/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef YOCTO_COMMON_DATA_H
#define YOCTO_COMMON_DATA_H

#include <memory>
#include <vendor-ril/telephony/ril.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <sys/prctl.h>
#include <cstdint>
#include <pthread.h>

#include "powerManager.h"
#include "rfdesense/RfDesenseTxTest.h"
#include "util/AtLine.h"
/*Warren add for t800 ril service 2021/12/15 start*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
/*Warren add for t800 ril service 2021/12/15 start*/


#define DEBUG 0
#define FUNCTION_CALLED(time,msg) printf("%s: %s %s called\n",(time), __func__ ,(msg));
#define FUNCTION_RETURN(time,msg) printf("%s: %s %s returns\n",(time), __func__ ,(msg));

#define EM_MODE_SUPPORT 1
#ifdef ATCI_PARSE
#define ATCI_ENABLE_RESPONSE 1
#endif
//#define ENABLE_BLOCK_FEATURE
#define BLOCK_MARK          0x10000000
#define RSP_DISP_TOKEN_MARK 0x01000000
#define ATCI_TOKEN_MARK     0x02000000
#define RIL_TOKEN_MARK      0x04000000
#define INIT_TOKEN_MARK     0x08000000
#define OTHER_TOKEN_MARK    0x20000000;
#define TOKEN_MODE 0x01000000
#define INIT 1
#define UDP  2
#define ATCI 3
#define RSPD 4
#define OTHER 5
//Warren add for plantform 2021_08_11 start
#define MAX_LEN 101
#define MAX_QUEST_LEN 12
//Warren add for plantform 2021_08_11 end
#define PROP_DEFAULT_DATA_SIM "persist.vendor.radio.data.sim"
#define PROP_DEFAULT_DATA_SIM_STATUS "vendor.radio.data.enable"
#define ATCI_SIM "persist.vendor.service.atci.sim"
//#define PROP_DATA_ALLOW_STATUS "vendor.ril.data.allow.status"
//Warren add for plantform 2021_08_11 start
/* 
**The range of error values unique to LYNQ is 8000 to 10000.
**The sim card state is error.
*/
typedef enum{
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001
}LYNQ_E;
/*Warren add for t800 RIL Service 2021/12/10 start*/

typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[1024*8];
}lynq_client_t;
/*Warren add for t800 RIL Service 2021/12/10 end*/


#define UNSET -1

typedef struct {
    int requestNumber;
    void (*dispatchFunction) (android::Parcel &p, struct RequestInfo *pRI);
    int(*responseFunction) (android::Parcel &p, void *response, size_t responselen);
} CommandInfo;

typedef struct RequestInfo {
    int32_t token;      //this is not RIL_Token
    /*Warren add for t800 ril service 2021/12/15 start*/
    int uToken;
    int lynqEvent;    // 1:This request comes from AT client
                      // 2:This request comes from lynq client
                      // 3:This request comes from factory client
    struct sockaddr_in uClient_addr;
    /*Warren add for t800 ril service 2021/12/15 end*/
    CommandInfo *pCI;
    struct RequestInfo *p_next;
    char cancelled;
    char local;         // responses to local commands do not go back to command process
    RIL_SOCKET_ID socket_id;
} RequestInfo;

/*Warren add for FAW 2021/11/1 start*/
extern int ttyGS3_fd;
/*Warren add for FAW 2021/11/1 end*/
/*Warren add for SZZT 2021/11/14 start*
** record data registration
*/
extern int current_data_reg;
extern int modemStatus;
extern int g_lynq_sim_state;
/*Warren add for SZZT 2021/11/14 end*/

// extern int lynq_output_LINFO_enable;
// void lynq_output_info(const char* format,...);
// void lynq_output_LINFO(const char* format,...);
//void lynq_output_LINFO_all();
    
typedef struct {
    char *name;           /* User printable name of the function. */
    int (*func)(int argc, char *argv[], RIL_SOCKET_ID socket_id, RequestInfo *pRI);       /* Function to call to do the job. */
    char *doc;            /* Documentation for this function.  */
    int request;
} COMMAND;

/**
 * @brief lei add for output imformation on elt(at port)
 * 
 * @param format 
 * @param ... 
 */
void lynq_output_info(const char* format,...);

void lynq_send_result_already(void);
int lynq_wait_result_comeback(int mtime);

void updateCardStatusV6(RIL_CardStatus_v6 *card_status,int slot);
char* getAid(int slot);

void update_reg_voice_service_state(int request, char* code, int slot, int32_t token);
void update_reg_voice_radio_tech(int request, int code, int slot, int32_t token);
void update_reg_data_service_state(int request, char* code, int slot, int32_t token);
void update_reg_data_radio_tech(int request, int code, int slot, int32_t token);
void update_preferred_network_type(int type, int slot);
void update_call_state(void *response, size_t responselen, int slot);

int is_call_state_idle(int slot);
int get_preferred_network_type(int slot);
int get_reg_data_radio_tech(int slot);
int get_reg_voice_radio_tech(int slot);
void update_voice_radio_tech(int code, int slot);
int get_voice_radio_tech(int slot);
void update_radio_capa(RIL_RadioCapability* cap, int slot);
RIL_RadioCapability get_radio_capa(int slot);
std::int32_t GenerateToken(int mode, int request);

void updateRadioStatus(int newValue,RIL_SOCKET_ID soc_id);
bool isRadioOn(RIL_SOCKET_ID soc_id);
bool isRadioAvailable(RIL_SOCKET_ID soc_id);

bool isDataConnectEnable(int slot);
void updataDataConnectState(int slot, bool state);
const char *radioStateToString(RIL_RadioState);
const char * rilSocketIdToString(RIL_SOCKET_ID socket_id);

#ifdef LED_SUPPORT
/*for led add by hq 20221202*/
bool ril_get_if_insert_simcard();
bool ril_get_if_3gpp_reg_success();
bool ril_get_if_3gpp_data_reg_success();
#endif

/*for urc broad cast optimission by hq 20221216*/
void lynq_exit();

#if EM_MODE_SUPPORT
typedef void (* netwokInfoNotify)(int type, char *data);
typedef void (*atCmdResponse)(char *response,int responselen);
extern RfDesenseTxTest* m_RfDesense;

void registerRadioOn(RfDesenseTxTest* rf);
void unregisterRadioOn();
void registerRadioOffOrNotAvailable(RfDesenseTxTest* rf);
void unregisterRadioOffOrNotAvailable();
void registerOnUnsolOemHookRaw(RfDesenseTxTest* rf);
void unregisterOnUnsolOemHookRaw();
void register_response_oem_hook_raw(RfDesenseTxTest* rf);
void unregister_response_oem_hook_raw();

bool isFinalResponseErrorEx(char* str);

void set_default_sim_all(int slot_id);
int get_default_sim_all();
void set_default_sim_voice(int slot_id);
int get_default_sim_voice();
void set_default_sim_data(int slot);
int get_default_sim_data_for_switch();
bool isNeedConnect();
void resetConnect();
int get_default_sim_data();
void set_default_sim_sms(int slot_id);
int get_default_sim_sms();
void set_default_sim_all_except_data(int slot_id);
int get_default_sim_all_except_data();
RequestInfo* creatRILInfoAndInit(int request, int mode, RIL_SOCKET_ID soc_id);
int get_atci_sim();
bool mtkItTest(const char* data);

void updateSystemTime(const void *data, int datalen);
void notifyDataSignal();
#endif
#ifdef ECALL_SUPPORT
void ConvertMsd(const char *msdChar, unsigned char *msd);
#endif /*ECALL_SUPPORT*/

#ifdef MOBILETEK_TARGET_PLATFORM_T106 
int is_exit_call_in_callist_and_all_call_not_active(int slot);
#endif
namespace android {
    void initRequestInfo(RequestInfo *pRI, int  request, int mode, RIL_SOCKET_ID soc_id);
    const char * requestToString(int request);
    const int RspDispFunction(int request,char* arg, RIL_SOCKET_ID socket_id);
    void requestSMSACKNOWLEDGE(RIL_SOCKET_ID soc_id);
    void requestAnswer(RIL_SOCKET_ID soc_id);
    void writeStringToParcel(Parcel &p, const char *s);
    void RIL_startEventLoop(void);
    void startATCILoop(void);
    void startGdbusLoop(void);
    void startPMLoop(void);
    void registerForATcmdResponse(atCmdResponse cb);
    void unregisterNetwork();
    void registerForNetworkInfo(netwokInfoNotify cb);
    void unregisterATcmd();
    int emResultNotify(const char *str);
    void ATCIRequest(int request, char* reqString, void* t,int argc, char**argv);
    void startWakupLoop(void);
    /*Warren add for FAW platform 2021/9/27 start*/
    void startUsbLoop(void);
    int sendRespToUsb(char *cmd);
    int sendUrcToUsb(char *cmd);
    int lynqSendToRil(int argc,char *argv[],int uToken);
    /*Warren add for FAW platform 2021/9/27 end*/
    /*Warren add for t800 RIL Service 2021/12/10 start*/
    int lynqSocketSendto(int fd,struct sockaddr *dest_addr,int addr_len,char msg[]);
/*Warren add for t800 RIL Service 2021/12/10 end*/
/*Warren add for t800 ril service 2021/12/23 start*/
    int lynqAssemblyParcelheader(Parcel &p,int slot,int utoken,int request,int respType,int error);
    int LYNQ_RIL_respSocket(Parcel &p,RIL_Token t);
    int LYNQ_RIL_respSocket_sp(Parcel &p,RequestInfo *pRI);
    int LYNQ_RIL_urcBroadcast(Parcel &p,int urc_id=0);
/*Warren add for t800 ril service 2021/12/23 end*/



}

#endif
