//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <string>
#include <algorithm>
using namespace std;

#include "HexDump.h"

const char HexDump::HEX_DIGITS[] = { '0', '1', '2', '3', '4', '5', '6', '7',
    '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
const char HexDump::HEX_LOWER_CASE_DIGITS[] = { '0', '1', '2', '3', '4', '5',
    '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
HexDump::HexDump() {
  // TODO Auto-generated constructor stub

}

HexDump::~HexDump() {
  // TODO Auto-generated destructor stub
}

std::string HexDump::dumpHexString(uint8_t* array, int length) {
  return dumpHexString(array, 0, length);
}
std::string HexDump::dumpHexString(uint8_t* array, uint32_t offset,
    int length) {
  string result;

  uint8_t line[16] = { 0 };
  int lineIndex = 0;

  result.append("\n0x");
  result.append(toHexString(offset));

  for (uint32_t i = offset; i < offset + length; i++) {
    if (lineIndex == 16) {
      result.append(" ");

      for (int j = 0; j < 16; j++) {
        if (line[j] > ' ' && line[j] < '~') {
          //(unsigned char)line[j]
          //result.append(string(line, j, 1));
          result.push_back(line[j]);
        } else {
          result.append(".");
        }
      }

      result.append("\n0x");
      result.append(toHexString(i));
      lineIndex = 0;
    }

    uint8_t b = array[i];
    result.append(" ");
    result.push_back(HEX_DIGITS[(b >> 4) & 0x0F]);
    result.push_back(HEX_DIGITS[b & 0x0F]);

    line[lineIndex++] = b;
  }

  if (lineIndex != 16) {
    int count = (16 - lineIndex) * 3;
    count++;
    for (int i = 0; i < count; i++) {
      result.append(" ");
    }

    for (int i = 0; i < lineIndex; i++) {
      if (line[i] > ' ' && line[i] < '~') {
        result.push_back(line[i]);
      } else {
        result.append(".");
      }
    }
  }
  return result;
}

std::string HexDump::toHexString(uint8_t b) {
  int length = 0;
  return toHexString(toByteArray(b, &length), length, true);
}

std::string HexDump::toHexString(uint8_t* array, int length, bool free) {
  return toHexString(array, 0, length, true, free);
}

std::string HexDump::toHexString(std::vector<uint8_t> v) {
  int length = v.size();
  uint8_t array[length] = {0};
  std::copy(v.begin(), v.end(), array);
  return toHexString(array, 0, length, true, false);
}

std::string HexDump::toHexString(uint8_t* array, int length, bool upperCase,
    bool free) {
  return toHexString(array, 0, length, upperCase);
}

std::string HexDump::toHexString(uint8_t* array, int offset, int length,
    bool free) {
  return toHexString(array, offset, length, true);
}

std::string HexDump::toHexString(uint8_t* array, int offset, int length,
    bool upperCase, bool free) {
  const char* digits = upperCase ? HEX_DIGITS : HEX_LOWER_CASE_DIGITS;
  char buf[length * 2];

  int bufIndex = 0;
  for (int i = offset; i < offset + length; i++) {
    uint8_t b = array[i];
    buf[bufIndex++] = digits[(b >> 4) & 0x0F];
    buf[bufIndex++] = digits[b & 0x0F];
  }
  string str(buf, (length * 2));
  if (free) {
    delete[] array;
  }
  return str;
}

std::string HexDump::toHexString(uint32_t i) {
  int length = 0;
  return toHexString(toByteArray(i, &length), length, true);
}

/**
 * @return need free.
 */
uint8_t* HexDump::toByteArray(uint8_t b, int* length) {
  uint8_t* array = new uint8_t[1];
  (*length) = 1;
  array[0] = b;
  return array;
}

/**
 * @return need free;
 */
uint8_t* HexDump::toByteArray(uint32_t i, int* length) {
  uint8_t* array = new uint8_t[4];
  (*length) = 4;
  array[3] = (uint8_t) (i & 0xFF);
  array[2] = (uint8_t) ((i >> 8) & 0xFF);
  array[1] = (uint8_t) ((i >> 16) & 0xFF);
  array[0] = (uint8_t) ((i >> 24) & 0xFF);

  return array;
}

uint32_t HexDump::toByte(char c) {
  if (c >= '0' && c <= '9') {
    return (c - '0');
  }
  if (c >= 'A' && c <= 'F') {
    return (c - 'A' + 10);
  }
  if (c >= 'a' && c <= 'f') {
    return (c - 'a' + 10);
  }
  return 0; //wrong
}

/**
 * @return need free
 */
uint8_t* HexDump::hexStringToByteArray(std::string hexString, int* length) {
  int len = hexString.length();
  uint8_t* buffer = new uint8_t[len / 2];

  for (int i = 0; i < len; i += 2) {
    buffer[i / 2] = (uint8_t) ((toByte(hexString[i]) << 4)
        | toByte(hexString[i + 1]));
  }
  (*length) = len;
  return buffer;
}
std::string HexDump::appendByteAsHex(std::string& sb, uint8_t b,
    bool upperCase) {
  const char* digits = upperCase ? HEX_DIGITS : HEX_LOWER_CASE_DIGITS;
  sb.push_back(digits[(b >> 4) & 0xf]);
  sb.push_back(digits[b & 0xf]);
  return sb;
}
