#!/bin/sh
#
# Run the daemon
#

DAEMON="lynq-sdk-ready-service"
PIDFILE="/var/run/$DAEMON.pid"
EXEC="/usr/bin/lynq-sdk-ready"
EXEC_ARGS=""


start() {
        echo -n "Starting $DAEMON... "
        start-stop-daemon --no-close -S -b -m -p $PIDFILE -x $EXEC -- $EXEC_ARGS
        [ $? -eq 0 ] && echo "OK" || echo "ERROR"
}

stop() {
        echo -n "Stopping $DAEMON... "
        start-stop-daemon -K -p $PIDFILE
        [ $? -eq 0 ] && echo "OK" || echo "ERROR"
}

restart() {
        stop
        start
}

case "$1" in
  start|stop|restart)
        "$1"
        ;;
  *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
esac

exit $?

