#include <stdio.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#include <errno.h>
#include "lynq_timer.h"
#include <include/lynq_uci.h>

#define LOG_TAG "LYNQ_SDK"
#define DEST_PORT 8088
#define DSET_IP_ADDRESS  "127.0.0.1"
#define RIL_REQUEST_DEVICE_IDENTITY 98
#define MAX_LEN 1024
#define TIMER 30


#define LOG_UCI_FILE "lynq_uci"
#define LOG_UCI_MODULE "debug_mode"

using ::android::Parcel;

static pthread_mutex_t g_lynq_sim_sendto_mutex;

typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[MAX_LEN];
}lynq_client_t;

int num = 0;

int max_num;
static int get_md_sta(void)
{
    FILE *fp;
    char buffer[64]={};
    fp = popen("cat /sys/kernel/ccci/boot","r");
    if(fp == NULL)
    {
        RLOGD("function %s fp is null\n", __FUNCTION__);
        return 0;
    }
    fgets(buffer,sizeof(buffer),fp);
    if(!strlen(buffer))
    {
        RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        pclose(fp);
        return 0;
    }
    if(buffer[4] == '4')
    {
        pclose(fp);
        return 1;
    }
    RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
    pclose(fp);
    return 0;
}

static int t800_check_service(const char *service)
{
    FILE *fp;
    char buffer[1024]={};
    if(!strcmp(service, "/usr/sbin/mtkfusionrild"))
    {
        fp = popen("ps -ef|grep rild","r");
    }
    else if(!strcmp(service, "lynq-ril-service"))
    {
        fp = popen("ps -ef|grep ril-service","r");
    }
    if(fp == NULL)
    {
        RLOGD("function %s fp is null\n", __FUNCTION__);
        return 0;
    }
    while(NULL != fgets(buffer,sizeof(buffer),fp))
    {
        if(strstr(buffer,service))
        {
            pclose(fp);
            RLOGD("check_service 1\n");
            return 1;
        }
    }
    RLOGD("check_service 0\n");
    pclose(fp);
    return 0;
}


static int t106_check_service(const char *service)
{
    FILE *fp;
    char buffer[1024]={};

    fp = popen("ps -ef|grep ril-service","r");
    if(fp == NULL)
    {
        ALOGD("ril-service fp is null\n");
        return -1;
    }
    while(NULL != fgets(buffer,sizeof(buffer),fp))
    {
        if(strstr(buffer,service))
        {
            pclose(fp);
            ALOGD("check_service right\n");
            return 1;
        }
    }
    ALOGD("check_service -1\n");
    pclose(fp);
    return 0;
}

/**
 * @brief 30s request imei
 * 
 * @param arg 
 * @return void* 
 */
void * timer_request_imei(void * arg)
{
    int sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if (-1 == sock_fd)
    {
        RLOGD("__FUNCTION__ %s create  sock_fd failed %s\n", __FUNCTION__, strerror(errno));
        /*set uci*/
        /*socket abnormal*/
        lynq_set_section("sdk_ready", "3");
        /*set uci*/
        return NULL;
    }
    struct sockaddr_in liblynq_data_socket;
    bzero(&liblynq_data_socket, sizeof(liblynq_data_socket));
    //set this lib socket config 
    liblynq_data_socket.sin_family = AF_INET;
    liblynq_data_socket.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);
    int ret = bind(sock_fd, (struct sockaddr *)&liblynq_data_socket, sizeof(liblynq_data_socket));
    if (-1 == ret)
    {
        RLOGE("liblynq_data_socket bind fail,errno:%d",errno);
        return NULL;
    }
    
    struct timeval timeOut;
    timeOut.tv_sec = 5;//timeout time 5s
    timeOut.tv_usec = 0;
    if (setsockopt(sock_fd, SOL_SOCKET, SO_RCVTIMEO, &timeOut, sizeof(timeOut)) < 0) 
    {
        RLOGE("__FUNCTION__ %s time out setting failed %s\n", __FUNCTION__, strerror(errno));
        /*set uci*/
        /*socket abnormal*/
        lynq_set_section("sdk_ready", "3");
        /*set uci*/
        return NULL;
    }
    struct sockaddr_in addr_serv;
    memset(&addr_serv, 0, sizeof(addr_serv));  
    addr_serv.sin_family = AF_INET;  
    addr_serv.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);  
    addr_serv.sin_port = htons(DEST_PORT);  
    int len_addr_serv = sizeof(addr_serv);
    int send_num = -1;
    int recv_num = -1;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int token = -1;
    int res_error = -1;
    lynq_client_t client_t;
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_DEVICE_IDENTITY;
    client_t.paramLen = 0;
    client_t.uToken = 999;
    memset(client_t.param, 0, sizeof(client_t.param));
    while (1)
    {
        bzero(res_data, MAX_LEN);
        pthread_mutex_lock(&g_lynq_sim_sendto_mutex);
        send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
        RLOGD("send_num %d\n", send_num);
        if(send_num == 0)  
        {
            RLOGE("__FUNCTION__ %s Close to end %s\n", __FUNCTION__, strerror(errno));
            //unknow
            lynq_set_section("sdk_ready", "4");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        if(send_num < 0)  
        {  
            RLOGE("__FUNCTION__ %s sendto error %s\n", __FUNCTION__, strerror(errno));
            //unknow
            lynq_set_section("sdk_ready", "4");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        //get data msg
        recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&
len_addr_serv);
        RLOGD("recv_num %d\n", recv_num);
        if(recv_num == 0)
        {
            RLOGE("__FUNCTION__ %s Close to end\n", __FUNCTION__);
            //unknow
            lynq_set_section("sdk_ready", "4");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        if(recv_num == -1 && errno == EAGAIN)
        {
            /*set uci*/
#ifdef MOBILETEK_TARGET_PLATFORM_T800
            if(!get_md_sta())
            {
                system("uci set lynq_uci.sdk_ready='1'");
            }
            else
            {
                if(t800_check_service("/usr/sbin/mtkfusionrild"))//rild work
                {
                    if(!t800_check_service("lynq-ril-service"))//not find,must be socket error
                    {
                        system("uci set lynq_uci.sdk_ready='3'");
                    }
                    else
                    {
                        //unknow error
                        system("uci set lynq_uci.sdk_ready='4'");
                    }
                    
                }
                else//rild no work
                {
                    //unknow
                    system("uci set lynq_uci.sdk_ready='4'");
                }
            }
#endif

#ifdef MOBILETEK_TARGET_PLATFORM_T106
            if(!t106_check_service("lynq-ril-service"))//not find,must be socket error
            {
                RLOGE("lynq-ril-service no exist\n");
                lynq_set_section("sdk_ready", "4");
            }
            else
            {
                RLOGE("__FUNCTION__ %s recvfrom fail because timeout\n", __FUNCTION__);
                lynq_set_section("sdk_ready", "3");
            }
#endif
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        if(recv_num < 0)
        {
            RLOGE("__FUNCTION__ %s sendto error %s\n", __FUNCTION__, strerror(errno));
            lynq_set_section("sdk_ready", "4");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        Parcel p;
        p.setData((uint8_t *)res_data,sizeof(char)*recv_num);
        p.setDataPosition(0);
        if(p.dataAvail() > 0)
        {
            p.readInt32(&resp_type);
            p.readInt32(&token);
            p.readInt32(&request);
            p.readInt32(&slot_id);
            p.readInt32(&res_error);
        }
        /*judge the res_error*/
        if(!res_error)
        {
            lynq_set_section("sdk_ready", "0");
            RLOGE("sdk_ready = 0\n");
        }
        else
        {
            //Md configurations are inconsistent with AP configurations
            RLOGE("__FUNCTION__ %s res_error %d\n", __FUNCTION__, res_error);
            lynq_set_section("sdk_ready", "2");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        /*judge the res_error*/
        pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
        sleep(TIMER);
    }
    return NULL;
}



void delete_enter(char data[])
{
    char *find = strchr(data, '\n');
    if(find)
        *find = '\0';
    return ;
}


void *check(void * arg)
{

    char pid[200][8];
    char ffd[200][4];
    char buf[128];
    char check_time[4];
    char timebuf[32];
    int num = 1;
    int i=0;
    int j;
    FILE *fp,*fp_1;
    int ret;

    ALOGD("check cpu/pid/interrupts/fd!!!\n");
    system("mkdir /var/log/check_file");
    system("touch /var/log/check_time");
    fp_1 = popen("cat /var/log/check_time","r");
    if(fgets(check_time, 4, fp_1) != NULL)
    {
        num = atoi(check_time);
    }
    pclose(fp_1);
    while(1)
    {
        ALOGD("start check");
        i = 0;
        sleep(300);

        system("date >>/var/log/check_file/cpu_moniter.txt");
        ret = system("top -b |head -n 25 >>/var/log/check_file/cpu_moniter.txt");
        ALOGD("cpu ret %d", ret);
        usleep(600000);
        system("date >>/var/log/check_file/inter_moniter.txt");
        ret = system("cat /proc/interrupts |grep -v \":          0          0\" >>/var/log/check_file/inter_moniter.txt");
        ALOGD("interrupts ret %d", ret);
        usleep(600000);
        system("date >>/var/log/check_file/pid_moniter.txt");
        ret = system("ps -e \"%p %a\" | grep -v \"\\[\" >>/var/log/check_file/pid_moniter.txt");
        ALOGD("pid ret %d", ret);
        usleep(600000);
        system("date >>/var/log/check_file/meminfo_moniter.txt");
        ret = system("cat /proc/meminfo >>/var/log/check_file/meminfo_moniter.txt");
        ALOGD("meminfo ret %d", ret);
        usleep(600000);
        system("date >>/var/log/check_file/buddyinfo_moniter.txt");
        ret = system("cat /proc/buddyinfo >>/var/log/check_file/buddyinfo_moniter.txt");
        ALOGD("buddyinfo ret %d", ret);
#ifdef MOBILETEK_TARGET_PLATFORM_T800
        system("date >>/var/log/check_file/ps_auxw_moniter.txt");
        ret = system("ps -auxw|grep -v \"0.0  0.0\"|grep -v \"0.1  0.0\"|grep -v \"0.0  0.1\" >>/var/log/check_file/ps_auxw_moniter.txt");
        ALOGD("ps_auxw ret %d", ret);
#endif
        usleep(600000);
        system("date >>/var/log/check_file/cur_freq_moniter.txt");
        ret = system("cat /sys/devices/system/cpu/cpufreq/policy0/scaling_cur_freq >>/var/log/check_file/cur_freq_moniter.txt");
        ALOGD("cur_freq ret %d", ret);
        usleep(600000);
        system("date >>/var/log/check_file/available_frequencies_moniter.txt");
        ret = system("cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_frequencies >>/var/log/check_file/available_frequencies_moniter.txt");
        ALOGD("available_frequencies ret %d", ret);

        system("date >>/var/log/check_file/fd_moniter.txt");
        fp = popen("ps -e \"%p %a\" | grep -v \"\\[\"|awk '{print $1}'","r");
        while(fgets(pid[i], 8, fp) != NULL)
        {
            ALOGD("pid[%d]:%s", i, pid[i]);
            delete_enter(pid[i]);
            i++;
        }
        pclose(fp);

        for(j=1;j<i;j++)
        {
            usleep(300000);
            sprintf(buf, "ls /proc/%s/fd | wc -l", pid[j]);
            fp = popen(buf, "r");
            fgets(ffd[j], 4, fp);
            sprintf(buf,"echo \"pid: %s, fd_num: %s\" >>/var/log/check_file/fd_moniter.txt",pid[j], ffd[j]);
            ALOGD("%s",buf);
            system(buf);
            pclose(fp);
        }

        if(num > max_num)
        {
            system("cp /var/log/check_file/cpu_moniter.txt /var/log/check_file/cpu_moniter_1.txt");
            system("cp /var/log/check_file/inter_moniter.txt /var/log/check_file/inter_moniter_1.txt");
            system("cp /var/log/check_file/pid_moniter.txt /var/log/check_file/pid_moniter_1.txt");
            system("cp /var/log/check_file/fd_moniter.txt /var/log/check_file/fd_moniter_1.txt");
            system("cp /var/log/check_file/meminfo_moniter.txt /var/log/check_file/meminfo_moniter_1.txt");
            system("cp /var/log/check_file/buddyinfo_moniter.txt /var/log/check_file/buddyinfo_moniter_1.txt");
#ifdef MOBILETEK_TARGET_PLATFORM_T800
            system("cp /var/log/check_file/ps_auxw_moniter.txt /var/log/check_file/ps_auxw_moniter_1.txt");
#endif
            system("cp /var/log/check_file/cur_freq_moniter.txt /var/log/check_file/cur_freq_moniter_1.txt");
            system("cp /var/log/check_file/available_frequencies_moniter.txt /var/log/check_file/available_frequencies_moniter_1.txt");


            system("rm -rf /var/log/check_file/cpu_moniter.txt");
            system("rm -rf /var/log/check_file/inter_moniter.txt");
            system("rm -rf /var/log/check_file/pid_moniter.txt");
            system("rm -rf /var/log/check_file/fd_moniter.txt");
            system("rm -rf /var/log/check_file/meminfo_moniter.txt");
            system("rm -rf /var/log/check_file/buddyinfo_moniter.txt");
#ifdef MOBILETEK_TARGET_PLATFORM_T800
            system("rm -rf /var/log/check_file/ps_auxw_moniter.txt");
#endif
            system("rm -rf /var/log/check_file/cur_freq_moniter.txt");
            system("rm -rf /var/log/check_file/available_frequencies_moniter.txt");

            num = 0;
        }
        num++;
        sprintf(timebuf, "echo \"%d\" >/var/log/check_time", num);
        ret = system(timebuf);
    }
    return NULL;

}


void *t800_check_uci(void * arg)
{
    int ret[6];
    int result = 0;
    int flag = 0;

    char uci_0[]="/etc/config/lynq_uci";
    char uci_1[]="/etc/config/lynq_uci_ro";
    char uci_2[]="/etc/config/mdlog";
    char uci_3[]="/etc/config/radio_property";
    char uci_4[]="/etc/config/service";
    char uci_5[]="/etc/config/usb";
    RLOGD("start check uci\n");
    while(num++ < 4)
    {
        RLOGD("@@@@@@@num=%d\n", num);
        flag = 0;
        ret[0] = system("uci show | grep \"lynq_uci.lynq_ril\" > /dev/null");
        if(ret[0] != 0)
        {
            RLOGD("lynq_uci unload\n");
            flag = 1;
        }

        ret[1] = system("uci show | grep \"^lynq_uci_ro\.\" > /dev/null");
        if(ret[1] != 0)
        {
            RLOGD("lynq_uci_ro unload\n");
            flag = 1;
        }

        ret[2] = system("uci show | grep \"^mdlog\.\"");
        if(ret[2] != 0)
        {
            RLOGD("mdlog unload\n");
            flag = 1;
        }

        ret[3] = system("uci show | grep \"^radio_property\.\" > /dev/null");
        if(ret[3] != 0)
        {
            RLOGD("radio_property unload\n");
            flag = 1;
        }

        ret[4] = system("uci show | grep \"^service\.\" > /dev/null");
        if(ret[4] != 0)
        {
            RLOGD("service unload\n");
            flag = 1;
        }

        ret[5] = system("uci show | grep \"^usb\.\" > /dev/null");
        if(ret[5] != 0)
        {
            RLOGD("usb unload\n");
            flag = 1;
        }

        RLOGD("flag=%d\n",flag);
        if(flag != 0)
        {
            RLOGD("config reload\n");
            result = chdir("/data_backup/");
            result =system("tar -zxvf userdata.tar.gz -C /STATE/ >/dev/null");
            if(result!= 0)
            {
                RLOGD("cp config fail\n");
            }
            if(ret[0] != 0)
            {
                lynq_load_config(uci_0);
                RLOGD("reload lynq_uci\n");
                system("systemctl start autosuspend");
            }
            if(ret[1] != 0)
            {
                lynq_load_config(uci_1);
                RLOGD("reload lynq_uci_ro\n");
            }
            if(ret[2] != 0)
            {
                lynq_load_config(uci_2);
                RLOGD("reload mdlog\n");
            }
            if(ret[3] != 0)
            {
                lynq_load_config(uci_3);
                RLOGD("reload radio_property\n");
                system("systemctl restart mtkfusionrild");
            }
            if(ret[4] != 0)
            {
                lynq_load_config(uci_4);
                RLOGD("reload service\n");
            }
            if(ret[5] != 0)
            {
                lynq_load_config(uci_5);
                RLOGD("reload usb\n");
            }
        }
        else
        {
            RLOGD("uci check success, exit check!\n");
            break;
        }
        sleep(2);
    }
    return NULL;
}


void *t106_check_uci(void * arg)
{
    int ret[6];
    int result = 0;
    int flag = 0;

    char uci_0[]="/etc/config/lynq_uci";
    char uci_1[]="/etc/config/lynq_uci_ro";

    ALOGD("start check uci\n");
    while(num++ < 4)
    {
        ALOGD("@@@@@@@num=%d\n", num);
        flag = 0;
        ret[0] = system("uci show | grep \"lynq_uci.lynq_ril\"");
        if(ret[0] != 0)
        {
            ALOGD("lynq_uci unload\n");
            flag = 1;
        }

        ret[1] = system("uci show | grep \"^lynq_uci_ro\.\"");
        if(ret[1] != 0)
        {
            ALOGD("lynq_uci_ro unload\n");
            flag = 1;
        }

        ALOGD("flag=%d\n",flag);
        if(flag != 0)
        {
            ALOGD("config reload\n");
            result =system("cp -R /etc/config/ /mnt/userdata/");
            if(result!= 0)
            {
                ALOGD("cp config fail\n");
            }
            if(ret[0] != 0)
            {
                ALOGD("config reload\n");
                result =system("cp -R /etc/config/lynq_uci /mnt/userdata/config/");
                if(result!= 0)
                {
                    ALOGD("cp config fail\n");
                }
                lynq_load_config(uci_0);
                ALOGD("reload lynq_uci\n");
                system("./etc/init.d/lynq-autosuspend.sh restart");
            }
            if(ret[1] != 0)
            {
                ALOGD("config reload\n");
		result =system("ln -s /etc/config/lynq_uci_ro /mnt/userdata/config/");
                if(result!= 0)
                {
                    ALOGD("cp config fail\n");
                }
                lynq_load_config(uci_1);
                ALOGD("reload lynq_uci_ro\n");
            }
        }
        else
        {
            ALOGD("uci check success, exit check!\n");
            break;
        }
        sleep(2);
    }
    return NULL;
}



void start_timer_request(void)
{
    pthread_t thid,thid_1,thid_2;
    pthread_attr_t a;
    pthread_attr_init(&a);
    pthread_attr_setdetachstate(&a, PTHREAD_CREATE_DETACHED);

    char tmp[20];
    int debug_mode;
    int ret;

    ALOGD("start lynq-sdk-ready\n");
/*
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    ret = pthread_create(&thid_2,NULL,t106_check_uci,NULL);
#endif

#ifdef MOBILETEK_TARGET_PLATFORM_T800
    ret = pthread_create(&thid_2,NULL,t800_check_uci,NULL);
#endif
    if(ret != 0){
        ALOGD("pthread_create error!!!");
        return;
    }
    pthread_detach(thid_2);
*/
    ret = pthread_create(&thid, &a, timer_request_imei, NULL);
    if(ret != 0){
        ALOGD("pthread_create error!!!");
        return;
    }

    ret = lynq_get_value(LOG_UCI_FILE, LOG_UCI_MODULE, "check_file_size", tmp);
    ALOGD("ret =%d, tmp is %s\n", ret, tmp);
    max_num=atoi(tmp);
    ALOGD("max_num is %d!!!\n", max_num);

    ret = lynq_get_value(LOG_UCI_FILE, LOG_UCI_MODULE, "sysinfo_debug_status", tmp);
    ALOGD("ret =%d, tmp is %s\n", ret, tmp);
    debug_mode=atoi(tmp);
    ALOGD("debug_mode is %d!!!\n", debug_mode);
    if((debug_mode == 1) &&(max_num > 0))
    {
        ALOGD("debug_mode is 1, pthread_create start!!!\n");
        ret = pthread_create(&thid_1, NULL, check, NULL);
        if(ret != 0)
        {
            ALOGD("pthread_create error!!!");
            return;
        }

    }

    return;
}

