#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <error.h>
#include <string.h>
#include <netinet/in.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/if_ether.h>
#include <netpacket/packet.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <errno.h>
#include <liblog/lynq_deflog.h>
#include "include/libat/lynq_at_factory.h"

#define FACTORY_STRING "AT+LYNQFACTORY="
#define USER_LOG_TAG "AT_FACTORY"
DEFINE_LYNQ_LIB_LOG(LYNQ_AT_FACTORY)


#undef LOG_TAG
#define LOG_TAG "AT_FACTORY"

lynq_atsvc_outcb handle_output;

typedef struct
{
    char *cmd;
    void (*func)(char *input);
}Command;

enum
{
    Response = 0,
    Urc
};

void lynq_response_ok()
{
    char *str = "OK\r\n";
    handle_output(str, strlen(str), Response);
}

void lynq_response_error(int error_code)
{
    char str[32] = {0};
    sprintf(str, "+CME ERROR: %d\r\n", error_code);
    handle_output(str, strlen(str), Response);
}

void lynq_handle_adc(char *input)
{
    FILE *fp;
    char lynq_adc_dev[126] = {0};
    char lynq_adc_buf[32] = {0};
    int lynq_adc_num = atoi(input+4);
    char flag[64] = {0};

    #ifdef MOBILETEK_TARGET_PLATFORM_T106
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/kernel/debug/pmu_zx29/adc1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/kernel/debug/pmu_zx29/adc2");
    }
    
    #else
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    #endif

    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);
    sprintf(flag,"%s %s\r\n", "+ADC:", lynq_adc_buf);
    if(handle_output != NULL)
    {
        handle_output(flag, strlen(flag), Response);
    }
    lynq_response_ok();
    pclose(fp);
}

void lynq_handle_emmc(char *input)
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};

    #ifdef MOBILETEK_TARGET_PLATFORM_T106
    sprintf(emmc_buf, "ls /dev | grep mmcblk1  2>&1");
    #else
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    #endif

    fp=popen(emmc_buf, "r");
    if(!fp){
        lynq_response_error(100);
        return;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        lynq_response_ok();
        pclose(fp);
        return;
    }
    lynq_response_error(100);
    pclose(fp);
}


/******gpio API******/
/*sc_gpio_init(gpio, direction, value, pullsel);
  sc_gpio_direction_set(test_gpio_handle[gpio], direction, 0);
  sc_gpio_value_set(test_gpio_handle[gpio], value);
  sc_gpio_value_get(test_gpio_handle[gpio], &value);
    gpio : gpio (0--143)
    direction : 0 - input 1 - output 
    value : when gpio output, set the default output value,if no use, set it to 0
    pull_sel : 0 - bias disable 1 - pull down 2 - pull up
    test_gpio_handle[gpio]:gpio handle get by init
*/
void lynq_handle_gpioset(char *input)
{
/*1.gpio_num 0-135
  2.direction_set //0 - in; 1 - out
  3.value_set  
  4.pullsel_set // 0 - bias disable; 1 - pull down; 2 - pull up
*/
    input = input + strlen("gpioset");
    int gpio_configure[4];
    int k = 0;
    for (int i = 0; i < strlen(input) ; i++)
    {
        int num = 0;
        for (; input[i] != ',' && input[i] != '\0'; i++)
        {
            if (input[i] >= '0' && input[i] <= '9')
            {
                num = num * 10 + (input[i] - '0');
            }
            else
            {
                handle_output("+GPIOSET:input error\r\n", strlen("+GPIOSET:input error\r\n"), Response);
                lynq_response_error(100);
                return;
            }
        }
        if(k >= 4)
        {
            handle_output("+GPIOSET:Too many parameters\r\n", strlen("+GPIOSET:Too many parameters\r\n"), Response);
            lynq_response_error(100);
            return;
        }
        gpio_configure[k] = num;
        k++;
    }

    int gpio = gpio_configure[0];
    if(gpio < 0 || gpio > 135)
    {
        lynq_response_error(1);
        return;
    }
    int direction_set = gpio_configure[1];
    if(direction_set != 0 && direction_set != 1)
    {
        lynq_response_error(2);
        return;
    }
    int value_set = gpio_configure[2];
    if(value_set != 0 && value_set != 1)
    {
        lynq_response_error(3);
        return;
    }
    int pullsel_set = gpio_configure[3];
    if(pullsel_set != 0 && pullsel_set != 1 && pullsel_set != 2)
    {
        lynq_response_error(4);
        return;
    }

    int ret;
    test_gpio_handle[gpio] = sc_gpio_init(gpio, direction_set, value_set, pullsel_set);
    if(test_gpio_handle[gpio] == NULL)
    {
        ALOGE("init%d fail\n",gpio);
        lynq_response_error(100);
        return;
    }
    ret = sc_gpio_uninit(test_gpio_handle[gpio]);
    if(ret)
    {
        ALOGE("uninit%d fail\n",gpio);
        lynq_response_error(100);
        return;
    }
    test_gpio_handle[gpio] = NULL;
    lynq_response_ok();
    return;
}

int lynq_gpio_analysis(char *input,int *lynq_gpio_arr,int lynq_gpio_total_arr[],int total_length)
{
    int j = 0;
    int k = 0;
    int size = 0;
    char res[64] = {0};
    int greep = input[0] - '0';
    ALOGD(res,"the greep:%d\n",greep);//The first digit represents grouping

    for (int i = 1; i < strlen(input); i++)
    {
        int num = 0;
        for (; input[i] != ',' && input[i] != '\0'; i++)
        {
            if (input[i] >= '0' && input[i] <= '9')
            {
                num = num * 10 + (input[i] - '0');
            }
            else
            {
                handle_output("+GPIO:input error\r\n", strlen("input error\r\n"), Response);
                return -1;
            }
        }
        for (k = 0; k < total_length && num != 0;k++)
        {
            if(num == lynq_gpio_total_arr[k])
            {
                lynq_gpio_arr[size] = num;
                size++;
                break;
            }
        }
        if(k >= total_length)
        {
            bzero(res,64);
            sprintf(res,"+GPIO:GPIO%d input error\r\n",num);
            handle_output(res, strlen(res), Response);
        }
    }
    if (lynq_gpio_arr == NULL)
    {
        handle_output("+GPIO:input all gpio not exist\r\n", strlen("input all gpio not exist\r\n"), Response);
        return -1;
    }
    return size;
}

#ifdef MOBILETEK_TARGET_PLATFORM_T106
#define GPIO_FILE "/data/factory/gpio_T106.conf"
int load_gpio(int *lynq_gpio_total_arr)
{
    FILE *fp;
    char StrLine[512];
    char StrGpio[512];
    char platform[10] = {0};
    char total[10] = {0};
    int count = 0;
    if((fp = fopen(GPIO_FILE, "r")) == NULL)
    {
        ALOGE("open %s error!\n", GPIO_FILE);
        return -1;
    }
    while (!feof(fp))
    {
        memset(StrLine, 0, 512);
        fgets(StrLine, 512, fp);
        if(strstr(StrLine, "platform:") != NULL)
        {
            strcpy(platform, strstr(StrLine, "platform:") + sizeof("platform:") - 1);
            if(!strcmp(platform,"T106"))
            {
                ALOGD("platform:error\n");
                return -1;
            }
            ALOGD("platform:%s\n",platform);
        }
        
        else if(strstr(StrLine, "total:") != NULL)
        {
            strcpy(total, strstr(StrLine, "total:") + sizeof("total:") - 1);
            ALOGD("total:%s\n",total);
        }
        
        else if((strstr(StrLine, "gpio:") != NULL))
        {
            strcpy(StrGpio, strstr(StrLine, "gpio:") + sizeof("gpio:") - 1);
            for(int i=0; StrGpio[i] != '\0'; i++)
            {
                int num = 0;
                for (; StrGpio[i] != ',' && StrGpio[i] != '\0' && StrGpio[i] != '\n'; i++)
                {
                    num = num * 10 + (StrGpio[i] - '0');
                }
                lynq_gpio_total_arr[count] = num;
                count++;
            }
            break;

        }
    }
    fclose(fp);
    return count;
}

/*GPIO 50 is Used for comparison*/
static int set_all_gpio_status_and_check(int lynq_gpio_arr[], int status, int total_length)
{
    int ret;
    int value;

    
    for(int m = 0; m < total_length; m++)
    {
        if(test_gpio_handle[lynq_gpio_arr[m]] != NULL)
        {
            ret = sc_gpio_uninit(test_gpio_handle[lynq_gpio_arr[m]]);
            if(ret)
            {
                ALOGE("uninit%d fail\n",lynq_gpio_arr[m]);
                return -1;
            }
        }
        test_gpio_handle[lynq_gpio_arr[m]] = sc_gpio_init(lynq_gpio_arr[m], 1, status, 0);
        if(test_gpio_handle[lynq_gpio_arr[m]] == NULL)
        {
            ALOGE("init%d fail\n",lynq_gpio_arr[m]);
            return -1;
        }
    }
    ret = sc_gpio_value_get(test_gpio_handle[50], &value);
    if(ret)
    {
        ALOGE("RET = %d, value = %d\n",ret,value);
        return -1;
    }
    if(value != status)
    {
        return 1;
    }
    return 0;
}

int all_gpio_uninit(int total_length, int lynq_gpio_total_arr[256])
{
    int ret;
    if(test_gpio_handle[50] != NULL)
    {
        ret = sc_gpio_uninit(test_gpio_handle[50]);
        if(ret)
        {
            ALOGE("uninit 50 fail\n");
            return -1;
        }
        test_gpio_handle[50] = NULL;
    }
    
    for(int m = 0; m < total_length; m++)
    {
        ret = sc_gpio_uninit(test_gpio_handle[lynq_gpio_total_arr[m]]);
        if(ret)
        {
            return -1;
            ALOGE("uninit%d fail\n",lynq_gpio_total_arr[m]);
        }
        test_gpio_handle[lynq_gpio_total_arr[m]] = NULL;
    }
    return 0;
}

void lynq_handle_gpio(char *input)
{
    int lynq_gpio_total_arr[256];
    int lynq_gpio_arr[256];
    char lynq_show_gpio_state[64] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_high = 0;
    int total_length = 0;
    int valid_length = 0;
    int value;
    int ret;
    int lynq_gpio_test_env_error = 1;
    int i = 0,m = 0,j = 0;
    int need_int = 1;
    int lynq_gpio_beta_state = 1;

    if((total_length = load_gpio(lynq_gpio_total_arr)) < 0)
    {
        ALOGE("Don't have this platform gpio configure\n");
        return;
    }
    test_gpio_handle[50] = sc_gpio_init(50, 0, 0, 0);
    ALOGE("50 youm:%p\n",test_gpio_handle[50]);
    if(test_gpio_handle[50] == NULL)
    {
        ALOGE("uninit 50 fail\n");
    }
    ALOGD("start function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    input = input + strlen("gpio");
    if((valid_length = lynq_gpio_analysis(input, lynq_gpio_arr, lynq_gpio_total_arr, total_length)) < 0)
    {
        lynq_response_error(100);
        all_gpio_uninit(total_length, lynq_gpio_total_arr);
        return;
    }
    ALOGE("The Valid count:%d\n",valid_length);
    for(i=0; i < valid_length; i++)
    {
        for(j=0;j<3;j++)
        {
            if  (j > 0) // reset gpio when retry
            {
                need_int = 1;
            }

            if (need_int == 1)
            {
                ret = set_all_gpio_status_and_check(lynq_gpio_arr, 0, valid_length);
                if (ret == 1)
                {
                    ALOGE("can't pull up or pull down gpio-50\n");
                    continue;
                }
                else if(ret == 0)
                {
                    ALOGE("all gpio can pull up or pull dpwn\n");
                    need_int = 0;
                }
                else if(ret == -1)
                {
                    ALOGE("gpio init or uninit fail\n");
                    lynq_response_error(100);
                    all_gpio_uninit(total_length, lynq_gpio_total_arr);
                    return;
                }
                ALOGD("finsh configure function\n");  
            }

            lynq_gpio_low = 0;
            lynq_gpio_high = 0;

            for(int n=0;n<3;n++)
            {
                ret = sc_gpio_value_set(test_gpio_handle[lynq_gpio_arr[i]], 1);
                usleep(10000);
                ret = sc_gpio_value_get(test_gpio_handle[50], &value);
                if(ret)
                {
                    ALOGE("sc_gpio_value_get\n");
                }
                if(value == 1)
                {
                    ALOGE("high function is OK,input %d\n",lynq_gpio_arr[i]);
                    lynq_gpio_high = 1;
                    lynq_gpio_test_env_error = 0;
                    break;
                }
                else
                {
                    ALOGE("high function is Fail, input %d\n",lynq_gpio_arr[i]);
                    if(i == 0 && j == 0)
                    {
                        lynq_gpio_test_env_error = set_all_gpio_status_and_check(lynq_gpio_arr, 1, valid_length) == 0 ? 0 : 1;
                    }
                }
            }
            if (lynq_gpio_test_env_error == 1)
                break;
            ret = sc_gpio_value_set(test_gpio_handle[lynq_gpio_arr[i]], 0);
            if(ret)
                {
                    ALOGE("sc_gpio_value_set gpio%d fail\n",lynq_gpio_arr[i]);
                }
                usleep(10000);
            ret = sc_gpio_value_get(test_gpio_handle[50], &value);
            if(ret)
                {
                    ALOGE("sc_gpio_value_get fail\n");
                }
            if(value == 0)
            {
                ALOGE("low function is OK,input %d\n",lynq_gpio_arr[i]);
                lynq_gpio_low = 1;
            }
            else
            {
                ALOGE("low function is fail,input %d\n",lynq_gpio_arr[i]);
            }
            bzero(lynq_show_gpio_state, 64);
            if((lynq_gpio_low != 1) || (lynq_gpio_high != 1))
            {
                ALOGE("total fail function,input %d\n",lynq_gpio_arr[i]);
            }
            else
            {
                ALOGE("success function,input:%d\n",lynq_gpio_arr[i]);
                sprintf(lynq_show_gpio_state,"+GPIO:%d\r\n",lynq_gpio_arr[i]);
                handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
                break; // do not retry when pass
            }
        } // for(j=0;j<3;j++)
        if (lynq_gpio_test_env_error == 1)
        {
            lynq_gpio_beta_state = 0;
            break;
        }
        if (j >= 3 )
        {
            lynq_gpio_beta_state = 0;
            sprintf(lynq_show_gpio_state,"+GPIO:%d FAIL\r\n",lynq_gpio_arr[i]);
            handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
        }
    } // for(i=0; i < sizeof(lynq_gpio_arr)/sizeof(lynq_gpio_arr[0]); i++)

    if(lynq_gpio_test_env_error == 1)
    {
        ALOGE("tool error\n");
        handle_output("+GPIO:tool error\r\n", strlen("+GPIO:tool error\r\n"), Response);
    }

    if(lynq_gpio_beta_state == 1)
    {
        ALOGD("total success function\n");
        lynq_response_ok();
    }
    else
    {
        ALOGE("total fail function\n");
        lynq_response_error(100);
    }
    ret = all_gpio_uninit(total_length, lynq_gpio_total_arr);
    if(ret)
    {
        ALOGD("all_gpio_uninit fail\n");
        lynq_response_error(100);
        return;
    }
}

int receive_data(int fd,char *buf_send,char *buf_recv, int send_len, int count)
{
    ssize_t ret;
    char *buf_cmp = NULL;
    int corrent_cont = 0;
    char reason_buf[32] = {0};

    /*To prevent packet loss,Setting 50 opportunities*/
    for(int cont = 0; cont < 50; cont++)
    {
        bzero(reason_buf,sizeof(reason_buf));
        bzero(buf_recv, sizeof(buf_recv));
        ret = recv(fd,buf_recv,1472,0);
        if(ret<0)
        {
            sprintf(reason_buf,"%d:recv_fail\n",count);
            ALOGD(reason_buf, strlen(reason_buf), Response);
            return -1;
        }

        else if (ret < send_len)
        {
            continue;
        }
        // Analyzing Ethernet frame headers
        struct ethhdr *eth_header = (struct ethhdr *)buf_recv;
        ALOGD("Source MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", eth_header->h_source[0], eth_header->h_source[1], eth_header->h_source[2], eth_header->h_source[3], eth_header->h_source[4], eth_header->h_source[5]);
        ALOGD("Destination MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", eth_header->h_dest[0], eth_header->h_dest[1], eth_header->h_dest[2], eth_header->h_dest[3], eth_header->h_dest[4], eth_header->h_dest[5]);
        ALOGD("Ethernet Type: %04X\n", ntohs(eth_header->h_proto));
        // Analyzing IP headers
        struct iphdr *ip_header = (struct iphdr *)(buf_recv + sizeof(struct ethhdr));
        ALOGD("Source IP: %s\n", inet_ntoa(*(struct in_addr *)&ip_header->saddr));
        ALOGD("Destination IP: %s\n", inet_ntoa(*(struct in_addr *)&ip_header->daddr));
        ALOGD("Protocol: %d\n", ip_header->protocol);
        // Analyzing UDP headers
        struct udphdr *udp_header = (struct udphdr *)(buf_recv + sizeof(struct iphdr) + sizeof(struct ethhdr));
        ALOGD("Source Port: %d\n", ntohs(udp_header->source));
        ALOGD("Destination Port: %d\n", ntohs(udp_header->dest));
        ALOGD("UDP Length: %d\n", ntohs(udp_header->len));
        // Compare data
        buf_cmp = buf_recv + sizeof(struct ethhdr) + sizeof(struct iphdr) + sizeof(struct udphdr);
        if(memcmp(buf_send, buf_cmp, send_len))
        {
            ALOGD("rec data fail and retry!!\n");
            continue;
        }
        // raw_socket will received data twice
        else
        {
            corrent_cont++;
            ALOGD("rec data success and again!!\n");
            if(corrent_cont == 2)
            {
                ALOGD("cammpare OK!!\n");
                return 0;
            }
            continue;
        }
        
    }
    handle_output("+RMII:can't receive correct data\r\n", strlen("+RMII:can't receive correct data\r\n"), Response);
    return -1;
}

int rgmii_init()
{
    char lynq_set_rgmii_arr[128] = {0};

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"echo 1,0x03,0x8800,0xc834 > /sys/devices/platform/soc/1307000.gmac/mdio_test");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("+RMII:Please checkout network_line\r\n", strlen("+RMII:Please checkout network_line\r\n"), Response);
        return -1;
    }
    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"echo 1,0x01,0x0,0xa000 > /sys/devices/platform/soc/1307000.gmac/mdio_test");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("+RMII:Please checkout network_line\r\n", strlen("+RMII:Please checkout network_line\r\n"), Response);
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ethtool -s eth0 speed 100 duplex full autoneg off");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 192.168.22.1");
    system(lynq_set_rgmii_arr);

    
    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ip n replace 192.168.22.2 lladdr ec:1d:7f:b0:2f:32 dev eth0");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth0 promisc");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 128);
    sprintf(lynq_set_rgmii_arr,"brctl delif br0 eth0");
    system(lynq_set_rgmii_arr);

    return 0;
}

int rgmii_socket_init(struct sockaddr_in* server_addr, const char * ip_addr)
{
    int ser_socket = -1;
    struct timeval timeout={1,0};
    int ret;
    server_addr->sin_family=AF_INET;
    server_addr->sin_port = htons(100);
    server_addr->sin_addr.s_addr = inet_addr(ip_addr);

    ser_socket = socket(AF_INET,SOCK_DGRAM,0);
    
    if (ser_socket<0)
    {
        return -1;
    }

    ret = setsockopt(ser_socket, SOL_SOCKET, SO_RCVTIMEO, &timeout, sizeof(struct timeval));
    if(ret < 0)
    {
        printf("set socket timeout init_failed\n");
        return -1;
    }
    ret = bind(ser_socket,(struct sockaddr*)server_addr,sizeof(*server_addr));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    return ser_socket;
}

void lynq_handle_rgmii()
{
    int ret;
    int check_count = 0;
    int check_ok_count = 0;
    int socketfd = -1;
    int raw_socket = -1;
    char buf_init[1024];
    char buf_recv[1472];
    struct sockaddr_in ser_addr;
    struct sockaddr_in cli_addr;
    struct sockaddr_ll raw_addr;
    struct timeval raw_timeout={2,0};
    struct ifreq ser;
    time_t start,end;
    bzero(buf_init,sizeof(buf_init));
    bzero(buf_recv,sizeof(buf_recv));
    
    const char *ser_ip = "192.168.22.1";
    const char *cli_ip = "192.168.22.2";

    int count = 0;
    ret = rgmii_init();
    if(ret<0)
    {
        lynq_response_error(1);
        return;
    }
    cli_addr.sin_family=AF_INET;
    cli_addr.sin_port = htons(100);
    cli_addr.sin_addr.s_addr = inet_addr(cli_ip);

    socketfd = rgmii_socket_init(&ser_addr,ser_ip);
    if(socketfd < 0)
    {
        ALOGE("init_failed\n");
        lynq_response_error(2);
        return;
    }
    //Use raw_socket receive data at the link layer
    raw_socket = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if(raw_socket < 0)
    {
        ALOGE("raw_socket init_failed\n");
        lynq_response_error(2);
        return;
    }
    memset(&raw_addr, 0, sizeof(raw_addr));
    raw_addr.sll_family=AF_PACKET;
    raw_addr.sll_protocol = htons(ETH_P_ALL);
    raw_addr.sll_ifindex = if_nametoindex("eth0");

    ret = setsockopt(raw_socket, SOL_SOCKET, SO_RCVTIMEO, &raw_timeout, sizeof(struct timeval));
    if(ret < 0)
    {
        printf("set raw_socket timeout init_failed\n");
        lynq_response_error(3);
        return -1;
    }

    ret = bind(raw_socket, (struct sockaddr*)&raw_addr, sizeof(raw_addr));//bind network interface card
    if(ret < 0)
    {
        ALOGE("bind raw_socket init_failed\n");
        lynq_response_error(3);
        return;
    }

    for(int j =0;j<4;j++)
    {
        for(int i =0;i<255;i++)
        {
            count += sprintf(buf_init + count,"%c",i);
            if (count >= 1024)
            {
                buf_init[1023] = '\0';
                break;
            }
        }
        
        if (count >= 1024)
        {
            break;
        }
    }

    start = time(NULL);
    for(int i=0;i<128;i++)
    {
        check_count++;
        end = time(NULL);
        if(difftime(end,start)>20)
        {
            break;
        }
        ret = sendto(socketfd,buf_init,sizeof(buf_init),0,(struct sockaddr*)&cli_addr,sizeof(cli_addr));
        if(ret < 0 )
        {
            continue;
        }
        ret = receive_data(raw_socket,buf_init,buf_recv, sizeof(buf_init),check_count);
        if(ret < 0)
        {
            continue;
        }

        check_ok_count ++;
    }
    //  Received correctly 120 times
    if(check_ok_count >= 120)
    {
        ALOGD("rgmii OK!!\n");
        lynq_response_ok();
    }
    else
    {
        ALOGE("sent %d, success %d\r\n", check_count, check_ok_count);
        lynq_response_error(100);
    }

    close(socketfd);
    close(raw_socket);
    return;
}
#endif

void lynq_handle_sdio(char *input)
{
    lynq_response_error(100);
}
void lynq_handle_pcm(char *input)
{
    lynq_response_error(100);
}
static Command commands[] = 
{
    {"adc",lynq_handle_adc},
    {"emmc",lynq_handle_emmc},
    {"gpioset",lynq_handle_gpioset},
    {"gpio",lynq_handle_gpio},
    {"rmii",lynq_handle_rgmii},
    {"sdio",lynq_handle_sdio},
    {"pcm",lynq_handle_pcm},
    {NULL, NULL}
};

Command* find_command(char *input)
{
    ALOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    int i;
    int ret = -1;
    for (i = 0; commands[i].cmd; i++)
    {
        ret = strncmp(input, commands[i].cmd, strlen(commands[i].cmd));
        if(ret == 0)
        {
            ALOGD("function %s line %d find input %s commands[i].cmd %s  strlen %d ret %d\n", __FUNCTION__, __LINE__, input, commands[i].cmd, strlen(commands[i].cmd), ret);
            return (&commands[i]);
        }
    }
    ALOGD("function %s line %d not find ret %d \n", __FUNCTION__, __LINE__, ret);
    return ((Command *)NULL);
}

void lynq_at_factory_cb(char *input, int input_max_size)
{
    if(handle_output != NULL)
    {
        ALOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        if(input != NULL)
        {
            char *handle_string = input + strlen(FACTORY_STRING);
            if(!strlen(handle_string))
            {
                ALOGD("function %s line %d strlen %d\n", __FUNCTION__, __LINE__, strlen(handle_string));
                return;
            }
            ALOGD("function %s line %d  handle_string %s\n", __FUNCTION__, __LINE__, handle_string);
            Command *cmd = find_command(handle_string);
            if(cmd != NULL)
            {
                ALOGD("function %s line %d\n", __FUNCTION__, __LINE__);
                (*(cmd->func))(handle_string);
                return;
            }
        }
    }
}

lynq_atsvc_incb lynq_register_at_factory(lynq_atsvc_outcb out_cb)
{
    if(out_cb != NULL)
    {
        handle_output = out_cb;
        ALOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        return lynq_at_factory_cb;
    }
}


