#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sc_irq.h>

#include "lynq-irq.h"
#include "liblog/lynq_deflog.h"

#ifdef __cplusplus
extern "C" {
#endif


/*****************************************
* @brief:lynq_irq_install
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/

int lynq_irq_install(int line, irq_handler irq_test_handler, int trig_type)
{
    int ret;
    if(trig_type < 0)
    {
        return -1;
    }
    ret = sc_irq_install(line, irq_test_handler, trig_type);
    if (ret != 0)
    {
        LYINFLOG("do_install_irq failed, ret:%d\n", ret);
        return ret;
    }
    return 0;
}


/*****************************************
* @brief:lynq_irq_uninstall
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/

int lynq_irq_uninstall(int line)
{
    int ret;
    ret = sc_irq_uninstall(line);
    if (ret != 0)
    {
        LYINFLOG("unistall failed, ret:%d\n", ret);
        return ret;
    }
    LYINFLOG("uninstall irq(%d) ok\n", line);
    return 0;
}


/*****************************************
* @brief:lynq_irq_set_type
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_irq_set_type(int line, int trig_type)
{
    int ret;
    if(trig_type < 0)
    {
        return -1;
    }
    ret = sc_irq_set_type(line, trig_type);
    if (ret != 0)
    {
        LYINFLOG("set_type failed, ret:%d\n", ret);
        return ret;
    }
    return 0;

}

/*****************************************
* @brief:lynq_irq_get_type
* @param count [IN]:1
* @param sum [OUT]:NA
* @return :success >= 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_irq_get_type(int line)
{
    int ret;
    int trig_type;
    ret = sc_irq_get_type(line, &trig_type);
    if (ret != 0)
    {
        LYINFLOG("get_type failed, ret:%d\n", ret);
        return ret;
    }
    LYINFLOG("get_type readback(%d)\n", trig_type);
    return trig_type;
}


/*****************************************
* @brief:lynq_irq_set_wake
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_irq_set_wake(int line, int en)
{
    int ret;
    if((en != 0) && (en != 1))
    {
        LYINFLOG("wake_state is not 0 or 1\n");
        return -1;
    }
    ret = sc_irq_set_wake(line, en);
    if (ret != 0)
    {
        LYINFLOG("set_wake failed, ret:%d\n", ret);
        return ret;
    }
    return 0;
}

/*****************************************
* @brief:lynq_irq_get_wake
* @param count [IN]:1
* @param sum [OUT]:NA
* @return :success >= 0, failed other
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_irq_get_wake(int line)
{
    int ret;
    int en;
    ret = sc_irq_get_wake(line, &en);
    if (ret != 0)
    {
        LYINFLOG("get_wake failed, ret:%d\n", ret);
        return ret;
    }
    LYINFLOG("get_wake readback(%d)\n", en);
    return en;
}


DEFINE_LYNQ_LIB_LOG(LYNQ_IRQ)

#ifdef __cplusplus
}
#endif



