﻿#ifndef LYNQ_MONITOR_H
#define LYNQ_MONITOR_H

#ifdef __cplusplus
extern "C" {
#endif
/**
 * @brief 定义监控异常通知的回调函数类型。
 * 该回调函数用于当监控到特定类型的异常时，通知调用者，并提供异常的详细信息。
 *
 * @param exception_type 异常类型，指示发生的异常的类别。
 * @param error_code 错误码，用于指示具体异常的错误代码。
 * @param operation_code 操作码，指示对于该异常应当采取的操作。具体的操作类型由调用者根据错误码和操作码决定。
 */
typedef void (*MonitorExceptionHandler)(int exception_type, int error_code, int opt_code);

/**
 * @brief 初始化监控模块
 *
 * @param config_path 配置文件路径
 * @return 初始化结果，成功返回0，失败返回非0
 */
int lynq_monitor_init(const char* config_path);

/**
 * @brief 注册异常通知回调函数
 *
 * @param handler 回调函数指针
 * @return 注册结果，成功返回0，失败返回非0
 */
int lynq_monitor_register_exception_handler(MonitorExceptionHandler handler);

/**
 * @brief 设置总的监控开关，准备休眠时，FOTA时建议关闭监测和异常状态处理
 *
 * @param state 状态，取值为0则不监控，取值为1则开始监控
 * @return 设置结果，成功返回0，失败返回非0
 */
int lynq_monitor_set_all_state(int state);

/**
 * @brief 设置各个类型的监控开关
 *@param monitor_type 0表示network,1表示data,2表示device,4表示ping
 * @param enabled 1表示开启，0表示关闭
 * @return 设置结果，成功返回0，失败返回非0
 */
int lynq_monitor_set_monitor_state(int monitor_type,int enabled);

#ifdef __cplusplus
}
#endif
#endif // LYNQ_MONITOR_H
