﻿#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <string.h>
#include <log/log.h>
#include "lynq_monitor_api.h"
#include "lynq_uci.h"
#include "lynq_monitor_internal.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "LYNQ_MONITOR"
#define LOG_UCI_FILE "lynq_uci"

int lynq_network_monitor_init(void)
{
    int pid = 0;
    int ret = 0;
    pid = getpid();
    
    ret = lynq_sim_init(pid);
    if(ret != 0)
    {
        LYERRLOG("lynq_sim_init fail. \n");
        return ret;
    }
    ret = lynq_network_init(pid);
    if(ret != 0)
    {
        LYERRLOG("lynq_network_init fail. \n");
        return ret;
    }
    return ret;
}
int lynq_monitor_is_network_registered(void)
{
    int regState = 0;
    int imsRegState = 0;
    char LAC[128] = "";
    char CID[128] = "";
    int netType = 0;
    int radioTechFam = 0;
    int errorCode = -1;
    LYINFLOG("lynq_monitor_is_network_registered start.\n");
    if(lynq_query_registration_state("DATA",&regState,&imsRegState,LAC,CID,&netType,&radioTechFam,&errorCode) != 0)
    {
        LYERRLOG("lynq_query_registration_state fail. \n");
        return 1;
    }
    if(regState == 0 || regState == 2 || regState == 3 || regState == 4)
    {
        LYERRLOG("regState: %d is not OK yet, try again. \n",regState);
        return 0;
    }
    else
    {
        LYERRLOG("regState: %d is OK.\n",regState);
    }
    return 1;

}

int lynq_monitor_is_device_runtime_state_ok(void)
{
    int ret = 0;
    int sdk_ready;
    char buf[4] = "";
    FILE* pipe = popen("uci get lynq_uci.sdk_ready", "r");
    if (pipe == NULL)
    {
        LYERRLOG("get sdk_ready fail\n");
        return ret;
    }
    if (fgets(buf, sizeof(buf), pipe) == NULL)
    {
        LYERRLOG("get sdk_ready fail\n");
        pclose(pipe); 
        return ret;
    }
    pclose(pipe);
    sdk_ready=atoi(buf);
    if(sdk_ready == 0)
    {
        ret = 1;
    }
    return ret;
}

int lynq_monitor_is_data_connected(void)
{
    int ret = 0;
    int apn_status = 0;
    char buf[4] = "";
    ret = lynq_get_value(LOG_UCI_FILE, "lynq_apn", "apn_status", buf);
    apn_status=atoi(buf);
    if(apn_status == 1)
    {
        ret = 1;
    }

    return ret;
}


int lynq_monitor_reset_flight_mode(void)
{
    int ret;
    LYINFLOG("lynq_monitor_reset_flight_mode start\n");
    ret = lynq_radio_on(NETWORK_RADIO_ON_TYPE_CFUN_0);
    sleep(1);
    ret = lynq_radio_on(NETWORK_RADIO_ON_TYPE_NORMAL_MODE);
    return ret;
}

int lynq_monitor_reset_sim(void)
{
    int ret;
    LYINFLOG("lynq_monitor_reset_sim start\n");
    ret = lynq_reset_sim();
    return ret;
}

int lynq_monitor_get_lock_state(char* wake_name) // 1-持锁，0-未持锁
{
    char buf[128];
    int lock_held = 0;
    int ret;
    LYINFLOG("lynq_monitor_get_lock_state start\n");
    if(wake_name == NULL)
    {
        return 0;
    }
    snprintf(buf, sizeof(buf), "grep -q '%s' /sys/power/wake_lock && echo 1 || echo 0", wake_name);
    FILE* pipe = popen(buf, "r");
    if (pipe) 
    {
        char result[4];
        ret = fgets(result, 2, pipe);
        if (strcmp(result, "1\n") == 0) 
        {
            lock_held = 1;
        }
        pclose(pipe);
    } 
    else 
    {
        fprintf(stderr, "Error: Failed to run command\n");
    }
    LYINFLOG("lynq_monitor_get_lock_state end\n");
    return lock_held;
}

void lynq_monitor_sleep(unsigned int seconds)
{
    sleep(seconds);
}