#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdint.h>
#include <stdlib.h>
#include <errno.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <pthread.h>
#include <termios.h>
#include <time.h>
#include <sys/ioctl.h>
#include <dirent.h>
#include <sys/stat.h>
#include <malloc.h>
#include <sys/time.h>
#include <liblog/lynq_deflog.h>
#include <include/lynq_uci.h>
#include "mbtk_gnss_internal.h"
#include "mbtk_http.h"
#include "mbtk_type.h"
#include "ringbuffer.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifndef MIN
#define MIN(A,B) ((A)<(B)?(A):(B))
#endif
#define _XOPEN_SOURCE
#define NMEA_RMC "RMC"
#define NEMA_LOG_FILE "/mnt/userdata/gnss.conf"
#define NMEA_LOG_MAX_SIZE  MIN(48*1024*1024,(gnsslog_file_size<1024*1024?1024*1024:gnsslog_file_size))
#define NMEA_LOG_MAX_FILE_NUM  MIN(12,(gnsslog_file_num<1?1:gnsslog_file_num))
extern long timezone;
extern int g_gnss_sync_enable_flag;
extern int g_gnss_sync_done;
extern int event;
extern int device_fd;

typedef int (*sc_rtc_time_get_cb)(unsigned int src_id, unsigned long ulsec);
extern int sc_rtc_timer_init(void);
extern int sc_rtc_timer_uninit(void);
extern int sc_rtc_time_set(int srcid);
extern int sc_cfg_get(char *name, char* buf, int bufLen);
extern int sc_cfg_set (char *name, char *value);

static inline int update_system_time(time_t timestamp)
{
    struct timeval tv;
    int ret = gettimeofday(&tv, NULL);
    int srcid = -1;
    if (ret == -1) {
        perror("gettimeofday");
        return -1;
    }
    if (tv.tv_sec == timestamp)
    {
        return 0;
    }
    printf("Now: %ld\n", tv.tv_sec);
    tv.tv_sec = timestamp;
    tv.tv_usec = 0;
    ret = settimeofday(&tv, NULL);
    if (ret == -1) {
        perror("settimeofday");
        return -1;
    }
    //set system time to rtc.
    if ((srcid = sc_rtc_timer_init()) <= 0)
    {
        ALOGE("%s %d error: sc_rtc_timer_init fail!\n", __func__, __LINE__);
        return -1;
    }
    ret = sc_rtc_time_set(srcid);
    if (ret != 0)
    {
        ALOGE("%s %d error: sc_rtc_time_set fail!\n", __func__, __LINE__);
        return -1;
    }
    ret = sc_rtc_timer_uninit();
    if (0 != ret)
    {
        LYERRLOG("uninit failed \n");
        ALOGE("%s %d error: dc_rtc_timer_uninit fail!\n", __func__, __LINE__);
        return -1;
    }
    return ret;
}

const char *enableMask[]=
    {
        "GPS L1",
        "GLONASS G1",
        "BEIDOU B1",
        "",
        "GALILEO E1",
        "QZSS L1",
        "SBAS L1",
        "IRNSS L5",
        "GPS L1C",
        "GPS L5",
        "GPS L2C",
        "",
        "",
        "GLONASS G2",
        "BEIDOU B1C",
        "BEIDOU B2A",
        "BEIDOU B3I",
        "BEIDOU B5",
        "BEIDOU B2",
        "",
        "GALILEO E5A",
        "GALILEO E5B",
        "GALILEO E6",
        "",
        "QZSS L6",
        "QZSS L1C",
        "QZSS L5",
        "QZSS L2C"
    };

void navsat(char *data,char *result)
{
    int nav_info = *((int*)(data+6));
    for (int i = 0; i < 28; i++)
    {
        if ((nav_info & (1 << i)) != 0)
        {
            if (strlen(result) > 0)
            {
                strcat(result, "+");
            }
            strcat(result, enableMask[i]);
        }
    }   
}


#if TTFF_TEST
struct mbtk_gnss_ttff_t
{
    int type;
    int timeout_sec;
    int test_count;
    int average_loc_time;
};
// ttff 测试 flag
static int location_test = 0;
static pthread_mutex_t loc_cond_mutex_r = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t loc_sync_cond = PTHREAD_COND_INITIALIZER;
#endif

const char *config_flags[] =
{  
    "debug.dbg2file",       //NMEA_LOG_FLAG,
    "debug.filename",       //NMEA_LOG_NAME_FLAG,
    "debug.filesize",       //NMEA_LOG_SIZE_FLAG,
    "debug.filenum",        //NMEA_LOG_NUM_FLAG,
    "debug.frequency"       //NMEA_OUTPUT_FREQ
};
#define NUM_CONFIG_FLAGS (sizeof(config_flags) / sizeof(config_flags[0]))
int global_fd = 0;
char log_real_name[128];
char tmp_file_name[128];
int gnsslog_file_size = 15*1024*1024;   //Max dbg log file size read from config file
int gnsslog_file_num = 5;  //Max dbg log num read from config file
int gnss_frq = 1;
volatile int nmea_state = 0;
volatile int nmea_reading = 0;
volatile int gnsslog_state = 0;
static int firmware_extren_state = 0;
static void *test_gpio_handle[MAX_GPIO_NUM]={NULL};
static struct mopen_gnss_device_info_t mopen_gnss_device_info;
static struct mbtk_gnss_handle_t *mbtk_gnss_handle = NULL;


/**
 *  \brief strstr_n
 *
 *  find string return number
 *
 *  \param param
 *  \return return type
 */
int strstr_n(const char *s1, const char *s2)
{
    int n;
    int strlen = 0;

    if(*s2)
    {
        while(*s1)
        {
            for(n = 0; *(s1+n) == *(s2 + n); n++)
            {
                if(!*(s2 + n + 1))
                {
                    strlen++;
                    return strlen;
                }
            }
            s1++;
            strlen++;
        }
        return 0;
    }
    else
        return 0;
}

/**
 * @brief      gnss_get_para_from_nmea
 *
 * @details    从buf里面得到第num个逗号所在的位置
 *
 * @param      param
 *
 * @return     0~0xfe,代表逗号所在位置的偏移.
 *             0xff,代表不存在第cx个逗号
 */
static int gnss_get_para_from_nmea(const char *data, char *out_data, int num)
{
    int i = 0;
    int n[2] = {0};
    int tmp;

    // 找到第num个","，结果放到 n[0]
    for (i = 0; i < num; ++i) {
        tmp = strstr_n(&data[n[0]], ",");
        if(0 == tmp) {
            gnss_log("%s %d : error\n", __func__, __LINE__);
            ALOGE("error: [%d] %s\n", num, data);
            return -1;
        }
        n[0] += tmp;
    }
    if ((n[1] = strstr_n(&data[n[0]], ",")) ||
            (n[1] = strstr_n(&data[n[0]], "*")) &&
            (n[1] > 1)) {
        memcpy(out_data, &data[n[0]], n[1] - 1);
    } else {
        gnss_log("%s %d : error [%d]\n" , __func__, __LINE__, n[1]);
        ALOGE("error: [%d] %s\n", num, data);
        return -1;
    }

    return 0;
}
/**
* @brief      get_timestamp
*
* @details    
*
* @param      param
*
* @return     return type
*/
static time_t get_timestamp(char *time)
{
    char tmp_char[4] = {0};
    struct tm* tmp_time = (struct tm*)malloc(sizeof(struct tm));

    memset(tmp_time, 0, sizeof(struct tm));
    memset(tmp_char, 0, sizeof(tmp_char));
    memcpy(tmp_char, &time[4], 2);
    tmp_time->tm_sec = atoi(tmp_char);
    memcpy(tmp_char, &time[2], 2);
    tmp_time->tm_min = atoi(tmp_char);
    memcpy(tmp_char, &time[0], 2);
    tmp_time->tm_hour = atoi(tmp_char);
    memcpy(tmp_char, &time[6], 2);
    tmp_time->tm_mday = atoi(tmp_char);
    memcpy(tmp_char, &time[8], 2);
    tmp_time->tm_mon = atoi(tmp_char) - 1;
    memcpy(tmp_char, &time[10], 2);
    tmp_time->tm_year = 100 + atoi(tmp_char);

    time_t _t = mktime(tmp_time);//按当地时区解析tmp_time
    //gnss_log("timestamp: %ld\n",_t);
    tzset();
    _t = _t - timezone;
    //gnss_log("timestamp: %ld\n",_t);

    free(tmp_time);
    return _t;
}
/**
 * @brief      get_gnss_device_info
 *
 * @details    获取设备信息
 *
 * @param      type: 5-从$PDTINFO获取
 *                   6-从$CFGNMEA获取
 *
 * @return     return type
 */
static void get_gnss_device_info(int type, char *str, void *usr_ptr)
{
    char tmp_str[32] = {0};
    int i, ret;

    if(5 == type) // define  mbtk_gnss_cmd_msg_map
    {
        // $PDTINFO get product info
        char *tmp_ptr[6] = {mopen_gnss_device_info.product_name,
                            mopen_gnss_device_info.dev_config,
                            mopen_gnss_device_info.hw_ver,
                            mopen_gnss_device_info.fw_ver,
                            mopen_gnss_device_info.pn,
                            mopen_gnss_device_info.sn
                           };
        for (i = 0; i < 6; ++i) {
            memset(tmp_str, 0, sizeof(tmp_str));
            // get product name
            ret = gnss_get_para_from_nmea(str, tmp_str, i + 1);
            if(ret)
                continue;
            memcpy(tmp_ptr[i], tmp_str, strlen(tmp_str));
        }
        gnss_log("*************************\n");
        gnss_log("-Pn: %s\n dc: %s\n hv: %s\n fw: %s\n pn: %s\n sn: %s\n ",
                 mopen_gnss_device_info.product_name,
                 mopen_gnss_device_info.dev_config,
                 mopen_gnss_device_info.hw_ver,
                 mopen_gnss_device_info.fw_ver,
                 mopen_gnss_device_info.pn,
                 mopen_gnss_device_info.sn);
    }
    if(6 == type) // define  mbtk_gnss_cmd_msg_map
    {
        // $CFGNMEA get nmea version
        memset(tmp_str, 0, sizeof(tmp_str));
        ret = gnss_get_para_from_nmea(str, tmp_str, 1);
        if(ret)
            return;
        memcpy(mopen_gnss_device_info.nmea_ver, tmp_str, strlen(tmp_str));
        mopen_gnss_device_info.device_info_valid = TRUE;
    }
}

static short int from_hex(char a)
{
    if (a >= 'A' && a <= 'F')
        return a - 'A' + 10;
    else if (a >= 'a' && a <= 'f')
        return a - 'a' + 10;
    else
        return a - '0';
}

static int str_to_hex(char *str)
{
    unsigned char str_len = strlen(str);
    int i;
    int ret = 0;

    for (i = 0; i < str_len; ++i) {
        ret = ret * 16 + from_hex(str[i]);
    }
    return ret;
}

int lynq_gnss_output_frq(int frequency)
{
    char save_configuration[] = {0xF1,0xD9,0x06,0x09,0x08,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x26,0x37};
    char one_frequency[] = {0xF1,0xD9,0x06,0x42,0x14,0x00,0x00,0x01,0x62,0x00,0xE8,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xDA};
    char two_frequency[] = {0xF1,0xD9,0x06,0x42,0x14,0x00,0x00,0x02,0x62,0x00,0xF4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB5,0x8F};
    char five_frequency[] = {0xF1,0xD9,0x06,0x42,0x14,0x00,0x00,0x05,0x62,0x00,0xC8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8B,0xF9};
    int ret;
    int buf_length;
    char *send_buf = NULL;
    int fd = open(MBTK_GNSS_DEV, O_RDWR | O_NOCTTY | O_NDELAY);
    if(fd < 0) {
        ALOGE("open error\n");
        return -1;
    }
    switch(frequency)
    {
        case 1:
        {
            send_buf = one_frequency;
            buf_length = sizeof(one_frequency);
            break;
        }
        case 2:
        {
            send_buf = two_frequency;
            buf_length = sizeof(two_frequency);
            break;
        }
        case 5:
        {
            send_buf = five_frequency;
            buf_length = sizeof(five_frequency);
            break;
        }
        default:
        {
            close(fd);
            return -2;
        }
    }
    ret = write(fd, send_buf, buf_length);
    if(ret < 0)
    {
        ALOGE("modify cmd send faild\n");
        close(fd);
        return -1;
    }
    ret = write(fd, save_configuration, sizeof(save_configuration));
    if(ret < 0)
    {
        ALOGE("save configuration send faild\n");
        close(fd);
        return -1;
    }
    usleep(100000);
    close(fd);
    return 0;
}

int lynq_gnss_configure_init()
{
    FILE *file;
    char buffer[128];
    char *configure_pointers[NUM_CONFIG_FLAGS] = {NULL};
    
    file = fopen(NEMA_LOG_FILE, "r");
    if(file == NULL)
    {
        ALOGD("dont't need configure\n");
        return -1;
    }
    while(fgets(buffer, 128, file) != NULL)
    {
        size_t len = strlen(buffer);
        if(len > 0 && buffer[len-1] == '\n')
        {
            buffer[len-1] = '\0';
        }
        for(int i = 0; i < NUM_CONFIG_FLAGS; i++)
        {
            if(strncmp(buffer, config_flags[i], strlen(config_flags[i])) == 0)
            {
                if(configure_pointers[i] == NULL)
                {
                    configure_pointers[i] = strdup(buffer); // 复制到相应位置  
                }
                break; // 找到匹配后可以退出循环  
            }
        }
    }
    fclose(file);

    if(configure_pointers[0] != NULL)
    {
        gnsslog_state = atoi(configure_pointers[0] + strlen(config_flags[0]) + 1);
        printf("gnsslog_state = %d\n", gnsslog_state);
        if(gnsslog_state == 1)
        {
            //lynq_gnss_log_handle(1);
            if(configure_pointers[1] != NULL)
            {
                strcpy(log_real_name, configure_pointers[1] + strlen(config_flags[1]) + 1);
                sprintf(log_real_name,"%s_gpslog", log_real_name);
                printf("log_real_name = %s\n", log_real_name);
                
            }
            else
            {
                sprintf(log_real_name,"/var/log/gpslog");
                printf("log_real_name = %s\n", log_real_name);
            }
        }
    //     else if(gnsslog_state == 0)
    //     {
    //         lynq_gnss_log_handle(0);
    //     }
    //     else
    //         ALOGE("LOG CONFIGURE ERROR\n");
    }
    // else
    //     lynq_gnss_log_handle(0);
    
    if(configure_pointers[2] != NULL)
    {
        char *token; // 用于分割字符串  
        const char delimiter[] = "*"; // 分隔符为 
        char *tmp_token = strdup(configure_pointers[2] + strlen(config_flags[2]) + 1);
        int result = 1;
        token = strtok(tmp_token, delimiter);
        while (token != NULL)
        {  
            result *= atoi(token);
            token = strtok(NULL, delimiter);
        }
        gnsslog_file_size = result;
        printf("log_file_size = %d\n", gnsslog_file_size);
    }
    
    if(configure_pointers[3] != NULL)
    {
        printf("%s\n", configure_pointers[3] + strlen(config_flags[3]) + 1);
        gnsslog_file_num = atoi(configure_pointers[3] + strlen(config_flags[3]) + 1);
        printf("log_file_num = %d\n", gnsslog_file_num);
    }
    if(configure_pointers[4] != NULL)
    {
        int ret;
        gnss_frq = atoi(configure_pointers[4] + strlen(config_flags[4]) + 1);
        ALOGD("gnss_frq = %d\n", gnss_frq);
        ret = lynq_gnss_output_frq(gnss_frq);
        {
            if(ret < 0)
            {
                ALOGE("set gnss frq error\n");
            }
        }
    }

    for(int j = 0; j < NUM_CONFIG_FLAGS; j++)
    {  
        if(configure_pointers[j] != NULL)
        {  
            free(configure_pointers[j]); // 释放使用 strdup 分配的内存  
        }  
    }
    
    return 0;
}
typedef struct
{
    char* name;
    time_t ctime;
} FileInfo;

int cmpfunc(const void *a, const void *b)
{
    FileInfo *fileA = (FileInfo *)a;
    FileInfo *fileB = (FileInfo *)b;

    return difftime(fileA->ctime, fileB->ctime);
}
int lynq_gnss_log_file_open()
{
    DIR *dir;
    time_t now;
    int file_count = 0;
    FileInfo files[24];
    struct dirent *ent;
    char time_info[32];
    
    char *dir_path = strdup(log_real_name);
    char *file_name = strrchr(dir_path, '/');
    *file_name = '\0';
    file_name++;
    time(&now);
    dir = opendir(dir_path);
    while(dir != NULL && (ent = readdir(dir)) != NULL)
    {
        if(strstr(ent->d_name, "gpslog") != NULL)
        {
            files[file_count].name = strdup(ent->d_name);
            struct stat st;
            char tmp_file1[128];
            snprintf(tmp_file1, sizeof(tmp_file1), "%s/%s", dir_path, ent->d_name);
            stat(tmp_file1, &st);
            files[file_count].ctime = st.st_ctime;
            file_count++;
            if(file_count >= 24)
            {
                ALOGE("the file count is exceed maximum value\n");
                break;
            }
        }//如果文件有超过gnsslog_file_num的文件怎么办
    }

    if(file_count >= gnsslog_file_num)
    {
        int i = file_count - gnsslog_file_num + 1;
        qsort(files, file_count, sizeof(FileInfo), cmpfunc);
        for(int j = 0; j < i; j++)
        {
            char tmp_file[128];
            snprintf(tmp_file, sizeof(tmp_file), "%s/%s", dir_path, files[j].name);
            remove(tmp_file);
            free(files[j].name);
            files[j].name == NULL;
        }
    }
    closedir(dir);

    strftime(time_info, 32, "%Y%m%d%H%M%S", localtime(&now));
    sprintf(tmp_file_name,"%s/%s_%s.log", dir_path, file_name, time_info);
    global_fd = open(tmp_file_name, O_RDWR | O_APPEND |O_CREAT, 0666);
    if (global_fd == -1)
    {
        ALOGE("Failed to open file\n");
        printf("Failed to open file\n");
        return -1;
    }
    return 0;
}

int write_gnss_log(char *buffer, int len)//写log实现 就用write
{
    // global_fd = open(tmp_file_name, O_WRONLY | O_APPEND);
    // if (global_fd == -1)
    // {
    //     ALOGE("Failed to open file\n");
    //     return -1;
    // }

    write(global_fd, buffer, len);
    return 0;
}

static void get_gnss_agnss_state(int cmd, char *str, void *data)
{

    int ret;
    char tmp_str[10] = {0};
    int agps;
    static int count = 0;

    ret = gnss_get_para_from_nmea(str, tmp_str, 2);
    if(ret) {
        printf("\n%s[%d] error!\n" , __FUNCTION__, __LINE__);
    }
    agps = str_to_hex(tmp_str);
    gnss_log("\n%s[%d] agnss: %s[%x]\n" , __FUNCTION__, __LINE__, tmp_str, agps);
    if(0 == agps && count < 5) {
        lynq_gnss_get_aidinfo((uint32)mbtk_gnss_handle);
        count++;
    } else {
        printf("\nagnss: %s\n", str);
        count = 0;
    }
}
// 1节=1海里/小时=1.852公里/小时
/**
 * @brief      function description
 *
 * @details    获取位置信息
 *
 * @param      type: 1-从$RMC获取
 *                   2-从$GGA获取
 * @return     return type
 */
static void get_gnss_loc_info(int type, char *str,
                              struct mopen_location_info_t *_mopen_location_info)

{
    char tmp_str[32] = {0};
    int ret;

    if(1 == type)
    {
        // $xxRMC get product info
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 7);
        if(ret)
            return;
        _mopen_location_info->speed = atof(tmp_str);
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 8);
        if(ret)
            return;
        _mopen_location_info->bearing = atof(tmp_str);
    }
    else if(2 == type)
    {
        // $XXGGA get product info
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 2);
        if(ret)
            return;
        _mopen_location_info->latitude = atof(tmp_str);
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 4);
        if(ret)
            return;
        _mopen_location_info->longitude = atof(tmp_str);
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 6);
        if(ret)
            return;
        _mopen_location_info->flags = atoi(tmp_str);
        memset(tmp_str, 0, sizeof(tmp_str));
        // get product name
        ret = gnss_get_para_from_nmea(str, tmp_str, 9);
        if(ret)
            return;
        _mopen_location_info->altitude = atof(tmp_str);
    }
}
static char g_no_sv = 0;// 参与定位的卫星数量
static void get_gnss_time_info(int cmd, char *str, void *data)
{
    int ret;
    char param[36] = {0};
    struct mopen_location_info_t *mopen_location_info_ptr = (struct mopen_location_info_t *)data;

    if (3 == cmd) {
        memset(param, 0, sizeof(param));
        // get time
        ret = gnss_get_para_from_nmea(str, param, 1);
        if(ret)
            return;
        // get date
        ret = gnss_get_para_from_nmea(str, &param[6], 9);
        if(ret)
            return;

        mopen_location_info_ptr->timestamp = get_timestamp(param);
        get_gnss_loc_info(1, str, mopen_location_info_ptr);
    } else if(4 == cmd) /* GGA */{
        get_gnss_loc_info(2, str, mopen_location_info_ptr);
        ret = gnss_get_para_from_nmea(str, param, 7);
        if(ret)
            return;
        char no_sv = (char)atoi(param);
        gnss_log("SV number: %d, %d\n", g_no_sv, no_sv);
        /*
          只能在临时固件下，才能获取APdata星历数据
          在6颗卫星保存文件，每增加2颗保存一次。
         */
        if (1 == firmware_extren_state &&
                g_no_sv < (no_sv - 1) && no_sv > 5) {

            g_no_sv = no_sv;
            //lynq_gnss_get_ap_data();
        }
    }
}

static void gnss_uart_info(int cmd, char *str, void *data)
{
    int ret;
    char tmp_str[12] = {0};

    // $CFGPRT,1,h0,9600,129,3*57
    ret = gnss_get_para_from_nmea(str, tmp_str, 3);
    if(ret)
        return;
    mopen_gnss_device_info.usrt_bandrate = atoi(tmp_str);
    gnss_log("CFGPRT: %s\n", str);
    gnss_log("Uart bandrate: %d\n" , mopen_gnss_device_info.usrt_bandrate);
    gnss_log("*************************\n");
}

static struct mbtk_gnss_cmd_msg_t mbtk_gnss_cmd_msg_map[] = {
    { 1,     "$OK",         NULL,                 0},
    { 2,     "$Fail",       NULL,                 0},
    { 3,     "RMC",         get_gnss_time_info,   1},
    { 4,     "GGA",         get_gnss_time_info,   1},
    { 5,     "$PDTINFO",    get_gnss_device_info, 0},
    { 6,     "$CFGNMEA",    get_gnss_device_info, 0},
    { 7,     "$CFGPRT",     gnss_uart_info,       0},
    { 8,     "$CFGAID",     get_gnss_agnss_state, 0},
    { 9,     "$ANTSTAT",    NULL,                 0},
    #if TTFF_TEST
    {10,     "GSA",         gnss_gsa_info,        1},
    #endif
    };
/**
 *  \brief function description
 *
 *  Detailed 处理gnss数据
 *
 *  \param param
 *  \return return type
 */
static void process_gnss_callback(struct mbtk_gnss_handle_t *handle, char *data, int data_len)
{
    int i = 0;
    int location = 17;
    static struct mopen_location_info_t mopen_location_info;
    static int64_t tmp_time = 0;
    mopen_gnss_nmea_info_t nmea_info;

    memset(&nmea_info, 0, sizeof(nmea_info));
    if(0 == tmp_time)
        memset(&mopen_location_info, 0, sizeof(mopen_location_info));

    for (i = 0;
         i < (sizeof(mbtk_gnss_cmd_msg_map) / sizeof(struct mbtk_gnss_cmd_msg_t));
         ++i) {
        if(strstr_n(data, mbtk_gnss_cmd_msg_map[i].cmd_str)) {
            if(mbtk_gnss_cmd_msg_map[i].gnss_msg_func)
                mbtk_gnss_cmd_msg_map[i].gnss_msg_func(mbtk_gnss_cmd_msg_map[i].index,
                                                       data, &mopen_location_info);
            break;
        }
    }
    if(0 == mbtk_gnss_cmd_msg_map[i].is_continue)
        return;

    tmp_time = mopen_location_info.timestamp;
    nmea_info.timestamp = mopen_location_info.timestamp;
    nmea_info.length = data_len;
    memcpy(nmea_info.nmea, data, data_len);
    //gnss_log("nmea:[%d] %s", data_len, data);
    if(handle->mode == 3 && handle->gnss_handler_func)
    {
        handle->gnss_handler_func((uint32)handle, E_MT_LOC_MSG_ID_NMEA_INFO, &nmea_info, NULL);
    }
    else if(handle->mode == 1 && handle->gnss_handler_func && mopen_location_info.timestamp && mopen_location_info.flags)
    {
        
        handle->gnss_handler_func((uint32)handle, E_MT_LOC_MSG_ID_LOCATION_INFO, &mopen_location_info, NULL);
        memset(&mopen_location_info, 0, sizeof(mopen_location_info));
    }
    //set system time.
    if (g_gnss_sync_enable_flag == 1 && g_gnss_sync_done == 0)
    {
    #if defined(HD_GNSS)
        location = 18;
    #elif defined(HX_GNSS)
        location = 17;
    #endif
        if(strncmp(data+3,NMEA_RMC,strlen(NMEA_RMC)) == 0 && data[location] == 'A')
        {
            if (update_system_time(nmea_info.timestamp) == 0)
            {
                g_gnss_sync_done = 1;
                sc_cfg_set("gnss_process_result","success");
            }
        }
    }
    return;
}

/**
 *  \brief get_gnss_from_str
 *
 *  Detailed 从串口数据解析出每条消息
 *
 *  \param param
 *  \return return type
 */
static int get_gnss_from_str(struct mbtk_gnss_handle_t *handle, char *data, int data_len)
{
    if(event)
    {
        char tar[] = {0xF1,0xD9};
        char tar2[] = {0x04,0x20};
        char result[64] = {0};
        char buf[64];
        if(strncmp(data,tar,2) == 0 && event == 1)
        {
            navsat(data,result);
            sprintf(buf, "+Navsat:%s\n", result);
            event = 0;
            write(device_fd, buf, strlen(buf));
        }
        else if(strncmp(data,tar2,2) == 0 && event == 2)
        {
            sprintf(buf,"+Gnssver:%.11s\n", data+19);//The 19th word of this statement starts with the software version number, which is a total of 11 words
            event = 0;
            write(device_fd, buf, strlen(buf));
        }
        memset(result,0,sizeof(result));
        memset(buf,0,sizeof(result));
    }

    int i = 0;
    for (i = 0; i < data_len; i++)
    {
        if (data[i] == '$')
            break;
    }
    if (i >= data_len)
        return -1;

    data += i;
    data_len -= i;
    process_gnss_callback(handle, data, data_len);
    return 1;
}

void mopen_gnss_NonBlock(int fd, int cmd)
{
    int flags;

    flags = fcntl(fd, F_GETFL, 0);
    if(cmd)
        flags |= O_NONBLOCK;
    else
        flags &= ~O_NONBLOCK;

    fcntl(fd, F_SETFL, flags);
}

int set_baudrate(int fd, int baudrate)
{
    struct termios options, oldtio;

    if(fcntl(fd, F_SETFL, 0) < 0) {
        printf("fcntl failed!\n");
        return -1;
    }

    if(tcgetattr(fd, &oldtio) != 0) {
        printf("setup serial error!\n");
        return -1;
    }

    /* Get the current options for the port... */
    tcgetattr(fd, &options);

    /* Set the baud rates to baudrate... */
    cfsetispeed(&options, baudrate);
    cfsetospeed(&options, baudrate);
    tcsetattr(fd, TCSANOW, &options);

    if (0 != tcgetattr(fd, &options))
    {
        printf("get options error!\n");
        return -1;
    }

    /*
     * 8bit Data,no partity,1 stop bit...
     */
    options.c_cflag &= ~PARENB;//无奇偶校验
    options.c_cflag &= ~CSTOPB;//停止位，1位
    options.c_cflag &= ~CSIZE; //数据位的位掩码
    options.c_cflag |= CS8;    //数据位，8位

    cfmakeraw(&options);

    /*
     * Set the new options for the port...
     */
    if (tcsetattr(fd, TCSANOW, &options) != 0)
    {
        printf("setup serial error!\n");
        return -1 ;
    }
    return 0 ;
}

static int select_read( int fd, int timeout ) //1ms
{
    fd_set set;
    struct timeval t;
    int ret;
    int i = timeout;

    do {
        FD_ZERO(&set);
        FD_SET(fd, &set);
        t.tv_sec = 0;
        t.tv_usec = 100;

        ret = select(FD_SETSIZE, &set, NULL, NULL, &t );
        if(ret == 0) continue;
        if(ret < 0 && errno == EINTR)continue;
        else return ret;
    } while(i--);

    return ret;
}

/*
  自适应波特率设置
 */
// static int auto_set_uart_baudrate(int fd)
// {
//     char rbuf[512];
//     int rByte = 0;
//     int b[3] = {B115200, B9600, 0};
//     int ret = B9600;
//     struct timeval time_m, time_n;
//     // 时间超时标志
//     int timeout_sign = 0;
//     // 先测试默认的9600波特率
//     SET_TIME_OUT(3);
//     do {
//         gettimeofday(&time_n, NULL);
//         if(time_n.tv_sec > time_m.tv_sec) {
//             //printf("Baudrate--test-9600--- timeout!\n");
//             if(timeout_sign)
//                 break;
//             set_baudrate(fd, B115200);
//             ret = B115200;
//             timeout_sign = 1;
//             SET_TIME_OUT(3);
//             continue;
//         }

//         if(select_read(fd, 1) > 0)
//             usleep(50000);
//         else
//             continue;

//         rByte = deal_read(fd,&rbuf,sizeof(rbuf));
//         if(rByte > 0) {
//             gnss_log("Auto Baudrate[%d]%s\n", rByte, rbuf);
//             if(strstr(rbuf, "$"))
//                 return ret;
//             memset(rbuf, 0, sizeof(rbuf));
//         } else {
//             printf("*** read error\n");
//         }
//     }while(1);

//     return 0;
// }

int mopen_gnss_open(char *dev, int baudrate)
{
    int ret;
    int fd = 0;

    fd = open(dev, O_RDWR | O_NOCTTY | O_NDELAY);
    if(fd < 0) {
        printf("open error\n");
        return -1;
    }
    gnss_log("curent dev: %s, fd: %d \n", dev, fd);
    printf("curent dev: %s, fd: %d \n", dev, fd);
    if(baudrate) {
        gnss_log("set baudrate: %d \n", baudrate);
        ret = set_baudrate(fd, baudrate);
        if(-1 == ret) {
            close(fd);
            return -1;
        }
    } else {
        set_baudrate(fd, B9600);
        printf("baudrate ok\n");
    }

    return fd;
}

int gnss_reset()
{
    void* reset_handle= sc_gpio_init(126,1,0,0);
    if (reset_handle == NULL)
        return -1;
    sc_gpio_value_set(reset_handle,1);
    usleep(500000);//500ms
    sc_gpio_value_set(reset_handle,0);
    sc_gpio_uninit(reset_handle);
    return 0;
}

int check_status()
{
    int count = 10;
    int fd = open(MBTK_GNSS_DEV, O_RDWR | O_NOCTTY | O_NDELAY);
    fd_set readfds;
    struct timeval timeout;
    do {
        FD_ZERO(&readfds);
        FD_SET(fd, &readfds);
        timeout.tv_sec = count == 10 ? 10 : 1;  // 设置超时时间为 10 秒
        int retval = select(fd + 1, &readfds, NULL, NULL, &timeout);
        if (retval == -1)
        {
            ALOGE("FD ERROR\n");
            continue;
        }
        else if (retval == 0)
        {
            gnss_reset();
            continue;
        }
        else
        {
            close(fd);
            return 0;
        }
    } while(count--);
    close(fd);
    return -1; 
}

static int mopen_gnss_read(int fd, char* buf, unsigned int buf_len)
{
    buf_len=(buf_len > MBTK_UART_RECV_BUFFER_SIZE ? MBTK_UART_RECV_BUFFER_SIZE : buf_len);
    return read(fd, buf, buf_len);
}

int mopen_gnss_write(int fd, const char* buf, unsigned int buf_len)
{
    size_t size;
    size_t size_to_wr;
    ssize_t size_written;
    if(MBTK_UART_SEND_BUFFER_MAX < buf_len)
    {
        return -1;
    }
    for(size = 0; size < buf_len;)
    {
        size_to_wr = buf_len - size;
        if( size_to_wr > MBTK_UART_SEND_BUFFER_MAX)
            size_to_wr = MBTK_UART_SEND_BUFFER_MAX;
        size_written = write(fd, &buf[size], size_to_wr);
        if (size_written==-1)
        {
            return -1;
        }
        ALOGD("send cmd: %s\n", &buf[size]);
        size += size_written;
        if(size_written != size_to_wr)
        {
            return size;
        }
    }
    return size;
}

int mopen_gnss_close(int fd)
{
    return close(fd);
}

static void gnss_info_pthread(void* hdl)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)hdl;
    int ret = 0, i;
    char tmp;
    char tmp_arr[128] = {0};

    pthread_detach(pthread_self());

    memset(tmp_arr, 0, sizeof(tmp_arr));
    while(mbtk_gnss_handle->inited)
    {
        for (i = 0; i < 256; ++i) {
            if (0 == mbtk_gnss_handle->inited)
                goto exit;
            ret = ring_buffer_peek(&gnss_handle->ring_buffer, &tmp, i);
            if (0 == ret) {
                usleep(300000);
                gnss_log("ring_buffer_peek ringbuffer read error\n");
                i--;
                continue;
            }
            if (tmp == '\n') {
                break;
            }
        }
        if (i > (256 - 2))
            continue;
        ret = ring_buffer_dequeue_arr(&gnss_handle->ring_buffer, tmp_arr, i + 1);
        if(ret > 0 && 0 == mbtk_gnss_handle->getap_status) {
            get_gnss_from_str(gnss_handle, tmp_arr, ret);
            memset(tmp_arr, 0, sizeof(tmp_arr));
        } else {
            gnss_log("ringbuffer read error\n");
        }
        usleep(5000);
    }
exit:
    pthread_exit(NULL);
}

int flag = 1;
int read_buf=0;
static void gnss_uart_pthread(void* hdl)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)hdl;
    int ret = 0;
    char buf[MBTK_UART_RECV_BUFFER_SIZE] = {0};

    pthread_detach(pthread_self());

    memset(buf, 0, sizeof(buf));
    mbtk_gnss_handle->getap_status = 0;

    while(mbtk_gnss_handle->inited)
    {
        if(nmea_state == 1)
        {
            nmea_reading = 1;
            ret = mopen_gnss_read(gnss_handle->dev_fd, buf, MBTK_UART_RECV_BUFFER_SIZE);
            if(gnsslog_state)
            {
                //write_gnss_log(buf, ret);
                read_buf += ret;
                if(read_buf >= NMEA_LOG_MAX_SIZE)
                {
                    close(global_fd);
                    lynq_gnss_log_file_open();
                    read_buf = ret;
                }
                write_gnss_log(buf, ret);
            }
            nmea_reading = 0;
            if(flag != 0)
            {
                flag = 0;
            }
            if(ret > 0) {
                ring_buffer_queue_arr(&gnss_handle->ring_buffer, buf, ret);
                memset(buf, 0, sizeof(buf)); 
            } else {
                ALOGE("read error\n");
            }
        }
        usleep(5000);
    }
    pthread_exit(NULL);
}


ssize_t deal_read(int fd, void *buf, size_t count)
{
    int ret = 0;

#if 0
    ret = read(fd, buf, count);
    return ret;
#else
    while (1)
    {
        ret = read(fd, buf, count);
        if (ret == 0) {
            printf("read serial return 0, please check serial device.\n");
            exit(-5);
        }
        if(ret < 0) {
            if ((errno == EAGAIN) || (errno == EINTR)) {
                printf("read serial return -1, errno = %d, retry.\n", errno);
                continue;
            } else {
                printf("read serial return -1, errno = %d, please check serial device.\n", errno);
                exit(-5);
            }
        }
        return ret;
    }
#endif
}



// check: 是否需要校验
// static int mopen_uart_change(int fd, int check)
// {
//     int rByte = 0, i = 20;
//     char name[32];
//     char rbuf[1024];

//     sprintf(name,"$CFGPRT,1,h0,115200,129,3\r\n");
//     rByte = write( fd, name, strlen(name));
//     tcdrain(fd);//阻塞直到发送完成

//     set_baudrate(fd, B115200);
//     usleep(200000);
//     tcflush(fd, TCIFLUSH);//清空缓存区数据

//     if (0 == check)
//         return 0;
//     do{
//         rByte = 0;
//         memset(rbuf, 0, sizeof(rbuf));
//         if(select_read(fd, 1) > 0) {
//             rByte = deal_read(fd, &rbuf, sizeof(rbuf) - 1);
//             rbuf[rByte] = 0;
//             gnss_log("%s: %s", __FUNCTION__, rbuf);
//         }
//         if(strstr(rbuf, "$")) {
//             return 0;
//         } else {
//             gnss_log("%d rByte = %d, [%s]\n", 20 - i, rByte, rbuf);
//         }
//         usleep(5000 * 100);
//     }while(i--);

//     return -1;
// }

int lynq_open_gps(int state)
{
    int ret;
    /*in Eur,need set GPIO15 and 84 value; in CN,need set GPIO86 value*/
    if(0 == state)
    {
        nmea_state = 0;
        for(int cont = 0; cont < 200; cont++)
        {
            if (nmea_reading == 0)
            {
                break;
            }
            usleep(10000);
        }

    #if defined(HD_GNSS)
            test_gpio_handle[15] = sc_gpio_init(15,0,0,0);
            test_gpio_handle[84] = sc_gpio_init(84,1,0,0);
            ret = sc_gpio_value_set(test_gpio_handle[84],0);
            if(ret)
            {
                ALOGE("gpio84 set value 0 error\n");
            }
    #elif defined(HX_GNSS)
            test_gpio_handle[86] = sc_gpio_init(86,1,0,0);
            ret = sc_gpio_value_set(test_gpio_handle[86],0);
            if(ret)
            {
                ALOGE("gpio86 set value 0 error\n");
            }
    #endif

    }

    else if(1 == state)
    {
        
    #if defined(HD_GNSS)
            test_gpio_handle[84] = sc_gpio_init(84,1,0,0);
            test_gpio_handle[15] = sc_gpio_init(15,0,0,0);
            test_gpio_handle[126] = sc_gpio_init(126,1,0,0);
            ret = sc_gpio_value_set(test_gpio_handle[126],1);
            if(ret)
            {
                ALOGE("gpio126 set value 1 error\n");
            }
            usleep(30000);
            ret = sc_gpio_value_set(test_gpio_handle[84],1);
            if(ret)
            {
                ALOGE("gpio84 set value 1 error\n");
            }
            usleep(15000);
            ret = sc_gpio_value_set(test_gpio_handle[126],0);
            if(ret)
            {
                ALOGE("gpio126 set value 1 error\n");
            }
    #elif defined(HX_GNSS)
            test_gpio_handle[86] = sc_gpio_init(86,1,0,0);
            ret = sc_gpio_value_set(test_gpio_handle[86],1);
            if(ret)
            {
                ALOGE("gpio86 set value 1 error\n");
            }
    #endif
    }

    #if defined(HD_GNSS)
        sc_gpio_uninit(test_gpio_handle[15]);
        sc_gpio_uninit(test_gpio_handle[84]);
        sc_gpio_uninit(test_gpio_handle[126]);
        test_gpio_handle[15] = NULL;
        test_gpio_handle[84] = NULL;
        test_gpio_handle[126] = NULL;
    #elif defined(HX_GNSS)
        sc_gpio_uninit(test_gpio_handle[86]);
        test_gpio_handle[86] = NULL;
    #endif
    return 0;
}

int lynq_gnss_start()
{
    lynq_open_gps(1);
    if (check_status())
        return -1;
    nmea_state = 1;
    return 0;
}


int lynq_gnss_client_init(uint32 *ph_gnss)
{
    int ret;
    if(ph_gnss == NULL) {
        ALOGE("ARG error or has inited.");
        return -1;
    }

    if (mbtk_gnss_handle) {
        ALOGE("GNSS has inited.");
        *ph_gnss = (uint32)mbtk_gnss_handle;
        return 0;
    }
    
    mbtk_gnss_handle = (mbtk_gnss_handle_t*)malloc(sizeof(struct mbtk_gnss_handle_t));
    if(NULL == mbtk_gnss_handle)
    {
        ALOGE("malloc memory error\n");
        return -3;
    }
    http_handle_init();
    memset(mbtk_gnss_handle, 0, sizeof(struct mbtk_gnss_handle_t));
    memset(&mopen_gnss_device_info, 0, sizeof(mopen_gnss_device_info));
    mbtk_gnss_handle->dev_fd = mopen_gnss_open(MBTK_GNSS_DEV, B115200);
    mbtk_gnss_handle->rb = (char*)malloc(MBTK_UART_RECV_BUFFER_SIZE);
    if(NULL == mbtk_gnss_handle->rb)
    {
        ALOGE("malloc memory error\n");
        return -1;
    }

    lynq_open_gps(1);
    sleep(1);
    lynq_gnss_configure_init();
    if(gnsslog_state)
    {
        usleep(1000);
        lynq_gnss_log_file_open();
    }
    lynq_open_gps(0);

    ring_buffer_init(&mbtk_gnss_handle->ring_buffer,
                     mbtk_gnss_handle->rb,
                     MBTK_UART_RECV_BUFFER_SIZE);
    mbtk_gnss_handle->inited = 1;
    mbtk_gnss_handle->mode = 3;
    pthread_mutex_init(&mbtk_gnss_handle->_cond_mutex, NULL);
    pthread_create(&mbtk_gnss_handle->uart_pthread, NULL, (void* (*)(void*))gnss_uart_pthread, (void *)mbtk_gnss_handle);
    pthread_create(&mbtk_gnss_handle->gnss_pthread, NULL, (void* (*)(void*))gnss_info_pthread, (void *)mbtk_gnss_handle);
    *ph_gnss = (uint32)mbtk_gnss_handle;
    mbtk_gnss_handle->phandle = ph_gnss;

    return 0;
err:
    mopen_gnss_close(mbtk_gnss_handle->dev_fd);
    lynq_open_gps(0);
    firmware_extren_state = 0;
    if (mbtk_gnss_handle) free(mbtk_gnss_handle);
    mbtk_gnss_handle = NULL;

    return ret;
}
static int _kill_pthread(pthread_t pid, int kill)
{
    int ret;

    if (kill) {
        ALOGE("GNSS hardware issues\n");
        ret = pthread_cancel(pid);
        pthread_join(pid, NULL);
    }
    do{
        ret = pthread_kill(pid, 0);
        if(ret == ESRCH)
            gnss_log("The specified thread does not exist or has terminated\n");
        else if(ret == EINVAL)
            gnss_log("Useless signal\n");
        else
            gnss_log("The thread exists\n");

        usleep(100000);
    }while(0 == ret);

    return 0;
}
int lynq_gnss_client_deinit(uint32 h_gnss)
{
    int ret;
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    if(h_gnss == NULL)
    {
        ALOGE("ARG error or not inited.");
        return -1;
    }
    gnss_handle->inited = 0;
#if TTFF_TEST
    // ttff测试线程在运行，而且不是临时固件模式
    if (gnss_handle->ttff_pid &&
            0 == firmware_extren_state &&
            0 == location_test) {
        gnss_log("kill thread ttff.\n");
        _kill_pthread(gnss_handle->ttff_pid, 1);
    }
#endif
    
    gnss_log("kill thread info 0.\n");
    _kill_pthread(gnss_handle->gnss_pthread, 0);
    gnss_log("kill thread uart.\n");
    _kill_pthread(gnss_handle->uart_pthread, flag);
    mopen_gnss_close(gnss_handle->dev_fd);
    ret = lynq_open_gps(0);
    if(ret)
    {
        ALOGE("GNSS close init error\n");
        return -1;
    }
    firmware_extren_state = 0;
    if (gnss_handle->rb)
    {
        free(gnss_handle->rb);
    }
    free(mbtk_gnss_handle);
    mbtk_gnss_handle = NULL;
    return 0;
}

int lynq_gnss_send_cmd(uint32 h_gnss, const char *cmd, int cmd_len)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    return  mopen_gnss_write(gnss_handle->dev_fd, cmd, cmd_len);
}


int lynq_gnss_get_device_info(uint32 h_gnss)
{
    int ret;
    char *send_buf = "$PDTINFO\r\n";
    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }

    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        printf("lynq_gnss_client_init FAIL.	ret:%d\n",ret);
        return -1;
    }

    return 0;
}


/**
 * @brief      lynq_gnss_get_aidinfo
 *
 * @details    查询辅助数据状态
 *             $CFGAID,0,D7FBFBDF,00000000,08*47
 * @param      param
 *
 * @return     return type
 */
int lynq_gnss_get_aidinfo(uint32 h_gnss)
{
    int ret;
    // char *send_buf = "$AIDINFO\r\n";
    char *send_buf = "$CFGAID,0\r\n";
    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }

    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        printf("%s FAIL. ret:%d\n", __FUNCTION__, ret);
        return -1;
    }
    return 0;
}
/**
 * @brief      lynq_gnss_get_uart
 *
 * @details    get uart config info.
 *             $CFGPRT,1,h0,9600,129,3*57
 *
 * @param      param
 *
 * @return     return type
 */
int lynq_gnss_get_uart(uint32 h_gnss)
{
    int ret;
    char *send_buf = "$CFGPRT,1\r\n";
    // char *send_buf = "$CFGPRT,2\r\n";
    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }

    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        printf("lynq_gnss_client_init FAIL.	ret:%d\n",ret);
        return -1;
    }
    return 0;
}

int mopen_gnss_set_uart(uint32 h_gnss, int baudrate)
{
    int ret;
    char send_buf[28] = {0};
    // char *send_buf = "$CFGPRT,1,h0,9600,1,3\r\n";

    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }
    sprintf(send_buf, "$CFGPRT,1,h0,%d,1,3\r\n", baudrate);
    gnss_log("%s %s", __FUNCTION__, send_buf);
    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        printf("lynq_gnss_client_init FAIL.	ret:%d\n",ret);
        return -1;
    }
    return 0;
}


int mopen_gnss_get_ant_state_info(uint32 h_gnss)
{
    int ret;
    char *cmd1_buf = "$ANTSTAT,1\r\n";
    char *cmd2_buf = "$ANTSTAT1\r\n";

    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }
    ret = lynq_gnss_send_cmd(h_gnss, cmd1_buf, strlen(cmd1_buf));
    if(ret < 0)
    {
        gnss_log("%s FAIL. ret:%d\n", __func__, ret);
        return -1;
    }
    ret = lynq_gnss_send_cmd(h_gnss, cmd2_buf, strlen(cmd2_buf));
    if(ret < 0)
    {
        gnss_log("%s FAIL. ret:%d\n", __func__, ret);
        return -1;
    }
    return 0;
}

int mopen_gnss_get_nmea_config(uint32 h_gnss)
{
    int ret;
    char *send_buf = "$CFGNMEA\r\n";

    if(0 == h_gnss)
    {
        ALOGE("%s handler invalid.\n", __func__);
        return -1;
    }
    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        ALOGE("%s FAIL. ret:%d\n", __func__, ret);
        return -1;
    }
    return 0;
}

#define AGNSS_TLE_FILE  "/mnt/userdata/agnss_tle"

static void http_data_cb_func(
    int session_id, mbtk_http_data_type_enum type,
    void *data,int data_len)
{
    static int agnss_fd = 0;
    int ret = 0;

    if(type == MBTK_HTTP_DATA_HEADER) {
        printf("Header(%d):%s\n", data_len, (char*)data);
        if(agnss_fd > 0)
            return;
        unlink(AGNSS_TLE_FILE);
        agnss_fd = open(AGNSS_TLE_FILE, O_RDWR|O_CREAT|O_TRUNC, 0644);
        if (agnss_fd <= 0)
        printf("file open error\n");
        printf("agnss file open: %d\n", agnss_fd);
    } else if(type == MBTK_HTTP_DATA_CONTENT) {
        printf("http Data(%d)\n", data_len);

        ret = write(agnss_fd, (char*)data, data_len);
        if (ret < 0) {
            printf("%s: error writing to file!\n", __FUNCTION__);
        } else if (ret < data_len) {
            printf("%s: wrote less the buffer size!\n", __FUNCTION__);
        }
    } else {
        printf(">>>>>Complete<<<<<\n");
        if(agnss_fd <= 0)
            return;
        close(agnss_fd);
        agnss_fd = 0;
    }
}

static int gnss_http_requst(char *id, char *pw)
{
    char tmp[128] = {0};
    
    int http_handle = mbtk_http_handle_get(TRUE, http_data_cb_func);
    if(http_handle < 0)
    {
        printf("mbtk_http_handle_get() fail.");
        return -1;
    }
    int http_session = mbtk_http_session_create(http_handle, HTTP_OPTION_POST, HTTP_VERSION_1_1);
    if(http_handle < 0)
    {
        printf("mbtk_http_session_create() fail.");
        return -2;
    }
    if(mbtk_http_session_url_set(http_handle, http_session, "http://unicore-api.rx-networks.cn/rxn-api/locationApi/rtcm")) {
        printf("mbtk_http_session_url_set() fail.\n");
        mbtk_http_handle_free(http_handle);
        return -3;
    }

    char* post_data = "[{\"rtAssistance\":{\"format\":\"rtcm\",\"msgs\":[\"GPS:2NAF\",\"BDS:2NAF\",\"QZS:2NAF\"]}}]\r\n";

    mbtk_http_session_head_add(http_handle, http_session, \
    "Host", "unicore-api.rx-networks.cn");

    sprintf(tmp, "RXN-BASIC cId=%s,mId=Unicore,dId=12-23-34-45-58,pw=%s", id, pw);
    mbtk_http_session_head_add(http_handle, http_session, \
    "Authorization", tmp);

    mbtk_http_session_head_add(http_handle, http_session, \
            "Content-Type", "application/json");

    mbtk_http_session_head_add(http_handle, http_session, \
            "Accept", "application/octet-stream");
    mbtk_http_session_content_set(http_handle, http_session,
                                  post_data, strlen(post_data));

    if(mbtk_http_session_start(http_handle, http_session)) {
        printf("mbtk_http_session_start() fail.\n");
        mbtk_http_handle_free(http_handle);
        return -4;
    }
    if(mbtk_http_handle_free(http_handle))
    {
        printf("mbtk_http_handle_free() fail.");
        return -5;
    }

    return 0;
}

static int hd_gnss_http_requst(char *host)
{
    int http_handle = mbtk_http_handle_get(TRUE, http_data_cb_func);
    if(http_handle < 0)
    {
        printf("mbtk_http_handle_get() fail.");
        return -1;
    }
    int http_session = mbtk_http_session_create(http_handle, HTTP_OPTION_GET, HTTP_VERSION_1_1);
    if(http_handle < 0)
    {
        printf("mbtk_http_session_create() fail.");
        return -2;
    }

    if(mbtk_http_session_url_set(http_handle, http_session, host))
    {
        mbtk_http_handle_free(http_handle);
        printf("mbtk_http_session_url_set() fail.\n");
        return -3;
    }
    if(mbtk_http_session_start(http_handle, http_session))
    {
        mbtk_http_handle_free(http_handle);
        printf("mbtk_http_session_start() fail.\n");
        return -4;
    }
    if(mbtk_http_handle_free(http_handle))
    {
        printf("mbtk_http_handle_free() fail.");
        return -5;
    }

    return 0;
}

#define AGNSS_CONFIG_FILE  "/data/gnss_update/agps.conf"

/**
 * @brief      mopen_gnss_download_tle;hd_gnss_download_tle
 *
 * @details    下载星历数据
 *             (卫星星历，又称为两行轨道数据（TLE，Two-Line Orbital Element）)
 *             保存到文件:AGNSS_TLE_FILE
 * @param      param
 *
 * @return     return type
 */
int mopen_gnss_download_tle(void)
{
    FILE *fp;
    char StrLine[64];
    char _id[28] = {0};
    char _passwd[28] = {0};
    int i;
    if((fp = fopen(AGNSS_CONFIG_FILE, "r")) == NULL)
    {
        printf("open %s error!\n", AGNSS_CONFIG_FILE);
        return -1;
    }

    while (!feof(fp))
    {
        memset(StrLine, 0, 64);
        fgets(StrLine, 64, fp);
        gnss_log("%s\n", StrLine);
        i = strstr_n(StrLine, ": ");
        if(i && strstr_n(StrLine, "ID"))
        {
            memcpy(_id, &StrLine[i + 1], strlen(StrLine) - i - 2);
            printf("%s\n",_id);
        }
        else if( i && strstr_n(StrLine, "Base 64"))
        {
            memcpy(_passwd, &StrLine[i + 1], strlen(StrLine) - i - 1);
            printf("%s\n",_passwd);
        }
    }
    fclose(fp);
    gnss_log("%s : %s[%d], %s[%d]\n", __FUNCTION__, _id, strlen(_id), _passwd, strlen(_passwd));
    return gnss_http_requst(_id, _passwd);
}

int hd_gnss_download_tle(char *host, char *id, char *password)
{
    //id and pw are currently not being used for future access to self built servers
    int ret;
    const char default_host[] = "http://uagnss.allystar.com/ephemeris/HD_GPS.hdb?compid=yikecs1&token=Z38w5urAuawubTxi";
    if(host == NULL)
    {
        ret = hd_gnss_http_requst(default_host);
    }
    else
    {
        ret = hd_gnss_http_requst(host);
    }
    return ret;
}

/**
 * @brief      mopen_gnss_injects_aidpos
 *
 * @details    注入星历, 128 bytes
 *
 * @param      param
 *
 * @return     return type
 */
int mopen_gnss_injects_aidpos(uint32 h_gnss)
{
    int ret;
    int agnss_fd = 0;
    int size = 0;

    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }

    agnss_fd = open(AGNSS_TLE_FILE, O_RDWR);
    if (agnss_fd <= 0)
    {
        printf("%s open file FAIL. errno:%d\n", __FUNCTION__, errno);
        return -1;
    }
    char* databuf = (char*)malloc(128);
    if(databuf == NULL)
    {
        gnss_log("%s malloc() fail.", __FUNCTION__);
        return -1;
    }
    memset(databuf, 0, 128);
    while(0 < (size = read(agnss_fd, databuf, 128)))
    {
        gnss_log("%s Write[%d]\r\n", __FUNCTION__, size);
        ret = lynq_gnss_send_cmd(h_gnss, databuf, size);
        if(ret < 0)
        {
            printf("%s send cmd FAIL. ret:%d\n", __FUNCTION__, ret);
            break;
        }
        memset(databuf, 0, 128);
    }
    close(agnss_fd);
    free(databuf);
    lynq_gnss_get_aidinfo(h_gnss);

    return 0;
}

#define BUFFER_SIZE 1024
int hd_gnss_injects_aidpos(uint32 h_gnss)
{
    int packet_length;
    int hd_agnss_fd = 0;
    int size = 0;
    int left_size = 0;
    int total_size = 0;
    char *databuf = (char *)malloc(BUFFER_SIZE);
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    hd_agnss_fd = open(AGNSS_TLE_FILE, O_RDWR);
    if (hd_agnss_fd <= 0)
    {
        free(databuf);
        databuf = NULL;
        printf("%s open file FAIL. errno:%d\n", __FUNCTION__, errno);
        return -1;
    }
    while(0 < (size = read(hd_agnss_fd, (databuf + left_size), BUFFER_SIZE)))
    {
        total_size = size + left_size;
        left_size = 0;
        for(int i=0; i < total_size;)
        {
            gnss_log("%s Write[%d]\r\n", __FUNCTION__, size);
            if((databuf[i] == 0xF1) && (databuf[i + 1] == 0xD9))
            {
                packet_length = (databuf[i + 4] | (databuf[i + 5] << 8));
                if (i + packet_length + 8 <= total_size)
                {
                    write(gnss_handle->dev_fd, databuf + i, packet_length + 8);
                    usleep(5000);
                    i = i + packet_length + 8;
                }
                else
                {
                    left_size = total_size - i;
                    char *tmp = databuf;
                    databuf = (char *)malloc(BUFFER_SIZE + left_size);
                    memcpy(databuf, tmp + i ,left_size);
                    free(tmp);
                    break;
                }
            }
            else
                i++;
        }
    }
    free(databuf);
    databuf = NULL;
    close(hd_agnss_fd);
    return 0;
}


/**
 * @brief
 *
 * @details    detailed description
 *
 * @param      mode
 *                  1 : out put locate information
 *                  2 : reserve
 *                  3 : out put nmea
 *
 * @return     return type
 */
int mopen_gnss_set_mode(uint32 h_gnss, int mode)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    if(0 == h_gnss)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }
    gnss_handle->mode = mode;

    return 0;
}

int mopen_gnss_print_version(uint32 h_gnss)
{
    printf("*************************\n");
    printf("-Pn: %s\n dc: %s\n hv: %s\n fw: %s\n pn: %s\n sn: %s\n ",
           mopen_gnss_device_info.product_name,
           mopen_gnss_device_info.dev_config,
           mopen_gnss_device_info.hw_ver,
           mopen_gnss_device_info.fw_ver,
           mopen_gnss_device_info.pn,
           mopen_gnss_device_info.sn);
    printf("Uart bandrate: %d\n" , mopen_gnss_device_info.usrt_bandrate);
    printf("*************************\n");

    return 0;
}

/*Injection ephemeris AGNSS_TLE_FILE*/
int lynq_gnss_Injection_ephemeris(uint32 h_gnss, char *ephemeris_path)
{
    int ret;
    int agnss_fd = 0;
    int size = 0;

    if(0 == h_gnss)
    {
        ALOGE("%s handler invalid.\n", __func__);
        return -1;
    }

    agnss_fd = open(ephemeris_path, O_RDWR);
    if (agnss_fd <= 0)
    {
        ALOGE("%s open file FAIL. errno:%d\n", __FUNCTION__, errno);
        return -1;
    }
    char* databuf = (char*)malloc(128);
    if(databuf == NULL)
    {
        ALOGE("%s malloc() fail.", __FUNCTION__);
        return -1;
    }
    memset(databuf, 0, 128);
    while(0 < (size = read(agnss_fd, databuf, 128)))
    {
        gnss_log("%s Write[%d]\r\n", __FUNCTION__, size);
        ret = lynq_gnss_send_cmd(h_gnss, databuf, size);
        if(ret < 0)
        {
            printf("send cmd FAIL. ret:%d\n",  ret);
            break;
        }
        memset(databuf, 0, 128);
    }
    close(agnss_fd);
    free(databuf);
    return 0;

}
#ifdef __cplusplus
}
#endif
