#include <sys/epoll.h>
#include <string.h>
#include <log/log.h>
#include <liblog/lynq_deflog.h>
//#include "mbtk_log.h"
#include "mbtk_http_base.h"
#include "mbtk_http.h"
#ifdef __cplusplus
extern "C" {
#endif

static bool http_sock_inited = FALSE;
static int http_handle = -1;
static int http_fd = -1;
//static void http_sock_cb_func(int handle, int fd, int event);

/*static mbtk_init_info =
{
    MBTK_NET_LINUX,
    NULL,
    http_sock_cb_func
} http_init_info;*/



/*static void http_sock_cb_func(int handle, int fd, int event)
{
    if(http_handle == handle && http_fd == fd) {
        if(event & EPOLLIN) { // READ

        } else if(event & EPOLLRDHUP) { // Close

        } else {
            RLOGD("Unknown event:%x",event);
        }
    }
}*/

int mbtk_sock_open()
{

    return 0;
}

int mbtk_http_init()
{
    if(http_sock_inited) {
        RLOGD("HTTP has inited.");
        return -1;
    }

    http_handle = socket(AF_INET,SOCK_STREAM,0);
    if(http_handle < 0)
    {
        RLOGD("mbtk_sock_init() fail.");
        return -1;
    }

    http_sock_inited = TRUE;
    return 0;
}

int mbtk_http_deinit()
{
    if(!http_sock_inited) {
        RLOGD("HTTP not inited.");
        return -1;
    }

    close(http_handle);
    http_handle = -1;
    http_sock_inited = FALSE;
    return 0;
}


int mbtk_http_open
(
    const void *host,
    int *port
)
{
    struct addrinfo server;
    struct addrinfo* serverInfo;
    int ret;

    server.ai_family = AF_INET;
    server.ai_socktype = SOCK_STREAM;
    server.ai_protocol = IPPROTO_TCP;
    server.ai_flags = AI_PASSIVE;
    char portStr[6];
    snprintf(portStr, sizeof(portStr), "%d", *port);
    memset(&server, 0, sizeof(server));
    ret = getaddrinfo(host, portStr, &server, &serverInfo);
    if (ret != 0)
    {
        printf("ret = %s\n",gai_strerror(ret));
        printf("getaddrinfo error: \n");
        return -1;
    }
    ret = connect(http_handle, serverInfo->ai_addr, serverInfo->ai_addrlen);
    if(ret < 0)
    {
        printf("connect fail http_handle:%d\n",http_handle);
        close(http_handle);
        freeaddrinfo(serverInfo);
        return -1;
    }
    printf("http_handle: %d\n",http_handle);
    return http_handle;
}

/*=============================================
FUNCTION
    mbtk_http_read

DESCRIPTION
    read content from socket.

DEPENDENCIES
    None

PARAMETERS
    *buf      Store read content.
    len       the length of Content.
    timeout   Set timeout

RETURN VALUE
    Length of read content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_read
(
    int sock_fd,
    void *buf,
    uint16_t len,
    int timeout_ms
)
{
    sleep(timeout_ms / 1000);
    int read_len = recv(sock_fd, buf, len, 0);
    if(read_len < 0)
    {
            return -1;
    }
    else
    {
        return read_len;
    }
}


int mbtk_http_read_line
(
    int sock_fd,
    void *buf,
    uint16_t len
)
{
    if(sock_fd > 0) {
        char *buf_ptr = (char*)buf;
        char read_buf[1];
        int read_len = 0;
        while(TRUE) {
            if(recv(sock_fd, read_buf, 1, 0) == 1) {
                *buf_ptr++ = read_buf[0];
                read_len++;

                if(read_buf[0] == '\n' || read_len >= len) {
                    return read_len;
                }
            } else {
                return -1;
            }
        }
    }


    return -1;
}


/*=============================================
FUNCTION
    mbtk_http_write

DESCRIPTION
    Write content to socket.

DEPENDENCIES
    None

PARAMETERS
    *buf    Content to be transferred
    len     the length of Content.

RETURN VALUE
    Length of written content

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_write(int sock_fd, void *buf, uint16_t len)
{
    RLOGD("Write[%d]:%s",len,(char*)buf);
    return send(sock_fd, buf, len, 0);
}

/*=============================================
FUNCTION
    mbtk_http_close

DESCRIPTION
    close HTTP service.

DEPENDENCIES
    None

PARAMETERS
    *err    Error number

RETURN VALUE
    TURE or FALSE

SIDE EFFECTS
    None
=============================================*/
int mbtk_http_close(int sock_fd)
{

    close(sock_fd);
    sock_fd = -1;
    return 0;
}

#ifdef __cplusplus
}
#endif