#include <stdio.h>
#include <stdint.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <log/log.h>
#include <stdlib.h>
#include <pthread.h>
#include <liblog/lynq_deflog.h>
#include "lynq_qser_sim.h"
#include <libsim/lynq_sim.h>

#define USER_LOG_TAG "LYNQ_QSER_SIM"

sim_client_handle_type h_sim = 0;

int qser_sim_client_init(sim_client_handle_type  *ph_sim)
{
    if(NULL == ph_sim)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    *ph_sim = (sim_client_handle_type)getpid();
    //*ph_sim = (sim_client_handle_type)53234323;
    h_sim = *ph_sim;
    return lynq_sim_init(*ph_sim);
}

int qser_sim_client_deinit(sim_client_handle_type h_sim)
{
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_sim_deinit();
}
QSER_SIM_RxMsgHandlerFunc_t tmp_sim = NULL;
void *new_sim_thread_recv(void *p)
{
    int handle = 0;
    int sim_status = 0;

    QSER_SIM_CARD_STATUS_INFO_T QSER_sim_info;
    while (1)
    {
        if(!lynq_wait_sim_state_change(&handle))
        {
            if(!lynq_read_sim_status(handle, &sim_status))
            {
                if(1 == sim_status)
                {
                    QSER_sim_info.e_card_state = 0xB03;
                }
                else if(0 == sim_status)
                {
                
                    QSER_sim_info.e_card_state = 0xB02;
                }
                else{
                    QSER_sim_info.e_card_state = 0xB01;
                }
                tmp_sim(&QSER_sim_info);
            }
            else
            {
                LYDBGLOG("lynq_read_sim_status error\n");
            }
        }
        else
        {
            LYDBGLOG("lynq_wait_receive_new_sim error\n");
            break;
        }
    }
    return NULL;
}

int qser_sim_addrxmsghandler(QSER_SIM_RxMsgHandlerFunc_t handlerPtr)
{
    if(NULL == handlerPtr)
    {
        return E_QSER_ERROR_BADPARM;
    }

    tmp_sim = handlerPtr;
    pthread_t lynq_new_sim_tid = -1;
    int ret = pthread_create(&lynq_new_sim_tid, NULL, new_sim_thread_recv, NULL);
    if(ret < 0)
    {
        LYDBGLOG("qser_sim_addrxmsghandler pthread_create error!!!\n");
        return -1;
    }
    return E_QSER_SUCCESS;
}


int qser_sim_getimsi(sim_client_handle_type h_sim, QSER_SIM_APP_ID_INFO_T *pt_info, char *imsi, size_t imsiLen)
{
    int ret = 0;
    //char imsi_data[30] = "";

    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(NULL == imsi)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }

    ret = lynq_get_imsi(imsi);
#if 0
    int num_items = sscanf(imsi, "+CIMI: %s", imsi_data);
    if (num_items == 1)
    {
        LYDBGLOG("imsi_data: %s\n", imsi_data);
    }
    else
    {
        LYERRLOG("imsi_data not found\n");
    }
#endif
    LYINFLOG("[%s-%d] QSER_IMSI: %s\n", __FUNCTION__, __LINE__, imsi);

    return ret;
}

int qser_sim_geticcid(sim_client_handle_type h_sim, QSER_SIM_SLOT_ID_TYPE_T simId, char *iccid, size_t iccidLen)
{
    int ret = 0;
    if(NULL == iccid)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_get_iccid(iccid);
    LYINFLOG("[%s-%d] QSER_ICCID: %s\n", __FUNCTION__, __LINE__, iccid);
    return ret;
}

int qser_sim_getphonenumber(sim_client_handle_type h_sim, QSER_SIM_APP_ID_INFO_T *pt_info,  char *phone_num, size_t phoneLen)
{
    int ret = 0;
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(NULL == phone_num)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_query_phone_number(phone_num);
    LYINFLOG("[%s-%d] QSER_PHONE_NUM: %s\n", __FUNCTION__, __LINE__, phone_num);
    return ret;
}

int qser_sim_verifypin(sim_client_handle_type h_sim, QSER_SIM_VERIFY_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_verify_pin(pt_info->pin_value);
}

int qser_sim_changepin(sim_client_handle_type h_sim,QSER_SIM_CHANGE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_change_pin(pt_info->old_pin_value, pt_info->new_pin_value);
}

int qser_sim_unblockpin(sim_client_handle_type h_sim, QSER_SIM_UNBLOCK_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_unlock_pin(pt_info->puk_value, pt_info->new_pin_value);
}

int qser_sim_enablepin(sim_client_handle_type h_sim, QSER_SIM_ENABLE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_enable_pin(pt_info->pin_value);
}

int qser_sim_disablepin(sim_client_handle_type h_sim, QSER_SIM_DISABLE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_disable_pin(pt_info->pin_value);
}

QSER_SIM_APP_STATE_TYPE_T convert_ril_appstate_toqser(int rilAppState) {
    switch (rilAppState) {
        case 0:
            return QSER_SIM_APP_STATE_UNKNOWN;
        case 1:
            return QSER_SIM_APP_STATE_DETECTED;
        case 2:
            return QSER_SIM_APP_STATE_PIN1_REQ;
        case 3:
            return QSER_SIM_APP_STATE_PUK1_REQ;
        case 5:
            return QSER_SIM_APP_STATE_READY;
        default:
            return QSER_SIM_APP_STATE_UNKNOWN;
    }
}


int qser_sim_getcardstatus(sim_client_handle_type h_sim,QSER_SIM_SLOT_ID_TYPE_T simId, QSER_SIM_CARD_STATUS_INFO_T   *pt_info)
{
    int ret = 0;
    int sim_status, app_state;
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_get_sim_status(&sim_status, &app_state);
    if(1 == sim_status)
    {
        pt_info->e_card_state = 0xB03;
    }
    else if(0 == sim_status)
    {
    
        pt_info->e_card_state = 0xB02;
    }
    else{
        pt_info->e_card_state = 0xB01;
    }
    pt_info->card_app_info.app_3gpp.app_state = convert_ril_appstate_toqser(app_state);
    LYINFLOG("[%s-%d] QSER_CARD_STATUS: e_card_state = 0x%x, app_state =  0x%x\n", __FUNCTION__, __LINE__, pt_info->e_card_state, pt_info->card_app_info.app_3gpp.app_state);
    return ret;
}

int qser_sim_getimei(sim_client_handle_type h_sim, char *imei)
{
    int ret = 0;
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_get_imei(imei);

    LYINFLOG("[%s-%d] QSER_IMEI: %s\n", __FUNCTION__, __LINE__, imei);

    return ret;
}
int qser_get_imei_and_sv(sim_client_handle_type h_sim,char *imei, char*sv)
{
    int ret = 0;

    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_get_imei_and_sv(imei, sv);
    LYINFLOG("[%s-%d] QSER_GET_IMEI_AND_SV: %s, %s\n", __FUNCTION__, __LINE__, imei, sv);
    return ret;
}
int qser_reset_modem(sim_client_handle_type h_sim)
{
    int ret = 0;

    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_reset_modem();
    return ret;
}

int qser_get_version(sim_client_handle_type h_sim, char *buf)
{
    int ret = 0;

    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_get_version(buf);
    LYINFLOG("[%s-%d] QSER_GET_VERSION: %s\n", __FUNCTION__, __LINE__, buf);
    return ret;
}

int qser_reset_sim(sim_client_handle_type h_sim)
{
    int ret = 0;

    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    ret = lynq_reset_sim();
    return ret;
}

int qser_sim_profile(char *cmd, char *rsp)
{
    if(lynq_req_sim_profile(cmd, rsp))
        return -1;
    return 0;
}
DEFINE_LYNQ_LIB_LOG(LYNQ_QSER_SIM)

