#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <errno.h>
#include <unistd.h>
#include <liblog/lynq_deflog.h>
#include <sys/types.h>
#include <pthread.h>
#include <libsms/lynq_sms.h>
#include "lynq_qser_sms.h"
#define USER_LOG_TAG "LYNQ_QSER_SMS"

QSER_SMS_RxMsgHandlerFunc_t tmp = NULL;

sms_client_handle_type h_sms = 0;

enum{
    SMS_OK = 0,
    SMS_FAIL,
    SMS_PARAM_ERR
};

void *new_sms_thread_recv(void *p)
{
    int handle = -1;
    int status = -1;
    int charset = -1;
    char smsc[1024];
    int smscLen = -1;
    int smslen = -1;
    char message[1024];
    char teleNum[1024];
    int numLen = -1;
    int current = -1;
    int total = -1;
    QSER_sms_info_t QSER_sms_info;
    while (1)
    {
        if(!lynq_wait_receive_new_sms(&handle))
        {
            if(!lynq_read_sms(handle,&status,&charset,smsc,&smscLen,&smslen,message,teleNum,&numLen,&current,&total))
            {
                QSER_sms_info.storage_index = handle;
                QSER_sms_info.format = (QSER_SMS_T)charset;
                memset(QSER_sms_info.sms_data, 0, sizeof(QSER_sms_info.sms_data));
                memset(QSER_sms_info.src_addr, 0, sizeof(QSER_sms_info.src_addr));
                memcpy(QSER_sms_info.src_addr, teleNum, strlen(teleNum));
                memcpy(QSER_sms_info.sms_data, message, smslen);
                QSER_sms_info.sms_data[smslen] = '\0';
                QSER_sms_info.sms_data_len = smslen;
                if(total > 1)
                {
                    QSER_sms_info.user_data_head_valid = 1;
                    QSER_sms_info.user_data_head.seg_number = current;
                    QSER_sms_info.user_data_head.total_segments = total;
                }
                else
                {
                    QSER_sms_info.user_data_head_valid = 0;
                }
                tmp(&QSER_sms_info, &h_sms);
            }
            else
            {
                LYDBGLOG("lynq_read_sms error\n");
            }
        }
        else
        {
            LYDBGLOG("lynq_wait_receive_new_sms error\n");
            break;
        }
    }
    return NULL;
}

int qser_sms_client_init(sms_client_handle_type  *ph_sms)
{
    if(NULL == ph_sms)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    *ph_sms = (sms_client_handle_type)getpid();
    h_sms = *ph_sms;
    return lynq_sms_init(*ph_sms);
}

int qser_sms_client_deinit(sms_client_handle_type h_sms)
{
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    return lynq_sms_deinit();
}

int qser_sms_send_sms(sms_client_handle_type h_sms, QSER_sms_info_t *pt_sms_info)
{
    if(NULL == pt_sms_info)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    if(pt_sms_info->format<0 || pt_sms_info->format>2)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    return lynq_send_sms(pt_sms_info->src_addr, pt_sms_info->format, pt_sms_info->sms_data, pt_sms_info->sms_data_len);
}

int qser_sms_addrxmsghandler(QSER_SMS_RxMsgHandlerFunc_t handlerPtr, void* contextPtr)
{
    if(NULL == handlerPtr)
    {
        return SMS_PARAM_ERR;
    }
  //  if(NULL == contextPtr)
  //  {
  //      return SMS_PARAM_ERR;
  //  }
    tmp = handlerPtr;
    pthread_t lynq_new_sms_tid = -1;
    int rt = pthread_create(&lynq_new_sms_tid, NULL, new_sms_thread_recv, NULL);
    if(rt < 0)
    {
        LYDBGLOG("qser_sms_addrxmsghandler pthread_create error!!!\n");
        return -1;
    }
    return SMS_OK;
}

int qser_sms_deletefromstorage(sms_client_handle_type  h_sms, QSER_sms_storage_info_t  *pt_sms_storage)
{
    if(NULL == pt_sms_storage)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    return lynq_delete_sms(pt_sms_storage->storage_idx);
}

int qser_sms_send_smspdu(sms_client_handle_type h_sms, QSER_wms_send_raw_message_data_t *raw_messagdata, QSER_wms_raw_send_resp_t *rawresp)
{
    if(NULL == raw_messagdata)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(NULL == rawresp)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    LYERRLOG("not support\n");
    return 0;
}

int qser_sms_getsmscenteraddress( sms_client_handle_type h_sms, QSER_sms_service_center_cfg_t *set_sca_cfg)
{
    if(NULL == set_sca_cfg)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    return lynq_get_smsc_address(set_sca_cfg->service_center_addr);
}

int qser_sms_setsmscenteraddress( sms_client_handle_type h_sms, QSER_sms_service_center_cfg_t *get_sca_cfg)
{
    if(NULL == get_sca_cfg)
    {
        LYERRLOG("input error\n");
        return SMS_PARAM_ERR;
    }
    if(h_sms == 0)
    {
        LYERRLOG("not init\n");
        return SMS_PARAM_ERR;
    }
    return lynq_set_smsc_address(get_sca_cfg->service_center_addr);
}

int qser_sms_getDatabasestatus()
{
    return(lynq_get_smsdatabase_status());
}
DEFINE_LYNQ_LIB_LOG(LYNQ_QSER_SMS)

