/*******************************************************
* 
* @brief: Add wifi api
* @details:  add liblynq-qser-wifi api
* @author:   wz.wang
* @date:     2024.3.15
* @version:  V1.0
* @copyright：Copyright (c) MobileTek
*
*********************************************/
#ifndef LYNQ_QSER_WIFI
#define LYNQ_QSER_WIFI

#ifdef __cplusplus
extern "C" {
#endif

#define LYNQ_WIFI_MAX_SCAN_INFO_CNT 30
typedef enum
{
	LYNQ_WIFI_WORK_MODE_MIN = -1,
	LYNQ_WIFI_WORK_MODE_AP0 = 0,  //2.4G single ap / ap+sta
	LYNQ_WIFI_WORK_MODE_AP1,  //5G single ap / ap+sta
	LYNQ_WIFI_WORK_MODE_MAX
} lynq_wifi_work_mode_e;

typedef enum {
	LYNQ_WIFI_AP_INDEX_MIN = -1,
	LYNQ_WIFI_AP_INDEX_AP0 = 0,  //2.4G
	LYNQ_WIFI_AP_INDEX_AP1,	 //5G
	LYNQ_WIFI_AP_INDEX_MAX
} lynq_wifi_ap_index_e;

typedef enum
{
	LYNQ_WIFI_MAC_ACL_RULE_MIN = -1,
	LYNQ_WIFI_MAC_ACL_RULE_NONE = 0,
	LYNQ_WIFI_MAC_ACL_RULE_WHITE,
	LYNQ_WIFI_MAC_ACL_RULE_BLACK,
	LYNQ_WIFI_MAC_ACL_RULE_MAX
} lynq_wifi_mac_acl_rule_e;

typedef enum {
	LYNQ_WIFI_EVENT_MIN = -1,
	LYNQ_WIFI_EVENT_ENABLE_STATUS = 0,
	LYNQ_WIFI_EVENT_DISABLE_STATUS,
	LYNQ_WIFI_EVENT_AP_STATION,
	LYNQ_WIFI_EVENT_AP_STA_STATUS,
	LYNQ_WIFI_EVENT_STA_STATUS,
	LYNQ_WIFI_EVENT_MAX,
} lynq_wifi_event_type_e;

typedef enum
{
	LYNQ_WIFI_MODE_MIN = -1,
	LYNQ_WIFI_MODE_80211B = 0,
	LYNQ_WIFI_MODE_80211BG,
	LYNQ_WIFI_MODE_80211BGN,
	LYNQ_WIFI_MODE_80211A,
	LYNQ_WIFI_MODE_80211AN,
	LYNQ_WIFI_MODE_80211AC,
	LYNQ_WIFI_MODE_80211BGNAX_2G,
	LYNQ_WIFI_MODE_80211ANAC, //5G
	LYNQ_WIFI_MODE_80211ANACAX_5G,
	LYNQ_WIFI_MODE_MAX
} lynq_wifi_mode_type_e;

typedef enum LYNQ_WIFI_BANDWIDTH_ENUM
{
	LYNQ_WIFI_BANDWIDTH_MIN = -1,
	LYNQ_WIFI_BANDWIDTH_HT20 = 0,
	LYNQ_WIFI_BANDWIDTH_HT40,
	LYNQ_WIFI_BANDWIDTH_HT80,
	LYNQ_WIFI_BANDWIDTH_MAX
} lynq_wifi_bandwidth_type_e;

typedef enum
{ 
	LYNQ_WIFI_AUTH_MIN = -1,
	LYNQ_WIFI_AUTH_OPEN = 0,
	LYNQ_WIFI_AUTH_WPA_PSK,
	LYNQ_WIFI_AUTH_WPA2_PSK, //AES
	LYNQ_WIFI_AUTH_WPA_WPA2_PSK_BOTH, //TKIP & AES
	LYNQ_WIFI_AUTH_WPA3_PSK, //AES
	LYNQ_WIFI_AUTH_WPA2_WPA3_PSK_BOTH, //AES
	LYNQ_WIFI_AUTH_MAX
} lynq_wifi_auth_e;

typedef enum {
	LYNQ_WIFI_AP_STATUS_NONE = 0,
	LYNQ_WIFI_AP_STATUS_IDLE, //or disable
	LYNQ_WIFI_AP_STATUS_ENABLING,
	LYNQ_WIFI_AP_STATUS_ENABLED,
	LYNQ_WIFI_AP_STATUS_DISABLING,
	LYNQ_WIFI_AP_STATUS_ERROR
} lynq_wifi_status_e;

typedef enum {
	LYNQ_WIFI_STATION_DISABLE = 0,    /* WiFi station is not enable */
	LYNQ_WIFI_STATION_CONNECTED,      /* WiFi station is connected hotspot */
	LYNQ_WIFI_STATION_DISCONNECTED    /* WiFi station is disconnect hotspot */
} lynq_wifi_station_status_e;

typedef enum
{
	LYNQ_WIFI_AUTH_WPA_PAIRWISE_MIN = -1,
	LYNQ_WIFI_AUTH_WPA_PAIRWISE_AUTO = 0, //TKIP & AES
	LYNQ_WIFI_AUTH_WPA_PAIRWISE_TKIP,
	LYNQ_WIFI_AUTH_WPA_PAIRWISE_AES,
	LYNQ_WIFI_AUTH_WPA_PAIRWISE_MAX
} lynq_wifi_auth_wpa_psk_e;

//pairwise,group_rekey is only used in get
typedef struct
{
	lynq_wifi_auth_e auth;
	lynq_wifi_auth_wpa_psk_e pairwise; 
	char passwd[64 + 1];
	int group_rekey; //in seconds
} lynq_wifi_ap_auth_t;

typedef struct
{
	lynq_wifi_status_e status;
	char ifname[32];
	char bssid[18];
}lynq_wifi_ap_status_t;

typedef struct
{
 	char ssid[33];
	lynq_wifi_auth_e auth; //only aic support wap3
	lynq_wifi_auth_wpa_psk_e pairwise;
	char passwd[64 + 1];
} lynq_wifi_sta_param_t;

typedef enum
{
	LYNQ_WIFI_STA_STATUS_NONE,
	LYNQ_WIFI_STA_STATUS_IDLE,
	LYNQ_WIFI_STA_STATUS_CONNECTING,
	LYNQ_WIFI_STA_STATUS_ASSOCIATED, //dhcping
	LYNQ_WIFI_STA_STATUS_CONNECTED,
	LYNQ_WIFI_STA_STATUS_DISCONNECTED, 
	LYNQ_WIFI_STA_STATUS_ERROR
} lynq_wifi_sta_status_e;

typedef enum
{
	LYNQ_WIFI_REASON_CODE_NONE,
	LYNQ_WIFI_REASON_CODE_WRONG_KEY,
	LYNQ_WIFI_REASON_CODE_AUTH_FAILED,
	LYNQ_WIFI_REASON_CODE_CONN_FAILED,
	LYNQ_WIFI_REASON_CODE_SET_FAILED,
	LYNQ_WIFI_REASON_CODE_DHCP_FAILED
} lynq_wifi_reason_code_e;

typedef struct
{
	char addr[16];
	char netmask[16];
	unsigned char subnet_bits; //255.255.255.0 is 24
	char gateway[16];
	char dnsp[16]; //primary DNS
	char dnss[16]; //secondary DNS
} lynq_wifi_net_addr_t;

typedef struct
{
	char addr[48];
	char prefix[48];
	unsigned char prefix_bits;
	char gateway[48];
	char dnsp[48]; //primary DNS
	char dnss[48]; //secondary DNS
} lynq_wifi_net_addr6_t;

typedef struct
{
	lynq_wifi_station_status_e sta_status;
	lynq_wifi_sta_status_e status;
	char ifname[32];
	char ap_bssid[18]; //cur ap mac
	//int rssi;
	unsigned char signal_level;
	unsigned char has_addr;
	lynq_wifi_net_addr_t addr; //(addr.s_addr)
	unsigned char has_addr6;
	lynq_wifi_net_addr6_t addr6; //
	lynq_wifi_reason_code_e reason_code;
} lynq_wifi_sta_status_t;

typedef struct
{
	char bssid[18];//mac
	char essid[33];
	int signal; //dbm
	unsigned char signal_level; //0-4, max 4
	int frequency; //Hz
	unsigned char channel; //1-13
	lynq_wifi_auth_e auth;
	lynq_wifi_auth_wpa_psk_e cipher;
}lynq_wifi_sta_scan_info_t;

typedef struct
{
	int cnt;
	lynq_wifi_sta_scan_info_t info[LYNQ_WIFI_MAX_SCAN_INFO_CNT];
}lynq_wifi_sta_scan_list_t;

typedef struct {
	unsigned long long	rx_packets;
	unsigned long long	rx_bytes;
	unsigned long long	rx_errors;
	unsigned long long	rx_dropped;
	unsigned long long	tx_packets;
	unsigned long long	tx_bytes;
	unsigned long long	tx_errors;
	unsigned long long	tx_dropped;
} lynq_wifi_pkt_stats_t;

typedef struct
{
    char addr[16]; 		/**< IPV4 address format string */
    char macaddr[18]; 	/**< MAC address, format: XX:XX:XX:XX:XX:XX */
    char name[20]; 		/**< hostname */
    char ifname[18]; 	/**< device name */
    int  uptime; 		/**< online time in sec */
} lynq_lanhost_t;

typedef struct
{
	int array_len;
    lynq_lanhost_t array[32];
} lynq_lanhost_ts;

typedef struct {
	lynq_wifi_event_type_e id;
	union {
	    /* the LYNQ_WIFI_ENABLE_STATUS or LYNQ_WIFI_DISABLE_STATUS event */
		lynq_wifi_status_e status;
		struct {
		    /* 
		     * If connected is true, the station is connected wifi hotspot.
		     * If connected is false, the station is disconnected wifi hotspot.
		     */
            int connected;
            char mac[18]; //mac connected to WiFi device
            char hostname[32]; //Name of the WiFi device
		} ap_sta_info;
		lynq_wifi_station_status_e sta_status;
		lynq_wifi_sta_status_t sta_status_all;
	};
} lynq_wifi_event_s;

typedef void (*lynq_wifi_event_handle)(lynq_wifi_event_s *event, void *arg);
typedef void (*lynq_wifi_event_handle_sta)(lynq_wifi_sta_scan_list_t *event);

int  qser_wifi_work_mode_set(lynq_wifi_work_mode_e type);
int  qser_wifi_work_mode_get(lynq_wifi_work_mode_e *type);
int  qser_wifi_enable(void);
int  qser_wifi_disable(void);
int  qser_wifi_ap_get_status(lynq_wifi_ap_index_e idx, lynq_wifi_ap_status_t *ap_stat);
int  qser_wifi_ap_acl_set(lynq_wifi_ap_index_e idx, lynq_wifi_mac_acl_rule_e acl_rule, char *mac_list);
int  qser_wifi_ap_acl_get(lynq_wifi_ap_index_e idx, lynq_wifi_mac_acl_rule_e *acl_rule, char *mac_list);
int  qser_wifi_ap_ssid_set(lynq_wifi_ap_index_e idx, const char *ssid);
int  qser_wifi_ap_ssid_get(lynq_wifi_ap_index_e idx, char *ssid);
int  qser_wifi_ap_ssid_hide_set(lynq_wifi_ap_index_e idx, bool hide);
int  qser_wifi_ap_ssid_hide_get(lynq_wifi_ap_index_e idx, bool *hide);
int  qser_wifi_ap_mode_set(lynq_wifi_ap_index_e idx, lynq_wifi_mode_type_e mode);
int  qser_wifi_ap_mode_get(lynq_wifi_ap_index_e idx, lynq_wifi_mode_type_e *mode);
int  qser_wifi_ap_bandwidth_set(lynq_wifi_ap_index_e idx, lynq_wifi_bandwidth_type_e bandwidth);
int  qser_wifi_ap_bandwidth_get(lynq_wifi_ap_index_e idx, lynq_wifi_bandwidth_type_e *bandwidth);
int  qser_wifi_ap_channel_set(lynq_wifi_ap_index_e idx, const char *country_code, int channel);
int  qser_wifi_ap_channel_get(lynq_wifi_ap_index_e idx, char *country_code, int *channel);
int  qser_wifi_ap_auth_set(lynq_wifi_ap_index_e idx, lynq_wifi_auth_e auth_mode, const char * auth_passwd);
int  qser_wifi_ap_auth_get(lynq_wifi_ap_index_e idx, lynq_wifi_auth_e *auth_mode, char * auth_passwd);
int  qser_wifi_ap_auth_get_s(lynq_wifi_ap_index_e idx, lynq_wifi_ap_auth_t *auth_mode);
int  qser_wifi_ap_max_sta_set(lynq_wifi_ap_index_e idx, int max_sta_num);
int  qser_wifi_ap_max_sta_get(lynq_wifi_ap_index_e idx, int *max_sta_num);
int  qser_wifi_lanhost_get_list(lynq_lanhost_ts *lynq_arrays);
int  qser_wifi_get_ap_pkt_stats(lynq_wifi_ap_index_e idx, lynq_wifi_pkt_stats_t *pkt_stat);
int  qser_wifi_ap_start(lynq_wifi_ap_index_e idx);
int  qser_wifi_ap_stop(lynq_wifi_ap_index_e idx);
int  qser_wifi_ap_restart(lynq_wifi_ap_index_e idx);
int  qser_wifi_register_handle(lynq_wifi_event_handle event_handle, lynq_wifi_event_handle_sta event_handle_sta, void *arg);
int  qser_wifi_sta_param_set(lynq_wifi_sta_param_t *param_stat);
int  qser_wifi_sta_param_get(lynq_wifi_sta_param_t *param_stat);
int  qser_wifi_sta_get_status(lynq_wifi_sta_status_t *status_stat);
int  qser_wifi_get_sta_pkt_stats(lynq_wifi_pkt_stats_t *pkt_stat);
int  qser_wifi_sta_start_scan(void);
int  qser_wifi_sta_start(void);
int  qser_wifi_sta_stop(void);




#ifdef __cplusplus
}
#endif
#endif

