/*******************************************************
* 
* @brief:    none
* @details:      Add  wakealrm and poweralarm api code 
* @author:    l.yang
* @date:    2023.8.17
* @version:    V1.0
* @copyright：    Copyright (c) MobileTek 
*
*********************************************/

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<stdbool.h>
#include<log/log.h>
#include "liblog/lynq_deflog.h"
#include <include/libpoweralarm.h>
#include <pthread.h>
#include <string.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "sc_rtc_timer.h"

#define USER_LOG_TAG "LYNQ_POWERALARM"

#define MIN_TIME    1
#define MAX_TIME    268435456


//typedef int (*sc_rtc_timer_exp_cb)(unsigned int src_id, int rtc_id);
typedef int (*lynq_wakealarm_add_cb)(unsigned int src_id, int rtc_id);

/*
extern int sc_rtc_timer_init(void);
extern int sc_rtc_timer_uninit(void );
extern int sc_rtc_timer_add(int srcid, int rtc_id, unsigned long ulSec, sc_rtc_timer_exp_cb rtc_notify);
extern int sc_rtc_timer_del(int srcid, int rtc_id);

extern int sc_rtc_timer_add_utc(int srcid, int rtc_id, struct tm *utc_sec, int wakeup, sc_rtc_timer_exp_cb rtc_notify);

extern int sc_rtc_get_poweroff_alarm_modid(int src_id,char *name);

extern int sc_rtc_add_poweroff_alarm(int srcid, int alarm_modid, int rtc_id, struct tm *utc_sec, sc_rtc_timer_exp_cb rtc_notify);

*/

/*****************************************
* @brief:lynq_rtc_service_init
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success src_id, failed -1
* @todo:
* @see:NA
* @warning:
*****************************************/
int lynq_rtc_service_init(void)
{
    int src_id = -1;
    
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    
    src_id = sc_rtc_timer_init();
    if (src_id <= 0)
    {
        LYERRLOG("rtc_timer_init fail!");
        return -1;
    }
    return src_id;

}

/*****************************************
* @brief:lynq_rtc_service_init
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success src_id, failed -1
* @todo:
* @see:NA
* @warning:
*****************************************/
int lynq_rtc_service_deinit(void)
{
    int ret = -1;
    ret = sc_rtc_timer_uninit();
    if(ret != 0)
    {
        LYINFLOG("Deinit failed!!!");
        return -1;
    }
    
    return 0;

}


/*****************************************
* @brief:Set wakealarm time
* @param count [IN]:char *buffer,int src_id ...
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:
* @see:NA
* @warning:
******************************************/
ssize_t wakealarm(char *buffer,int src_id,int rtc_id,lynq_wakealarm_add_cb wakealarm_notify )
{
    unsigned long  time_sec = 0;
    int ret = 0;
    char *buf_bak = buffer;
    time_t tmp_time = 0;

    struct tm *wake_arlarm = NULL;
    tmp_time = time(NULL);
    localtime(&tmp_time);
    
    if(buffer == NULL)
    {
        LYINFLOG("Bad input parameter,exit!!!!");
        return -1;
    }

    while(*buffer != '\0' )
    {
        if((*buffer < '0') || (*buffer > '9'))
        {
            LYERRLOG("Illeagel input buffer , there is invalid character!!!!");
            return -1;
        }
        else
        {
            buffer++;
        }
    }
   

    buffer = buf_bak;
    time_sec = strtoul(buffer,NULL,10);
    if(time_sec < MIN_TIME || time_sec > MAX_TIME || errno == ERANGE)
    {
        LYERRLOG("Illeagle input: too large or too small !!!");
        return -1;
    }

    tmp_time += time_sec;
    wake_arlarm = localtime(&tmp_time);
    
    LYINFLOG("Set  wakealarm   %lu seconds ",time_sec);

    ret = sc_rtc_timer_add_utc(src_id, rtc_id,wake_arlarm,0,wakealarm_notify);
    if(ret < 0)
    {
        LYINFLOG("Add  rtc timer failed!!!!");
        return -1;
    }
    
    LYINFLOG("Set wakealarm success !!!");

    return 0;

}


/*****************************************
* @brief:set poweralarm time 
* @param count [IN]:char *buffer, int srcid
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:
* @see:NA
* @warning:
******************************************/
ssize_t poweralarm(char *buffer,int src_id )
{

    unsigned long  time_sec = 0;
    int ret = 0;
    char *buf_bak = buffer;
    
    int alarmid = 0;
    char username[8] = "user";
    time_t tmp_time = 0;
    struct tm *power_arlarm = NULL;
    tmp_time = time(NULL);
    localtime(&tmp_time);
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
   
    if(buffer == NULL)
    {
        LYERRLOG("Bad input parameter,exit!!!!");
        return -1;
    }
    
    while(*buffer != '\0' )
    {
        if(( *buffer < '0' )|| ( *buffer > '9'))
        {
            LYERRLOG("Illeagel input buffer , there is invalid character!!!!");
            return -1;
        }
        else
        {
            buffer++;
        }
    }
    

    buffer = buf_bak;
    time_sec = strtoul(buffer,NULL,10);

    tmp_time += time_sec;
    power_arlarm = localtime(&tmp_time);
    
    if(time_sec < MIN_TIME || time_sec > MAX_TIME || errno == ERANGE)
    {
        LYERRLOG("Illeagle input: too large or too small !!!");
        return -1;
    }
    
    LYINFLOG("Set poweralarm %lu seconds",time_sec);

    
    alarmid = sc_rtc_get_poweroff_alarm_modid(src_id, username);
    if(alarmid < 0)
    {
        LYERRLOG("Get poweroff alarm id failed !!!");
        return -1;
    }

    ret = sc_rtc_add_poweroff_alarm(src_id, alarmid, 0, power_arlarm, NULL);
    if(ret < 0)
    {
        LYERRLOG("Set power alarm failed !!!");
        return -1;
    }
    LYINFLOG("Set power alarm success !!!!");

    return 0;
    
}

/**********************************************
* @brief:cancel_wakealarm,
* @param count [IN]:int src_id, int rtc_id
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:
* @see:NA
* @warning:
********************************************/
ssize_t cancel_wakealarm(int src_id, int rtc_id)
{
    int ret = 0;

    LYINFLOG("Enter cancel_wakealarm ");
    ret = sc_rtc_timer_del(src_id, rtc_id);
    if(ret < 0)
    {
        LYERRLOG("Del wakealarm failed!!!");
        return -1;
    }
    LYINFLOG("Cancel success  ");
    return 0;
    
}


/*****************************************
* @brief:lynq_set_poweralarm
* @param count [IN]:unsigned long time_sec , int src_id
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:
* @see:NA
* @warning:
******************************************/
int  lynq_set_poweralarm(unsigned long time_sec,int src_id)
{

    int ret = 0;
    int alarmid = 0;
    char username[8] = "user";
    
    time_t tmp_time = 0;
    struct tm *power_arlarm = NULL;
    tmp_time = time(NULL);
    localtime(&tmp_time);

    
    tmp_time += time_sec;
    power_arlarm = localtime(&tmp_time);
   
    if(time_sec < MIN_TIME || time_sec > MAX_TIME )
    {
        LYERRLOG("Illeagle input: too large or too small !!!");
        return -1;
    }

    LYINFLOG("lynq_set_poweralarm  %lu seconds",time_sec);


    alarmid = sc_rtc_get_poweroff_alarm_modid(src_id, username);
    if(alarmid < 0)
    {
        LYERRLOG("Get poweroff alarm id failed !!!");
        return -1;
    }

    ret = sc_rtc_add_poweroff_alarm(src_id, alarmid, 0, power_arlarm, NULL);
    if(ret < 0)
    {
        LYERRLOG("Set power alarm failed !!!");
        return -1;
    }
    
    LYINFLOG("Set power alarm success !!!!");
    
    return 0;
    

}


/*****************************************
* @brief:lynq_set_wakealarm
* @param count [IN]:unsigned long  time_sec,....
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:
* @see:NA
* @warning:
******************************************/
int lynq_set_wakealarm(unsigned long time_sec,int src_id,int rtc_id,lynq_wakealarm_add_cb wakealarm_notify )
{
    int ret = 0;
    
    time_t tmp_time = 0;
    struct tm *wake_arlarm = NULL;
    tmp_time = time(NULL);
    localtime(&tmp_time);
        
    if(time_sec < MIN_TIME || time_sec > MAX_TIME)
    {
        LYERRLOG("Illeagle input: too large or too small !!!");
        return -1;
    }
    
    LYINFLOG("lynq_set_wakealarm   %lu seconds ",time_sec);

    tmp_time += time_sec;
    wake_arlarm = localtime(&tmp_time);
    LYINFLOG("Set  wakealarm   %lu seconds ",time_sec);
    
    ret = sc_rtc_timer_add_utc(src_id, rtc_id,wake_arlarm,0,wakealarm_notify);
    if(ret < 0)
    {
        LYINFLOG("Add  rtc timer failed!!!!");
        return -1;
    }
    
    LYINFLOG("Set wakealarm success !!!");
    
    return 0;

}


DEFINE_LYNQ_LIB_LOG(LYNQ_POWERALARM)

#ifdef __cplusplus
}
#endif

