
#include "cwmp/periodic.h"
#include "cwmp/cwmp.h"
#include "cwmp/log.h"
#include "soft_timer.h"

extern cwmp_t *g_cwmp;

#define PERIODIC_INFORM_TIMER   (30)

#define PERIODIC_ENABLE_INI_TAG       "periodic:enable"
#define PERIODIC_INTERVAL_INI_TAG     "periodic:interval"


static void *periodic_inform_timer(void *arg)
{
    FUNCTION_TRACE();

	cwmp_t *cwmp = g_cwmp;
	
    cwmp_log_info("push begin");

    cwmp->new_request = CWMP_YES;
    cwmp_event_set_value(g_cwmp, INFORM_PERIODIC, 1, 0, 0, 0, 0);

    cwmp_log_info("push ok");

    return NULL;
}


int cwmp_reset_periodic_inform(cwmp_t * cwmp)
{
    long result = 0;
	
	periodic_info_st * pperiodic = &(cwmp->periodic_info);

	cwmp_log_info("Enable is: %d, interval:%d", pperiodic->PeriodicInformEnable, pperiodic->PeriodicInformInterval);

	if(pperiodic->PeriodicInformEnable)
	{
	
	    sc_timer_delete(PERIODIC_INFORM_TIMER);
	    result = sc_timer_create(PERIODIC_INFORM_TIMER, 0, pperiodic->PeriodicInformInterval*1000, periodic_inform_timer, &cwmp);
	}
	
	return result;
}


int cwmp_clean_periodic_inform(cwmp_t * cwmp)
{
    sc_timer_delete(PERIODIC_INFORM_TIMER);

	return CWMP_OK;
}


int get_periodic_info_enable()
{
    int cwmp_enable = 0;
    cwmp_enable = cwmp_conf_get_int(PERIODIC_ENABLE_INI_TAG);

	if(0 == cwmp_enable)
	{
	    return 0;
	}
	else
	{
	    return 1;
	}

}


int get_periodic_info_interval()
{
    int interval = 0;
	
	interval = cwmp_conf_get_int(PERIODIC_INTERVAL_INI_TAG);

    if(0 != interval)
    {
        return interval;
    }
	else
	{
	    return 60;
	}		
}



int set_periodic_info_enable(const char* value)
{
    return cwmp_conf_set(PERIODIC_ENABLE_INI_TAG, value);
}


int set_periodic_info_interval(const char* value)
{
    return cwmp_conf_set(PERIODIC_INTERVAL_INI_TAG, value);	
}



int update_periodic_info_enable(cwmp_t* cwmp)
{
    periodic_info_st *pperiodic_info = &(cwmp->periodic_info);

	pperiodic_info->PeriodicInformEnable = get_periodic_info_enable();

	return CWMP_OK;
}



int update_periodic_info_interval(cwmp_t* cwmp)
{
    periodic_info_st *pperiodic_info = &(cwmp->periodic_info);

    pperiodic_info->PeriodicInformInterval = get_periodic_info_interval();
	
	return CWMP_OK;
}



int ini_periodic_info(cwmp_t* cwmp)
{
    update_periodic_info_enable(cwmp);

    update_periodic_info_interval(cwmp);

	return CWMP_OK;
}



