#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include "../../include/message.h"
#include <netdb.h>
#include "../zte_web_interface.h"
#include "../zte_web_sms.h"
#include "../zte_web_cjson.h"
#include "cfg_api.h"
#include <ctype.h>
#include <float.h>


/**************************************************************************
* 궨
**************************************************************************/

#define TRAFFIC_PLATFORM   "mifi"
#define CX_360_SERVER_IP_NV  "traffic_server_ip"
#define CX_360_DEFAULT_SERVER_IP  "223.202.20.216"
#define CX_360_PORT   80
#define CX_360_SERVER_URL  "cx.shouji.360.cn"
#define TRAFFIC_SMS_QUERY_URL  "http://cx.shouji.360.cn/smscode/index.php"
#define TRAFFIC_SMS_PARSE_URL  "http://cx.shouji.360.cn/parsesms_v2/index.php"

#define TRAFFIC_MAX_REQUEST   3
#define GET_TRAFFIC_SUCCESS   100

//for WEBUI read
#define NV_TRAFFIC_USED_OFFSET_DATA   "traffic_alined_delta"
#define NV_TRAFFIC_PROCESS_STATE   "is_traffic_alining"

#define NV_TRAFFIC_RECV_SMS_ID   "traffic_recv_sms_id"
#define NV_TRAFFIC_SMS_SEND_TIME   "traffic_sms_send_time"
#define NV_TRAFFIC_SMS_NUMBER   "traffic_sms_number"
#define NV_TRAFFIC_OVER_TIME   "traffic_over_time"
#define NV_TRAFFIC_END_TIME   "traffic_end_time"
#define NV_TRAFFIC_STATE   "traffic_process_state"
#define NV_TRAFFIC_RESULT  "traffic_process_result"
#define NV_TRAFFIC_GLOBAL_TOTAL   "traffic_global_total"
#define NV_TRAFFIC_GLOBAL_USED   "traffic_global_used"
#define NV_TRAFFIC_LOCAL_TOTAL   "traffic_local_total"
#define NV_TRAFFIC_LOCAL_USED   "traffic_local_used"
#define NV_TRAFFIC_PROVINCEINNER_TOTAL     "traffic_provinceinner_total"
#define NV_TRAFFIC_PROVINCEINNER_USED       "traffic_provinceinner_used"
#define NV_TRAFFIC_PROVINCEOUTTER_TOTAL   "traffic_provinceoutter_total"
#define NV_TRAFFIC_PROVINCEOUTTER_USED     "traffic_provinceoutter_used"
#define TIME_ONE_DAY_INTERVAL             (60*60*24)   /* 1 DAY */
#define TRAFFIC_SMS_MEM_STORE_IN_DB    10

#define TRAFFIC_FIRST_REQUEST_SEND_LEN 500
#define TRAFFIC_SECOND_REQUEST_SEND_LEN 4000
#define TRAFFIC_ENCODE_HTTP_HEAD_LEN 3500
#define TRAFFIC_ENCODE_SMS_UTF8_LEN 3000

/**************************************************************************
* ݽṹ
**************************************************************************/

/*У׼״̬*/
typedef enum _traffic_process_state_type_t {
	TRAFFIC_STATE_IDLE,
	TRAFFIC_STATE_FIRST_REQUEST,
	TRAFFIC_STATE_SEND_SMS,
	TRAFFIC_STATE_WAIT_RECV_SMS,
	TRAFFIC_STATE_SECOND_REQUEST,
	TRAFFIC_STATE_OVER
} traffic_process_state_type_t;


typedef struct _TRAFFIC_FIRST_PARSE {
	char traffic_number[20];
	char traffic_code[20];
} TRAFFIC_FIRST_PARSE;

typedef struct _TRAFFIC_SECOND_PARSE {
	char code[10];
	char msg[50];
	char local_total[30];
	char local_used[30];
	char local_balance[30];
	char global_total[30];
	char global_used[30];
	char global_balance[30];
	char provinceinner_total[30];
	char provinceinner_used[30];
	char provinceinner_balance[30];
	char provinceoutter_total[30];
	char provinceoutter_used[30];
	char provinceoutter_balance[30];
} TRAFFIC_SECOND_PARSE;

typedef struct _TRAFFIC_REQUEST_PARAM {
	char operator[60];
	char brand[60];
	char province[50];
	char city[50];
	char platform[30];
	char imsi[50];
	char version[50];
} TRAFFIC_REQUEST_PARAM;


typedef enum _traffic_result_type_t {
	TRAFFIC_RESULT_FAIL = -1,
	TRAFFIC_RESULT_OK,
	TRAFFIC_RESULT_CONTINUE,
	TRAFFIC_NOT_SELECT_SIM_PROVINCE,
	TRAFFIC_NOT_ENABLE_SWITCH,
	TRAFFIC_NOT_CONNECT_NET,
	TRAFFIC_NOT_ENOUGH_SMS_MEMORY,
} traffic_result_type_t;

/**************************************************************************
* ȫֱ
**************************************************************************/

int g_traffic_sock_fd = -1;
int g_traffic_select_offset_time = 0;
int g_traffic_select_retry_count = 0;
int g_traffic_302reponse_retry_count = 0;

TRAFFIC_FIRST_PARSE  traffic_first_parse;
char * g_traffic_sms_body;
long g_traffic_last_time = 0;
int g_traffic_process_state = TRAFFIC_STATE_OVER;

pthread_mutex_t g_web_getaddrinfo_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t g_web_getnameinfo_mutex = PTHREAD_MUTEX_INITIALIZER;

/**************************************************************************
* 
**************************************************************************/

extern void zte_traffic_handle();
extern void zte_traffic_cfg_init();
extern void zte_traffic_calculate_offset(unsigned long long used);

/**************************************************************************
* Ҫʵֺ
**************************************************************************/
void zte_traffic_set_end_time(long now_time)
{
	//רΪWEBUIʾʱֵ
	struct tm ptm = {0};
	char buf[NV_ITEM_STRING_LEN_50] = {0};

	//ptm = localtime(&now_time);
	localtime_r(&now_time, &ptm);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic]traffic_set_end_time:Y->%d;M->%d;D->%d\n", ptm.tm_year, ptm.tm_mon, ptm.tm_mday);

	//if(ptm != NULL)
	{
		snprintf(buf,50, "%d-%02d-%02d_%02d:%02d:%02d", ptm.tm_year + 1900, ptm.tm_mon + 1, ptm.tm_mday, ptm.tm_hour, ptm.tm_min, ptm.tm_sec);
		sc_cfg_set(NV_TRAFFIC_END_TIME, buf);
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_set_end_time = %s\n", buf);
}

void zte_traffic_set_process_result(int result)
{
	long now_time = 0;
	char now_time_str[NV_ITEM_STRING_LEN_20] = {0};

	if (result == TRAFFIC_RESULT_FAIL) {
		sc_cfg_set(NV_TRAFFIC_RESULT, "failure");
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_set_process_result = fail \r\n");
	} else {
		sc_cfg_set(NV_TRAFFIC_RESULT, "success");
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_set_process_result = success \r\n");
	}

	time(&now_time);//Ϊλ
	sprintf(now_time_str, "%ld", now_time);
	sc_cfg_set(NV_TRAFFIC_OVER_TIME, now_time_str);
	sc_cfg_set(NV_TRAFFIC_PROCESS_STATE, "no");
	zte_traffic_set_end_time(now_time);
}

void zte_traffic_set_process_state(int state)
{
	char _state[NV_ITEM_STRING_LEN_50] = {0};

	g_traffic_process_state = state;

	if (state == TRAFFIC_STATE_FIRST_REQUEST) {
		strncpy(_state, "TRAFFIC_STATE_FIRST_REQUEST", sizeof(_state) - 1);
	} else if (state == TRAFFIC_STATE_SEND_SMS) {
		strncpy(_state, "TRAFFIC_STATE_SEND_SMS", sizeof(_state) - 1);
	} else if (state == TRAFFIC_STATE_WAIT_RECV_SMS) {
		strncpy(_state, "TRAFFIC_STATE_WAIT_RECV_SMS", sizeof(_state) - 1);
	} else if (state == TRAFFIC_STATE_SECOND_REQUEST) {
		strncpy(_state, "TRAFFIC_STATE_SECOND_REQUEST", sizeof(_state) - 1);
	} else if (state == TRAFFIC_STATE_OVER) {
		strncpy(_state, "TRAFFIC_STATE_OVER", sizeof(_state) - 1);
	} else if (state == TRAFFIC_STATE_IDLE) {
		strncpy(_state, "TRAFFIC_STATE_IDLE", sizeof(_state) - 1);
	} else {
		strncpy(_state, "TRAFFIC_STATE_ERROR", sizeof(_state) - 1);
	}

	if (strlen(_state) > 0) {
		sc_cfg_set(NV_TRAFFIC_STATE, _state);
	}
}

int zte_traffic_get_process_state()
{
	return g_traffic_process_state;
}


void zte_traffic_close_socket()
{
	if (g_traffic_sock_fd != -1) {
		close(g_traffic_sock_fd);
		g_traffic_sock_fd = -1;
	}
}

unsigned long  zte_traffic_get_server_ip()
{
	struct addrinfo hints           = { 0 };
	struct addrinfo *result         = NULL;
	struct addrinfo *result_pointer = NULL;

	int           ret   = 0;
	unsigned long ul_ip = (unsigned long)inet_addr(CX_360_DEFAULT_SERVER_IP);

	hints.ai_family   = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags    = AI_CANONNAME;
	hints.ai_protocol = 0;

	pthread_mutex_lock(&g_web_getaddrinfo_mutex);
	ret = getaddrinfo(CX_360_SERVER_URL, NULL, &hints, &result);
	pthread_mutex_unlock(&g_web_getaddrinfo_mutex);

	if (ret != 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic_calibration] error in getaddrinfo: %s, use default ip: %s \n", gai_strerror(ret), CX_360_DEFAULT_SERVER_IP);
		return ul_ip;
	}

	for (result_pointer = result; result_pointer != NULL; result_pointer = result_pointer->ai_next) {
		char hostname[1025] = {0};

		if (result_pointer->ai_family == AF_INET6) {
			continue;
		}

		pthread_mutex_lock(&g_web_getnameinfo_mutex);
		ret = getnameinfo(result_pointer->ai_addr, result_pointer->ai_addrlen, hostname, sizeof hostname, NULL, 0, NI_NUMERICHOST);
		pthread_mutex_unlock(&g_web_getnameinfo_mutex);

		if (ret != 0) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic_calibration] error in getnameinfo: %s.\n", gai_strerror(ret));
			continue;
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[traffic_calibration] Server ip = %s.\n", hostname);
		ul_ip = (unsigned long)inet_addr(hostname);
		break;
	}

	freeaddrinfo(result);
	return ul_ip;
}


char *zte_traffic_get_brand(char *operator)
{
	if (0 == strcmp(operator, "China Mobile") || 0 == strcmp(operator, "CHINA MOBILE")) {
		return "\%e7\%a5\%9e\%e5\%b7\%9e\%e8\%a1\%8c";
	} else if (0 == strcmp(operator, "CHINA UNICOM")) {
		return "\%e8\%81\%94\%e9\%80\%9a3G";
	} else {
		return "\%e7\%94\%b5\%e4\%bf\%a1";
	}
}

char *zte_traffic_get_operator(char *operator)
{
	if (0 == strcmp(operator, "China Mobile") || 0 == strcmp(operator, "CHINA MOBILE")) {
		return "\%e4\%b8\%ad\%e5\%9b\%bd\%e7\%a7\%bb\%e5\%8a\%a8";
	} else if (0 == strcmp(operator, "CHINA UNICOM")) {
		return "\%e4\%b8\%ad\%e5\%9b\%bd\%e8\%81\%94\%e9\%80\%9a";
	} else {
		return "\%e4\%b8\%ad\%e5\%9b\%bd\%e7\%94\%b5\%e4\%bf\%a1";
	}
}

int zte_traffic_isdigit(char *srcStr, int len)
{
	int i = 0;
	int flag = 0;
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_isdigit....srcStr =%s \n", srcStr);
	for (i = 0; i < len; i++) {
		if (srcStr[i] >= '0' && srcStr[i] <= '9') {
			continue;
		} else {
			flag = -1;
			break;
		}
	}

	if (flag == 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_isdigit....content_length is digit \n");
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_isdigit....content_length is not digit, error!!!\n");
	}
	return flag;
}

int zte_traffic_parse_response_content(char *srcStr, char *content, int max_len)
{
	char *p1 = NULL;
	char *p2 = NULL;
	int len = 0;
	char content_length[NV_ITEM_STRING_LEN_10] = {0};

	p1 = strstr(srcStr, "Content-Length");
	if (p1 != NULL) {
		len = strlen("Content-Length: ");
		p1 = p1 + len;

		p2 = strchr(p1, '\r');
		len = p2 - p1;
		if (len >= NV_ITEM_STRING_LEN_10) {
			return TRAFFIC_RESULT_FAIL;
		}

		memcpy(content_length, p1, len);
		content_length[9]=0;
		if (-1 == zte_traffic_isdigit(content_length, strlen(content_length))) {
			return TRAFFIC_RESULT_FAIL;
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_parse_content....content_length = %s \n", content_length);
		p1 = strchr(srcStr, '{');
		if (p1 == NULL) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_parse_content....not correct ,no { ,fail, return \n");
			return TRAFFIC_RESULT_FAIL;
		}
		int tmplen = atoi(content_length);
		if (tmplen >= max_len) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_parse_content....content_length > max_len size\n");
			memcpy(content, p1, max_len - 1);
		} else {
			memcpy(content, p1, tmplen);
		}
	} else {
		p1 = strchr(srcStr, '{');
		if (p1 == NULL) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_parse_content....not Content-Length and no { ,fail, return \n");
			return TRAFFIC_RESULT_FAIL;
		}

		p2 = strrchr(srcStr, '}');
		if (p2 == NULL) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_parse_content....not Content-Length and no } ,fail, return \n");
			return TRAFFIC_RESULT_FAIL;
		}

		len = p2 - p1 + 1;
		if (len >= max_len) {
			slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_parse_content....len > max_len size\n");
			memcpy(content, p1, max_len - 1);
		} else {
			memcpy(content, p1, len);
		}
	}

	return TRAFFIC_RESULT_OK;
}


int zte_traffic_parse_response_state(char *srcStr)
{
	char *p1 = NULL;
	char *p2 = NULL;
	char state[NV_ITEM_STRING_LEN_10] = {0};
	int len = 0;
	int i = 0;

	while (srcStr[i] == ' ') {
		i++;
	}

	if (i > 0) {
		srcStr = srcStr + i;
	}

	i = 0;
	p1 = strchr(srcStr, ' ');
	if (p1 == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	while (p1[i] == ' ') {
		i++;
	}

	p1 = p1 + i;
	p2 = strchr(p1, ' ');
	if (p2 == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	len = p2 - p1;

	if ((len > 0) && (len <= sizeof(state) - 1)) {
		memcpy(state, p1, len);
	} else {
		return TRAFFIC_RESULT_FAIL;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_parse_response_state....state = %s \n", state);
	return atoi(state);
}

void zte_traffic_get_request_param(TRAFFIC_REQUEST_PARAM *request, int type)
{
	char buf[NV_ITEM_STRING_LEN_150] = {0};
	char network[NV_ITEM_STRING_LEN_50] = {0};
	char province[NV_ITEM_STRING_LEN_50] = {0};

	sc_cfg_get("network_provider", network, sizeof(network));
	sc_cfg_get(NV_DATA_TRAFFIC_SIM_PROVINCE, province, sizeof(province));
	strncpy(request->operator, zte_traffic_get_operator(network), sizeof(request->operator) - 1);
	strncpy(request->brand, zte_traffic_get_brand(network), sizeof(request->brand) - 1);

	URLEncode(province, strlen(province), buf, sizeof(buf));
	strncpy(request->province, buf, sizeof(request->province) - 1);
	strncpy(request->city, buf, sizeof(request->city) - 1);
	strncpy(request->platform, "\%6d\%69\%66\%69", sizeof(request->platform) - 1);

	if (type == 1) {
		sc_cfg_get("sim_imsi", (request->imsi), sizeof(request->imsi));
		sc_cfg_get("cr_version", (request->version), sizeof(request->version));
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_get_request_param, imsi = %s, version=%s \n", request->imsi, request->version);

	}
}

int zte_traffic_first_encode_request_url(char *url, int url_len)
{
	TRAFFIC_REQUEST_PARAM request = {0};
	char buf[NV_ITEM_STRING_LEN_50] = {0};

	sc_cfg_get("network_provider", buf, sizeof(buf));
	if (strlen(&buf) == 0 || url == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	zte_traffic_get_request_param(&request, 0);

	strncat(url, TRAFFIC_SMS_QUERY_URL, url_len -1);
	strncat(url, "?", url_len - strlen(url) - 1);
	strncat(url, "operator=", url_len - strlen(url) - 1);
	strncat(url, request.operator, url_len - strlen(url) - 1);
	strncat(url, "&", url_len - strlen(url) - 1);
	strncat(url, "brand=", url_len - strlen(url) - 1);
	strncat(url, request.brand, url_len - strlen(url) - 1);
	strncat(url, "&", url_len - strlen(url) - 1);
	strncat(url, "province=", url_len - strlen(url) - 1);
	strncat(url, request.province, url_len - strlen(url) - 1);
	strncat(url, "&", url_len - strlen(url) - 1);
	strncat(url, "city=", url_len - strlen(url) - 1);
	strncat(url, request.city, url_len - strlen(url) - 1);
	strncat(url, "&", url_len - strlen(url) - 1);
	strncat(url, "platform=", url_len - strlen(url) - 1);
	strncat(url, request.platform, url_len - strlen(url) - 1);

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] first url = %s!\n", url);
	return TRAFFIC_RESULT_OK;
}


int  zte_traffic_first_encode_http_head(char *head, int head_len)
{
	char url[NV_ITEM_STRING_LEN_200 * 2] = {0};
	char ip[NV_ITEM_STRING_LEN_50] = {0};

	if (head == NULL || head_len == 0) {
		return TRAFFIC_RESULT_FAIL;
	}

	if (TRAFFIC_RESULT_FAIL == zte_traffic_first_encode_request_url(&url, NV_ITEM_STRING_LEN_200 * 2)) {
		return TRAFFIC_RESULT_FAIL;
	}

	sc_cfg_get(CX_360_SERVER_IP_NV, ip, sizeof(ip));
	strncat(head, "GET ", head_len-1);
	strncat(head, url, head_len-strlen(head)-1);
	strncat(head, " HTTP/1.1\r\n", head_len-strlen(head)-1);
	//strcat(head, "Accept-Language: zh-cn\r\n");
	//strcat(head, "Accept: application/json, text/html, text/*, */*\r\n");
	//strcat(head, "Accept-Encoding: x-gzip,gzip, deflate\r\n");
	//strcat(head, "Accept-charset: utf-8; q=0.5,*;q=0.5\r\n");
	strncat(head, "Host: ", head_len-strlen(head)-1);
	strncat(head, &ip, head_len-strlen(head)-1);
	strncat(head, "\r\n", head_len-strlen(head)-1);
	strncat(head, "Accept: */*\r\n", head_len-strlen(head)-1);
	strncat(head, "Connection: Keep-Alive\r\n", head_len-strlen(head)-1);
	//strcat(head, "Cache-Control: no-cache\r\n");
	strncat(head, "\r\n", head_len-strlen(head)-1);

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] first. http_head: %s \n", head);
	return TRAFFIC_RESULT_OK;
}




/*******
*{"charge_code":"YE","charge_number":"10086","traffic_code":"1091",
    "traffic_number":"10086","fenzhong_code":"1091","fenzhong_number":"10086",
"duanxin_code":"1091","duanxin_number":"10086","sp_code":"0000","sp_number":"10086"}
*/
int zte_traffic_first_parse_json(char *srcStr)
{
	cJSON *root = NULL;
	cJSON *object = NULL;
	memset(&traffic_first_parse, 0, sizeof(TRAFFIC_FIRST_PARSE));
	root = cJSON_Parse(srcStr);
	if (root == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] first.. traffic_first_parse_json, root == NULL fail \n");
		return TRAFFIC_RESULT_FAIL;
	}

	object = cJSON_GetObjectItem(root, "traffic_code");
	if (object == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] first.. traffic_first_parse_json, traffic_code == NULL fail \n");
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}
	strncpy(traffic_first_parse.traffic_code, object->valuestring, sizeof(traffic_first_parse.traffic_code) - 1);

	object = cJSON_GetObjectItem(root, "traffic_number");
	if (object == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] first.. traffic_first_parse_json, traffic_number == NULL fail \n");
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}
	strncpy(traffic_first_parse.traffic_number, object->valuestring, sizeof(traffic_first_parse.traffic_number) - 1);
	cJSON_Delete(root);
	traffic_first_parse.traffic_code[19]=0;
	traffic_first_parse.traffic_number[19]=0;
	if (strlen(traffic_first_parse.traffic_code) == 0 || strlen(traffic_first_parse.traffic_number) == 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] web_traffic_parse_json_first...invalid data fail \n");
		return TRAFFIC_RESULT_FAIL;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_parse_json_first....traffic_code = %s \n", traffic_first_parse.traffic_code);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_parse_json_first....traffic_number = %s \n", traffic_first_parse.traffic_number);
	return TRAFFIC_RESULT_OK;
}


int zte_traffic_first_parse_response(char *srcStr)
{
	char *p1 = NULL;
	char *p2 = NULL;

	int len = 0;
	char data[500] = {0};
	int state = 0;

	if (srcStr == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	state = zte_traffic_parse_response_state(srcStr);
	if (state != 200) {
		if (state == 302) {
			if (g_traffic_302reponse_retry_count < TRAFFIC_MAX_REQUEST) {
				g_traffic_302reponse_retry_count ++;
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_parse_response..state = 302,  retry_count  = %d, continue\n", g_traffic_302reponse_retry_count);
				return TRAFFIC_RESULT_CONTINUE;
			}
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_parse_response..state = %d, fail\n", state);
		return TRAFFIC_RESULT_FAIL;
	}

	state = zte_traffic_parse_response_content(srcStr, &data, sizeof(data));
	if (state == TRAFFIC_RESULT_FAIL) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_first_parse_response..parse_content  fail\n");
		return TRAFFIC_RESULT_FAIL;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_parse_response....data = %s \n", data);
	return zte_traffic_first_parse_json(&data);
}


int zte_traffic_socket_creat()
{
	g_traffic_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
	if (g_traffic_sock_fd < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic]  sendSocket Creation Fail!\n");
		return TRAFFIC_RESULT_FAIL;
	}

	return TRAFFIC_RESULT_OK;
}

int zte_traffic_socket_connect()
{
	struct sockaddr_in toAddr;
	char IPdotdec[20];
	toAddr.sin_addr.s_addr = zte_traffic_get_server_ip();
	toAddr.sin_family      = AF_INET;
	toAddr.sin_port        = htons(CX_360_PORT);
	bzero(&(toAddr.sin_zero), 8);

	//slog(MISC_PRINT, SLOG_DEBUG,"[traffic]  Send  IP: %s \n", inet_ntoa(toAddr.sin_addr));
	//sc_cfg_set(CX_360_SERVER_IP_NV, inet_ntoa(toAddr.sin_addr));

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic]  Send  IP: %s \n", inet_ntop(AF_INET, &toAddr.sin_addr, IPdotdec, 16));
	sc_cfg_set(CX_360_SERVER_IP_NV, IPdotdec);

	if (connect(g_traffic_sock_fd, (struct sockaddr *)&toAddr, sizeof(struct sockaddr)) == -1) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic]  sendSocket connect Fail!\n");
		return TRAFFIC_RESULT_FAIL;
	}

	return TRAFFIC_RESULT_OK;
}

int zte_traffic_socket_send()
{
	int retValue = TRAFFIC_RESULT_FAIL;
	int state = 0;
	char *buf = NULL;
	int size = 0;

	state = zte_traffic_get_process_state();
	if (state == TRAFFIC_STATE_FIRST_REQUEST) {
		size = TRAFFIC_FIRST_REQUEST_SEND_LEN;
	} else if (state == TRAFFIC_STATE_SECOND_REQUEST) {
		size = TRAFFIC_SECOND_REQUEST_SEND_LEN;
	} else {
		return TRAFFIC_RESULT_FAIL;
	}

	buf = malloc(size);
	if (buf == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	memset(buf, 0, size);

	if (state == TRAFFIC_STATE_FIRST_REQUEST) {
		retValue = zte_traffic_first_encode_http_head(buf, TRAFFIC_FIRST_REQUEST_SEND_LEN);
//	} else if (state == TRAFFIC_STATE_SECOND_REQUEST) {  // kw 3
	}else{  // for other value return TRAFFIC_RESULT_FAIL
		retValue = zte_traffic_second_encode_http_head(buf, TRAFFIC_SECOND_REQUEST_SEND_LEN);
	}

	if (retValue != TRAFFIC_RESULT_OK) {
//		if (buf != NULL) {   // kw 3
			free(buf);
			buf = NULL;
//		}
		return retValue;
	}

	retValue = send(g_traffic_sock_fd, buf, strlen(buf), 0);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic]  need send len = %d,  send success len = %d chars \n", strlen(buf), retValue);
//	if (buf != NULL) {  // kw 3
		free(buf);
		buf = NULL;
//	}
	return TRAFFIC_RESULT_OK;
}


int zte_traffic_socket_select()
{
	fd_set readfds;
	struct timeval tv;
	int retValue = 0;

	FD_ZERO(&readfds);
	FD_SET(g_traffic_sock_fd, &readfds);
	tv.tv_sec = 10 + g_traffic_select_offset_time;
	tv.tv_usec = 0;
	do {
		retValue = select(g_traffic_sock_fd + 1, &readfds, NULL, NULL, &tv);
	} while (retValue < 0 && errno == EINTR);

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] first select  retValue = %d\n", retValue);

	if (retValue < 0 || (g_traffic_select_retry_count >= TRAFFIC_MAX_REQUEST)) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] ...select data fail...break \n");
		return TRAFFIC_RESULT_FAIL;
	}

	if (retValue == 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] ...select no data , so again to send,  tryCount = %d\n", g_traffic_select_retry_count);
		g_traffic_select_retry_count ++;
		g_traffic_select_offset_time += 5;
		return TRAFFIC_RESULT_CONTINUE;
	}

	g_traffic_select_offset_time = 0;
	g_traffic_select_retry_count = 0;

	return TRAFFIC_RESULT_OK;
}

int zte_traffic_socket_recv()
{
	int retValue;
	int state = 0;
	char buf[1024] = {0};

	retValue = recv(g_traffic_sock_fd, buf, sizeof(buf), 0);
	if (retValue <= 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] ...recv data fail... \n");
		return TRAFFIC_RESULT_FAIL;
	}

	slog(MISC_PRINT, SLOG_ERR,"[traffic] ...recv msg , buf = %s \n", buf);
	buf[1024 - 1] = '\0';
	state = zte_traffic_get_process_state();
	if (state == TRAFFIC_STATE_FIRST_REQUEST) {
		retValue = zte_traffic_first_parse_response(buf);
	} else if (state == TRAFFIC_STATE_SECOND_REQUEST) {
		retValue = zte_traffic_second_parse_response(buf);
	}

	return retValue;
}


int zte_traffic_send_http_request()
{
	int retValue = 0;

	retValue = zte_traffic_socket_creat();
	if (retValue != TRAFFIC_RESULT_OK) {
		return retValue;
	}

	retValue = zte_traffic_socket_connect();
	if (retValue != TRAFFIC_RESULT_OK) {
		return retValue;
	}

	retValue = zte_traffic_socket_send();
	if (retValue != TRAFFIC_RESULT_OK) {
		return retValue;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] ...Received msg ... \n");

	retValue = zte_traffic_socket_select();
	if (retValue != TRAFFIC_RESULT_OK) {
		return retValue;
	}

	retValue = zte_traffic_socket_recv();
	if (retValue != TRAFFIC_RESULT_OK) {
		return retValue;
	}

	return TRAFFIC_RESULT_OK;
}

void zte_traffic_calculate_offset(unsigned long long used)
{
	unsigned long long month_used = 0;
	long long offset = 0;
	char buf[NV_ITEM_STRING_LEN_150] = {0};
	char month_total[NV_ITEM_STRING_LEN_20] = {0};

	sc_cfg_get("flux_month_total", month_total, sizeof(month_total));
	month_used = atoll(month_total);
	if(month_used > ULLONG_MAX-1){
        month_used = 0;
	}
	
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_calculate_offset  used = %lld\n", used);
	offset = used - month_used;
	sprintf(buf, "%lld", offset);
	sc_cfg_set(NV_TRAFFIC_USED_OFFSET_DATA, buf);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_calculate_offset  offset = %s\n", buf);
	//zte_send_message(MODULE_ID_MMI,CB_MSG_MMI_TRAFFIC_INFO_RESET,0, NULL);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
}

int zte_traffic_check_data(TRAFFIC_SECOND_PARSE *parse)
{
	if (strlen(parse->global_total) > 0 || strlen(parse->local_total) > 0
	    || strlen(parse->provinceinner_total) > 0 || strlen(parse->provinceoutter_total) > 0) {
		return TRAFFIC_RESULT_OK;
	}

	return TRAFFIC_RESULT_FAIL;
}

int zte_traffic_save_data(TRAFFIC_SECOND_PARSE *parse)
{
	char data[NV_ITEM_STRING_LEN_20] = {0};
	float tmp_used = 0;
	float all_used = 0;
	int tmp_total = 0;
	long total = 0;
	unsigned long long used = 0;
	int flag = 0;

	flag = zte_traffic_check_data(parse);
	if (flag == TRAFFIC_RESULT_FAIL) {
		return TRAFFIC_RESULT_FAIL;
	}

	if (strlen(parse->global_total) > 0) {
		sscanf(parse->global_total, "%d", &tmp_total);
		if(tmp_total < 0 || tmp_total >  INT_MAX-1)  // kw 3
		{
			tmp_total = 0;
		}
	
		sscanf(parse->global_used, "%f", &tmp_used);
		if(tmp_used < 0 || tmp_used >  FLT_MAX)  // kw 3
		{
			tmp_used = 0;
		}		

		total = total + tmp_total;
		all_used = all_used + tmp_used;
	}

	if (strlen(parse->local_total) > 0) {
		sscanf(parse->local_total, "%d", &tmp_total);
		if(tmp_total < 0 || tmp_total >  INT_MAX-1)  // kw 3
		{
			tmp_total = 0;
		}

		
		sscanf(parse->local_used, "%f", &tmp_used);
		if(tmp_used < 0 || tmp_used >  FLT_MAX)  // kw 3
		{
			tmp_used = 0;
		}

		
		total = total + tmp_total;
		all_used = all_used + tmp_used;
	}

	if (strlen(parse->provinceinner_total) > 0) {
		sscanf(parse->provinceinner_total, "%d", &tmp_total);
		if(tmp_total < 0 || tmp_total >  INT_MAX-1)  // kw 3
		{
			tmp_total = 0;
		}
		
		sscanf(parse->provinceinner_used, "%f", &tmp_used);
		if(tmp_used < 0 || tmp_used >  FLT_MAX)  // kw 3
		{
			tmp_used = 0;
		}

		
		total = total + tmp_total;
		all_used = all_used + tmp_used;
	}

	if (strlen(parse->provinceoutter_total) > 0) {
		sscanf(parse->provinceoutter_total, "%d", &tmp_total);
		if(tmp_total < 0 || tmp_total >  INT_MAX-1)  // kw 3
		{
			tmp_total = 0;
		}
		
		sscanf(parse->provinceoutter_used, "%f", &tmp_used);
		if(tmp_used < 0 || tmp_used > FLT_MAX-1)  // kw 3
		{
			tmp_used = 0;
		}
	
		total = total + tmp_total;
		all_used = all_used + tmp_used;
	}

	sprintf(data, "%d", total);
	sc_cfg_set(NV_DATA_TRAFFIC_MONTH_TOTAL, data);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_save_data  total = %s\n", data);

	memset(data, 0, sizeof(data));
	sprintf(data, "%f", all_used);
	sc_cfg_set(NV_DATA_TRAFFIC_MONTH_USED,  data);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_save_data  used = %s\n", data);

	used = all_used * 1024 * 1024;
	zte_traffic_calculate_offset(used);
	return TRAFFIC_RESULT_OK;
}

/**
{"code":"100",
"msg":"ok",
"data":{"local":
    {"total":"5120","used":"5120","balance":"0"},
    "global":
    {"total":"11264","used":"6476.32","balance":"4787.68"}
}
}
*/
int zte_traffic_second_parse_json(char *srcStr)
{
	cJSON *root = NULL;
	cJSON *data = NULL;
	cJSON *object = NULL;
	cJSON *object1 = NULL;
	TRAFFIC_SECOND_PARSE  traffic_second_parse;

	memset(&traffic_second_parse, 0, sizeof(TRAFFIC_SECOND_PARSE));
	root = cJSON_Parse(srcStr);
	if (root == NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. traffic_second_parse_json, root == NULL fail \n");
		return TRAFFIC_RESULT_FAIL;
	}

	object = cJSON_GetObjectItem(root, "code");
	if (object == NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. traffic_second_parse_json, code == NULL fail \n");
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}
	strncpy(traffic_second_parse.code, object->valuestring, sizeof(traffic_second_parse.code) - 1);
	traffic_second_parse.code[9]='\0';
	object = cJSON_GetObjectItem(root, "msg");
	if (object == NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. traffic_second_parse_json, msg == NULL fail\n");
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}

	strncpy(traffic_second_parse.msg, object->valuestring, sizeof(traffic_second_parse.msg) - 1);

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. code = %s \n", traffic_second_parse.code);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...msg  = %s \n", traffic_second_parse.msg);

	if (atoi(traffic_second_parse.code) != GET_TRAFFIC_SUCCESS) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. traffic_second_parse_json, msg = %s ,not success\n", traffic_second_parse.msg);
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}

	//for data
	data = cJSON_GetObjectItem(root, "data");
	if (data == NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second.. traffic_second_parse_json, data == NULL fail \n");
		cJSON_Delete(root);
		return TRAFFIC_RESULT_FAIL;
	}

	object = cJSON_GetObjectItem(data, "local");
	if (object != NULL) {
		object1 = cJSON_GetObjectItem(object, "total");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.local_total, object1->valuestring, sizeof(traffic_second_parse.local_total) - 1);
			sc_cfg_set(NV_TRAFFIC_LOCAL_TOTAL, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "used");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.local_used, object1->valuestring, sizeof(traffic_second_parse.local_used) - 1);
			sc_cfg_set(NV_TRAFFIC_LOCAL_USED, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "balance");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.local_balance, object1->valuestring, sizeof(traffic_second_parse.local_balance) - 1);
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...local_total  = %s \n", traffic_second_parse.local_total);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...local_used  = %s \n", traffic_second_parse.local_used);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...local_balance  = %s \n", traffic_second_parse.local_balance);
	}

	object = cJSON_GetObjectItem(data, "global");
	if (object != NULL) {
		object1 = cJSON_GetObjectItem(object, "total");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.global_total, object1->valuestring, sizeof(traffic_second_parse.global_total) - 1);
			sc_cfg_set(NV_TRAFFIC_GLOBAL_TOTAL, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "used");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.global_used, object1->valuestring, sizeof(traffic_second_parse.global_used) - 1);
			sc_cfg_set(NV_TRAFFIC_GLOBAL_USED, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "balance");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.global_balance, object1->valuestring, sizeof(traffic_second_parse.global_balance) - 1);
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...global_total  = %s \n", traffic_second_parse.global_total);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...global_used  = %s \n", traffic_second_parse.global_used);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...global_balance  = %s \n", traffic_second_parse.global_balance);
	}

	object = cJSON_GetObjectItem(data, "provinceinner");
	if (object != NULL) {
		object1 = cJSON_GetObjectItem(object, "total");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceinner_total, object1->valuestring, sizeof(traffic_second_parse.provinceinner_total) - 1);
			sc_cfg_set(NV_TRAFFIC_PROVINCEINNER_TOTAL, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "used");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceinner_used, object1->valuestring, sizeof(traffic_second_parse.provinceinner_used) - 1);
			sc_cfg_set(NV_TRAFFIC_PROVINCEINNER_USED, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "balance");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceinner_balance, object1->valuestring, sizeof(traffic_second_parse.provinceinner_balance) - 1);
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceinner_total  = %s \n", traffic_second_parse.provinceinner_total);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceinner_used  = %s \n", traffic_second_parse.provinceinner_used);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceinner_balance  = %s \n", traffic_second_parse.provinceinner_balance);
	}

	object = cJSON_GetObjectItem(data, "provinceoutter");
	if (object != NULL) {
		object1 = cJSON_GetObjectItem(object, "total");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceoutter_total, object1->valuestring, sizeof(traffic_second_parse.provinceoutter_total) - 1);
			sc_cfg_set(NV_TRAFFIC_PROVINCEOUTTER_TOTAL, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "used");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceoutter_used, object1->valuestring, sizeof(traffic_second_parse.provinceoutter_used) - 1);
			sc_cfg_set(NV_TRAFFIC_PROVINCEOUTTER_USED, object1->valuestring);
		}

		object1 = cJSON_GetObjectItem(object, "balance");
		if (object1 != NULL) {
			strncpy(traffic_second_parse.provinceoutter_balance, object1->valuestring, sizeof(traffic_second_parse.provinceoutter_balance) - 1);
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceoutter_total  = %s \n", traffic_second_parse.provinceoutter_total);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceoutter_used  = %s \n", traffic_second_parse.provinceoutter_used);
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second...provinceoutter_balance  = %s \n", traffic_second_parse.provinceoutter_balance);
	}

	cJSON_Delete(root);
	return zte_traffic_save_data(&traffic_second_parse);
}


int zte_traffic_second_parse_response(char *srcStr)
{
	char *p1 = NULL;
	char *p2 = NULL;
	int len = 0;
	char data[500] = {0};
	int state = 0;

	if (srcStr == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	state = zte_traffic_parse_response_state(srcStr);
	if (state != 200) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_parse_response..state != 200  fail\n");
		return TRAFFIC_RESULT_FAIL;
	}

	state = zte_traffic_parse_response_content(srcStr, &data, sizeof(data));
	if (state == TRAFFIC_RESULT_FAIL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_parse_response..parse_content  fail\n");
		return TRAFFIC_RESULT_FAIL;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_parse_response....data = %s \n", data);

	return zte_traffic_second_parse_json(&data);
}


int zte_traffic_second_get_request_data(char *data, int data_len)
{
	char *sms_body = NULL;
	int size = TRAFFIC_ENCODE_SMS_UTF8_LEN;
	TRAFFIC_REQUEST_PARAM  request = {0};

	if (data == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	sms_body = malloc(size);
	if (sms_body == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	memset(sms_body, 0, size);

	if (g_traffic_sms_body != NULL) {
		zte_traffic_convert_unicode_to_utf8(g_traffic_sms_body, strlen(g_traffic_sms_body), sms_body, size);
		free(g_traffic_sms_body);
		g_traffic_sms_body = NULL;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_get_request_data=============================== \n");

	zte_traffic_get_request_param(&request, 1);

	strncat(data, "operator=", data_len-1);
	strncat(data, request.operator, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "brand=", data_len-strlen(data)-1);
	strncat(data, request.brand, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "province=", data_len-strlen(data)-1);
	strncat(data, request.province, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "city=", data_len-strlen(data)-1);
	strncat(data, request.city, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "platform=", data_len-strlen(data)-1);
	strncat(data, request.platform, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "imsi=", data_len-strlen(data)-1);
	strncat(data, request.imsi, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "version=", data_len-strlen(data)-1);
	strncat(data, request.version, data_len-strlen(data)-1);
	strncat(data, "&", data_len-strlen(data)-1);
	strncat(data, "smsbody=", data_len-strlen(data)-1);
	strncat(data, sms_body, data_len-strlen(data)-1);

//	if (sms_body != NULL) {  // kw 3
		free(sms_body);
		sms_body = NULL;
//	}
	return TRAFFIC_RESULT_OK;
}


int zte_traffic_second_encode_http_head(char *head, int head_len)
{
	char *data = NULL;
	int size = TRAFFIC_ENCODE_HTTP_HEAD_LEN;
	int len = 0;
	char buf[NV_ITEM_STRING_LEN_10] = {0};
	int ret = -1;
	char ip[NV_ITEM_STRING_LEN_50] = {0};

	if (head == NULL  || head_len == 0) {
		return TRAFFIC_RESULT_FAIL;
	}

	data = malloc(size);
	if (data == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	memset(data, 0, size);
	ret = zte_traffic_second_get_request_data(data, size);
	if (ret == TRAFFIC_RESULT_FAIL) {
//		if (data != NULL) {  // kw 3
			free(data);
			data = NULL;
//		}
		return TRAFFIC_RESULT_FAIL;
	}

	len = strlen(data);
	snprintf(buf,10, "%d", len);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second. data len: %s \n", buf);
	sc_cfg_get(CX_360_SERVER_IP_NV, ip, sizeof(ip));
	strncat(head, "POST ", head_len-1);
	strncat(head, TRAFFIC_SMS_PARSE_URL, head_len-strlen(head)-1);
	strncat(head, " HTTP/1.1\r\n", head_len-strlen(head)-1);
	strncat(head, "Host: ", head_len-strlen(head)-1);
	strncat(head, &ip, head_len-strlen(head)-1);
	strncat(head, "\r\n", head_len-strlen(head)-1);
	strncat(head, "Accept: */*\r\n", head_len-strlen(head)-1);
	strncat(head, "Connection: Keep-Alive\r\n", head_len-strlen(head)-1);
	strncat(head, "Content-Length: ", head_len-strlen(head)-1);
	strncat(head, buf, head_len-strlen(head)-1);
	strncat(head, "\r\n", head_len-strlen(head)-1);
	strncat(head, "Content-Type: application/x-www-form-urlencoded\r\n", head_len-strlen(head)-1);
	strncat(head, "\r\n", head_len-strlen(head)-1);
	strncat(head, data, head_len-strlen(head)-1);
	strncat(head, "\r\n", head_len-strlen(head)-1);

//	if (data != NULL) {  // kw 3
		free(data);
		data = NULL;
//	}
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] second. http_head: %s \n", head);
	return TRAFFIC_RESULT_OK;
}


void zte_traffic_delete_sms_after_process_over()
{
	/*ֹУ׼ʧܺŴݿռռ
	   ˴ͳһɾ*/
	char str_id[100] = {0};
	int count = 0;
	int rec_count = 0;
	int i = 0;
	T_zUfiSms_DelReq  del_req = {0};
	unsigned char rec_separate[10][20] = {0};
	int tmp_id = 0;

	zte_libwms_get_traffic_sms_id(&str_id, &count);
	if (count == 0) {
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"traffic_delete_sms_after_process_over   str_id = %s.\n", str_id);
	rec_count = zte_traffic_parse_str_by_separator(str_id, (unsigned char *)rec_separate, 20, SEPARATOR_CHARACTER);

	for (i = 0; i < rec_count; i++) {
		tmp_id = atoi(rec_separate[i]);
	    if(tmp_id < 0 || tmp_id >  INT_MAX-1)  // kw 3
		{
			tmp_id = 0;
		}
		del_req.id[i] = tmp_id;
			
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic]traffic_delete_sms_after_process_over:  del_req.id[%d] = %d\n", i, del_req.id[i]);
	}
	del_req.all_or_count = count;

	if (ZTE_MC_OK_S == zte_mc_relay_sms_delete_msg((T_zUfiSms_DelReq*)(&del_req))) {
		slog(MISC_PRINT, SLOG_NORMAL,"[traffic]traffic_delete_sms_after_process_over:send delete sms cmd to mc success.\n");
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[traffic]traffic_delete_sms_after_process_over:send delete sms cmd to mc fail.\n");
	}
}

void zte_traffic_delete_sms(long id)
{
	T_zUfiSms_DelReq  del_req = {0};

	del_req.all_or_count = 1;
	del_req.id[0] = id;
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic]traffic_delete_sms:  id = %d\n", id);

	if (ZTE_MC_OK_S == zte_mc_relay_sms_delete_msg((T_zUfiSms_DelReq*)(&del_req))) {
		slog(MISC_PRINT, SLOG_NORMAL,"[traffic]traffic_delete_recv_sms:send delete sms cmd to mc success.\n");
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[traffic]traffic_delete_recv_sms:send delete sms cmd to mc fail.\n");
	}
}

int zte_traffic_wait_to_recv_sms()
{
	char buf[NV_ITEM_STRING_LEN_20] = {0};
	long id = 0;
	int result = 0;
	int body_size = 2 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX * ZTE_WMS_CONCAT_SMS_COUNT_MAX + 1 ;
	long now_time = 0;
	long offset_time = 0;

	//˴նŵȴ120
	time(&now_time);
	offset_time = now_time - g_traffic_last_time;
	if (offset_time > 120 || offset_time < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_wait_to_recv_sms wait sms,time arrived, not recv whole sms , stop to recv, fail\n");
		return TRAFFIC_RESULT_FAIL;
	}

	sc_cfg_get(NV_TRAFFIC_RECV_SMS_ID, buf, sizeof(buf));
	if (0 == strcmp(buf, "0")) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_wait_to_recv_sms wait sms contiue\n");
		return TRAFFIC_RESULT_CONTINUE;
	}

	id = atol(buf);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_wait_to_recv_sms id=%ld\n", id);

	if (id == 0) {
		return TRAFFIC_RESULT_CONTINUE;
	}

	g_traffic_sms_body = malloc(body_size);
	if (g_traffic_sms_body  == NULL) {
		return TRAFFIC_RESULT_FAIL;
	}

	memset(g_traffic_sms_body, 0, sizeof(body_size));

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_wait_to_recv_sms     id=%d \n", id);
	result = zte_libwms_get_traffic_sms_body(id, g_traffic_sms_body);
	if (result != 0) {
		return TRAFFIC_RESULT_FAIL;
	}

	//zte_traffic_delete_sms(id);

	//˴ÿΪÿնʱҪ
	//кıȶ
	sc_cfg_set(NV_TRAFFIC_SMS_NUMBER, "0");
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_wait_to_recv_sms body=%s\n", g_traffic_sms_body);
	return TRAFFIC_RESULT_OK;
}


int zte_traffic_check_can_send_sms()
{
	T_zUfiSms_StatusInfo cmd_status_info = {0};
	int result = 0;

	cmd_status_info.cmd = WMS_SMS_CMD_MSG_SEND;
	result = zte_libwms_get_cmd_status(&cmd_status_info);
	if (result == -1) {
		return TRAFFIC_RESULT_OK;
	}

	if (cmd_status_info.cmd_status == WMS_CMD_PROCESSING) {
		return TRAFFIC_RESULT_CONTINUE;
	}

	return TRAFFIC_RESULT_OK;
}


int zte_traffic_send_sms()
{
	unsigned int i = 0;
	int message_content_len = 0;
	unsigned int   rec_count = 0;

	int s_flag = 0;
	int index = 0;
	struct timeval  time_tv;
	struct tm ptm = {0};
	int result = 0;
	char body[NV_ITEM_STRING_LEN_50] = {0};
	int year = 0;
	char time_buf[30] = {0};
	long now_time = 0;
	long offset_time = 0;

	//˴Ͷȴ60
	time(&now_time);
	offset_time = now_time - g_traffic_last_time;
	if (offset_time > 60 || offset_time < 0) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_send_sms wait sms, time arrived, stop to send sms, fail\n");
		return TRAFFIC_RESULT_FAIL;
	}

	result = zte_traffic_check_can_send_sms();
	if (result != TRAFFIC_RESULT_OK) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_check_can_send_sms fail \n");
		return result;
	}

	unsigned char rec_separate[ZTE_WMS_SEND_NUM_MAX][ZTE_WMS_ADDRESS_LEN_MAX + 1] = {0};
	T_zUfiSms_SendReq  MSG_SEND_ST;

	memset(&MSG_SEND_ST, 0, sizeof(T_zUfiSms_SendReq));

	message_content_len = zte_traffic_ConvertUcs2(traffic_first_parse.traffic_code, strlen(traffic_first_parse.traffic_code), &body);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, content USC2S body = %s, len = %d\n", body, message_content_len);
	rec_count = zte_traffic_parse_str_by_separator(traffic_first_parse.traffic_number, (unsigned char *)rec_separate, ZTE_WMS_ADDRESS_LEN_MAX + 1, SEPARATOR_CHARACTER);

	if (0 != gettimeofday(&time_tv, NULL)) {
		slog(MISC_PRINT, SLOG_ERR,"[traffic] get time of system fail \n");
		return TRAFFIC_RESULT_FAIL;
	}
	gmtime_r(&time_tv.tv_sec, &ptm);
	year = ptm.tm_year + 1900 - 2000;
	if (year > 9) {
		snprintf(MSG_SEND_ST.date.year,5, "%d", year);
	} else {
		snprintf(MSG_SEND_ST.date.year,5, "0%d", year);
	}

	snprintf(MSG_SEND_ST.date.month,3, "%d", ptm.tm_mon + 1);
	snprintf(MSG_SEND_ST.date.day,3, "%d", ptm.tm_mday);
	snprintf(MSG_SEND_ST.date.hour,3, "%d", ptm.tm_hour);
	snprintf(MSG_SEND_ST.date.min,3, "%d", ptm.tm_min);
	snprintf(MSG_SEND_ST.date.sec,3, "%d", ptm.tm_sec);
	sprintf(MSG_SEND_ST.date.timezone, "%d", 8);

	snprintf(time_buf, sizeof(time_buf),"%d", (int)time_tv.tv_sec);
	sc_cfg_set(NV_TRAFFIC_SMS_SEND_TIME, time_buf);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, time_tv = %s\n", time_buf);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, year = %s\n", MSG_SEND_ST.date.year);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, month = %s\n", MSG_SEND_ST.date.month);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, day = %s\n", MSG_SEND_ST.date.day);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, hour = %s\n", MSG_SEND_ST.date.hour);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, min = %s\n", MSG_SEND_ST.date.min);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, sec = %s\n", MSG_SEND_ST.date.sec);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, content = %s\n", traffic_first_parse.traffic_code);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] send sms, content len = %d\n", strlen(traffic_first_parse.traffic_code));

	zte_libwms_db_write_send_msg_content_data(&body);

	MSG_SEND_ST.msg_len = message_content_len;
	MSG_SEND_ST.dcs = DCS_GSM7_DEFAULT;
	MSG_SEND_ST.receiver_count = rec_count;
	MSG_SEND_ST.id = -1;
	MSG_SEND_ST.mem_store = TRAFFIC_SMS_MEM_STORE_IN_DB;
	memcpy(MSG_SEND_ST.dest_num, rec_separate, sizeof(rec_separate));

	sc_cfg_set(NV_TRAFFIC_SMS_NUMBER, MSG_SEND_ST.dest_num[0]);
	slog(MISC_PRINT, SLOG_NORMAL,"[traffic] send sms, num = %s\n", MSG_SEND_ST.dest_num[0]);
	zte_sms_handle_DB_status_whenSend(WMS_CMD_PROCESSING);
	if (0 == zte_mc_relay_sms_send_msg((T_zUfiSms_SendReq*)(&MSG_SEND_ST))) {
		return TRAFFIC_RESULT_OK;
	} else {
		zte_sms_handle_DB_status_whenSend(WMS_CMD_FAILED);
		return TRAFFIC_RESULT_FAIL;
	}
}

void zte_traffic_clear_param_state()
{
	sc_cfg_set(NV_TRAFFIC_SMS_NUMBER, "0");
	sc_cfg_set(NV_TRAFFIC_RECV_SMS_ID, "0");
	sc_cfg_set(NV_TRAFFIC_SMS_SEND_TIME, "0");

	g_traffic_select_offset_time = 0;
	g_traffic_select_retry_count = 0;
	g_traffic_302reponse_retry_count = 0;

	if (g_traffic_sms_body != NULL) {
		free(g_traffic_sms_body);
		g_traffic_sms_body = NULL;
	}
}

void zte_traffic_init_nv()
{
	sc_cfg_set(NV_TRAFFIC_PROCESS_STATE, "yes");
	sc_cfg_set(NV_TRAFFIC_RESULT, "processing");
	sc_cfg_set(NV_TRAFFIC_GLOBAL_TOTAL, "");
	sc_cfg_set(NV_TRAFFIC_GLOBAL_USED, "");
	sc_cfg_set(NV_TRAFFIC_LOCAL_TOTAL, "");
	sc_cfg_set(NV_TRAFFIC_LOCAL_USED, "");
	sc_cfg_set(NV_TRAFFIC_PROVINCEINNER_TOTAL, "");
	sc_cfg_set(NV_TRAFFIC_PROVINCEINNER_USED, "");
	sc_cfg_set(NV_TRAFFIC_PROVINCEOUTTER_TOTAL, "");
	sc_cfg_set(NV_TRAFFIC_PROVINCEOUTTER_USED, "");
}

void zte_traffic_process()
{
	int state = 0;
	int result = TRAFFIC_RESULT_FAIL;

	zte_traffic_init_nv();
	zte_traffic_clear_param_state();
	zte_traffic_set_process_state(TRAFFIC_STATE_FIRST_REQUEST);

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] start to traffic=============!!!\n");

	while (1) {
		state = zte_traffic_get_process_state();

		if (state == TRAFFIC_STATE_FIRST_REQUEST) {
			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_request!\n");
			result = zte_traffic_send_http_request();
			if (result == TRAFFIC_RESULT_CONTINUE) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_request, continue!\n");
				zte_traffic_close_socket();
				continue;
			} else if (result == TRAFFIC_RESULT_FAIL) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_request,fail ---> traffic_over!\n");
				break;
			}

			zte_traffic_set_process_state(TRAFFIC_STATE_SEND_SMS);
			zte_traffic_close_socket();
			time(&g_traffic_last_time);
			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_first_request, success!\n");
		} else if (state == TRAFFIC_STATE_SEND_SMS) {
			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_send_sms!\n");
			result = zte_traffic_send_sms();
			if (result == TRAFFIC_RESULT_FAIL) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_send_sms, fail -->traffic_over!\n");
				break;
			} else if (result == TRAFFIC_RESULT_CONTINUE) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_send_sms, CONFLICT, sleep and wait 5s, and continue to send!\n");
				sleep(5);
				continue;
			}

			zte_traffic_set_process_state(TRAFFIC_STATE_WAIT_RECV_SMS);

			time(&g_traffic_last_time);
			sleep(5);
			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_send_sms, success!\n");
		} else if (state == TRAFFIC_STATE_WAIT_RECV_SMS) {
			result = zte_traffic_wait_to_recv_sms();
			if (result == TRAFFIC_RESULT_CONTINUE) {
				sleep(10);
				continue;
			} else if (result == TRAFFIC_RESULT_FAIL) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_wait_to_recv_sms,fail ---> traffic_over!\n");
				break;
			}

			zte_traffic_set_process_state(TRAFFIC_STATE_SECOND_REQUEST);
		} else if (state == TRAFFIC_STATE_SECOND_REQUEST) {
			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_request!\n");
			result = zte_traffic_send_http_request();
			if (result == TRAFFIC_RESULT_CONTINUE) {
				slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_request, continue!\n");
				zte_traffic_close_socket();
				continue;
			} else if (result == TRAFFIC_RESULT_FAIL) {
				slog(MISC_PRINT, SLOG_ERR,"[traffic] traffic_second_request,fail ---> traffic_over!\n");
				break;
			}

			slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_second_request, success!\n");
			break;
		}
	}

	zte_traffic_set_process_state(TRAFFIC_STATE_OVER);
	zte_traffic_set_process_result(result);
	zte_traffic_clear_param_state();
	zte_traffic_close_socket();
	zte_traffic_delete_sms_after_process_over();

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] traffic_process, over====================!\n");
	return;
}


int zte_web_traffic_start()
{
	pthread_t  traffic_thread_id;
	pthread_attr_t attr;
	int  result = 0;
	slog(MISC_PRINT, SLOG_NORMAL,"[traffic] traffic_start--------!\n");

	if (zte_traffic_get_process_state() != TRAFFIC_STATE_OVER) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] already running, can not start now, fail!\n");
		return TRAFFIC_RESULT_FAIL;
	}

	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

	zte_traffic_set_process_state(TRAFFIC_STATE_IDLE);
	result = pthread_create(&traffic_thread_id, &attr, zte_traffic_process, NULL);
	pthread_attr_destroy(&attr);
	if (result != 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] pthread_create faild!\n");
		zte_traffic_set_process_state(TRAFFIC_STATE_OVER);
		return TRAFFIC_RESULT_FAIL;
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] pthread_create  SUCCESS!\n");
		return TRAFFIC_RESULT_OK;
	}
}

int zte_web_traffic_check()
{
	char ppp_status[NV_ITEM_STRING_LEN_50] = {0};
	char traffic_switch[NV_ITEM_STRING_LEN_10] = {0};
	char province[NV_ITEM_STRING_LEN_50] = {0};

	sc_cfg_get(NV_DATA_TRAFFIC_SWITCH, traffic_switch, sizeof(traffic_switch));
	if (0 != strcmp(traffic_switch, "yes")) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check  switch is off , can not start traffic, fail!\n");
		return  TRAFFIC_NOT_ENABLE_SWITCH;
	}

	if (zte_traffic_get_process_state() != TRAFFIC_STATE_OVER) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] already running, can not start now, fail!\n");
		return TRAFFIC_RESULT_FAIL;
	}

	sc_cfg_get(NV_DATA_TRAFFIC_SIM_PROVINCE, province, sizeof(province));
	if (0 == strlen(&province)) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check  province fail!\n");
		return TRAFFIC_NOT_SELECT_SIM_PROVINCE;
	}

	sc_cfg_get("ppp_status", ppp_status, sizeof(ppp_status));
	if (0 != strcmp(ppp_status, "ppp_connected")
	    && 0 != strcmp(ppp_status, "ipv4_ipv6_connected")
	    && 0 != strcmp(ppp_status, "ipv6_connected")) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] ppp disconnected, can not start traffic, fail!\n");
		return TRAFFIC_NOT_CONNECT_NET;
	}

	if (zte_get_sms_remain_capacity() < 5) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] TRAFFIC_NOT_ENOUGH_SMS_MEMORY, fail!\n");
		return TRAFFIC_NOT_ENOUGH_SMS_MEMORY;
	}
	sc_cfg_set("traffic_check", "yes");
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check  SUCCESS!\n");
	return TRAFFIC_RESULT_OK;
}


int zte_web_traffic_check_if_exceed_one_day_time()
{
	long now_time = 0;
	long last_traffic_over_time = 0;
	long interval_time = 0;
	char last_traffic_over_time_str[NV_ITEM_STRING_LEN_20] = {0};
	int result = -1;

	time(&now_time);//Ϊλ
	sc_cfg_get(NV_TRAFFIC_OVER_TIME, last_traffic_over_time_str, sizeof(last_traffic_over_time_str));

	last_traffic_over_time = atol(last_traffic_over_time_str);
	if(last_traffic_over_time < 0 || last_traffic_over_time > LONG_MAX-1){
        last_traffic_over_time = LONG_MAX;
	}
		
	interval_time = now_time - last_traffic_over_time;

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_exceed_one_day_time,   last_traffic_over_time = %d!\n", last_traffic_over_time);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_exceed_one_day_time,   interval_time = %d!\n", interval_time);

	//жϴУ׼ʱ뵱ǰʱĲǷ1
	if (interval_time >= TIME_ONE_DAY_INTERVAL || interval_time < 0) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_exceed_one_day_time,  interval_time >= TIME_ONE_DAY_INTERVAL !\n");
		result = 0;
	}

	return result;
}


int zte_web_traffic_check_if_same_day()
{
	struct tm now_ptm = {0};
	struct tm last_traffic_ptm = {0};

	long now_time = 0;
	long last_traffic_over_time = 0;
	char last_traffic_over_time_str[NV_ITEM_STRING_LEN_20] = {0};

	time(&now_time);//Ϊλ
	gmtime_r(&now_time, &now_ptm);
	//now_ptm = gmtime(&now_time);
	//if(now_ptm == NULL)
	//{
	//    return -1;
	//}

	sc_cfg_get(NV_TRAFFIC_OVER_TIME, last_traffic_over_time_str, sizeof(last_traffic_over_time_str));

	if (strlen(last_traffic_over_time_str) == 0) {
		return 0;
	}

	last_traffic_over_time = atol(last_traffic_over_time_str);
	gmtime_r(&last_traffic_over_time, &last_traffic_ptm);
	//last_traffic_ptm = gmtime(&last_traffic_over_time);
	//if(last_traffic_ptm == NULL)
	//{
	//    return -1;
	//}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_same_day, last_traffic_ptm, tm_year = %d, tm_month=%d, tm_day=%d\n",  last_traffic_ptm.tm_year, last_traffic_ptm.tm_mon, last_traffic_ptm.tm_mday);
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_same_day, now_ptm, tm_year = %d, tm_month=%d, tm_day=%d\n",  now_ptm.tm_year, now_ptm.tm_mon, now_ptm.tm_mday);
	if ((now_ptm.tm_year == last_traffic_ptm.tm_year)
	    && (now_ptm.tm_mon == last_traffic_ptm.tm_mon)
	    && (now_ptm.tm_mday == last_traffic_ptm.tm_mday)) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_same_day,  the same day, no need traffic when poweron!\n");
		return -1;;
	}

	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] web_traffic_check_if_same_day, not the same day,need traffic when poweron!\n");
	return 0;
}


void zte_traffic_cfg_init()
{
	sc_cfg_set("is_traffic_alining", "no");
}

void zte_traffic_handle()
{
	int flag = 0;
	char buf[NV_ITEM_STRING_LEN_10] = {0};

	memset(&buf, 0, sizeof(buf));
	sc_cfg_get("poweron_traffic", buf, sizeof(buf));
	if ((0 == strcmp(buf, "yes"))
	    && (0 == zte_web_traffic_check())) {
		sc_cfg_set("test_is_poweron_traffic", "yes");
		sc_cfg_set("poweron_traffic", "no");

		if (0 == zte_web_traffic_check_if_same_day()) {
			flag = 1;
		}
	}

	//for traffic ѭʱʱ䵽У׼һ
	if ((0 == zte_web_traffic_check_if_exceed_one_day_time())
	    && (0 == zte_web_traffic_check())) {
		sc_cfg_set("test_is_time_arrived_traffic", "yes");
		flag = 1;
	}

	if (flag == 1) {
		zte_web_traffic_start();
	}
}

