/**
 * @file netapi.h
 * @brief Public APIs of Sanechips, linux network external interface
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author Linxu Gebin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 ************************************************************************
 */

#ifndef __NETAPI_H__
#define __NETAPI_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/**
 * @brief NVֵĳȣΪ˽ʡջռʹ꣬ʹNV_MAX_KEY_LENпܻջԽ
 */
#define	NV_NAME_LEN   30

#define RJ45_ALL_OUT	0x00
#define RJ45_LAN_IN		0x01
#define RJ45_WAN_IN		0x02
#define RJ45_ALL_IN		0x03

#define USB_LAN_OUT     0x00
#define USB_LAN_IN		0x01



/**
 * @brief atӦý̵ӿʱֵָʾPDP ķλãڲвͬ·
 * @param PDP_LOCAL ʾǱӦ÷PDPšVoLTE
 * @param PDP_EXT ʾɷǱڷAṬ巢ATǺڽ͸ʱҪڽֱ
 * @param PDP_NORMAL ʾǱ˵atserverPDPNATת
 * @param PDP_PPP ʾǱ˵PPPصPDPģPPP
 */
#define PDP_LOCAL     0
#define PDP_EXT       1
#define PDP_NORMAL    2
#define PDP_PPP       3

#define   NONE_AUTH           0
#define   PAP_AUTH            1
#define   CHAP_AUTH           2
#define   PAP_CHAP_AUTH       3
#define   PPP_NONE_AUTH       4
#define   PPP_CHAP_AUTH       5
#define   PPP_PAP_AUTH        PAP_AUTH

/**
 * @brief IPV4ַ
 */
#define IPV4ADDLEN_MAX         16

/**
 * @brief IPV6ַ
 */
#define IPV6ADDLEN_MAX         46

/**
 * @brief MACַ
 */
#define MAX_MACADDR_LEN 		14

/**
 * @brief MACַ
 */
#define MAC_ADDR_LEN 18

/**
 * @brief 
 */
#define HOSTNAME_LEN 150

/**
 * @brief ַ
 */
#define SITE_LEN 400


/**
 * @brief PPPDʹõĺ궨
 * @param NUM_PPPD_AUTH һpppֵ֧û
 * @param USER_MAX ûսidĳ
 * @param PW_MAX ĳ
 * @param CHALLENGE_MAX սӦ
 */
#define NUM_PPPD_AUTH		1
#define USER_MAX			50
#define PW_MAX				50
#define CHALLENGE_MAX		50


/**
* @brief PDP
* @param V4V6_INVALID ʼֵκβ
* @param V4_VALID V4вȥ
* @param V6_VALID V6вȥ
* @param V46_VALID V4V6вȥ
*/
enum ipv4v6_flag {
	V4V6_INVALID = 0x00,
	V4_VALID,
	V6_VALID,
	V46_VALID,
};

/**
* @brief ״̬
* @param DEV_STATE_IDLE 豸ڿ״̬
* @param DEV_STATE_CONNECT 豸ڻȡַ״̬
* @param DEV_STATE_WORKING 豸ȡַɣڹ״̬
* @param DEV_STATE_DEAD 豸ӶϿ״̬
*/
enum emDev_State {
	DEV_STATE_IDLE,
	DEV_STATE_CONNECT,
	DEV_STATE_WORKING,
	DEV_STATE_DEAD,
};

/**
* brief  еڡ豸IDֵ
* @param PS_NET_DEV PS 豸ʶAPʱӦ豸ΪUSBDDRNET豸
* @param PS_EXT_DEV1 PS豸ݿ̬һΪUSBͨҲǹDDRͨDDRͨȲ¼ϱ
* @param PS_EXT_DEV2 Ŀǰ֧1-8CID
* @param PS_EXT_DEV3 Ŀǰ֧1-8CID
* @param PS_EXT_DEV4 Ŀǰ֧1-8CID
* @param PS_EXT_DEV5 Ŀǰ֧1-8CID
* @param PS_EXT_DEV6 Ŀǰ֧1-8CID
* @param PS_EXT_DEV7 Ŀǰ֧1-8CID
* @param PS_EXT_DEV8 Ŀǰ֧1-8CID
* @param RJ45_WAN_DEV RJ45豸ʶRJ45_LAN_DEVʶΪ֧Զл
* @param RJ45_LAN_DEV RJ45豸ʶRJ45ͬʱڳ
* @param SW_WAN_DEV Realtek switch 豸ʶ֧Ȳ
* @param SW_LAN_DEV Realtek switch 豸ʶ֧Ȳ
* @param WIFI_WAN_DEV station豸ʶ
* @param WIFI_LAN_DEV station豸ʶ
* @param USB_LAN_DEV USB豸ʶ
* @param NO_DEV ȱʡΪʱʶ
*/
enum dev_ID {
	PS_NET_DEV,
	PS_EXT_DEV1,
	PS_EXT_DEV2,
	PS_EXT_DEV3,
	PS_EXT_DEV4,
	PS_EXT_DEV5,
	PS_EXT_DEV6,
	PS_EXT_DEV7,
	PS_EXT_DEV8,
	RJ45_WAN_DEV,
	RJ45_LAN_DEV,
	SW_WAN_DEV,
	SW_LAN_DEV,
	WIFI_WAN_DEV,
	WIFI_LAN_DEV,
	USB_LAN_DEV,
	NO_DEV,
};

/**
* @brief ʧܵԭIDֵ
* @param TIME_OUT ӳʱ
*/
enum dialfail_reason_ID {
	TIME_OUT = 0,
};

/**
 * @brief ڵip46ȵַϢ
 * @param ip46flag ipv4/ipv6 ־λ
 * @param ip ipv4ַ
 * @param gateway صַ
 * @param netmask 
 * @param pri_dns ѡdnsַ
 * @param sec_dns ѡdnsַ
 * @param  ip6 ipv6 ַ
 * @param gateway6 ipv6 صַ
 * @param  pri_dns6 ipv6 ѡdnsַ
 * @param  sec_dns6 ipv6 ѡdnsַ
 * @note ip46flag ȡֵοV46_VALIDȺֵ
 */
struct netdev_act_info {
	unsigned char  ip46flag;
	char ip[IPV4ADDLEN_MAX];
	char gateway[IPV4ADDLEN_MAX];
	char netmask[IPV4ADDLEN_MAX];
	char pri_dns[IPV4ADDLEN_MAX];
	char sec_dns[IPV4ADDLEN_MAX];
	char ip6[IPV6ADDLEN_MAX];
	char gateway6[IPV6ADDLEN_MAX];
	char pri_dns6[IPV6ADDLEN_MAX];
	char sec_dns6[IPV6ADDLEN_MAX];
};

/**
 * @brief ṹ˵:PDPϢרPSڣcidʶͬPS
 * @param c_id PDPΨһʶ
 * @param pdp_type pdp 
 * @param act_info ڵַϢ
 * @note pdp type ȡֵμPDP_LOCALȺֵ
 */
struct pdp_active_info {
	int c_id;
	unsigned char pdp_type;
	struct netdev_act_info act_info;
};

/**
 * @brief macַͶӦϢ
 * @param mac macַ
 * @param hostname macַӦ
 */
struct mac_hostname_info {
	char mac[MAC_ADDR_LEN];
	char hostname[HOSTNAME_LEN];
};

/**
 * @brief ̬mac ipַϢ
 * @param mac mac ַ
 * @param ip  macַ󶨵ľ̬ipַ
 */
struct static_macip_info {
	char mac[32];
	char ip[32];
};

/**
 * @brief ҳģʽվϢ
 * @param name վ
 * @param site վַ
 */
struct white_site_info {
	char name[HOSTNAME_LEN];
	char site[SITE_LEN];
};

/**
 * @brief ȱʡϢ
 * @param p46flag ipv4/ipv6־λ
 * @param dev_id  豸id
 */
struct default_dev_info {
	unsigned char  ip46flag;
	unsigned char  dev_id;
};

/**
 * @brief Ϣ
 * @param c_id PDPΨһʶucݿģʽҪ룬ufiģʽҪ
 * @param tc_downlink  ֵλ:
 * @param tc_uplink  ֵλ:
 * @note tc_downlink/tc_uplink 0 ʾҪأlinux׼Ƕֽڴֵ8
 */
struct tc_control_info {
	int c_id;
	unsigned int tc_downlink;
	unsigned int tc_uplink;
};

/**
 * @brief ʧʱṹ
 * @param ip46flag ipv4/ipv6 ־λ
 * @param dev_id 豸id
 * @param dialfail_reason ʧԭ
 * @note dialfail_reasonȡֵμTIME_OUTȺֵ
 */
struct dialfail_dev_info {
	unsigned char  ip46flag;
	unsigned char  dev_id;
	unsigned char  dialfail_reason;
};


/**
 * @brief PDPȥϢרPS
 * @param c_id PDP Ψһʶ
 * @param ip46flag  ipv4/ipv6 ־
 * @note c_id ʶͬPS
 */
struct pdp_deactive_info {
	int c_id;
	unsigned char ip46flag;
};

#if 0
typedef struct {
	int result;
	int cid;
	char v6_addr[46];
} V6ADDR_INFORM;
#endif

/**
 * @brief PPPDPDPϢϢ
 * @param auth_type ֤ʽ0PAP1CHAP
 * @param user_len  û 
 * @param user  ûCHAPʽ¸ֵΪսid
 * @param pw_len 볤
 * @param pw 룬ֻPAPʽ
 * @param chg_len ս
 * @param challenge սidCHAPʽ
 */
typedef struct pppd_auth {
	int 	auth_type;
	int 	user_len;
	char 	user[USER_MAX];
	int 	pw_len;
	char 	pw[PW_MAX];
	int 	chg_len;
	char 	challenge[CHALLENGE_MAX];
} pppd_auth;

typedef union
{
    u_int8_t e8[8];
    u_int16_t e16[4];
    u_int32_t e32[2];
} netapi_eui64_t;

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/




/**
 * @brief 豸ȡӦ豸ID,ȼNVе豸ƥ
 * @param dev_name 豸
 * @return ʧܷ-1
 */
int getDevId_byname(char *dev_name);


/**
 * @brief  PS豸ӿ
 * @param actinfo pdp Ϣ
 * @param src_id  ô˽ӿڵĽid
 * @return ɹ  0, ʧ  -1
 * @note atӦý̵ãatserverpcserverVoLTEŵӦý
 */
int pdp_act_proc(struct pdp_active_info *actinfo, int src_id);


/**
 * @brief PPP豸ӿ
 * @param ttyname  tty 豸
 * @return ɹ  0, ʧ  -1
 */
int ppp_act_proc(char *ttyname);

/**
 * @brief PS豸ȥӿ
 * @param c_id  PDPc_id
 * @param ip46flag  ip4/ipv6־
 * @param src_id  ô˽ӿڵĽid
 * @return ɹ  0, ʧ  -1
 * @note atӦý̵ãatserverpcserverVoLTEŵӦý
 */
int pdp_deact_proc(int c_id, unsigned char ip46flag, int src_id);


/**
 * @brief Ȳ豸,ӿڲǷҪвţҪִеַ䡢
 * @param netdev_id	 豸id
 * @param src_id  ô˽ӿڵĽid
 * @return ɹ  0, ʧ  -1
 * @note 豸صô˽ӿʱ豸ͨ·ͨԽIPݰշˣ
 * ؽҪ֤Ȳ¼ظøýӿڣڲƵظIPַ
 */
int netdev_plugin_proc(unsigned char netdev_id, int src_id);

/**
* @brief Ȳ豸γ,ӿڲifconfig downɱӦĵַ
* @param netdev_id	豸id
* @param src_id  ô˽ӿڵĽid
* @return ɹ  0, ʧ  -1
* @note 豸صô˽ӿʱ豸ͨ·ѶϣҪٽIPݰշ
*/
int netdev_plugout_proc(unsigned char netdev_id, int src_id);


/**
* @brief webui͵,ӿڲifconfig upӦĵַ
* @param netdev_id	豸id
* @param src_id  ô˽ӿڵĽid
* @return ɹ  0, ʧ  -1
* @note 豸ģô˽ӿǰҪ⵱ǰ豸ͨ·ͨӦõô˽ӿ
*/
int netdev_connect_internet(unsigned char netdev_id, int src_id);


/**
* @brief webui͵ĶϿ,ӿڲifconfig downɱӦĵַ
* @param netdev_id	豸id
* @param src_id  ô˽ӿڵĽid
* @return ɹ  0, ʧ  -1
* @note 豸ģô˽ӿ
*/
int netdev_disconnect_internet(unsigned char netdev_id, int src_id);


/**
* @brief 
* @param tcinfo	ϢҪص
* @param src_id	 Դid
* @return ɹ1ʧܷ0
* @note ҪƵӦõãҪأٵã޷ȡڽ
*           ػ¿֮ǰõȻЧ
*/
int tc_control(struct tc_control_info *tcinfo, int src_id);


/**
* @brief  Ȳ豸,ӿڲǷҪԶţҪִеַ䡢
* @param netdev_name  豸
* @param src_id  Դ id 
* @return ɹ1ʧܷ0
* @note 豸صô˽ӿʱ豸ͨ·ͨԽIPݰշ
*/
int netdev_plugin_proc_byname(char *netdev_name, int src_id);


/**
* @brief Ȳ豸γ,ӿڲifconfig downɱӦĵַ
* @param netdev_name  豸
* @param src_id  Դ id 
* @return  ɹ1ʧܷ0
* @note 豸صô˽ӿʱ豸ͨ·ѶϣҪٽIPݰշ
*/
int netdev_plugout_proc_byname(char *netdev_name, int src_id);


/**
* @brief  ָʱɾɵļ
* @param 
* @return 
*/
void tcpip_reset_configure();

/**
* @brief  switch豸eth0.200ڶӦport3Ϊwanڻlan
* @param mode:1 => wanڣ0 => lan
* @return 
*/
void set_ethwan_port_mode(int mode);

int netapi_ether_to_eui64(const char *dev_name, netapi_eui64_t *p_eui64);

#endif

/*******************************************************************************
 *                      Global function implementations                          *
 ******************************************************************************/

#endif/* __NETAPI__ */
