
/************************************************************************
*ܽܣat_ctlwifiص¼ʵֺӿ
*ˣ
*޸գ
*޸ݣ
*汾ţ
************************************************************************/

#include "ps_wifi.h"
#if (APP_OS_TYPE == APP_OS_TOS)
#include "zctrm_ext_locknet.h"
#endif
#define RSP_OK                              "OK"
#define RSP_ERR                             "ERROR"

static T_zAt_CsimRes *tCsimRes=NULL;//ڼ¼csimظ
static char *cardmode=NULL;//ڼ¼cardmodeظ
#if (APP_OS_TYPE == APP_OS_TOS)
int crsm_reason = GET_NONE;
extern T_zCtrm_SIMPara simPara;
extern SINT32 g_Sec_Status;
#endif

char* normal_getcsimset(char *pdu)
{
    char *at_next=NULL;
    at_next=malloc(AT_CMD_MAX);
    if(at_next == NULL){
		softap_assert("");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);
	sprintf(at_next,"AT+CSIM=%d,%s,%d\r\n", strlen(pdu), pdu, 0x2d);
	return at_next;
}

char* normal_getcardmode()
{
    char *at_next=NULL;
    at_next=malloc(AT_CMD_MAX);
    if(at_next == NULL){
		softap_assert("");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);
	sprintf(at_next,"AT^CARDMODE\r\n");
	return at_next;
}

char *normal_getssidset()
{
    char *at_next=NULL;
    char ssid1[50]={0};
    sc_cfg_get(NV_SSID1,ssid1,sizeof(ssid1));
    at_next=malloc(AT_CMD_MAX);
    if(at_next == NULL){
		softap_assert("");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);
    sprintf(at_next,"AT+SSID=%s\r\n",ssid1);
    return at_next;
}

char *normal_getwifikeyset()
{
    char *at_next=NULL;
    char wpapsk1[50]={0};
    sc_cfg_get(NV_WPAPSK1,wpapsk1,sizeof(wpapsk1));
    at_next=malloc(AT_CMD_MAX);
    if(at_next == NULL){
		softap_assert("");
		return NULL;
	}
    memset(at_next,0,AT_CMD_MAX);
    sprintf(at_next,"AT+WIFIKEY=%s\r\n",wpapsk1);
    return at_next;
}

char *start_csimauth_cmd(void *msg,struct at_context *context)
{
    char pdu[1024] ={0};
	int len = strlen(((MSG_BUF*)msg)->aucDataBuf);
	if(len < 2048)
    string2bytes(((MSG_BUF*)msg)->aucDataBuf, pdu, len);
    return normal_getcsimset(pdu);
}

char *start_cardmode_cmd(void *msg,struct at_context *context)
{
    return normal_getcardmode();
}

char *start_pinstatus_cmd(void *msg,struct at_context *context)
{
    return normal_getcpinread();
}

char *start_pinnum_cmd(void *msg,struct at_context *context)
{
    return normal_getzrapread();
}

char *start_crsmreq_cmd(void *msg,struct at_context *context)
{
    return normal_getcrsmset(((MSG_BUF*)msg)->aucDataBuf);
}

char *start_cimi_cmd(void *msg,struct at_context *context)
{
    return normal_getcimi();
}

char *start_getmac_cmd(void *msg,struct at_context *context)
{
    return normal_getcgsn();
}

char *start_setssid_cmd(void *msg,struct at_context *context)
{
    return normal_getssidset();
}

char *start_setwifikey_cmd(void *msg,struct at_context *context)
{
    return normal_getwifikeyset();
}

int  csim_set_ok_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    if(tCsimRes==NULL){softap_assert("");}
    *next_req=tCsimRes;
    *next_len=sizeof(T_zAt_CsimRes);
    return AT_END;
}

int csim_auto_act( char *at_paras ,int is_query_report)
{
    tCsimRes=malloc(sizeof(T_zAt_CsimRes));
    if(tCsimRes==NULL){
		softap_assert("");
		return AT_END;
	}
    memset(tCsimRes,0,sizeof(T_zAt_CsimRes));

	void *p[3] = {&tCsimRes->pduLen, tCsimRes->pdu, &tCsimRes->seq};
    at_print(AT_DEBUG,"csim_auto_act at_paras=%s!\n",at_paras);
    parse_param2("%d,%s,%d", at_paras, p);
    at_print(AT_DEBUG,"csim_auto_act pduLen=%d,pdu=%s,seq=%d!\n",
    tCsimRes->pduLen, tCsimRes->pdu, tCsimRes->seq); 

    return AT_END;
}

int  cardmode_ok_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    if(cardmode==NULL){
		softap_assert("");
		return AT_END;
	}
    switch(context->msg_id)
    {
     	case MSG_CMD_CARD_MODE_REQ:
		{
		    *next_req = cardmode;
		    *next_len = strlen(*next_req);
		    return AT_END;
	    }
   }
   return AT_END;
}

int cardmode_err_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
	switch(context->msg_id)
    {
     	case MSG_CMD_CARD_MODE_REQ:
		{		
			*next_req=malloc(20);			
			if(*next_req == NULL){
				softap_assert("");
				return AT_END;
			}
			*next_len=20;
			sprintf(*next_req,"%d", CARD_MODE_NO_SIM);
			return AT_END;
     	}
	}
	return AT_END;
}
int cardmode_auto_act( char *at_paras ,int is_query_report)
{
    cardmode = malloc(10);
    if(cardmode==NULL){
		softap_assert("");
		return AT_END;
	}
    memset(cardmode,0,10);
    if(0 == strcmp(at_paras, "0"))
    {
		sprintf(cardmode,"%d", CARD_MODE_NO_SIM);
	}
	else if(0 == strcmp(at_paras, "1"))
	{
		sprintf(cardmode,"%d", CARD_MODE_SIM);
	}
	else if(0 == strcmp(at_paras, "2"))
	{
		sprintf(cardmode,"%d", CARD_MODE_USIM);
	}
    return AT_END;
}

int  ssid_ok_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    *next_req=malloc(10);
	if(*next_req == NULL)
		return AT_END;
    *next_len=10;
    strcpy(*next_req,RSP_OK);
    return AT_END;
}

int  ssid_err_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    *next_req=malloc(10);
	if(*next_req == NULL)
		return AT_END;
    *next_len=10;
    strcpy(*next_req,RSP_ERR);
    return AT_END;
}

int  wifikey_ok_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    *next_req=malloc(10);
	if(*next_req == NULL)
		return AT_END;
    *next_len=10;
    strcpy(*next_req,RSP_OK);
    return AT_END;
}

int  wifikey_err_act(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
    *next_req=malloc(10);
	if(*next_req == NULL)
		return AT_END;
    *next_len=10;
    strcpy(*next_req,RSP_ERR);
    return AT_END;
}
