#include "at_com.h"
#include "at_netdog.h"
//ַǰΣȥ\0ȣڶԽյĴݽ

static int at_isprint(char c)
{
	return isprint(c);
}

static unsigned char at_toupper(char c)
{
	return toupper(c);
}

int trim_atstr(char *str, int str_size)
{
   char * read  = str;
   char * write = str;

   assert(str != NULL);
   for(; read < str + str_size; read++){
       if(*read == '\0'){
           NETDOG_AT_STATICS(dbg_uart_zero_chr_num++);
           continue;
       }
       if(!at_isprint(*read) && *read != '\r' && *read != '\n'){
           NETDOG_AT_STATICS(dbg_uart_no_print_num++);
           return 0;
       }
       if(write < read){
           *write = *read;
           *read = '\0';
       }
       write++;
   }
   return write - str;
}

//ʶǰǷΪATչ󣬻ڲƥ䣬
int is_req_at(char *str)
{
	char *print_char = NULL;

    assert(str != NULL);
	print_char= find_print_char(str);
    if(print_char == NULL){
        return 0;
    }
	if (at_strnstr2(print_char, "at", 2))
		return 1;
	return 0;
}
//ʶǰǷΪ"\r\nok"
int is_rsp_ok(char *str)
{
	char *print_char = NULL;

    assert(str != NULL);
	print_char = find_print_char(str);
    if(print_char == NULL){
		return 0;
    }
	if (print_char > str + 1 && *(print_char - 2) == '\r' && *(print_char - 1) == '\n' &&
	    at_strnstr2(print_char, "ok", 2))
		return 1;
	return 0;
}
//ʶǰǷΪ"\r\nerror",뷵ERRNOֵдָ
int is_rsp_err(char *str, int *err_no)
{
	char *print_char = NULL;

    assert(str != NULL);
	print_char = find_print_char(str);
    if(print_char == NULL){
        return 0;
    }
	if (print_char > str + 1 && *(print_char - 2) == '\r' && *(print_char - 1) == '\n') {
		char *err_tail;
		//"\r\n+CME ERROR""\r\n+CMS ERROR"Ҫ
		err_tail = at_strnstr2(print_char, "ERROR", 11); // kw 3
		if (err_tail) {
			//:ֵ
			if (err_no != NULL && err_tail + 2 < str + strlen(str)) {
				char *num_first = find_print_char(err_tail + 2);
                if(num_first == NULL){
                    return 0;
                }
				*err_no = atoi(num_first);
			}
			return 1;
		}
	}
	return 0;
}
//ʶǰǷΪ"\r\n"ķʽ
int is_report_at(char *str)
{
	char *print_char = NULL;

    assert(str != NULL);
	print_char = find_print_char(str);
    if(print_char == NULL){
        return 0;
    }
	//ͽ\r\nΪϱ
	if(!is_req_at(str)&&!is_rsp_err(str,NULL)&&!is_rsp_ok(str))
	{
		if(print_char>str+1&&*(print_char-2)=='\r'&&*(print_char-1)=='\n')
			return 1;
	}
	return 0;
}
int is_result_at(char *str)
{
    return (at_strstr(str, "OK\r") != NULL || at_strstr(str, "\r\n+CME ERROR") != NULL  
           || at_strstr(str, "\r\n+CMS ERROR") != NULL || at_strstr(str, "ERROR\r") != NULL || at_strstr(str, "\r\n> ") != NULL
           || at_strstr(str, "ERROR:") != NULL);
}
//ǰǷΪϷATǰ׺\r֮ǰַǷΪĸֵȴӡַ,ֹݣԶյ
int is_correct_atcmd(char *str)
{
    assert(str != NULL);
	if (is_req_at(str) || is_rsp_err(str, NULL) || is_rsp_ok(str) || is_report_at(str)) {
		char *print_head = find_print_char(str);

        if(print_head == NULL){
            return 0;
        }
        for(; *print_head != '\0' && *print_head != '\r'; print_head++){

            if(!isprint(*print_head)){
                return 0;
            }
        }
        return *print_head == '\r';
	}
	return 0;
}
//ҵַһɴӡַATǰ׺ͷͷ\nոӰ죬ΪµATַǰ׺׵ַA+
char *find_print_char(char *str)
{
    assert(str != NULL);
	for (; *str != '\0'; str++) {
		if (isgraph(*str)) {
			return str;
		}
	}
	return NULL;
}
//ǰ׺ƥ䣬srcdstģƥdst_lenĸִСд԰\r\nոȣƥɹβַ+1ԱƥַֹԽ
char * at_strnstr2(char *source, char *substr, int dst_len)
{
	const char *source_end = source + dst_len;
	const char *source_cmp = source;
	unsigned int substr_len = 0;

    assert(source != NULL && substr != NULL && dst_len >0);
	substr_len = strlen(substr);
	while (source_cmp != '\0' && source_cmp + substr_len <= source_end) {
		const char * curch_source = source_cmp;
		const char * curch_substr = substr;

		while (*curch_substr != '\0') {
			if (*curch_source == '\0' || curch_source >= source_end) {
				return NULL;
			}
			if (at_toupper(*curch_source) != at_toupper(*curch_substr)) {
				break;
			}
			curch_source++;
			curch_substr++;
		}
		if (*curch_substr == '\0') {
			return (char *)curch_source;
		}
		source_cmp++;
	}
	return NULL;
}
//ģƥdstǷsrc԰\r\nոȣƥɹβַ+1""Ӱ죬ԱƥַֹԽ
char *at_strstr2(const char * source, const char * substr)
{
	//int DIFF_VALUE = 'a'-'A';
	int ch1 = 0;
	int ch2 = 0;
	int mark_num = 0; //˫żڲƥ

    assert(source != NULL && substr != NULL);
	//ַеĴСĸתɶӦСдĸٲ
	while (*source != '\0') {
		char *p = (char *)source;
		char *q = (char *)substr;
		char *res = NULL;
		if (*p == '"')
			mark_num++;
		//˫ڲƥ
		do {
			ch1 = toupper(*(p++));
			ch2 = toupper(*(q++));
		} while (ch1 && ch2 && (ch1 == ch2) && (mark_num % 2 == 0));
		//ƥ䵽һַַԴ˵ַ
		if (ch2 == '\0')
			return p - 1;
		source++;
	}
	return NULL;
}
//ǰ׺ƥ䣬ƥɹո=:ȸţز׵ַΪգ򷵻NULL
char *get_param_str(const char * source, const char * prefix)
{
	const char * sliding_pointer = NULL;

    assert(source != NULL && prefix != NULL);
    sliding_pointer = at_strstr2(source, prefix);
	if (sliding_pointer == NULL) {
		return NULL;
	}

	for (; *sliding_pointer != '\0' && *sliding_pointer != '\r'; sliding_pointer++) {
		if (*sliding_pointer == ':') {
			return (char *)(sliding_pointer + 1);
		}
		if (*sliding_pointer == '=') {
			return (*(sliding_pointer + 1) == '?') ? NULL : (char *)(sliding_pointer + 1);
		}
	}
	return NULL;
}

