/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_pvtest.c
*  ļʶ  
*  ļ  
*  ʵֹ  
*        
*  汾      V1.0
*    2014-11-21
*  ˵  
*
*******************************************************************************/

#include "mmi_common.h"
#include "zctrm_ext.h"
#include "RONvParam_AMT.h"

typedef struct {
	char at[32];
	ZCTRM_ATEXT_FUN func;
} T_PvTest_At;

#define ZPS_CTRM_MSINFO_NVINFO_BASE_ADDR 0xB8
#define ZPS_CTRM_MSINFO_MAX_NVINFO_LEN 200

/**********************************************************************************
*˵õص
************************************************************************************/
static SINT32 pvtest_GetBatteryLevel(VOID)
{
	UINT32 voltage_now = 0;
	SINT32 bat_level = 0;
	T_ZDrvIO_Handle chgHandle = NULL;
	chgHandle = mmi_open(CHG_DEV, 1);
	zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "pvtest_GetBatteryLevel open CHE_DEV chgHandle = %x!!\n", chgHandle);
	if (chgHandle == NULL) {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "pvtest_GetBatteryLevel open CHE_DEV error!!\n");
		zOss_ASSERT(0);
	}
	voltage_now = mmi_voltage_state_read();
	bat_level = get_voltage_level_from_table(voltage_now);
	return bat_level;
}

/**********************************************************************************
*˵յAT 
************************************************************************************/
/**************************************************************************
* : zPvTest_ProGetBatteryLevel
* : ѯص
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static SINT32 zPvTest_ProGetBatteryLevel(UINT8 channel_id, const UINT8 *buff, UINT16 buffer_len, T_zAti2_CtrmChInd chInd)
{
	CHAR  *pStrAt   = NULL;
	SINT32 batLevel = 0;
	char pPtr[30] = {0};
	ZOSS_THREAD_ID m_ledtest_thread = ZOSS_INVALID_THREAD_ID;
	if ((pStrAt = strstr((const char *)buff, "AT+ZBATTERYLEVEL?")) != 0) {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "PVTEST zPvTest_ProGetBatteryLevel!\n");
		batLevel = pvtest_GetBatteryLevel();
		sprintf((char *)pPtr, "\r\n%s%ld%%", "+ZBATTERYLEVEL:", batLevel);
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "pPtr = %s\r", pPtr);
		strcat((char *)pPtr, "\r\n\r\nOK\r\n");
		zCtrm_PsCallbackEntry(channel_id, pPtr, strlen((const char *)pPtr), chInd);
		return -1;
	}
	return 0;
}

/**************************************************************************
* : zPvTest_ProReset
* : ָ(ɾ)
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static SINT32 zPvTest_ProReset(UINT8 channel_id, const UINT8 *buff, UINT16 buffer_len, T_zAti2_CtrmChInd chInd)
{
	UINT32 retCode = ZOSS_ERROR;
	CHAR  *pStrAt   = NULL;
	char pPtr[15] = {0};
	if ((pStrAt = strstr((const char *)buff, "AT+ZRESET")) != 0) {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "PVTEST zPvTest_ProReset!\n");
		//retCode = zte_mgmt_restore_comm(FALSE, TRUE);
		if (retCode != ZOSS_ERROR) {
			sprintf((char *)pPtr, "\r\nOK\r\n");
		} else {
			sprintf((char *)pPtr, "\r\n%s\r\n", "ERROR");
		}

		zCtrm_PsCallbackEntry(channel_id, pPtr, strlen((const char *)pPtr), chInd);
		return -1;
	}
	return 0;
}

/**************************************************************************
* : zPvTest_ProResetSms
* : ָãţ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
/*static SINT32 zPvTest_ProResetSms(UINT8 channel_id, const UINT8 *buff, UINT16 buffer_len, T_zAti2_CtrmChInd chInd)
{
	CHAR  *pStrAt   = NULL;
	char pPtr[10] = {0};
    if((pStrAt=strstr((const char *)buff,"AT+ZRESETSMS"))!=0)
    {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL,"PVTEST zPvTest_ProReset!\n");
		zte_mgmt_restore_comm();
		sprintf((char *)pPtr,"\r\nOK\r\n");
    	zCtrm_PsCallbackEntry(channel_id, pPtr, strlen((const char *)pPtr), chInd);
		return -1;
    }
	return 0;
}*/

/**************************************************************************
* : zPvTest_ProPoweroff
* : ػ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static SINT32 zPvTest_ProPoweroff(UINT8 channel_id, const UINT8 *buff, UINT16 buffer_len, T_zAti2_CtrmChInd chInd)
{
	CHAR  *pStrAt   = NULL;
	char pPtr[10] = {0};
	if ((pStrAt = strstr((const char *)buff, "AT+ZPOWEROFF")) != 0) {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "PVTEST zPvTest_ProPoweroff!\n");
		zOss_SysPowerdown();
		sprintf((char *)pPtr, "\r\nOK\r\n");
		zCtrm_PsCallbackEntry(channel_id, pPtr, strlen((const char *)pPtr), chInd);
		return -1;
	}
	return 0;
}

/**************************************************************************
* : zPvTest_ProReadNvInfo
* : NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static SINT32 zPvTest_ProReadNvInfo(UINT8 channel_id, const UINT8 *buff, UINT16 buffer_len, T_zAti2_CtrmChInd chInd)
{
	UINT32 retCode = ZOSS_ERROR;
	UINT8  buffNv[ZPS_CTRM_MSINFO_MAX_NVINFO_LEN + 1] = {0};
	CHAR  *pStrAt   = NULL;
	char pPtr[ZPS_CTRM_MSINFO_MAX_NVINFO_LEN + 30] = {0};
	if ((pStrAt = strstr((const char *)buff, "AT+RTESTINFO")) != 0) {
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "PVTEST zPvTest_ProReadNvInfo!\n");

		retCode = zPS_NvAMTItemRead(ABTESTINFO_NVPARAM, buffNv, ZPS_CTRM_MSINFO_MAX_NVINFO_LEN);
		if (retCode != ZOSS_ERROR) {
			sprintf((char *)pPtr, "\r\n+RTESTINFO:%s", buffNv);
			strcat((char *)pPtr, "\r\n\r\nOK\r\n");
		} else {
			sprintf((char *)pPtr, "\r\n%s\r\n", "ERROR");
		}
		zCtrm_PsCallbackEntry(channel_id, pPtr, strlen((const char *)pPtr), chInd);
		return -1;
	}
	return 0;
}

T_PvTest_At g_PvTest_Reg_At[] = {
	{"AT+ZBATTERYLEVEL?",   zPvTest_ProGetBatteryLevel},
	{"AT+ZRESET",   zPvTest_ProReset},
	//{"AT+ZRESETSMS",   zPvTest_ProResetSms},
	{"AT+RTESTINFO",   zPvTest_ProReadNvInfo},
	{"AT+ZPOWEROFF", zPvTest_ProPoweroff}
};

/**********************************************************************************
*˵ں
************************************************************************************/
VOID zPvTest_Entry(VOID)
{
	UINT32 i = 0;

	for (i = 0; i < sizeof(g_PvTest_Reg_At) / sizeof(T_PvTest_At); ++ i) {
		if (0 == zCtrm_ExtRegisterAT(g_PvTest_Reg_At[i].at, strlen(g_PvTest_Reg_At[i].at), g_PvTest_Reg_At[i].func)) {
			zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "PVTEST zPvTest_Entry zCtrm_ExtRegisterAT %s success!\n", g_PvTest_Reg_At[i].at);
		}
	}
}


