/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   httpsģ
* ļƣ unicom_dm.c
* ļʶ
* ժҪ
*
* ޸      汾     ޸ı       ޸       ޸
* ----------------------------------------------------------------------
* 2017          1.0                       chentianming
************************************************************************/

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include <string.h>
#include <openssl/aes.h>
#include <openssl/evp.h>
#include <openssl/md5.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>

#include <unistd.h>
#include <assert.h>
#include <sched.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <netdb.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/signal.h>

#include "include/unicom_dm.h"
#include "softap_api.h"
/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#define DM_PKCS5_SIZE(x)                   ((x)<16?16:(((x)/16 + 1) * 16))
#define MD5_DIGEST_LENGTH 16
#define DM_AES_ECB_ENCRYPT_KEY_LENGTH        128
#define DM_DIGEST_LENGHT                     16
#define DM_PRIV_FILE_PATH                    "/etc/pri.pem"
#define DM_PUBLIC_KEY_PATH                   "/etc/pubkey.pem"               //"pub.pem"
#define HTTPS_HEAD_DATA_LENGTH				 512
#define SEARCH_STR_RETURN_CODE_HTTPS		 "200"

#define HTTP_SEARCH_LENGTH                	 512
#define RECV_BUFFER_LENGTH				 	 512

#define log(...)            do { printf(__VA_ARGS__); fflush(stdout); } while(0)
#define log_err(...)        do { log("DM-ERR NOW: FILE(%s) , LINE(%d) >>>>: ", __FILE__, __LINE__ );  printf(__VA_ARGS__); fflush(stdout);} while(0)

#define DM_FOR_DEBUG_ENCRYPT
#define __DM_DEBUG__

#ifdef __DM_DEBUG__
#define log_debug(...)      do { log("dm-debug now: file(%s) ,line(%d) >>>>: ", __FILE__, __LINE__); printf(__VA_ARGS__); fflush(stdout);} while(0)
#else
#define log_debug(...)
#endif

#define CALL(x) do { int t_ret = (x); if (t_ret != ERR_SUCCESS) { log_err("Get t_ret(%d)\n", t_ret); return t_ret;} } while (0)
#define CHECK_PARAM(X)  do {if(X) {log_err("the param is null\n");  return ERR_PARAM_NULL;} } while(0)
#define ASSER_VOID(X)   do {if(X) {log_err("the param is null\n");  return;}                } while(0)
/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                                                                *
 **************************************************************************/
/*******************ܵݽṹ ********************************/
typedef struct __ENCRYPT_DATA__
{
    char *dataBuffer;
    unsigned int dataSize;
} ENCRYPT_DATA;

/***********************ӵϢṹ***************************/
typedef struct _HTTPS_CONNECTION_INFO_
{
    int socketId;
    int isHttps;
    SSL_METHOD* sslMethod;
    SSL_CTX* sslCtx;
    SSL* ssl;
} HTTPS_CONNECTION_INFO;

/***************base64ṹ**********************************/
typedef struct _BASE64_DATA_INFO_
{
    char *dataBuffer;
    int dataSize;
} BASE64_DATA_INFO;

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/

/**************************************************************************
 *                         ̬                                    *
 **************************************************************************/
static int dm_aes_ecb_pandding(char *in, char *out);
static int dm_aes_ecb_encrypt_panding(const ENCRYPT_DATA *in, const ENCRYPT_DATA  *out);

static int dm_aes_ecb_enscrypt(ENCRYPT_DATA *in, ENCRYPT_DATA *out,  AES_KEY *key);

static int dm_create_aes_encrypt_key(const ENCRYPT_DATA *in, AES_KEY *key);
static int dm_create_aes_decrypt_key(ENCRYPT_DATA *in,  AES_KEY *key);

static int dm_aes_ecb_encrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key);
static int dm_aes_ecb_decrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key);

static int dm_http_request_handle(DM_UNICOM_HTTP_URL_INFO *urlInfo, ENCRYPT_DATA *inEncryptData, DM_UNICOM_HTTP_DATA_INFO *inData, DM_UNICOM_HTTP_DATA_INFO *recData);
static int dm_http_request_start(DM_UNICOM_HTTP_URL_INFO *urlInfo, DM_UNICOM_HTTP_DATA_INFO *inData, DM_UNICOM_HTTP_DATA_INFO *recData);
static void dm_hex_print(char *str, int len);
//static char *pt(unsigned char *md, int len);
static void dm_base64_encode(ENCRYPT_DATA *in, ENCRYPT_DATA *out,  int withNewLine);
static void dm_base64_decode(ENCRYPT_DATA *in, ENCRYPT_DATA *out,  int withNewLine);
static int dm_Url_Encode(const char* str, const int strSize, char* result, const int resultSize);


static int http_socket_connect(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_URL_INFO *urlInfo);
static int http_socket_create(HTTPS_CONNECTION_INFO *connectionInfo);
static void http_protocol_packet_create(DM_UNICOM_HTTP_URL_INFO *smsUrlInfo, ENCRYPT_DATA *sendEncryptData, ENCRYPT_DATA *signData, DM_UNICOM_HTTP_DATA_INFO *httpsPacket);
static int http_request_handle(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_DATA_INFO *httpsPacket, DM_UNICOM_HTTP_DATA_INFO *recData);
static char *http_packet_parse(char *srcPackket, char *str);

static unsigned long dm_get_ip_byhostname(char *hostName);
//static int  http_recv_data(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_DATA_INFO *recData);
static int http_socket_recv(HTTPS_CONNECTION_INFO * connectionInfo, DM_UNICOM_HTTP_DATA_INFO * recData);

static void dm_url_param_encode_handle(DM_UNICOM_HTTP_URL_INFO *urlInfoSrc, DM_UNICOM_HTTP_URL_INFO *urlInfoDest);
/**************************************************************************
*                         ̬                                   *
**************************************************************************/
/**
 * ƣ http_packet_parse
 *  жhttpsݰַָ
 * ˵
 *   ֵ
 * ˵ ҪŻݽ
 */
static char * http_packet_parse(char *srcPackket, char *str)
{
    if (!srcPackket || !str)
        return NULL;

    return strstr(srcPackket, str);
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ
 * ˵ 
 */
static void dm_hex_print(char *str, int len)
{
    int i = 0;
    for (i = 0; i < len; i++)
    {
        printf("%s%02x%s", ((i % 16 == 0 ? "|" : "")), *((unsigned char*)str + i), (((i + 1) % 16 == 0) ? "|\n" : " "));
    }
    if (i % 16 != 0)
        printf("|\n");
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int  dm_aes_ecb_pandding(char *in, char *out)
{
    int inSize = 0;
    int i = 0;
    int remainIndex = 0;
    int outSize = 0;

    CHECK_PARAM(!in || !out);

    inSize = strlen(in);
    remainIndex = inSize % 16;
    /* using PKCS5 panding */
    if (inSize < 16)
    {
        char input[16] = {0};
        for (i = 0; i < 16; i++)
        {
            if (i < remainIndex)
            {
                input[i] = in[i];
            }
            else
            {
                input[i] = 16 - inSize; /* */
            }
        }
        outSize = 16;
        if (!strncpy(out, input, 16))
        {
            log_err("aes pandding strncpy erro \n");
            return ERR_PANDDING_ERROR;
        }

    }
    else     /*  16 ֽ 龰*/
    {
        int group = inSize / 16;
        int size = 16 * (group + 1);
        char input[size];
        for (i = 0; i < size; i++)
        {
            if (i < inSize)
            {
                input[i] = in[i];
            }
            else
            {
                if (remainIndex == 0)
                {
                    input[i] = 0x10;
                }
                else
                {
                    int dif = size - inSize;
                    input[i] = dif;
                }
            }
        }

        outSize = size;
        if (!strncpy(out, input, size))
        {
            log_err("aes pandding strncpy erro \n");
            return ERR_PANDDING_ERROR;
        }
    }
    log_debug("aes pad src data ***************\n");
    log_debug("%s\n", in);

    log_debug("aes pad dest data hex output****\n");
    dm_hex_print(out, outSize);

    log_debug("aes pad what hex to data **********\n");
    dm_hex_print(out + outSize - 16, 16);
    return ERR_SUCCESS;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_encrypt_panding(const ENCRYPT_DATA *in, const ENCRYPT_DATA  *out)
{
    int inSize = 0;
    int ret = 0;

    CHECK_PARAM(!in || !out);

    /* using pkcs5 pandding now
     * first checking the size
     * */
    inSize = out->dataSize;

    memset(out->dataBuffer, 0, inSize);
    if (ERR_SUCCESS != (ret =  dm_aes_ecb_pandding(in->dataBuffer, out->dataBuffer)))
    {
        log_err("dm aes pandding error\n");
        return ret;
    }

    return ERR_SUCCESS;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_enscrypt(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key)
{

    const int enc = AES_ENCRYPT;
    int i = 0;
    char *inDataBuffer = NULL;
    char *outDatabuffer = NULL;
    int inSize = 0;

    CHECK_PARAM(!in || !out || !key);

    inDataBuffer = in->dataBuffer;
    inSize = in->dataSize;
    outDatabuffer = out->dataBuffer;
    /* encrypt now  */
    for (i = 0; i < inSize / 16; i++)
    {
        AES_ecb_encrypt((const unsigned char *)(inDataBuffer + (i * 16)), (unsigned char *)(outDatabuffer + (i * 16)), (const AES_KEY *)key, enc);
    }

    return ERR_SUCCESS;

}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_encrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key)
{
    ENCRYPT_DATA inData = {0};
    int ret = 0;

    CHECK_PARAM(!in || !out);

    inData.dataSize = DM_PKCS5_SIZE((in->dataSize));
    inData.dataBuffer = (char *)malloc(inData.dataSize);
    if (!inData.dataBuffer)
    {
        log_err("encrypt handle malloc error \n");
        return ERR_MEM_ALLOC_ERROR;
    }
    memset(inData.dataBuffer, 0, inData.dataSize);
    if (ERR_SUCCESS != (ret = dm_aes_ecb_encrypt_panding(in, &inData)))
    {
        free(inData.dataBuffer);
        inData.dataBuffer = NULL;
        log_err("dm encrypt fail \n");
        return ret;
    }

    if (ERR_SUCCESS != (ret = dm_aes_ecb_enscrypt(&inData, out, key)))
    {
        free(inData.dataBuffer);
        inData.dataBuffer = NULL;
        log_err("dm eas ecb encrypt fail \n");
        return ret;
    }

    free(inData.dataBuffer);
    inData.dataBuffer = NULL;
    return ERR_SUCCESS;
}


/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_create_aes_encrypt_key(const ENCRYPT_DATA *in, AES_KEY *key)
{
    int dataSize = 0;
    char *dataBuffer = NULL;
    int ret = 0;
    /*Using the md5, so the length = MD5_DIGEST_LENGTH */
    unsigned char md[MD5_DIGEST_LENGTH] = {0};
    CHECK_PARAM(!in || !key);

    dataBuffer = in->dataBuffer;
    dataSize = in->dataSize;
    if (0 == (ret = EVP_Digest(dataBuffer, dataSize, md, NULL, EVP_md5(), NULL)))
    {
        log_err("create md5 fail\n");
        return ERR_CREATE_DM5_KEY_ERRRO;
    }

    /* for printf md(md5)*/
    log_debug("md5-value hex-output: \n");
    dm_hex_print((char *)md, MD5_DIGEST_LENGTH);

    if (0 != (ret = AES_set_encrypt_key(md, DM_AES_ECB_ENCRYPT_KEY_LENGTH, key)))
    {
        log_err("create aes encrypt Aes-key fail\n");
        return ERR_CREATE_ENCRYPT_KEY_ERROR;
    }

    return ERR_SUCCESS;
}

#if 0
/**
 * ƣ
 *  ժҪϢ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static char *pt(unsigned char *md, int len)
{
    int i = 0;
    static char buf[DM_AES_ECB_ENCRYPT_KEY_LENGTH * 8] = {0};

    memset(buf, 0, DM_AES_ECB_ENCRYPT_KEY_LENGTH * 8);
    for (i = 0; i < len; i++)
    {
        sprintf(&(buf[i * 2]), "%02x", md[i]);
    }
    return (buf);
}

/**
* ƣ http_socket_recv
*  http
* ˵
*   ֵ ɹERR_SUCCESSʧܷӦĴ
* ˵ 
*/
static int  http_recv_data(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_DATA_INFO *recData)
{
    int recvMaxLen = 0;
    int ret = 0;

    recvMaxLen = recData->dataLen;
    ret = recv(connectionInfo->socketId, recData->dataBuffer, recvMaxLen - 1, 0);
    log_debug("recvMaxLen (%d)\n", recvMaxLen - 1);
    if (ret > 0)   /*right */
    {
        recData->httpHeadSize = ret;
        log_debug("recv data now...recv-length(%d)\n", ret);
        return ERR_SUCCESS;

    }
    else
    {
        if ((ret < 0) && (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR))   //⼸ִ룬Ϊģ
        {
            log_debug("ret(%d), errno(%d)\n", ret, errno);
            return ERR_SUCCESS;
        }
        if (0 == errno)
        {
            log_debug(" recv data now, errno(%d)\n", errno);
            recData->httpHeadSize = 0;
            return ERR_SUCCESS;
        }
        log_err("rev data erron now, errno(%d), socket fd(%d)\n", errno, connectionInfo->socketId);
        return ERR_RECV_ERROR;
    }
    return ERR_SUCCESS;
}

#endif

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_create_digest_sign(DM_UNICOM_HTTP_DATA_INFO *inData, ENCRYPT_DATA *signData)
{
    FILE *file = NULL;
    RSA *p_rsa = NULL;
    int dataLen = 0;
    char *dataBuffer = 0;
    int ret = 0;
    unsigned char md[DM_DIGEST_LENGHT] = {0};

    CHECK_PARAM(!inData || !(inData->dataBuffer) ||  !signData);

    dataBuffer = inData->dataBuffer;
    dataLen = inData->dataLen;

    if (0 == (ret = EVP_Digest(dataBuffer, dataLen, md, NULL, EVP_md5(), NULL)))
    {
        log_err("evp digest err, ret(%d) \n", ret);
        return ERR_EVP_DIGEST_ERROR;
    }

    if ((file = fopen(DM_PRIV_FILE_PATH, "r")) == NULL)
    {
        log_err("open key file error");
        return -1;
    }

    if (NULL == (p_rsa = PEM_read_RSAPrivateKey(file, NULL, NULL, NULL)))
    {
        fclose(file);
        log_err("create digest sign, read rsaprivatekey error\n");
        return ERR_RSA_READ_KEY_ERROR;
    }

    if (0 >= (ret = RSA_private_encrypt(DM_DIGEST_LENGHT, md, (unsigned char *)(signData->dataBuffer), p_rsa, RSA_PKCS1_PADDING)))
    {
        RSA_free(p_rsa);
        fclose(file);
        log_err("create signe asa private encrypt  ret(%d) \n", ret);
        return ERR_RSA_ENCRYPT_ERROR;
    }

#ifdef  DM_FOR_DEBUG_ENCRYPT
    /* for debug now out put the sign*/
    {
        if (p_rsa)
        {
            RSA_free(p_rsa);
            p_rsa = NULL;
        }
        if (file)
        {
            fclose(file);
            p_rsa = NULL;
        }

        char outTmep[16] = {0};
        if ((file = fopen(DM_PUBLIC_KEY_PATH, "r")) == NULL)
        {
            log_err("open key file error");
            return ERR_RSA_READ_KEY_ERROR;
        }

        if ((p_rsa = PEM_read_RSA_PUBKEY(file, NULL, NULL, NULL)) == NULL)
        {
            /*	if((p_rsa=PEM_read_RSAPublicKey(file,NULL,NULL,NULL))==NULL){   for later using */
            log_err("read key fail\n");
            fclose(file); //klockworks issue.
            return -1;
        }

        RSA_public_decrypt(DM_AES_ECB_ENCRYPT_KEY_LENGTH, (const unsigned char *)(signData->dataBuffer), (unsigned char *)outTmep, p_rsa, RSA_PKCS1_PADDING);

        log_debug("sign data hex output ************\n");
        log_debug("len(%d) content as following \n", signData->dataSize);
        dm_hex_print(signData->dataBuffer, DM_AES_ECB_ENCRYPT_KEY_LENGTH);
    }
#endif

    if (p_rsa)
        RSA_free(p_rsa);
    if (file)
        fclose(file);

    return ERR_SUCCESS;
}

/**
 * ƣ http_socket_create
 *  socketͨ
 * ˵ connectionInfo 洢Ϣṹ
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int http_socket_create(HTTPS_CONNECTION_INFO *connectionInfo)
{
    connectionInfo->socketId = socket(AF_INET, SOCK_STREAM, 0);
    struct timeval  timeOut = {10, 0};
    if (connectionInfo->socketId < 0)
    {
        log_err("can not create socket id \n");
        return  ERR_SOCKET_CREATE_ERROR;
    }

    /*set timeout for reading/writing */
	if(0 != setsockopt(connectionInfo->socketId, SOL_SOCKET, SO_SNDTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_SNDTIMEO err...\n");
	}
    if(0 != setsockopt(connectionInfo->socketId, SOL_SOCKET, SO_RCVTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_RCVTIMEO err...\n");
	}
    return  ERR_SUCCESS;
}

/**
 * ƣ http_socket_connect
 *  https
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int http_socket_connect(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_URL_INFO *urlInfo)
{
    struct sockaddr_in toAddr = {0};
    int ret = 0;
    unsigned long ipAddr = 0;
    static int connectNum = 0;

    /*first using IP address, sencond using hostName*/
    if (INADDR_NONE == (ipAddr = inet_addr(urlInfo->ipAddr)))
    {
        struct timeval startTime = {0};
        struct timeval endTime = {0};
        //test time now
        gettimeofday(&startTime, NULL);
        ipAddr = dm_get_ip_byhostname(urlInfo->hostName);
        gettimeofday(&endTime, NULL);
        log_debug("https get ip by hostName casting  time (%d) \n", (endTime.tv_sec - startTime.tv_sec) * 1000 + (endTime.tv_usec - startTime.tv_usec) / 1000);
        if (0 == ipAddr)
        {
            log_err("can not find ip addr..., hostName(%s)error-value(%d)\n", urlInfo->hostName, errno);
            return ERR_SOCKET_NO_IP;
        }
    }

    toAddr.sin_addr.s_addr = ipAddr;
    toAddr.sin_family	   = AF_INET;
    toAddr.sin_port 	   = htons((unsigned short)urlInfo->portNum);
    bzero(&(toAddr.sin_zero), 8);

    //klockworks issue.
    log_debug("Send IP string (%s), port(%d), IPaddress(%lu), toAddr.sin_addr.s_addr(%lu)\n", inet_ntoa(toAddr.sin_addr), urlInfo->portNum, ipAddr, toAddr.sin_addr.s_addr);
    connectNum = 2;

CONNECT_SOCKET:
    if (-1 == (ret = connect(connectionInfo->socketId, (struct sockaddr *)&toAddr, sizeof(struct sockaddr))))
    {
        while (connectNum-- > 0)
        {
            close(connectionInfo->socketId);
            connectionInfo->socketId = 0;
            log_debug("http socket connect	connectNum(%d)\n", connectNum);
            usleep(1000 * 600);
            if (ERR_SUCCESS != (ret = http_socket_create(connectionInfo)))
            {
                log_err("create socket fail \n");
                return ERR_SOCKET_CREATE_ERROR;
            }
            goto CONNECT_SOCKET;

        }

        log_err("https socket connect fail ret(%d), connectNum(%d),  eeror(%d)\n", ret, connectNum, errno);
        return ERR_SOCKET_CONNECT_ERROR;
    }

    return ERR_SUCCESS;
}

/**
 * ƣ http_protocol_packet_create
 *  http͵Э,ݵû
 * ˵
 *   ֵ
 * ˵ 
 */
static void http_protocol_packet_create(DM_UNICOM_HTTP_URL_INFO *smsUrlInfo, ENCRYPT_DATA *sendEncryptData, ENCRYPT_DATA *signData, DM_UNICOM_HTTP_DATA_INFO *httpsPacket)
{
    char *url = NULL;
    char *httpsPacketData = NULL;
    char buf[12] = {0};
    int  dataLen = 0;

    if (!smsUrlInfo || ! httpsPacket || !sendEncryptData)   //klockworks issue.
    {
        log_err("create https packet param is null\n");
        return ;
    }

    url  = smsUrlInfo->urlBuffer;
    httpsPacketData = httpsPacket->dataBuffer;
    memset(httpsPacketData, 0, httpsPacket->dataLen);

    snprintf(buf, sizeof(buf) - 1, "%d", sendEncryptData->dataSize); //sendEncryptData->dataSize);

    strcat(httpsPacketData, "POST ");
    strcat(httpsPacketData, url);
    strcat(httpsPacketData, signData->dataBuffer);

    strcat(httpsPacketData, " HTTP/1.1\r\n");

    //strcat(httpsPacketData, "Host: dm.wo.com.cn\r\n");
    strcat(httpsPacketData, "Host: ");
    strcat(httpsPacketData, smsUrlInfo->hostName);
    strcat(httpsPacketData, "\r\n");

    strcat(httpsPacketData, "Content-Length: ");
    strcat(httpsPacketData, buf);
    strcat(httpsPacketData, "\r\n");

    strcat(httpsPacketData, "Accept: */*\r\n");
    strcat(httpsPacketData, "Content-Type: application/encrypted-json\r\n");
    strcat(httpsPacketData, "Connection: Keep-Alive\r\n");
    strcat(httpsPacketData, "\r\n");

    dataLen = strlen(httpsPacketData);
    log_debug("create http packet now content(%s), len(%d)\n", httpsPacketData, dataLen);
    if((sendEncryptData->dataBuffer) && (sendEncryptData->dataSize != 0))
    {
        memcpy((httpsPacketData + dataLen), sendEncryptData->dataBuffer, sendEncryptData->dataSize);

        httpsPacketData[dataLen + sendEncryptData->dataSize] = '\r';
        httpsPacketData[dataLen + sendEncryptData->dataSize + 1] = '\n';
    }

    httpsPacket->dataLen = dataLen + sendEncryptData->dataSize + 2; // strlen("\r\n") = 2;

    log_debug("encrypt data len(%d), httpPacket-len(%d)\n", sendEncryptData->dataSize, httpsPacket->dataLen);
}

/**
 * ƣ http_socket_recv
 *  http
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int http_socket_recv(HTTPS_CONNECTION_INFO * connectionInfo, DM_UNICOM_HTTP_DATA_INFO * recData)
{
    int ret = 0;
    fd_set fds;
    int recvMaxLen = 0;
    struct timeval timeOut = {10, 0};

    CHECK_PARAM(!connectionInfo || !recData);

    while (1)
    {

        FD_ZERO(&fds);
        FD_SET(connectionInfo->socketId, &fds);
        switch (select(connectionInfo->socketId + 1, &fds, NULL, NULL, &timeOut))   //select
        {
        case -1:
        {
            log_err("select errno(%d)\n", errno);
            return ERR_RECV_ERROR;
        }
        case 0:
        {

            log_debug("recv timeout now , recData totalSize(%d), recv-data(%s)\n", recData->totalSize, recData->dataBuffer);
            return ERR_RECV_ERROR; /*no data or timeout*/
        }
        default:
            if (FD_ISSET(connectionInfo->socketId, &fds))   /*sockǷɶ*/
            {
                recvMaxLen = recData->dataLen;
                ret = recv(connectionInfo->socketId, recData->dataBuffer, recvMaxLen - 1, 0);

                if (ret > 0)   /*right */
                {
                    recData->httpHeadSize = ret;
                    recData->totalSize = ret;
                    log_debug("recv data now...recv-length(%d), recv-data(%s)\n", ret, recData->dataBuffer);
                    return ERR_SUCCESS;
                }
                else
                {
                    if ((ret < 0) && (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR))   //⼸ִ룬Ϊģ
                    {
                        log_debug("ret(%d), errno(%d)\n", ret, errno);
                        return ERR_SUCCESS;
                    }

                    log_err("rev data erron now, errno(%d), socket fd(%d)\n", errno, connectionInfo->socketId);
                    return ERR_RECV_ERROR;
                }

            }

        }// end switch

    }

    return ERR_SUCCESS;
}

/**
 * ƣ http_request_handle
 *  smsʼ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷ
 * ˵ 
 */
static int  http_request_handle(HTTPS_CONNECTION_INFO *connectionInfo, DM_UNICOM_HTTP_DATA_INFO *httpsPacket, DM_UNICOM_HTTP_DATA_INFO *recData)
{
    int ret = 0;
    int sendLen = httpsPacket->dataLen;
    char *sendBuf = httpsPacket->dataBuffer;

    ret = send(connectionInfo->socketId, sendBuf, sendLen, 0);
    if (ret < 0)
    {
        log_err("http send data error\n");
        return ERR_SEND_ERROR;
    }
    log_debug("send content now, want send len(%d), realy send len(%d)\n", sendLen, ret);

    if (ERR_SUCCESS != (ret =  http_socket_recv(connectionInfo, recData)))
    {
        log_debug("http_socket_recv error, ret(%d), recvData-buffer(%s), recData-totalSize(%d), recData-httpHeadSize(%d)\n", ret, recData->dataBuffer, recData->totalSize, recData->httpHeadSize);
        return ret;
    }

    return ERR_SUCCESS;
}

/**
 * ƣ dm_get_ip_byhostname
 * 
 * ˵
 *   ֵ
 * ˵ 
 */
static unsigned long dm_get_ip_byhostname(char *hostName)
{
    struct addrinfo    hints           = { 0 };
    struct addrinfo    *result         = NULL;
    struct addrinfo    *result_pointer = NULL;
    unsigned long ipAddr = 0;
    int ret = 0;
    ret = getaddrinfo(hostName, NULL, &hints, &result);
    if (ret != 0)
    {
        log_debug("can not get ip addr by hostName\n");
        return 0;
    }

    for (result_pointer = result; result_pointer != NULL; result_pointer = result_pointer->ai_next)
    {
        char hostNameTemp[1025] = {0};

        if (result_pointer->ai_family == AF_INET6)
        {
            continue;
        }

        ret = getnameinfo(result_pointer->ai_addr, result_pointer->ai_addrlen, hostNameTemp, sizeof hostNameTemp, NULL, 0, NI_NUMERICHOST);
        if (ret != 0)
        {
            log_debug("error in getnameinfo: %s.\n", gai_strerror(ret));
            continue;
        }

        log_debug("Server ip = %s.\n", hostNameTemp);
        ipAddr = (unsigned long)inet_addr(hostNameTemp);
        freeaddrinfo(result); //klockworks issue.
        return ipAddr;
    }

    freeaddrinfo(result); //klockworks issue.
    return 0;
}

/**
 * ƣ
 *  urḷ
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_Url_Encode(const char* str, const int strSize, char* result, const int resultSize)
{
    int i;
    int j = 0;//for result index
    char ch;

    if ((!str || !result) || (strSize <= 0) || (resultSize <= 0))
    {
        return 0;
    }

    for (i = 0; (i < strSize) && (j < resultSize); ++i)
    {
        ch = str[i];
        if (((ch >= 'A') && (ch < 'Z')) ||
                ((ch >= 'a') && (ch < 'z')) ||
                ((ch >= '0') && (ch < '9')))
        {
            result[j++] = ch;
        }
        else if (ch == ' ')
        {
            result[j++] = '+';
        }
        else if (ch == '.' || ch == '-' || ch == '_' || ch == '*')
        {
            result[j++] = ch;
        }
        else
        {
            if (j + 3 < resultSize)
            {
                sprintf(result + j, "%%%02X", (unsigned char)ch);
                j += 3;
            }
            else
            {
                return 0;
            }
        }
    }

    result[j] = '\0';
    return j;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_http_request_handle(DM_UNICOM_HTTP_URL_INFO *urlInfo, ENCRYPT_DATA *sendEncryptData, DM_UNICOM_HTTP_DATA_INFO *inData, DM_UNICOM_HTTP_DATA_INFO *recData)
{

    ENCRYPT_DATA signData = {0};
    ENCRYPT_DATA base64Out = {0};
    char signBuffer[DM_AES_ECB_ENCRYPT_KEY_LENGTH] = {0};
    HTTPS_CONNECTION_INFO connectionInfo = {0};
    DM_UNICOM_HTTP_DATA_INFO httpsPacket  = {0};
    int sendDataLength = 0;
    char *sendData = NULL;
    int  base64Size = 0;
    int  urlMaxEncodeLen = 0;
    int ret = 0;

    CHECK_PARAM(!urlInfo || !sendEncryptData || !inData);

    signData.dataBuffer = signBuffer;
    signData.dataSize = DM_AES_ECB_ENCRYPT_KEY_LENGTH;

    CALL(dm_create_digest_sign(inData, &signData));

    /* handle the signdata to base64 */
    dm_base64_encode(&signData, &base64Out, 1);

    base64Size = base64Out.dataSize;
    char base64TemData[base64Size + 1];
    memset(base64TemData, 0, base64Size + 1);
    memcpy(base64TemData, base64Out.dataBuffer, base64Out.dataSize);
    free(base64Out.dataBuffer);


    signData.dataBuffer = base64TemData;
    signData.dataSize = base64Out.dataSize;

#ifdef  DM_FOR_DEBUG_ENCRYPT
    /*get base64 decode */
    {
        ENCRYPT_DATA base64DecodeOut = {0};
        dm_base64_decode(&signData, &base64DecodeOut, 1);

        /* the len should == src len */
        base64DecodeOut.dataSize = DM_AES_ECB_ENCRYPT_KEY_LENGTH;

        log_debug("sign -> base64 encode data hex output ***********\n");
        log_debug("len(%d) content as following \n", signData.dataSize);

        log_debug("base64 decode data -> sign hex ouput ************\n");
        log_debug("len(%d)	content as following \n", base64DecodeOut.dataSize);
        if(NULL != base64DecodeOut.dataBuffer)
        {
			dm_hex_print(base64DecodeOut.dataBuffer, base64DecodeOut.dataSize);

	        free(base64DecodeOut.dataBuffer);
	        base64DecodeOut.dataBuffer = NULL;
		}        
    }
#endif


    /* url encode now ...*/
    urlMaxEncodeLen = signData.dataSize * 3 + 1;
    char urlEnCodeBuffer[urlMaxEncodeLen];
    int urlEnCodeLen = 0;

    memset(urlEnCodeBuffer, 0, urlMaxEncodeLen);
    if (0 >= (urlEnCodeLen = dm_Url_Encode(signData.dataBuffer, signData.dataSize, urlEnCodeBuffer, urlMaxEncodeLen)))
    {
        return ERR_URL_ENCODE_ERROR;

    }

    signData.dataBuffer = urlEnCodeBuffer;
    signData.dataSize = urlEnCodeLen;

    if ((sendEncryptData->dataBuffer) && sendEncryptData->dataSize > 0)
    {
        sendDataLength = sendEncryptData->dataSize;
    }

    if (ERR_SUCCESS != (ret = http_socket_create(&connectionInfo)))
    {
        close(connectionInfo.socketId);
        log_err("create socket is fail, ret-code(%d)\n", ret);
        return ret;
    }

    if (ERR_SUCCESS != (ret = http_socket_connect(&connectionInfo, urlInfo)))
    {
        close(connectionInfo.socketId);
        log_err("http_socket_connect is fail, ret-code(%d)\n", ret);
        return ret;
    }

    /*ݷ͵ݰ,httpsЭĳ */
    sendData = (char *)malloc(HTTPS_HEAD_DATA_LENGTH + sendDataLength + base64Size);
    if(!sendData)
    {
        close(connectionInfo.socketId);
        return ERR_MEM_ALLOC_ERROR;
    } //klockworks issue.

    httpsPacket.dataBuffer = sendData;
    httpsPacket.dataLen = HTTPS_HEAD_DATA_LENGTH + sendDataLength + base64Size;
    memset(httpsPacket.dataBuffer, 0, httpsPacket.dataLen);
    http_protocol_packet_create(urlInfo, sendEncryptData, &signData, &httpsPacket);

    ret = http_request_handle(&connectionInfo, &httpsPacket, recData);

    close(connectionInfo.socketId);
    free(httpsPacket.dataBuffer);
    httpsPacket.dataBuffer = NULL;
    sendData = NULL;
    return ret;

}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_create_aes_decrypt_key(ENCRYPT_DATA *in, AES_KEY *key)
{
    int dataSize = 0;
    char *dataBuffer = NULL;
    int ret = 0;
    unsigned char md[MD5_DIGEST_LENGTH] = {0};
    if (!in || !key)
    {
        return ERR_PARAM_NULL;
    }

    dataBuffer = in->dataBuffer;
    dataSize = in->dataSize;

    if (0 == (ret = EVP_Digest(dataBuffer, dataSize, md, NULL, EVP_md5(), NULL)))
    {
        log_err("create aes key-md5 fail\n");
        return ERR_CREATE_DM5_KEY_ERRRO;
    }

    if (0 != (ret = AES_set_decrypt_key(md, DM_AES_ECB_ENCRYPT_KEY_LENGTH, key)))
    {
        log_err("create aes encrypt Aes-key fail\n");
        return ERR_CREATE_ENCRYPT_KEY_ERROR;
    }

    return ERR_SUCCESS;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_aes_ecb_decrypt_handle(ENCRYPT_DATA *in, ENCRYPT_DATA *out, AES_KEY *key)
{
    const int enc = AES_DECRYPT;
    int i = 0;
    char *inDataBuffer = NULL;
    char *outDatabuffer = NULL;
    int inSize = 0;

    CHECK_PARAM(!in || !out || !key);

    inDataBuffer = in->dataBuffer;
    inSize = in->dataSize;
    outDatabuffer = out->dataBuffer;

    for (i = 0; i < inSize / 16; i++)
    {
        AES_ecb_encrypt((const unsigned char *)(inDataBuffer + (i * 16)), (unsigned char *)(outDatabuffer + (i * 16)), (const AES_KEY *) key, enc);
    }

    return ERR_SUCCESS;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static void dm_base64_encode(ENCRYPT_DATA *in, ENCRYPT_DATA *out,  int withNewLine)
{
    BIO * bmem = NULL;
    BIO * b64 = NULL;
    BUF_MEM * bptr = NULL;

    b64 = BIO_new(BIO_f_base64());
    ASSER_VOID(!b64);

    if (!withNewLine)
    {
        BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    }
    bmem = BIO_new(BIO_s_mem());
    ASSER_VOID(!bmem);

    b64 = BIO_push(b64, bmem);
    BIO_write(b64, in->dataBuffer, in->dataSize);
    BIO_flush(b64);
    BIO_get_mem_ptr(b64, &bptr);

    char * buff = (char *)malloc(bptr->length + 1);
    ASSER_VOID(!buff); //klockworks issue.
    memset(buff, 0, bptr->length + 1);

    memcpy(buff, bptr->data, bptr->length);

    out->dataBuffer = buff;
    out->dataSize = bptr->length;

    BIO_free_all(b64);
    return;
}

/**
 * ƣ
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static void dm_base64_decode(ENCRYPT_DATA *in, ENCRYPT_DATA *out,  int withNewLine)
{
    BIO * b64 = NULL;
    BIO * bmem = NULL;
    char * buffer = (char *)malloc(in->dataSize);

    ASSER_VOID(!buffer);
    memset(buffer, 0, in->dataSize);

    b64 = BIO_new(BIO_f_base64());
    if(!b64)
    {
        free(buffer);
        return; //klockworks issue.
    }

    if (!withNewLine)
    {
        BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    }
    bmem = BIO_new_mem_buf(in->dataBuffer, in->dataSize);
    if(!bmem)
    {
        free(buffer);
        return; //klockworks issue.
    }

    bmem = BIO_push(b64, bmem);
    BIO_read(bmem, buffer, in->dataSize);
    BIO_free_all(bmem);

    out->dataBuffer = buffer;

}

/**
 * ƣ dm_url_param_encode_handle
 * 
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static void dm_url_param_encode_handle(DM_UNICOM_HTTP_URL_INFO *urlInfoSrc, DM_UNICOM_HTTP_URL_INFO *urlInfoDest)
{
    int manufSize = 0;
    int modelSize = 0;
    char *pManuf = NULL;
    char *pModel = NULL;
    char *pSign = NULL;
    ASSER_VOID(!urlInfoSrc || !urlInfoDest);
    memcpy(urlInfoDest, urlInfoSrc, sizeof(DM_UNICOM_HTTP_URL_INFO));
    memset(urlInfoDest->urlBuffer, 0, URL_INFO_LINE_SIZE);
    if (NULL == (pModel = strstr(urlInfoSrc->urlBuffer, "&model=")))
    {
        log_err("can not find model code now \n");
        return;
    }
    if (NULL == (pManuf = strstr(urlInfoSrc->urlBuffer, "&manuf=")))
    {
        log_err("can not find manuf now \n");
        return;
    }
    if (NULL == (pSign = strstr(urlInfoSrc->urlBuffer, "&sign=")))
    {
        log_err("can not find sign now \n");
        return;
    }

    if (0 >= (manufSize = pSign - pManuf - strlen("&manuf=")))
    {
        log_err("manufSize is err\n");
        return;
    }
    if (0 >= (modelSize = pManuf - pModel  - strlen("&model=")))
    {
        log_err("model is err\n");
        return;
    }

    log_debug("pSign (%s), pManuf (%s), pMedol(%s) , manufSize(%d),modelSize(%d)\n", pSign, pManuf, pModel, manufSize, modelSize);
    char manufBuffer[manufSize + 1];
    char modelBuffer[modelSize + 1];
    char manufBufferEncode[manufSize * 3 + 1];
    char modelBufferEncode[modelSize * 3 + 1];
    memset(manufBuffer, 0, (int)(manufSize + 1));
    memset(modelBuffer, 0, (int)(modelSize + 1));
    memset(modelBufferEncode, 0, (int)(modelSize * 3 + 1));
    memset(manufBufferEncode, 0, (int)(manufSize * 3 + 1));
    memcpy(manufBuffer, pManuf + strlen("&manuf="), manufSize);
    memcpy(modelBuffer, pModel + strlen("&model="), modelSize);
    /*manuf and model url encode now */
    dm_Url_Encode(manufBuffer, manufSize, manufBufferEncode, manufSize * 3 + 1);
    dm_Url_Encode(modelBuffer, modelSize, modelBufferEncode, modelSize * 3 + 1);

    log_debug("manufBuffer(%s), modelBuffer(%s),manufBufferEncode(%s),modelBufferEncode(%s)\n", manufBuffer, modelBuffer, manufBufferEncode, modelBufferEncode);
    log_debug("urlInfo size (%d)\n", pModel - (urlInfoSrc->urlBuffer));

    /* create urlInfo contain url-code of manuf and model */
    //strncat(urlInfoDest->urlBuffer, urlInfoSrc->urlBuffer, pModel - (urlInfoSrc->urlBuffer));
    //strcat(urlInfoDest->urlBuffer, "&model=");
    //strcat(urlInfoDest->urlBuffer, modelBufferEncode);
    //strcat(urlInfoDest->urlBuffer, "&manuf=");
    //strcat(urlInfoDest->urlBuffer, manufBufferEncode);
    //strcat(urlInfoDest->urlBuffer, "&sign=");
    snprintf(urlInfoDest->urlBuffer, sizeof(urlInfoDest->urlBuffer)-1, "%s%s%s%s%s%s",
             urlInfoSrc->urlBuffer, "&model=", modelBufferEncode, "&manuf=", manufBufferEncode, "&sign="); //klockworks issue.
    log_debug("urlInfoDest urlBuffer(%s), hostName(%s), portNum(%d)\n", urlInfoDest->urlBuffer, urlInfoDest->hostName, urlInfoDest->portNum);
}

/**
 * ƣ dm_http_request_start
 *  ʼdm
 * ˵
 *   ֵ ɹERR_SUCCESSʧܷӦĴ
 * ˵ 
 */
static int dm_http_request_start(DM_UNICOM_HTTP_URL_INFO *urlInfo, DM_UNICOM_HTTP_DATA_INFO *inData, DM_UNICOM_HTTP_DATA_INFO *recData)
{
    ENCRYPT_DATA inTempData = {0};
    ENCRYPT_DATA encryptOutData = {0};
    DM_UNICOM_HTTP_URL_INFO urlInfoTemp ;
    AES_KEY key ;
    char  *searchStr = SEARCH_STR_RETURN_CODE_HTTPS;
    CHECK_PARAM(!urlInfo || !inData || !recData);

    inTempData.dataBuffer = inData->dataBuffer;
    inTempData.dataSize = inData->dataLen;
    encryptOutData.dataSize = DM_PKCS5_SIZE(inTempData.dataSize);
    char tempData[encryptOutData.dataSize];
    encryptOutData.dataBuffer = tempData;

    /*create aes key */
    CALL(dm_create_aes_encrypt_key(&inTempData, &key));

    /* using PKCS pandding and encrypting now */
    memset(encryptOutData.dataBuffer, 0, encryptOutData.dataSize);
    CALL(dm_aes_ecb_encrypt_handle(&inTempData, &encryptOutData, &key));

#ifdef  DM_FOR_DEBUG_ENCRYPT
    {
        AES_KEY keyTemp;
        ENCRYPT_DATA outTemp = {0};

        outTemp.dataSize = encryptOutData.dataSize;
        char outemData[outTemp.dataSize];
        outTemp.dataBuffer = outemData;

        /*create the aes decrypt key */
        memset(outTemp.dataBuffer, 0, outTemp.dataSize);
        CALL(dm_create_aes_decrypt_key(&inTempData, &keyTemp));

        /*decrypte the data now */
        CALL(dm_aes_ecb_decrypt_handle(&encryptOutData, &outTemp, &keyTemp));

        log_debug("get the aes src data*****************************\n");
        log_debug("len(%d)\n(%s)\n", inTempData.dataSize, inTempData.dataBuffer);

        log_debug("get the aes decrypt data hex output*************************\n");
        log_debug("len(%d)\n", outTemp.dataSize);
        dm_hex_print((outTemp.dataBuffer), outTemp.dataSize);

        log_debug("get aes pad what to data **********\n");
        dm_hex_print((outTemp.dataBuffer + outTemp.dataSize - 16), 16);
    }
#endif
    /*urlInfo url-encode */
    memset(&urlInfoTemp, 0, sizeof(DM_UNICOM_HTTP_URL_INFO));
    dm_url_param_encode_handle(urlInfo, &urlInfoTemp);

    /*http send data and get recv data */
    CALL(dm_http_request_handle(&urlInfoTemp, &encryptOutData, inData, recData));

    /*parse the recData now */
    if (!(http_packet_parse(recData->dataBuffer, searchStr)))
    {
        log_err("can not find the 200, search the string(%s), recvData-buffer(%s)\n", searchStr, recData->dataBuffer);
        return ERR_RECVDATA_NO_200_ERROR;
    }

    return ERR_SUCCESS;
}

/**************************************************************************
 *                        ȫֺ                                    *
 **************************************************************************/
/**
 * ƣ dm_https_request
 *  ݹ
 * ˵
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷӦĴ
 * ˵ 
 */
int dm_unicom_http_request(DM_UNICOM_HTTP_URL_INFO *urlInfo, DM_UNICOM_HTTP_DATA_INFO *sendSrcData)
{
    /*checking the prarm*/
    DM_UNICOM_HTTP_DATA_INFO recData = {0};
    char recDataBuffer[RECV_BUFFER_LENGTH] = {0};
    CHECK_PARAM(!urlInfo || !sendSrcData || !sendSrcData->dataBuffer);

    log_debug("url info urlBuffer(%s), portNum(%d), ipAdress(%s), hostName(%s)\n",
              urlInfo->urlBuffer, urlInfo->portNum, urlInfo->ipAddr, urlInfo->hostName);

    log_debug("sendSrcData(%s), sendSrcData-len(%d)\n", sendSrcData->dataBuffer, sendSrcData->dataLen);

    recData.dataBuffer = recDataBuffer;
    recData.dataLen = RECV_BUFFER_LENGTH;
    memset(recData.dataBuffer, 0, recData.dataLen);

    CALL(dm_http_request_start(urlInfo, sendSrcData, &recData));

    log_debug("dm success now: recData->buffer(%s), recData len(%d), recData httpHeadSize(%d)\n", recData.dataBuffer, recData.totalSize, recData.httpHeadSize);

    return ERR_SUCCESS;
}

