#include <stdio.h>
#include <stdlib.h>
#include "headers.h"
#include "settings.h"
#include "runner.h"
#include "socketHelper.h"
#include "zpingp.h"
#include "softap_log.h"


const struct option long_options[] = {

	{"ipv4",             no_argument, NULL, '4'},
//{"ipv6",             no_argument, NULL, '6'},
	{"size",       required_argument, NULL, 'l'},
	{"pingcount",  required_argument, NULL, 'c'},
	{"itemcount",  required_argument, NULL, 'n'},
	{"timeout",    required_argument, NULL, 'w'}, // wait "w" seconds for each reply
	{"interval",   required_argument, NULL, 'i'}, // minimum seconds between two requests
	{"unstopped",        no_argument, NULL, 't'},
	{"printall",      	 no_argument, NULL, 'p'},
	{"lostoutput",       no_argument, NULL, 'o'},
	{"maxwaitnum", required_argument, NULL, 'u'},
	{"delaycheck", 		 no_argument, NULL, 'd'},
	{"help", 		     no_argument, NULL, 'h'},

	{0, 0, 0, 0}
};

const char short_options[] = "4l:c:n:w:i:tpou:dh";

void sig_handler(int sig)
{
	if (sig == SIGINT || sig == SIGTERM) {
		exit(0);
	}
}


void init_settings(zping_settings_t *zping_settings)
{
	memset(zping_settings, 0, sizeof(zping_settings_t));

	zping_settings->size = 800;
	zping_settings->itemcount = 20;
	zping_settings->pingcount = 100;
	zping_settings->timeout = 4;
	zping_settings->interval = 1;
	zping_settings->lostoutput = 1;
	zping_settings->unstopped = 1;
}

int main(int argc, char** argv)
{
	int c, rc;
	zping_settings_t zping_settings;

	int item_size = 0;

	struct sigaction sigact;
	/* // for child pthreads to ignore SIGPIPE
	    sigset_t signal_mask;
	    sigemptyset (&signal_mask);
	    sigaddset (&signal_mask, SIGPIPE);
	    rc = pthread_sigmask (SIG_BLOCK, &signal_mask, NULL);
	    if (rc != 0)
	    {
	       zping_print(LOG_ALERT, "block sigpipe error\n");
	    }
	*/

	sigact.sa_handler = sig_handler;
	sigact.sa_flags = 0;
	sigemptyset(&sigact.sa_mask);
	sigaction(SIGINT, &sigact, NULL);
	sigaction(SIGTERM, &sigact, NULL);

	/* ignore SIGPIPE */
	sigact.sa_handler = SIG_IGN;
	sigact.sa_flags = 0;
	sigemptyset(&sigact.sa_mask);
	sigaction(SIGPIPE, &sigact, NULL);

	//pthread_t tid = pthread_self();
	//zping_print(LOG_ALERT, "main pthread id:%lu \n",tid);

	//memset(&zperf_settings, 0, sizeof(zperf_settings_t));
	init_settings(&zping_settings);

	while ((c = getopt_long(argc, argv, short_options, long_options, NULL)) != -1) {
		//test = 1;
		zping_print(LOG_ALERT, "option %c\n", c);
		switch (c) {
		case '4':
			zping_settings.ip_type = 0;
			break;

		case 'l':
			zping_settings.size = atoi(optarg);
			break;

		case 'c':
			zping_settings.pingcount = atoi(optarg);
			zping_settings.unstopped = 0;
			break;

		case 'n':
			zping_settings.itemcount = atoi(optarg);
			break;

		case 'w':
			zping_settings.timeout = atoi(optarg);
			break;

		case 'i':
			zping_settings.interval = atoi(optarg);
			break;

		case 't':
			zping_settings.unstopped = 1;
			break;

		case 'p':
			zping_settings.delayoutput = 1;
			break;

		case 'o':
			zping_settings.lostoutput = 1;
			break;

		case 'u':
			zping_settings.maxwaitnum = atoi(optarg);
			break;

		case 'd':
			//if (atoi(optarg) == 1 || atoi(optarg) == 0)
			//	zping_settings.set_id = atoi(optarg);
			zping_settings.set_id = 1;
			zping_settings.delayoutput = 1;
			break;

		case 'h':
			printf("zping ip_addr [options] \n");
			printf("options: \n");			
			printf("-d  		delay check \n");
			printf("-c num  	ping num\n");
			printf("-l size  	ping size\n");
			printf("-p  		print every packet\n");	
			goto out;			

		case '?':
			break;

		default:
			zping_print(LOG_ALERT,  "?? getopt returned character code 0%o ??\n", c);
			break;
		}
	}

	if (argc <= 1) {
		zping_print(LOG_ALERT, "zping -h for usage \n");
		goto out;
	}

	strcpy(zping_settings.address_str, argv[optind]);
	SockAddr_setHostname(zping_settings.address_str, &zping_settings.zping_sockaddr);

	//zping_print(LOG_ALERT, "zping_settings.address_str:%s, %x\n", zping_settings.address_str,
	//    ((struct sockaddr_in*)&zping_settings.zping_sockaddr)->sin_addr.s_addr);

	if (zping_settings.size > 1472) {
		zping_print(LOG_ALERT, "size should not be greater than 1472\n");
		goto out;
	}

	item_size = zping_settings.set_id == 0 ? sizeof(zping_pktlost_item_t) : sizeof(zping_item_t);
	if (zping_settings.size < sizeof(zping_hdr_t) + zping_settings.itemcount * item_size) {
		zping_print(LOG_ALERT, "%d bytes is not enough to contain %d items, at least %d bytes are needed\n",
		            zping_settings.size, zping_settings.itemcount,
		            sizeof(zping_hdr_t) + zping_settings.itemcount * item_size);
		goto out;
	}
	if(zping_settings.set_id)		
		zping_print(LOG_ALERT, "work type:  deley check \n");
	else
		zping_print(LOG_ALERT, "work type:  loss check \n");
	zping_print(LOG_ALERT, "ping size: %d \n",zping_settings.size);
	zping_print(LOG_ALERT, "node num: %d \n",zping_settings.itemcount);	
	if(zping_settings.unstopped)
		zping_print(LOG_ALERT, "ping num: endless \n");
	else
		zping_print(LOG_ALERT, "ping num: %d \n",zping_settings.pingcount);
	zping_print(LOG_ALERT, "wait time: %d \n",zping_settings.timeout);	
	
	start_run(&zping_settings);

	//thread_start(&zperf_settings);

	//thread_join(&zperf_settings);

	//zping_print(LOG_ALERT, "Hello World\n");
	//getchar();
	//all done !
out:
	return 0;
}

