#include "at_context.h"
extern int g_fd;

struct at_context nearps_ctx[NEAR_PS_CXT_MAX] = {0};
//struct at_context *near_ps[NEAR_PS_CXT_MAX] = {&nearps_ctx};

int at_write_by_ctx(struct at_context *ctx, const void *buf, int size)
{
	int ret = -1;
	//char *time_str;
	at_assert(size != 0);
	if (ctx) {
		if (ctx->position == NEAR_PS) {
            ret = at_write(ctx->fd, buf, size);
			//time_str = at_time_record(buf, 0);
		}
	}
	return ret;
}

//⵱ǰǷĳ״̬æ
int  is_at_ctx_busy(int position, int state)
{
	if (position == NEAR_PS)
		return (nearps_ctx[0].state & state);
	
}

//ͨʼfdcontext
void at_channel_init()
{
	int i = 0;
	//int at_fd = 0;
	for(i=0;i<NEAR_PS_CXT_MAX;i++)
	{
		nearps_ctx[i].fd = at_open("/dev/ttyS0");//˴ⶨƣuart0
		g_fd = nearps_ctx[i].fd; //Ŀǰһͨ˴˴ν򿪵fdֱӴ浽ȫֱ
		nearps_ctx[i].position = NEAR_PS;
		//˴ⶨ,killat_ctlֹat_ctlռuartͨ
		system("killall -9 at_ctl");
	}
}

//ͨposition
struct at_context *alloc_context_by_position(int position, int state)
{
	int i = 0;
	if(position == NEAR_PS)
	{
		for(i=0;i<NEAR_PS_CXT_MAX;i++)
		{
			if((nearps_ctx[i].state & state) == 0)
			{
				nearps_ctx[i].state |= state; 
				return &nearps_ctx[i];
			}
		}
		//return NULL;
	}
	return NULL;
}

//ͨfd󶨵context
struct at_context *find_context_by_fd(int position, int at_fd)
{
	int i = 0;
	if(position == NEAR_PS)
	{
		for(i=0;i<NEAR_PS_CXT_MAX;i++)
		{
			if(nearps_ctx[i].fd == at_fd)
			{
				return &nearps_ctx[i];
			}
		}
		//return NULL;
	}
	return NULL;
}

char* at_err_build(int param)
{
    char *at_str = NULL;
	
    at_str = malloc(32);
	
    if(!at_str)
        return NULL;
    if(param == 0)
        sprintf(at_str,"\r\nERROR\r\n");
    else
        sprintf(at_str,"\r\n+CME ERROR: %d\r\n",param);
        
    return at_str;    

}

//ͨģid󶨵contextͨ첽serverӦ÷ؽsoc
struct at_context *find_context_by_moduleid(int position, int module_id)
{
	int i = 0;
	if(position == NEAR_PS)
	{
		for(i=0;i<NEAR_PS_CXT_MAX;i++)
		{
			if(nearps_ctx[i].svr_dest_id == module_id)
			{
				return &nearps_ctx[i];
			}
		}
		//return NULL;
	}
	return NULL;
}

//еnear_psͨд
void write_all_nearps_fd(char *at_str, int at_len)
{
	int i = 0;
	for(i=0;i<NEAR_PS_CXT_MAX;i++)
	{
		at_write_by_ctx(&nearps_ctx[i], at_str, at_len);
	}
}


