#define _LINUX_OS
#include <stdlib.h>
#include "user_demo.h"
#ifdef _LINUX_OS
#include <sys/time.h>
#include <signal.h>
#include <semaphore.h>
#include <sys/msg.h>
#include <pthread.h>
#endif
#include "at_api.h"
#include <errno.h>

int  zxic_is_ready = 0;
struct zipstat_info ipstat_info = {0};
struct ziprecv_info recv_data = {0};

struct zipsocket_info mysocket_info = {0};
//ATͨĴat_clientģطԣҵERRҪҵ񿪷ģݴ
//ĿǰĲοǽָطʧܣԽtimeoutλΪ
int get_modem_info_succ(char *req_at,char *info_fmt,void **pval, long timeout)
{
    int ret = 0;
    int again_num = 0;
    while((ret = get_modem_info(req_at,info_fmt,pval,timeout))!=0)
    {
        printf("%d",ret);
		switch(ret)
		{
		case ATERR_NOT_ALLOWED:
			printf("param is wrong and can not resent, please check cmd\n");
			return ret;
		case ATERR_MEM_LESS:
		case ATERR_CHANNEL_BUSY:
		case ATERR_PROC_FAILED:
			//sleep 1sٴط
			printf("wait 1s and resent\n");
			sleep(1);
			break;
		case ATERR_PARAM_INVALID:
			//ط
			printf("resent again\n");
			break;
		default:
			return ret;
		}
        if(again_num++ > RESEND_MAX)
            at_assert(!"have  resend  fial!!!");
    }
}


int at_socket_send()
{
	char at_str[128]= {0};
	int sock =0;
	int send_len = 0;
	void *p[]={&sock,&send_len};
	int ret = 0;

    //ʹZXIC΢оƬ
    memset(at_str, 0, sizeof(at_str));
	strcpy(at_str,"AT+ZWORKLOCK=FFFF\r\n");
	ret = get_modem_info_succ(at_str,NULL,NULL,500);
	//ʧܣ
	if(ret != AT_PARSE_OK)
	{
		printf("AT+ZWORKLOCK=FFFF failed!!!\n");
		at_assert(0);
	}
    
	//socket
	memset(at_str, 0, sizeof(at_str));
	sprintf(at_str,"AT+ZIPOPEN=%d,%d,%s,%d,%d\r\n",mysocket_info.socket_id,mysocket_info.conn_type,mysocket_info.remote_ip,mysocket_info.remote_port,mysocket_info.local_port);
	ret = get_modem_info_succ(at_str,NULL,NULL,5000);
	//ʧܣAT+ZWORKLOCK=0ͷŶZXIC΢оƬʹ
	if(ret != AT_PARSE_OK)
	{
		printf("ZIPOPEN failed!!!\n");
		goto ERR_PROC2;
	}
	
	//
    memset(at_str, 0, sizeof(at_str));
	sprintf(at_str,"AT+ZIPSEND=%d,%d,%s\r\n",mysocket_info.socket_id,mysocket_info.send_len,mysocket_info.send_data);
    ret = get_modem_info_succ(at_str,"%d,%d",p,5000);
	//ʧܣûԸretֵݴοΪ͹رsocket
	if(ret != AT_PARSE_OK)
	{
		printf("ZIPSEND failed!!!\n");
		goto ERR_PROC1;
	}
    //ݲϱʽμAT_SOCKET_ZIPRECVϢ
	printf("+ZIPSEND=%d,%d\n",sock,send_len);
    return 1;

ERR_PROC1:
	//رsocket
	memset(at_str, 0, sizeof(at_str));
	sprintf(at_str,"AT+ZIPCLOSE=%d\r\n",mysocket_info.socket_id);
    ret = get_modem_info_succ(at_str,NULL,NULL,5000);
	//ʧܣAT+ZWORKLOCK=0ͷŶZXIC΢оƬʹ
	if(ret != AT_PARSE_OK)
	{
		printf("ZIPCLOSE failed and goto ERR_PROC2!!!\n");
	}

ERR_PROC2:
    //ͷZXIC΢оƬʹ
    memset(at_str, 0, sizeof(at_str));
	strcpy(at_str,"AT+ZWORKLOCK=0\r\n");
	ret = get_modem_info_succ(at_str,NULL,NULL,1000);
	//ʧܣ
	if(ret != AT_PARSE_OK)
	{
		printf("AT+ZWORKLOCK=0 failed!!!\n");
		at_assert(0);
	}
    return  0;
}
int at_socket_close()
{
	char at_str[128]= {0};
	int sock =0;
	int send_len = 0;
	void *p[]={&sock,&send_len};
	int ret = 0;

	//رsocket
	memset(at_str, 0, sizeof(at_str));
	sprintf(at_str,"AT+ZIPCLOSE=%d\r\n",mysocket_info.socket_id);
    ret = get_modem_info_succ(at_str,NULL,NULL,5000);
	//ʧܣAT+ZWORKLOCK=0ͷŶZXIC΢оƬʹ
	if(ret != AT_PARSE_OK)
	{
		printf("ZIPCLOSE failed !!!\n");
	}

    //ͷZXIC΢оƬʹ
    memset(at_str, 0, sizeof(at_str));
	strcpy(at_str,"AT+ZWORKLOCK=0\r\n");
	ret = get_modem_info_succ(at_str,NULL,NULL,1000);
	//ʧܣ
	if(ret != AT_PARSE_OK)
	{
		printf("AT+ZWORKLOCK=0 failed!!!\n");
		at_assert(0);
	}
    return  0;
}
//ճʱ
void rcv_timeout_handle(int signo)
{
	//ͳʱϢ̴߳
	at_send_msg(MODULE_ID_AT_CLIENT, MODULE_ID_AT_SOCKET, AT_SOCKET_RCV_TIMEOUT, 0, NULL, 0);			
}
void rcv_atmsg_proc(void)
{
    MSG_BUF stMsg = {0};
    int iMsgHandle = 0;
    char *p[]={0};
	int iRet = 0;
	long msgSize = sizeof(MSG_BUF)-sizeof(long);
	struct itimerval val;
    /* Ϣ*/
    iMsgHandle = msgget(MODULE_ID_AT_SOCKET, IPC_CREAT|0600);
    while(1)
    {
        iRet = 0;
        memset(&stMsg, 0x00, sizeof(MSG_BUF));

        /* ȡϢϢ*/
        iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);
        if (iRet >= 0)
        {
            switch (stMsg.usMsgCmd)
            {
                //յZXICĵһϱZXIC״̬ʼԽݽ
                case MSG_CMD_AT_READY_IND:
                    zxic_is_ready = 1;
                    break;
                //Ӧò㷢ڲԶsocketATͻ
                case APP_SOCKET_SEND_REQ:
                    assert(zxic_is_ready==1);
                    iRet = at_socket_send();
                    //socketʧܣҪûݴοֱӶ
                    assert(iRet==1);
                    //õȴrcvݳʱ
					signal(SIGALRM, rcv_timeout_handle);
                    //Ϊȷ΢оƬʡЧ󻯣ⲿMCU΢оƬʱɿ
					val.it_value.tv_sec = 30;//Ŀǰ30sʱ
					val.it_value.tv_usec = 0;
					val.it_interval.tv_usec = 0;
					val.it_interval.tv_sec = 0;//ʱһ
					setitimer(ITIMER_REAL, &val, 0);
					break;
                case AT_SOCKET_ZIPSTAT:
                    p[0] = &ipstat_info.sock_id;
                    p[1] = &ipstat_info.state;
                    iRet = parse_param("%d%d",stMsg.aucDataBuf,p);
                    at_assert(iRet == AT_PARSE_OK);
					printf("+ZIPSTAT: %d,%d\n",ipstat_info.sock_id,ipstat_info.state);
                    break;  
                case AT_SOCKET_ZIPRECV:
                    p[0] = &recv_data.sock_id;
                    p[1] = recv_data.dst_ip;
                    p[2] = &recv_data.dst_port;
                    p[3] = &recv_data.data_len;
                    iRet = parse_param("%d%s%d%d",stMsg.aucDataBuf,p);
                    at_assert(iRet == AT_PARSE_OK);
                    recv_data.data = malloc(recv_data.data_len);
                    iRet = parse_param(",,,,%s",stMsg.aucDataBuf,&recv_data.data);
                    at_assert(iRet == AT_PARSE_OK);
					printf("Response: +ZIPRECV: %d,%s,%d,&d,%s\n",recv_data.sock_id,recv_data.dst_ip,recv_data.dst_port,recv_data.data_len,recv_data.data);
					free(recv_data.data);
					recv_data.data = NULL;
                    break;
                //Ӧòֹͣscoketշ
                case APP_SOCKET_CLOSE_REQ:
                //ȴݳʱ
                case AT_SOCKET_RCV_TIMEOUT:
                //PDPȥʱsocketĹر
                case MSG_CMD_PDP_DEACT_IND:
			        //ͣյȴʱ,ʱ
			        memset(&val,0,sizeof(struct itimerval));
        			setitimer(ITIMER_REAL, &val, 0);
                    at_socket_close();
                    break;
                default:
                    printf("ERR: MSG UNKNOW \n");
                	break;
            }
        }
        else
        {
            if(errno != EINTR)
                printf("errno = %d, errmsg = %s\n", errno,strerror(errno));
        }
    }
}


/*ģⲿӦõķϢ߳*/
int main(int argc, char *argv[])
{ 
	int ret = 0;

	//ȡsocketϢ
	mysocket_info.socket_id = atoi(argv[1]);          //socket id
	mysocket_info.conn_type = atoi(argv[2]);          // 0 TCP , 1 UDP
	strcpy(mysocket_info.remote_ip, argv[3]);         //ԶIPַ
	mysocket_info.remote_port= atoi(argv[4]);         //Զ˶˿ں
	mysocket_info.local_port= atoi(argv[5]);          //ض˿ں
	mysocket_info.send_len= atoi(argv[6]);            //ݳ
	mysocket_info.send_data= malloc(mysocket_info.send_len);
	memset(mysocket_info.send_data, 0x00, mysocket_info.send_len);
	strcpy(mysocket_info.send_data, argv[7]);  		  //	
	rcv_atmsg_proc();
	free(mysocket_info.send_data);
	return 0;
}


