#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <errno.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <linux/sockios.h>
//#include <cfg_api.h>
#include <termios.h>
#include <sys/prctl.h>
#include <pthread.h>
#include <assert.h>
#include <sys/select.h> 
#include <semaphore.h>
#include <linux/netlink.h>

#define UART_DEV "/dev/ttyS0"
#define TEST_WAKELOCK_NAME "t_lock"
#define ONE_LEN 4095
#define NETLINK_BUFFER_SIZE  2048*3
typedef unsigned int uint32_t;
typedef unsigned char uint8_t;
static pthread_t wakeup_monitor;
static pthread_t mcu_state_mon_th;
int uart_fd_0 = -1;
int uart_fd_2 = -1;
int times = 0;
int wake_times = 0;
int tlen = 0;
uint8_t dbuf[2100000];

#define MCU_SLEEP_STATE_GPIO    53			/*the GPIO that AP to CP about sleep_wake status*/
#define MODEM_SLEEP_STATE_GPIO    130		/*the GPIO that CP to AP about sleep_wake status*/
#define MODEM_WAKE_MCU_GPIO     131			/*the GPIO corresponding to the line interruption when the CP wakes up an AP*/

#define FUNC_GPIO_53 "GPIO53_GPIO53##"
#define FUNC_GPIO_130 "GPIO130_GPIO130##"
#define FUNC_GPIO_131 "GPIO131_GPIO131##"
#define DIRECT_GPIO_53 "/sys/class/gpio/gpio53/direction"
#define DIRECT_GPIO_130 "/sys/class/gpio/gpio130/direction"
#define DIRECT_GPIO_131 "/sys/class/gpio/gpio131/direction"
#define VALUE_GPIO_53    "/sys/class/gpio/gpio53/value"
#define VALUE_GPIO_130    "/sys/class/gpio/gpio130/value"
#define VALUE_GPIO_131    "/sys/class/gpio/gpio131/value"


#define GPIO_DIRECTION_OUT 0 
#define GPIO_DIRECTION_IN 1 


#define STRBUF_LEN 32  
#define STR_TYPE_FUNC 0 
#define STR_TYPE_DIRECTION 1 
#define STR_TYPE_VALUE 2 

char gpio_func[STRBUF_LEN];
char gpio_direction[STRBUF_LEN];
char gpio_value[STRBUF_LEN];

int g_stop_test = 0;
int g_enter_sleep = 1;
int stop_monitor = 0;
int wait_for_monitor = 0;

sem_t wake_sem;
sem_t sleep_sem;
sem_t mcu_state_sem;
sem_t mcu_state_monitor;

int gpio[] = {53,130, 131};
char *func[] = {FUNC_GPIO_53, FUNC_GPIO_130, FUNC_GPIO_131, "0"};
char *direction[] = {DIRECT_GPIO_53, DIRECT_GPIO_130, DIRECT_GPIO_131, "0"};
char *value[] = {VALUE_GPIO_53, VALUE_GPIO_130, VALUE_GPIO_131, "0"};
char *inout[] = {"in", "out", "out", "0"};


void write_lock(char *filepath, char *setbuf)
{
	int f, len = 0;

	f = open(filepath, O_RDWR);
	if (f == -1) {
		return;
	}

	len = strlen(setbuf);
	if (write(f, setbuf, len) != len) {
	} else {
	}
	close(f);
}
int crc_get_index_by_num(int gpio_num)
{

	int array_idx = 0;
	switch (gpio_num){
		case MCU_SLEEP_STATE_GPIO:
			array_idx = 0;
			break;
		case MODEM_SLEEP_STATE_GPIO:
			array_idx = 1;
			break;
		case MODEM_WAKE_MCU_GPIO:
			array_idx = 2;
			break;
		default:
			break;
	}
	return array_idx;
}

int crc_write_gpio(int gpio_num, int v)
{	
	int ret = 0;
	int fd_gpio = -1;
	int len = 0;
	char buf[50];
	memset(buf, 0, 50);
	
	int idx = crc_get_index_by_num(gpio_num);
		
	fd_gpio = open(value[idx], O_RDWR);
	if(fd_gpio < 0) 
	{		
		printf("%d fd_value open fail.\n", gpio_num);
		return -1;
	}
	
	len = snprintf(buf, sizeof(buf), "%s", ((v == 0) ? "0" : "1"));
	ret = write(fd_gpio, buf, len);
	close(fd_gpio);
	
	if(ret != len) 
	{
		printf("crc_write_gpio fd_value write fail.gpio:%d, value:%d\n", gpio_num, v);
		return -1;
	}
	return 0;
}

int crc_read_gpio(int gpio_num)
{	
	int gpio_value = 0;
	int fd_gpio = -1;
	int ret = 0;
	//int len = 0;
	char buf[50];
	memset(buf, 0, 50);
	int idx = crc_get_index_by_num(gpio_num);
	
	fd_gpio = open(value[idx], O_RDWR);
	if(fd_gpio < 0) 
	{		
		printf("%d fd_value open fail.\n", gpio_num);
		return -1;
	}
	//len = snprintf(buf, sizeof(buf), "%s", ((value == 0) ? "0" : "1"));
	ret = read(fd_gpio, buf, 50);
	close(fd_gpio);
	
	if(ret < 0) 
	{
		//printf("crc_read_gpio fd_value read fail.gpio:%d,ret:%d, buf:%s\n", gpio_num, ret, buf);
		return 0;
	}
	gpio_value = atoi(buf);
	//printf(" crc_read_gpio read gpio:%d, value:%s, gpio_value:%d\n", gpio_num, buf, gpio_value);
	
	return gpio_value;
}

int crc_gpio_init(void)
{
	int ret = 0;
	int len = 0;
	int fd_gpio = -1;
	char buf[50];
	int i;
	memset(buf, 0, 50);
#if 0
	ret = crc_get_gpio_str(gpio_func, STRBUF_LEN, gpio_num, STR_TYPE_FUNC);
	ret = crc_get_gpio_str(gpio_direction, STRBUF_LEN, gpio_num, STR_TYPE_DIRECTION);
	ret = crc_get_gpio_str(gpio_value, STRBUF_LEN, gpio_num, STR_TYPE_VALUE);
#endif	
	for(i = 0; i < 3; i++){	

		/*Apply for one GPIO */
		fd_gpio = open("/sys/class/gpio/export", O_WRONLY);
		if(fd_gpio < 0) 
		{
			printf("%d fd_export open fail.\n", gpio[i]);
			return -1;
		}
		len = snprintf(buf, sizeof(buf), "%d", gpio[i]);
		ret = write(fd_gpio, buf, len);
		close(fd_gpio);
		if(ret != len) 
		{
			printf("%d fd_export write fail.ret:%d, len:%d\n", gpio[i], ret, len );
			return -1;
		}
		
		/* Setting the GPIO Function */
		fd_gpio = open("/sys/kernel/debug/zx29_gpio", O_RDWR);
		if(fd_gpio < 0) 
		{
			printf("%d fd_func open fail.ret:%d, len:%d\n", gpio[i], ret, len );
			return -1;
		}
		ret = write(fd_gpio, func[i], strlen(func[i]));
		close(fd_gpio);
		if(ret != strlen(func[i])) 
		{
			printf("%d fd_func write fail.ret:%d, len:%d\n", gpio[i], ret, len );
			return -1;
		}

		/* Setting GPIO Input and Output */
		fd_gpio = open(direction[i], O_WRONLY);
		if(fd_gpio < 0) 
		{
			printf("%d fd_direction open fail.\n", gpio[i]);
			return -1;
		}
		len = snprintf(buf, sizeof(buf), "%s", inout[i]);
		ret = write(fd_gpio, buf, len);
		close(fd_gpio);
		if(ret != len) 
		{
			printf("%d fd_direction write fail.ret:%d, len:%d\n", gpio[i], ret, len );
			return -1;
		}

		/* The initial value cannot be set after it is set as input. */
		if(i == 0)
		{
			continue ;
		}
		
		/* Sets the initial status of the GPIO */	
		fd_gpio = open(value[i], O_WRONLY);
		if(fd_gpio < 0) 
		{		
			printf("%d fd_value open fail.\n", gpio[i]);
			return -1;
		}
		len = snprintf(buf, sizeof(buf), "%s", "1");
		ret = write(fd_gpio, buf, len);
		close(fd_gpio);
		
		if(ret != len) 
		{
			printf("%d fd_value write fail.ret:%d, len:%d\n", gpio[i], ret, len );
			return -1;
		}	
	}
	return 0;
}

int crc_release_gpio(void)
{
	int fd_gpio = -1;
	int len = 0;
	int ret = 0;
	char buf[50];
	memset(buf, 0, 50);
	int i;
	/* release GPIO */
	fd_gpio = open("/sys/class/gpio/unexport", O_WRONLY);
	if(fd_gpio < 0) 
	{
		printf("crc_release_gpio open  fail.\n");
		return -1;
	}
	for(i = 0; i < 3; i++){
		len = snprintf(buf, sizeof(buf), "%d", gpio[i]);
		ret = write(fd_gpio, buf, len);
		
		if(ret != len) 
		{
			printf(" crc_release_gpio write fail %d.\n", gpio[i]);
			continue;
		}
	}
	close(fd_gpio);
	return 0;
}

int crc_wakeup_mcu(int state)
{
	return crc_write_gpio(MODEM_WAKE_MCU_GPIO, state);
}

int crc_set_modem_state(int state)
{
	return crc_write_gpio(MODEM_SLEEP_STATE_GPIO, state);
}

int crc_get_mcu_state(void)
{
	int a = crc_read_gpio(MCU_SLEEP_STATE_GPIO);
	if (a == 1)
	{
		printf("##########read gpio_53 state: %d! the other side is waking!\n", a);
	}
	else
	{
		printf("##########read gpio_53 state: %d! the other side is sleeping!\n", a);
	}
	return a;
}

int crc_request_set_gpio(int gpio_num, int value)
{

	return 0;
}

void process_exit(int signo)
{
	switch(signo)
	{
		case SIGINT:
			printf("recv signal SIGINT\n");
			break;
		case SIGTERM:
			printf("recv signal SIGTERM\n");
			break;
		default:
			printf("recv signal default\n");	
			break;
	}
	
	crc_release_gpio();
    exit(1);
}

int32_t crc_com_Convbaud(uint32_t iBaudrate)
{
    switch(iBaudrate)
    {
        case 0:
            return B0;
        case 50:
            return B50;
        case 75:
            return B75;
        case 110:
            return B110;
        case 134:
            return B134;
        case 150:
            return B150;
        case 200:
            return B200;
        case 300:
            return B300;
        case 600:
            return B600;
        case 1200:
            return B1200;
        case 1800:
            return B1800;
        case 2400:
            return B2400;
        case 4800:
            return B4800;
        case 9600:
            return B9600;
        case 19200:
            return B19200;
        case 38400:
            return B38400;
        case 57600:
            return B57600;
        case 115200:
            return B115200;
        case 230400:
            return B230400;
        case 460800:
            return B460800;
        case 500000:
            return B500000;
        case 576000:
            return B576000;
        case 921600:
            return B921600;
        case 1000000:
            return B1000000;
        case 1152000:
            return B1152000;
        case 1500000:
            return B1500000;
        case 2000000:
            return B2000000;
        case 2500000:
            return B2500000;
        case 3000000:
            return B3000000;
        case 3500000:
            return B3500000;
        case 4000000:
            return B4000000;
        default:
            return B115200;
    }
}

static int crc_com_SetBaud(int32_t iFdCom,int nSpeed)
{
	int ret = 0;
    struct termios tOldTermios = {0};
	int32_t iBaudrate = 0;
    bzero(&tOldTermios, sizeof(tOldTermios));
	
    ret = tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
	if(ret)
	{
		printf("tcgetattr failed! \n");
	}
    
	iBaudrate = crc_com_Convbaud(nSpeed);
	if(iBaudrate == B115200 && nSpeed != 115200){
		//got specil baud, not standerd
		printf("the baud set is not standerd, please call other function to set \n");
		return 1;
	}
	tcflush(iFdCom, TCIOFLUSH);
	cfsetispeed(&tOldTermios, iBaudrate);
	cfsetospeed(&tOldTermios, iBaudrate);
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
        printf("Set vFnSetBaud error. iFd == %d\n", iFdCom);
		return 1;
	}
	tcflush(iFdCom, TCIOFLUSH);	

	return 0;

}

static void crc_com_SetnBit(int32_t iFdCom, int nBits)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions

	switch( nBits )
    {
    case 7:
        tOldTermios.c_cflag |= CS7;
        break;
    case 8:
	default:	
        tOldTermios.c_cflag |= CS8;
        break;
    }
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
        printf("Set vFnSetnBit error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void crc_com_SetParity(int32_t iFdCom,char nEvent)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    switch( nEvent )
    {
    case 'O':
        tOldTermios.c_cflag |= PARENB;
        tOldTermios.c_cflag |= PARODD;
        tOldTermios.c_iflag |= (INPCK | ISTRIP);
        break;
    case 'E':
        tOldTermios.c_iflag |= (INPCK | ISTRIP);
        tOldTermios.c_cflag |= PARENB;
        tOldTermios.c_cflag &= ~PARODD;
        break;
    case 'N':
    default:
		tOldTermios.c_cflag &= ~PARENB;
        break;
    }
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
       printf("Set vFnSetParity error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void crc_com_SetnStop(int32_t iFdCom, int nStop)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions


    switch( nStop )
    {
    case 1:                    
        tOldTermios.c_cflag &=  ~CSTOPB;
        break;
    case 2:  
		tOldTermios.c_cflag |=  CSTOPB;
		break;
    default:
		tOldTermios.c_cflag &=  ~CSTOPB;
		break;
    }
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
        printf("Set vFnSetnStop error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void crc_com_SetCtrl(int32_t iFdCom, int nCtrl)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions

	switch(nCtrl)
	{
	case 0:
		{
			tOldTermios.c_cflag &= ~CRTSCTS;        //no flow control
			tOldTermios.c_iflag |= IGNBRK | IGNPAR;
		}break;
	case 1:
		{
			tOldTermios.c_cflag |= CRTSCTS;         //hardware flow control
		}break;
	case 2:
		{
			tOldTermios.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
		}break;
	default:
		break;
	}
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
       	 printf("Set vFnSetCtrl error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

	//printf("Set vFnSetCtrl end\n");

}


static void crc_com_SetTimeOut(int32_t iFdCom, int iTime)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions

	tOldTermios.c_cc[VTIME] = iTime;
	tOldTermios.c_cc[VMIN] = 0;

	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)
	{	
        printf("Set TimeOut error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void com_SetIO_Para(int32_t iFdCom)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
	tOldTermios.c_iflag &= ~(ICRNL | IXON);
	tOldTermios.c_lflag &= ~(ICANON | ECHO | ECHOE | ECHOK | ISIG);
	tOldTermios.c_oflag &= ~OPOST;
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //set new attr, TCSANOW: apply right now
	{	
        printf("Set TimeOut error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);
	printf("com_SetIO_Para over.\n");
}

static int zUP_SetPort_0(int32_t iFd ,int ctsrts_en, int iBaud, int iDelay)
{		
	crc_com_SetBaud(iFd, iBaud);
	crc_com_SetnBit(iFd, 8);
	crc_com_SetParity(iFd, 'N');
	//com_SetParity(iFd, 'O');
	crc_com_SetnStop(iFd,1);
	crc_com_SetCtrl(iFd,ctsrts_en); //add flow control
	com_SetIO_Para(iFd);
	crc_com_SetTimeOut(iFd,iDelay); //timeout 100ms
	
	printf("set serial port0 done!\n");
	
    return 0;
}

static int zUP_SetPort_2(int32_t iFd, int ctsrts_en, int iBaud, int iDelay)
{
	crc_com_SetBaud(iFd, iBaud);
	crc_com_SetnBit(iFd, 8);
	crc_com_SetParity(iFd, 'N');
	//com_SetParity(iFd, 'O');
	crc_com_SetnStop(iFd, 1);
	crc_com_SetCtrl(iFd, ctsrts_en); //add flow control
	com_SetIO_Para(iFd);
	crc_com_SetTimeOut(iFd, iDelay); //timeout 100ms

	printf("set serial port2 done!\n");

	return 0;
}

//block to detect pc's data
int block_select_one_time()
{
	int ret;
	fd_set rfds;
	FD_ZERO(&rfds);
	FD_SET(uart_fd_2,&rfds);
	ret = select(uart_fd_2+1,&rfds,NULL,NULL,NULL);
	if(ret == -1)
	{
		printf("uart_fd_2 select error: -1");
		return 0;
	}
	else
	{
		return 1;
	}
	
	return 1;
}

//send ack to pc
int send_one_time()
{
	int len = 0;
	
	len = write(uart_fd_2, &times, 4); 
	if(len <= 0)
	{
		printf("Ack write failed %s\n",strerror(errno));
		return 0;
	}
	
	printf("Ack send success index :%d\n", times);
	return 1;
}

//send data to mcu
int send_data_to_mcu()
{
	int len = 0;
	len = write(uart_fd_0, dbuf, tlen);
	if (len <= 0)
	{
		printf("data write to mcu failed %s\n", strerror(errno));
		return 0;
	}

	printf("data send to mcu success, src tlen is %d, write to mcu's len :%d\n", tlen, len);
	return 1;
}

int read_datas_tty()
{
	int recv_len = 0;
	tlen = 0;
	
	while(1)
	{
		recv_len = read(uart_fd_2, dbuf+tlen, ONE_LEN);
		if(recv_len == 0)
		{
			printf("read_datas_tty end! please wait for this packet's handle! total len: %d\n", tlen);
			break;
		}
		else if(recv_len < 0)
		{
			printf("read_datas_tty error %s\n",strerror(errno));
			return 0;
		}
		else
		{
			tlen += recv_len;
		}
	}
	
	//printf("0 is %#x, 1 is %#x, -3 is %#x, -2 is %#x, -1 is %#x\n",dbuf[0],dbuf[1],dbuf[tlen-3],dbuf[tlen-2],dbuf[tlen-1]);
	return 1;
}

//send packet data to mcu
int interact_to_mcu()
{
	int ret = 0;
	int mcu_status = 0;
	ret = send_data_to_mcu();
	if (!ret)
	{
		return 0;
	}
	sem_wait(&sleep_sem);
	printf("-------------------------------sleep_sem recv:now I am sleeping--------------------------\n");
	crc_wakeup_mcu(0);
	check_other_side_sleep();

	return 1;
}

/* hot swapping socket init */
int monitor_sock_init()
{
	int sockfd = 0;
	int ret;
	struct sockaddr_nl snl;

	bzero(&snl, sizeof(struct sockaddr_nl));
	snl.nl_family = AF_NETLINK;
	snl.nl_pid = getpid();
	snl.nl_groups = 1;

	if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
		perror("signal");

	sockfd = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
	if (sockfd < 0) {
		//slog(NET_PRINT, SLOG_ERR, "create hotplug socket failed!\n");
		return -1;
	}
//  setsockopt(sockfd, SOL_SOCKET, SO_RCVBUF, &buffersize, sizeof(buffersize));

	ret = bind(sockfd, (struct sockaddr *)&snl, sizeof(struct sockaddr_nl));
	if (ret < 0) {
		//slog(NET_PRINT, SLOG_ERR, "hotplug socket bind fail!\n");
		close(sockfd);
		return -1;
	}

	return sockfd;
}

int wakeup_monitor_proc()
{
	int monitor_fd = 0;
	fd_set readfds;
	int maxfd = 0;
	char buf[NETLINK_BUFFER_SIZE] = {0};
	int len = 0;
	int ret = 0;
	
	//prctl(PR_SET_NAME, "hotplug", 0, 0, 0);
	//loglevel_init();
	
	monitor_fd = monitor_sock_init();
	if (monitor_fd < 0) {
		//slog(NET_PRINT, SLOG_ERR, "hotplug socket init fail!\n");
		return -1;
	}

	printf("wakeup_monitor_proc,now waiting msg\n");
	
	maxfd = monitor_fd;
	while (1) {
		FD_ZERO(&readfds);
		FD_SET(monitor_fd, &readfds);
		ret = select(maxfd + 1, &readfds, NULL, NULL, NULL);
		if (ret == -1 && errno == EINTR)
			continue;

		if (FD_ISSET(monitor_fd, &readfds)) {
			memset(buf, 0, sizeof(buf));
			len = recv(monitor_fd, &buf, sizeof(buf), 0);
			if (len <= 0) {
				//slog(NET_PRINT, SLOG_ERR, "hotplug recv msg fail!\n");
				continue;
			}
			printf("now receive msg\n");
			if(strstr(buf, "xp2xp_notify"))
			{
				//msg is from xp2xp
				if(strstr(buf, "online@"))
				{
					// now is wakeup
					printf("now receive msg online \n");
					write_lock("/sys/power/wake_lock", TEST_WAKELOCK_NAME);
					g_enter_sleep = 0;
					crc_set_modem_state(1);
					sem_post(&wake_sem);	
				}
				else if(strstr(buf, "offline@"))
				{ 
					//now is sleep
					printf("now receive msg offline \n");
					write_lock("/sys/power/wake_unlock", TEST_WAKELOCK_NAME);
					//crc_wakeup_mcu(0);
					g_enter_sleep = 1;
					crc_set_modem_state(0);
					sem_post(&sleep_sem);
				}
			}
			
			if(stop_monitor){//now exit from this thread
				break;
			}
		}
	}
	close(maxfd);
	return 0;
}

int mcu_state_proc()
{
	int ret = 0;
	int mcu_status = 0;
	while (1)
	{
	    sem_wait(&mcu_state_monitor);
		do{
			mcu_status = crc_get_mcu_state();
			if(mcu_status > 0 && mcu_status < 10)
			{
				printf("do while check the other side state,now change to :%d\n", mcu_status);
				sem_post(&mcu_state_sem);
				break;
			}
			usleep(1500);
		}while(mcu_status == 0);
	}

	return 0;
}

int create_monitor_thread(void)
{
	int iResult = -1;
	pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    iResult = pthread_create(&wakeup_monitor, &attr, wakeup_monitor_proc, NULL);
	pthread_attr_destroy(&attr);
	if(iResult)
	{
	   	//slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug_thread_create fail %d\n", iResult);
		return -1;
	}
 
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    iResult = pthread_create(&mcu_state_mon_th, &attr, mcu_state_proc, NULL);
	pthread_attr_destroy(&attr);
	if(iResult)
	{
	   	//slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug_thread_create fail %d\n", iResult);
		return -1;
	}
	
	return 0;
}

void check_other_side_sleep()
{
	int mcu_status = 0;
	do
	{
		mcu_status = crc_get_mcu_state();
		if (mcu_status == 0)
		{
			//printf("do while check the other side state,now change to :%d\n", mcu_status);
			break;
		}
		usleep(1500);
	} while (mcu_status == 1);
	printf("-------------------------------check_other_side_sleep:now the other side is sleeping--------------------------\n");
}

int main(int argc, char** argv)
{
	int ret0 = 0;
	int baud = atoi(argv[1]);
	int delay = atoi(argv[2]);
	printf("modem crc main program start...\n");

	sem_init(&wake_sem, 0, 0);
	sem_init(&sleep_sem, 0, 0);
	sem_init(&mcu_state_sem, 0, 0);
	sem_init(&mcu_state_monitor, 0, 0);

	//signal(SIGINT,int_handle);
	signal(SIGINT, process_exit);
	signal(SIGTERM, process_exit);
	
	ret0 = crc_gpio_init();
	if(ret0)
	{
		printf("crc_gpio_init fail, test exit\n");
		return -1;
	}
	
	ret0 = create_monitor_thread();
	if(ret0)
	{
		printf("create_monitor_thread fail, test exit\n");
	}

    uart_fd_0 = open("/dev/ttyS0",O_RDWR);//connect to mcu
	if (uart_fd_0 < 0)
	{
		printf("open uart0 dev failed :%s\n", strerror(errno));
		return -1;
	}

	uart_fd_2 = open("/dev/ttyS2", O_RDWR);//connect to pc
	if (uart_fd_2 < 0)
	{
		printf("open uart2 dev failed :%s\n", strerror(errno));
		return -1;
	}
   
	zUP_SetPort_0(uart_fd_0, 0, baud, delay);
	zUP_SetPort_2(uart_fd_2, 0, baud, delay);

    memset(dbuf,0,2100000);
	//sleep(10);
	//crc_set_modem_state(0);
	crc_wakeup_mcu(0);
	check_other_side_sleep();

	sem_wait(&sleep_sem);
	printf("-------------------------------sleep_sem recv:now I am sleeping--------------------------\n");

	while (1)
	{
		ret0 = send_one_time();
		if (!ret0)
		{
			break;
		}

		if (block_select_one_time())
		{
			ret0 = read_datas_tty();
			if (ret0)
			{
				//waiting for mcu waking up,if now sleep,pass this packet
				if (g_enter_sleep == 0)
				{
					wake_times++;
					sem_wait(&wake_sem);
					printf("-------------------------------wake_sem recv:now the I am waking!wake_times is %d--------------------------\n", wake_times);
					//if mcu sleep, modem waking up it
					if (crc_get_mcu_state() == 0)
					{
						crc_wakeup_mcu(1);
						//wakeup read thread
						sem_post(&mcu_state_monitor);
						printf("waiting for mcu up\n");
						sem_wait(&mcu_state_sem);
						printf("-------------------------------mcu_state_sem recv:now the other side is waking--------------------------\n");
					}

					ret0 = interact_to_mcu();
					if (!ret0)
					{
						printf("interact_to_mcu failed\n");
						break;
					}
				}
				times++;
			}
			else
			{
				printf("read_datas_tty failed\n");
				break;
			}
		}
	}

	printf("modem crc main programe end...\n");
    close(uart_fd_0);
	crc_release_gpio();
	return 0;
}
	
