


int  cpe_refresh_igd_ld_lhcm_ipinterface(cwmp_t * cwmp, parameter_node_t * param_node, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();

    if(!param_node)
    {
        return FAULT_CODE_9002;
    }
    parameter_node_t * tmp_param, *tmp_node, *child_param;
    child_param = param_node->child;
    if(child_param)
    {
        for(tmp_param=child_param->next_sibling; tmp_param; )
        {
            cwmp_log_info("refresh LANDevice.{i}.LANHostConfigManagement.IPInterface node, delete param %s\n", tmp_param->name);
            tmp_node = tmp_param->next_sibling;
            cwmp_model_delete_parameter(tmp_param);
            tmp_param = tmp_node;
        }
        child_param->next_sibling = NULL;

		cwmp_log_info("ready to get lan index");
        int lan_index = get_index_after_paramname(param_node, "LANDevice"); 

        cwmp_log_info("lan index is:%d", lan_index);
		
        parameter_node_t * lan1conn_param;
        cwmp_model_copy_parameter(param_node, &lan1conn_param, 1);
		
        if(lan_index == 2)
        {
             parameter_node_t * lan2conn_param;
             cwmp_model_copy_parameter(param_node, &lan2conn_param, 2);
        }

        cwmp_model_refresh_object(cwmp, param_node, 0, callback_reg); 
    }

    return FAULT_CODE_OK;
}


int cpe_get_igd_ld_lhcm_ipinterfaceipaddress(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();

	*value = pool_pstrdup(pool, "192.168.0.1");

    return	FAULT_CODE_OK;

}


int cpe_get_igd_ld_lhcm_ipinterfacesubnetMask(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();

	*value = pool_pstrdup(pool, "255.255.255.0");

    return	FAULT_CODE_OK;

}


int cpe_set_igd_ld_lhcm_ipinterfaceipaddress(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
	cwmp_log_info("value is:%s", value);
    return FAULT_CODE_OK;
}

int cpe_set_igd_ld_lhcm_ipinterfacesubnetMask(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();
	cwmp_log_info("value is:%s", value);
    return FAULT_CODE_OK;
}




