
/************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ zte_web_lan.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ zyt
* ڣ 2010-11-06
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/

/**************************************************************************
* ޸ı : ¹
*    : chenjie10092374
* ޸ : 2014.6.24
* ޸ : ֧ufi monitorܴ
**************************************************************************/
#include   <ctype.h>

#include "zte_web_interface.h"
#include "./net/zte_web_net_other.h"
#include "netotherapi.h"

#define WDS_DISABLE "0"
#define WDS_ROOTAP "1"
#define WDS_CLIENT "2"
#define WDS_REPEATER "3"
#define WIFI_MAX_STA_NUM 32 //kw 3


#define NV_WRITE(nv_name, str, ret)  do{ ret = zte_web_write(nv_name, (char *)str);}while(0)

static int zte_wlan_ssid1_basic_set(webs_t wp, unsigned int *wifi_set_flags);
static int zte_lan_ssid1_security_set(webs_t wp, unsigned int *wifi_set_flags);
static int zte_wlan_ssid2_basic_set(webs_t wp, unsigned int *wifi_set_flags);
static int zte_lan_ssid2_security_set(webs_t wp, unsigned int *wifi_set_flags);

static int get_random(unsigned char* buf, size_t len);


enum {WIFI_COVERAGE_LEN = 16};
/**
 * @brief wifi share mode setting's struct
 * @param wep_key_index
 * @param wep_key1_mode
 * @param wep_key2_mode
 * @param wep_key3_mode
 * @param wep_key4_mode
 * @param wep_key1
 * @param wep_key2
 * @param wep_key3
 * @param wep_key4
 * @note
 * @warning
 */
typedef struct {
	uint8 wep_key_index[WF_WPS_KEY_INDEX_LEN];
	uint8 wep_key1_mode[WF_KEY_MODE_LEN];
	uint8 wep_key2_mode[WF_KEY_MODE_LEN];
	uint8 wep_key3_mode[WF_KEY_MODE_LEN];
	uint8 wep_key4_mode[WF_KEY_MODE_LEN];
	uint8 wep_key1[WF_WEP_KEY_MAX_LEN];
	uint8 wep_key2[WF_WEP_KEY_MAX_LEN];
	uint8 wep_key3[WF_WEP_KEY_MAX_LEN];
	uint8 wep_key4[WF_WEP_KEY_MAX_LEN];
} zte_wifi_open_and_share_mode_s_type;
/*wifi WPA/WPA2 mode setting*/
typedef struct {
	uint8 pre_share_key[WF_WPA_KEY_MAX_LEN];
} zte_wifi_wpa_and_wpa2_mode_s_type;

static char * str2upper(const char * in, char * out)
{
	char *p1 = in;
	char  *p2 = out;
	if (in == NULL || out == NULL) return NULL;

	slog(MISC_PRINT, SLOG_DEBUG,"[%s]  in=%s\n", __FILE__, in);

	while (*p1   != '\0') {
		//if (isalpha(*p1)) {//cov m
		if ((*p1) >= 'a' && (*p1) <= 'z') {
			*p2   = toupper(*p1);
		} else {
			*p2  =  *p1;
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[%s]  UPPER = %c[%d],  Lower=%c[%d]\n", __FILE__, *p2, *p2, *p1, *p1);
		p1++;
		p2++;
	}

	*p2 = '\0';
	return out;

}

static int validate_pin_code(unsigned long code)
{
	unsigned long accum = 0;
	accum += 3 * ((code / 10000000) % 10);
	accum += 1 * ((code / 1000000) % 10);
	accum += 3 * ((code / 100000) % 10);
	accum += 1 * ((code / 10000) % 10);
	accum += 3 * ((code / 1000) % 10);
	accum += 1 * ((code / 100) % 10);
	accum += 3 * ((code / 10) % 10);
	accum += 1 * ((code / 1) % 10);
	return (0 == (accum % 10));
}
static int zte_Safe_valid_SpecialCharForSSID(char single_data)
{
	/*if(single_data == '&') return 0;
	else if(single_data == '.') return 0;
	else if(single_data == '`') return 0;
	else if(single_data == '\\') return 0;
	else*/
	return 1;
}


static data_safe_result_type_t zte_Safe_noSpecialCharForSSID(char *str)
{
#if 0 //kw 3
	int i = 0;
	int len = 0;
	if (NULL == str) {
		return 0;
	}

	len = strlen(str);
	for (i = 0; i < len; i++) {
		if (zte_Safe_valid_SpecialCharForSSID(str[i]) != 0) {
			continue;
		} else {
			return 0;
		}
	}
#endif
	return 1;
}

void wlan_set_change_ssid_key_status()
{
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_MODIFY_SSID_KEY, 0, NULL, 0);
}


void wifi_work_mode_set_basic()
{
	char m_ssid_enable[20] = {0};
	char system_restore_flg[32] = {0};
	char MAX_Access_num[16] = {0};
	char m_MAX_Access_num[16] = {0};
	char MAX_Station_num[16] = {0};

	char num_buf[12] = {0};
	char m_num_buf[12] = {0};
	int max_sta_num = 0;
	int max_num = 0;
	int m_max_num = 0;
	char max_access_bak[16] = {0};
	char max_station_bak[16] = {0};
	sc_cfg_get("MAX_Access_num_bbak", max_access_bak, sizeof(max_access_bak));
	sc_cfg_get("MAX_Station_num_bak", max_station_bak, sizeof(max_station_bak));
	slog(MISC_PRINT, SLOG_ERR,"MAX_Access_num_bbak:%s,MAX_Station_num_bak:%s\n",max_access_bak,max_station_bak);
	if(strlen(max_station_bak) != 0 && strcmp(max_station_bak, "0")){	
		sc_cfg_set("MAX_Station_num",max_station_bak);
		sc_cfg_set("MAX_Station_num_bak","0");
	}
	if(strlen(max_access_bak) != 0 && strcmp(max_access_bak, "0")){
		sc_cfg_set("MAX_Access_num", max_access_bak);	
	}

	//wifi workmode set
	sc_cfg_get("m_ssid_enable", m_ssid_enable, sizeof(m_ssid_enable));
	sc_cfg_get("system_restore_flg", system_restore_flg, sizeof(system_restore_flg));

	if (!strcmp(m_ssid_enable, "1")) {
		sc_cfg_set("AP_STARTMODE", "multi");
		if (!strcmp(system_restore_flg, "first_restore")) {
			sc_cfg_set("system_restore_flg", "not_first_restore");
			slog(MISC_PRINT, SLOG_DEBUG,"is first config access num.....\n");

			sc_cfg_get("MAX_Access_num", MAX_Access_num, sizeof(MAX_Access_num));
			max_num = atoi(MAX_Access_num);
			if (max_num > 1 && max_num < 33) {
				sprintf(num_buf, "%d", max_num / 2);
				slog(MISC_PRINT, SLOG_DEBUG,"num_buf = %s\n", num_buf);
				zte_web_write("MAX_Access_num", num_buf);
				zte_web_write("m_MAX_Access_num", num_buf);
			}
		}

		sc_cfg_get("MAX_Station_num", MAX_Station_num, sizeof(MAX_Station_num));
		sc_cfg_get("MAX_Access_num", MAX_Access_num, sizeof(MAX_Access_num));
		sc_cfg_get("m_MAX_Access_num", m_MAX_Access_num, sizeof(m_MAX_Access_num));

		zte_web_write("MAX_Access_num_bak", MAX_Access_num);

		slog(MISC_PRINT, SLOG_DEBUG,"[%s],MAX_Access_num_bak=%s\n", __FILE__, MAX_Access_num);

		max_sta_num = atoi(MAX_Station_num);
		max_num = atoi(MAX_Access_num);
		m_max_num = atoi(m_MAX_Access_num);
		if ((max_sta_num < 0 || max_sta_num > WIFI_MAX_STA_NUM) ||
			(max_num < 0 || max_num > WIFI_MAX_STA_NUM)) { //kw 3
			slog(MISC_PRINT, SLOG_ERR,"\n error max_sta_num parameter\n");
			return;
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[%s],MAX_Station_num=%s,MAX_Access_num=%s,m_MAX_Access_num=%s\n", __FILE__, MAX_Station_num, MAX_Access_num, m_MAX_Access_num);
		if (max_num == max_sta_num) {
			sprintf(m_num_buf, "%d", max_sta_num / 2);
			zte_web_write("MAX_Access_num", m_num_buf);
			zte_web_write("m_MAX_Access_num", m_num_buf);
		} else {
			if (max_num < max_sta_num) { // ʵϣ˵ֵСֵ˴ж
				m_max_num = max_sta_num - max_num;
				sprintf(m_num_buf, "%d", m_max_num);
				zte_web_write("m_MAX_Access_num", m_num_buf);
			}

		}

	} else if (!strcmp(m_ssid_enable, "0")) {
		sc_cfg_set("AP_STARTMODE", "standard");
		sc_cfg_get("MAX_Access_num_bak", MAX_Access_num, sizeof(MAX_Access_num));
		zte_web_write("MAX_Access_num", MAX_Access_num);
	} else {
		slog(MISC_PRINT, SLOG_ERR,"\n error wifi_work_mode_set parameter\n");
		return;
	}
}

void zte_lan_stop_apsta()
{
	zte_web_write("wifi_sta_connection", "0");
	//zte_web_write("blc_switch", "00");
	zte_web_write("user_initiate_disconnect", "0"); //û״̬˳Ԥģʽ
	zte_web_write("manual_d_wifi", "0");

	slog(MISC_PRINT, SLOG_NORMAL,"[lan_stop_apsta]MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID\n", 0, NULL);

	//zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID, 0,  NULL);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID, 0, NULL, 0);
}

void zte_wlan_basic_set(webs_t wp)
{
	char_t *wifi_on = NULL, *old_wifi_on = NULL;
	char_t *radio_off = NULL;
	char_t  *wirelessmode = NULL, *old_wirelessmode = NULL;
	char_t  *countrycode = NULL, *old_countrycode = NULL;
	//char_t  *ssid = NULL, *old_ssid = NULL;
	char_t  *broadcastssid = NULL, *old_broadcastssid = NULL ;
	char_t  *channel = NULL, *old_channel = NULL;
	//char_t *abg_rate = NULL,*old_abg_rate = NULL;
	//char_t *NoForwarding = NULL,*old_NoForwarding = NULL;
	char_t *MAX_Access_num = NULL, *old_MAX_Access_num = NULL;
	char_t *m_ssid_enable = NULL, *old_m_ssid_enable = NULL;
	//char_t *m_SSID = NULL,*old_m_SSID = NULL;
	//char_t *m_HideSSID = NULL,*old_m_HideSSID = NULL;
	//char_t *m_NoForwarding = NULL,*old_m_NoForwarding =NULL;
	char_t *wifi_11n_cap = NULL, *old_wifi_11n_cap = NULL;
	//char_t  *channel_JP = NULL, *old_channel_JP = NULL;
	char_t  *wifi_band = NULL, *old_wifi_band = NULL;

	//int Access_num = 0;
	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};
	char wifi_sta_connection[8] = {0};

	zte_topsw_state_e_type nv_ret = ZTE_NVIO_DONE;
	char nv_basic[NVIO_WIFI_MAX_LEN] = {0}; // for nv read and write
//cov m
#define NV_READ(nv_name, str, ret) do{ret = zte_web_read(nv_name, nv_basic); str = nv_basic;}while(0)
	/*lint -e717*/
	//#define NV_WRITE(nv_name, str, ret)  do{ ret = zte_web_write(nv_name, (char *)str);}while(0)

	slog(WIFI_PRINT, SLOG_ERR, "wlan_basic_set enter \n");

	//reset wifi_set_flags
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, "");

	//wifiEnabled or not
	memset(nv_basic, 0, sizeof(nv_basic));
	wifi_on = websGetVar(wp, T("wifiEnabled"), NULL);
	if (wifi_on != NULL) {
		if (STR_EQUAL(wifi_on, "0")) {
			slog(MISC_PRINT, SLOG_ERR, T("UFIx User disable WIFI swtich!\n"));
		} else if (STR_EQUAL(wifi_on, "1")) {
			slog(MISC_PRINT, SLOG_ERR, T("UFIx User enable WIFI swtich!\n"));
		}
		NV_READ("wifiEnabled", old_wifi_on, nv_ret);
		printf("[%s:%s]old_wifi_on=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_wifi_on, nv_ret);
		//NV_READ("RadioOff", radio_off, nv_ret);
		//printf("[%s:%s]radio_off=%s, nv_ret=%d",__FILE__, __FUNCTION__, radio_off,nv_ret);
		if (!STR_EQUAL(wifi_on, old_wifi_on)) { //kw 3
			//send_to_mc = TRUE;
			wifi_set_flags |= ZTE_WLAN_ON_OFF_SET;
			NV_WRITE("wifiEnabled", wifi_on, nv_ret);

#if 0
			if (STR_EQUAL(wifi_on, "0") && STR_EQUAL(radio_off, "1")) {
				NV_WRITE("wifiEnabled", wifi_on, nv_ret);
				NV_WRITE("RadioOff", wifi_on, nv_ret);
				NV_WRITE("RadioOn", wifi_on, nv_ret);

			} else if (STR_EQUAL(wifi_on, "1")) {
				NV_WRITE("wifiEnabled", wifi_on, nv_ret);
				NV_WRITE("RadioOn", wifi_on, nv_ret);
			}
#endif
		}
		printf("[%s:%s]wifi_on:[%s]\n", __FILE__, __FUNCTION__, wifi_on);
	}

	//wifiMode
	memset(nv_basic, 0, sizeof(nv_basic));
	wirelessmode = websGetVar(wp, T("wifiMode"), NULL);
	if (wirelessmode != NULL) {
		slog(MISC_PRINT, SLOG_ERR, T("UFIx User set WIFI advanced settings!\n"));
		printf("[%s:%s]wirelessmode:%s\n", __FILE__, __FUNCTION__, wirelessmode);   /*lint !e26*/
		NV_READ("WirelessMode", old_wirelessmode, nv_ret);
		printf("[%s:%s]old_wirelessmode=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_wirelessmode, nv_ret); /*lint !e26*/
		if (!STR_EQUAL(wirelessmode, old_wirelessmode)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_WIRELESS_MODE_SET;
			NV_WRITE("WirelessMode", wirelessmode, nv_ret);
			printf("[%s:%s]wirelessmode is :%s\n", __FILE__, __FUNCTION__, wirelessmode);       /*lint !e26*/
		}
	}

	/* country code*/
	memset(nv_basic, 0, sizeof(nv_basic));
	countrycode = websGetVar(wp, T("countryCode"), NULL);
	if (countrycode != NULL) {
#ifdef WEBS_SECURITY
		zte_web_read("wifi_sta_connection", wifi_sta_connection);
		if(wifi_sta_connection[0] == '1')
		{
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
#endif		
		NV_READ("CountryCode", old_countrycode, nv_ret);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]old_countrycode=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_countrycode, nv_ret);  /*lint !e26*/
		if (!STR_EQUAL(countrycode, old_countrycode)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_COUNTRY_SET;
			NV_WRITE("CountryCode", countrycode, nv_ret);
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]countrycode:%s\n", __FILE__, __FUNCTION__, countrycode);         /*lint !e26*/
	}

#if 0  //ڸ߼Ƶ
	//broadcastSsidEnabled
	memset(nv_basic, 0, sizeof(nv_basic));
	broadcastssid = websGetVar(wp, T("broadcastSsidEnabled"), NULL);
	if (broadcastssid != NULL) {
		NV_READ("HideSSID", old_broadcastssid, nv_ret);
		printf("[%s:%s]old_broadcastssid=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_broadcastssid, nv_ret);  /*lint !e26*/
		if ((nv_ret ==  ZTE_NVIO_DONE &&
		     !STR_EQUAL(broadcastssid, old_broadcastssid)) ||
		    (nv_ret !=  ZTE_NVIO_DONE)) {
			//send_to_mc = TRUE;
			wifi_set_flags |= ZTE_WLAN_BROADCAST_SET;
			NV_WRITE("HideSSID", broadcastssid, nv_ret);
		}
		printf("[%s:%s]broadcastssid:%s\n", __FILE__, __FUNCTION__, broadcastssid);     /*lint !e26*/
	}
#endif
	//selectedChannel
	memset(nv_basic, 0, sizeof(nv_basic));
	channel = websGetVar(wp, T("selectedChannel"), NULL);
	if (channel != NULL) {
		NV_READ("Channel", old_channel, nv_ret);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]old_channel=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_channel, nv_ret);  /*lint !e26*/
		if (!STR_EQUAL(channel, old_channel)) { //kw 3
			//send_to_mc = TRUE;
			wifi_set_flags |= ZTE_WLAN_CHANNEL_SET;
			NV_WRITE("Channel", channel, nv_ret);
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]channel:%s\n", __FILE__, __FUNCTION__, channel); /*lint !e26*/
	}

	//band setting
	memset(nv_basic, 0, sizeof(nv_basic));
	wifi_band = websGetVar(wp, T("wifi_band"), NULL);
	if (wifi_band != NULL) {
		NV_READ("wifi_band", old_wifi_band, nv_ret);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]old_wifi_band=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_wifi_band, nv_ret);      /*lint !e26*/
		if (!STR_EQUAL(wifi_band, old_wifi_band)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_WIFI_BAND_SET;
			NV_WRITE("wifi_band", wifi_band, nv_ret);
		}
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]wifi_band:%s\n", __FILE__, __FUNCTION__, wifi_band);         /*lint !e26*/
	}


	//set wifi rate
#if 0
	memset(nv_basic, 0, sizeof(nv_basic));
	abg_rate = websGetVar(wp, T("abg_rate"), NULL);
	if (abg_rate != NULL) {
		NV_READ("HT_MCS", old_abg_rate, nv_ret);
		printf("old_abg_rate=%s, nv_ret=%d", old_abg_rate, nv_ret);  /*lint !e26*/
		if ((nv_ret ==  ZTE_NVIO_DONE &&
		     !STR_EQUAL(abg_rate, old_abg_rate)) ||
		    (nv_ret !=  ZTE_NVIO_DONE)) {
			wifi_set_flags |= ZTE_WLAN_DATA_RATE_SET;
			NV_WRITE("HT_MCS", abg_rate, nv_ret);
		}

		printf("abg_rate:%s", abg_rate); /*lint !e26*/
	}
#endif

#if 0 // not belong to RF parameters
	//set  MAX_Access_num
	memset(nv_basic, 0, sizeof(nv_basic));
	MAX_Access_num = websGetVar(wp, T("MAX_Access_num"), NULL);
	if (MAX_Access_num != NULL) {
		NV_READ("MAX_Access_num", old_MAX_Access_num, nv_ret);
		printf("[%s:%s]old_MAX_Access_num=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_MAX_Access_num, nv_ret);    /*lint !e26*/
		if ((nv_ret ==  ZTE_NVIO_DONE &&
		     !STR_EQUAL(MAX_Access_num, old_MAX_Access_num)) ||
		    (nv_ret !=  ZTE_NVIO_DONE)) {
			wifi_set_flags |= ZTE_WLAN_MAX_ACCESS_NUM_SET;
			NV_WRITE("MAX_Access_num", MAX_Access_num, nv_ret);
			NV_WRITE("MAX_Access_num_user_set", "1", nv_ret);
		}

		printf("[%s:%s]MAX_Access_num:%s\n", __FILE__, __FUNCTION__, MAX_Access_num);   /*lint !e26*/
	}
#endif
	//set  m_ssid_enable
	memset(nv_basic, 0, sizeof(nv_basic));
	m_ssid_enable = websGetVar(wp, T("m_ssid_enable"), NULL);
	if (m_ssid_enable != NULL) {
#if 1
		NV_READ("m_ssid_enable", old_m_ssid_enable, nv_ret);
		slog(MISC_PRINT, SLOG_DEBUG,"old_m_ssid_enable=%s, nv_ret=%d\n", old_m_ssid_enable, nv_ret);/*lint !e26*/
		if (!STR_EQUAL(m_ssid_enable, old_m_ssid_enable)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
			NV_WRITE("m_ssid_enable", m_ssid_enable, nv_ret);
			wlan_set_change_ssid_key_status();//added by dujiajiao
			wifi_work_mode_set_basic();
		}
#else
		if (!strcmp(m_ssid_enable, "1")) {
			NV_WRITE("m_ssid_enable", "0", nv_ret);
		}
#endif
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]m_ssid_enable:%s\n", __FILE__, __FUNCTION__, m_ssid_enable); /*lint !e26*/
	}

	//set  wifi_11n_cap
	memset(nv_basic, 0, sizeof(nv_basic));
	NV_READ("wifi_11n_cap", old_wifi_11n_cap, nv_ret);
	slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]old_wifi_11n_cap=%s, nv_ret=%d\n", __FILE__, __FUNCTION__, old_wifi_11n_cap, nv_ret); /*lint !e26*/
	wifi_11n_cap = websGetVar(wp, T("wifi_11n_cap"), NULL);
	if (wifi_11n_cap != NULL) {
		if (!STR_EQUAL(wifi_11n_cap, old_wifi_11n_cap)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_WIRELESS_MODE_SET;
			NV_WRITE("wifi_11n_cap", wifi_11n_cap, nv_ret);
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]wifi_11n_cap:%s\n", __FILE__, __FUNCTION__, wifi_11n_cap);       /*lint !e26*/
	}

	//last, write the wifi_set_flags
	(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);
	slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]wifi_set_flags:[0x%x] to [%s]\n", __FILE__, __FUNCTION__, wifi_set_flags, wifi_set_flags_str); /*lint !e26*/

	if (0 != wifi_set_flags) {
		unsigned int  flags = 0;
		UCHAR  flag_str[8] = {0};
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]send wifi para to wlan-server@basic_set\n", __FILE__, __FUNCTION__); /*lint !e26*/

		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]m_ssid_enable=%s,wifi_on=%s\n", __FILE__, __FUNCTION__, m_ssid_enable, wifi_on); /*lint !e26*/

		if (NULL != wifi_on && (wifi_set_flags & ZTE_WLAN_ON_OFF_SET)) {
//wifiʱͬʱMSSIDֻÿwifi flagsΪMSSIDnvѾù

			if (0 == atoi(wifi_on))
				flags = WIFI_ADVANCED_CLOSE;
			else if (m_ssid_enable != NULL && 1 == atoi(m_ssid_enable)) { // ͬʱmultisssidҪԤapsta һ
				flags = WIFI_ADVANCED_OPEN_VA01;
			} else
				flags = WIFI_ADVANCED_OPEN;

		} else if (wifi_set_flags & ZTE_WLAN_SET_AP_MSSID) { // wifiؿ״̬£ Multi SSID пл
			if (1 == atoi(m_ssid_enable))
				flags = WIFI_ADVANCED_OPEN_VA1;
			else
				flags = WIFI_ADVANCED_CLOSE_MSSID;

		} else { // ø߼Ƶ
			flags = WIFI_ADVANCED_RF;
		}
		snprintf(flag_str,sizeof(flag_str), "%d", flags);
		zte_web_read("wifi_sta_connection", wifi_sta_connection);


		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]m_ssid_enable=%s,wifi_on=%s\n", __FILE__, __FUNCTION__, m_ssid_enable, wifi_on); /*lint !e26*/

//when open mssid , need close apsta at same time
		if ((flags == WIFI_ADVANCED_OPEN_VA1) &&  atoi(wifi_sta_connection) == 1) {
			zte_lan_stop_apsta();
		} else {
			//if(0 != zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, strlen(flag_str)+1,  flag_str))
			if (0 != ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, strlen(flag_str) + 1, flag_str, 0)) {
				zte_write_result_to_web(wp, FAILURE);
				return;
			}
		}
		slog(WIFI_PRINT, SLOG_ERR, "[%s:%s]wifi set cmd done! \n", __FILE__, __FUNCTION__); /*lint !e26*/
	}
	zte_write_result_to_web(wp, SUCCESS);

}

void zte_wlan_mac_filter_set(webs_t wp)
{
	char_t *ACL_mode = NULL;
	char_t *old_ACL_mode = NULL;
	char_t *wifi_mac_black_list = NULL;
	char_t *wifi_mac_white_list = NULL;
	char_t *old_wifi_mac_black_list = NULL;
	char_t *old_wifi_mac_white_list = NULL;
	char_t *wifi_hostname_black_list = NULL;
	char_t *wifi_hostname_white_list = NULL;
	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};
	char accesscontrollist0[720] = {0};
	zte_topsw_state_e_type nv_ret = ZTE_NVIO_DONE;
	char nv_basic[NVIO_WIFI_MAX_LEN] = {0}; // for nv read and write
	char nv_mac[720] = {0};
//cov m
#define NV_READ(nv_name, str, ret)  do{ret = zte_web_read(nv_name, nv_basic); str = nv_basic;}while(0)
#define NV_READ_MAC(nv_name, str, ret)  do{ret = zte_web_read(nv_name, nv_mac); str = nv_mac;}while(0)
	slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]wlan_mac_filter_set.\n", __FILE__, __FUNCTION__); /*lint !e26*/
	memset(nv_basic, 0, sizeof(nv_basic));
	NV_READ("ACL_mode", old_ACL_mode, nv_ret);
	ACL_mode = websGetVar(wp, T("ACL_mode"), T(""));

	slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s] ACL_mode =%s,nv_ret = %d  old_ACL_mode = %s \n", __FILE__, __FUNCTION__, ACL_mode, nv_ret, old_ACL_mode);
	if (ACL_mode != NULL) {
		if (!strcmp(ACL_mode, "2")) {
			slog(MISC_PRINT, SLOG_ERR, T("UFIx User enable black list!\n"));
		} else if (!strcmp(ACL_mode, "0")) {
			slog(MISC_PRINT, SLOG_ERR, T("UFIx User disable black list!\n"));
		}
		if (!STR_EQUAL(ACL_mode, old_ACL_mode)) { //kw 3
			wifi_set_flags |= ZTE_WLAN_ACL_SET;
			NV_WRITE("ACL_mode", ACL_mode, nv_ret);
		}

	} else {//klocwork
		slog(MISC_PRINT, SLOG_ERR,"[%s:%s]ACL_mode:no such para.", __FILE__, __FUNCTION__); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	memset(nv_mac, 0, sizeof(nv_mac));
	if (!strcmp(ACL_mode, "2")) {
		char  black_list[720] = {0};
		NV_READ_MAC("wifi_mac_black_list", old_wifi_mac_black_list, nv_ret);
		wifi_mac_black_list = websGetVar(wp, T("wifi_mac_black_list"), T(""));
		slog(MISC_PRINT, SLOG_DEBUG,"[%s] wifi_mac_black_list = %s, old_wifi_mac_black_list=%s \n", __FILE__, wifi_mac_black_list, old_wifi_mac_black_list);
		//cov m
		if ((wifi_mac_black_list != NULL) && (strlen(wifi_mac_black_list) < sizeof(black_list))) {
			str2upper(wifi_mac_black_list, black_list);
			if (!STR_EQUAL(black_list, old_wifi_mac_black_list)) { //kw 3
				wifi_set_flags |= ZTE_WLAN_ACL_SET;
				NV_WRITE("wifi_mac_black_list", black_list, nv_ret);
			}

		}
		wifi_hostname_black_list = websGetVar(wp, T("wifi_hostname_black_list"), T(""));
		if (wifi_hostname_black_list != NULL)//klocwork
			(void)zte_web_write("wifi_hostname_black_list", wifi_hostname_black_list);
	} else if (!strcmp(ACL_mode, "1")) {
		char  white_list[720] = {0};
		NV_READ_MAC("wifi_mac_white_list", old_wifi_mac_white_list, nv_ret);
		wifi_mac_white_list = websGetVar(wp, T("wifi_mac_white_list"), T(""));
		slog(MISC_PRINT, SLOG_DEBUG,"[%s] wifi_mac_white_list = %s,old_wifi_mac_white_list=%s \n", __FILE__,  wifi_mac_white_list, old_wifi_mac_white_list);
		//cov m
		if ((wifi_mac_white_list != NULL)  && (strlen(wifi_mac_white_list) < sizeof(white_list))) {
			str2upper(wifi_mac_white_list, white_list);
			if (!STR_EQUAL(white_list, old_wifi_mac_white_list)) { //kw 3
				wifi_set_flags |= ZTE_WLAN_ACL_SET;
				NV_WRITE("wifi_mac_white_list", white_list, nv_ret);
			}

		}
		wifi_hostname_white_list = websGetVar(wp, T("wifi_hostname_white_list"), T(""));
		if (wifi_hostname_white_list != NULL)//klocwork
			(void)zte_web_write("wifi_hostname_white_list", wifi_hostname_white_list);
	}
	if ('\0' == *ACL_mode) {
		slog(MISC_PRINT, SLOG_ERR,"[%s:%s]ACL_mode:invalid input para.", __FILE__, __FUNCTION__); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//(void)zte_web_write("ACL_mode",ACL_mode);
	//(void)zte_web_write("wifi_mac_black_list", wifi_mac_black_list);


/*
	if (!strcmp(ACL_mode, "2")) {
		(void)zte_web_write("wifi_hostname_black_list", wifi_hostname_black_list);
	} else if (!strcmp(ACL_mode, "1")) {
		(void)zte_web_write("wifi_hostname_white_list", wifi_hostname_white_list);
	}
*/

	slog(MISC_PRINT, SLOG_DEBUG,"[%s] wifi_mac_black_list=%s ,wifi_mac_white_list=%s, wifi_set_flags=%d\n",
	       __FILE__, wifi_mac_black_list, wifi_mac_white_list, wifi_set_flags);

	if (wifi_set_flags != 0) {
		(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
		(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_MAC,0,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_MAC, 0, NULL, 0);

		slog(MISC_PRINT, SLOG_NORMAL,"[%s:%s] MSG_CMD_WIFI_MAC  send to wlan-server!\n", __FILE__, __FUNCTION__); /*lint !e26*/
	} else {
		slog(MISC_PRINT, SLOG_NORMAL,"[%s:%s]do not deal\n", __FILE__, __FUNCTION__);
	}

	zte_write_result_to_web(wp, SUCCESS);

}

void zte_wlan_wps_mode_set(webs_t wp)

{
	slog(MISC_PRINT, SLOG_ERR, T("UFIx User set wps mode!\n"));

	char *wps_mode = NULL;
	char *WPS_SSID = NULL;
	char *wps_pin = NULL;

//    char pinIsValidate[10] = {0};
	char auth_mode[NV_ITEM_STRING_LEN_20] = {0};
	char encrypType[WF_ENCRY_TYPE_LEN] = {0};
	char wps_state[NV_ITEM_STRING_LEN_50] = {0};
	int  pin_len = 0;
	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};

	char *wifi_wps_index = NULL;
	char  wps_msg[16] = {0};

	wps_mode = websGetVar(wp, T("wps_mode"), T(""));
	WPS_SSID = websGetVar(wp, T("WPS_SSID"), T(""));
	wifi_wps_index = websGetVar(wp, T("wifi_wps_index"), T(""));

	slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s] wifi_wps_index = %s\n", __FILE__, __FUNCTION__, wifi_wps_index);

	if (('\0' == *wps_mode) || ('\0'  == *WPS_SSID)) {
		slog(MISC_PRINT, SLOG_ERR,"[%s:%s]lan_wps_set:invalid input para.\n wps_mode is [%s]\n WPS_SSID is [%s]", __FILE__, __FUNCTION__, wps_mode, WPS_SSID); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	(void) zte_web_read(NV_WIFI_WPS_STATE, wps_state);
	if (0 == strcmp(wps_state, "1")) {
		slog(MISC_PRINT, SLOG_ERR,"lan_wps_set:invalid operate, wps in processing..");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (0 == strcmp(wps_mode, WPS_MODE_PBC)) {
		(void)zte_web_write(NV_WIFI_WPS_STATE, "1");
		(void)zte_web_write(NV_WIFI_WPS_MODE, wps_mode);
		(void)zte_web_write(NV_WIFI_WPS_SSID, WPS_SSID);
	} else if (0 == strcmp(wps_mode, WPS_MODE_PIN)) {
		wps_pin = websGetVar(wp, T("wps_pin"), T(""));
		//add by liuyingnan for server safe for xss attack start
		if (DATA_NO_SAFE == zte_Safe_noSpecialChar(wps_pin)) {
			slog(MISC_PRINT, SLOG_ERR,"[%s:%s]Get Data is no Safe:wps_pin:%s\n", __FILE__, __FUNCTION__, wps_pin); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}

		//printf(" ---- wlan_wps_mode_set len is %s\n", wps_pin);
		if (wps_pin == NULL) {
			zte_write_result_to_web(wp, FAILURE);
			return;
		}

		pin_len = strlen(wps_pin);
		if ((pin_len == 0) || ((pin_len != 4) && (pin_len != 8))) {
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
		int wps_pin_num = atoi(wps_pin);
		if(wps_pin_num<0 || wps_pin_num> INT_MAX-1)
		{
			wps_pin_num = 0;
		}
		if ((pin_len == 8) && !validate_pin_code(wps_pin_num)) {
			zte_write_result_to_web(wp, FAILURE);
			slog(MISC_PRINT, SLOG_ERR,"%s PIN check failed\n", __FUNCTION__);
			return;
		}


		//add by liuyingnan for server safe for xss attack end
		(void)zte_web_write(NV_WIFI_WPS_STATE, "1");
		(void)zte_web_write(NV_WIFI_WPS_MODE, wps_mode);
		(void)zte_web_write(NV_WIFI_WPS_SSID, WPS_SSID);
		(void)zte_web_write(NV_WIFI_WPS_PIN, wps_pin);
	} else {
		slog(MISC_PRINT, SLOG_ERR,"[%s][%s]invalid wps_mode[%s].", __FILE__, __FUNCTION__, wps_mode); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	wifi_set_flags |= ZTE_WLAN_WPS_SET;

	//last, write the wifi_set_flags
	(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);

	slog(MISC_PRINT, SLOG_NORMAL,"[%s][%s] send to wlan-server wps cmd\n", __FILE__, __FUNCTION__);


	if (wifi_wps_index != NULL) {
		zte_web_write(NV_WIFI_WPS_INDEX, wifi_wps_index);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s] wifi_wps_index = %s\n", __FILE__, __FUNCTION__, wifi_wps_index);
	}

	//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_WPS,0,NULL);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_WPS, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wifi set cmd done!", __FILE__, __FUNCTION__); /*lint !e26*/
	zte_write_result_to_web(wp, SUCCESS);
}



void zte_wlan_web_ssid1_set(webs_t wp)
{
	slog(MISC_PRINT, SLOG_DEBUG, T("UFIx User set WIFI SSID settings!\n"));

	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};
	zte_topsw_state_e_type ret = ZTE_NVIO_DONE;

	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, "");

	slog(MISC_PRINT, SLOG_DEBUG,"wlan_web_ssid1_set:+++++++++++++++++======\n");
	if (FALSE == zte_wlan_ssid1_basic_set(wp, &wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"wlan_web_ssid1_set: wlan_ssid1_basic_set failure .\n");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (-1 == zte_lan_ssid1_security_set(wp, &wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"call lan_ssid1_security_set failure .\n");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);
	slog(MISC_PRINT, SLOG_DEBUG,"wlan_web_ssid1_set: wifi_set_flags [%u] to [%s].\n", wifi_set_flags, wifi_set_flags_str); /*lint !e26*/

	if (0 != wifi_set_flags) {
		slog(MISC_PRINT, SLOG_NORMAL,"send wifi para to wlan-server@ssid1\n");/*lint !e26*/
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_SSID,NULL,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_CFG_AP, 0, NULL, 0);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wifi set cmd done!", __FILE__, __FUNCTION__); /*lint !e26*/
	}
	zte_write_result_to_web(wp, SUCCESS);

}



void zte_wlan_ssid2_set(webs_t wp)
{

	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};
	zte_topsw_state_e_type ret = ZTE_NVIO_DONE;

	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, "");

	if (FALSE == zte_wlan_ssid2_basic_set(wp, &wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"wlan_ssid2_set: wlan_ssid2_basic_set failure .");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (-1 == zte_lan_ssid2_security_set(wp, &wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"call lan_ssid2_security_set fail.\n .");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);
	slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid2_set: wifi_set_flags [%u] to [%s].", wifi_set_flags, wifi_set_flags_str);

	if (0 != wifi_set_flags) {
		slog(MISC_PRINT, SLOG_NORMAL,"send wifi para to wlan-server@ssid2");/*lint !e26*/
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_SSID_M,NULL,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_CFG_AP2, 0, NULL, 0);
		slog(MISC_PRINT, SLOG_DEBUG,"wifi set cmd done!");        /*lint !e26*/
	}
	zte_write_result_to_web(wp, SUCCESS);

}



/**********************************************************************
* Function:        zte_wlan_sleep_set
* Description:     to set the wifi sleep mode
* Input:           http info
* Output:
* Return:           0:ok;-1:fail
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/07/11    V1.0        zhouti       first version
**********************************************************************/
void zte_wlan_sleep_set(webs_t wp)
{
	char_t *sleepMode = NULL;
	//char_t *wifi_mac_black_list = NULL;
	//char_t *wifi_hostname_black_list = NULL;
	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};

	slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wlan_sleep_set.", __FILE__, __FUNCTION__); /*lint !e26*/
	//printf("zhouti wlan_sleep_set------------------------\n");
	sleepMode = websGetVar(wp, T("sysIdleTimeToSleep"), T(""));

	if (NULL == sleepMode || '\0' == *sleepMode) {
		slog(MISC_PRINT, SLOG_ERR,"sleepMode:invalid input para.");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//printf("zhouti wlan_sleep_set sleepMode is %s\n", sleepMode);
	(void)zte_web_write("Sleep_interval", sleepMode);
	// (void)zte_web_write("wifi_mac_black_list", wifi_mac_black_list);
	// (void)zte_web_write("wifi_hostname_black_list", wifi_hostname_black_list);


	wifi_set_flags |= ZTE_WLAN_SET_AP_SLEEPTIMER;

	(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
	(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);

	slog(MISC_PRINT, SLOG_NORMAL,"send wifi para to wlan-mac_filter_set@basic_set");/*lint !e26*/
	//zte_send_message(MODULE_ID_WIFI, MSG_CMD_WIFI_SLEEP, 0, NULL);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_SLEEP, 0, NULL, 0);
	//printf("wifi set cmd done!");/*lint !e26*/

	zte_write_result_to_web(wp, SUCCESS);
}

static int check_web_input_wifi(char *str, int len)
{
	int i = 0;
	if (str == NULL || len <= 0 || strlen(str) < len) {
		return 0;
	}
	for (i = 0; i < len; i++) {
		if (strchr("`$&*\\[];:\'\"<>,",str[i]) || !isprint(str[i])) {
			return 0;
		}
	}
	return 1;
}

/**********************************************************************
* Function:        zte_wlan_coverage_set
* Description:     to set the wifi coverage
* Input:           http info
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2014/05/27    V1.0        zhouti       first version
**********************************************************************/
void zte_wlan_coverage_set(webs_t wp)
{
	char_t *wifi_coverage = NULL;
	char_t old_wifi_coverage[WIFI_COVERAGE_LEN + 1] = {0};
	unsigned int wifi_set_flags = 0;
	char wifi_set_flags_str[NV_ITEM_STRING_LEN_20] = {0};
	slog(MISC_PRINT, SLOG_DEBUG,"wlan_coverage_set.");
	//printf("zhouti wlan_coverage_set------------------------\n");
	wifi_coverage = websGetVar(wp, T(NV_WIFI_COVERAGE), T(""));

	if (NULL == wifi_coverage || '\0' == *wifi_coverage) {
		slog(MISC_PRINT, SLOG_ERR,"[%s][%s]coverage: invalid input para.", __FILE__, __FUNCTION__);
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	(void)zte_web_read(NV_WIFI_COVERAGE, old_wifi_coverage);
	if (strcmp(wifi_coverage, old_wifi_coverage)) { //kw 3
		(void)zte_web_write(NV_WIFI_COVERAGE, wifi_coverage);

		wifi_set_flags |= ZTE_WLAN_POWER_SET;

		(void)snprintf(wifi_set_flags_str, sizeof(wifi_set_flags_str) - 1, "%u", wifi_set_flags);
		(void)zte_web_write(WIFI_NV_ITEM_WIFI_SET_FLAGS, wifi_set_flags_str);

		slog(MISC_PRINT, SLOG_NORMAL,"send wifi para to wlan-mac_filter_set@basic_set");/*lint !e26*/
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_COVERAGE,0,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_COVERAGE, 0, NULL, 0);
		//printf("wifi set cmd done!");/*lint !e26*/
	}
	zte_write_result_to_web(wp, SUCCESS);
}

static int zte_wlan_ssid1_basic_set(webs_t wp, unsigned int *wifi_set_flags)
{

	char_t  *ssid = NULL;
	char_t  *broadcastssid = NULL ;
	char_t  *NoForwarding = NULL ;
	char_t *MAX_Access_num = NULL;
	zte_topsw_state_e_type status = ZTE_NVIO_MAX;
	char nv_tmp[NVIO_WIFI_MAX_LEN] = {0};
	char_t  *wirelessmode = NULL;
	char_t  *countrycode = NULL;
	char_t  *channel = NULL;
	char_t *wifi_11n_cap = NULL;
	char_t  *wifi_band = NULL;
	char_t  *show_qrcode_flag = NULL;//main ssid show qrcode flag

	char wifi_sta_connection[8] = {0};

	sc_cfg_get("wifi_sta_connection", wifi_sta_connection, sizeof(wifi_sta_connection));
	slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wifi_sta_connection=%s\n", __FILE__, __FUNCTION__, wifi_sta_connection);

	//ssid
	memset(nv_tmp, 0, sizeof(nv_tmp));
	ssid = websGetVar(wp, T("ssid"), NULL);
#ifdef WEBS_SECURITY
		if(ssid && !check_web_input_wifi(ssid,strlen(ssid)))
		{
			slog(MISC_PRINT, SLOG_ERR,"[goahead]ssid1=%s\n",ssid);
			return FALSE;
		}
#endif
	if (ssid != NULL  && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("SSID1", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]old_ssid=[%s], ssid=[%s]", __FILE__, __FUNCTION__, nv_tmp, ssid); /*lint !e26*/
		//add by liuyingnan for server safe for xss attack start
#if 0 //kw 3
		if (DATA_NO_SAFE == zte_Safe_noSpecialCharForSSID(ssid)) {
			slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]Get Data is no Safe:ssid:%s\n", __FILE__, __FUNCTION__, ssid); /*lint !e26*/
			return FALSE;
		}
#endif
		//add by liuyingnan for server safe for xss attack end
		if (0 != strcmp(ssid, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_SSID_SET;
			status = zte_web_write("SSID1", ssid);
			wlan_set_change_ssid_key_status();
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]wlan_ssid1_basic_set: write nv [SSID1] fail.", __FILE__, __FUNCTION__); /*lint !e26*/
				return FALSE;
			}
		}
	}

	//broadcastSsidEnabled
	memset(nv_tmp, 0, sizeof(nv_tmp));
	broadcastssid = websGetVar(wp, T("broadcastSsidEnabled"), NULL);

	if (broadcastssid != NULL   && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("HideSSID", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_HideSSID=[%s], HideSSID=[%s]", nv_tmp, broadcastssid);  /*lint !e26*/
		if (0 != strcmp(broadcastssid, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_BROADCAST_SET;
			status = zte_web_write("HideSSID", broadcastssid);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid1_basic_set: write nv [HideSSID] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

#if 0
	//set  NoForwarding(ap isolated)
	memset(nv_tmp, 0, sizeof(nv_tmp));
	NoForwarding = websGetVar(wp, T("NoForwarding"), NULL);
	if (NoForwarding != NULL   && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("NoForwarding", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_NoForwarding=[%s], NoForwarding=[%s]", nv_tmp, NoForwarding);/*lint !e26*/
		if (0 != strcmp(NoForwarding, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_AP_ISOLATION_SET;
			status = zte_web_write("NoForwarding", NoForwarding);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid1_basic_set: write nv [NoForwarding] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}
#endif
	//set  MAX_Access_num
	memset(nv_tmp, 0, sizeof(nv_tmp));
	MAX_Access_num = websGetVar(wp, T("MAX_Access_num"), NULL);
	if (MAX_Access_num != NULL   && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("MAX_Access_num", nv_tmp);

		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]old_MAX_Access_num=[%s], MAX_Access_num=[%s]\n", __FILE__, __FUNCTION__, nv_tmp, MAX_Access_num);

		if (0 != strcmp(MAX_Access_num, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_MAX_ACCESS_NUM_SET;
			zte_web_write("MAX_Access_num", MAX_Access_num); //kw 3		
			zte_web_write("MAX_Access_num_user_set", "1");
		}
	}
	//set  show_qrcode_flag
	memset(nv_tmp, 0, sizeof(nv_tmp));
	show_qrcode_flag = websGetVar(wp, T("show_qrcode_flag"), NULL);
	if (show_qrcode_flag != NULL) {
		(void)zte_web_read("show_qrcode_flag", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]ssid1:old_show_qrcode_flag=[%s], show_qrcode_flag=[%s]\n", __FILE__, __FUNCTION__, nv_tmp, show_qrcode_flag);

		if (0 != strcmp(show_qrcode_flag, nv_tmp)) {
			status = zte_web_write("show_qrcode_flag", show_qrcode_flag);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid1_basic_set: write nv [show_qrcode_flag] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}



#if 0
	//wifiMode
	memset(nv_tmp, 0, sizeof(nv_tmp));
	wirelessmode = websGetVar(wp, T("wifiMode"), NULL);
	if (wirelessmode != NULL && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		printf("wirelessmode:%s", wirelessmode);    /*lint !e26*/
		(void)zte_web_read("WirelessMode", nv_tmp);
		printf("[%s][%s]old_WirelessMode=[%s], wirelessmode=[%s]", __FILE__, __FUNCTION__, nv_tmp, wirelessmode); /*lint !e26*/
		if (0 != strcmp(wirelessmode, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_WIRELESS_MODE_SET;
			status = zte_web_write("WirelessMode", wirelessmode);
			if (ZTE_NVIO_DONE != status) {
				printf("wlan_ssid1_basic_set: write nv [WirelessMode] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	/* country code*/
	memset(nv_tmp, 0, sizeof(nv_tmp));
	countrycode = websGetVar(wp, T("countryCode"), NULL);
	if (countrycode != NULL && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("CountryCode", nv_tmp);
		printf("[%s][%s]old_countrycode=%s, countrycode = %s", __FILE__, __FUNCTION__, nv_tmp, countrycode); /*lint !e26*/
		if (0 != strcmp(countrycode, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_COUNTRY_SET;
			status = zte_web_write("CountryCode", countrycode);
			if (ZTE_NVIO_DONE != status) {
				printf("[%s][%s]wlan_ssid1_basic_set: write nv [CountryCode] fail.", __FILE__, __FUNCTION__); /*lint !e26*/
				return FALSE;
			}
		}
	}

	//selectedChannel
	memset(nv_tmp, 0, sizeof(nv_tmp));
	channel = websGetVar(wp, T("selectedChannel"), NULL);
	if (channel != NULL && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("Channel", nv_tmp);
		printf("[%s][%s]old_channel=%s, channel = %s", __FILE__, __FUNCTION__, nv_tmp, channel); /*lint !e26*/
		if (0 != strcmp(channel, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_CHANNEL_SET;
			status = zte_web_write("Channel", channel);
			if (ZTE_NVIO_DONE != status) {
				printf("wlan_ssid1_basic_set: write nv [Channel] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	//band setting
	memset(nv_tmp, 0, sizeof(nv_tmp));
	wifi_band = websGetVar(wp, T("wifi_band"), NULL);
	if (wifi_band != NULL && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("wifi_band", nv_tmp);
		printf("[%s][%s]old_wifi_band=%s, wifi_band = %s", __FILE__, __FUNCTION__, nv_tmp, wifi_band); /*lint !e26*/
		if (0 != strcmp(wifi_band, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_WIFI_BAND_SET;
			status = zte_web_write("wifi_band", channel);
			if (ZTE_NVIO_DONE != status) {
				printf("wlan_ssid1_basic_set: write nv [wifi_band] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	//set  wifi_11n_cap
	memset(nv_tmp, 0, sizeof(nv_tmp));
	wifi_11n_cap = websGetVar(wp, T("wifi_11n_cap"), NULL);
	if (wifi_11n_cap != NULL && !(wp->flags & WEBS_XML_CLIENT_REQUEST)) {
		(void)zte_web_read("wifi_11n_cap", nv_tmp);
		printf("[%s][%s]old_wifi_11n_cap=%s, wifi_11n_cap=%s", __FILE__, __FUNCTION__, nv_tmp, wifi_11n_cap); /*lint !e26*/
		if (0 != strcmp(wifi_11n_cap, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_WIRELESS_MODE_SET;
			status = zte_web_write("wifi_11n_cap", wifi_11n_cap);
			if (ZTE_NVIO_DONE != status) {
				printf("wlan_ssid1_basic_set: write nv [wifi_11n_cap] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}
#endif
	slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid1_basic_set:  wifi basic setup success.");/*lint !e26*/
	return TRUE;

}

static int zte_wlan_ssid2_basic_set(webs_t wp, unsigned int *wifi_set_flags)
{
	char_t  *ssid = NULL;
	char_t  *broadcastssid = NULL ;
	char_t  *NoForwarding = NULL ;
	char_t *MAX_Access_num = NULL;
	char_t  *show_qrcode_flag = NULL;//guest ssid show qrcode flag
	zte_topsw_state_e_type status = ZTE_NVIO_MAX;
	char nv_tmp[NVIO_WIFI_MAX_LEN] = {0};

	if ((NULL == wp) || (NULL == wifi_set_flags)) {
		return FALSE;
	}

	//ssid
	memset(nv_tmp, 0, sizeof(nv_tmp));
	ssid = websGetVar(wp, T("m_SSID"), NULL);
#ifdef WEBS_SECURITY
		if(ssid && !check_web_input_wifi(ssid,strlen(ssid)))
		{
			slog(MISC_PRINT, SLOG_ERR,"[goahead]ssid2=%s\n",ssid);
			return FALSE;
		}
#endif
	if (ssid != NULL) {
		//add by liuyingnan for server safe for xss attack start
		if (DATA_NO_SAFE == zte_Safe_noSpecialChar(ssid)) {
			slog(MISC_PRINT, SLOG_DEBUG,"Get Data is no Safe:ssid:%s\n", ssid); /*lint !e26*/
			return FALSE;
		}
		//add by liuyingnan for server safe for xss attack end
		(void)zte_web_read("m_SSID", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_m_SSID=[%s], m_SSID=[%s]", nv_tmp, ssid);    /*lint !e26*/
		if (0 != strcmp(ssid, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
			status = zte_web_write("m_SSID", ssid);
			wlan_set_change_ssid_key_status();//added by dujiajiao
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_ERR,"wlan_ssid2_basic_set: write nv [m_SSID] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	//broadcastSsidEnabled
	memset(nv_tmp, 0, sizeof(nv_tmp));
	broadcastssid = websGetVar(wp, T("m_HideSSID"), NULL);
	if (broadcastssid != NULL) {
		(void)zte_web_read("m_HideSSID", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_m_HideSSID=[%s], m_HideSSID=[%s]", nv_tmp, broadcastssid);   /*lint !e26*/
		if (0 != strcmp(broadcastssid, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
			status = zte_web_write("m_HideSSID", broadcastssid);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_ERR,"wlan_ssid2_basic_set: write nv [m_HideSSID] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}


	//set  NoForwarding
	memset(nv_tmp, 0, sizeof(nv_tmp));
	NoForwarding = websGetVar(wp, T("m_NoForwarding"), NULL);
	if (NoForwarding != NULL) {
		(void)zte_web_read("m_NoForwarding", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_m_NoForwarding=[%s], m_NoForwarding=[%s]", nv_tmp, NoForwarding);/*lint !e26*/
		if (0 != strcmp(NoForwarding, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
			status = zte_web_write("m_NoForwarding", NoForwarding);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_ERR,"wlan_ssid1_basic_set: write nv [m_NoForwarding] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	//set  MAX_Access_num
	memset(nv_tmp, 0, sizeof(nv_tmp));
	MAX_Access_num = websGetVar(wp, T("m_MAX_Access_num"), NULL);
	if (MAX_Access_num != NULL) {
		(void)zte_web_read("m_MAX_Access_num", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"old_m_MAX_Access_num=[%s], m_MAX_Access_num=[%s]", nv_tmp, MAX_Access_num);/*lint !e26*/
		if (0 != strcmp(MAX_Access_num, nv_tmp)) {
			*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
			status = zte_web_write("m_MAX_Access_num", MAX_Access_num);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_ERR,"wlan_ssid2_basic_set: write nv [MAX_Access_num] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}

	//set  show_qrcode_flag
	memset(nv_tmp, 0, sizeof(nv_tmp));
	show_qrcode_flag = websGetVar(wp, T("m_show_qrcode_flag"), NULL);
	if (show_qrcode_flag != NULL) {
		(void)zte_web_read("m_show_qrcode_flag", nv_tmp);
		slog(MISC_PRINT, SLOG_DEBUG,"ssid2: old_show_qrcode_flag=[%s], show_qrcode_flag=[%s]", nv_tmp, show_qrcode_flag);/*lint !e26*/
		if (0 != strcmp(show_qrcode_flag, nv_tmp)) {
			status = zte_web_write("m_show_qrcode_flag", show_qrcode_flag);
			if (ZTE_NVIO_DONE != status) {
				slog(MISC_PRINT, SLOG_ERR,"wlan_ssid2_basic_set: write nv [show_qrcode_flag] fail.");/*lint !e26*/
				return FALSE;
			}
		}
	}



	slog(MISC_PRINT, SLOG_DEBUG,"wlan_ssid2_basic_set:  wifi basic setup success.");/*lint !e26*/
	return TRUE;

}

static int zte_lan_ssid1_security_set(webs_t wp, unsigned int *wifi_set_flags)
{
#define KEY_INDEX_MAX 5

	char_t *security_mode = NULL;
	char *encryp_type = NULL;
	int i = 0;
	char_t *pass_phrase_str = NULL;
	//add by liuyingnan for Server safe start
	int pass_phrase_str_decode_length = 0;
	char_t *pass_phrase_str_decode = NULL;
#ifdef WEBS_SECURITY
	char_t *pass_phrase_b64_encode = NULL;
#endif
	char_t zte_pass_phrase_str[WIFI_PSW_DEFAULT_LENGTH] = {0};
	int zte_pass_phrase_len = 0;
	//add by liuyingnan for Server safe end

	char_t *DefaultKeyID = NULL;
	char_t * KeyType[KEY_INDEX_MAX];
	char_t * KeyStr[KEY_INDEX_MAX];

	char_t *cipher_str = NULL;
	char_t wpa_encry_type[WF_ENCRY_TYPE_LEN] = {0};

	zte_topsw_state_e_type nv_ret = ZTE_NVIO_DONE;    /*lint -e550*/

	uint8 nv_au_mode[WF_AU_MODE_LEN] = {0};
	uint8 nv_ecry_type[WF_ENCRY_TYPE_LEN] = {0};
	char_t  psw[NV_ITEM_VALUE_DEFAULT_STRING_LEN] = {0};
	//char nv_basic[NVIO_WIFI_MAX_LEN]={0}; // for nv read and write

	/*lint -e717*/
#define SECURITY_NV_WRITE(nv_name, str, ret)  do{ ret = zte_web_write(nv_name, (char *)str);}while(0)

	memset(KeyType, 0, sizeof(KeyType)); //set 0
	memset(KeyStr, 0, sizeof(KeyStr));     //set 0

	if ((NULL == wp) || (NULL == wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"[%s][%s]input para is null.\n", __FILE__, __FUNCTION__); /*lint !e26*/
		return -1;
	}

	security_mode = websGetVar(wp, T("security_mode"), NULL);
	if (security_mode != NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]security_mode = [%s]", __FILE__, __FUNCTION__, security_mode); /*lint !e26*/

		encryp_type = websGetVar(wp, T("security_shared_mode"), NULL);
		if (NULL == encryp_type) {
			slog(MISC_PRINT, SLOG_ERR,"encryp_type == NULL");/*lint !e26*/
			return -1;
		}

		slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]encryp_type = [%s]", __FILE__, __FUNCTION__, encryp_type); /*lint !e26*/

		if (STR_EQUAL(security_mode, WF_AU_OPEN)  || STR_EQUAL(security_mode, WF_AU_SHARE)) {
			if ((STR_EQUAL(security_mode, WF_AU_OPEN) && STR_EQUAL(encryp_type, WF_ENCRY_WEP)) ||
			    (STR_EQUAL(security_mode, WF_AU_SHARE))) { //&&STR_EQUAL(wifi_encry_type, WF_AU_OPEN)) )
				zte_wifi_open_and_share_mode_s_type nv_open_and_share_s;
				memset(&nv_open_and_share_s, 0, sizeof(zte_wifi_open_and_share_mode_s_type));

				//read nv
				(void)zte_web_read("AuthMode", nv_au_mode);
				(void)zte_web_read("EncrypType", nv_ecry_type);
				(void)zte_web_read("DefaultKeyID", nv_open_and_share_s.wep_key_index);
				(void)zte_web_read("Key1Str1", nv_open_and_share_s.wep_key1);
				(void)zte_web_read("Key2Str1", nv_open_and_share_s.wep_key2);
				(void)zte_web_read("Key3Str1", nv_open_and_share_s.wep_key3);
				(void)zte_web_read("Key4Str1", nv_open_and_share_s.wep_key4);
				(void)zte_web_read("Key1Type", nv_open_and_share_s.wep_key1_mode);
				(void)zte_web_read("Key2Type", nv_open_and_share_s.wep_key2_mode);
				(void)zte_web_read("Key3Type", nv_open_and_share_s.wep_key3_mode);
				(void)zte_web_read("Key4Type", nv_open_and_share_s.wep_key4_mode);

				DefaultKeyID = websGetVar(wp, T("wep_default_key"), "");
				KeyStr[1] = websGetVar(wp, T("wep_key_1"), "");
				KeyStr[2] = websGetVar(wp, T("wep_key_2"), "");
				KeyStr[3] = websGetVar(wp, T("wep_key_3"), "");
				KeyStr[4] = websGetVar(wp, T("wep_key_4"), "");
				KeyType[1] = websGetVar(wp, T("WEP1Select"), "");
				KeyType[2] = websGetVar(wp, T("WEP2Select"), "");
				KeyType[3] = websGetVar(wp, T("WEP3Select"), "");
				KeyType[4] = websGetVar(wp, T("WEP4Select"), "");

				//when the wifi setting has changed,then set them
				if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(encryp_type, nv_ecry_type) \
				    && STR_EQUAL(DefaultKeyID, nv_open_and_share_s.wep_key_index) \
				    && STR_EQUAL(KeyStr[1], nv_open_and_share_s.wep_key1) && STR_EQUAL(KeyStr[2], nv_open_and_share_s.wep_key2) && STR_EQUAL(KeyStr[3], nv_open_and_share_s.wep_key3) && STR_EQUAL(KeyStr[4], nv_open_and_share_s.wep_key4) \
				    && STR_EQUAL(KeyType[1], nv_open_and_share_s.wep_key1_mode) && STR_EQUAL(KeyType[2], nv_open_and_share_s.wep_key2_mode) && STR_EQUAL(KeyType[3], nv_open_and_share_s.wep_key3_mode) && STR_EQUAL(KeyType[4], nv_open_and_share_s.wep_key4_mode)) {

					slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wifi:[%s][%s] not changed.\n", __FILE__, __FUNCTION__, security_mode, encryp_type); /*lint !e26*/
				} else {
					SECURITY_NV_WRITE("AuthMode", security_mode, nv_ret);
					SECURITY_NV_WRITE("EncrypType", encryp_type, nv_ret);

					SECURITY_NV_WRITE("DefaultKeyID", DefaultKeyID, nv_ret);

					SECURITY_NV_WRITE("Key1Str1", KeyStr[1], nv_ret);
					SECURITY_NV_WRITE("Key2Str1", KeyStr[2], nv_ret);
					SECURITY_NV_WRITE("Key3Str1", KeyStr[3], nv_ret);
					SECURITY_NV_WRITE("Key4Str1", KeyStr[4], nv_ret);

					SECURITY_NV_WRITE("Key1Type", KeyType[1], nv_ret);
					SECURITY_NV_WRITE("Key2Type", KeyType[2], nv_ret);
					SECURITY_NV_WRITE("Key3Type", KeyType[3], nv_ret);
					SECURITY_NV_WRITE("Key4Type", KeyType[4], nv_ret);

					*wifi_set_flags |= ZTE_WLAN_BASIC_SECURITY_SET;
					wlan_set_change_ssid_key_status();
				}
			} else if (STR_EQUAL(security_mode, WF_AU_OPEN) && STR_EQUAL(encryp_type, WF_ENCRY_NONE)) {
				(void)zte_web_read("AuthMode",nv_au_mode);
				(void)zte_web_read("EncrypType", nv_ecry_type);

				if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(encryp_type, nv_ecry_type)) {
					printf("[%s][%s]wifi:[%s][%s] not changed.\n", __FILE__, __FUNCTION__, security_mode, encryp_type); /*lint !e26*/
				} else {
					SECURITY_NV_WRITE("AuthMode", security_mode, nv_ret);
					SECURITY_NV_WRITE("EncrypType", encryp_type, nv_ret);
					SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_ENCODE, "", nv_ret);
					SECURITY_NV_WRITE(NV_WIFI_WPA_PASS, "", nv_ret);
					SECURITY_NV_WRITE("Key1Str1", "", nv_ret);
					SECURITY_NV_WRITE("Key2Str1", "", nv_ret);
					SECURITY_NV_WRITE("Key3Str1", "", nv_ret);
					SECURITY_NV_WRITE("Key4Str1", "", nv_ret);
					*wifi_set_flags |= ZTE_WLAN_BASIC_SECURITY_SET;
					wlan_set_change_ssid_key_status();
				}
			} else {
				//wifi_au_mode or encrype invalid
				slog(MISC_PRINT, SLOG_ERR,"[%s][%s]wifi:[%s][%s] is invalid.\n", __FILE__, __FUNCTION__, security_mode, encryp_type); /*lint !e26*/
				return -1;
			}
		} else if (STR_EQUAL(security_mode, WF_AU_WPA)  || STR_EQUAL(security_mode, WF_AU_WPA2) ||
		           STR_EQUAL(security_mode, WF_AU_WPA_WPA2) || STR_EQUAL(security_mode, WF_AU_WPA3) || STR_EQUAL(security_mode, WF_AU_WPA2_WPA3)) {
			zte_wifi_wpa_and_wpa2_mode_s_type nv_wpa_and_wpa2;
			memset(&nv_wpa_and_wpa2, 0, sizeof(zte_wifi_wpa_and_wpa2_mode_s_type));

			pass_phrase_str = websGetVar(wp, T("passphrase"), "");
			int j = 0;
			for (i = 0; i < strlen(pass_phrase_str) && j < NV_ITEM_VALUE_DEFAULT_STRING_LEN; i++) {
				if (pass_phrase_str[i] != '\r' && pass_phrase_str[i] != '\n') {
					psw[j] = pass_phrase_str[i];
					j++;
				}
			}
			pass_phrase_str = psw;
			if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
				cipher_str = websGetVar(wp, T("cipher"), "");
			} else {
#ifndef CONFIG_CHINA_UNICOM
				if (STR_EQUAL(security_mode, WF_AU_WPA_WPA2)) {
					cipher_str = websGetVar(wp, T("cipher_str"), "");
				} else
#endif
				{
					cipher_str = websGetVar(wp, T("cipher"), "");
				}
			}
			slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]pass_phrase_str = %s", __FILE__, __FUNCTION__, pass_phrase_str); /*lint !e26*/
			slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]cipher_str = %s", __FILE__, __FUNCTION__, cipher_str); /*lint !e26*/
			//add by liuyingnan for server safe for xss attack start
			if (DATA_NO_SAFE == zte_Safe_noSpecialChar(pass_phrase_str)) {
				slog(MISC_PRINT, SLOG_ERR,"Get Data is no Safe:ssid:%s\n", pass_phrase_str); /*lint !e26*/
				return -1;
			}
			//add by liuyingnan for server safe for xss attack end

			switch (cipher_str[0]) {
			case '0':
				strncpy(wpa_encry_type, WF_ENCRY_TKIP, sizeof(wpa_encry_type) - 1);
				break;
			case '1':
				strncpy(wpa_encry_type, WF_ENCRY_AES, sizeof(wpa_encry_type) - 1);
				break;
			case '2':
				strncpy(wpa_encry_type, WF_ENCRY_TKIP_AES, sizeof(wpa_encry_type) - 1);
				break;
			default:
				slog(MISC_PRINT, SLOG_ERR,"unvalid encry type [%c]", encryp_type[0], 0, 0);
				return -1;
			}

			(void)zte_web_read("AuthMode", nv_au_mode);
			(void)zte_web_read("EncrypType", nv_ecry_type);
			(void)zte_web_read(NV_WIFI_WPA_PASS, nv_wpa_and_wpa2.pre_share_key);

			if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(wpa_encry_type, nv_ecry_type) && STR_EQUAL(pass_phrase_str, nv_wpa_and_wpa2.pre_share_key)) {

				slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]wifi:[%s][%s] not changed.\n", __FILE__, __FUNCTION__, security_mode, wpa_encry_type); /*lint !e26*/
			} else {
				SECURITY_NV_WRITE("AuthMode", security_mode, nv_ret);
				SECURITY_NV_WRITE("EncrypType", wpa_encry_type, nv_ret);
#ifndef CONFIG_CHINA_UNICOM
				if (STR_EQUAL(security_mode, WF_AU_WPA_WPA2)) {
#endif
					SECURITY_NV_WRITE("cipher_str", cipher_str, nv_ret);
#ifndef CONFIG_CHINA_UNICOM
				}
#endif
				//add by liuyingnan for Server safe start
				slog(MISC_PRINT, SLOG_DEBUG,"[%s][%s]pass_phrase_str:%s.\n", __FILE__, __FUNCTION__, pass_phrase_str); /*lint !e26*/
#ifdef WEBS_SECURITY
				pass_phrase_str_decode = js_aes_decode(pass_phrase_str, strlen(pass_phrase_str), (unsigned int*)&pass_phrase_str_decode_length);
#else
				pass_phrase_str_decode = (char*)zte_base64_decode((const unsigned char *)pass_phrase_str, strlen(pass_phrase_str), (unsigned int*)&pass_phrase_str_decode_length);
#endif
				
				if (NULL == pass_phrase_str_decode) {
					slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_str_decode: psw is empty.\n");/*lint !e26*/
					free(pass_phrase_str_decode);
					return -1;
				}
				zte_pass_phrase_len = (pass_phrase_str_decode_length < sizeof(zte_pass_phrase_str) ? pass_phrase_str_decode_length : sizeof(zte_pass_phrase_str) - 1);
				snprintf(zte_pass_phrase_str,zte_pass_phrase_len+1,"%s",pass_phrase_str_decode);
				//strncpy(zte_pass_phrase_str, pass_phrase_str_decode, zte_pass_phrase_len);
				free(pass_phrase_str_decode);
				slog(MISC_PRINT, SLOG_DEBUG,"login3 -> psw_admin:%s.\n", zte_pass_phrase_str); //cov m
#ifdef WEBS_SECURITY
				if(zte_pass_phrase_str && !check_web_input_wifi(zte_pass_phrase_str,strlen(zte_pass_phrase_str)))
				{
					slog(MISC_PRINT, SLOG_ERR,"[goahead]wifipass1=%s\n",zte_pass_phrase_str);
					return -1;
				}
				pass_phrase_b64_encode = zte_base64_encode(zte_pass_phrase_str, strlen(zte_pass_phrase_str));
				if (NULL == pass_phrase_b64_encode) {
					slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_b64_encode: psw is NULL.\n");/*lint !e26*/
					return -1;
				}
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_ENCODE, pass_phrase_b64_encode, nv_ret);
				free(pass_phrase_b64_encode);
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS, zte_pass_phrase_str, nv_ret);
				SECURITY_NV_WRITE("WPAPSK1_enaes", pass_phrase_str, nv_ret);
#else
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_ENCODE, pass_phrase_str, nv_ret);
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS, zte_pass_phrase_str, nv_ret);
#endif
				//add by liuyingnan for Server safe end
				//SECURITY_NV_WRITE(NV_WIFI_WPA_PASS, pass_phrase_str, nv_ret);

				*wifi_set_flags |= ZTE_WLAN_BASIC_SECURITY_SET;
				wlan_set_change_ssid_key_status();
			}
		} else {
			// other security mode is invalid
			slog(MISC_PRINT, SLOG_ERR,"ERROR:security mode  is invalid", 0, 0, 0);/*lint !e26*/
			return -1;
		}
	} else {
		//security_mode is NULL
		slog(MISC_PRINT, SLOG_ERR,"ERROR:security_mode is NULL ", 0, 0, 0);/*lint !e26*/
		return -1;
	}

	return 0;

}

/**********************************************************************
* Function:         zte_lan_ssid2_security_set
* Description:     to set the wifi security paras for SSID2
* Input:           http info
* Output:
* Return:           0:ok;-1:fail
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/07/11    V1.0        chenyi       first version
**********************************************************************/
/*lint -e{818,830}*/
static int zte_lan_ssid2_security_set(webs_t wp, unsigned int *wifi_set_flags) /*lint !e533*/
{
#define KEY_INDEX_MAX 5

	char_t *security_mode = NULL;
	char *encryp_type = NULL;

	char_t *pass_phrase_str = NULL;
	//add by liuyingnan for Server safe start
	int pass_phrase_str_decode_length = 0;
	char_t *pass_phrase_str_decode = NULL;
#ifdef WEBS_SECURITY
	char_t *pass_phrase_b64_encode = NULL;
#endif
	char_t zte_pass_phrase_str[WIFI_PSW_DEFAULT_LENGTH] = {0};
	int zte_pass_phrase_len = 0;
	//add by liuyingnan for Server safe end

	char_t *DefaultKeyID = NULL;
	char_t * KeyType[KEY_INDEX_MAX];
	char_t * KeyStr[KEY_INDEX_MAX];

	char_t *cipher_str = NULL;
	char_t wpa_encry_type[WF_ENCRY_TYPE_LEN] = {0};

	zte_topsw_state_e_type nv_ret = ZTE_NVIO_DONE;    /*lint -e550*/

	uint8 nv_au_mode[WF_AU_MODE_LEN] = {0};
	uint8 nv_ecry_type[WF_ENCRY_TYPE_LEN] = {0};

	//char nv_basic[NVIO_WIFI_MAX_LEN]={0}; // for nv read and write

	/*lint -e717*/
#define SECURITY_NV_WRITE(nv_name, str, ret)  do{ ret = zte_web_write(nv_name, (char *)str);}while(0)

	memset(KeyType, 0, sizeof(KeyType)); //set 0
	memset(KeyStr, 0, sizeof(KeyStr));     //set 0

	if ((NULL == wp) || (NULL == wifi_set_flags)) {
		slog(MISC_PRINT, SLOG_ERR,"input para is null.\n");/*lint !e26*/
		return -1;
	}

	security_mode = websGetVar(wp, T("m_AuthMode"), NULL);
	if (security_mode != NULL) {
		slog(MISC_PRINT, SLOG_DEBUG,"security_mode = [%s]", security_mode);/*lint !e26*/

		encryp_type = websGetVar(wp, T("m_EncrypType"), NULL);
		if (NULL == encryp_type) {
			slog(MISC_PRINT, SLOG_DEBUG,"encryp_type == NULL", 0, 0, 0);/*lint !e26*/
			return -1;
		}

		slog(MISC_PRINT, SLOG_DEBUG,"encryp_type = [%s]", encryp_type);  /*lint !e26*/

		if (STR_EQUAL(security_mode, WF_AU_OPEN)  || STR_EQUAL(security_mode, WF_AU_SHARE)) {
			if ((STR_EQUAL(security_mode, WF_AU_OPEN) && STR_EQUAL(encryp_type, WF_ENCRY_WEP)) ||
			    (STR_EQUAL(security_mode, WF_AU_SHARE))) { //&&STR_EQUAL(wifi_encry_type, WF_AU_OPEN)) )
				zte_wifi_open_and_share_mode_s_type nv_open_and_share_s;
				memset(&nv_open_and_share_s, 0, sizeof(zte_wifi_open_and_share_mode_s_type));

				//read nv
				(void)zte_web_read("m_AuthMode", nv_au_mode);
				(void)zte_web_read("m_EncrypType", nv_ecry_type);
				(void)zte_web_read("m_DefaultKeyID", nv_open_and_share_s.wep_key_index);
				(void)zte_web_read("m_Key1Str1", nv_open_and_share_s.wep_key1);
				(void)zte_web_read("m_Key2Str1", nv_open_and_share_s.wep_key2);
				(void)zte_web_read("m_Key3Str1", nv_open_and_share_s.wep_key3);
				(void)zte_web_read("m_Key4Str1", nv_open_and_share_s.wep_key4);
				(void)zte_web_read("m_Key1Type", nv_open_and_share_s.wep_key1_mode);
				(void)zte_web_read("m_Key2Type", nv_open_and_share_s.wep_key2_mode);
				(void)zte_web_read("m_Key3Type", nv_open_and_share_s.wep_key3_mode);
				(void)zte_web_read("m_Key4Type", nv_open_and_share_s.wep_key4_mode);

				DefaultKeyID = websGetVar(wp, T("m_DefaultKeyID"), "");
				KeyStr[1] = websGetVar(wp, T("m_Key1Str1"), "");
				KeyStr[2] = websGetVar(wp, T("m_Key2Str1"), "");
				KeyStr[3] = websGetVar(wp, T("m_Key3Str1"), "");
				KeyStr[4] = websGetVar(wp, T("m_Key4Str1"), "");
				KeyType[1] = websGetVar(wp, T("m_Key1Type"), "");
				KeyType[2] = websGetVar(wp, T("m_Key2Type"), "");
				KeyType[3] = websGetVar(wp, T("m_Key3Type"), "");
				KeyType[4] = websGetVar(wp, T("m_Key4Type"), "");

				//when the wifi setting has changed,then set them
				if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(encryp_type, nv_ecry_type) \
				    && STR_EQUAL(DefaultKeyID, nv_open_and_share_s.wep_key_index) \
				    && STR_EQUAL(KeyStr[1], nv_open_and_share_s.wep_key1) && STR_EQUAL(KeyStr[2], nv_open_and_share_s.wep_key2) && STR_EQUAL(KeyStr[3], nv_open_and_share_s.wep_key3) && STR_EQUAL(KeyStr[4], nv_open_and_share_s.wep_key4) \
				    && STR_EQUAL(KeyType[1], nv_open_and_share_s.wep_key1_mode) && STR_EQUAL(KeyType[2], nv_open_and_share_s.wep_key2_mode) && STR_EQUAL(KeyType[3], nv_open_and_share_s.wep_key3_mode) && STR_EQUAL(KeyType[4], nv_open_and_share_s.wep_key4_mode)) {

					printf("wifi:[%s][%s] not changed.\n", security_mode, encryp_type); /*lint !e26*/
				} else {
					SECURITY_NV_WRITE("m_AuthMode", security_mode, nv_ret);
					SECURITY_NV_WRITE("m_EncrypType", encryp_type, nv_ret);

					SECURITY_NV_WRITE("m_DefaultKeyID", DefaultKeyID, nv_ret);

					SECURITY_NV_WRITE("m_Key1Str1", KeyStr[1], nv_ret);
					SECURITY_NV_WRITE("m_Key2Str1", KeyStr[2], nv_ret);
					SECURITY_NV_WRITE("m_Key3Str1", KeyStr[3], nv_ret);
					SECURITY_NV_WRITE("m_Key4Str1", KeyStr[4], nv_ret);

					SECURITY_NV_WRITE("m_Key1Type", KeyType[1], nv_ret);
					SECURITY_NV_WRITE("m_Key2Type", KeyType[2], nv_ret);
					SECURITY_NV_WRITE("m_Key3Type", KeyType[3], nv_ret);
					SECURITY_NV_WRITE("m_Key4Type", KeyType[4], nv_ret);

					*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
					wlan_set_change_ssid_key_status(); //added by dujiajiao
				}
			} else if (STR_EQUAL(security_mode, WF_AU_OPEN) && STR_EQUAL(encryp_type, WF_ENCRY_NONE)) {
				(void)zte_web_read("m_AuthMode", nv_au_mode);
				(void)zte_web_read("m_EncrypType", nv_ecry_type);

				if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(encryp_type, nv_ecry_type)) {
					slog(MISC_PRINT, SLOG_NORMAL,"wifi:[%s][%s] not changed.\n", security_mode, encryp_type); /*lint !e26*/
				} else {
					SECURITY_NV_WRITE("m_AuthMode", security_mode, nv_ret);
					SECURITY_NV_WRITE("m_EncrypType", encryp_type, nv_ret);
					/* added by dujiajiao, in open&no encrypt condition, there is no password  */
					SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M_ENCODE, "", nv_ret);
					SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M, "", nv_ret);
					SECURITY_NV_WRITE("m_Key1Str1", "", nv_ret);
					SECURITY_NV_WRITE("m_Key2Str1", "", nv_ret);
					SECURITY_NV_WRITE("m_Key3Str1", "", nv_ret);
					SECURITY_NV_WRITE("m_Key4Str1", "", nv_ret);
					/*added by dujiajiao end */
					*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
					wlan_set_change_ssid_key_status(); //added by dujiajiao
				}
			} else {
				//wifi_au_mode or encrype invalid
				slog(MISC_PRINT, SLOG_ERR,"wifi:[%s][%s] is invalid.\n", security_mode, encryp_type); /*lint !e26*/
				return -1;
			}
		} else if (STR_EQUAL(security_mode, WF_AU_WPA)  || STR_EQUAL(security_mode, WF_AU_WPA2) ||
		           STR_EQUAL(security_mode, WF_AU_WPA_WPA2) || STR_EQUAL(security_mode, WF_AU_WPA3) || STR_EQUAL(security_mode, WF_AU_WPA2_WPA3)) {
			zte_wifi_wpa_and_wpa2_mode_s_type nv_wpa_and_wpa2;
			memset(&nv_wpa_and_wpa2, 0, sizeof(zte_wifi_wpa_and_wpa2_mode_s_type));

			pass_phrase_str = websGetVar(wp, T(NV_WIFI_WPA_PASS_M), "");
			cipher_str = websGetVar(wp, T("cipher"), "");

			slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_str = %s", pass_phrase_str);     /*lint !e26*/
			slog(MISC_PRINT, SLOG_DEBUG,"cipher_str = %s", cipher_str);  /*lint !e26*/

			//add by liuyingnan for server safe for xss attack start
			if (DATA_NO_SAFE == zte_Safe_noSpecialChar(pass_phrase_str)) {
				printf("Get Data is no Safe:ssid:%s\n", pass_phrase_str); /*lint !e26*/
				return -1;
			}
			//add by liuyingnan for server safe for xss attack end

			switch (cipher_str[0]) {
			case '0':
				strncpy(wpa_encry_type, WF_ENCRY_TKIP, sizeof(wpa_encry_type) - 1);
				break;
			case '1':
				strncpy(wpa_encry_type, WF_ENCRY_AES, sizeof(wpa_encry_type) - 1);
				break;
			case '2':
				strncpy(wpa_encry_type, WF_ENCRY_TKIP_AES, sizeof(wpa_encry_type) - 1);
				break;
			default:
				printf("unvalid encry type [%c]", encryp_type[0]);/*lint !e26*/
				return -1;
			}

			(void)zte_web_read("m_AuthMode", nv_au_mode);
			(void)zte_web_read("m_EncrypType", nv_ecry_type);
			(void)zte_web_read(NV_WIFI_WPA_PASS_M, nv_wpa_and_wpa2.pre_share_key);

			if (STR_EQUAL(security_mode, nv_au_mode) && STR_EQUAL(wpa_encry_type, nv_ecry_type) && STR_EQUAL(pass_phrase_str, nv_wpa_and_wpa2.pre_share_key)) {

				slog(MISC_PRINT, SLOG_NORMAL,"wifi:[%s][%s] not changed.\n", security_mode, wpa_encry_type); /*lint !e26*/
			} else {
				SECURITY_NV_WRITE("m_AuthMode", security_mode, nv_ret);
				SECURITY_NV_WRITE("m_EncrypType", wpa_encry_type, nv_ret);
				//add by liuyingnan for Server safe start
				slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_str:%s.\n", pass_phrase_str); /*lint !e26*/
#ifdef WEBS_SECURITY
				pass_phrase_str_decode = js_aes_decode(pass_phrase_str, strlen(pass_phrase_str), (unsigned int)&pass_phrase_str_decode_length);
#else
				pass_phrase_str_decode = (char*)zte_base64_decode((const unsigned char *)pass_phrase_str, strlen(pass_phrase_str), (unsigned int)&pass_phrase_str_decode_length);
#endif
				slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_str_decode:%s.\n", pass_phrase_str_decode); /*lint !e26*/

				if (NULL == pass_phrase_str_decode) {
					slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_str_decode: psw is empty.\n");/*lint !e26*/
					free(pass_phrase_str_decode);
					return -1;
				}		
				zte_pass_phrase_len = (pass_phrase_str_decode_length < sizeof(zte_pass_phrase_str) ? pass_phrase_str_decode_length : sizeof(zte_pass_phrase_str) - 1);
				snprintf(zte_pass_phrase_str,zte_pass_phrase_len+1,"%s",pass_phrase_str_decode);
				//strncpy(zte_pass_phrase_str, pass_phrase_str_decode, zte_pass_phrase_len);
				free(pass_phrase_str_decode);
				slog(MISC_PRINT, SLOG_DEBUG,"login3 -> pass_phrase_str:%s.\n", zte_pass_phrase_str); //cov m
#ifdef WEBS_SECURITY
				if(zte_pass_phrase_str && !check_web_input_wifi(zte_pass_phrase_str,strlen(zte_pass_phrase_str)))
				{
					slog(MISC_PRINT, SLOG_ERR,"[goahead]wifipass2=%s\n",zte_pass_phrase_str);
					return -1;
				}
				pass_phrase_b64_encode = zte_base64_encode(zte_pass_phrase_str, strlen(zte_pass_phrase_str));
				if (NULL == pass_phrase_b64_encode) {
					slog(MISC_PRINT, SLOG_DEBUG,"pass_phrase_b64_encode: psw is NULL.\n");/*lint !e26*/
					return -1;
				}
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M_ENCODE, pass_phrase_b64_encode, nv_ret);
				free(pass_phrase_b64_encode);
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M, zte_pass_phrase_str, nv_ret);
				SECURITY_NV_WRITE("m_WPAPSK1_enaes", pass_phrase_str, nv_ret);
#else
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M_ENCODE, pass_phrase_str, nv_ret);
				SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M, zte_pass_phrase_str, nv_ret);
#endif
				//add by liuyingnan for Server safe end
				//SECURITY_NV_WRITE(NV_WIFI_WPA_PASS_M, pass_phrase_str, nv_ret);

				*wifi_set_flags |= ZTE_WLAN_SET_AP_MSSID;
				wlan_set_change_ssid_key_status(); //added by dujiajiao
			}
		} else {
			// other security mode is invalid
			slog(MISC_PRINT, SLOG_ERR,"ERROR:security mode  is invalid");/*lint !e26*/
			return -1;
		}
	} else {
		//security_mode is NULL
		slog(MISC_PRINT, SLOG_ERR,"ERROR:security_mode is NULL ");/*lint !e26*/
		return -1;
	}

	return 0;

}

void zte_wlan_set_tsw(webs_t wp)
{
	char * openEnable = NULL;
	char * closeEnable = NULL;
	char * openTime = NULL;
	char * closeTime = NULL;
	char old_open_time[16] = {0};
	char old_close_time[16] = {0};
	char old_open_enable[16] = {0};
	char tsw_sleep_time_hour[16] = {0};
	char tsw_sleep_time_min[16] = {0};
	char tsw_wake_time_hour[16] = {0};
	char tsw_wake_time_min[16] = {0};
	char *tmp = NULL;
	int tsw_change_flag = 0;
	sc_cfg_get("openEnable", old_open_enable, sizeof(old_open_enable));

	sc_cfg_get("openTime", old_open_time, sizeof(old_open_time));

	sc_cfg_get("closeTime", old_close_time, sizeof(old_close_time));

	slog(MISC_PRINT, SLOG_DEBUG,"[%s]old_open_enable=%s,old_open_time=%s,old_close_time=%s\n", __FUNCTION__, old_open_enable, old_open_time, old_close_time);
	openEnable = websGetVar(wp, T("openEnable"), T(""));
	closeEnable = websGetVar(wp, T("closeEnable"), T(""));
	openTime = websGetVar(wp, T("openTime"), T(""));
	closeTime = websGetVar(wp, T("closeTime"), T(""));
	slog(MISC_PRINT, SLOG_DEBUG,"[%s]openEnable=%s,closeEnable=%s,openTime=%s,closeTime=%s\n", __FUNCTION__, openEnable, closeEnable, openTime, closeTime);

	//check the param: openEnable & closeEnable
	if (NULL == openEnable || '\0' == *openEnable || NULL == closeEnable || '\0' == *closeEnable) {
		slog(MISC_PRINT, SLOG_ERR,"wlan_set_tsw: **open/close**invalid input para.\n");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//if swtich is open , then check the param: openTime & closeTime
	if (strcmp(openEnable, "1") == 0) {
		if (NULL == openTime || '\0' == *openTime || NULL == closeTime || '\0' == *closeTime) {
			slog(MISC_PRINT, SLOG_ERR,"wlan_set_tsw: **open**invalid input para:openTime /closeTime.\n");/*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	}
	sc_cfg_set("openEnable", openEnable);
	sc_cfg_set("closeEnable", closeEnable);

	//send msg to wlan-server to close timing sleep wake up
	if (strcmp(openEnable, "0") == 0 && strcmp(old_open_enable, "1") == 0) {
		tsw_change_flag = 1;
		slog(MISC_PRINT, SLOG_NORMAL,"send to wlan-server : MSG_CMD_WIFI_TSW_CLOSE\n");
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_TSW_CLOSE,0,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_TSW_CLOSE, 0, NULL, 0);

	}
	// 1.if current openEnable is 1, and old_open_enable is 0, then send msg to wlan-server to setup tsw
	// 2. if current openEnable is 1,  and openTime is changed or closeTime changed, then send msg to wlan-server to setup tsw
	else if ((strcmp(openEnable, "1") == 0 && strcmp(old_open_enable, "0") == 0) || \
	         ((strcmp(openEnable, "1") == 0)  && (strcmp(openTime, old_open_time) != 0 || strcmp(closeTime, old_close_time) != 0))) {
		tsw_change_flag = 1;

		sc_cfg_set("openTime", openTime);
		sc_cfg_set("closeTime", closeTime);
		snprintf(tsw_wake_time_hour, 3, "%s", openTime);
		snprintf(tsw_wake_time_min, 3, "%s", openTime + 3);
		snprintf(tsw_sleep_time_hour, 3, "%s", closeTime);
		snprintf(tsw_sleep_time_min, 3, "%s", closeTime + 3);
		slog(MISC_PRINT, SLOG_DEBUG,"tsw_wake_time_hour:%s,tsw_wake_time_min:%s\n", tsw_wake_time_hour, tsw_wake_time_min);
		slog(MISC_PRINT, SLOG_DEBUG,"tsw_sleep_time_hour:%s,tsw_sleep_time_min:%s\n", tsw_sleep_time_hour, tsw_sleep_time_min);
		sc_cfg_set("tsw_wake_time_hour", tsw_wake_time_hour);

		sc_cfg_set("tsw_wake_time_min", tsw_wake_time_min);
		sc_cfg_set("tsw_sleep_time_hour", tsw_sleep_time_hour);

		sc_cfg_set("tsw_sleep_time_min", tsw_sleep_time_min);

		slog(MISC_PRINT, SLOG_NORMAL,"send msg to wlan-server : MSG_CMD_WIFI_TSW_SET\n ");
		//zte_send_message(MODULE_ID_WIFI,MSG_CMD_WIFI_TSW_SET,0,NULL);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_WIFI, MSG_CMD_WIFI_TSW_SET, 0, NULL, 0);
	}

	zte_write_result_to_web(wp, SUCCESS);
}

static void zte_get_cur_user_mac(struct list_head *Dhcp_info_list)
{
	struct in_addr addr;
	char ipaddress[16] = {0};
	char client_mac_addr[18] = {0};
	char old_client_mac_addr[18] = {0};
	DHCPOFFERADDR_LIST_t * p_dhcp_info  = NULL;

	sc_cfg_get("client_mac_address", old_client_mac_addr, sizeof(old_client_mac_addr));
	sc_cfg_get(NV_USER_IP_ADDR, ipaddress, sizeof(ipaddress));
	list_for_each_entry(p_dhcp_info, Dhcp_info_list, list) {
		addr.s_addr = p_dhcp_info->dhcp_info.ip;
		if ((strcmp(ipaddress, "") != 0) && (strcmp(inet_ntoa(addr), "")) && (!strcmp(ipaddress, inet_ntoa(addr)))) {
			snprintf(client_mac_addr, 18, "%02X:%02X:%02X:%02X:%02X:%02X", p_dhcp_info->dhcp_info.mac[0], p_dhcp_info->dhcp_info.mac[1], p_dhcp_info->dhcp_info.mac[2], p_dhcp_info->dhcp_info.mac[3], p_dhcp_info->dhcp_info.mac[4], p_dhcp_info->dhcp_info.mac[5]);
			if (strcmp(client_mac_addr, old_client_mac_addr)) {
				sc_cfg_set("client_mac_address", client_mac_addr);
				break;
			}
		}
	}
}

static DHCPOFFERADDR_LIST_t *find_match_sta(struct list_head *dhcp_info_list,  RT_802_11_MAC_ENTRY * pEntry)
{
	DHCPOFFERADDR_LIST_t * p_dhcp_info = NULL;

	list_for_each_entry(p_dhcp_info, dhcp_info_list, list) {
		//  printf("[%s] p_dhcp_info:%d\n", __FUNCTION__, p_dhcp_info);


		if ((p_dhcp_info->dhcp_info.mac[0] == pEntry->Addr[0]) && (p_dhcp_info->dhcp_info.mac[1] == pEntry->Addr[1]) &&
		    (p_dhcp_info->dhcp_info.mac[2] == pEntry->Addr[2]) && (p_dhcp_info->dhcp_info.mac[3] == pEntry->Addr[3]) &&
		    (p_dhcp_info->dhcp_info.mac[4] == pEntry->Addr[4]) && (p_dhcp_info->dhcp_info.mac[5] == pEntry->Addr[5])) {

			return p_dhcp_info;

		}
	}


	return  NULL;

}

//ȡwifi lanϢ: wifiֿԭھбlease޷˭wifiֻwifiоƬ֪
void zte_wlan_get_station_list(webs_t wp)
{
	int i      = 0;
	int result = 0;

	BOOL first 	= TRUE;
	BOOL match  = FALSE;

	struct in_addr ipAddr                   = {0};
	RT_802_11_MAC_TABLE staList             = {0};
	DHCPOFFERADDR_LIST_t * p_dhcp_info   = NULL;

	struct list_head dhcp_info_list;
	INIT_LIST_HEAD(&dhcp_info_list);

	zte_get_wifi_sta_list(&staList);
	if (staList.Num > MAX_NUMBER_OF_MAC) {//kw 2,3
		slog(MISC_PRINT, SLOG_ERR, "sta_count err, Num=%d\n", staList.Num);
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[%s]staList.Num:%d\n", __FUNCTION__, staList.Num);
	slog(MISC_PRINT, SLOG_DEBUG,"[%s]sta_list->ConnectedTime:%d\n", __FUNCTION__, staList.Entry[0].ConnectedTime);
	if (0 == staList.Num) {
		sc_cfg_set("client_mac_address", ""); //added by dujiajiao 2016-2-24
	}

	result = zte_get_mac_list_from_lease(&dhcp_info_list);

	web_feedback_header(wp);
	(void)websWrite(wp, T("{\"%s\":["), CMD_WIFI_STATION_LIST);

	/*
	        if(-1 == result || -2 == result || -3 == result)
	        {
	    	    (void)websWrite(wp, T("]}"));
	            safe_free(dhcp_info_list);
	            return;
	        }
	*/

	if (0 == result) {
		zte_get_cur_user_mac(&dhcp_info_list);//added by dujiajiao 2016-2-24
	}


	for (i = 0; i < staList.Num; i++) {

		if (first == FALSE) {
			(void)websWrite(wp, T(","));
		} else {
			first = FALSE;
		}

		if (staList.Entry[i].ConnectedTime) {
			(void)websWrite(wp, T("{\"%s\":%ld,"), WIFI_STATION_CONNECTTIME, staList.Entry[i].ConnectedTime);
		} else {
			(void)websWrite(wp, T("{\"%s\":\"--\","), WIFI_STATION_CONNECTTIME);
		}

		/*do not use macro,  the SSID_index = 0 in broadcom*/
		slog(MISC_PRINT, SLOG_DEBUG,"[%s]SSID_index:%d\n", __FUNCTION__, staList.Entry[i].SSID_index);

		if (staList.Entry[i].SSID_index) {
			(void)websWrite(wp, T("\"%s\":\"%d\","), WIFI_SSID_INDEX, staList.Entry[i].SSID_index);
		}

		(void)websWrite(wp, T("\"%s\":\"wifi\","), WIFI_STATION_DEVTYPE);


		(void)websWrite(wp, T("\"%s\":\"%02X:%02X:%02X:%02X:%02X:%02X\","), WIFI_STATION_MAC, \
		                staList.Entry[i].Addr[0], staList.Entry[i].Addr[1], staList.Entry[i].Addr[2], staList.Entry[i].Addr[3], staList.Entry[i].Addr[4], staList.Entry[i].Addr[5]);

		if ((p_dhcp_info = find_match_sta(&dhcp_info_list,  &staList.Entry[i])) != NULL) {


			slog(MISC_PRINT, SLOG_DEBUG,"[%s] dhcp_info.mac= %02X %02X %02X %02X %02X %02X \n", __FUNCTION__, \
			       p_dhcp_info->dhcp_info.mac[0], p_dhcp_info->dhcp_info.mac[1], p_dhcp_info->dhcp_info.mac[2], \
			       p_dhcp_info->dhcp_info.mac[3], p_dhcp_info->dhcp_info.mac[4], p_dhcp_info->dhcp_info.mac[5]);

			if (p_dhcp_info->dhcp_info.ip != NULL) {

				slog(MISC_PRINT, SLOG_DEBUG,"[%s]dhcp_info_ip:%d\n", __FUNCTION__, p_dhcp_info->dhcp_info.ip);

			}

			ipAddr.s_addr = p_dhcp_info->dhcp_info.ip;

			if (strlen(p_dhcp_info->dhcp_info.host_name) > 0) { //kw 3 ??
				(void)websWrite(wp, T("\"%s\":\"%s\","), WIFI_STATION_HOSTNAME, p_dhcp_info->dhcp_info.host_name);
			} else {
				(void)websWrite(wp, T("\"%s\":\"--\","), WIFI_STATION_HOSTNAME);
			}

			if (inet_ntoa(ipAddr)) {
				(void)websWrite(wp, T("\"%s\":\"%s\","), WIFI_STATION_IPADDR, inet_ntoa(ipAddr));
				slog(MISC_PRINT, SLOG_DEBUG,"[%s]dhcp_info_ip-inet_ntoa:%s\n", __FUNCTION__, inet_ntoa(ipAddr));
			} else {
				(void)websWrite(wp, T("\"%s\":\"--\","), WIFI_STATION_IPADDR);
			}

			if (zte_is_static_dhcp_ip(inet_ntoa(ipAddr))) {
				//(void)websWrite(wp,T("\"%s\":-1,"),WIFI_STATION_VALIDTIME);
				(void)websWrite(wp, T("\"%s\":\"STATIC\"}"), WIFI_STATION_IPTYPE);
			} else {
				//(void)websWrite(wp,T("\"%s\":%ld,"),WIFI_STATION_VALIDTIME, dhcpInfo.expires);
				(void)websWrite(wp, T("\"%s\":\"DHCP\"}"), WIFI_STATION_IPTYPE);
			}
			match = FALSE;
		} else {
//1.  dchp  not  give an IP
//2.  customer set a static ip
			slog(MISC_PRINT, SLOG_DEBUG,"[%s:%s]do not match ++++++++ \n", __FILE__, __FUNCTION__);

			(void)websWrite(wp, T("\"%s\":\"--\","), WIFI_STATION_HOSTNAME);
			(void)websWrite(wp, T("\"%s\":\"--\","), WIFI_STATION_IPADDR);
			(void)websWrite(wp, T("\"%s\":\"--\"}"), WIFI_STATION_IPTYPE);
		}

	}

	(void)websWrite(wp, T("]}"));

	free_dhcp_list(&dhcp_info_list);
}


static unsigned int wps_pin_checksum(unsigned long pin)
{
	unsigned long int accum = 0;
	while (pin) {
		accum += 3 * (pin % 10);
		pin /= 10;
		accum += pin % 10;
		pin /= 10;
	}

	return (10 - accum % 10) % 10;
}

int os_get_time(struct os_time *t)
{
	int res = 0;
	struct timeval tv;
	res = gettimeofday(&tv, NULL);
	t->sec = tv.tv_sec;
	t->usec = tv.tv_usec;
	return res;
}
static int get_random(unsigned char* buf, size_t len)
{
	FILE* f;
	size_t rc;

	f = fopen("/dev/urandom", "rb");
	if (f == NULL) {
		slog(MISC_PRINT, SLOG_ERR,"Could not open /dev/urandom.\n");
		return -1;
	}

	rc = fread(buf, 1, len, f);
	//kw 3
	fclose(f);
	
	//printf("rc is %d, buf is %s\n", rc, buf);
	return rc != len ? -1 : 0;
}

int random_get_bytes(void* buf, size_t len)
{
	int ret;
	unsigned char* bytes = buf;

	ret = get_random(buf, len);
	return ret;
}

static int wps_generate_pin(void)
{
	unsigned int val = 0;

	/*Generate seven random digits for the PIN*/
	if (random_get_bytes((unsigned char *) &val, sizeof(val)) < 0) {
		struct os_time now;
		os_get_time(&now);
		val = random() ^ now.sec ^ now.usec;
	} else {//klocwork
		if (val > 0xFFFFFFF0) {
			struct os_time now;
			os_get_time(&now);
			val = random() ^ now.sec ^ now.usec;
		}
	}
	val %= 10000000;
	//printf("val is %ld\n", val);
	/*Append checksum digit*/
	return val * 10 + wps_pin_checksum(val);
}

void zte_wlan_get_wps_pin(webs_t wp)
{
	unsigned long pincode = 0;
	char pin[9] = {0};

	pincode = wps_generate_pin();
	snprintf(pin,sizeof(pin), "%08d", pincode);

	(void)zte_web_write(NV_WIFI_WPS_AP_PIN, pin);
	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	zte_rest_cmd_write(wp, NV_WIFI_WPS_AP_PIN, pin, 0);
	zte_rest_cmd_write_foot(wp);
}

void zte_wlan_get_wps_defpin(webs_t wp)
{
	//unsigned long defpincode = 0;
	char pin[9] = {0};
	(void)zte_web_read(NV_WIFI_WPS_DEF_PIN, pin);

	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	zte_rest_cmd_write(wp, NV_WIFI_WPS_DEF_PIN, pin, 0);
	zte_rest_cmd_write_foot(wp);
}


