/************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ zte_web_mgmt.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ zyt
* ڣ 2010-11-06
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/

/**************************************************************************
* ޸ı : ¹
*    : chenjie10092374
* ޸ : 2014.6.24
* ޸ : ֧ufi monitorܴ
**************************************************************************/

#include "zte_web_interface.h"
//#include "sms_com.h"
#include "zte_web_get_fw_para.h"
#include "zte_web_sms.h"


#define  UPCASE( c ) ( ((c) >= 'a' && (c) <= 'z') ? ((c) - 0x20) : (c) )

extern void zte_rest_get_sms_data_head(webs_t wp);
extern void zte_rest_get_sms_data_foot(webs_t wp);
extern void zte_rest_get_bro_data_head(webs_t wp);
extern void zte_rest_get_bro_data_foot(webs_t wp);
extern void zte_rest_get_sms_data(webs_t wp, zte_sms_query_result *p_sms_query_result, int i, int tag);
extern void zte_rest_sms_parameter(webs_t wp, T_zUfiSms_ParaInfo sms_parameter_info);
extern void zte_rest_sms_status_rpt(webs_t wp, zte_sms_query_result *p_sms_query_result, int i, int tag);
extern void zte_rest_boradcast_data(webs_t wp, zte_wms_cell_bro_s_type *p_bro_query_result);
static void zte_web_feed_back_empty(webs_t wp);
static unsigned int parseStrBySeparator(unsigned char *input, unsigned char *output,  int destLen, unsigned char separator);
//static int asc_util_atoi(unsigned int *val_arg_ptr,  const unsigned char *s, unsigned int r);
//static int  sms_util_asc_to_hex(unsigned char  *in_ptr, unsigned char *out_ptr, int   len);

#define WebSms_LOG(priority,...) do {  \
	printf(__VA_ARGS__); \
} while(0)


VOID zte_sms_handle_DB_status_whenSend(int cmd_status)
{
	T_zUfiSms_StatusInfo statusInfo;
	memset((void*)&statusInfo, 0, sizeof(T_zUfiSms_StatusInfo));
	statusInfo.cmd = WMS_SMS_CMD_MSG_SEND;
	statusInfo.cmd_status = cmd_status;
	statusInfo.err_code = ZTE_SMS_CMS_NONE;
	statusInfo.send_failed_count = 0;
	statusInfo.delete_failed_count = 0;

	zte_libwms_setSmsCmdStatus(&statusInfo);
}

VOID zte_sms_handle_DB_status(int cmd, int cmd_status)
{
	T_zUfiSms_StatusInfo statusInfo;
	memset((void*)&statusInfo, 0, sizeof(T_zUfiSms_StatusInfo));
	statusInfo.cmd = cmd;
	statusInfo.cmd_status = cmd_status;
	statusInfo.err_code = ZTE_SMS_CMS_NONE;
	statusInfo.send_failed_count = 0;
	statusInfo.delete_failed_count = 0;

	zte_libwms_setSmsCmdStatus(&statusInfo);
}

/*
*Ӵ˺жҪΪУ׼Ҳᷢ
*Ϊ˱֤ATSERVER̴һԣӴж
*/
int zte_sms_check_can_send_sms()
{
	T_zUfiSms_StatusInfo cmd_status_info = {0};
	int result = 0;
	char buf1[NV_ITEM_STRING_LEN_10] = {0};
	char buf2[NV_ITEM_STRING_LEN_10] = {0};
	char buf3[NV_ITEM_STRING_LEN_20] = {0};

	/*
	*¼Բж:
	*(1)У׼δ;
	*(2)У׼Ѵ򿪣ĿǰУ
	*(3)У׼ѴУڷͶŹУ
	*ע:ʵԹΪ(3)һжϼɣ
	*       ˴Ϊ˱άڴжϴ
	*/
	sc_cfg_get(NV_DATA_TRAFFIC_SWITCH, &buf1, sizeof(buf1));
	sc_cfg_get("is_traffic_alining", buf2, sizeof(buf2));
	sc_cfg_get("traffic_sms_number", buf3, sizeof(buf3));

	if ((0 != strcmp(buf1, "yes"))
	    || (0 == strcmp(buf2, "no"))
	    || (0 == strcmp(buf3, "0"))) {
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] sms_check_can_send_sms, no need to check!\n");
		return  0;
	}

	cmd_status_info.cmd = WMS_SMS_CMD_MSG_SEND;
	result = zte_libwms_get_cmd_status(&cmd_status_info);
	if (result == -1) {
		return 0;
	}

	if (cmd_status_info.cmd_status == WMS_CMD_PROCESSING) {
		return -1;
	}

	return 0;
}

int hex_check(char *buf)
{
	int i = 0;
	int len = strlen(buf);
	for (i = 0; i < len; i++) {
		if(!isxdigit(buf[i]))
			return -1;
	}
	return i;
}

void zte_sms_send_msg_process(webs_t wp)
{
	unsigned int i = 0;
	//int j = 0;
	int message_content_len = 0;
	unsigned int   rec_count = 0;
	unsigned char encode_type = 0;
	char_t *sms_encode_type = NULL;
	char_t *msg_id = NULL;
	unsigned char *msg_content_web = NULL;
	//char_t *which_page = NULL;
	char_t *sms_time = NULL;
	int s_flag = 0; //to distinguish time field from time string
	int index = 0;
	unsigned char *rec_number = NULL;
	unsigned char rec_separate[ZTE_WMS_SEND_NUM_MAX][ZTE_WMS_ADDRESS_LEN_MAX + 1] = {0};
	T_zUfiSms_SendReq  MSG_SEND_ST;

	memset(&MSG_SEND_ST, 0, sizeof(T_zUfiSms_SendReq));
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User send msg!\n"));
	//which_page = websGetVar(wp, "which_cgi", T(""));
	rec_number = websGetVar(wp, "Number", T(""));
	msg_content_web = websGetVar(wp, "MessageBody", T(""));
	msg_id = websGetVar(wp, "ID", T(""));
	sms_encode_type = websGetVar(wp, "encode_type", T(""));
	sms_time = websGetVar(wp, "sms_time", T(""));

	//add by liuyingnan for server safe for xss attack start
	if (DATA_NO_SAFE == zte_Safe_noSpecialChar(msg_content_web)
	    || DATA_NO_SAFE == zte_Safe_noSpecialChar(rec_number)
	    || hex_check(msg_content_web) < 0) {
		sc_cfg_set("data_safe", "failed");
		slog(MISC_PRINT, SLOG_ERR,"Get Data is no Safe:msg_content_web:%s\n", msg_content_web); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//add by liuyingnan for server safe for xss attack end

	/* adjust the number and contents' form */
	message_content_len = strlen(msg_content_web) / 2;
	slog(MISC_PRINT, SLOG_DEBUG, "goahead==message_content_len=%d", message_content_len); /*lint !e26*/
	rec_count = parseStrBySeparator(rec_number, (unsigned char *)rec_separate, ZTE_WMS_ADDRESS_LEN_MAX + 1, SEPARATOR_CHARACTER);

	if (0 == strcmp("ASCII", sms_encode_type)) { //not include chinese
		encode_type = DCS_ASC;
	} else if (0 == strcmp("UNICODE", sms_encode_type)) {
		encode_type = DCS_UNICODE;
	} else if (0 == strcmp("GSM7_span", sms_encode_type)) {
		encode_type = DCS_SPANISH;
	} else if (0 == strcmp("GSM7_default", sms_encode_type)) {
		slog(MISC_PRINT, SLOG_DEBUG, "goahead==GSM7_default==sms_encode_type=%s", sms_encode_type); /*lint !e26*/
		encode_type = DCS_GSM7_DEFAULT;
		slog(MISC_PRINT, SLOG_DEBUG,"goahead==end==encode_type=%d", encode_type); /*lint !e26*/
	} else if (0 == strcmp("GSM7_turkey", sms_encode_type)) {
		encode_type = DCS_TURKISH;
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "invalid sms_encode_type [%s]! \n", sms_encode_type); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//parse the time field
	for (i = 0; i < strlen(sms_time); i++) {
		if (';' == sms_time[i]) {
			s_flag++;
			index = 0;
			continue;
		}

		if ((0 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.year) - 1))) {
			MSG_SEND_ST.date.year[index++] = sms_time[i];
		} else if ((1 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.month) - 1))) {
			MSG_SEND_ST.date.month[index++] = sms_time[i];
		} else if ((2 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.day) - 1))) {
			MSG_SEND_ST.date.day[index++] = sms_time[i];
		} else if ((3 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.hour) - 1))) {
			MSG_SEND_ST.date.hour[index++] = sms_time[i];
		} else if ((4 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.min) - 1))) { /*lint !e123*/
			MSG_SEND_ST.date.min[index++] = sms_time[i];/*lint !e123*/
		} else if ((5 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.sec) - 1))) {
			MSG_SEND_ST.date.sec[index++] = sms_time[i];
		} else if ((6 == s_flag) && (index < (sizeof(MSG_SEND_ST.date.timezone) - 1))) {
			MSG_SEND_ST.date.timezone[index++] = sms_time[i];
		}

	}

	slog(MISC_PRINT, SLOG_DEBUG,"sms_send_msg_process:year is [%s];"\
	           "month is [%s];day is [%s];hour is [%s];minute is [%s];second is [%s];timezone is [%s].\n", \
	           MSG_SEND_ST.date.year, MSG_SEND_ST.date.month, MSG_SEND_ST.date.day, \
	           MSG_SEND_ST.date.hour, MSG_SEND_ST.date.min, MSG_SEND_ST.date.sec, \
	           MSG_SEND_ST.date.timezone);/*lint !e26 !e123 */

	/* stuff the struct which is sending to mc */
	slog(MISC_PRINT, SLOG_DEBUG, "goahead==============msg_content_web==========%s", msg_content_web); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "goahead=========message_content_len=%d", message_content_len); /*lint !e26*/
//  concat sms
	zte_libwms_db_write_send_msg_content_data(msg_content_web);
	//doSystem("sleep 1");
	slog(MISC_PRINT, SLOG_NORMAL, "Send message to database succesful!\n"); /*lint !e26*/
#if 0  // ԭּ֧ŵĴ
	(void)sms_util_asc_to_hex(msg_content_web, MSG_SEND_ST.msg_content, message_content_len);
#endif
	MSG_SEND_ST.msg_len = message_content_len;

	MSG_SEND_ST.dcs = encode_type;

	MSG_SEND_ST.receiver_count = rec_count;
	memcpy(MSG_SEND_ST.dest_num, rec_separate, sizeof(rec_separate));

	//handle whether to delete the old sms begin
	if (0 != strcmp(msg_id, "")) {
		MSG_SEND_ST.id = atol(msg_id); //-1:new msg
	} else {
		slog(MISC_PRINT, SLOG_ERR, "invalid msg_id [%s]! \n", msg_id); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//handle whether to delete the old sms end

#if 0
	if (0 == strcmp(which_page, NEW_MESSAGE)) {
		MSG_SEND_ST.db = ZTE_WMS_TABLE_NV;
	} else if (0 == strcmp(which_page, NATIVE_INBOX) || 0 == strcmp(which_page, NATIVE_DRAFTBOX)) {
		MSG_SEND_ST.db = ZTE_WMS_TABLE_NV;
	} else if (0 == strcmp(which_page, SIM_INBOX) || 0 == strcmp(which_page, SIM_DRAFTBOX)) {
		MSG_SEND_ST.db = ZTE_WMS_TABLE_SIM;
	} else {
		WebSms_LOG(LOG_INFO, "invalid which_page [%s]! \n", which_page); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
#endif

	if (0 != zte_sms_check_can_send_sms()) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	/* mc interface */
	zte_sms_handle_DB_status_whenSend(WMS_CMD_PROCESSING);
	if (ZTE_MC_OK_S == zte_mc_relay_sms_send_msg((T_zUfiSms_SendReq*)(&MSG_SEND_ST))) {
		slog(MISC_PRINT, SLOG_NORMAL, "sms_send_msg_process:Send message to mc successful!\n"); /*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		zte_sms_handle_DB_status_whenSend(WMS_CMD_FAILED);
		slog(MISC_PRINT, SLOG_ERR, "sms_send_msg_process:Send message to mc fail!\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}

}
void zte_sms_save_msg_process(webs_t wp)
{
	//int j = 0;
	unsigned int i = 0;
	unsigned int   rec_count = 0;
	unsigned char *rec_number = NULL;
	char_t *msg_id = NULL;
	int message_content_len = 0;
	unsigned char encode_type = 0;
	unsigned char *msg_content_web = NULL;
	char_t *sms_encode_type = NULL;
	//char_t *which_page = NULL;
	char_t *sms_time = NULL;
	int s_flag = 0; //to distinguish time field from time string
	int index = 0;
	unsigned char rec_separate[ZTE_WMS_SEND_NUM_MAX][ZTE_WMS_ADDRESS_LEN_MAX + 1] = {0};   //separate receiver phone number
	T_zUfiSms_SaveReq  MSG_SAVE_ST;
	char_t *mem_store = NULL;
	char_t *tags = NULL;
	char_t *draft_group_id = NULL;

	memset(&MSG_SAVE_ST, 0, sizeof(T_zUfiSms_SaveReq));
	mem_store = websGetVar(wp, "location", T("1"));
	tags = websGetVar(wp, "tags", T("4"));
	//which_page = websGetVar(wp, "which_cgi", T(""));
	msg_content_web = websGetVar(wp, "SMSMessage", T(""));
	rec_number = websGetVar(wp, "SMSNumber", T(""));
	msg_id = websGetVar(wp, "Index", T(""));
	sms_encode_type = websGetVar(wp, "encode_type", T(""));
	sms_time = websGetVar(wp, "sms_time", T(""));
	draft_group_id = websGetVar(wp, "draft_group_id", T(""));

	//add by liuyingnan for server safe for xss attack start
	if (DATA_NO_SAFE == zte_Safe_noSpecialChar(msg_content_web)
	    || DATA_NO_SAFE == zte_Safe_noSpecialChar(rec_number) 
	    || hex_check(msg_content_web) < 0) {
		sc_cfg_set("data_safe", "failed");
		slog(MISC_PRINT, SLOG_DEBUG, "Get Data is no Safe:msg_content_web:%s\n", msg_content_web); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//add by liuyingnan for server safe for xss attack end

	/* adjust the contents' form */
	message_content_len = strlen(msg_content_web) / 2;

	if (0 == strcmp("ASCII", sms_encode_type)) { //not include chinese
		encode_type = DCS_ASC;
	} else if (0 == strcmp("UNICODE", sms_encode_type)) {
		encode_type = DCS_UNICODE;
	} else if (0 == strcmp("GSM7_span", sms_encode_type)) {
		encode_type = DCS_SPANISH;
	} else if (0 == strcmp("GSM7_default", sms_encode_type)) {
		encode_type = DCS_GSM7_DEFAULT;
	} else if (0 == strcmp("GSM7_turkey", sms_encode_type)) {
		encode_type = DCS_TURKISH;
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "invalid sms_encode_type [%s]! \n", sms_encode_type); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//parse the time field
	for (i = 0; i < strlen(sms_time); i++) {
		if (';' == sms_time[i]) {
			s_flag++;
			index = 0;
			continue;
		}

		if ((0 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.year) - 1))) {
			MSG_SAVE_ST.date.year[index++] = sms_time[i];
		} else if ((1 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.month) - 1))) {
			MSG_SAVE_ST.date.month[index++] = sms_time[i];
		} else if ((2 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.day) - 1))) {
			MSG_SAVE_ST.date.day[index++] = sms_time[i];
		} else if ((3 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.hour) - 1))) {
			MSG_SAVE_ST.date.hour[index++] = sms_time[i];
		} else if ((4 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.min) - 1))) { /*lint !e123*/
			MSG_SAVE_ST.date.min[index++] = sms_time[i];/*lint !e123*/
		} else if ((5 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.sec) - 1))) {
			MSG_SAVE_ST.date.sec[index++] = sms_time[i];
		} else if ((6 == s_flag) && (index < (sizeof(MSG_SAVE_ST.date.timezone) - 1))) {
			MSG_SAVE_ST.date.timezone[index++] = sms_time[i];
		}

	}

	slog(MISC_PRINT, SLOG_DEBUG, "sms_save_msg_process:year is [%s];"\
	           "month is [%s];day is [%s];hour is [%s];minute is [%s];second is [%s];timezone is [%s].\n", \
	           MSG_SAVE_ST.date.year, MSG_SAVE_ST.date.month, MSG_SAVE_ST.date.day, \
	           MSG_SAVE_ST.date.hour, MSG_SAVE_ST.date.min, MSG_SAVE_ST.date.sec, \
	           MSG_SAVE_ST.date.timezone);/*lint !e26 !e123 */
//CONCAT_SMS
	zte_libwms_db_write_send_msg_content_data(msg_content_web);
	//doSystem("sleep 1");
	slog(MISC_PRINT, SLOG_DEBUG, "Send message to database succesful!\n"); /*lint !e26*/
#if 0  // ԭּ֧ŵĴ
	/* stuff the struct which is sending to mc */
	(void)sms_util_asc_to_hex(msg_content_web, MSG_SAVE_ST.msg_content, message_content_len);
#endif

	MSG_SAVE_ST.msg_len = message_content_len;
	rec_count = parseStrBySeparator(rec_number, (unsigned char *)rec_separate, ZTE_WMS_ADDRESS_LEN_MAX + 1, SEPARATOR_CHARACTER);


	MSG_SAVE_ST.receiver_count = rec_count;
	memcpy(MSG_SAVE_ST.dest_num, rec_separate, sizeof(rec_separate));
	memcpy(MSG_SAVE_ST.draft_group_id, draft_group_id, sizeof(MSG_SAVE_ST.draft_group_id));

	MSG_SAVE_ST.dcs = encode_type;
	MSG_SAVE_ST.mem_store = (unsigned char)atoi(mem_store);
	MSG_SAVE_ST.tags = (unsigned char)atoi(tags);
	//handle whether to delete the old sms begin
	if (0 != strcmp(msg_id, "")) {
		MSG_SAVE_ST.id = atol(msg_id); //-1:new msg
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "invalid msg_id [%s]! \n", msg_id); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	//handle whether to delete the old sms end

#if 0
	if (0 == strcmp(which_page, NEW_MESSAGE)) {
		MSG_SAVE_ST.db = ZTE_WMS_TABLE_NV;
	} else if (0 == strcmp(which_page, NATIVE_INBOX) || 0 == strcmp(which_page, NATIVE_DRAFTBOX)) {
		MSG_SAVE_ST.db = ZTE_WMS_TABLE_NV;
	} else if (0 == strcmp(which_page, SIM_INBOX) || 0 == strcmp(which_page, SIM_DRAFTBOX)) {
		MSG_SAVE_ST.db = ZTE_WMS_TABLE_SIM;
	} else {
		WebSms_LOG(LOG_INFO, "invalid which_page [%s]! \n", which_page); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
#endif

	/* print log */
	for (i = 0; i < rec_count; i++) {
		slog(MISC_PRINT, SLOG_DEBUG, "MSG_SAVE_ST.dest_num = [%s]\n", MSG_SAVE_ST.dest_num[i]); /*lint !e26*/
	}

	slog(MISC_PRINT, SLOG_DEBUG, "web_sms:message_content_len = [%d]\n", message_content_len);	/*lint !e26*/
#if 0
	for (j = 0; j < message_content_len; j++) {
		WebSms_LOG(LOG_INFO, "web_sms:MSG_SAVE_ST content=[%x]\n", MSG_SAVE_ST.msg_content[j]); /*lint !e26*/
	}
#endif
	/* mc interface */

	if (ZTE_MC_OK_S == zte_mc_relay_sms_write_msg((T_zUfiSms_SaveReq*)(&MSG_SAVE_ST))) {
		slog(MISC_PRINT, SLOG_NORMAL, "web_sms:Send message to mc successful!(save msg)\n"); /*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "web_sms:Send message to mc fail!(save msg)\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}

	//zte_write_result_to_web(wp,SUCCESS);
}

void zte_sms_delete_msg_process(webs_t wp)
{
	unsigned int i = 0;
	unsigned int j = 0;
	unsigned int   msg_id_count = 0;
	unsigned char *msg_id = NULL;                                             //receiver phone number get from web
	unsigned char msg_id_separate[ZTE_WMS_DELETE_COUNT_MAX][WMS_MODULE_ID_LEN] = {0};             //separate receiver phone number
	T_zUfiSms_DelReq  del_sms_setting;
	//char_t *which_page = NULL;
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User delete msg!\n"));
	WebSms_LOG(LOG_INFO, T("[SMS] User delete msg!"));

	memset(&del_sms_setting, 0, sizeof(T_zUfiSms_DelReq));

	msg_id = websGetVar(wp, "msg_id", T(""));
	//which_page = websGetVar(wp, "which_cgi", T(""));

	slog(MISC_PRINT, SLOG_DEBUG, "web para:[msg_id] is [%s].\n", msg_id); /*lint !e26*/
	//WebSms_LOG(LOG_INFO,"web para:[which_page] is [%s].\n",which_page);/*lint !e26*/

	msg_id_count = parseStrBySeparator(msg_id, (unsigned char *)msg_id_separate, WMS_MODULE_ID_LEN, SEPARATOR_CHARACTER);
	slog(MISC_PRINT, SLOG_DEBUG,"!!!!goahead enter delete msg!!msg_id:%s/msg_id_count:%d.\n", msg_id, msg_id_count);

	del_sms_setting.all_or_count = msg_id_count;
	for (i = 0; i < msg_id_count; i++) {
		del_sms_setting.id[i] = atoi(msg_id_separate[i]);
	}

	for (j = 0; j < msg_id_count; j++) {
		slog(MISC_PRINT, SLOG_DEBUG,"sms_delete_msg_process:delete msg number:[%lu]\n", del_sms_setting.id[j]);/*lint !e26*/
	}
	/* mc interface */

	zte_sms_handle_DB_status(WMS_SMS_CMD_MSG_DELETE, WMS_CMD_PROCESSING);
	if (ZTE_MC_OK_S == zte_mc_relay_sms_delete_msg((T_zUfiSms_DelReq*)(&del_sms_setting))) {
		slog(MISC_PRINT, SLOG_DEBUG,"sms_delete_msg_process:send delete sms cmd to mc success.\n");/*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_DEBUG,"sms_delete_msg_process:send delete sms cmd to mc fail.\n");/*lint !e26*/
		zte_sms_handle_DB_status(WMS_SMS_CMD_MSG_DELETE, WMS_CMD_FAILED);
		zte_write_result_to_web(wp, FAILURE);
	}

	//zte_write_result_to_web(wp,SUCCESS);
}

void zte_sms_move_to_sim_msg_process(webs_t wp)
{
	unsigned int i = 0;
	unsigned int j = 0;
	unsigned int   msg_id_count = 0;
	unsigned char *msg_id = NULL;                                             //receiver phone number get from web
	unsigned char msg_id_separate[ZTE_WMS_DELETE_COUNT_MAX][WMS_MODULE_ID_LEN] = {0};             //separate receiver phone number
	T_zUfiSms_DelReq  del_sms_setting;
	//char_t *which_page = NULL;

	memset(&del_sms_setting, 0, sizeof(T_zUfiSms_DelReq));

	msg_id = websGetVar(wp, "msg_id", T(""));
	//which_page = websGetVar(wp, "which_cgi", T(""));

	slog(MISC_PRINT, SLOG_DEBUG,"web para:[msg_id] is [%s].\n", msg_id);
	//WEBLOG("web para:[which_page] is [%s].\n",which_page);

	msg_id_count = parseStrBySeparator(msg_id, (unsigned char *)msg_id_separate, WMS_MODULE_ID_LEN, SEPARATOR_CHARACTER);

	del_sms_setting.all_or_count = msg_id_count;
	for (i = 0; i < msg_id_count; i++) {
		del_sms_setting.id[i] = atoi(msg_id_separate[i]);
	}

	slog(MISC_PRINT, SLOG_DEBUG, "sms_move_to_sim_msg_process:del_sms_setting.all_or_count is [%lu]\n", del_sms_setting.all_or_count);

	for (j = 0; j < msg_id_count; j++) {
		slog(MISC_PRINT, SLOG_DEBUG, "sms_move_to_sim_msg_process:move msg number:[%lu]\n", del_sms_setting.id[j]);
	}
	/* mc interface */


	if (ZTE_MC_OK_S == zte_mc_relay_sms_move_to_sim_msg((T_zUfiSms_DelReq*)(&del_sms_setting))) {
		slog(MISC_PRINT, SLOG_NORMAL, "sms_move_to_sim_msg_process:send move sms cmd to mc success.\n");
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "sms_move_to_sim_msg_process:send move sms cmd to mc fail.\n");
		zte_write_result_to_web(wp, FAILURE);
	}

	//zte_write_result_to_web(wp,SUCCESS);
}
void zte_goform_sms_alldel_msg_process(webs_t wp)
{
	int ret = 0;
	char strPage[16] = {0};
	WEB_DEL_SMS_BY_TYPE  MSG_DEL_TYPE_ST;
	memset(&MSG_DEL_TYPE_ST, 0, sizeof(WEB_DEL_SMS_BY_TYPE));

	strncpy(strPage, websGetVar(wp, "which_page", T("")),sizeof(strPage)-1);
	if (0 == strcmp(strPage, "inbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_SIM;
		MSG_DEL_TYPE_ST.eBoxName = SMS_INBOX;
	} else if (0 == strcmp(strPage, "outbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_SIM;
		MSG_DEL_TYPE_ST.eBoxName = SMS_OUTBOX;
	} else if (0 == strcmp(strPage, "draftbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_SIM;
		MSG_DEL_TYPE_ST.eBoxName = SMS_DRAFTBOX;
	} else if (0 == strcmp(strPage, "me_inbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_ME;
		MSG_DEL_TYPE_ST.eBoxName =  SMS_INBOX;
	} else if (0 == strcmp(strPage, "me_outbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_ME;
		MSG_DEL_TYPE_ST.eBoxName =  SMS_OUTBOX;
	} else if (0 == strcmp(strPage, "me_draftbox")) {
		MSG_DEL_TYPE_ST.eLocation = SMS_LOCATION_ME;
		MSG_DEL_TYPE_ST.eBoxName = SMS_DRAFTBOX;
	}
	slog(MISC_PRINT, SLOG_NORMAL, "goform_sms_alldel_msg_process send message: MODULE_ID_SMS, MSG_CMD_DEL_SMS_BY_TYPE");/*lint !e26*/
	//ret = zte_send_message(MODULE_ID_SMS, MSG_CMD_DEL_SMS_BY_TYPE,sizeof(WEB_DEL_SMS_BY_TYPE),(UCHAR *)&MSG_DEL_TYPE_ST);  /*lint !e26 !e55*/
	ret = ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_SMS, MSG_CMD_DEL_SMS_BY_TYPE, sizeof(WEB_DEL_SMS_BY_TYPE), (UCHAR *)&MSG_DEL_TYPE_ST, 0);
	if (0 != ret) {
		zte_write_result_to_web(wp, FAILURE);
		WebSms_LOG(LOG_ERR, "Delete all the message to sms failed(send msg)\n");/*lint !e26*/
		return;
	}
	zte_write_result_to_web(wp, SUCCESS);
}
void zte_sms_set_message_center(webs_t wp)
{
	T_zUfiSms_ParaInfo sms_setting_st;
	char_t *sms_center_number = NULL;
	char_t *mem_store = NULL;
	char_t *validity_period = NULL;
	char_t *status_report = NULL;
	char_t *send_retry = NULL;
	char_t *outdate_delete = NULL;
	char_t *default_store = NULL;

	memset(&sms_setting_st, 0, sizeof(T_zUfiSms_ParaInfo));
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User set message center!\n"));

	sms_center_number = websGetVar(wp, "MessageCenter", T(""));
	mem_store = websGetVar(wp, "save_location", T(""));
	validity_period = websGetVar(wp, "save_time", T(""));
	status_report = websGetVar(wp, "status_save", T(""));
	send_retry = websGetVar(wp, "sendfail_retry", T(""));
	outdate_delete = websGetVar(wp, "outdate_delete", T(""));
	default_store = websGetVar(wp, "default_store", T(""));

	if (('\0' == (*sms_center_number)) || ('\0' == (*mem_store))
	    || ('\0' == (*validity_period)) || ('\0' == (*status_report))) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (('\0' != (*send_retry)) || ('\0' != (*outdate_delete))
	    || ('\0' != (*default_store))) {
		sms_setting_st.sendfail_retry_on = atoi(send_retry);       //open--->1;close--->0;
		sms_setting_st.outdate_delete_on = atoi(outdate_delete);       //open--->1;close--->0;
	}
	strncpy(sms_setting_st.default_store, default_store,sizeof(sms_setting_st.default_store)-1);

	strncpy(sms_setting_st.sca, sms_center_number,sizeof(sms_setting_st.sca)-1);
	sms_setting_st.status_report_on = atoi(status_report);        //open--->1;close--->0;
	slog(MISC_PRINT, SLOG_DEBUG, "sms_setting_st.sca=%s", sms_setting_st.sca); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sms_setting_st.status_report_on=%d", sms_setting_st.status_report_on); /*lint !e26*/

	if (!strcmp(mem_store, "native")) {                    //location of saving message
		sms_setting_st.mem_store = 1;
	} else if (!strcmp(mem_store, "sim_card")) {
		sms_setting_st.mem_store = 0;
	} else {
		slog(MISC_PRINT, SLOG_ERR,"sms_set_message_center: invalid mem_store.\n"); /*lint !e26*/
		sms_setting_st.mem_store = 1;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "sms_setting_st.mem_store=%d", sms_setting_st.mem_store); /*lint !e26*/

	if (0 == strcmp(validity_period, "twelve_hours")) { //according to 3GPP technical specification
		sms_setting_st.tp_validity_period = 143;
	} else if (0 == strcmp(validity_period, "one_day")) {
		sms_setting_st.tp_validity_period = 167;
	} else if (0 == strcmp(validity_period, "one_week")) {
		sms_setting_st.tp_validity_period = 173;
	} else if (0 == strcmp(validity_period, "largest")) {
		sms_setting_st.tp_validity_period = 255;
	} else if (0 == strcmp(validity_period, "cdma_largest")) {
		sms_setting_st.tp_validity_period = 244;
	} else {
		slog(MISC_PRINT, SLOG_ERR, "sms_set_message_center: invalid validity_period.\n"); /*lint !e26*/
		sms_setting_st.tp_validity_period = 255;
	}

	slog(MISC_PRINT, SLOG_DEBUG, " sms_setting_st.tp_validity_period=%d", sms_setting_st.tp_validity_period); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "sms_set_message_center:The center number is:[%s].\n", sms_setting_st.sca); /*lint !e26*/

	/* mc interface */
	if (ZTE_MC_OK_S == zte_mc_relay_sms_set_parameter((T_zUfiSms_ParaInfo*)(&sms_setting_st))) {
		slog(MISC_PRINT, SLOG_NORMAL, "sms_set_message_center: send msg to mc success.\n"); /*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "sms_set_message_center: send msg to mc fail.\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}
	//zte_write_result_to_web(wp,SUCCESS);
}

/**********************************************************************
* Function:         zte_sms_view_msg_process
* Description:      to set the viewed msg as read
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2011/11/16    V1.0        chenyi       first version
**********************************************************************/

void zte_sms_view_msg_process(webs_t wp)
{
	char_t *msg_id = NULL;
	char_t *tag = NULL;
	T_zUfiSms_ModifyFlag modify_tag_ptr;

	unsigned int total_id = 0;
	unsigned char id[WMS_MODULE_ID_LEN] = {0};
	int i = 0;
	int index = 0;

	memset(&modify_tag_ptr, 0, sizeof(T_zUfiSms_ModifyFlag));

	/* get value from web */
	msg_id = websGetVar(wp, "msg_id", T(""));
	tag = websGetVar(wp, "tag", T(""));

	if (('\0' == (*msg_id)) || ('\0' == (*tag))) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	modify_tag_ptr.tags = (unsigned char)atoi(tag);
	//parse id list
	for (i = 0; i < strlen(msg_id); i++) {
		if (';' == msg_id[i]) {
			if (total_id < (sizeof(modify_tag_ptr.id) / sizeof(unsigned long))) {
				modify_tag_ptr.id[total_id] = atoi(id);
			}
			total_id++;
			index = 0;
			memset(id, 0, sizeof(id)); //reset
			continue;
		}

		if (index < (sizeof(id) - 1)) {
			id[index++] = msg_id[i];
		}
	}

	modify_tag_ptr.total_id = total_id;

	slog(MISC_PRINT, SLOG_DEBUG, " modify_tag_ptr.tags=%d", modify_tag_ptr.tags); /*lint !e26*/
	slog(MISC_PRINT, SLOG_DEBUG, "  modify_tag_ptr.total_id =%d",  modify_tag_ptr.total_id); /*lint !e26*/

#if 0
	//msg print
	for (i = 0 ; i < total_id; i++) {
		WebSms_LOG(LOG_INFO, "view msg id[%d]= [%lu]\n", i, modify_tag_ptr.id[i]); /*lint !e26*/
	}

	WebSms_LOG(LOG_INFO, "view msg:tag[%c],total_id[%lu]\n", modify_tag_ptr.tags, modify_tag_ptr.total_id); /*lint !e26*/

	WebSms_LOG(LOG_INFO, "view size:[%d]", (sizeof(modify_tag_ptr.id) / sizeof(unsigned long))); /*lint !e26*/
#endif

	if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
		modify_tag_ptr.type = 1;
	} else {
		modify_tag_ptr.type = 0;
	}
	/* mc interface */
	if (ZTE_MC_OK_S == zte_mc_relay_sms_modify_tag(&modify_tag_ptr)) {
		slog(MISC_PRINT, SLOG_NORMAL, "web_sms:Send message to mc successful!(view message)\n"); /*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "web_sms:Send message to mc fail!(view message)\n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}

	//zte_write_result_to_web(wp,SUCCESS);
}

/**********************************************************************
* Function:         zte_get_sms_data
* Description:      to get the sms data info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

void zte_get_sms_data(webs_t wp)
{
	zte_sms_query_req sms_query_req;
	zte_sms_query_result *p_sms_query_result = NULL;
	int result = 0;
	int i = 0;
	char_t *page = NULL;
	char_t *data_per_page = NULL;
	char_t *mem_store = NULL;
	char_t *tags = NULL;
	char_t *order_by = NULL;
	T_zUfiSms_ModifyFlag modify_tag_ptr;
	int  index = 0;
	memset(&modify_tag_ptr, 0, sizeof(T_zUfiSms_ModifyFlag));
	memset(&sms_query_req, 0, sizeof(zte_sms_query_req));

	page = websGetVar(wp, "page", T(""));
	data_per_page = websGetVar(wp, "data_per_page", T(""));
	mem_store = websGetVar(wp, "mem_store", T(""));
	tags = websGetVar(wp, "tags", T(""));
	order_by = websGetVar(wp, "order_by", T(""));

	if (('\0' == *page) || ('\0' == *data_per_page) || ('\0' == *mem_store) || ('\0' == *tags) || ('\0' == *order_by)) {
		slog(MISC_PRINT, SLOG_ERR, "get_sms_data: invalid input.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

#if 0 // kw 3
	sms_query_req.page = (uint8)atoi(page);
#else
    int temp_page = atoi(page);
	if(temp_page > 255 || temp_page < 0){
		return;
	}

	sms_query_req.page = temp_page;
#endif
	
	int tmp_data_per_page = atoi(data_per_page);
	if(tmp_data_per_page > 255 || tmp_data_per_page < 0)
		return;
	sms_query_req.data_per_page = (uint8)tmp_data_per_page;

	sms_query_req.mem_store = (uint8)atoi(mem_store);
	sms_query_req.tags = (uint8)atoi(tags);
	//sms_query_req.order_by = (uint8)atoi(order_by);
	strncpy(sms_query_req.order_by, order_by, sizeof(sms_query_req.order_by) - 1);

	slog(MISC_PRINT, SLOG_DEBUG, "sms_query_req:[%u,%u,%u,%u,%s].\n", sms_query_req.page, sms_query_req.data_per_page, sms_query_req.mem_store, \
	           sms_query_req.tags, sms_query_req.order_by); /*lint !e26*/

	//handle special condition:if the @data_per_page is 0
	if (0 == sms_query_req.data_per_page) {
		slog(MISC_PRINT, SLOG_ERR,"to get 0 sms record.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	p_sms_query_result = (zte_sms_query_result*)malloc(4 + sizeof(zte_sms_data) * (sms_query_req.data_per_page));
	if (NULL == p_sms_query_result) {
		slog(MISC_PRINT, SLOG_ERR, "malloc sms result mem fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	//reset,which is important
	memset(p_sms_query_result, 0, 4 + sizeof(zte_sms_data) * (sms_query_req.data_per_page));

	slog(MISC_PRINT, SLOG_NORMAL, "SMS_DATA GET DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libwms_get_sms_data(&sms_query_req, p_sms_query_result);
	slog(MISC_PRINT, SLOG_DEBUG, "SMS_DATA GET DATA FROM DB END.\n"); /*lint !e26*/

	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call wms_db_get_sms_data fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		//free
//		if (NULL != p_sms_query_result) {   // kw 3
			free(p_sms_query_result);
			p_sms_query_result = NULL;
//		}
		return ;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "total query count [%u].\n", (*p_sms_query_result).count); /*lint !e26*/

	if (0 == (*p_sms_query_result).count) {
		zte_web_feed_back_empty(wp);
		//free
//		if (NULL != p_sms_query_result) {  // kw 3
			free(p_sms_query_result);
			p_sms_query_result = NULL;
//		}
		return ;
	}
	//write the sms data to web
	for (i = 0; i < (*p_sms_query_result).count; i++) {
		if (0 == i) {
			web_feedback_header(wp);
			zte_rest_get_sms_data_head(wp);
			zte_rest_get_sms_data(wp, p_sms_query_result, i, 0);
#if 0
			(void)websWrite(wp, T("{\"%s\":[{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\",\"%s\":\"%s\"}"), SMS_MESSAGES, SMS_ID, \
			                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
			                SMS_TAG, (*p_sms_query_result).data[i].tag, \
			                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
			                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
			                (*p_sms_query_result).data[i].date.timezone, SMS_DRAFT_GROUP_ID, (*p_sms_query_result).data[i].draft_group_id);
#endif
		} else {
			zte_rest_get_sms_data(wp, p_sms_query_result, i, 1);
#if 0
			(void)websWrite(wp, T(",{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\",\"%s\":\"%s\"}"), SMS_ID, \
			                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
			                SMS_TAG, (*p_sms_query_result).data[i].tag, \
			                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
			                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
			                (*p_sms_query_result).data[i].date.timezone, SMS_DRAFT_GROUP_ID, (*p_sms_query_result).data[i].draft_group_id);
#endif
		}
		/*
			    if(sms_query_req.mem_store == 0 && atoi(p_sms_query_result->data[i].tag) == 1)
			    {
			        modify_tag_ptr.id[index] = atoi(p_sms_query_result->data[i].id);
			        modify_tag_ptr.total_id ++;
			        index ++;
			    }
		*/
	}
	/*
	        if(sms_query_req.mem_store == 0 && modify_tag_ptr.total_id > 0)
		    {
		        modify_tag_ptr.tags = 0;
		        zte_mc_relay_sms_modify_tag(&modify_tag_ptr);
		    }
	*/
	zte_rest_get_sms_data_foot(wp);
	//(void)websWrite(wp, T("]}"));

	//free
//	if (NULL != p_sms_query_result) {  // kw 3
		free(p_sms_query_result);
		p_sms_query_result = NULL;
//	}
}

/**********************************************************************
* Function:         zte_get_sms_data_total
* Description:      to get the total sms
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

void zte_get_sms_data_total(webs_t wp)
{
	zte_sms_query_req sms_query_req;
	zte_sms_query_result *p_sms_query_result = NULL;
	int result = 0;
	int i = 0;
	char_t *page = NULL;
	char_t *data_per_page = NULL;
	char_t *mem_store = NULL;
	char_t *tags = NULL;
	char_t *order_by = NULL;

	int idata_per_page = 0;

	int total_pages = 0;
	int leave_nums = 0;
	int curr_page = 0;
	int total_sms = 0;
	T_zUfiSms_ModifyFlag modify_tag_ptr;
	int  index = 0;
	memset(&sms_query_req, 0, sizeof(zte_sms_query_req));

	page = websGetVar(wp, "page", T(""));
	data_per_page = websGetVar(wp, "data_per_page", T(""));
	mem_store = websGetVar(wp, "mem_store", T(""));
	tags = websGetVar(wp, "tags", T(""));
	order_by = websGetVar(wp, "order_by", T(""));

	if (('\0' == *page) || ('\0' == *data_per_page) || ('\0' == *mem_store) || ('\0' == *tags) || ('\0' == *order_by)) {
		slog(MISC_PRINT, SLOG_ERR, "get_sms_data: invalid input.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}
#if 0
	//calculate the total pages
	total_pages = (atoi(data_per_page)) / SMS_READ_RECORD_MAX_NUM;
	leave_nums = (atoi(data_per_page)) % SMS_READ_RECORD_MAX_NUM;

	if (0 != leave_nums) {
		total_pages++;
	}

#else
	idata_per_page = atoi(data_per_page);
	if(idata_per_page < 0 || idata_per_page >  INT_MAX-1)
	{
	    total_pages = 1;
		leave_nums = 0;
	}
	else
	{
    	//calculate the total pages
    	total_pages = idata_per_page / SMS_READ_RECORD_MAX_NUM;
    	leave_nums = idata_per_page % SMS_READ_RECORD_MAX_NUM;
    
    	if (0 != leave_nums) {
    		total_pages++;
    	}
	}
#endif	

	slog(MISC_PRINT, SLOG_DEBUG, "total_pages,leave_nums:[%d][%d]", total_pages, leave_nums); /*lint !e26*/

	p_sms_query_result = (zte_sms_query_result*)malloc(4 + sizeof(zte_sms_data) * SMS_READ_RECORD_MAX_NUM);
	if (NULL == p_sms_query_result) {
		slog(MISC_PRINT, SLOG_ERR, "malloc sms result mem fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	for (curr_page = 0; curr_page < total_pages; curr_page++) {

		//reset
		index = 0;
		memset(&modify_tag_ptr, 0, sizeof(T_zUfiSms_ModifyFlag));
		memset(&sms_query_req, 0, sizeof(zte_sms_query_req));
		sms_query_req.page = curr_page;
#if 0
		if (((total_pages - 1) == curr_page) && (0 != leave_nums)) {
			sms_query_req.data_per_page = leave_nums;//last page
		} else {
			sms_query_req.data_per_page = SMS_READ_RECORD_MAX_NUM;
		}
#endif
		sms_query_req.data_per_page = SMS_READ_RECORD_MAX_NUM;
		sms_query_req.mem_store = (uint8)atoi(mem_store);
		sms_query_req.tags = (uint8)atoi(tags);
		//sms_query_req.order_by = (uint8)atoi(order_by);
		strncpy(sms_query_req.order_by, order_by, sizeof(sms_query_req.order_by) - 1);

		slog(MISC_PRINT, SLOG_DEBUG, "sms_query_req:[%u,%u,%u,%u,%s].\n", sms_query_req.page, sms_query_req.data_per_page, sms_query_req.mem_store, \
		           sms_query_req.tags, sms_query_req.order_by); /*lint !e26*/

		//reset,which is important
		memset(p_sms_query_result, 0, 4 + sizeof(zte_sms_data)*SMS_READ_RECORD_MAX_NUM);

		slog(MISC_PRINT, SLOG_NORMAL, "SMS_DATA_TOTAL GET DATA FROM DB START.\n"); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "curr_page[%d]", sms_query_req.page); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "total_sms[%d]", total_sms); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, " atoi(data_per_page)=%d", atoi(data_per_page)); /*lint !e26*/

		result = zte_libwms_get_sms_data(&sms_query_req, p_sms_query_result);

		slog(MISC_PRINT, SLOG_DEBUG, "SMS_DATA_TOTAL GET DATA FROM DB END.\n"); /*lint !e26*/

		if (-1 == result) {
			WebSms_LOG(LOG_DEBUG, "read sms page [%d] fail.\n", curr_page); /*lint !e26*/
			//free
//			if (NULL != p_sms_query_result) {  // kw 3
				free(p_sms_query_result);
				p_sms_query_result = NULL;
//			}

			if (0 == curr_page) {
				zte_web_feed_back_empty(wp);
				return ;
			} else {
				break;
			}
		}

		slog(MISC_PRINT, SLOG_DEBUG, "total query count [%u].\n", (*p_sms_query_result).count); /*lint !e26*/

		if (0 == (*p_sms_query_result).count) {
			//free
//			if (NULL != p_sms_query_result) {   // kw 3
				free(p_sms_query_result);
				p_sms_query_result = NULL;
//			}

			if (0 == curr_page) {
				zte_web_feed_back_empty(wp);
				return ;
			} else {
				break;
			}
		}

		//write the sms data to web
		for (i = 0; (i < (*p_sms_query_result).count) && (total_sms < atoi(data_per_page)); i++) {
			if ((0 == i) && (0 == curr_page)) {
				web_feedback_header(wp);
				zte_rest_get_sms_data_head(wp);
				zte_rest_get_sms_data(wp, p_sms_query_result, i, 0);
#if 0
				(void)websWrite(wp, T("{\"%s\":[{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\",\"%s\":\"%s\"}"), SMS_MESSAGES, SMS_ID, \
				                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
				                SMS_TAG, (*p_sms_query_result).data[i].tag, \
				                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
				                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
				                (*p_sms_query_result).data[i].date.timezone, SMS_DRAFT_GROUP_ID, (*p_sms_query_result).data[i].draft_group_id);
				total_sms ++;
#endif
			} else {
				zte_rest_get_sms_data(wp, p_sms_query_result, i, 1);
#if 0
				(void)websWrite(wp, T(",{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\",\"%s\":\"%s\"}"), SMS_ID, \
				                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
				                SMS_TAG, (*p_sms_query_result).data[i].tag, \
				                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
				                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
				                (*p_sms_query_result).data[i].date.timezone, SMS_DRAFT_GROUP_ID, (*p_sms_query_result).data[i].draft_group_id);
				total_sms ++;
#endif
			}
			/*
				        if(sms_query_req.mem_store == 0 && atoi(p_sms_query_result->data[i].tag) == 1)
				        {
				            modify_tag_ptr.id[index] = atoi(p_sms_query_result->data[i].id);
			                modify_tag_ptr.total_id ++;
				            index ++;
				        }
			*/
		}
		/*
		        if(sms_query_req.mem_store == 0 && modify_tag_ptr.total_id > 0
					&& !(wp->flags & WEBS_XML_CLIENT_REQUEST))
			    {
			        modify_tag_ptr.tags = 0;
			        zte_mc_relay_sms_modify_tag(&modify_tag_ptr);
			    }
		*/
	}
	zte_rest_get_sms_data_foot(wp);
	//(void)websWrite(wp, T("]}"));

	//free
//	if (NULL != p_sms_query_result) {  // kw 3
		free(p_sms_query_result);
		p_sms_query_result = NULL;
//	}
}

/**********************************************************************
* Function:         zte_get_sms_parameter_info
* Description:      to get the sms parameter info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

void zte_get_sms_parameter_info(webs_t wp)
{
	T_zUfiSms_ParaInfo sms_parameter_info;
	int result = 0;

	memset(&sms_parameter_info, 0, sizeof(T_zUfiSms_ParaInfo));

	slog(MISC_PRINT, SLOG_NORMAL, "SMS_PARAMETER_INFO GET DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libwms_get_parameter(&sms_parameter_info);
	slog(MISC_PRINT, SLOG_DEBUG, "SMS_PARAMETER_INFO GET DATA FROM DB END.\n"); /*lint !e26*/
	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libwms_get_parameter fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	web_feedback_header(wp);
	zte_rest_sms_parameter(wp, sms_parameter_info);
#if 0
	(void)websWrite(wp, T("{\"%s\":\"%s\",\"%s\":\"%d\",\"%s\":\"%u\",\"%s\":\"%u\"}"), SMS_PARAMETER_SCA, sms_parameter_info.sca, SMS_PARAMETER_MEM_STORE, sms_parameter_info.mem_store, \
	                SMS_PARAMETER_VALIDITY_PERIOD, sms_parameter_info.tp_validity_period, \
	                SMS_PARAMETER_STATUS_REPORT, sms_parameter_info.status_report_on);
#endif
}


/**********************************************************************
* Function:         zte_get_sms_cmd_status_info
* Description:      to get the sms cmd status info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

void zte_get_sms_cmd_status_info(webs_t wp)
{
	T_zUfiSms_StatusInfo cmd_status_info;
	int result = 0;
	char *sms_cmd = NULL;

	memset(&cmd_status_info, 0, sizeof(T_zUfiSms_StatusInfo));

	//read sms_cmd
	sms_cmd = websGetVar(wp, "sms_cmd", T(""));
	if ('\0' == *sms_cmd) {
		slog(MISC_PRINT, SLOG_ERR, "sms_cmd is empty.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	/*lint -e64*/
	int cmd = atoi(sms_cmd);
	if(cmd >= WMS_SMS_CMD_NONE && cmd <= WMS_SMS_CMD_WMS_MAX){
		cmd_status_info.cmd = (T_zUfiSms_CmdType)cmd;
	} else {
		slog(MISC_PRINT, SLOG_ERR, "sms_cmd is %d.\n",cmd);
		zte_web_feed_back_empty(wp);
		return ;
	}
		
	slog(MISC_PRINT, SLOG_NORMAL, "sms_cmd_status_info GET DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libwms_get_cmd_status(&cmd_status_info);
	slog(MISC_PRINT, SLOG_DEBUG, "sms_cmd_status_info GET DATA FROM DB END.\n"); /*lint !e26*/
	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libwms_get_cmd_status fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	zte_rest_cmd_write(wp, SMS_CMD, sms_cmd, 1);
	zte_rest_cmd_write_int(wp, SMS_CMD_STATUS_RESULT, cmd_status_info.cmd_status, 0);
	zte_rest_cmd_write_foot(wp);
	//(void)websWrite(wp, T("{\"%s\":\"%s\",\"%s\":\"%d\"}"),SMS_CMD,sms_cmd,SMS_CMD_STATUS_RESULT,cmd_status_info.cmd_status);
}


int  zte_get_sms_remain_capacity()
{
	int sms_remain = 0;
	int sms_nv_total = 0;
	int sms_sim_total = 0;
	int sms_nv_rev_total = 0;
	int sms_nv_send_total = 0;
	int sms_nv_draftbox_total = 0;
	char default_store[NV_ITEM_STRING_LEN_10] = {0};

	sc_cfg_get("default_store", default_store, sizeof(default_store));
	if (0 == strcmp(default_store, "sim")) {
		sms_sim_total = zte_libwms_get_sms_capability(0);//sim
		//洢Զμ㣬޷ͳ
		//¶Ŵ洢ڿ࣬ôͲж
		//˴ֵΪ10ڵñʱжϵ5
		//ռǷܽУ׼ŵж
		//Эջжϴ
		sms_remain = 10;
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] get_sms_remain_capacity, default_store = %s, total = %d!\n", default_store, sms_sim_total);
	} else {
		sms_nv_total = zte_libwms_get_sms_capability(1);//nv
		sms_nv_rev_total = zte_libwms_get_sms_used(1, 0); //nv rev read
		sms_nv_rev_total += zte_libwms_get_sms_used(1, 1); //nv rev not read
		sms_nv_send_total = zte_libwms_get_sms_used(1, 2); //nv send
		sms_nv_draftbox_total = zte_libwms_get_sms_used(1, 3); //nv draftbox 1,not send
		sms_nv_draftbox_total += zte_libwms_get_sms_used(1, 4); //nv draftbox 2,write

		if(sms_nv_total < 0 || sms_nv_total > INT_MAX -1){
            sms_nv_total = INT_MAX;
		}

		sms_remain = sms_nv_total - sms_nv_rev_total - sms_nv_send_total - sms_nv_draftbox_total;
		slog(MISC_PRINT, SLOG_DEBUG,"[traffic] get_sms_remain_capacity, default_store = %s, total = %d, rev= %d, send= %d, draft= %d!\n", default_store, sms_nv_total, sms_nv_rev_total, sms_nv_send_total, sms_nv_draftbox_total);
	}
	slog(MISC_PRINT, SLOG_DEBUG,"[traffic] get_sms_remain_capacity, default_store = %s, sms_remain = %d!\n", default_store, sms_remain);
	return sms_remain;
}


/**********************************************************************
* Function:         zte_get_sms_capacity_info
* Description:      to get the sms capacity info
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

void zte_get_sms_capacity_info(webs_t wp)
{
	int sms_nv_total = 0;
	int sms_sim_total = 0;

	//int sms_nv_used = 0;
	//int sms_sim_used = 0;

	int sms_nv_rev_total = 0;
	int sms_nv_send_total = 0;
	int sms_nv_draftbox_total = 0;
	int sms_sim_rev_total = 0;
	int sms_sim_send_total = 0;
	int sms_sim_draftbox_total = 0;

	//WebSms_LOG(LOG_INFO,"sms_capacity_info GET DATA FROM DB START.\n");


	sms_nv_total = zte_libwms_get_sms_capability(1);//nv
	sms_sim_total = zte_libwms_get_sms_capability(0);//sim

	sms_nv_rev_total = zte_libwms_get_sms_used(1, 0); //nv rev read
	sms_nv_rev_total += zte_libwms_get_sms_used(1, 1); //nv rev not read
	sms_nv_send_total = zte_libwms_get_sms_used(1, 2); //nv send
	sms_nv_draftbox_total = zte_libwms_get_sms_used(1, 3); //nv draftbox 1,not send
	sms_nv_draftbox_total += zte_libwms_get_sms_used(1, 4); //nv draftbox 2,write

	sms_sim_rev_total = zte_libwms_get_sms_used(0, 0); //sim rev read
	sms_sim_rev_total += zte_libwms_get_sms_used(0, 1); //sim rev not read
	sms_sim_send_total = zte_libwms_get_sms_used(0, 2); //sim send
	sms_sim_draftbox_total = zte_libwms_get_sms_used(0, 3); //sim draftbox 1,not send
	sms_sim_draftbox_total += zte_libwms_get_sms_used(0, 4); //sim draftbox 2,write

	//WebSms_LOG(LOG_INFO,"sms_capacity_info GET DATA FROM DB END.\n");/*lint !e26*/

	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	zte_rest_cmd_write_int(wp, SMS_NV_TOTAL, sms_nv_total, 1);
	zte_rest_cmd_write_int(wp, SMS_SIM_TOTAL, sms_sim_total, 1);
	zte_rest_cmd_write_int(wp, SMS_NV_REV_TOTAL, sms_nv_rev_total, 1);
	zte_rest_cmd_write_int(wp, SMS_NV_SEND_TOTAL, sms_nv_send_total, 1);
	zte_rest_cmd_write_int(wp, SMS_NV_DRAFTBOX_TOTAL, sms_nv_draftbox_total, 1);
	zte_rest_cmd_write_int(wp, SMS_SIM_REV_TOTAL, sms_sim_rev_total, 1);
	zte_rest_cmd_write_int(wp, SMS_SIM_SEND_TOTAL, sms_sim_send_total, 1);
	zte_rest_cmd_write_int(wp, SMS_SIM_DRAFTBOX_TOTAL, sms_sim_draftbox_total, 0);
	zte_rest_cmd_write_foot(wp);

	sc_cfg_set("sms_db_change", "0");
	slog(MISC_PRINT, SLOG_DEBUG, "nv  set sms_db_change=0.\n"); /*lint !e26*/
#if 0
	(void)websWrite(wp, T("{\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\"}"), \
	                SMS_NV_TOTAL, sms_nv_total, SMS_SIM_TOTAL, sms_sim_total, \
	                SMS_NV_REV_TOTAL, sms_nv_rev_total, SMS_NV_SEND_TOTAL, sms_nv_send_total, SMS_NV_DRAFTBOX_TOTAL, sms_nv_draftbox_total, \
	                SMS_SIM_REV_TOTAL, sms_sim_rev_total, SMS_SIM_SEND_TOTAL, sms_sim_send_total, SMS_SIM_DRAFTBOX_TOTAL, sms_sim_draftbox_total \
	               );
#endif
}

/**********************************************************************
* Function:         zte_get_sms_status_rpt_data
* Description:      to get the sms status report data
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/
void zte_get_sms_status_rpt_data(webs_t wp)
{
	zte_sms_query_req sms_query_req;
	zte_sms_query_result *p_sms_query_result = NULL;
	int result = 0;
	int i = 0;
	char_t *page = NULL;
	char_t *data_per_page = NULL;

	memset(&sms_query_req, 0, sizeof(zte_sms_query_req));

	page = websGetVar(wp, "page", T(""));
	data_per_page = websGetVar(wp, "data_per_page", T(""));

	if (('\0' == *page) || ('\0' == *data_per_page)) {
		slog(MISC_PRINT, SLOG_ERR, "get_sms_data: invalid input.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}
	int tmp_page = atoi(page);
	int tmp_data_per_page = atoi(data_per_page);
	if((tmp_page > 255 || tmp_page < 0)
		||(tmp_data_per_page > 255 || tmp_data_per_page < 0)){
		slog(MISC_PRINT, SLOG_ERR, "sms_query_req:err[%d,%d].\n", tmp_page, tmp_data_per_page); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}
	sms_query_req.page = (uint8)tmp_page;
	sms_query_req.data_per_page = (uint8)tmp_data_per_page;

	slog(MISC_PRINT, SLOG_DEBUG, "sms_query_req:[%u,%u].\n", sms_query_req.page, sms_query_req.data_per_page); /*lint !e26*/

	p_sms_query_result = (zte_sms_query_result*)malloc(1 + sizeof(zte_sms_data) * (sms_query_req.data_per_page));
	if (NULL == p_sms_query_result) {
		slog(MISC_PRINT, SLOG_ERR, "malloc sms result mem fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		return ;
	}

	//reset,which is important
	memset(p_sms_query_result, 0, 1 + sizeof(zte_sms_data) * (sms_query_req.data_per_page));
	slog(MISC_PRINT, SLOG_NORMAL, "sms_status_rpt_data GET DATA FROM DB START.\n"); /*lint !e26*/
	result = zte_libwms_get_sms_report(&sms_query_req, p_sms_query_result);
	slog(MISC_PRINT, SLOG_DEBUG, "sms_status_rpt_data GET DATA FROM DB END.\n"); /*lint !e26*/
	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libwms_get_sms_report fail.\n"); /*lint !e26*/
		zte_web_feed_back_empty(wp);
		//free
//		if (NULL != p_sms_query_result) {  // kw 3
			free(p_sms_query_result);
		    p_sms_query_result =  NULL;
//		}
		return ;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "total query count for status rpt: [%u].\n", (*p_sms_query_result).count); /*lint !e26*/

	if (0 == (*p_sms_query_result).count) {
		zte_web_feed_back_empty(wp);
		//free
//		if (NULL != p_sms_query_result) {  // kw 3
			free(p_sms_query_result);
		    p_sms_query_result = NULL;
//		}
		return ;
	}
	//write the sms data to web
	for (i = 0; i < (*p_sms_query_result).count; i++) {
		if (0 == i) {
			web_feedback_header(wp);
			zte_rest_get_sms_data_head(wp);
			zte_rest_sms_status_rpt(wp, p_sms_query_result, i, 0);
#if 0
			(void)websWrite(wp, T("{\"%s\":[{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\"}"), SMS_MESSAGES, SMS_ID, \
			                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
			                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
			                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
			                (*p_sms_query_result).data[i].date.timezone);
#endif

		} else {
			zte_rest_sms_status_rpt(wp, p_sms_query_result, i, 1);
#if 0
			(void)websWrite(wp, T(",{\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s\",\"%s\":\"%s,%s,%s,%s,%s,%s,%s\"}"), SMS_ID, \
			                (*p_sms_query_result).data[i].id, SMS_NUMBER, (*p_sms_query_result).data[i].number, SMS_CONTENT, (*p_sms_query_result).data[i].sms_content, \
			                SMS_DATE, (*p_sms_query_result).data[i].date.year, (*p_sms_query_result).data[i].date.month, (*p_sms_query_result).data[i].date.day, \
			                (*p_sms_query_result).data[i].date.hour, (*p_sms_query_result).data[i].date.min, (*p_sms_query_result).data[i].date.sec, \
			                (*p_sms_query_result).data[i].date.timezone);
#endif

		}
	}
	zte_rest_get_sms_data_foot(wp);
	//(void)websWrite(wp, T("]}"));

	//free
//	if (NULL != p_sms_query_result) {  // kw 3
		free(p_sms_query_result);
	    p_sms_query_result = NULL;
//	}
}

/**********************************************************************
* Function:         zte_get_sms_unread_count
* Description:      to get the unread sms count
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/
void zte_get_sms_unread_count(webs_t wp)
{
	int sms_dev_unread_count = 0;
	int sms_sim_unread_count = 0;
	slog(MISC_PRINT, SLOG_NORMAL, "sms_unread_count GET DATA FROM DB START.\n"); /*lint !e26*/
	sms_dev_unread_count = zte_libwms_get_sms_used(1, 1); //nv unread
	sms_sim_unread_count = zte_libwms_get_sms_used(0, 1); //sim unread
	slog(MISC_PRINT, SLOG_DEBUG, "sms_unread_count GET DATA FROM DB END.\n"); /*lint !e26*/


	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);

	if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
		zte_rest_cmd_write_int(wp, CMD_SMS_UNREAD_COUNT, sms_dev_unread_count, 0);
		zte_rest_cmd_write_int(wp, SMS_DEV_UNREAD_COUNT, sms_dev_unread_count, 1);
		zte_rest_cmd_write_int(wp, SMS_SIM_UNREAD_COUNT, sms_sim_unread_count, 0);
	} else {
		(void)websWrite(wp, T("\"%s\":\"%d\",\"%s\":\"%d\",\"%s\":\"%d\""), \
		                CMD_SMS_UNREAD_COUNT, sms_dev_unread_count, \
		                SMS_DEV_UNREAD_COUNT, sms_dev_unread_count, \
		                SMS_SIM_UNREAD_COUNT, sms_sim_unread_count);
	}

	zte_rest_cmd_write_foot(wp);

}

/**********************************************************************
* Function:         zte_get_sms_unread_num
* Description:      to get the unread sms num
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/
void zte_get_sms_unread_num(webs_t wp)
{
	int sms_dev_unread_count = 0;
	sms_dev_unread_count = zte_libwms_get_sms_used(1, 1); //nv unread

	if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
		zte_rest_cmd_write_int(wp, NV_SMS_UNREAD_NUM, sms_dev_unread_count, 0);
	} else {
		(void)websWrite(wp, T("\"%s\":\"%d\""), NV_SMS_UNREAD_NUM, sms_dev_unread_count);
	}
}

/**********************************************************************
* Function:         zte_web_feed_back_empty
* Description:      to write empty info to web
* Input:            the web para
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/03    V1.0        liuyingnan       first version
**********************************************************************/

static void zte_web_feed_back_empty(webs_t wp)
{
	if (NULL == wp) {
		return;
	}

	web_feedback_header(wp);
	if (wp->flags & WEBS_XML_CLIENT_REQUEST) {
		websWrite(wp, T("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"));
		websWrite(wp, T("<%s>empty</%s>\n"), SMS_MESSAGES, SMS_MESSAGES);
	} else {
		(void)websWrite(wp, T("{\"%s\":[]}"), SMS_MESSAGES);
	}

}

/******************************************************
* Function: parseStrBySeparator()
* Description: separate the string by a specific character
* Input:
* Output:
* Return: -1--->failed, 0--->successful
* Others:
* Modify Date    Version   Author         Modification
* 2010/10/27        V1.0     huangmin        create
2012/06/20        v2.0       chenyi             modify
*******************************************************/
static unsigned int parseStrBySeparator
(
    unsigned char* input,
    unsigned char* output,
    int destLen,
    unsigned char separator
)
{
	int i, j, k;
	int srcLen = 0;
	i = j = k = 0;

	if (NULL == input || NULL == output || destLen == 0 || strlen(input) == 0) {
		slog(MISC_PRINT, SLOG_ERR, "parseStrBySemicolon: param is null!\n"); /*lint !e26*/
		return 0;
	}

	srcLen = strlen(input) + 1;//which contains the '\0'

	for (i = 0; i < srcLen; i++) {
		if ('\0' == input[i]) {
			if (k <= (destLen - 1)) {
				*(output + destLen * j + k)  = '\0';
			} else {
				*(output + destLen * j + (destLen - 1))  = '\0';
			}

			return j + 1;
		}

		if (separator == input[i]) {
			if (k <= (destLen - 1)) {
				*(output + destLen * j + k)  = '\0';
			} else {
				*(output + destLen * j + (destLen - 1))  = '\0';
			}

			if ('\0' != input[i + 1]) {
				k = 0;
				j++;
			}
		} else {
			if (k < (destLen - 1)) {
				*(output + destLen * j + k)  = input[i];
				k++;
			}
		}
	}

	return j;
}

#if 0
/******************************************************
* Function: sms_util_asc_to_hex()
* Description: transform the ASCII string of SMS code to hex
* Input:
* Output:
* Return: -1--->failed, 0--->successful
* Others:
* Modify Date    Version   Author         Modification
* 2010/10/27        V1.0     huangmin        create
*******************************************************/
static int  sms_util_asc_to_hex                 /*lint !e528*/
(
    unsigned char  *in_ptr,    	/* IN: Pointer to the Hex data (in ASCII format)    */
    unsigned char  *out_ptr,   /* OUT: Pointer to the result buffer(converted data) */
    int   len                       	/* IN: Length of the input data pointer (Hex data)  */
)
{
	unsigned char *str;
	unsigned char temp_buf[3];
	int i;
	unsigned int num_val;
	int result = 0;

	str = in_ptr;

	len = len * 2;

	//WebSms_LOG(LOG_INFO,"in sms_util_asc_to_hex\n");/*lint !e26*/
	while (len > 0) {
		for (i = 0; (i < 2) && (*str != '\0'); i++) {
			temp_buf[i] = *str++;
		}
		temp_buf[i] = '\0';
		if (asc_util_atoi(&num_val, temp_buf, 16) != 0) {
			/* We got a out of range value */
			result = -1;
		}
		*out_ptr++ = (unsigned char)num_val;
		// WebSms_LOG(LOG_INFO,"goahead=====middle===out_ptr===%s",out_ptr);/*lint !e26*/
		len -= i;
	}
	WebSms_LOG(LOG_INFO, "leave sms_util_asc_to_hex\n"); /*lint !e26*/

	return result;
} /* ZTE_dsat707sms_asscii_to_is637_data */


/******************************************************
* Function: asc_util_atoi()
* Description: transform the ASCII string to integer
* Input:
* Output:
* Return: -1--->failed, 0--->successful
* Others:
* Modify Date    Version   Author         Modification
* 2010/10/27        V1.0     huangmin        create
*******************************************************/
static int asc_util_atoi
(
    unsigned int *val_arg_ptr,      /*  value returned  */
    const unsigned char *s,                        /*  points to string to eval  */
    unsigned int r                        /*  radix */
)
{
	int err_ret = 0;
	unsigned char c;
	unsigned int val, val_lim, dig_lim;

	val = 0;
	val_lim = (unsigned int)((unsigned int)0xFFFFFFFF / r);
	dig_lim = (unsigned int)((unsigned int)0xFFFFFFFF % r);

	while ((c = *s++) != '\0') {
		if (c != ' ') {
			c = (unsigned char) UPCASE(c);
			if (c >= '0' && c <= '9') {
				c -= '0';
			} else if (c >= 'A') {
				c -= 'A' - 10;
			} else {
				err_ret = -1;  /*  char code too small */
				break;
			}

			if (c >= r || val > val_lim
			    || (val == val_lim && c > dig_lim)) {
				err_ret = -1;  /*  char code too large */
				break;
			} else {
				err_ret = 0;            /*  arg found: OK so far*/
				val = (unsigned int)(val * r + c);
			}
		}
		*val_arg_ptr =  val;
	}

	return err_ret;
}
#endif
void zte_get_boradcast_data(webs_t wp)
{
	zte_wms_cell_bro_s_type *p_bro_query_result = NULL;

	int result = 0;

	slog(MISC_PRINT, SLOG_NORMAL, "get_boradcast_data GET DATA FROM DB START.\n");
	p_bro_query_result = (zte_wms_cell_bro_s_type*)malloc(1 + sizeof(zte_wms_cell_bro_s_type));
	if(p_bro_query_result == NULL) return;
	result = zte_libwms_get_cell_bro(p_bro_query_result);

	slog(MISC_PRINT, SLOG_DEBUG, "get_boradcast_data GET DATA FROM DB END.\n");
	if (-1 == result) {
		slog(MISC_PRINT, SLOG_ERR, "call libwms_get_cell_bro fail.\n");
		zte_web_feed_back_empty(wp);
		//cov
		free(p_bro_query_result);
		p_bro_query_result = NULL;
		return ;
	}
	web_feedback_header(wp);
	zte_rest_get_bro_data_head(wp);
	zte_rest_boradcast_data(wp, p_bro_query_result);
	zte_rest_get_bro_data_foot(wp);




	//if (NULL != p_bro_query_result) {
		free(p_bro_query_result);
		p_bro_query_result = NULL;
	//}

}
