/**
 * @file at_ctl.c
 * @brief at_ctlݣ漰at_ctlĳʼ̶߳ԲͬģϢľ崦
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_context.h"
#include "at_register.h"
#include "recv_thread.h"
#include "softap_api.h"
#include "at_netdog.h"
#include "ps_pdp.h"
#include "at_zephyr.h"
#include "ref_nv_def.h"
#include "RONvParam_AMT.h"
#include "nv_api.h"
#include "atreg_msg.h"
#ifndef HAVE_MODE_IN_CORE
#include "syncnv.h"
#endif
#ifdef _USE_BL
#include "zbl_ati_cc_msg.h"
#include "zbl_ati_ss_msg.h"
#include "zbl_ati_sms_msg.h"
#include "zbl_ati_mm_msg.h"
#include "zbl_ext_msg.h"
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

#define bInside(data, up, down)             (((data) <= (up) && (data) >= (down)) || \
                                                               ((data) >= (up) && (data) <= (down)))
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static int ctl_recv_thread_create(void);
static int rcv_serv_rsp_msg_proc(MSG_BUF *msg_buf);
static int ctl_appsoc_proc(MSG_BUF *msg_buf);
extern int proc_at_port_hotplug(MSG_BUF *msg_buf);
extern int add_one_cache_msg(MSG_BUF *msg);
extern int user_special_msg_proc(MSG_BUF *msg_buf);
extern int user_server_is_special_cmd(char *at_cmd);
extern int rcv_timeout_msg_proc(MSG_BUF *msg_buf);
extern T_ZDrvSys_PowerOn_Type g_powerOnType;
extern void recv_mainloop_farps(void);
extern void at_comm_init(void);
extern char PsmIndAtCmdPrefix[AT_CMD_MAX];
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/

/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
unsigned int private_cpe_msgid[] =
{
MSG_CMD_ATD_DIAL_REQ,
MSG_CMD_ATA_REQ,
MSG_CMD_CHUP_REQ,
MSG_CMD_VTS_REQ,		
MSG_CMD_ZIMSPLUS_REQ,	
MSG_CMD_CHLD_REQ,		
MSG_CMD_CCFC_REQ,		
MSG_CMD_CLCK_REQ,

MSG_CMD_SENDSMS_REQ,
MSG_CMD_DELSMS_REQ,
MSG_CMD_STORAGE_CAP_REQ,
MSG_CMD_MODIFY_TAG_REQ,
MSG_CMD_READSMS_REQ,
MSG_CMD_SCA_SET_REQ,
MSG_CMD_NOTIFY_SET_REQ,
MSG_CMD_SMSACK_REQ,
MSG_CMD_SMSINIT_REQ

};

/* ùatǰ׺*/
#ifdef _USE_BL
unsigned int private_msgid[] =
{

	ATI_CC_DIAL_REQ,
	ATI_CC_ANSWER_REQ,
	ATI_CC_HANGUP_REQ,
	ATI_CC_HANGUPVT_REQ,
	ATI_CC_CHLD_REQ,
	ATI_CC_COLP_REQ,
	ATI_CC_CBST_REQ,
	ATI_CC_CUSD_REQ,
	ATI_CC_CRC_REQ,
	ATI_CC_CMOD_REQ,
	ATI_CC_ATH_REQ,
	ATI_CC_VOLTE_MPTY_DIAL_REQ,
	ATI_CC_VOLTE_REF_DIAL_REQ,
	ATI_VOLTE_CVMOD_REQ,
	ATI_CC_ZIMSPLUS_REQ,
	ATI_CC_VTS_REQ,
	ATI_CC_ZCFC_REQ,
	ATI_MM_ZLCK_REQ,
	ATI_SMS_CNMA_REQ,
	ATI_SMS_CMGS_REQ,
	ATI_MM_CFUN_REQ
};


//char FilterAtCmdPrefix[AT_CMD_MAX] = "+ZSQR+CUSD+ZEMCI+ZEMHI+ZEMSCI+ZUSTAT+ZURDY+ZCARDATR+ZUPCI+ZUEND+ZUFCH+ZLTEINFO+CNAP+CPSB+IMSVMODE+CEN+CIREPI+CEN1+CNEMS1";
#else
//char FilterAtCmdPrefix[AT_CMD_MAX] = {0};
#endif
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
/* at_ctl߳*/
static int ctl_recv_thread_create(void)
{
#if (APP_OS_TYPE == APP_OS_LINUX)
    pthread_t recv_thread_tid;
    return pthread_create(&recv_thread_tid, NULL, (void *)recv_mainloop, NULL);
#elif (APP_OS_TYPE == APP_OS_TOS)

    return zOss_CreateThread("at_recv_thread",recv_mainloop,NULL,12 * 1024, 13, 1, 1);//ܴ
#endif
}

/* ϢҪעᵽg_ser_listеϢ
 * ˵ӦϢװмϱͽ뷢͸ͨ
 */
static int  rcv_serv_rsp_msg_proc(MSG_BUF *msg_buf)
{
    struct ser_ops_t2 * ser_nod = NULL;
    char * rsp_msg =NULL;
    int rsp_len = 0;
    int ret;

    struct ser_ops_t0 * ser_nod0 = NULL;
    ser_nod0 = find_ser_by_msg_modid0(msg_buf->usMsgCmd, msg_buf->src_id);
    if(ser_nod0 != NULL)
    {
        at_context_write_data(ser_nod0->context->at_channel->at_fd, msg_buf->aucDataBuf, msg_buf->usDataLen);
        at_context_free_ctx(ser_nod0->context);
        ser_nod0->context = NULL;
        return  1;
    }

    ser_nod = find_ser_by_msg(msg_buf->usMsgCmd);
    if(ser_nod != NULL)
    {
        /* ִӦϢĲӦӦмat*/
        ret = ser_nod->rsp_act((void *)msg_buf->aucDataBuf, (void**)&rsp_msg, &rsp_len);
        if(ret == AT_END)
        {
        	if(user_server_is_special_cmd(rsp_msg))//˴mbbͻserverӦֱдͨ
			{
				at_context_write_data(ser_nod->context->at_channel->at_fd, rsp_msg, rsp_len);
				free(rsp_msg);
	        	at_context_free_ctx(ser_nod->context);
				ser_nod->context = NULL;
	        	return  1;
			}
#if (APP_OS_TYPE == APP_OS_LINUX)
//#ifdef GUODIAN
			/*ⷢϢ,м'/0'ַᵼ¶Ի߷ȥ*/
			if(g_customer_type == CUSTOMER_SDK || MODULE_ID_SOCKET_PROXY != ser_nod->module_id)
//#endif
#endif
            {
	            if(rsp_len != strlen(rsp_msg)||ser_nod->context == NULL)
	            {
	                softap_assert("");
					return	1;
	            }
			}
#ifndef CONFIG_MIN_8M_VERSION
//#ifdef GUODIAN
            if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
            {
                /*͸ϢɹãͨϺݲATֱӷsocketӦý*/
                set_passthough_bycmd(msg_buf);
            }
//#endif
#endif
            /* ָͨat*/
            at_context_write_data(ser_nod->context->at_channel->at_fd,rsp_msg,rsp_len);
            free(rsp_msg);
            at_context_free_ctx(ser_nod->context);
            ser_nod->context = NULL;
            return  1;
        }
        else
        {
            softap_assert("");
        }
    }
    return  0;
}

//ڷӦý첽ʽӦַatأatдͨ
void  rcv_serv_rsp_msg_async(MSG_BUF *msg_buf)
{
	struct at_context *ser_ctx = NULL;
	ser_ctx = at_context_find_ctx_by_moduleid(msg_buf->src_id, AT_SERVER);

	//Ӧý̵첽Ӧ
	if(ser_ctx)
	{
		at_context_write_data(ser_ctx->at_channel->at_fd, msg_buf->aucDataBuf, msg_buf->usDataLen);
		if(is_result_at(msg_buf->aucDataBuf))
			at_context_free_ctx(ser_ctx);
	}
	else
	{
	//㲥Ӧý̵ϱ
		struct at_channel_info * at_chan = at_channel_head[FAR_PS];

		for(; NULL !=at_chan; at_chan = at_chan->next)//еFAR_PSttyͨд
		{
			if((at_chan->attribution & (1<<CH_AUTOIND)) == 0)
				at_context_write_data(at_chan->at_fd, msg_buf->aucDataBuf, msg_buf->usDataLen);
		}
	}

}



/* ˼ӦϢ*/
static int  ctl_appsoc_proc(MSG_BUF *msg_buf)
{
#ifdef MULTI_CPU
    int ret;
    T_Soc_Msg  *socMsg = (T_Soc_Msg*)msg_buf->aucDataBuf;
    char *at_str = NULL;
    int at_fd = 0;

    at_fd = at_context_get_fd_by_pos(socMsg->position);

    at_print(AT_NORMAL,"[SOC]ctl_appsoc_proc: msgid = %x, at_fd=%d \n", socMsg->msg_cmd, at_fd);
    at_socmsg_write_msg(at_fd, socMsg->srcId, socMsg->targetId, socMsg->msg_cmd, socMsg->len, socMsg->msg);
#endif
	return  1;

}

int is_private_msgid(unsigned int msgid)
{
#ifdef _USE_VOLTE
#ifdef _USE_BL
	int i = 0;
	for(i = 0; i < sizeof(private_msgid) / sizeof(unsigned int); i++)
    {
        if(private_msgid[i] == msgid)
        {
			return 1;
		}
	}
#else
	int i = 0;
	for(i = 0; i < sizeof(private_cpe_msgid) / sizeof(unsigned int); i++)
    {
        if(private_cpe_msgid[i] == msgid)
        {
			return 1;
		}
	}
#endif
#endif
	return 0;
}
#ifdef _USE_BL
extern unsigned int amt_set_bootmode(unsigned char  bootmode[]);
static void zmode_msg_act(MSG_BUF *msg)
{
    int iUsbMode = 0;
    int retCode = -1;
    unsigned char bootmode[] = {0x54,0x4D};
	iUsbMode = atoi((char*)((MSG_BUF *)msg)->aucDataBuf);

    at_print(AT_ERR, "iUsbMode == %d\n", iUsbMode);

    switch(iUsbMode)
    {
        case 0: //user mode
        {   
            nv_set_item(NV_RO, "usb_modetype", "user", 1);
            bootmode[1] =0x00;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 1://debug mode
        {
            nv_set_item(NV_RO, "usb_modetype", "debug", 1);
            bootmode[1] =0x01;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 2://factory mode
        {
            nv_set_item(NV_RO, "usb_modetype", "factory", 1);
            bootmode[1] =0x02;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 3://amt mode
        {
            //nv_set_item(NV_RO, "usb_modetype", "amt", 1);
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        default:
        {
        	break;
        }
    }

    nv_commit(NV_RO);

	
   	at_print(AT_ERR,"send ZBL_ZMODE_SET_CNF\n");

	ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_BL, ZBL_ZMODE_SET_CNF, sizeof(int), &retCode, 0);

    return;
}
#endif
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/*ͨAPIϢϢatctlشڲ¼ִ*/
int  rcv_clt_req_msg_proc(MSG_BUF *msg_buf)
{
    char *at_str = NULL;
    struct at_context *context = NULL;
    struct app_clt_ops_t *ext_nod = NULL;
    int is_bl_to_volte = 0;

    /* жǷΪͬһģ鷢һϢǣȡôβ*/
    if(1 == at_context_clt_abort_handle(msg_buf))
        return 1;

    ext_nod = find_extclt_by_msg(msg_buf->usMsgCmd);
    if(ext_nod == NULL)
    {
        at_print(AT_ERR,"ERR: ext_nod == NULL \n");
        return 0;
    }

    is_bl_to_volte = is_private_msgid(msg_buf->usMsgCmd);
    if(is_bl_to_volte)
    {
        context = at_context_alloc_ctx_by_pos(POSITION_VOLTE);
    }
    else
    {
        context = at_context_alloc_ctx_by_pos(ext_nod->position);
    }

    if(context == NULL)
    {/* ͨĽڵʧܣ·͸Ϣ*/
        at_print(AT_NORMAL,"at_context_clt_req_resend \n");
        add_one_cache_msg(msg_buf);
        return  1;
    }
    context->source = msg_buf->src_id;
    context->msg_id = msg_buf->usMsgCmd;

    /* ִӦϢĲӦat*/
    at_str = ext_nod->req_act(msg_buf,context);

	//ΪNULLϢѱ¼ӦϢreq_actڲִ
    if(at_str == NULL)
    {
        at_print(AT_ERR,"ERR: at_str == NULL \n");
        at_context_free_ctx(context);
        return  1;
    }

    /* ͨӦͨat*/
    at_context_write_by_ctx(context,at_str,strlen(at_str));
	at_context_write_data(context->at_channel->at_fd, at_str,strlen(at_str));

    /* ˴ͷatڴ*/
    free(at_str);
    return  1;
}


/**
 * @brief at_ctl߳ϢMODULE_ID_AT_CTLϢϢat_ctlڲϢƽ̨ⲿϢ
 * @param msg_buf Ϣ
 * @return 0ʾ
 * @note
 * @warning
 */
int rcv_msg_proc(MSG_BUF *msg_buf)
{
    struct fwd_resend_t *fwd_resend_msg = NULL;
    struct at_msg_data * msg_data = NULL;
    struct at_context *context = NULL;

	if(msg_buf->usMsgCmd != ATCTL_RCV_AT_STR_MSG)//̵߳atϢӡ
    	at_print(AT_ERR,"rcv_msg_proc recv usMsgCmd = 0x%x, source is 0x%x\n",msg_buf->usMsgCmd, msg_buf->src_id);
    switch (msg_buf->usMsgCmd)
    {
    case ATCTL_RCV_AT_STR_MSG:/* atͨϢat_ctl̵߳Ϣ*/
        msg_data = (struct at_msg_data *)(msg_buf->aucDataBuf);
		save_monitor_at_buf(msg_data->at_fd, msg_data->at_str, msg_data->at_len, AT_RECV_TYPE);
        rcv_at_str_proc(msg_data->at_fd, (char *)msg_data->at_str, msg_data->at_len);
        free(msg_data->at_str);
        break;

	case ATCTL_DEBUG_PRINT_MSG:/* ϢӡϢ*/
        at_channel_context_print();
        break;

    case MSG_CMD_SOC_MSG_REQ:/* ˼ӦϢ*/
        ctl_appsoc_proc(msg_buf);
        break;

   /* ӦͨϢmodematʱҪͨϢһatͨ*/
    case MSG_CMD_SET_MSG_IS_FD:
	{
		if(msg_buf->src_id == 0)
			softap_assert("");
		//is_xinke_msg = 1;mbimҪATֹget_modem_infoͻ
		/*ӦģIDat_fd뵽atͨУڷַmodemϱмӦatʱ
		at_writeжҪдatͨӦģIDMSGӦ*/
		struct at_channel_info* new_chan = add_new_channel(msg_buf->src_id, FAR_PS);
		new_chan->is_xinke_msg = 1;
        break;
    }

    case MSG_CMD_SEND_ATREQ_BY_MSG:/* ͻԶAT.ͨport/usbͻAPPATͨѶ*/
    {
		save_monitor_at_buf(msg_buf->src_id, (char *)msg_buf->aucDataBuf, msg_buf->usDataLen, AT_RECV_TYPE);
		rcv_at_str_proc(msg_buf->src_id, (char *)msg_buf->aucDataBuf, msg_buf->usDataLen);
        break;
    }
    //ڷATַPS
    case MSG_CMD_SEND_AT_TO_PS:
    {
    	struct app_send_req_at *app_req = (struct app_send_req_at *)(msg_buf->aucDataBuf);
        struct at_channel_info* new_chan = add_new_channel(msg_buf->src_id, FAR_PS);//ģFAR_PS
        new_chan->attribution |= (1<<CH_AUTOIND);//رոͨϱܣܶӦĲѯм
		new_chan->timeout = app_req->timeout;
		rcv_at_str_proc(msg_buf->src_id, app_req->atstr, app_req->str_len);
        break;
    }
    //ͨûͨѯATϢѯƫŵPSϢ
    case MSG_CMD_SEND_REQAT_TO_FARPS:
    {
        struct app_send_req_at *app_req = (struct app_send_req_at *)(msg_buf->aucDataBuf);
        //ԴģIDͨ
        struct at_channel_info* new_chan = add_new_channel(msg_buf->src_id, NEAR_PS);
        new_chan->attribution |= (1<<CH_AUTOIND);//رոͨϱܣܶӦĲѯм
        new_chan->timeout = app_req->timeout;
		//ַߴ˴˺õstrlen
		rcv_at_str_proc(new_chan->at_fd, app_req->atstr, app_req->str_len);
		break;
    }
	//Ӧ÷͸ַͨһڷӦATַⲿMCU
	case MSG_CMD_SEND_RSP_TO_OUTSIDE:
	{
		rcv_serv_rsp_msg_async(msg_buf);
        break;
	}
    //VOLTEӦ߽ԭ·
	case MSG_CMD_FD1_VOLTE_TO_ATCTL:
	{		
		VOLTE_MSG_DATA  *volte_req = (VOLTE_MSG_DATA  *)(msg_buf->aucDataBuf);
		int volte_req_fd = volte_req->at_fd;
		if(volte_req_fd >= 1 && volte_req_fd <= VOLTE_PTY1_MAX)
		{
			at_print(AT_ERR,"====>FD1_VOLTE_TO_ATCTL fd=%d\n", volte_req_fd);
			at_print(AT_ERR,"====>FD1_VOLTE_TO_ATCTL str=%s\n", volte_req->msg_data);
			save_monitor_at_buf(MODULE_ID_ATCTL_TO_VOLTE+volte_req_fd-1, (char *)volte_req->msg_data, volte_req->msg_len, AT_RECV_TYPE);
			rcv_at_str_proc(MODULE_ID_ATCTL_TO_VOLTE+volte_req_fd-1, (char *)volte_req->msg_data, volte_req->msg_len);
		}
		break;
	}
	//at_ctlӦVOLTE
	case MSG_CMD_FD2_VOLTE_TO_ATCTL:
	{	
		VOLTE_MSG_DATA  *volte_req = (VOLTE_MSG_DATA  *)(msg_buf->aucDataBuf);
		int volte_req_fd = volte_req->at_fd;
		if(volte_req_fd >= 1 && volte_req_fd <= VOLTE_PTY2_MAX)
		{
			at_print(AT_ERR,"====>FD2_VOLTE_TO_ATCTL fd=%d\n", volte_req_fd);
			at_print(AT_ERR,"====>FD2_VOLTE_TO_ATCTL str=%s\n", volte_req->msg_data);
		    save_monitor_at_buf(MODULE_ID_VOLTE_TO_ATCTL+volte_req_fd-1, (char *)volte_req->msg_data, volte_req->msg_len, AT_RECV_TYPE);
			rcv_at_str_proc(MODULE_ID_VOLTE_TO_ATCTL+volte_req_fd-1, (char *)volte_req->msg_data, volte_req->msg_len);
		}
		break;
	}
    case MSG_CMD_AT_REG_REQ:
    {
        struct atreg_msg_t rsp = {0};
        if(msg_buf->usDataLen != sizeof(struct atreg_msg_t))
        {
            at_print(AT_ERR,"at rcv_msg_proc REG_REQ len=%d!=%d err\n", (int)msg_buf->usDataLen, (int)sizeof(struct atreg_msg_t));
        }
        memcpy(&rsp, msg_buf->aucDataBuf, sizeof(struct atreg_msg_t));
		rsp.at_cmd_prefix[AT_CMD_PREFIX-1]='\0';
        if(rsp.type)
        {
            rsp.res = register_inform_func0(rsp.at_cmd_prefix, msg_buf->src_id ,rsp.req_msg_id);
        }
        else
        {
            rsp.res = register_serv_func0(rsp.at_cmd_prefix, msg_buf->src_id, rsp.req_msg_id, rsp.rsp_msg_id);
        }
        
        if(0 != ipc_send_message2(MODULE_ID_AT_CTL, msg_buf->src_id, MSG_CMD_AT_REG_RSP, sizeof(struct atreg_msg_t), &rsp,0))
        {
            at_print(AT_ERR,"at rcv_msg_proc REG_REQ id=%d at=%s ipc err\n",  msg_buf->src_id, rsp.at_cmd_prefix);
        }
        break;
    }
    case MSG_CMD_AT_UNREG_REQ:
    {
        struct atreg_msg_t rsp = {0};
        if(msg_buf->usDataLen != sizeof(struct atreg_msg_t))
        {
            at_print(AT_ERR,"at rcv_msg_proc UNREG_REQ len=%d!=%d err\n",  msg_buf->usDataLen, (int)sizeof(struct atreg_msg_t));
        }
        memcpy(&rsp, msg_buf->aucDataBuf, sizeof(struct atreg_msg_t));
		rsp.at_cmd_prefix[AT_CMD_PREFIX-1]='\0';
        if(rsp.type)
        {
            rsp.res = unregister_inform_func0(rsp.at_cmd_prefix, rsp.req_msg_id);
        }
        else
        {
            rsp.res = unregister_serv_func0(rsp.at_cmd_prefix, rsp.req_msg_id);
        }
        
        if(0 != ipc_send_message2(MODULE_ID_AT_CTL, msg_buf->src_id, MSG_CMD_AT_UNREG_RSP, sizeof(struct atreg_msg_t), &rsp,0))
        {
            at_print(AT_ERR,"at rcv_msg_proc UNREG_REQ id=%d at=%s ipc err\n",  msg_buf->src_id, rsp.at_cmd_prefix);
        }
        break;
    }

 	
#ifdef _USE_BL	
	case MSG_CMD_MODESET_REQ:
	{
		at_print(AT_ERR,"recv MSG_CMD_MODESET_REQ\n");

		zmode_msg_act(msg_buf);
		break;
	}
#endif
    default:/* 򿪻߹رtty豸Ϣ*/
		if(1 == proc_at_port_hotplug(msg_buf))
			break;
		if(1 == user_special_msg_proc(msg_buf))//mbbûϢ
			break;
		if(1 == rcv_timeout_msg_proc(msg_buf))
			break;
#ifndef CONFIG_MIN_8M_VERSION
		if(1 == at_socket_data_proc(msg_buf))
			break;
#endif
		/* ϲӦ÷Ϣ*/
		if(1 == rcv_serv_rsp_msg_proc(msg_buf))
			break;
		/* ϲӦÿͻϢ*/
		if(1 == rcv_clt_req_msg_proc(msg_buf))
			break;

        at_print(AT_ERR,"ERR: MSG UNKNOW \n");
        break;
    }
    return 0;
}


static char BCD2Ascii(char iBCD)
{
    char iAscii;

    if (bInside(iBCD, 0x00, 0x09))
    {
        iAscii = (unsigned char)(iBCD + '0');
    }
    else if (bInside(iBCD, 0x0a, 0x0f))
    {
        iAscii = (unsigned char)((iBCD - 0x0a) + 'A');
    }
    else
    {
        return -1;
    }
    return iAscii;
}

void getwifimac(void)
{
	char   TmpWifiMac[128] = {0};
	char   TmpMacAddr[Comm_DEV_MSINFO_MAX_WIFIMAC_Area_Len] = {0};//imeiֵ
	char   str[13];
	unsigned long abMacindex = 0;
	char macstr1[13] = {0};
	char macstr2[13] = {0};
	unsigned int retCode = CPNV_ERROR;

	at_print(AT_ERR,"$$$$$getwifimac\n");

	retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS, (unsigned char *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE);
	if(retCode == CPNV_ERROR){softap_assert("");}
	/* MACַתBCDתΪAscii	*/
	memset(str, 0, 13);

	for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
	{
		str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
		str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

		macstr1[abMacindex] = BCD2Ascii(str[abMacindex]);
		macstr1[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
	}
	//sprintf(TmpWifiMac,"+MAC:%s",macstr1);
	//at_print(AT_ERR,"$$$$$getwifimac = %s\n", TmpWifiMac);

	memset(TmpMacAddr, 0, Comm_DEV_MSINFO_MAX_WIFIMAC_Area_Len);
	memset(str, 0, 13);
	//memset(macstr, 0, 13);
	retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS, (UINT8 *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE);
	if(retCode == CPNV_ERROR){softap_assert("");}
	for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
	{
		str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
		str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

		macstr2[abMacindex] = BCD2Ascii(str[abMacindex]);
		macstr2[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
	}
	sprintf(TmpWifiMac,"+MAC:%s;%s",macstr1,macstr2);

	at_print(AT_ERR,"$$$$$getwifimac = %s\n", TmpWifiMac);
	sc_cfg_set("at_wifi_mac",TmpWifiMac);
	sc_cfg_save();

}

void nv_init(void)
{
	char TmpExthver[ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN+1] = {0};
	char TmpExtcgmr[ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN+1] = {0};
	char TmpSoftVersion[ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN+1]={0};
	UINT8 phoneModeStatus = 0;
	unsigned int retCode = CPNV_ERROR;

	retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR, &phoneModeStatus, sizeof(UINT8));
	if(retCode == CPNV_ERROR){softap_assert("");}

	if((0x1 & phoneModeStatus) == 1)
	{
		sc_cfg_set("version_mode","1");  //modem汾
	}
	else
	{
		sc_cfg_set("version_mode","0");
	}

	retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_HARDWAREVERSION_BASE_ADDR,(unsigned char *)TmpExthver, ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN);
	if(retCode == CPNV_ERROR){softap_assert("");}
	TmpExthver[ZPS_REF_MSINFO_MAX_HARDWAREVERSION_LEN]='\0';
	sc_cfg_set("hw_version", TmpExthver);
	sc_cfg_set("hardware_version", TmpExthver);

	retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_EXT_BASE_ADDR, (unsigned char *)TmpExtcgmr, ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN);
	if(retCode == CPNV_ERROR){softap_assert("");}
	TmpExtcgmr[ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN]='\0';
	sc_cfg_set("wa_version", TmpExtcgmr);
	sc_cfg_set("cr_version", TmpExtcgmr);
	sc_cfg_set("wa_inner_version", TmpExtcgmr);


	retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_INT_BASE_ADDR, (unsigned char*)TmpSoftVersion, ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN);
	if(retCode == CPNV_ERROR){softap_assert("");}
	TmpSoftVersion[ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN]='\0';
	sc_cfg_set("cr_inner_version", TmpSoftVersion);
	{
		UINT8 cid = 0;
		retCode = cpnv_NvItemRead(OS_FLASH_ATCFG_RW_NONFAC_OFFSET_FROM_NV+0x300, &cid, sizeof(UINT8));
		if(retCode == CPNV_ERROR){softap_assert("");}
		set_def_attach_cid(cid);
	}
	getwifimac();
	sc_cfg_save();
}


/**
 * @brief at_ctlӦý/߳
 * @param
 * @return
 * @note
 * @warning
 */
#if (APP_OS_TYPE == APP_OS_LINUX)
int at_ctl_main(int argc, char * argv[])
#else
void at_ctl(void)
#endif
{
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);
    int iMsgHandle = 0;
    int iRet = 0;
	prctl(PR_SET_NAME, "at_ctl", 0, 0, 0);
#ifdef USE_CAP_SUPPORT
	/*ڶNVҪCAPӦATͨǰЭջATϱʧ*/
	at_context_at_chn_init();
#endif
    /* atͨ״̬Ϣӡ*/
#if (APP_OS_TYPE == APP_OS_LINUX)
	g_powerOnType = atoi(argv[1]);
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	//ָapnppp_passwd
	atctl_aes_init();
    //NVȡͻ
    get_customer_type();
#ifndef CONFIG_MIN_8M_VERSION
	if(g_customer_type == CUSTOMER_GUODIAN || g_customer_type == CUSTOMER_NANDIAN)
		start_goudian_baseapp();
#endif		
#endif
    at_debug_init();
	at_comm_init();
	/* ʼat*/
    INIT_LIST_HEAD(&g_clt_list);
    INIT_LIST_HEAD(&g_fwd_list);
    INIT_LIST_HEAD(&g_inform_list);
    INIT_LIST_HEAD(&g_ser_list2);
    INIT_LIST_HEAD(&g_ser_list);
    INIT_LIST_HEAD(&g_appclt_list);
    INIT_LIST_HEAD(&g_modem_extat_list);
	INIT_LIST_HEAD(&g_formatinform_list);
    INIT_LIST_HEAD(&g_inform_list0);
    INIT_LIST_HEAD(&g_ser_list0);

    /* Ϣ*/
    iMsgHandle = msgget(MODULE_ID_AT_CTL, IPC_CREAT|0600);

	{
#ifndef USE_CAP_SUPPORT
		/* ʼatͨ*/
		at_context_at_chn_init();
#endif
		/* atͨϢ߳*/
		{
			pthread_t recv_thread_tid;
			if (pthread_create(&recv_thread_tid, NULL, (void *)recv_mainloop_farps, NULL) != 0) //cov m
				at_print(AT_ERR,"recv_mainloop_farps create fail\n");
		}
		if(g_powerOnType != POWER_ON_CHARGING)
			ctl_recv_thread_create();
		/* עat*/
		register_at_event_init();
#if 0//def MULTI_CPU
		/* APCPNVͬ*/
		sync_nv();

		//оƬ֤
#if (APP_OS_TYPE == APP_OS_LINUX)
		//оƬ֤汾NVͬ
		at_ctl_atcmd_stream_sync();

		//ƽ̨ϱͬ
		sync_appointed_nv(NEAR_PS, "cpIndCmdList");
#endif
#endif
		nv_init();
		/* ʼcidԴ֧4·pdpͨcid_resumednvֵȷõcid*/
		cid_resource_init();

		/* Ϣʱѯ*/
		at_timeout_start_perio_query();
	}
	sc_cfg_get("customIndCmdList", PsmIndAtCmdPrefix, sizeof(PsmIndAtCmdPrefix));
    while(g_powerOnType != POWER_ON_LOCALUPDATE)
    {
        iRet = 0;
        memset(&stMsg, 0x00, sizeof(MSG_BUF));

        /* ȡϢϢ*/
        iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);
        if (iRet >= 0)
        {
            rcv_msg_proc(&stMsg);
        }
        else
        {
            if(errno != EINTR)
                at_print(AT_ERR,"errno = %d, errmsg = %s\n", errno,strerror(errno));
        }
    }
	return 0;
}

void At_Ctl_Init(void)
{
#if (APP_OS_TYPE == APP_OS_TOS)
    ZOSS_THREAD_ID  threadId = NULL;

    //zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "Entered NetInfoRptStart!!!!!\r\n");
    threadId = zOss_CreateThread("at_ctl", at_ctl, 0, 12 * 1024, 13, 1, 1);/* Żȼ13Ϊ16 */
    if(threadId == NULL)
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "Create at_ctl Failed threadId == 0!!!!!\r\n");
    else
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "Create at_ctl success!!!!!\r\n");
#endif
}

