#include <stdio.h>
#include <stdlib.h>

#include <stdbool.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fota_common.h>
#include <sys/types.h>
#include <sys/time.h>
#include "dmgr_api.h"
#include <getopt.h>
#include "fota_dm_dl.h"
#include "cfg_api.h"


#define FOTA_DEFAULT_DELTA_URL  "http://192.168.0.100:8080/Fota/Versions/User1/Project1/Version1.bin"

void usage (void)
{
	printf ("fota_test [-cvgh] [--retry=<times>] [--download=<url> or -d]\n "
	         "  -c, --check check version, and save the verison info to nv\n"
	         "  -d, --download download the indicated url file\n"
             "  -r, --retry  just loop retry download the times\n"			 
	         "  -g, --debug set fota_dm into debug mode\n"
	         "  -v, --lib version info\n"
	         "  -h, --help show this usage text\n");
}


void print_version()
{
	char version[64]={0};
	
	if(dmgr_version(version, sizeof(version)) < 0)
		printf("can not find the gs lib version\n");
	
	
	printf("lib version: %s", version);
}

void check_version()
{
	
	fota_dm_check_new_version();
	
}

int  download_version(char * url)
{
	char buf[1024]={0};
	if(url != NULL)
		sc_cfg_set (NV_FOTA_VERSION_DELTA_URL, url);
		
	sc_cfg_get(NV_FOTA_VERSION_DELTA_URL, buf, sizeof(buf));
	if(strlen(buf) == 0){
		printf("please check version first\n");
		return -1;	
	}
	return fota_dm_download_version();
	
}

/*

struct timeval{
long tv_sec; //
long tv_usec; //΢
};
struct timezone
{
int tz_minuteswest; //Greenwich ʱ˶ٷ
int tz_dsttime; //չԼʱ״̬
}; 

*/
long  timeus()
{
       struct  timeval  tv;
       gettimeofday(&tv, NULL);
       return tv.tv_usec;
}

long  time_diff(struct  timeval  *end, struct  timeval *start)
{
	long time_ms = end->tv_usec - start->tv_usec;
	if(time_ms > 0)
	{
		time_ms = (end->tv_sec - start->tv_sec)*1000 + time_ms/1000;
	}
	else
	{
	
		time_ms = (end->tv_sec - start->tv_sec - 1)*1000 + (1000000 + end->tv_sec - start->tv_sec)/1000;
	}

	return time_ms;
}

int main (int argc, char *argv[])
{
	int c=0;
	int option_index = 0;
	char *optstring = "d::r:ctvgh";
	char *url_str = NULL;
	int  retry_num = 0;

	int  dl_job = 0;
	
	static struct option long_options[] = {
		{"check",   		no_argument, NULL, 'c'},
		{"download",    	optional_argument, NULL, 'd'},
		{"retry",    		required_argument, NULL, 'r'},		
		{"version",   		no_argument, NULL, 'v'},
		{"debug",   		no_argument, NULL, 'g'},
		{"help",            no_argument, NULL, 'h'},
		{0, 0, 0, 0}
	};
	for (;;) {
		c = getopt_long (argc, argv, optstring, long_options, &option_index);
		if (c < 0)
			break;
		switch (c) {
		case 'c':
			check_version();
			return 0;
		case 'r':
			if(optarg != NULL) { //klocwork
				retry_num = atoi(optarg);
				printf("retry_num =%d, %s \n", retry_num, optarg);
				if (retry_num > 0x8FFFFFFF || retry_num < 0)
					return 0;
			}
			continue;
		case 'd':
			url_str = optarg;
			dl_job = 1;
			if (url_str != NULL) //klocwork
				printf("dl_job =%d  url_str= %s\n", dl_job, url_str);
			continue;
		case 'h':
			usage();
			return 0;
		case 'v':
			print_version();
			return 0;
		case 'g':
			printf("can to set debug mode\n");
			break;
		default:
			usage();
			return 0;
		}
	}

	if(1 == dl_job)
	{
		int i = 0,ret=0;
		do{
			struct  timeval start,end;
			gettimeofday(&start, NULL);
			fprintf(stderr, "[fota_test]**************[[%d]], now=[%lds:%ldus]\n", i,start.tv_sec, start.tv_usec);
			ret = download_version(url_str);
			gettimeofday(&end, NULL);
			fprintf(stderr, "[fota_test]**************[[%d]],time=[%d ms] [%s]\n\n", i, time_diff(&end,&start), ret==0?"SUCCESS":"FAIL");
			i++;
			system("rm -f /cache/zte_fota/delta.package");
		}while(i < retry_num);
		
		return 0;
	}
#if 0
	http_send_test(FOTA_DEFAULT_DELTA_URL);
#endif
	usage();
	return 0;
}
