/*
        Wifi ģ鹫ͷļ
*/

#ifndef  WIFI_UTIL_H
#define WIFI_UTIL_H

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/prctl.h>
#include <pthread.h>
#include <linux/netlink.h>
#include <sys/inotify.h>
#include <linux/rtc.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <syslog.h>
#include <signal.h>
#include <sys/time.h>
#include <time.h>
#include "softap_api.h"
#include "netotherapi.h"



#define CASE_RETURN_STR(x) case x: return #x;
// Useful macros..
#define MIN( a, b ) ((a) < (b) ? (a) : (b))
#define MAX( a, b ) ((a) < (b) ? (b) : (a))
#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)
#define itoa(i,a,b) (((b) == 16) ? sprintf((a), "%x", (i)) : sprintf((a), "%d", (i)))


enum {
	WIFI_CFG_OPEN,                //wifi
	WIFI_CFG_CLOSE,               //رwifi
	WIFI_CFG_OPEN_MSSID,          //򿪸ssid
	WIFI_CFG_CLOSE_MSSID,         //رոssid
	WIFI_CFG_OPEN_VA0_VA1,        //ssid
	WIFI_CFG_RF,                  //Ƶ
	WIFI_CFG_AP,                  //AP
	WIFI_CFG_MSSID,               //øssid
	WIFI_CFG_RESTART_APSTATION,   //ap station
	WIFI_CFG_RESTART_AP,          //ap
	WIFI_CFG_CLOSESTA_OPENMSSID,  //رstation򿪸ssid
	WIFI_CFG_FORCE_RESTART,       //ǿwifi
	WIFI_CFG_SLEEP,               //˯
	WIFI_CFG_CHANNEL_FOLLOW,      //APŵSTA
	WIFI_CFG_APSTA_OPEN_AP,		  //apstaӳɹap
};

void wf_write_file (char* file, char* status);
int wf_get_msg_qid (int module_id);
int wf_create_msg_id (int module_id);
void wf_ms_sleep (unsigned long mSec);
int find_substr_num (char* str, char substr);
int find_substr_num_for_acl (char* str, char substr);
void write_status (char* file, const char* status);
void wlan_write_file (char* file_path, char* param);
int wf_create_msg_qid (int module_id);
void  wf_create_thread (void *thread_name, void * (*thread_loop) (void*));
#define  wf_err(fmt, args...)	\
	do {slog(WIFI_PRINT,SLOG_ERR,   "[wlan][%s-%d]: " fmt"\n", __FUNCTION__, __LINE__, ## args);} while (0)


#define  wf_log(fmt, args...)	\
	do {slog(WIFI_PRINT,SLOG_ERR,   "[wlan][%s-%d]: " fmt"\n", __FUNCTION__, __LINE__, ## args);} while (0)

//	do {wlog("[wlan][%s]: " fmt"\n", __FUNCTION__, ## args);} while (0)
unsigned int deleteCharFromStr (char c, char* instr, char* outstr);
void* safe_malloc (int size, unsigned char is_assert);
void safe_strcpy (char* dest, char* source, int size);
int wlan_readfile (const char *path, char * buf,  int  len);
int wfsystem(const char * cmd);
unsigned char s2x (char *s);

int ensure_config_dir_exist(char * dir);
 int   get_file_size (char * file);

int ensure_file_exist(char * file);
void write_lockfile (char *filepath, char *setbuf);


int wf_msg_to_zcore(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData);
int wf_msg_to_mmi(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData);
int wf_msg_to_self(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData);
#ifdef __AP_FUNC__
int wifi_aes_init_key(void);
int wifi_encrypt_code(void);
int wifi_decrypt_code(void);
int wifi_decode_b2s(void);
#endif

#endif
