/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    USBCFGMNG
*  ļ    usbCfgMng_msg.c
*  ļʶ  
*  ļ  
*  ʵֹ  usbùϢ
*        
*  汾      V1.0
*    2016-3-9
*  ˵  
*
******************************************************************************/

/*****************************************************************************
                         ͷļ
******************************************************************************/
#include <pthread.h>
#include <sys/prctl.h>
#include "zte_drv_usb_ctrl.h"


extern USBCFG_MSG_PROC_INFO g_usbcfg_info[USBCFG_MSG_MAX_LENGTH];
static int g_usbcfg_msgQue_Id = 0;

/**********************************************************************************
:usbù̵Ϣ
***********************************************************************************/
long usbcfg_create_msg_queue(void)
{
    long msgid=0;
    if((msgid = msgget(MODULE_ID_USBCFGMNG,IPC_CREAT | 0600)) == -1)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] [error]:Create MODULE_ID_USBCFGMNG queue faild! msgid=%d\n",msgid);
        return -1;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]Creating usbCfgMng message queue success! MODULE_ID_USBCFGMNG=%d\n",msgid);
    return msgid;
}

/**********************************************************************************
:usbùϢ
***********************************************************************************/
long usbcfg_send_message(unsigned short Msg_cmd,unsigned short us_DataLen, unsigned char *pData)/*lint !e129*/
{
    int ret = 0;
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng][%s]msg_cmd:0x%04x\n", __func__, Msg_cmd);

    //ret = send_soc_msg(NEAR_PS, MODULE_ID_AT_CTL, Msg_cmd, us_DataLen, pData);
	ret = ipc_send_message(MODULE_ID_USBCFGMNG,MODULE_ID_BL, Msg_cmd, us_DataLen, pData,0);
    if(ret != 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s]send message filed!\n", __func__);
        return -1;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng][%s]send message success!\n", __func__);
    return 0;     
}

/**********************************************************************************
:usbùϢ
***********************************************************************************/
int usbcfg_RecvMsgFromQueue(int msgQueueId, MSG_BUF *pstMsg, long MsgType)
{
    int iRet = -1;
    long msgSize =  sizeof(MSG_BUF) - sizeof(long);

    if(NULL == pstMsg)
    {
        return -1;
    }

    iRet = msgrcv(msgQueueId, pstMsg, msgSize, MsgType, MSG_NOERROR);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng][%s]iRet : %ld, pstMsg->src_id:ld,  pstMsg->usMsgCmd:ld \n", __func__, iRet, pstMsg->src_id, pstMsg->usMsgCmd);

    if(iRet <= 0)
    {
        return -1;
    }
    else
    {
        return 0;
    }  
}

/**********************************************************************************
:USBù̵Ϣ
***********************************************************************************/
static int usbcfg_ProcMsg(MSG_BUF *pstMsg)
{
    int i = 0;

    if(NULL == pstMsg)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s] NULL == pstMsg!\n", __func__);
        return -1;
    }
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng][%s] msg:src_id = 0x%04x,usMsgCmd = 0x%08x,usDataLen = %d,data = %s\n",
        __func__, pstMsg->src_id, pstMsg->usMsgCmd, pstMsg->usDataLen, pstMsg->aucDataBuf);

    for (i=0; i < (int)(sizeof(g_usbcfg_info)/sizeof(g_usbcfg_info[0])); i++)
    {
        if (pstMsg->usMsgCmd == g_usbcfg_info[i].id)
        {
            if (g_usbcfg_info[i].func_ptr != NULL)
            {
                g_usbcfg_info[i].func_ptr((VOID*)(pstMsg->aucDataBuf));
            }
            return 0;
        }
    }

    return 0;
}

static void usb_handleMsgEntry(void* args)
{
    long MsgType = 0;
    MSG_BUF usbcfgMsg;
    prctl(PR_SET_NAME,"usbcfghandlemsg",0,0,0);
    
    while(1)
    {
        memset((VOID*)(&usbcfgMsg), 0, sizeof(MSG_BUF));
        if(-1 != usbcfg_RecvMsgFromQueue(g_usbcfg_msgQue_Id, &usbcfgMsg, MsgType))
        {
            usbcfg_ProcMsg(&usbcfgMsg);
        }
    }
	
}

void usb_initUsbCfgMsg(void)
{
	
	pthread_t usb_handlemsg_thread;

    //ٿػʹõϢ
    if((g_usbcfg_msgQue_Id = usbcfg_create_msg_queue()) == -1)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]create g_usbcfg_msgQue_Id failed!!!\n");	
        softap_assert("");
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_initUsbCfgMsg\n");
    
    //ٿػ Ϣ߳
    if(pthread_create(&usb_handlemsg_thread, NULL, usb_handleMsgEntry, NULL)== -1)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_initUsbCfgMsg pthread_create handle msg error\n"); 
        return ;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_initUsbCfgMsg Register finish!!\n"); 
}

