/***********************************************************************
 *Project       Linux H100
 *Modual        USRLINE
 *FileName      slc_inf.c
 *Description   user line driver interface
 *-----------------------------------------------------------------------
 *modify History:
 *
 * Data         author          version         modify description
 * 2004/12/10   jiang.yuelong   1.0             create
 ************************************************************************/
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/ioctl.h>
/*lint -save -esym(18, LONG) */
/*lint -restore */

#include "slic_inf.h"
#include "112.h"
#include "libzte_log.h"

static LONG SLIC_Fd;
static S8 *SLIC_DeviceName     = (S8 *)"/dev/slic";

DWORD SLIC_Initial(VOID)
{

    SLIC_Fd = open(SLIC_DeviceName, O_RDONLY);
    if(SLIC_Fd < 0)
    {
        printf("slctool: open device error.\n");
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

VOID SLIC_Release(VOID)
{
    close(SLIC_Fd);
}

VOID SLIC_DebugLevel(WORD wLevel)
{
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));

    //Tmp.unPara.wLevel = wLevel;
    
    if (ioctl(SLIC_Fd, SLIC_DEBUG_LEVEL, (DWORD)&Tmp) < 0) {//cov m
		printf("SLIC_DebugLevel ioctl fail\n");
	}
}

DWORD SLIC_ResetPort(WORD wPort, BYTE bType)
{
    SLIC_IOCTL_DATA Tmp;
	
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;
    
    if (ioctl(SLIC_Fd, SLIC_PORT_RESET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

DWORD SLIC_Port_Lock(WORD wPort, BYTE bType)
{
    SLIC_IOCTL_DATA Tmp;
	
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;

    if (ioctl(SLIC_Fd, SLIC_PORT_LOCK, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

DWORD SLIC_Port_UnLock(WORD wPort, BYTE bType)
{
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;

    if (ioctl(SLIC_Fd, SLIC_PORT_UNLOCK, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

DWORD SLIC_FXS_PolarityReverse(WORD wPort)
{
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    
    if (ioctl(SLIC_Fd, SLIC_POLARITY_REVERSE, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}
extern int get_polarity_reversal_flag(void);

DWORD SLIC_PolarityReverse(WORD wPort, int is_active)
{
#ifdef USE_SLIC_TW
	
    if (ioctl(SLIC_Fd, SLIC_POLARITY_REVERSE, (WORD) is_active) < 0)
    {
        return SLIC_FAIL;
    }
 #else	

    SLIC_IOCTL_DATA Tmp;

    if(get_polarity_reversal_flag()==0)
    	return SLIC_SUCCESS;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    Tmp.dwSize = (WORD)is_active;
    
    if (ioctl(SLIC_Fd, SLIC_POLARITY_REVERSE, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif

    return SLIC_SUCCESS;
}


DWORD SLIC_Play_Signal(WORD wPort, BYTE bType, SIGNAL_DATA *pSig)
{
#ifdef USE_SLIC_TW
    if (!pSig)
    {
        return SLIC_FAIL;
    }
	
    if (ioctl(SLIC_Fd, SLIC_SIGNAL_START, (DWORD) pSig) < 0)
    {
        return SLIC_FAIL;
    }
 #else	
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));

    if (!pSig)
    {
        return SLIC_FAIL;
    }

    Tmp.pData       = pSig;
    Tmp.dwSize      = sizeof(SIGNAL_DATA);
	
    if (ioctl(SLIC_Fd, SLIC_SIGNAL_START, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }

#endif
    return SLIC_SUCCESS;
	
}

DWORD SLIC_Stop_Signal(WORD wPort, BYTE bType)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_SIGNAL_STOP, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else

    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;

    if (ioctl(SLIC_Fd, SLIC_SIGNAL_STOP, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }

#endif
    return SLIC_SUCCESS;
}
DWORD SLIC_Start_PCM()
{
      printf("ccapp:SLIC_Start_PCM! \n");
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_PCM_OPEN, NULL) < 0)
    {
        printf("ccapp:SLIC_Start_PCM fail!\n");
        return SLIC_FAIL;
    }
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    if (ioctl(SLIC_Fd, SLIC_PCM_OPEN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Stop_PCM()
{
      printf("[ccapp_debug]:SLIC_Stop_PCM!\n");
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_PCM_CLOSE, NULL) < 0)
    {
        printf("[ccapp_debug]:SLIC_Stop_PCM fail!\n");
        return SLIC_FAIL;
    }
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    if (ioctl(SLIC_Fd, SLIC_PCM_CLOSE, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif	
    return SLIC_SUCCESS;
}

DWORD SLIC_PCM_Set_NB()
{
      printf("ccapp:SLIC_PCM_Set_NB!\n");
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_PCM_SET_NB, NULL) < 0)
    {
        printf("ccapp:SLIC_PCM_Set_NB fail! \n");    
        return SLIC_FAIL;
    }
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    if (ioctl(SLIC_Fd, SLIC_PCM_SET_NB, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
 #endif	
    return SLIC_SUCCESS;
}

DWORD SLIC_PCM_Set_WB()
{
#ifdef USE_SLIC_TW
    printf("ccapp:SLIC_PCM_Set_WB!\n");   
    if (ioctl(SLIC_Fd, SLIC_PCM_SET_WB, NULL) < 0)
    {
        printf("ccapp:SLIC_PCM_Set_WB fail! \n");   
        return SLIC_FAIL;
    }
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    if (ioctl(SLIC_Fd, SLIC_PCM_SET_WB, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}


DWORD SLIC_SelectTimeSlot(WORD wPort, BYTE bType, BYTE bTX, BYTE bRX)
{
#ifdef USE_SLIC_TW
#if 0
    if (bType > 1)
    {
        return SLIC_FAIL;
    }

    if (ioctl(SLIC_Fd, SLIC_TIMESLOT_SET, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else

 VpOptionTimeslotType timeslot={0};
 timeslot.rx=bRX;
 timeslot.tx=bTX;

 
    if (ioctl(SLIC_Fd, SLIC_TIMESLOT_SET, (DWORD) &timeslot) < 0)
    {
        return SLIC_FAIL;
    }
#endif
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;
    //Tmp.unPara.stTimeSlot.bTx = bTX;
    //Tmp.unPara.stTimeSlot.bRx = bRX;


    if (bType > 1)
    {
        return SLIC_FAIL;
    }

    if (ioctl(SLIC_Fd, SLIC_TIMESLOT_SET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_ReleaseTimeSlot(WORD wPort, BYTE bType)
{
#ifdef USE_SLIC_TW
    if (bType > 1)
    {
        return SLIC_FAIL;
    }

    if (ioctl(SLIC_Fd, SLIC_TIMESLOT_RELEASE, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;

    if (bType > 1)
    {
        return SLIC_FAIL;
    }

    if (ioctl(SLIC_Fd, SLIC_TIMESLOT_RELEASE, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_MsgRev(BYTE *bEvent, DWORD *pPayLoad)
{
#ifdef USE_SLIC_TW
    LONG rev = 0;
    MSG_DATA msg;
    memset((VOID *)&msg,0,sizeof(msg));    
    rev = ioctl(SLIC_Fd, SLIC_MSG_REV, (DWORD) &msg);
    if (rev < 0)
    {
        return SLIC_FAIL;
    }
#else
    LONG rev = 0;
    SLIC_IOCTL_DATA Tmp;
    MSG_DATA msg;
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    memset((VOID *)&msg,0,sizeof(msg));

    Tmp.pData       = &msg;
    Tmp.dwSize      = sizeof(MSG_DATA);
    
    rev = ioctl(SLIC_Fd, SLIC_MSG_REV, (DWORD) &Tmp);
    if (rev < 0)
    {
        return SLIC_FAIL;
    }
#endif
    //*wPort      = msg.wPort;
    *bEvent     = msg.bMsgId;
    *pPayLoad   = msg.dPayLoad;
    return SLIC_SUCCESS;
}

DWORD SLIC_MsgClr(VOID)
{
    if (ioctl(SLIC_Fd, SLIC_MSG_CLR, NULL) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_HookLowTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_HOOK_LOWLEN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_HOOK_LOWLEN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
 #endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_HookHighTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_HOOK_HIGLEN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_HOOK_HIGLEN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_PreHookHighTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_PREHOOK_HIGLEN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_PREHOOK_HIGLEN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_FlashLowMinTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_LMIN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_LMIN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_FlashLowMaxTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_LMAX, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_LMAX, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_FlashHighFixTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_HFIX, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_FLASH_HFIX, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_DialLowMinTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_LMIN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_LMIN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_DialLowMaxTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_LMAX, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_LMAX, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_DialHighMinTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_HMIN, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_HMIN, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_DialHighFixTime(WORD wPort, WORD wTime)
{
#ifdef USE_SLIC_TW

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_HMAX, NULL) < 0)
    {
        return SLIC_FAIL;
    }
#else
	SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = PORT_TYPE_FXS;
    //Tmp.unPara.wTime= wTime;

    if (ioctl(SLIC_Fd, SLIC_CFG_DIAL_HMAX, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Read_Codec(BYTE *pParm)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_Read_Codec not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
	
    Tmp.pData       = pParm;
    Tmp.dwSize      = 2;
    
    if (ioctl(SLIC_Fd, SLIC_CODEC_GET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}
DWORD SLIC_Read_Codec_ALL(VOID)
{
#ifdef USE_SLIC_TW
	int ret = 0;
	ret = ioctl(SLIC_Fd, SLIC_CODEC_GETALL, NULL) ;
    if (ret< 0)
    {
    	printf("SLIC_Read_Codec_ALL error ret=%d \n", ret);

        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}
DWORD SLIC_Cfg_Codec(BYTE *pParm)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_Cfg_Codec not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    Tmp.pData       = pParm;
    Tmp.dwSize      = 2;
    
    if (ioctl(SLIC_Fd, SLIC_CODEC_SET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif	
    return SLIC_SUCCESS;
}

DWORD SLIC_112TestStart(WriteCmd_t *pCmd)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_LINE_TEST_START not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    
    //Tmp.wPort       = pCmd->port;
    //Tmp.bPortType   = pCmd->port_type;
    //Tmp.pData       = pCmd;
    //Tmp.dwSize      = sizeof(WriteCmd_t);
    
    if (ioctl(SLIC_Fd, SLIC_LINE_TEST_START, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_112TestAbort( WORD wPort, BYTE bType )
{
#ifdef USE_SLIC_TW
   printf(" SLIC_LINE_TEST_ABORT not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;

    if (ioctl(SLIC_Fd, SLIC_LINE_TEST_ABORT, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_112TestRead( WORD wPort, BYTE bType, TestResult_t *pResBuf)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_LINE_TEST_READ not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort       = wPort;
    //Tmp.bPortType   = bType;
    
    if (NULL == pResBuf)
    {
        return SLIC_FAIL;
    }

    Tmp.pData       = pResBuf;
    Tmp.dwSize      = sizeof(TestResult_t);
    
    if (ioctl(SLIC_Fd, SLIC_LINE_TEST_READ, (DWORD)&Tmp) < 0)
    {
        printf("Read error!!\n");
        return SLIC_FAIL;
    }
  #endif  
    return SLIC_SUCCESS;
}

DWORD SLIC_Dev_Init()
{   
    if (ioctl(SLIC_Fd, SLIC_DEV_INIT, 0) < 0)
    {
        return SLIC_FAIL;
    }
    return SLIC_SUCCESS;
}

DWORD SLIC_Read_Ram(BYTE *pParm)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_RAM_GET not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
	
    Tmp.pData       = pParm;
    Tmp.dwSize      = 2;
    
    if (ioctl(SLIC_Fd, SLIC_RAM_GET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

    
DWORD SLIC_Cfg_Ram(BYTE *pParm)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_RAM_SET not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;
    
    memset((VOID *)&Tmp,0,sizeof(Tmp));
    Tmp.pData       = pParm;
    Tmp.dwSize      = 2;
    
    if (ioctl(SLIC_Fd, SLIC_RAM_SET, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}

DWORD SLIC_Cfg_Electric(WORD wPort, BYTE bType, ELECTRIC_CFG_CUSTOMIZED *pElec)
{
#ifdef USE_SLIC_TW
   printf(" SLIC_ELECTRIC_CFG not support!\n"); 
    return SLIC_FAIL;
#else
    SLIC_IOCTL_DATA Tmp;

    memset((VOID *)&Tmp,0,sizeof(Tmp));
    //Tmp.wPort = wPort;
    //Tmp.bPortType = bType;

    if (NULL == pElec)
    {
        return SLIC_FAIL;
    }

    Tmp.pData = pElec;
    Tmp.dwSize = sizeof(ELECTRIC_CFG_CUSTOMIZED);

    if (ioctl(SLIC_Fd, SLIC_ELECTRIC_CFG, (DWORD) &Tmp) < 0)
    {
        return SLIC_FAIL;
    }
#endif
    return SLIC_SUCCESS;
}
