

#include <fcntl.h>              // open
#include <string.h>             // bzero
#include <stdlib.h>             // exit
#include <sys/types.h>          // pid_t
//#include "ufi_def.h"
#include "os_type_def.h"

#include "cc_at.h"
#include "cc_proc.h"
#include "cc_main.h" 
#include <termios.h>                 //termios, tcgetattr(), tcsetattr()
#ifndef TEST_CCAPP
#include <unistd.h>
#include <sys/ioctl.h>          // ioctl  
#include <sys/times.h>          // times
#endif

//ζ
#define ZCC_APP_AT_COMM_CC         "/dev/armps_rpmsgch12"
#define ZCC_APP_AT_COMM_SS         "/dev/armps_rpmsgch13"
#define ZCC_APP_AT_COMM_DEV     "/dev/armps_rpmsgch14"
#define ZCC_APP_AT_COMM_IND         "/dev/armps_rpmsgch15"


static int  g_zCcApp_ComFd[4] = {0};   

/*******************************************
 *  תת
 ********************************************/
static int convbaud(unsigned long int baudrate)
{
         switch (baudrate)
         {
            case 2400:
                     return B2400;
            case 4800:
                     return B4800;
            case 9600:
                     return B9600;
            case 19200:
                     return B19200;
            case 38400:
                     return B38400;
            case 57600:
                     return B57600;
            case 115200:
                     return B115200;
            default:
                     return B9600;
         }
}

#ifndef TEST_CCAPP
int zCc_CleanCCMSG()
{
         int ret = -1;
         //get CC fd
         int fd = zCcApp_GetAtCCFd();
         fd_set readfdForCC;
         
        struct timeval tv={0};   

         while(1)
         {
            //0s timeout
            tv.tv_sec = 0;
            FD_ZERO(&readfdForCC);
            FD_SET(fd, &readfdForCC);            
            ret = select(fd + 1, &readfdForCC, NULL, NULL, &tv);
            if(ret<0)
            {
                     continue;
            }
            //"Select timeout"
            if(ret == 0)          
            {
                     break;
            }
            
            if(FD_ISSET(fd, &readfdForCC))         
            {
                     char AtBuf[ZCC_APP_AT_BUF_MAX_LEN] = {0};
                     int readlen = 0;
                     readlen = read(fd, AtBuf, ZCC_APP_AT_BUF_MAX_LEN);
            }
            else
            {
                     continue;
            }
         }
         
         return 0;
}

int zCcApp_GetAtCmdFd(void)
{
    int fd = 0;
    E_CC_APP_AtReqCmdId  AtChnlCmdId = g_Cc_CallDetail.curAtCmdId;

    switch (AtChnlCmdId)
    {
        case CC_APP_AT_CMD_REQ_A:
        case CC_APP_AT_CMD_REQ_D:
        case CC_APP_AT_CMD_REQ_CHUP:
        case CC_APP_AT_CMD_REQ_SET_CHLD:
        case CC_APP_AT_CMD_REQ_VTS:   
        case CC_APP_AT_CMD_REQ_IMSPLUS:
        fd = g_zCcApp_ComFd[1];
        break;


        case CC_APP_AT_CMD_REQ_GET_CLCC:        
        case CC_APP_AT_CMD_REQ_CMUT:
        case CC_APP_AT_CMD_REQ_CLVL:
        fd = g_zCcApp_ComFd[3];
        break;



        case CC_APP_AT_CMD_REQ_SET_CCFC:
        case CC_APP_AT_CMD_REQ_SET_CCWA:
        case CC_APP_AT_CMD_REQ_SET_CLCK:
        case CC_APP_AT_CMD_REQ_GET_CCFC:
        case CC_APP_AT_CMD_REQ_GET_CCWA:    
        case CC_APP_AT_CMD_REQ_SET_CPWD:
        fd = g_zCcApp_ComFd[2];
        break;
            
        default:
        break;
    }
    
    return fd;
}
/********************************************
 *  send data
 *  fdcom: , data: , datalen: ݳ
 *  ʵʷͳ
 *********************************************/
int zCcApp_PortSend(int fdcom, CHAR *data, int datalen)
{
    int len = 0;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCcApp_PortSend:AtcmdMsg = %s\n",__FUNCTION__,data);
    len = write(fdcom, data, datalen);  //ʵдĳ
    if (len == datalen)
    {
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s zCcApp_PortSend succ fdcom=%d,data=%s,len=%d\n  <---\n",__FUNCTION__,fdcom,data,datalen);
        return len;
    }
    else
    {
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s zCcApp_PortSend fail fdcom=%d,data=%s,len=%d\n  <---\n",__FUNCTION__,fdcom,data,datalen);
        tcflush(fdcom, TCOFLUSH);
        return -1;
    }
}

/*******************************************
 *  receive data
 *  ʵʶֽ
 *
 ********************************************/
int zCcApp_PortRecv(int fdcom, CHAR *data, int datalen)
{
    
    char AtBuf[ZCC_APP_AT_BUF_MAX_LEN] = {0};
    int readlen = 0;
    readlen = read(fdcom, AtBuf, ZCC_APP_AT_BUF_MAX_LEN);
	if (readlen >= 0) { //cov m
		strncpy(data,AtBuf,readlen);
	}
	    
    return readlen;
}

/*******************************************
 *  Setup comm attr
 *  fdcom: ļ, pportinfo: õĶ˿Ϣs
 *
 ********************************************/
int zCcApp_PortSet(int fdcom, T_CC_APP_Portinfo *pPortinfo)
{
    struct termios  termios_old, termios_new;
    int             baudrate, tmp;
    char            databit, stopbit, parity, fctl;
    bzero(&termios_old, sizeof(termios_old));
    bzero(&termios_new, sizeof(termios_new));
    cfmakeraw(&termios_new);
    tcgetattr(fdcom, &termios_old);         //get the serial port attributions

    /*------------ö˿----------------*/
    //baudrates
    baudrate = convbaud(pPortinfo->baudrate);
    cfsetispeed(&termios_new, baudrate);        //봮˲
    cfsetospeed(&termios_new, baudrate);        //봮˲
    termios_new.c_cflag |= CLOCAL;          //ģʽ, ֤򲻻Ϊ˿ڵռ
    termios_new.c_cflag |= CREAD;           //ģʽ, ʹܶ˿ڶȡ

    // ģʽ, flow control
    fctl = pPortinfo->fctl;
    switch (fctl)
    {
        case '0':
        {
            termios_new.c_cflag &= ~CRTSCTS;        //no flow control
            break;
        }
        case '1':
        {
            termios_new.c_cflag |= CRTSCTS;         //hardware flow control
            break;
        }
        case '2':
        {
            termios_new.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
            break;
        }
        default:
        {
            //ZTE_LOG(LOG_ERR, "Unknown fctl %c\n", fctl);
            break;
        }
    }
    
    //ģʽ, data bits
    termios_new.c_cflag &= ~CSIZE;      //ģʽ, ַСλ
    databit = pPortinfo->databit;
    switch (databit)
    {
        case '5':
            termios_new.c_cflag |= CS5;
            //lint -fallthrough
        case '6':
            termios_new.c_cflag |= CS6;
            //lint -fallthrough
        case '7':
            termios_new.c_cflag |= CS7;
            //lint -fallthrough
        default:
            termios_new.c_cflag |= CS8;
    }
    
    //ģʽ parity check
    parity = pPortinfo->parity;
    switch (parity)
    {
        case '0':
        {
            termios_new.c_cflag &= ~PARENB;     //no parity check
            break;
        }
        case '1':
        {
            termios_new.c_cflag |= PARENB;      //odd check
            termios_new.c_cflag &= ~PARODD;
            break;
        }
        case '2':
        {
            termios_new.c_cflag |= PARENB;      //even check
            termios_new.c_cflag |= PARODD;
            break;
        }
        default:
        {
           //ZTE_LOG(LOG_ERR, "Unknown parity %c\n", parity);
           break;
        }
    }
    
    //ģʽ, stop bits
    stopbit = pPortinfo->stopbit;
    if (stopbit == '2')
    {
        termios_new.c_cflag |= CSTOPB;  //2 stop bits
    }
    else
    {
        termios_new.c_cflag &= ~CSTOPB; //1 stop bits
    }
    //other attributions default
    termios_new.c_oflag &= ~OPOST;          //ģʽ, ԭʼ
    termios_new.c_cc[VMIN] = 1;         //ַ, ҪȡַС
    termios_new.c_cc[VTIME] = 1;            //ַ, ȡһַĵȴʱ,   unit: (1/10)second
    tcflush(fdcom, TCIFLUSH);           //ݿԽ,
    tmp = tcsetattr(fdcom, TCSANOW, &termios_new);  //, TCSANOW: ɸıЧ
    
    tcgetattr(fdcom, &termios_old);

    //printf("%s \n",__FUNCTION__);
    //printf("%s %d: tty %d,baudrate %d,stopbit %d, parity%d, databit %d\n",__FUNCTION__,termios_old.tty,termios_old.baudrate,termios_old.stopbit,termios_old.parity,termios_old.databit);
    return(tmp);
}


/*******************************************
 *  Open serial port
 *  DevName: "/dev/armps_rpmsgch9" 
 *  ֵΪļ
 ********************************************/
int zCcApp_PortOpen(char* DevName)
{

    // serial port information
    T_CC_APP_Portinfo   PortInfo =  {'0',115200,'8',    '0','0','0','0','0','1', 0  };
    int  ComFd =0 ;//serial port handle

    int nTryOpen = 0;  
    ComFd = open(DevName, O_RDWR);  
    while (ComFd < 0)
    {
        //assert(nTryOpen < ZCC_APP_MAX_OPEN_PORT_TIMES);
        nTryOpen++;
        zCc_sleep(500);//500 ms later to try again
		ComFd = open(DevName, O_RDWR);	
    }

	if (ioctl(ComFd, (('R'<<8)|1|(0x4004<<16)), 0x400) < 0) {//cov m
		zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s ioctl1 fail\n  <---\n",__FUNCTION__);
	}
	if (ioctl(ComFd, (('R'<<8)|4|(0x4004<<16)), 0) < 0) {//cov m
		zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s ioctl2 fail\n  <---\n",__FUNCTION__);
	}
    zCcApp_PortSet(ComFd, &PortInfo);
    return ComFd;
}


int zCcApp_StartComm(void)
{
    /*򿪴*/    
    g_zCcApp_ComFd[1] = zCcApp_PortOpen(ZCC_APP_AT_COMM_CC);
    g_zCcApp_ComFd[2] = zCcApp_PortOpen(ZCC_APP_AT_COMM_SS);
    g_zCcApp_ComFd[3] = zCcApp_PortOpen(ZCC_APP_AT_COMM_DEV);
    g_zCcApp_ComFd[0] = zCcApp_PortOpen(ZCC_APP_AT_COMM_IND);
    return 0;   
}

int zCcApp_GetAtIndFd(void)
{
    int fd = 0;
    fd = g_zCcApp_ComFd[0];
    
    return fd;  
    
}

int zCcApp_GetAtCCFd(void)
{
    int fd = 0;
    fd = g_zCcApp_ComFd[1];
    
    return fd;  
    
}
#endif


