# /*****************************************************************************
#* Ȩ (C)2010, ͨѶɷ޹˾
#* 
#* ļ:     gcc_arm_tos.mk
#* ļʶ:     gcc_arm_tos.mk
#* ժҪ:     tos gccļ
#* ʹ÷:     include gcc_arm.mk
#* 
#* ޸        汾      ޸ı        ޸          ޸
#* -----------------------------------------------------------------------------
#* 2011/01/05      V1.0        Create                    
#* 
# ******************************************************************************/

#===============================================================================
# compiler tools path, TOS_GCC_ROOT is set in build_eCos.bat
#===============================================================================
GCC_ROOT    = $(TOS_GCC_ROOT)
GCC_BIN     = $(GCC_ROOT)/$(TOS_GCC_PATH)/bin
GCC_LIB     = $(TOS_LIB)

#===============================================================================
# compiler tools setup
#===============================================================================
CC          = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)gcc
CXX         = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)gcc
ASM         = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)as
AR          = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)ar
LD          = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)ld
ELF2BIN     = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)objcopy
ELF2SYM	    = $(GCC_BIN)/$(TOS_COMMAND_PREFIX)nm

#===============================================================================
# C include path setup
#===============================================================================
INCLUDE     =   -I$(ZP_ROOT)/                                               \
                -I$(TOS_INC)                                                \
                -I$(TOS_INC)/$(CPU_ARCH)

#===============================================================================
# C++ STL(standard template library) include path setup
#===============================================================================
STDINCLUDE  += 

#===============================================================================
# gcc flags setup
#===============================================================================
export CCFLAGS  =  -I$(TOS_INC)                                             \
                   -I$(TOS_INC)/$(CPU_ARCH)
export CCFLAGS  += -Wall -Wpointer-arith -Wstrict-prototypes -Wundef -Wno-write-strings -Wno-missing-braces -Wno-redundant-decls -Wfatal-errors
export CCFLAGS  += -fdata-sections -fno-exceptions -fshort-enums -fsigned-char -fno-schedule-insns -fno-schedule-insns2 -fstrict-volatile-bitfields
export CCFLAGS  += -march=$(CPU_ARCH) -mno-unaligned-access
#export CCFLAGS  += -finstrument-functions 
ifeq ($(THUMB), yes)
export CCFLAGS  += -mthumb
endif
export CCFLAGS  += -Wl,--gc-sections
export CCFLAGS  += -g -O2 -MD -c
export CXXFLAGS =  $(CCFLAGS)

#===============================================================================
# assembler flags setup
#===============================================================================
ASFLAGS     = -march=$(CPU_ARCH)

#===============================================================================
# archieve flags setup
#===============================================================================
ARFLAGS     = -rcs

#===============================================================================
# library include path setup
#===============================================================================
LDFLAG      = -Wl,--no-check-sections -nostartfiles -L$(GCC_LIB) -T$(OBJ_PATH)/os/tos/tos.ld

#===============================================================================
# ld setup
#===============================================================================
LDOUT       = 
LDMAP       = 

#===============================================================================
# elf to binary flags setup
#===============================================================================
ELF2BINOUT  = -O binary

#===============================================================================
# elf to symbol flags setup
#===============================================================================
ELF2SYMOUT	= -nCS --size-sort

#===============================================================================
# user defintion
#===============================================================================
export PLAT_GCC_OPTIMIZE    = -O2
export COM_GCC_OPTIMIZE     = -O2
export DRV_GCC_OPTIMIZE     = -O2
export PS_GCC_OPTIMIZE      = -O2
export TOOLS_GCC_OPTIMIZE   = -O2

