/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ 
*   ģ   :   ATI2ģͷļ
*      :   zati_com.h
*   ļʶ :   
*   ļ : 
*   ʵֹ :   
*        :   
*        :   1.0
*    :   2012/01/09
*   ˵ :
***************************************************************************/

#ifndef ZATI_COM_H
#define ZATI_COM_H
/* ϵͳͷļ */
#include <oss_api.h>
#include <pub.h>

/* ϵͳùͷļ */
#include "RONvConfig.h"
#include "RWNvConfig.h"

/* ⲿͷļ */
#ifdef ATI_FOR_2963 
#include "drvs_nv.h"
#endif
#include "atipsevent.h"
#include "apuiccint.h"
#include "atipscom.h"
#include "atipsint.h"
/* ڲͷļ */
#include "ps/src/nas/ati/inc/zati_int.h"
#include "ps/src/nas/ati/inc/zati_fnc.h"
#include "ps/src/nas/ati/inc/zati_typ.h"
#include "ps/src/nas/ati/inc/zat_com.h"

/**************************************************************************
 *                        궨                                          *
 **************************************************************************/
/*======================== general err code ===============================*/
#define Z_ATI_ZBAND_W_ACT        4
#define Z_ATI_ZBAND_LTE_ACT      3
#define Z_ATI_ZBAND_TD_ACT       2
#define Z_ATI_ZBAND_GSM_ACT      1
#define Z_ATI_ZBAND_NO_ACT       0

#define ZATI2_TOTAL_LEN             (1024 * 15)  //512//640//512
#define ZATI2_MUTEX_OPERAT_VTBUFF   "ZATI_MUTEX_OPERAT_VTBUFF"   /* VT BUFFź */

#define Z_ATI_EPSQOS_QCI_MIN    (BYTE)0
#define Z_ATI_EPSQOS_QCI_MAX    (BYTE)9
#define Z_ATI_EPSQOS_DLGBR_MAX  (DWORD)256000
#define Z_ATI_EPSQOS_ULGBR_MAX  (DWORD)256000
#define Z_ATI_EPSQOS_DLMBR_MAX  (DWORD)256000
#define Z_ATI_EPSQOS_ULMBR_MAX  (DWORD)256000

#define Z_ATI_AOC_EPPU_DIGIT_MAX_NUM                (BYTE)4  
#define Z_ATI_AOC_EX_MAX_VALUE                      (BYTE)7
#define Z_ATIPDI_UDPCONTENT_MAX_LEN                          (WORD)256       /*UDPݰ󳤶*/

#define Z_ATIPDI_ABORTCLEAN_VALID                            (BYTE)1         /*PDIյжϢҪձر*/
#define Z_ATI_UNOSL_CHANNEL_ALL_FREE                    (BYTE)0xFF   // ڷܻϱ


/***#define Z_ATI_SELECT_EFFECTIVE_SUBACT(GSM_SUBACT,TD_SUBACT,W_SUBACT,LTE_SUBACT)   \
  ((LTE_SUBACT != Z_ATI_INVALID_BYTE) ? LTE_SUBACT : ((GSM_SUBACT != Z_ATI_INVALID_BYTE) ? GSM_SUBACT : ((TD_SUBACT != Z_ATI_INVALID_BYTE)? TD_SUBACT : 
  W_SUBACT))) ******/  


/* ԭ */
#define Z_ATI_NOERROR_ERR                                    (DWORD)0
#define Z_ATI_NVFAILURE_ERR                                  ERR_NvFailure 
#define Z_ATI_INVALIDMSG_ERR                                 ERR_InvalidMsg
#define Z_ATI_INVALIDPARA_ERR                                ERR_InvalidPara
#define Z_ATI_INVALIDPDU_ERR                                 ERR_MMIA_InvalidPdu
#define Z_ATI_CMSINVALIDTEXTPARA_ERR                         ERR_MMIA_CMSINVALIDTEXTPARA
#define Z_ATI_UNKNOWN_ERR                                    (DWORD)0xff


#define Z_ATI_BYTE_BITNUM                                    (BYTE)8
#define Z_ATI_WORD_BITNUM                                    (WORD)16
#define Z_ATI_DWORD_BITNUM                                   (DWORD)32

#define Z_ATI_LONGNETNAME_MAX_LEN                 63    /*Ӫ̳󳤶*/
#define Z_ATI_SHORTNETNAME_MAX_LEN               63     /*Ӫ̶󳤶*/
/*========================= macro of general ===================================*/

/* ҵ绰Ľжϼ */
#define Z_ATI_QRYPB_SUCC                                     (BYTE)0     /*PBҳɹм¼*/
#define Z_ATI_QRYPB_FAIL                                     (BYTE)1     /*PBʧܣش*/
#define Z_ATI_QRYPB_INVALIDPARA                              (BYTE)2     /*PBصĲд*/

#define Z_ATI_INVALID_BYTE                                   (BYTE)0xff  /* ַͨЧֵ */
#define Z_ATI_INVALID_WORD                                   (WORD)0xffff  /* WORDͨЧֵ*/
#define Z_ATI_INVALID_DWORD                                  (DWORD)0xffffffff  /* DWORDͨЧֵ*/

#define Z_ATI_PROCFUNC_NUM                                   (DWORD)50  /* ATIģϢ */

#define Z_ATI_TRUE                                           TRUE
#define Z_ATI_FALSE                                          FALSE   
/* ATIԴ*/
#define Z_ATI_SRCINDEX                                       (BYTE)0xff


/* ģID */
#define Z_ATI_TASKID_MMIA                                    (BYTE)(SUBMDL_Z_ATI - SUBMDL_PSBASE)
#define Z_ATI_TASKID_ATI                                     (BYTE)(SUBMDL_Z_ATI - SUBMDL_PSBASE)                        
#define Z_ATI_TASKID_UMM                                     (BYTE)(SUBMDL_Z_UMM - SUBMDL_PSBASE)  
#define Z_ATI_TASKID_UICC                                    (BYTE)(SUBMDL_Z_UICCMNG - SUBMDL_PSBASE)
#define Z_ATI_TASKID_MCR                                     (BYTE)(SUBMDL_Z_UMCR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_CC                                      (BYTE)(SUBMDL_Z_CC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_PB                                      (BYTE)(SUBMDL_Z_STM - SUBMDL_PSBASE) 
#define Z_ATI_TASKID_SS                                      (BYTE)(SUBMDL_Z_SS - SUBMDL_PSBASE)
#define Z_ATI_TASKID_SM                                      (BYTE)(SUBMDL_Z_SM - SUBMDL_PSBASE)
#define Z_ATI_TASKID_SMS                                     (BYTE)(SUBMDL_Z_SMS - SUBMDL_PSBASE)
#define Z_ATI_TASKID_EMM                                     (BYTE)(SUBMDL_Z_EMM - SUBMDL_PSBASE)
#define Z_ATI_TASKID_GRR                                     (BYTE)(SUBMDL_Z_GRR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_URBC                                    (BYTE)(SUBMDL_Z_URBC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_GRRC                                    (BYTE)(SUBMDL_Z_GRRC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_CBS                                     (BYTE)(SUBMDL_Z_CBS - SUBMDL_PSBASE)
#define Z_ATI_TASKID_PDI                                     (BYTE)(SUBMDL_Z_PDI - SUBMDL_PSBASE)
#define Z_ATI_TASKID_ESM                                     (BYTE)(SUBMDL_Z_ESM - SUBMDL_PSBASE)
#define Z_ATI_TASKID_STM_ASSIST                              (BYTE)(SUBMDL_Z_STM_ASSIST - SUBMDL_PSBASE)
#define Z_ATI_TASKID_EUMCR                                   (BYTE)(SUBMDL_Z_EUMCR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_UCSR                                    (BYTE)(SUBMDL_Z_UCSR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_EUCSR                                   (BYTE)(SUBMDL_Z_EUCSR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_EUCER                                   (BYTE)(SUBMDL_Z_EUCER - SUBMDL_PSBASE)
#define Z_ATI_TASKID_L1E                                     (BYTE)(SUBMDL_Z_L1E - SUBMDL_PSBASE)
#define Z_ATI_TASKID_EUMTC                                  (BYTE)(SUBMDL_Z_EUMTC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_WMTC                                    (BYTE)(SUBMDL_Z_WMTC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_WRBC                                    (BYTE)(SUBMDL_Z_WRBC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_WCSR                                    (BYTE)(SUBMDL_Z_WCSR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_WMCR                                    (BYTE)(SUBMDL_Z_WMCR - SUBMDL_PSBASE)

#define Z_ATI_TASKID_GSMA                                   (BYTE)(SUBMDL_Z_GSMA - SUBMDL_PSBASE)
#define Z_ATI_TASKID_UMTC                                   (BYTE)(SUBMDL_Z_UMTC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_UCER                                   (BYTE)(SUBMDL_Z_UCER - SUBMDL_PSBASE)
#define Z_ATI_TASKID_USIR                                    (BYTE)(SUBMDL_Z_USIR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_UCMR                                   (BYTE)(SUBMDL_Z_UCMR - SUBMDL_PSBASE)
#define Z_ATI_TASKID_PSI                                    (BYTE)(SUBMDL_Z_PSI - SUBMDL_PSBASE)
#define Z_ATI_TASKID_ASC                                   (BYTE)(SUBMDL_Z_ASC - SUBMDL_PSBASE)
#define Z_ATI_TASKID_L1T                                    (BYTE)(SUBMDL_Z_L1T - SUBMDL_PSBASE)
#define Z_ATI_TASKID_L1W                                    (BYTE)(SUBMDL_Z_L1W - SUBMDL_PSBASE)

/********************************* LTE GoTaģ *******************************/
#ifdef BTRUNK_SUPPORT
#define Z_ATI_TASKID_TSM                                     (BYTE)(SUBMDL_Z_TSM - SUBMDL_PSBASE)
#endif

#define Z_ATI_FLYMODE_IN                                     (BYTE)0
#define Z_ATI_FLYMODE_OUT                                    (BYTE)1

/* ͨ */
#define Z_ATI_CH_RSV                                         (BYTE)0     /* Ԥ */
#define Z_ATI_CH_E                                           (BYTE)1     /* eר */ 
#define Z_ATI_CH_TDCRD                                       (BYTE)2     /* TSPݿר */
#define Z_ATI_CH_DCRD                                        (BYTE)3     /* ݿר */ 
#define Z_ATI_CH_MOBIL                                       (BYTE)4     /* ֻר */
#define Z_ATI_CH_INVALID                                     (BYTE)0XFF  /* Чͨ */

/*========================= macro of UMM ===================================*/

#define Z_ATI_PLMNINFOFLAG_COPS                              (BYTE)0  /* PlmnInfoظCOPSѡ */
#define Z_ATI_PLMNINFOFLAG_IND                               (BYTE)1  /* ϱPlmnInfo */

#define Z_ATI_CPLS_UPLMN                                     (BYTE)0  /* +cplsUPLMNȡֵ */
#define Z_ATI_CPLS_OPLMN                                     (BYTE)1  /* +cplsOPLMNȡֵ */
#define Z_ATI_CPLS_HPLMN                                     (BYTE)2  /* +cplsHPLMNȡֵ */

/* UPLMN/PLMNSelector пռ */
#define Z_ATI_PLMN_FULL                                     (BYTE)0
#define Z_ATI_PLMN_SPACE                                    (BYTE)1

#define Z_ATI_UTRAN_TD                                       (BYTE)0
#define Z_ATI_UTRAN_W                                        (BYTE)1

/* active״̬ */
#define Z_ATI_ACTIVE_MMCMDS                                  (BYTE)0 /* MM AT(cops/cgatt/zatt) */
#define Z_ATI_ACTIVE_CGAUTO                                  (BYTE)1
#define Z_ATI_ACTIVE_S0                                      (BYTE)2
#define Z_ATI_ACTIVE_DEFAULT                                 (BYTE)0XFF

#define Z_ATI_OPER_NUMTOLONG                                 (BYTE)0
#define Z_ATI_OPER_NUMTOSHORT                                (BYTE)1
#define Z_ATI_OPER_LONGTONUM                                 (BYTE)2
#define Z_ATI_OPER_SHORTTONUM                                (BYTE)3

#define Z_ATI_LONG_NAME                             (BYTE)0
#define Z_ATI_SHORT_NAME                             (BYTE)1
/*************+ZPLMNINFO******************/
#define Z_ATI_PLMN_ME                                                (BYTE)0
#define Z_ATI_PLMN_RESRVE                                         (BYTE)1
#define Z_ATI_PLMN_OPLPNN                                         (BYTE)2
#define Z_ATI_PLMN_NET                                             (BYTE)3
#define Z_ATI_PLMN_GLOBAL                                       (BYTE)4
#define Z_ATI_PLMN_NOTFIND                                (BYTE)5

/* פ״̬ */
#define Z_ATI_REG_HPLMN                                      (BYTE)0
#define Z_ATI_REG_ROAM                                      (BYTE)1
#define Z_ATI_NOTREG                                         (BYTE)2

/* UPLMN/PLMNSelector */
#define Z_ATI_PLMN_U                                         (BYTE)0
#define Z_ATI_PLMN_SEL                                       (BYTE)1

/*========================= macro of SMS ===================================*/
#define Z_ATI_SMSADDRESS_MAXLEN                              (BYTE)10   /* ַ */
#define Z_ATI_SCAADDRESS_MAXLEN                              (BYTE)11  /* SCAֵַ󳤶*/

#define Z_ATI_MAX_PDU_LEN                                    (BYTE)176
#define Z_ATI_MAX_TPDU_LEN                                   (BYTE)164
#define Z_ATI_MAX_TPUD_LEN                                   (BYTE)140
#define Z_ATI_MAX_TPCD_LEN                                   (BYTE)156

#define Z_ATI_ADDRTYPE_NORM                                  (BYTE)0
#define Z_ATI_ADDRTYPE_SCA                                   (BYTE)1

/* 
 * ATIʹõĶϢֵֵͣͬͣ
 * FOеMsgTypeId
 */
#define Z_ATI_SMSTYPE_DLV                                    (BYTE)0    /* ӦDELIVERϢ*/
#define Z_ATI_SMSTYPE_DLVRPT                                 (BYTE)1    /* ӦDELIVER REPORT Ϣ*/
#define Z_ATI_SMSTYPE_SUB                                    (BYTE)2    /* ӦSUBMIT Ϣ*/
#define Z_ATI_SMSTYPE_SUBRPT                                 (BYTE)3    /* ӦSUBMIT REPORT Ϣ*/
#define Z_ATI_SMSTYPE_CMD                                    (BYTE)4    /* ӦCOMMAND Ϣ*/
#define Z_ATI_SMSTYPE_SR                                     (BYTE)5    /* ӦSTATUS REPORT Ϣ*/
#define Z_ATI_SMSTYPE_RSRV                                   (BYTE)6   

#define Z_ATI_CNMIMT_e_NOROUTE                               (BYTE)0 
#define Z_ATI_CNMIMT_e_DIRECTROUTE                           (BYTE)1 
#define Z_ATI_CNMIMT_e_STOREIND                              (BYTE)2
#define Z_ATI_CNMIMT_e_ONLYSTOR                              (BYTE)3

#define Z_ATI_MSGWITHOUTSCA                                  (BYTE)0
#define Z_ATI_MSGWITHSCA                                     (BYTE)1

#define Z_ATI_SMS_TPVP_RELATIVE_LEN                          (BYTE)1
#define Z_ATI_SMS_TPVP_ABSOLUTEANDENHANCE_LEN                (BYTE)7

#define Z_ATI_SMS_FO_LEN                                     (BYTE)1
#define Z_ATI_SMS_MR_LEN                                     (BYTE)1
#define Z_ATI_SMS_SCTS_LEN                                   (BYTE)7
#define Z_ATI_SMS_DT_LEN                                     (BYTE)7
#define Z_ATI_SMS_ST_LEN                                     (BYTE)1
#define Z_ATI_SMS_PI_LEN                                     (BYTE)1
#define Z_ATI_SMS_PID_LEN                                    (BYTE)1
#define Z_ATI_SMS_DCS_LEN                                    (BYTE)1
#define Z_ATI_SMS_CT_LEN                                     (BYTE)1
#define Z_ATI_SMS_MN_LEN                                     (BYTE)1

#define Z_ATI_SMS_SRFIXLEN                                   (BYTE)(Z_ATI_SMS_FO_LEN + Z_ATI_SMS_MR_LEN + Z_ATI_SMS_SCTS_LEN +   \
                                                                   Z_ATI_SMS_DT_LEN + Z_ATI_SMS_ST_LEN + Z_ATI_SMS_PI_LEN +   \
                                                                   Z_ATI_SMS_PID_LEN + Z_ATI_SMS_DCS_LEN)

#define Z_ATI_SMSADDR_LENFIELD_SIZE                          (BYTE)1
#define Z_ATI_SMSADDR_TYPEFIELD_SIZE                         (BYTE)1
/*========================= macro of CC ===================================*/
#define  Z_ATI_MAX_CALLINGBCDNUM_NUM                         (BYTE)10

#define  Z_ATISS_PW_LENGTH                                   (BYTE)4

#define Z_ATI_NOSIMECC_MAXNUM                                (BYTE)6 /* ޿ʱԱȵĺ*/
#define Z_ATI_GENELECC_MAXNUM                                (BYTE)2 /* ͨõĺ*/

#define Z_ATI_AOC_TIMER_INTERVAL                             (WORD)(10*1000)   /* +CAOC 10Ӷʱʱ*/
/*========================= macro of SS ===================================*/
#define  Z_ATISS_CLCKSTATUS_MAXNUM                           (BYTE)8


/*========================= macro of SM ===================================*/
#define Z_ATI_MAX_PDPADDR_LEN                                (BYTE)40   /*PDPַ󳤶*/
#define Z_ATI_MAX_APN_LEN                                    (BYTE)100  /*APN󳤶*/

#define Z_ATI_PDP_NotDefine                                  (BYTE)0 /* δ */
#define Z_ATI_PDP_Define                                     (BYTE)1 /* Ѷ */

#define Z_ATI_QOS_NotDefine                                  (BYTE)0 /* δ */
#define Z_ATI_QOS_Define                                     (BYTE)1 /* Ѷ */

#define Z_ATI_CONTXT_First                                   (BYTE)0 /* һ */
#define Z_ATI_CONTXT_Secnd                                   (BYTE)1 /*  */

/* 2GQosݵ2Դר2GQosμ */
#define Z_ATI_2GQos_ForUp                                    (BYTE)0 
#define Z_ATI_2GQos_ForUpMin                                 (BYTE)1

/* 3GQos of request ݵԴڲ */
#define Z_ATI_3GQosReq_ForUp                                 (BYTE)0

/* 3GQos of min ݵԴڲ */
#define Z_ATI_3GQosMin_ForUp                                 (BYTE)0

/*========================= macro of CBS ===================================*/
/*CBS*/
#define Z_ATI_CBS_PDU_LEN                                    (BYTE)88

/*CSCB mode궨*/
#define Z_Ati_Cbs_ACCEPT                                     (BYTE)0    
#define Z_Ati_Cbs_NOTACCEPT                                  (BYTE)1


/*========================= macro of other ===================================*/

/*provide local infomation type*/
#define Z_ATI_USAT_LOCALINFO                                 (BYTE)0x00
#define Z_ATI_USAT_IMEI                                      (BYTE)0x01
#define Z_ATI_USAT_TIMEZONE                                  (BYTE)0x03
#define Z_ATI_USAT_ACT                                       (BYTE)0x06
#define Z_ATI_USAT_IMEISV                                    (BYTE)0x08

#define Z_Ati_UICC_ForMaxLen_FLG                             (BYTE)0
#define Z_Ati_UiccCmdType_Max                                (BYTE)3

#define Z_ATI_RptRxlev_DISABLE                               (BYTE)0
#define Z_ATI_RptRxlev_ENABLE                                (BYTE)1

/*ϴȡֵĿк: 0 , 1 ѯ*/
#define Z_ATI_OperType_Set                                   (BYTE)0
#define Z_ATI_OperType_Qry                                   (BYTE)1
#define Z_ATI_OperType_MAX                                   Z_ATI_OperType_Qry     /*úͲѯȡֵֵ*/

/*ϴȡֵĿк: 0 ر, 1 */
#define Z_ATI_SetType_Disable                                (BYTE)0
#define Z_ATI_SetType_Enable                                 (BYTE)1
#define Z_ATI_SetType_MAX                                    Z_ATI_SetType_Enable     /*ÿصȡֵֵ*/

/* eпʼ״̬ */
#define Z_ATI_CARDINIT_NOT                                   (BYTE)0     /* δʼ */
#define Z_ATI_CARDINIT_ING                                   (BYTE)1     /* ڳʼ */
#define Z_ATI_CARDINIT_FINISH                                (BYTE)2     /* ɳʼ */

/*ʼ*/
#define Z_CARD_NOT_INIT                                     (BYTE)0   /*δʼ*/
#define Z_CARD_INIT_ERR                                     (BYTE)1   /*ʼʧܻ߰ο*/
#define Z_CARD_INIT_SUCC                                    (BYTE)2  /*ʼɹ*/

/* Ϊ+AUTOSTART*/
#define Z_ATI_AUTOSTART_INIT                                 (BYTE)0 
#define Z_ATI_AUTOSTART_WAITUICCINIT                         (BYTE)1 
#define Z_ATI_AUTOSTART_CARDWRONG                            (BYTE)2 
#define Z_ATI_AUTOSTART_WAITRFON                             (BYTE)3 
#define Z_ATI_AUTOSTART_CARDOK                               (BYTE)4 


#define Z_ATI_MSGINDEX_AUTOSTART                             (BYTE)0
#define Z_ATI_MSGINDEX_QUERYIMSI                             (BYTE)1
#define Z_ATI_MSGINDEX_ATCMD                                 (BYTE)2

#define Z_ATI_CELLINFO_SET                                   (BYTE)0
#define Z_ATI_N_CELLINFO_SET                                 (BYTE)1

#define Z_ATI_EFSST_ELEMENT_VALID_BITS                       (BYTE)3
/*========================= macro of not used ===================================*/

#define Z_CSR_MAX_GSMFREQ_NUM                                 (BYTE)32/*UEֵ֧2GƵ*/
#define Z_CSR_MAX_PARTITION_NUM                               (BYTE)8 /*ÿʽƵλ*/    
#define Z_CSR_MAX_ACT_NUM                                     (BYTE)2 /*UEֵ֧AcT*/
#define Z_CSR_MAX_UTRANFREQ_NUM                               (BYTE)8 /*UEֵ֧3GƵ*/


#define Z_ATI_NVITEM_PDPCNTXT                                (BYTE)1
#define Z_ATI_NVITEM_TFT                                     (BYTE)2
#define Z_ATI_NVITEM_QOS                                     (BYTE)3
#define Z_ATI_NVITEM_MINQOS                                  (BYTE)4
#define Z_ATI_NVITEM_EQOS                                    (BYTE)5
#define Z_ATI_NVITEM_MINEQOS                                 (BYTE)6

#define Z_ATI_MAX_STR_LEN                                    (BYTE)50 

#define Z_ATI_ACTIVECNFFLAG_COPS                             (BYTE)0  /* ActiveCnfظCOPSע */ 
#define Z_ATI_ACTIVECNFFLAG_CGATT                            (BYTE)1  /* ActiveCnfظCGATT */

#define Z_ATI_MEMAVAIL_NOTSUCC                               (BYTE)0
#define Z_ATI_MEMAVAIL_SUCC                                  (BYTE)1

#define Z_ATI_S1_MODE        (BYTE)0
#define Z_ATI_IU_MODE        (BYTE)1

#define Z_ATI_CSQ      (BYTE)0
#define Z_ATI_ZSQ      (BYTE)1
/*==============================================================================*/
#define Z_ATI_NET_NOTREG                                     (BYTE)0  /*ǰδע*/       
#define Z_ATI_NET_REG                                        (BYTE)1  /*ǰע*/
#ifdef Z_SELL_STAT_SUPPORT
/*ͳ޶ʱ*/
#define Z_ATI_SellStat_OnePdpTime                            (DWORD)(60*30*1000)    /* 30 min: 60*30*1000 */
#define Z_ATI_SellStat_SumPdpTime                            (DWORD)(60*60*2*1000)  /* 2 hours: 60*60*2*1000 */
#define Z_ATI_SellStat_RegOnce                               (DWORD)(60*60*1*1000)  /* 1 hours: 60*60*1*1000 */

#define Z_ATI_SellStat_OnePdpTime_Debug                      (DWORD)(60*1000)       /* 1 min: 60*1000*/
#define Z_ATI_SellStat_SumPdpTime_Debug                      (DWORD)(60*3*1000)      /* 3 min: 60*3*1000*/
#define Z_ATI_SellStat_RegOnce_Debug                         (DWORD)(60*2*1000)      /* 2 min: 60*2*1000*/

#define Z_ATI_SellStat_Max_RegNum                            (BYTE)3

#define Z_ATI_SellStat_TestOn                                (BYTE)1               /*ͳƲģʽ*/
#define Z_ATI_SellStat_TestOff                               (BYTE)0               /*ͳƲģʽر*/

#define Z_ATI_LASTNOTREGFG_INVALID                           (BYTE)0               /*ǰһ״̬Ϊע̬*/
#define Z_ATI_LASTNOTREGFG_VALID                             (BYTE)1               /*ǰһ״̬Ϊע̬*/
#endif
#define Z_ATI_MAX_DNSIPADDR_LEN                              (BYTE)4               /*DNS IP ַ󳤶*/  

#define Z_ATI_CIDINFO_PDPACT                                 (BYTE)1              /*PDP*/
#define Z_ATI_CIDINFO_PDPDEACT                               (BYTE)0              /*PDPδ*/

/* PCOprotocol identifiersֶȡֵ */
#define Z_ATI_PROTO_ID_LCP                   (WORD)0xC021
#define Z_ATI_PROTO_ID_PAP                   (WORD)0xC023
#define Z_ATI_PROTO_ID_CHAP                  (WORD)0xC223
#define Z_ATI_PROTO_ID_IPCP                  (WORD)0x8021
#define Z_ATI_PROTO_ID_IPV6CP                (WORD)0x8057

/* PCOadditional parameters listֶȡֵնPCOȡֵμ24.008 10.5.6.3Table 10.5.154 */
#define Z_ATI_ADDPARA_ID_PCSCF_IPV6ADDR        (WORD)0x0001
#define Z_ATI_ADDPARA_ID_IMS_SIGNAL_FLG        (WORD)0x0002
#define Z_ATI_ADDPARA_ID_DNS_SRV_IPV6ADDR      (WORD)0x0003
#define Z_ATI_ADDPARA_ID_RESERVED4       (WORD)0x0004 /*Эϲ֧ID*/
#define Z_ATI_ADDPARA_ID_SUPPORT_BC_INDICATOR  (WORD)0x0005
#define Z_ATI_ADDPARA_ID_RESERVED6              (WORD)0x0006
#define Z_ATI_ADDPARA_ID_DSMIPV6_HA_ADDR       (WORD)0x0007
#define Z_ATI_ADDPARA_ID_DSMIPV6_HN_PREF       (WORD)0x0008
#define Z_ATI_ADDPARA_ID_DSMIPV6V4_HA_ADDR     (WORD)0x0009
#define Z_ATI_ADDPARA_ID_IPADDR_VIA_NAS_SIGNAL (WORD)0x000A
#define Z_ATI_ADDPARA_ID_IPV4ADDR_VIA_DHCPV4   (WORD)0x000B
#define Z_ATI_ADDPARA_ID_PCSCF_IPV4_ADDR       (WORD)0x000C
#define Z_ATI_ADDPARA_ID_DNS_SRV_IPV4_ADDR     (WORD)0x000D
#define Z_ATI_ADDPARA_ID_MSISDN                (WORD)0x000E
#define Z_ATI_ADDPARA_ID_IFOM                  (WORD)0x000F
#define Z_ATI_ADDPARA_ID_IPV4MTU               (WORD)0x0010

#define Z_ATI_ADDPARAID_IPV6DNS                              (BYTE)0x03
#define Z_ATI_PROTOCOLID_IPCP                                (WORD)0x8021         /*IPCPProtocol ID*/
#define Z_ATI_IPCPHEAD_LEN                                   (BYTE)4              /*IPCPͷ,:
                                                                                         ݱ---1ֽ
                                                                                         ݱıʾ---1ֽ
                                                                                         ݱĳ-----2ֽ,ȰͷϢ,ϢԼ*/
#define Z_ATI_PRIMDNSSER_ADDR                                (BYTE)0x81
#define Z_ATI_SECMDNSSER_ADDR                                (BYTE)0x83
#define Z_ATI_IPV4DNSIP_VAL_LEN                              (BYTE)4
#define Z_ATI_IPV4DNSIP_HEAD_LEN                             (BYTE)2
#define Z_ATI_PAPCHAPDNSIP_VAL_LEN                              (BYTE)4

#define Z_ATI_AUTO_START                                     (BYTE)1
/*Ǩ״̬*/
#define Z_ATI_PS_MOVE_ORIGIN  0    //ʼ̬
#define Z_ATI_PS_MOVE_IN_PROCESS  1    //Ǩ
#define Z_ATI_PS_MOVE_INSERT_USER_DISCONNECT  2  //ǨյûҶ

/*ѡֵ*/
#define Z_ATI_LTE_THRESH_RSRP        97
#define Z_ATI_LTE_THRESH_RSRP_H        97
#define Z_ATI_LTE_THRESH_RSRQ        34
#define Z_ATI_LTE_THRESH_RSRQ_H        34   
#define Z_ATI_TD_THRESH_RSCP      96
#define Z_ATI_TD_THRESH_RSCP_H       96

/****************+ZRPISET*******************/
#define Z_ATI_RPIACT_LTE        0
#define Z_ATI_RPIACT_W          1
#define Z_ATI_RPIACT_GSM        2

/***************+CTZR*******************/
#define Z_ATI_DISABLE_MOD      0
#define Z_ATI_CTZV_MOD      1

/***************+ZMOBILE***************/
#define Z_ATI_MIN_T3411_TRYED_NUM    3
#define Z_ATI_MAX_T3411_TRYED_NUM    15

/***************+ZEPCG***************/
#define Z_ZEPCG_IND_CMD    25

#define Z_NORMAL_SRV    0
#define Z_LIMIT_SRV    1
#define Z_NO_SRV    2
/**************+ZSCHPLMN*************************/
#define Z_NOT_SEARCH_PLMN    0
#define Z_SEARCH_PLMN    1
/**************ϱʽ***************/
#define Z_CEER_TEXT  0
#define Z_CEER_NUM   1
/**************ʹģ*************/
#define Z_CEER_CC   0
#define Z_CEER_SM  1
#define Z_CEER_ESM  2
#define Z_CEER_UMM  3
#define Z_CEER_MM  4
/*************Ӫ̳洢λ***************/
#define Z_ATI_OPLPNN        0
#define Z_ATI_NET              1
#define Z_ATI_ME                2
#define Z_ATI_GLOBAL       3

#define Z_ATI_IND_NUM     10   //COPNѯеϱ
/*TMGIб*/
#define Z_ATI_TMGI_ACT            0
#define Z_ATI_TMGI_AVA            1
#define Z_ATI_TMGI_OOS            2

#define     Z_ATI_USAT_CMDSUCC_LIMITSRV        (BYTE)6
#define     Z_ATI_USAT_CMDSUCC_NORMSRV        (BYTE)0

/****************+ZTMGIACT**************/
#define Z_ATI_TMGI_DEACTIVE                 (BYTE)0
#define Z_ATI_TMGI_ACTIVE                 (BYTE)1
#define Z_ATI_TMGI_LEN                     (BYTE)11  /**TMGIΪ11ַ*/

#define Z_ATI_TMGI_DEACT_SUCC        (BYTE)0/*ȥɹ*/
#define Z_ATI_TMGI_DEACT_DUPLC       (BYTE)3/*ظȥ*/
/****************SCA******************/
#define Z_ATI_CSCA                (BYTE)0
#define Z_ATI_ZSCA                (BYTE)1
/****************CSMP*******************/
#define Z_ATI_CSMP                (BYTE)0
#define Z_ATI_ZSMP                (BYTE)1
/*********************AMR_CODETYPE********************/
#define Z_ATI_CODETYPE_NB           (BYTE)0
#define Z_ATI_CODETYPE_WB           (BYTE)1
/*********************AmrPath**************************/
#define Z_ATI_AMRPATH_TEAK           (BYTE)0/*teak*/
#define Z_ATI_AMRPATH_OPEN           (BYTE)1/*Դ*/
/*********************+ZUECAPASET*****************************/
#define Z_ATI_MAX_CDRX               (BYTE)3
#define Z_ATI_MAX_ANR                (BYTE)7

/**********************SMģʹõCID*******************/
#define Z_ATI_SM_MIN_CID           (BYTE)1
#define Z_ATI_SM_MAX_CID           (BYTE)4


/**********************ECALL TYPE************************/
#define Z_ATI_NOTSUP_ECALL     (BYTE)0/*eCall not support*/
#define Z_ATI_ECALL_ONLY     (BYTE)1/*eCall Only support*/
#define Z_ATI_ECALL_NORMCALL    (BYTE)2/*eCall and Normal call support*/
/**********************NUM OR URI************************/
#define  Z_ATI_ECALL_NUM_NOT_SUP      (BYTE)0
#define  Z_ATI_ECALL_NUM_SUP      (BYTE)1
#define  Z_ATI_ECALL_URI_NOT_SUP      (BYTE)0
#define  Z_ATI_ECALL_URI_SUP      (BYTE)1
/**********************ecall type*************************/
#define Z_ATI_TEST_ECALL      (BYTE)0/*test call*/
#define Z_ATI_RECFG_ECALL      (BYTE)1/*reconfiguration call eCall*/
#define Z_ATI_MANUINIT_ECALL      (BYTE)2/*manually initiated eCall*/
#define Z_ATI_AUTOINIT_ECALL      (BYTE)3/*automatically initated eCall*/
/*********************ps done***************************/
#define Z_ATI_PSDONE_CECALL        (BYTE)0/*+CECALL*/
#define Z_ATI_PSDONE_ZECALL        (BYTE)1/*+ZECALL*/
/*********************num type*************************/
#define Z_ATI_TEST_NUM      (BYTE)0/*test num*/
#define Z_ATI_RECFG_NUM      (BYTE)1/*reconfiguration number num*/


#ifdef DSDS_VSIM
/**********************״̬***************************/
#define Z_ATI_CARD_DEACT           (BYTE)0
#define Z_ATI_CARD_ACT             (BYTE)1

/********************п֮Ƿؽ********************/
#define Z_ATI_AFTCRDSWH_NONEST           (BYTE)0 //п֮ؽ
#define Z_ATI_AFTCRDSWH_EST             (BYTE)1//п֮ؽ

/*********************л״̬***************************/
#define Z_ATI_CARD_NOTSWITCH       (BYTE)0
#define Z_ATI_CARD_SWITCHING       (BYTE)1
#endif
/*svȱʡֵ*/
#define Z_IMEISV_RESERVE_VALUE       (BYTE)0x99
#define Z_IMEI_DIGIT_LEN                      (BYTE)15

/*FRŻֵ*/
#define Z_ATI_MAX_LTE_FROP_TIME_LEN        10

/*FPLMNLIST һʾ*/
#define Z_APMMIA_MAX_FPLMN_NUM    12
//#define Z_ATI_UNSOL_CHNL_3                  (BYTE)3   /* οZCTRM_MUX_CHIDֵһ*/
// ط
#define ZAT2_SUB_PARAM_MAX_LEN 512                    /* Ӳ󳤶 */
#define ZAT2_HEXFMTPA_MAX_LEN 1024                      /*16Ʋ󳤶*/
#define Z_ATI_CALLBACK_FUNC_INDEX_IS_VALID(_FUNC_INDEX_)   ((_FUNC_INDEX_) < Z_ATI_PROCFUNC_NUM)

#define ZAT2_INTEGER_PARAM_MAX_LEN 10                    /* Ͳ󳤶ȣֵҪ10 */
/*atiԴNASCOM.Hpsl1com.h,˺ֵҪpsl1com.hеEVENT_CARD_CONFIGֵһ*/
#define Z_ATI_EVENT_CARD_CONFIG              10

/****************+ZGPCOCHAP**************/
#define Z_ATI_ZGPCOCHAP_CHALLENGE_MAXLEN             (BYTE)64

#define Z_ATI_EM_TIMER_MAXLEN                   (BYTE)100  /* ģʽСϢʱʱλ */

extern const UINT8 g_zAt_Latin1GsmTable[256];
extern UINT8 g_zAti_CurInstance;

/**************************************************************************
 *                        ATI ڲݽṹ                               *
 **************************************************************************/
/*  */

/* ǰplmnϢ */
typedef struct 
{
    T_z_PlmnId                                            tPlmnId;
    BYTE                                                    bAct;               /* 0xffЧ */
    BYTE                                                    bSubMode;           /* ϵͳģʽ*/
    BYTE                                                    bUtranAct;          /* 0 td, 1 wcdma, 3GʽΪAT^MODE */
    BYTE                                                    bRac;
    T_z_Act                                                 tAct;
    BYTE                                                    abLac[2];           /* ǰλ */
    BYTE                                                    abTac[2];           /* */
    BYTE                                                    abCi[4];
} T_zAti_PlmnPara;                        

/* pduSUBMITϢ */
typedef struct 
{
    T_zApMmia_TpAddress                                  tTpda;              /* Ŀĵַ */ 
    BYTE                                                    bCharNum;           /*ıַȡֵΪZ_APATI_MAX_SMSTEXTCHAR_LEN*/
    WORD                                                    wTextLen;           /* ı */
    PBYTE                                                   pbTextBuf;          /* ı */
} T_zAti_TxtSubMsg;

/* pduCMDϢ */
typedef struct 
{
    T_zApMmia_TpFo                                       tTpfo;
    T_zApMmia_TpAddress                                  tTpda;              /* Ŀĵַ */    
    BYTE                                                    bCmdType;
    BYTE                                                    bMn;
    BYTE                                                    bPid;
    WORD                                                    wTextLen;           /* ı */
    PBYTE                                                   pbTextBuf;          /* ı */
} T_zAti_TxtCmdMsg;

/* pdu, pdu */
typedef struct 
{
    BYTE                                                    bTpmr;              /* ʱ0xff */    
    WORD                                                    wPduLen; 
    PBYTE                                                   pbPduBuf;
} T_zAti_PduMsg;

/* deliver pdu  */
typedef struct 
{
    T_zApMmia_TpAddress                                  tSca;
    T_zApMmia_TpAddress                                  tTpoa;
    T_zApMmia_TpFo                                       tTpFo;
    BYTE                                                    bPid;
    BYTE                                                    bDcs;
    BYTE                                                    abScts[7];
    BYTE                                                    bCharNum;
    WORD                                                    wTxtLen;
    PBYTE                                                   pbTxtBuf;
} T_zAti_TxtDlvMsg;

/* status pdu  */
typedef struct 
{
    T_zApMmia_TpFo                                       tTpFo;
    T_zApMmia_TpAddress                                  tTpra;
    BYTE                                                    abScts[7];
    BYTE                                                    abDisTime[7];
    BYTE                                                    bStatVal;   
    BYTE                                                    bTpmr;
} T_zAti_TxtStatMsg;

typedef struct
{
    T_zApMmia_TpAddress                                  tSca;
    T_zApMmia_TpAddress                                  tTpda;
    T_zApMmia_TpFo                                       tTpFo;
    BYTE                                                    bPid;
    BYTE                                                    bDcs;
    BYTE                                                    bVpLen;
    BYTE                                                    abVp[7];
    BYTE                                                    bCharNum;
    WORD                                                    wTxtLen;
    PBYTE                                                   pbTxtBuf;
} T_zAti_SubmitMsg;
/* ͨģӳ, ڴģĵһҪabort*/
typedef struct
{
    BYTE                                                    bSrcIndex;          /* ATCͨ */
    BYTE                                                    bCmMdl;             /* ģ */
} T_zAti_ChMdlTable;

typedef struct 
{
    BYTE                                                    abEccCode[3];
    BYTE                                                    bLen;
}T_zAti_NosimEcc, T_zAti_GeneralEcc;

/* uplmn༭ */
typedef struct 
{
    BYTE                                                    bIndex;         /* 0 ΪЧֵ */
    T_z_PlmnAct                                           tPlmnAct;
} T_zAti_UPlmnEle;

/**************************************************************************
              EFAAeM (Automatic Answer for eMLPP Service)ļ 
 **************************************************************************/
typedef struct
{
    BYTE                                         bAutoAnswerLevel;
} T_zAti_EFaaem;

typedef struct{
    BYTE                                         bSrcIndex;                     /* The source index */
    BYTE                                         bDesIndex;                     /* The destination index */

    BYTE                                         abPadding[2];
} T_zAti_Index;

/*  */
typedef struct
{
    BYTE                                         bFunBak;       /* ݱ */
    BYTE                                         bFunVal;       /* funֵ0xffЧ */
    BYTE                                         bRfVal;
    BYTE                                         bPadding;
} T_zAti_Fun;

/*CIDϢ*/
typedef struct
{
    BYTE                                         bPdpActFg;  
    BYTE                                         bPdpType;      
    BYTE                                         abPadding[2];

    BYTE                                         abDnsIpAddr[Z_ATI_MAX_DNSIPADDR_LEN];
    BYTE                                         abPdpAddr[Z_APMMIA_SM_MAX_PDPADDR_LEN];
}T_zAti_CIDInfo;
/*PSǨϢ*/
typedef struct
{
    BYTE        bPsMovStatus;/*Z_ATI_PS_MOVE_ORIGIN  0
                                                    Z_ATI_PS_MOVE_IN_PROCESS  1
                                                    Z_ATI_PS_MOVE_INSERT_USER_DISCONNECT  2  */
    BYTE        abDisConnChnl[Z_MMIASM_MAX_CID_NUM];
    BYTE        abPadding[2];
}T_zAti_PsMovInfo;

enum 
{
    Z_ATI_AT_CMD_CACM,
    Z_ATI_AT_CMD_CAMM,    
    Z_ATI_AT_CMD_CPUC,
    Z_ATI_AT_CMD_ZPIN2,
    Z_ATI_AT_CMD_MAX
};

typedef struct
{
    BYTE ab2Para[2];
    WORD wPara;

    BYTE ab3Para[3];
    BYTE bPadding;

    DWORD dwPara;
}T_zAti_AocParaRec;

typedef struct
{
    BITS                                                bSpare:5;
    BITS                                                bQciFlg:1;        /*Ƿ񷵻QCI*/
    BITS                                                bUlDlGbrFlg:1;    /*Ƿ񷵻GBR*/
    BITS                                                bUlDlMbrFlg:1;    /*Ƿ񷵻MBR*/

    BYTE                                                bQci;
    BYTE                                                abPadding[2];

    DWORD                                               dwDlGbr;
    DWORD                                               dwUlGbr;

    DWORD                                               dwDlMbr;
    DWORD                                               dwUlMbr;
}T_zAti_EpsQos;

enum {
    Z_ATI_READUICC_CSAS,        
    Z_ATI_READUICC_CRES,        
    Z_ATI_READUICC_SMSP,        
    Z_ATI_READUICC_SMSS,        
    Z_ATI_READUICC_PLMNLIST,    
    Z_ATI_READUICC_PUCT,        
    Z_ATI_READUICC_ACMMAX,      
    Z_ATI_READUICC_LANGUAGE,
    Z_ATI_READUICC_IMSI,
    Z_ATI_READUICC_ACL,
    Z_ATI_READUICC_ACLAPN,
    Z_ATI_READUICC_SMSS_TPMR
};

typedef struct
{
    UINT8               arrData[ZATI2_TOTAL_LEN];
    UINT16              iUsedLen;  /* (൱дָ)ѾɵݳȣҪbEndʹ */
    UINT16              iReadLen;  /* ָ룬TAFָ */
    UINT16              iCopyedLen; /* (൱ڶָ)ѾߵݳȣiUsedLen */
    BOOL                bEnd; /* дָѾͷΪTRUEiCopyedLenҲѾͷΪFALSE */
    ZOSS_MUTEX_ID       mutexVtBuff;
}T_ZAti_VtBuff;

typedef struct 
{
    WORD wOffsetBase;
    WORD wDataLen;
}T_zAti_ZgiidfRetrieveRange;

typedef struct
{
    BYTE bSrcIndex;
    BYTE bDesIndex;
    BYTE bReadKey;
    BYTE bPadding;

    T_z_UICC_SPN tSpn;
    T_zMmiaSms_MsgSend_Cnf tMsgSendCnf;
    T_zAti_ZgiidfRetrieveRange tZgiidRange;
}T_zAti_UiccInfo;

typedef struct
{
    T_ZAti_ZgdataTestSetReq            tPsZgdtInfo;
    ZOSS_TIMER_ID             pTimrIdZgdt;       /*+ZGDATATEST psʱʱ*/
    BYTE            bCurrTime; /*ǰԴ*/
    BYTE            abPadding[3];
}T_zAti_PsDataTest_Info;

typedef struct
{
    T_ZAti_ZgdataTestSetReq    zTest;
    UINT16                      iCurrTimes; /* Ѿ͵Ĵ */
    ZOSS_TIMER_ID               timerSendCsData;
}T_zAti_CsDataTest_Info;

typedef struct
{
    T_zAti_PsDataTest_Info  tPsDataTestInfo;
    T_zAti_CsDataTest_Info  tCsDataTestInfo;
}T_zAti_DataTest;

typedef struct
{
    BYTE                    bCcNotifyOpenAocTimer;    /* CCָʾAOCʱ򿪻ǹر*/
    BOOL                    boCcmQuery;          /* can del  ʹindex ж*/ /* true +CAOCѯCCM */
    BYTE                     abPadding[2];
    DWORD                dwCurrCcm;           /* ϵCCM  */
    ZOSS_TIMER_ID       pAocTimer;          /* AOCʱ */ 
}T_zAti_Aoc_Info;

typedef struct
{
    BYTE                                        bTpdaFlg;  /* ָʾtTpdaЧ,ȡֵZ_VALID/Z_INVALID */
    BYTE                                        abPadding[3];
    T_zApMmia_TpAddress        tTpda;    /*SMS TPDA*/
}T_zAti_Sms_TpdaInfo;

typedef struct
{
    BYTE                                                    bUmmCauseRpted;
    BYTE                                                    bCcCauseRpted;      /* ʶCCǷϱȡֵZ_VALID/Z_INVALID */
    BYTE                                                    bSmCauseRpted;      /* ʶSMǷϱȡֵZ_VALID/Z_INVALID */
    
    BYTE                                                    bPsCauseFg;
    BYTE                                                    bCcCauseFg;         /* ָʾcccauseǷЧ */
    BYTE                                                    bSmCauseFg;       /* ָʾSmCauseǷЧ */
    BYTE                                                    bEsmCauseFg;       /* ָʾSmCauseǷЧ */
    BYTE                                                    bCsCauseFg;

    BYTE                                                    bBkOffTimeFg;
    BYTE                                                    abPadding[3];

    DWORD                                               dwCcCause;          /* ʧԭ0xffffffff Ч*/
    DWORD                                               dwSmCause;        /* gprsʧԭ0xffffffff Ч */
    DWORD                                               dwUmmCause;
    DWORD                                               dwEsmCause; 
    DWORD                                               dwPsCause;
    DWORD                                               dwCsCause;
    DWORD                                               dwBkOffTime;//s
}T_zAti_Ceer_Info;

typedef struct {
    T_ZAti_VtBuff                          *ptVtBuff;
    WORD                                  wDataRemainLen;
    BYTE                                     abPadding[2];
}T_zAti_CsdBuf_Info;
/*οЭ31102 - 4.2.58/4.2.59*/
 typedef struct {
    T_z_PlmnId      tPlmnId;
    BYTE    bPadding;
    BYTE    abFullName[Z_MAX_LONGNAME_LEN];
    BYTE    abShortName[Z_MAX_SHORTNAME_LEN];
    BYTE    abLacStart[2];
    BYTE    abLacEnd[2];
}T_zAti_Plmninfo;

typedef struct {
    BYTE   bRecNum;/*PLMNID*/
    T_zAti_Plmninfo*    atPmnInfo[255];
}T_zAti_Card_PnnOpl;
typedef struct{
    BYTE                    bLastNotRegFg;      /*ǰ״̬ΪעλͳƿRegʱʱʹ
                                                                       жΪעʱλ
                                                                       עᶨʱʱȥλ*/
    BYTE                    bPdiUsedCid;        /*PDIʹõcid, 0xffΪʼֵЧֵ*/
    BYTE                    bSellStatDebug;     /* ȡNVοЧ */
    BYTE                    bSellStatTestFg;    /*ͳƲģʽλ*/
    DWORD               dwSumPdpBeginTick;   /*ۼPDPʱʱtick*/
    DWORD               dwSumPdpEndTick;      /*ۼPDPʱرʱtick*/

    ZOSS_TIMER_ID                                pOnePdpTimer;       /*PDPʱ*/
    ZOSS_TIMER_ID                                pSumPdpTimer;       /*ۼPDPʱ*/
    ZOSS_TIMER_ID                                pRegTimer;              /*עᶨʱ*/
}T_zAti_SellStat_Info;

typedef struct {
    BYTE                        bSrcIndex;
    BYTE                        bDesIndex;
    BYTE                        bCsgSelMode;
    BYTE                        bActFg;
    BYTE                        bCsgIdFg;
    BYTE                        abPadding[3];
    T_z_CsgId                   tCsgId;           
    T_z_PlmnAct                 tPlmnAct;         /*ӦѡCsgѡʽ*/
}T_zAti_CsgSel_Req;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bIndexFg;/*Z_VALID,Z_INVALID*/
    BYTE        bIndex;
}T_zAti_ZfplmnSet_Req;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        abPadding[2];
}T_zAti_ZfplmnQry_Req,T_zAti_ZfplmnTst_Req, T_zAti_Copn_Query_Req,
T_zAti_Copn_End_Cnf;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bMem; //洢λ
    BYTE        bIndNum; //˴Ҫϱ
    WORD        wTotalNum; //
    WORD        wCurrNum;  //Ѿϱĸ
}T_zAti_Copn_Exe_Cnf;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bOplPnnTotalNum;
    BYTE        bOplPnnCurrNum;
    BYTE        bNetTotalNum;
    BYTE        bNetCurrNum;
    BYTE        bMeTotalNum;
    BYTE        bMeCurrNum;
    WORD        wGloBalTotalNum;
    WORD        wGloBalCurrNum;
    UINT32   wMsgId;
}T_zAti_CopnQry_Cnf;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bMaxIndex;
    BYTE        bPadding;
}T_zAti_ZfplmnTst_Cnf;

typedef struct{
    BYTE        bIndex;
    BYTE        abPlmnId[3];
}T_zAti_ApMmia_Fplmn;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bPadding;
    BYTE        bNum;
    T_zAti_ApMmia_Fplmn atFplmnList[Z_APMMIA_MAX_FPLMN_NUM];//һ12
}T_zAti_ZfplmnQry_Cnf;

typedef struct{
    BYTE        bSrcIndex;
    BYTE        bDesIndex;
    BYTE        bChID;
    BYTE        bPadding;
    DWORD        dwUiccState;
}T_zAti_Zisiminit_Ind;

typedef struct {
    BYTE                                         bSrcIndex;
    BYTE                                         bDesIndex;
    T_zPS_PlmnId                               tPlmnId;
    T_zAtiUmm_EcNumList                     tEcNumList;
}T_zAti_EmerNum_Ind;

 typedef struct {
    BYTE                                         bSrcIndex;
    BYTE                                         bDesIndex;
    BYTE                                         bSupport;/*Z_VALID,Z_INVALID*/
    BYTE                                         bType; /*Z_ATI_S1_MODE,  Z_ATI_IU_MODE*/
}T_zApMmia_Emerber_Ind;

 /****************************************************************************
  :ATIڲʹTMGIȥʱʹ
  Ӧ:+ZTMGIACT
 ***************************************************************************/
typedef struct {
    BYTE    bSrcIndex;
    BYTE    bDesIndex;
    BYTE    bType;        /*Z_ATI_TMGI_DEACTIVE/Z_ATI_TMGI_ACTIVE*/
    BYTE    bDeactAll;      /*Z_VALID/Z_INVALID,bTypeΪZ_ATI_TMGI_DEACTIVEʱЧ*/
    T_zAtiAs_Mbms_Service_Info      tTmgiInfo;
}T_zApMmia_Tmgi_ActDeact_Req;

typedef struct {
    BYTE     bFg;
    BYTE     abPadding[3];
    T_zApUicc_USAT_SetUpMenuCmd   tSetUpMenuCmd;
}T_zAti_SetUpMemnu;
typedef struct {
    BYTE    bGsmRssi;
    BYTE    bTdRscp;
    BYTE    bWRscp;
    BYTE    bWEcno;
    BYTE    bLteRsrq;
    BYTE    bLteRsrp;
}T_zAti_CesqSqinfo;
/* ṹ嶨 */
typedef struct {
    BYTE    bIsSetChap;
    BYTE    bUserNameLen;
    BYTE    bChallengeLen;
    BYTE    bHashRspLen;
    
    BYTE    abpadding[3];
    BYTE    abUserName[Z_DEV_AtMem_MAX_STR_LEN+1];/*û*/
    BYTE    abChallenge[Z_ATI_ZGPCOCHAP_CHALLENGE_MAXLEN];/**/
    BYTE    abHashRsp[Z_DEV_AtMem_MAX_HASH_LEN];/*HASH*/
}T_ZAti_PcoChapInfo;

typedef struct {
    BYTE                                    bLength;  
    BYTE                                    bPadding;

    BYTE                                    abAtr[Z_APUICC_ATR_MAXLEN];
}T_zAti_AtrInfo;

#ifdef _USE_LPP_ECID
typedef struct {
    BYTE            bAllow;
    BYTE            bHdleId;
    BYTE            abpadding[2];
}T_zAti_MtlraInfo;
#endif

typedef struct {
    DWORD     dwMCS; //save new value, report new value
    DWORD     dwAckCnt;  //save total cnt, , report avearage value
    DWORD     dwNackCnt; //save total cnt,report avearage value
    DWORD     dwBSR;   //save new value, , report new value
    DWORD     dwTBS;   //save total cnt, report avearage value
}T_zAti_UlParamInd;

typedef struct {
    BYTE    bValidFg;
    BYTE    bYear;
    BYTE    bMon;
    BYTE    bDay;
    BYTE    bHour;
    BYTE    bMin;
    BYTE    bSec;
    BYTE    bTimezone;
}T_zAti_TimeInfo;

#ifdef DSDS_VSIM
typedef struct {
    BYTE    bSim1Stat;/*0-ȥ1-*/
    BYTE    bSim2Stat;/*0-ȥ1-*/
    BYTE    bSwitchStat;/*0-no switch,1-card switching*/
    BYTE    bPadding;
}T_zAti_CardSitchStat;
#endif

typedef struct {
    BYTE                                                    bCsState;           /* ǰCSע״̬ */
    BYTE                                                    bPsState;           /* ǰPSע״̬ */
    BYTE                                                    bCsSrv;             /* СǷ֧csҵϵͳϢ : zps_invalid:֧֣zps_valid: ֧*/
    BYTE                                                    bPsSrv;             /* СǷ֧psҵϵͳϢ: zps_invalid:֧֣zps_valid: ֧ */

    BYTE                                                    bInRoam;            /* Z_ATI_REG_HPLMN etc. */
    BYTE                                                    bCgattState;        /*+CGATT PSĸ״̬*/
    BYTE                                                    bZattState;         /*+ZATT  CSĸ״̬*/
    BYTE                                                    bIsBgltePlmnTst;

    BYTE                                                    bCellInfSet;        /*СϢϱ*/
    BYTE                                                    bHoInfoSet;         /*лϢϱ*/
    BYTE                                                    bTraceCellInfSet;       /* Ϣϱ*/
    BYTE                                                    bCcoCount;       /* Ϣϱ*/

    BYTE                                                    bZsqrSet;
    BYTE                                                    bRange;
    BYTE                                                    bPreLevel;
    BYTE                                                    bPreAct;

    BYTE                                                    bActiveFg;          /*activeʶ
                                                                                                                                         ȡֵ
                                                                                                                                         Z_ATI_ACTIVE_MMCMDS  
                                                                                                                                         Z_ATI_ACTIVE_CGAUTO  
                                                                                                                                         Z_ATI_ACTIVE_S0      
                                                                                                                                         Z_ATI_ACTIVE_DEFAULT */ 

 
    BYTE                                                    bAutoStartFlg; /* Z_ATI_AUTOSTART_INIT          
                                                                                                                             Z_ATI_AUTOSTART_WAITUICCINIT
                                                                                                                             Z_ATI_AUTOSTART_CARDWRONG 
                                                                                                                             Z_ATI_AUTOSTART_WAITRFON    
                                                                                                                             Z_ATI_AUTOSTART_CARDOK
                                                                                                                             */ 
#ifdef PS_RAT_LTE
    BYTE                                                    bEpsState;
#else
    BYTE                                                    bPadding;
#endif

    BYTE                                                    bAtCmd;   /* ¼νյATZ_ATI_AT_CMD_CACM*/

    BYTE                                                    bActivatFlg;  
    BYTE                                                    bMtAdrrType;
    BYTE                                                    bSmbL2P;
    BYTE                                                    bActCnfCid;
    
    BYTE                                                    bMmMode; /* Used to keep the setting of ^MODE, <mode> */
    BYTE                                                    bCardInitiatedFlag; /*ʼ־λ*/ 
    BYTE                                                    bCardState; /*ǰ״̬*/
    BYTE                                                    bAtdIndex; /*˫ʱ¼ATD·*/

    BOOL                                                    IsFlymode; /*ǷƵδ״̬*/
    BOOL                                                    IsCfgChging; /*Ƿڿ״̬*/
    BOOL                                                    IsNeedOutFlymode; /*ǷҪģʽ*/

    BYTE                                                     bSearchPlmnFg; /*¼Ƿй*/
    BYTE                                                     bZcwaFg; /*¼ZCWAõֵ0:յwaiting callʱֱӾܾϱ1:ϱ*/
    BYTE                                                     bZemsciqIndex;/*¼ģʽѯʽӦ*/
    BYTE                                                     bZemPadding;
#ifdef Z_DUALSTANDBY
    BYTE                                                    bZpsStat;    /*¼PSҵ״̬*/
#endif
    BYTE                                                    bImsvopsStat;/*֧IMS voice over PS session״̬*/
    BYTE                                                    bLteEmerbearInd;
    BYTE                                                    bUtranEmerbearInd;

    T_zAti_Fun                                     tFun;               /*  */
    T_zAti_PlmnPara                                tCsPlmnPara;        /* ¼ CSPLMN Ϣ*/
    T_zAti_PlmnPara                                tPsPlmnPara;        /* ¼ PSPLMN Ϣ*/
#ifdef PS_RAT_LTE
    T_zAti_PlmnPara                                tEPlmnPara;         /* ¼ LTEPLMN Ϣ*/
#endif
    T_zAti_PlmnPara                                tCurrPlmnPara;      /* ¼ ǰµPLMN Ϣ*/
#ifdef USE_VOICE_SUPPORT
    T_zAti_AocParaRec                              tAocPara;            /* Ҫ֤PIN룬ʱ¼õֵ*/ 
#endif
    ZOSS_TIMER_ID                                  pTimrIdHo;          /*ģʽлϢϱʱID*/
    T_zMmiaAs_EM_UHoInfo_Ind*                      ptUrrcHoInd;        /*urrcϱлϢ*/   
    T_zMmiaAs_EM_GHoInfo_Ind*                      ptGrrcHoInd;        /*grrcϱлϢ*/  
    T_zAti_UiccInfo                                tUiccInfo;    /* UICCϢʱ¼±ҪĵϢ*/

    T_zAti_Sms_TpdaInfo                            tSmsTpda;   /*SMS TPDA*/
#ifdef USE_VOICE_SUPPORT
    T_zAti_Aoc_Info                                tCaocInfo;   /*+CAOCȫֱϢ*/
#endif
    T_zAti_DataTest                                tDataTestInfo;    /*+ZGDATATESTݲȫֱ*/
    T_zAti_Ceer_Info                               tCeerInfo;   /*+CEERȫ*/

    T_ZAt2_CscsType                                bCurCscsTyp;   /* Used to keep the setting of +CSCS, <chset> */
#ifdef USE_VOICE_SUPPORT
    T_ZAti_CMCCVTS                                 tDtmf;    /*DTMF*/
#endif
    T_ZAti_ChannelInfo*                            ptCardInitChnlOfFirstCmd;
    T_ZAti_CallControlManagement                   tCcMan;  /*ͨȫ*/
#ifndef CONFIG_SINGLECORE
    T_zAti_CsdBuf_Info                             tCsdBuf; /*CSDϢ*/
#endif
#ifdef Z_SELL_STAT_SUPPORT
    T_zAti_SellStat_Info                           tSellStat; /*ͳȫ*/
    T_zAti_CIDInfo                                 tCIDInfo[Z_APMMIA_SM_MAX_CID_NUM]; /*SMϱPDPϢбά*/
#endif
    T_zAti_Card_PnnOpl                             tCrdPnnOpl;
    T_zAti_SetUpMemnu                              tStUpMenu;
    BYTE                                           abPcoAuthChkFailCount[ZATI2_SM_MAX_SMCID_NUM];
    BYTE                                           bPreRxlev;
    BYTE                                           bPreCsqAct;
    T_zAti_CesqSqinfo                              tCesqSqinfo;
    T_ZAti_PcoChapInfo                             tPcoChapAuth[ZATI2_SM_MAX_SMCID_NUM];
    BYTE                                           bZcsqRssi;
    BYTE                                           bZcsqAct;
    BYTE                                           bTimeZone;/*ǰһϱֵ,ʼֵ0XFF*/
    BYTE                                           bpadding;
    T_zAti_AtrInfo                                 tAtrInfo;
#ifdef _USE_LPP_ECID
    T_zAti_MtlraInfo                                tMtlraInfo;
#endif
    DWORD                                          dwUlRtTime;
    T_zAti_UlParamInd                              tUlParamInd;
    ZOSS_TIMER_ID                                  pTimrIdZurtind;
    T_zAti_TimeInfo                                tTimeInfo;
}T_zAti_Data_Ex;

/******************************NV***********************************/
typedef struct {
    BYTE                                                    bEModeType; /*617001738758 [ati]AT޸ĵ*/
    BYTE                                                    bSsMode; /*ҵģʽʾ*/
    BYTE                                                    bCurEValue;
    BYTE                                                    bCurVValue;

    CHAR                                                    bCurS3Value;
    CHAR                                                    bCurS4Value;
    CHAR                                                    bCurS5Value;
    BYTE                                                     bNeedChgFg;/*ǷҪȡֵ:Z_ATI_CHANGE_INIT/Z_ATI_NONEED_CHANGE
                                                                                                                                   Z_ATI_NEED_CHANGE/Z_ATI_USER_DECIDE_CHANGE*/

    BOOL                                                   IsOutFlymodeIng; /*ǰǷģʽ*/

    BOOL                                                   bSmOnlyL2PFlag;
    BOOL                                                   bPowerIndFlag; /* 617001591411 ܻ- ܻV3汾ͬʵ*/


    

    T_ZDrvIO_Handle                              sDevId;             /* 豸 */

    DWORD                                               dwRcvMsg;           /* һյϢ */
    DWORD                                               dwSndMsg;           /* һη͵Ϣ */
    DWORD                                               dwFailCause;        /* һʧܵԭ */
    
    BYTE                                                    abChMdlTable[256];  /* ͨģӳ, ڴģĵһҪabort
                                                                                                                                         ±ΪsrcIndexATCͨ;
                                                                                                                                          ԪΪģţ0xffʾЧȡֵΪZ_APATI_PSMDL_CC etc.*/

    T_ZAt2_CmeeType                                  bCmeeTyp;    /* Used to keep the setting of +CMEE, <n> */
    T_ZAt2_CmdInputInfo*                          ptCmdInputInfo; /* ͨϢΪȫָ룬Ӻ޸ */
#ifdef CXT_MOV
    T_zAti_PsMovInfo                                   tPsMovInfo;    /*PSǨϢ*/
#endif
    T_ZAti_ChanelList                                  tAtChnelList;    /*ͨ*/
    DWORD                                              adwIndChnel[8]; /*ϱʱӦͨǷҪϱadwIndChnel[0]bit1-bit32Ӧͨ1-32,bitλΪ1ʾҪϱΪ0ʾϱ*/
    DWORD                                              dwLastNvWtTm;/*ǰһյ·Ҫд볤ʱtickֵ*/
    BYTE                                               bS0Value; /*úԶӦ*/
    BYTE                                               bIsWtNv; /*nvǷиĶ*/
#ifdef DSDS_VSIM
    T_zAti_CardSitchStat                               tCardSwitch;
#endif
} T_zAti_Data;

typedef struct {
    T_zDev_AtMem            *ptAtMem[Z_ATI_INSTANCE_MAX_NUM];
}T_zAti_AtmemData;

typedef struct {
    T_zAti_Data    *ptSingleData;
    T_zAti_Data_Ex    *ptDualData[Z_ATI_INSTANCE_MAX_NUM];
}T_zAti_Golbal_Data;

typedef struct {
    BYTE       bChNum;    /* ͨ */
    BYTE       bAtInfo[255];  /* AT */
}T_zAtInfo;

/**************************************************************************
 *                        ȫֱ                                    *
 **************************************************************************/
extern T_zAti_Data*  g_zAti_ptData; 
extern T_zAti_Data_Ex g_zAti_atDataEx[Z_ATI_INSTANCE_MAX_NUM];
extern T_ZAti_Context  g_zAti_Context;
extern T_ZAti_SmContext g_zAti_SmContext[Z_ATI_INSTANCE_MAX_NUM];
#ifdef  _USE_GLOBAL_TRACE
extern T_zAti_AtmemData    g_zAti_Atmem;
extern T_zAti_Golbal_Data    g_zAti_GlobData;
#endif
extern const UINT8 g_zAt_Latin1GsmTable[256];
extern UINT8 g_zAti_CurInstance;
extern const UINT8 g_zAt_Ascii2Gsm7bitTable[128];

extern T_ZAti_Context                  g_zAti_Context;
extern T_ZAti_EmInfo g_zAti_EmInfo[Z_ATI_INSTANCE_MAX_NUM];
extern T_ZAti_EmInfoSemaphore g_zAti_EmInfoSemaphore[Z_ATI_INSTANCE_MAX_NUM];
extern T_ZAti_EmInfoMutex g_zAti_EmInfoMutex[Z_ATI_INSTANCE_MAX_NUM];


/**************************************************************************
 *                        ⲿ                                    *
 **************************************************************************/


/**************************************************************************
 *                        ڲ                                    *
 **************************************************************************/
#define zAti_SendExpt2TraceAgt( dwErrcode,  bTraceClass, pString) \
    if (zCatAgt_IsPsExpTraced())\
      Z_EXCP_TRACE_AGT((BYTE)(g_zAti_CurInstance + 1), SUBMDL_Z_ATI, dwErrcode, g_zAti_ptData->dwRcvMsg, g_zAti_ptData->dwSndMsg, pString, 0, bTraceClass)

BOOL zAti_IsDeliverMsgByPower(UINT32 iEvId);

BYTE zAti_GetAlwaysReportChnel(BYTE bPsId);
BOOL zAti_IsBlackScreenReportMsg(UINT32 iEvId);

/**************************************************************************
* ƣ zAti_GetDeliverAllEvId
*  ͨϢIDжǷΪ֪ͨϢԷȺͨ
* ˵ (IN) 
*            iEvId         ϢID
*            (OUT)
*   ֵ ɹTRUEʧܷFALSE
* ˵ һӦһͨ
**************************************************************************/
BOOL zAti_IsDeliverAllMsg(UINT32 iEvId);
/**************************************************************************
:zAti_IsWithOutIndexDelivInd(UINT32 iEvId, UINT8 *pDataPtr)
:ͨϢIDжǷΪûֵϱϢ
**************************************************************************/
BOOL zAti_IsWithOutIndexDelivInd(UINT32 iEvId, UINT8 *pDataPtr);
/*************************************************************************
:zAti_IsIndiCateCnfMsg
:ͨϢIDϢжǷΪҪϱ첽
ӦϢ
*************************************************************************/
BOOL zAti_IsIndiCateCnfMsg(UINT32 iEvId, UINT8 *pDataPtr);
/**************************************************************************
* ƣ zAti_GetUB
*  ռ䣬ʼΪ0
* ˵
*   ֵ 
* ˵ 
**************************************************************************/
VOID * zAti_GetUB(DWORD size); 

/**************************************************************************
* ƣ zAti_RetUB
*  ͷָ룬ÿ
* ˵
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_RetUB(VOID** ptr);

/**************************************************************************
* ƣ zAti_KillTimer
*  ͷŶʱÿ
* ˵
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_KillTimer(ZOSS_TIMER_ID * pTimer_Id);

/**************************************************************************
* ƣ zAti_MarkIndex
*  ¼ԴӦģ
* ˵
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_MarkIndex(VOID *ptBuff, BYTE bMdl);
BYTE zAti_GetLittle(BYTE bP1, BYTE bP2);

BYTE zAti_CheckFplmnSetIndex(T_z_UICC_FPlmnList * ptFPlmnList, T_zAti_ZfplmnSet_Req* ptZfplmnSet);

/**************************************************************************
: zAti_CheckScaLen
: TPADDRESS
    : 
    
    أ
ע    ͣ
23.011 8.2.5   sca
***************************************************************************/
BYTE zAti_CheckScaLen(BYTE bLen);

BYTE zAti_CheckBand(BYTE bAmtband, BYTE bUserBand);
VOID zAti_SetBand1toBand8(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand9toBand16(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand17toBand24(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand25toBand32(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand33toBand40(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand41toBand48(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand49toBand56(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand57toBand64(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptUeCapa);
VOID zAti_SetBand65toBand66(BYTE bUserBandFg, BYTE bUserBand, T_zAti_Nv_LteBand * ptLteBnad);
/**************************************************************************
* : zAti_RspNotEwalk
* : ڷeʱeеϢ
*     :
*     
*         Z_ATI_NOERROR_ERR
*     أ
* ע    ͣ
***************************************************************************/
DWORD zAti_RspNotEwalk(VOID* pBuff);
VOID zAtiCtrl(BYTE bState, DWORD dwMsgId, PBYTE pBuff, WORD wMsgLen, PBYTE pbPrvData);
VOID zAti_Init(VOID);
VOID zAti_InitZgdatatestGlobalVar(VOID); 
VOID zAti_InitComGlobalVar(VOID);
#ifdef Z_SELL_STAT_SUPPORT
BOOL zAti_InitPdpSumSellStatGlobalVar(VOID);
VOID zAti_InitSellStatGlobalVar(VOID);
#endif
VOID zAti_InitCsGlobalVar(VOID);
#ifdef Z_SELL_STAT_SUPPORT
BOOL zAti_InitRegSellStatGlobalVar(VOID);
#endif
VOID zAti_InitOplPnnInfo(BYTE bInstance);
VOID zAti_InitCeerGlobalVarByInstNo(BYTE bInstance);
VOID zAti_InitGlobalVarByInstNo(BYTE bInstance);
VOID zAti_MiniFunModeInitGlobalVarByInstNo(BYTE bInstance);
VOID zAti_InFlyModeInitGlobalVarByInstNo(BYTE bInstance);
VOID zAti_CardOffInitGlobalVarByInstNo(BYTE bInstance);
VOID zAti_Cereg0InitGlobalVar(BYTE bInstance);
VOID zAti_Randomize(VOID);
BYTE zAti_MsgFromATI(DWORD dwMsgId);

VOID zAti_WordtoBytes(BYTE* bDestBytes,WORD wSrcWord);
VOID zAti_DWordtoBytes(BYTE* bDestBytes,DWORD dwSrcWord);
BYTE zAti_MsgForward(DWORD dwMsgId, PBYTE pMsg, WORD wMsgLen, BYTE bTaskIndex);
#ifdef PS_RAT_LTE
VOID zAti_SendMsgToEpdcp(DWORD dwMsgId, PBYTE  pbMsg, WORD wMsgLen);
#endif
BYTE zAti_MsgSend(DWORD dwMsgId, PBYTE pMsg, WORD wMsgLen, BYTE bTaskIndex);
#ifdef USE_VOICE_SUPPORT
BYTE zAti_CheckMemIndex(WORD  bIndex);
#endif
BYTE zAti_CheckNumLen(BYTE bNumLen);
VOID zAti_SetToTpaddr(T_zApMmia_TpAddress* pTpaddr,PBYTE pSetAddr,BYTE bAddrType);
VOID zAti_TpaddrToSet(PBYTE pSetAddr,T_zApMmia_TpAddress* pTpaddr,BYTE bAddrType);
BYTE zAti_CheckNumLen(BYTE bNumLen);
DWORD zAti_UiccUpdateItemGeneralCnf (T_zApUicc_UpdateItem_Cnf *ptUpdateItemCnf);
VOID zAti_CpyPlmnID(PBYTE pOperName,T_z_PlmnId tPlmnID );
BYTE zAti_GenTodaByAddressType(T_zApMmia_AddrType *ptAddrType);
#ifdef Z_DUALSTANDBY
BOOL zAti_IsGsmOnlySysconfig(VOID);
#endif
VOID zAti_InitEmInfoByInstNo(BYTE bInstance);
typedef DWORD(*P_AtiProcFunc)(VOID *);
typedef struct  /* Ԫؽṹ */
{
    DWORD  dwMsgId;                                            /* Ϣʶ */
    DWORD (* pHandleMsg)(VOID * pbMsgData);                         /* Ӻָ */
}
T_zAti_DistributeMsgTab;

extern T_zAti_DistributeMsgTab g_atDistributeMsgMap[ATI_DISTRIBUTE_FUNC_EVENT_END + 9];
extern P_AtiProcFunc atiOuterMsgMap[22][Z_ATI_PROCFUNC_NUM];
#ifdef USE_VOICE_SUPPORT
DWORD zAti_CacmSetReq (VOID *pBuff);
DWORD zAti_CammSetReq (VOID *pBuff);
DWORD zAti_CpucSetReq (VOID *pBuff);
#endif
DWORD zAti_PinReq(VOID* pBuff);
DWORD zAti_EM_CellInfoSetReq(VOID* pBuff);
DWORD zAti_EM_CellInfoQryReq(VOID* pBuff);
DWORD zAti_EM_CellInfoQryReqByIndex(VOID* pBuff);
DWORD zAti_EM_HoInfoSetReq(VOID* pBuff);
VOID zAti_CellresOrCcoCountReq(VOID *pBuff);
VOID zAti_CellresOrCcoCount (BYTE bAction, BYTE bDestMdl);
DWORD zAti_ZRptRxlevReq(VOID* pBuff);
DWORD zAti_ZRptRxlevProc (T_zApMmia_ZRptRxlev_Req *ptRxlevReq);
DWORD zAti_RxlevReq(VOID* pBuff);
DWORD zAti_ZcsqReq(VOID* pBuff);
DWORD zAti_AutoStartReq (VOID* pBuff);
DWORD zAti_CopsSet(VOID* pBuff);
DWORD zAti_SmCgactReq(VOID* pBuff);
DWORD zAti_SmCgactExc(VOID* pBuff);
DWORD zAti_SendSmZgactReq(T_zApMmia_SmZgact_Req  *ptApZgactReq);
DWORD zAti_SmZgactReq(VOID* pBuff);
DWORD zAti_SmAnsReq(VOID *pBuff);
DWORD zAti_CeerReq(VOID *pBuff);
DWORD zAti_SmsTcmgsReq(VOID* pBuff);
DWORD zAti_SmsTcmgwReq(VOID* pBuff);
DWORD zAti_SmsTcmgcReq(VOID* pBuff);
DWORD zAti_SmsPcnmaReq(VOID* pBuff);
DWORD zAti_SmsPcmgsReq(VOID* pBuff);
DWORD zAti_SmsPcmgwReq(VOID* pBuff);
DWORD zAti_SmsPcmgcReq(VOID* pBuff);

DWORD zAti_SmsTcsmpReq(VOID* pBuff);
DWORD zAti_SsClckSet(VOID* pBuff);
DWORD zAti_SsCpwdSet(VOID* pBuff);
DWORD zAti_SsCusdSetReq(VOID* pBuff);
DWORD zAti_SmsCscaReq(VOID* pBuff);
DWORD zAti_SmsTpmrReq(VOID* pBuff);
#ifdef _USE_LPP_ECID
DWORD zAti_SsMolrReq(VOID* pBuff);
#endif
#ifdef PS_RAT_LTE
DWORD zAti_ImsDatadelReq(VOID* pBuff);
#endif
#ifdef DSDS_VSIM
DWORD zAti_CardSwitchReq(VOID* pBuff);
#endif
DWORD zAti_Cbs_DataInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_SmMtCgevInd(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
//DWORD zAti_SmMtActivateInd(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
//--VOID zAti_SmIpPdpActCnf(VOID* pBuff);
//--DWORD zAti_SmConnectInd(VOID* pBuff, DWORD * pdwChangedMsgId);
#ifdef CXT_MOV
DWORD zAti_SmContextCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#endif
#ifdef DSDS_VSIM
DWORD zAti_CardSwitchCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#endif
BOOL zAti_SaveLastCidTab(UINT8 iCid, UINT8 chnelId);

VOID zAti_SmDeactivateInd(VOID* pBuff);
DWORD zAti_SmsMsgSendCnf(VOID* pBuff ,DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_SmsDeliverRecInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_SmsStatusRecInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#ifdef USE_VOICE_SUPPORT
DWORD zAti_CcMocCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcMtcInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcAnsModCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcModifyCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcDiscInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcSsNotifyInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_ProcInfoInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcmQueryCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
//DWORD zAti_CcCommonCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcDicsCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_CcDtmfCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#endif
DWORD zAti_PlmnInfo(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_PlmnList(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_RfControl(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_Mminfo(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UmmSearchPlmnCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#ifdef CXT_MOV
DWORD zAti_UmmPsContextCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
#endif
DWORD zAti_PbSaveSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_PbReadSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_PbFindIndexCnf(VOID *pBuff);
DWORD zAti_PbPBMemStatusCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccInitCnf(VOID *pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccOkInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccZuststInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UmmCsSrvInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccCommonCnf (VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UmmCommonCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
T_ZAti_ChannelInfo* zAti_GetAtCmdChId(T_ZAt2_CmdIdType cmd_id);
DWORD zAti_UiccReadCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccUpdateCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_UiccUpdateItemCnf(VOID* pBuff , DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_VerifyPin2Cnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
//T_zAti_UiccInfo *zAti_GetValRecReadUiccCnf (VOID);
DWORD zAti_PbDeleteSmCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_PbSmMemAvail(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_PbInitCmpltInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
DWORD zAti_ReadItem (BYTE bKeyId, BYTE bStartRec, BYTE bEndRec, VOID *pValBuf);
WORD zAti_GetDataSizeByKeyId(WORD wKeyId);
BYTE zAti_CheckParam(BYTE bParam,BYTE bUpVal,BYTE bAnotherVal);
BYTE zAti_CheckQryPbResult(T_zApMmia_QryPhoneResult *ptQryResult);
DWORD zAti_CopyStrFromUiccVal (VOID *pNewVal, WORD wKeyId, T_zApUicc_Read_Cnf *ptUiccReadCnf);
#ifdef USE_VOICE_SUPPORT
VOID zAti_LongToArray(BYTE *pbArray, DWORD dwPara, BYTE bArraySize);
#endif
VOID zAti_SaveValWhenReadUicc (T_zAti_UiccInfo *ptSaveVal);
DWORD zAti_UiccReadReq (BYTE bUiccKeyId, BYTE bRecNum, BYTE bSrcIndex, BYTE bDstIndex);
VOID zAti_UiccUpdateItemReq (VOID *pData, DWORD dwDataSize, BYTE bUiccKeyId, BYTE bSrcIndex, BYTE bDesIndex);
VOID zAti_UiccUpdateItemAndSaveInfo (VOID *pData, DWORD dwDataSize, BYTE bUiccKeyId, BYTE bReadKey, BYTE bSrcIndex, BYTE bDesIndex);
DWORD zAti_UiccUpdateReq (VOID *pData, BYTE bUiccKeyId, BYTE bSrcIndex, BYTE bDstIndex);
BYTE zAti_memCheck(BYTE *pBuff, WORD wBuffLen, BYTE bVal);
VOID zAti_UiccInfoInit(BYTE bInstance);
BOOL zAti_IsDualPsOneCardNonGsm(BYTE bInsNo);
BYTE zAti_GetAutoStartState (VOID);
BOOL zAti_IsEWalkUiccInit(BYTE bDesIndex);
#ifdef Z_DUALCARD_ADAPT
BOOL zAti_IsCardSelfAdaptCnf(BYTE bDesIndex);
#endif
BYTE zAti_GetAnothAutoStartState(VOID);
#ifdef CXT_MOV
BYTE zAti_GetPsMovStat(VOID);
VOID zAti_ClearPsMovStat(VOID);
VOID zAti_SendUserDisConnect(VOID);
VOID zAti_HandStoredCmdInPsmov(VOID);
VOID zAti_SetPsMovStat(BYTE bPsMovStat);
VOID zAti_SetChnlWhenUserDisConn(UINT8 iChnelId );
BYTE zAti_IsDestStackChannelValid(BYTE bDestInsNo);
VOID zAti_MovSmAtMem(VOID);
VOID zAti_MovDataChannl(VOID);
VOID  zAti_SndUmmPsContextInd(T_zMmiaUmm_PsContext_Cnf *ptPsContextCnf, T_zMmiaUmm_PsContext_Ind *ptPsContextInd);
#endif
VOID zAti_PbAdaptCallNum (T_z_CallNum *ptDstCallNum, T_z_CallNum *ptSrcCallNum, BYTE bIndex);
VOID zAti_SetAutoStartState (BYTE bAutoStartState);
DWORD zAti_GETCMSERR(DWORD dwErrCod);
BYTE zAti_GetTdRssi(BYTE bRxlev);
BYTE zAti_GetTdNewPowerLevel(BYTE bRxlev);
BYTE zAti_IsTdPowerLevelChng(BYTE bRxlev);
BYTE zAti_GetGsmRssi(BYTE bRxlev);
BYTE zAti_GetGsmNewPowerLevel(BYTE bRxlev);
BYTE zAti_IsGsmPowerLevelChng(BYTE bRxlev);
BYTE zAti_IsLtePowerLevelChng(BYTE bRxlev);
BYTE zAti_GetLteNewPowerLevel(BYTE bRxlev);
BYTE zAti_IsWPowerLevelChng(BYTE bRxlev);
BYTE zAti_GetWNewPowerLevel(BYTE bRxlev);
VOID zAti_EM_NotfyAsforCco(BYTE bAction);
VOID zAti_GrrRptRxlevCnf(VOID* pBuff);
VOID zAti_McrRptRxlevCnf(VOID* pBuff);
VOID zAti_GrrRptRxlevInd(VOID* pBuff);
VOID zAti_McrRptRxlevInd(VOID* pBuff);
VOID zAti_HandleUlParaInd(VOID* pBuff);
#ifdef ECALL_SUPPORT
BYTE zAt_GetEcallSupStat(PBYTE pbEcallType,  PBYTE pbIsNum, PBYTE pbIsUri);
VOID zAti_UpdateDialNum(PBYTE abNum, PBYTE pbcdSscLen);
VOID zAti_GetCcECallType(BYTE *pbECallType);
VOID zAti_GetAtECallType(BYTE *pbCcECallType);
VOID zAt_GetFdnEcallNum(T_z_CallNum* ptTestNum, T_z_CallNum* ptReCfgNum, BYTE bInsNo);
VOID zAt_GetFdnEcallUri(T_z_UICC_FdnUri* ptTestUri, T_z_UICC_FdnUri* ptRecfgUri, BYTE bInsNo);
VOID zAt_GetSdnEcallNum(T_z_CallNum* ptTestNum, T_z_CallNum* ptReCfgNum, BYTE bInsNo);
VOID zAt_GetSdnEcallUri(T_z_UICC_SdnUri* ptTestUri, T_z_UICC_SdnUri* ptRecfgUri, BYTE bInsNo);
#endif
#ifdef USE_VOICE_SUPPORT
BYTE zAti_HexArrayToLong (DWORD *pdwPara, BYTE *pbArray, BYTE bArraySize);
VOID zAti_DecArrayToLong(DWORD *pdwPara, BYTE *pbArray, BYTE bArraySize);
#endif
BYTE zAti_HexToDecimal(BYTE bHexVal);
BYTE zAti_DcimalToHex(BYTE bDcimVal);
VOID zAti_ConvertByte2ActStruct(BYTE bAct, BYTE bSubActFg, BYTE bSubAct,T_z_PlmnAct *ptAct);
VOID zAti_CopsActAdapt(PBYTE pbAct);
#ifdef USE_VOICE_SUPPORT
DWORD zAti_ZcfisSetReq(VOID *pBuff);
DWORD zAti_ZcfisSetCnf(T_zApUicc_Read_Cnf *pReadCnf);
DWORD zAti_UpdateCommonCnf (T_zApUicc_Update_Cnf *ptUpdateCnf);
#endif
DWORD zAti_UiccMbauReq(VOID *pBuff);
DWORD zAti_UiccAuthRsp(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo *pChnelNode);
DWORD zAti_UiccAuthFailInd(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo *pChnelNode);
BYTE zAti_RfCtrlReq(BYTE bSrcIndex, BYTE DesIndex, BYTE bCfunMode);
BOOL zAti_IsStackInRfClose(BYTE bInsNo);
#ifdef Z_DUALCARD_ADAPT
VOID zAti_GetStackIntoFlymode(BYTE bInsNo);
VOID zAti_SendCfunSetReq(BYTE bValue, BYTE bInsNo);
VOID zAti_ExchangeSysconfig(VOID);
#endif
DWORD zAti_CfunSet(VOID* pBuff);
DWORD zAti_Zpin2Set(VOID* pBuff);
DWORD zAt_ZtmgiActiveReq(VOID* pBuff);
DWORD zAt_CopnQryReq(VOID* pBuff);
VOID zAti_RetUbCardPlmnInfo(VOID);
VOID zAti_SendRecvCmdStr2Trace (UINT8 iChannel, UINT16 iDataLen, CHAR *ptStrData);
VOID zAti_SendRspCmdStr2Trace (UINT8 iChannel, UINT16 iDataLen, CHAR *ptStrData);
VOID zAti_CardInitFlgClr_SigCd(BYTE bInstance, BYTE bCardInitFlg);
VOID zAti_SetCardState(BYTE bInsNo, BYTE bCardStat);
#ifdef Z_DUALCARD_ADAPT
BYTE zAti_GetCardState(BYTE bInsNo);
BYTE zAti_GetChangeCfgFlg(VOID);
BOOL zAti_IsCcStateFillChangeCfgCondition(VOID);
BOOL zAti_IsCardStateFillChangeCfgCondition(VOID);
#endif
VOID zAti_HandleMsgBuff(VOID);
VOID zAti_AutoStartRfOn(VOID);
VOID zAti_HandleAutoStart(VOID);
BYTE zAti_SelectEffectiveSubact(BYTE bGsmSubact, BYTE bTdSubact, BYTE bWsubact,BYTE bLteSubact);

VOID zAti_InitCCMan(BYTE bInstNo);
VOID zAti_InitChnelNode(BYTE bCurChnelId);
#ifdef USE_VOICE_SUPPORT
DWORD zAti_HandleVtsForCmcc(BYTE bSourceIndex, BYTE bDestIndex);
#endif
VOID zAti_ChangeChnelNodeToCmd(T_ZAti_ChannelInfo *pChnelNode);
DWORD zAti_HandleSmNoCarrierCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo *pChnelNode);
DWORD zAti_HnadlePdpCauseQueryCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
BYTE zAti_UmmAativeReq(BYTE bSrcIndex, BYTE bDesIndex, BYTE bActiveType, BYTE bActiveValue, BYTE bActiveFg);
BYTE zAti_CpyPlmnList(T_zApMmia_SearchPlmn *ptDstPlmnList, T_zMmiaUmm_PlmnList_Cnf* ptSrcPlmnList);
BYTE zAti_UpdatePlmnList(T_zApMmia_SearchPlmn *ptDstPlmnList, BYTE bNumber);
VOID zAti_UpdateScanInfo(T_zMmiaUmm_Scan_Cnf *ptSrc, T_zApMmia_ZscanTest_Cnf *ptDest);
BOOL zAt_GetOperNameFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo);
BOOL zAt_GetCopsQryOperNameFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, WORD wLac);
BOOL zAt_GetPlmnIdFromSimCard(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName);
BOOL zAt_GetOperNameFromNetInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo);
BOOL zAt_GetPlmnIdFromNetInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName);
BOOL zAt_GetOperNameFromMeInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo);
BOOL zAt_GetPlmnIdFromMeInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName);
BOOL zAt_GetOperNameFromGlobInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo);
BOOL zAt_GetPlmnIdFromGlobInfo(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName);
BOOL zAt_GetOperName(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, BYTE bInsNo);
BOOL zAt_GetOperPlmnId(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName);
BOOL zAt_GetCopsQryOperName(BYTE bFlag,T_z_PlmnId* pNumName, void* ptAlphName, WORD wLac);
BOOL zAti_PutPlmnId(T_z_PlmnId *ptPlmnId, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo);
VOID zAti_GetAppointedPlmnIdbyShortName(BYTE *pName, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo);
VOID zAti_GetAppointedPlmnIdbyFullName(BYTE *pName, T_zMmiaUmm_OperPlmn *ptPlmn, BYTE bInsNo);
VOID zAti_GetCardPlmnInfo(BYTE bInsNo);
BYTE zAti_GetAtMemItem(BYTE bAtMemItem);
BOOL zAti_IsNeedAutoSearchPlmn(T_zAti_NV_CopsMode *ptNvCopsMode);
BOOL zAti_IsNeedAutoManuSearchPlmn(T_zAti_NV_CopsMode *ptNvCopsMode);
VOID zAti_HandleSmDeActInd(T_zMmiaSm_CidDeact_Ind *ptDeactInd);

DWORD zAti_ProcCpbr(VOID *pbMsgData);
DWORD zAti_ProcSmsCmglReq(VOID *pbMsgData);
DWORD zAti_ProcPbAddUserEn(VOID *pbMsgData);
DWORD zAti_ProcSmsCmgdTest(VOID *pbMsgData);
DWORD zAti_ProcDtmfReq(VOID *pbMsgBody);
#ifdef USE_VOICE_SUPPORT
BYTE zAti_CcMtcIndSetCli (BYTE bNoCliCause, PBYTE pbCli);
#endif
BOOL zAti_IsLteStandBy(BYTE bInsNo);
VOID zAti_SendInfo2MsgTrace (PBYTE pBuff, WORD wMsgLen, DWORD dwMsgId, BYTE bStackIndex);
BOOL zAti_IsSingleCardForTwoStandby(VOID);
BOOL zAti_IsSingleCardForOneStandby(VOID);
BYTE zAti_GetInstantForSingleCardOneStandby(VOID);
DWORD zAti_SendSmAnsReq(VOID* pBuff);
#ifdef Z_DUALCARD_ADAPT 
BOOL zAti_IsCmdChnelIdIdel(BYTE bInsNo);
#endif
BOOL zAti_GetMtAutoAnsMsg(BYTE bType, PBYTE pAtMemBuf, T_zApMmia_SmMtActAns_Req* ptApAnsReq);
BOOL zAti_HasMoreCmd(T_ZAti_ChannelInfo *pChnelNode);
BYTE zAti_GetByteAct(T_z_Act* ptAct);
BOOL zAti_IsGetGlobalVarMsg(UINT32 iEvId);
BOOL zAti_IsEccNumValid(T_zPS_PlmnId* ptPlmnAct);
SINT32 zAti_SendFnc(BYTE chID, BYTE *data, UINT16 dataLen, T_zAti2_CtrmChInd chInd);
BYTE zAti_IsPlmnIdValid(T_z_PlmnId* ptPlmnId);
#ifdef Z_DUALCARD_ADAPT
VOID zAti_ClearSelfAdaptGlobVar(BYTE bInsNo);
DWORD zAti_SelfAdaptOutFlymodeCnf(VOID);
DWORD zAti_SelfAdaptFlymodeCnf(VOID);
VOID zAti_OutFlymodeInSelfAdapt(VOID);
VOID zAti_IndicatCfgStart(VOID);
VOID zAti_IndicatCfgEnd(VOID);
VOID zAti_IndicatUserDecide(VOID);
VOID zAti_NeedChangeInNoChange(VOID);
VOID zAti_NeedChangeInSingleCfgChanging(VOID);
VOID zAti_NoNeedChangeInSingleCfgChanging(VOID);
VOID zAti_NeedChangeInDualChanging(VOID);
#endif
VOID zAti_RemoveALLCmd(T_ZAti_ChannelInfo *pChnelNode);
VOID zAti_RemoveOneCmd(T_ZAti_ChannelInfo *pChnelNode);
#ifdef USE_VOICE_SUPPORT
DWORD zAt_RedialResult(VOID);
#endif
DWORD zAti_CesqQryReq(VOID* pBuff);
DWORD zAti_ZlbsReq(VOID* pBuff);
BYTE zAti_GetCurAct_ByIndex(BYTE bInsIdx);
BYTE zAti_GetNvRfCtrlFg(VOID);
BYTE zAti_IsGsmRfOpen(BYTE bNvRfCtrlFg);
BYTE zAti_IsTdRfOpen(BYTE bNvRfCtrlFg);
BYTE zAti_IsWRfOpen(BYTE bNvRfCtrlFg);
BYTE zAti_IsLteRfOpen(BYTE bNvRfCtrlFg);
BYTE zAti_IsTdPhyExist(VOID);
BYTE zAti_IsWPhyExist(VOID);
BYTE zAti_IsGsmPhyExist(VOID);
BYTE zAti_IsLtePhyExist(VOID);

BYTE  zAti_GetTaskInstantIndex(BYTE bSubMode);
BYTE zAti_GetCallState(BYTE bInsNo);
BYTE zAti_IsDualPsDualUicc(VOID);
#ifdef  PS_RAT_LTE
BYTE zAti_IsNeedLteBGplmnSearch(BYTE bInsIdx);
#endif

VOID zAti_SetEventEnd(VOID);
BYTE zAti_GetRegState(VOID);

extern BOOL zAti_IsHasValidFg(BYTE *pbFg, BYTE bLen);

extern VOID zAti_SetS0Value(BYTE bS0Value);
extern BYTE zAti_GetS0Value(VOID);
BYTE zAt_IsBeepCallNum(T_z_CallNum *ptCheckedNum);
#endif
