#include "atipsint.h"
#include "ps/src/nas/ati/inc/zat_fnc.h"
#include "ps/src/nas/ati/inc/zati_fnc.h"
#include "ps/src/nas/ati/inc/zati_com.h"
#include "ps/src/nas/ati/inc/zati_othr.h"
#include "ps/src/nas/ati/inc/zati_sm.h"
#include "ps/src/nas/ati/inc/zati_sms.h"

/**************************************************************************
*    Manifest Constants             
**************************************************************************/

/* 
  * ͱдϱͷ  
*/
UINT16  zAt_EncCmglHead ( CHAR * pStrTarget, BYTE bStatChgFlg)
{
    if (bStatChgFlg == Z_APMMIA_STATCHANGE_ENABLE)
    {
        return (UINT16)sprintf((char *)pStrTarget, "%s+CMGL: ", g_zAt_CRLF); 
    }
    else
    {
        return (UINT16)sprintf((char *)pStrTarget, "%s+ZMGL: ", g_zAt_CRLF); 
    }
}

UINT16  zAt_EncCmgrHead ( CHAR * pStrTarget, BYTE bStatChgFlg)
{
    if (bStatChgFlg == Z_APMMIA_STATCHANGE_ENABLE)
    {
        return (UINT16)sprintf((char *)pStrTarget, "%s+CMGR: ", g_zAt_CRLF); 
    }
    else
    {
        return (UINT16)sprintf((char *)pStrTarget, "%s+ZMGR: ", g_zAt_CRLF); 
    }
}

UINT16 zAt_EncSmsStatus ( CHAR * pStrTarget, BYTE bStatus)
{
    if(bStatus < ZAT_SMS_STATE_MAX)
    {
        return (UINT16)sprintf((char *)pStrTarget, "\"%s\"", ZAT_SMS_STATE_TYPE[bStatus] );
    }
    else
    {
        return (UINT16)sprintf((char *)pStrTarget, "\"\"");
    }
}

BYTE zAt_GetTpFoToByte(T_zApMmia_TpFo *ptTpFo)
{
    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
   /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
   /*       7             6                  5                 4   3             2        1   0   */
   /*---------------------------------------------------------------------------------------*/
    return (BYTE) (ptTpFo->bMsgTypeId |
        (ptTpFo->bMsgFeature << 2) |
        (ptTpFo->bTpvpFormat<< 3) |
        (ptTpFo->bStatRptFeature<< 5) |
        (ptTpFo->bTpudHeadInd<< 6) |
        (ptTpFo->bReplyPathInd<< 7));
}

BYTE zAt_GetAddrTypeToByte(T_zApMmia_AddrType *ptAddrType)
{
    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/
    return (BYTE) ( (ptAddrType->bTopBit << 7) + (ptAddrType->bNumberType << 4) + ptAddrType->bNumPlanId);
}

UINT16 __ps_static_func zAt_EncSmsAddrType ( CHAR * pStrTarget, BYTE bAddrType)
{
    if (bAddrType == Z_APMMIA_TOA_PLUS)
    {
        return (UINT16)sprintf((char *)pStrTarget, "\"+");
    }
    else /* 129 */
    {
        return (UINT16)sprintf((char *)pStrTarget, "\"");
    }
}

// bTpType : Z_ATI_ADDRTYPE_NORM, Z_ATI_ADDRTYPE_SCA, 
UINT16 zAt_EncTpAddrVal(BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, BYTE bAddrType, T_zApMmia_TpAddress *ptTpAddr)
{
    CHAR *pStrWalk = pStrTarget;
    UINT8 iBcdByteLen = 0;
    if(bCommaFg)
    {
        pStrWalk += sprintf((char *)pStrTarget, ",");
    }
    pStrWalk += zAt_EncSmsAddrType(pStrWalk, bAddrType);  

    /* print the BCD number */
    if(bTpType == Z_ATI_ADDRTYPE_SCA)
    {
        if(ptTpAddr->bAddrLength > 0)
        {
            iBcdByteLen = ptTpAddr->bAddrLength - 1;
        }
        else
        {
            iBcdByteLen = 0;
        }
    }
    else
    {
        iBcdByteLen = (ptTpAddr->bAddrLength +1 )/2;
    }

    zAt_EncBcd2NumStrByCscsType(pStrWalk, ptTpAddr->abAddrValue, iBcdByteLen, g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);
    pStrWalk += strlen((const char *)pStrWalk);
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    return (UINT16)strlen((const char *)pStrTarget);
}

UINT16 zAt_EncScAddrVal(BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, BYTE bAddrType, T_zApMmia_TpAddress *ptTpAddr)
{
    CHAR *pStrWalk = pStrTarget;
    UINT8 iBcdByteLen = 0;
    if(bCommaFg)
    {
        pStrWalk += sprintf((char *)pStrTarget, ",");
    }
    pStrWalk += zAt_EncSmsAddrType(pStrWalk, bAddrType);  

    /* print the BCD number */
    if(bTpType == Z_ATI_ADDRTYPE_SCA)
    {
        if(ptTpAddr->bAddrLength > 0)
        {
            iBcdByteLen = ptTpAddr->bAddrLength - 1;
        }
        else
        {
            iBcdByteLen = 0;
        }
    }
    else
    {
        iBcdByteLen = (ptTpAddr->bAddrLength +1 )/2;
    }

    zAt_EncBcd2NumStrByCscsType(pStrWalk, ptTpAddr->abAddrValue, iBcdByteLen, ZAT2_CSCS_GSM);
    pStrWalk += strlen((const char *)pStrWalk);
    pStrWalk += sprintf((char *)pStrWalk, "\"");
        
    return (UINT16)strlen((const char *)pStrTarget);
}

// bTpType : Z_ATI_ADDRTYPE_NORM, Z_ATI_ADDRTYPE_SCA, 
UINT16 zAt_EncTpAddr(BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, T_zApMmia_TpAddress *ptTpAddr)
{
    CHAR *pStrWalk = pStrTarget;
    UINT8 iTpAddrType = zAt_GetAddrTypeToByte(&ptTpAddr->tAddressType);    

    pStrWalk += zAt_EncTpAddrVal(bCommaFg, pStrWalk,bTpType, iTpAddrType, ptTpAddr);
    /* <type of addr> */
    pStrWalk += sprintf((char *)pStrWalk, ",%d", iTpAddrType);
    return (UINT16)strlen((const char *)pStrTarget);
}

UINT16 zAt_EncScAddr(BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, T_zApMmia_TpAddress *ptTpAddr)
{
    CHAR *pStrWalk = pStrTarget;
    UINT8 iTpAddrType = zAt_GetAddrTypeToByte(&ptTpAddr->tAddressType);    

    pStrWalk += zAt_EncScAddrVal(bCommaFg, pStrWalk,bTpType, iTpAddrType, ptTpAddr);
    /* <type of addr> */
    pStrWalk += sprintf((char *)pStrWalk, ",%d", iTpAddrType);
    return (UINT16)strlen((const char *)pStrTarget);
}


BOOL zAt_EncSmCgevOthTypeInd(CHAR * pStrWalk, UINT8 SmType)
{
    if(SmType == Z_APMMIA_CGEV_MT_ACT_REJ)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: REJECT ", g_zAt_CRLF);
    }
    else if(SmType == Z_APMMIA_CGEV_NW_REACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW REACT ", g_zAt_CRLF);
    }
    else
    {
        return FALSE;
    }
    
    return TRUE;
}

BOOL zAt_EncSmCgevPdptypeInd(CHAR * pStrWalk, UINT8 pdpType,UINT8 *addrSect)
{
    if (pdpType== Z_APMMIA_SM_PPP)
    {
        sprintf((char *)pStrWalk, "\"PPP\",\"");
        *addrSect = 0; 
    }
    else if (pdpType == Z_APMMIA_SM_IPV4)
    {
        sprintf((char *)pStrWalk, "\"IP\",\"");
        *addrSect = Z_APMMIA_SM_IPV4_ADDR_MAX_LEN; 
    }
    else if (pdpType == Z_APMMIA_SM_IPV6)
    {
        sprintf((char *)pStrWalk, "\"IPV6\",\"");
        *addrSect = Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;
    }
    else if (pdpType == Z_APMMIA_SM_IPV4V6)
    {
        sprintf((char *)pStrWalk, "\"IPV4V6\",\"");
        *addrSect = Z_APMMIA_SM_IPV4V6_ADDR_MAX_LEN;
    }
    else
    {
        return FALSE;
    }
    
    return TRUE;    
}


BOOL zAt_EncSmCgevOthInd(CHAR * pStrWalk, T_zMmiaSm_Cgev_R5Ver SmCgevVal)
{
    UINT8 iPdpAddrSect = 0,j = 0;

    if(!zAt_EncSmCgevOthTypeInd(pStrWalk,SmCgevVal.bType))
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(!zAt_EncSmCgevPdptypeInd(pStrWalk,SmCgevVal.tPdpAddr.tPdpAddr.bPdpType,&iPdpAddrSect))
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(iPdpAddrSect == Z_APMMIA_SM_IPV4_ADDR_MAX_LEN)
    {
        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", SmCgevVal.tPdpAddr.tPdpAddr.abIPv4Addr[j]);
        }
        pStrWalk--;
    }
    else if(iPdpAddrSect == Z_APMMIA_SM_IPV6_ADDR_MAX_LEN)
    {
        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", SmCgevVal.tPdpAddr.tPdpAddr.abIPv6Addr[j]);
        }
        pStrWalk--;
    } 
    /*617001621882Ӧðipv4v6Ͳv4v6*/
    else if(iPdpAddrSect == Z_APMMIA_SM_IPV4V6_ADDR_MAX_LEN)
    {
        for (j = 0; j < Z_APMMIA_SM_IPV4_ADDR_MAX_LEN; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", SmCgevVal.tPdpAddr.tPdpAddr.abIPv4Addr[j]);
        }
        for (j = 0; j < Z_APMMIA_SM_IPV6_ADDR_MAX_LEN; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", SmCgevVal.tPdpAddr.tPdpAddr.abIPv6Addr[j]);
        }
        pStrWalk--;
    }        
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    if (SmCgevVal.tPdpAddr.bCid < 0xff)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", SmCgevVal.tPdpAddr.bCid);
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return TRUE;
}

BOOL zAt_EncSmCgevSecPadInd(CHAR * pStrWalk, T_zMmiaSm_Cgev_SecPdn SmCgevVal)
{
    if(SmCgevVal.bType == Z_APMMIA_CGEV_NW_SEC_PDN_ACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW ACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_ME_SEC_PDN_ACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: ME ACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_NW_SEC_PDN_DEACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW DEACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_ME_SEC_PDN_DEACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: ME DEACT ", g_zAt_CRLF);
    }
    else
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);
    sprintf((char *)pStrWalk, "%d,%d,%d%s", SmCgevVal.bPriCid,SmCgevVal.bCid,SmCgevVal.bEventType,g_zAt_CRLF);

    return TRUE;
}

BOOL zAt_EncSmCgevModifyInd(CHAR * pStrWalk, T_zMmiaSm_Cgev_ModifyPdn SmCgevVal)
{
    if(SmCgevVal.bType == Z_APMMIA_CGEV_NW_MODIFY)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW MODIFY ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_ME_MODIFY)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: ME MODIFY ", g_zAt_CRLF);
    }
    else
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);
    sprintf((char *)pStrWalk, "%d,%d,%d%s", SmCgevVal.bCid,SmCgevVal.bChngReason,SmCgevVal.bEventType,g_zAt_CRLF);
    
    return TRUE;
}

BOOL __ps_4g_func zAt_EncSmCgevPriPadInd(CHAR * pStrWalk, T_zMmiaSm_Cgev_PriPdn SmCgevVal)
{
    if(SmCgevVal.bType == Z_APMMIA_CGEV_ME_PRI_PDN_ACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: ME PDN ACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_NW_PRI_PDN_DEACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW PDN DEACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_ME_PRI_PDN_DEACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: ME PDN DEACT ", g_zAt_CRLF);
    }
    else if(SmCgevVal.bType == Z_APMMIA_CGEV_NW_PRI_PDN_ACT)
    {
        sprintf((char *)pStrWalk, "%s+CGEV: NW PDN ACT ", g_zAt_CRLF);
    }
    else
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);
    sprintf((char *)pStrWalk, "%d%s", SmCgevVal.bCid,g_zAt_CRLF);

    return TRUE;
}

UINT16 __ps_4g_func zAt_PsEncSmCgevInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zMmiaSm_Cgev_Ind *pCgevInd = (T_zMmiaSm_Cgev_Ind*) pEncCmdInfo->pMsgBody;
    BOOL bEncResult = FALSE;

    switch (pCgevInd->bCgevType)
    {
        case Z_MMIASM_CGEV_TYPE_PRI_PDN_IND:
        {            
            bEncResult = zAt_EncSmCgevPriPadInd(pEncCmdInfo->pStrCmd, pCgevInd->u.tPriPdnInd);
        }
        break;

        case Z_MMIASM_CGEV_TYPE_MODIFY_IND:
        {
            bEncResult = zAt_EncSmCgevModifyInd(pEncCmdInfo->pStrCmd, pCgevInd->u.tModifyInd);
        }
        break;
        
        case Z_MMIASM_CGEV_TYPE_SEC_PDN_IND:
        {
            bEncResult = zAt_EncSmCgevSecPadInd(pEncCmdInfo->pStrCmd, pCgevInd->u.tSecPdnInd);
        }
        break;
        
        case Z_MMIASM_CGEV_TYPE_OTHER_IND:
        {
            /*617001621882Ӧðipv4v6Ͳv4v6*/
            bEncResult = zAt_EncSmCgevOthInd(pEncCmdInfo->pStrCmd, pCgevInd->u.tR5VerInd);
        }
        break;
        
    default:
        {
            return 0;
        }
    }
    if (!bEncResult)
    {
        return 0;
    }
    
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_EncSmsMemType
*  iMemĴ洢ͣӦַĿַ
* ˵ (IO):
*            pStrWalk:  ַĵַ
*            (I):
*            iMem:      洢ֵ
*   ֵ TRUE ɹ FALSE ʧ
* ˵ йش洢͵Ӻ
**************************************************************************/
BYTE zAt_EncSmsMemType(CHAR * pStrWalk, UINT8 iMem)
{
    // iMemм
    //CHAR * smsMem[6] = {"\"BM\"", "\"ME\"", "\"MT\"",  "\"SM\"", "\"TA\"", "\"SR\""};
    //return (BYTE)sprintf((char *)pStrWalk, (const char *)smsMem[iMem]);

    if(Z_APMMIA_CPMSMEM_BM == iMem)
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"BM\"");
    }
    else if(Z_APMMIA_CPMSMEM_ME == iMem)
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"ME\"");
    }
    else if(Z_APMMIA_CPMSMEM_MT == iMem)
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"MT\"");
    }
    else if(Z_APMMIA_CPMSMEM_USIM == iMem)
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"SM\"");
    }
    else if(Z_APMMIA_CPMSMEM_TA == iMem)
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"TA\"");
    }
    else
    {
        return (BYTE)sprintf((char *)pStrWalk, "\"SR\"");
    }
}

/* 
// number type
// bNumFg ptNumǷڣ
*/
BOOL zAt_EncPbNumType(CHAR * pStrWalk, BYTE bNumFg, T_z_CallNum *ptNum)
{
    if(bNumFg == 1)
    {
        /* <num1>,<type>, */
        pStrWalk += sprintf((char *)pStrWalk, ",");
        pStrWalk += zAt_EncSmsAddrType(pStrWalk, ptNum->bNumType);  

        if (ptNum->bNumLen > Z_MAX_CALLNUM_LEN)
        {
            return FALSE;
        }                    
    
        /* print the BCD number */
        
        if (g_zAti_ptData->bEModeType == 0 && ptNum->bNumLen > Z_APMMIA_SCALLNUM_MAXLEN)
        {
            ptNum->bNumLen = Z_APMMIA_SCALLNUM_MAXLEN;        
        }
    
        zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)ptNum->abNum, 
            ptNum->bNumLen, ZAT2_CSCS_GSM);

        pStrWalk += strlen((const char *)pStrWalk);
    
        if((ptNum->bNumType != 0) && (ptNum->bNumType != 0xff))
        {       
            pStrWalk += sprintf((char *)pStrWalk, "\",%d", ptNum->bNumType);
        }
        else
        {
            pStrWalk += sprintf((char *)pStrWalk, "\",");    
        }
    }
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, ",\"\",");  
    }

    return TRUE;
}

BOOL __ps_comm_func zAt_EncBCDNumType(BYTE bCommaFg, CHAR * pStrWalk, T_z_CallNum *ptNum)
{
    /* <num1>,<type>, */
    if(bCommaFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
    }
    pStrWalk += zAt_EncSmsAddrType(pStrWalk, ptNum->bNumType);  

    if (ptNum->bNumLen > Z_MAX_CALLNUM_LEN)
    {
        return FALSE;
    }    
    
    /* print the BCD number */
    zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)ptNum->abNum, 
            ptNum->bNumLen, ZAT2_CSCS_GSM);

    pStrWalk += strlen((const char *)pStrWalk);
    pStrWalk += sprintf((char *)pStrWalk, "\",%d", ptNum->bNumType);

    return TRUE;
}

BOOL zAt_EncBCDAddrType(BYTE bCommaFg, CHAR * pStrWalk, T_z_CallSubAddr *ptAddr)
{
    /*  [,<subaddr>,<satype>]  */
    if(bCommaFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
    }
     
    pStrWalk += zAt_EncSmsAddrType(pStrWalk, ptAddr->bTypeSubAddr);  

    if (ptAddr->bSubAddrLen > Z_MAX_SUBADDR_LEN)
    {
        return FALSE;
    }    
    
    /* print the BCD number */
    zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)ptAddr->abSubAddr, 
            ptAddr->bSubAddrLen , ZAT2_CSCS_GSM);

    pStrWalk += strlen((const char *)pStrWalk);
    pStrWalk += sprintf((char *)pStrWalk, "\",%d", ptAddr->bTypeSubAddr);

    return TRUE;
}

UINT16 __ps_comm_func zAt_EncPbTextByCscs(BYTE bCommaFg,CHAR * pTarget, BYTE bTextFg, BYTE *pbTextVal)
{
        /* <text> */
    CHAR * pStrWalk = pTarget;
    UINT16 wTextLen = 0;
    UINT16 i = 0;
    if(bCommaFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
    }
    pStrWalk += sprintf((char *)pStrWalk, "\"");
    if(bTextFg == Z_APMMIA_VALID)
    {
        wTextLen = zAt_EncAlphaStrLenByCscsType(pbTextVal);
        if(wTextLen > 0)
        {
            if(!zAt_EncPbStrByCscsType(pStrWalk, pbTextVal, wTextLen, g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp))
            {
                if(strlen((const char*)pStrWalk) > 0)
                {
                    zOss_Memset(pStrWalk, 0, strlen((const char*)pStrWalk));
                }
                for(i = 0; i < wTextLen; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pbTextVal[i]);
                }
            }
            pStrWalk += strlen((const char *)pStrWalk);
        }
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");
    return (UINT16)strlen((char *)pTarget);
}

/**************************************************************************
* ƣ zAt_PsEncSmsStoreRecInd
*  ZPS_ApMmia_SmsStoreRecInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMTI,+CDSI,+CBMIϱı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsStoreRecInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SaveSm_Cnf *pStoRecInd = (T_zApMmia_SaveSm_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CMTI: <mem>,<Index> */
    /* +CDSI: <mem>,<Index> */
    /* +CBMI: <mem>,<Index> */

    switch (pStoRecInd->bSaveFlag)
    {
    case Z_APMMIA_SMSAVEFLAG_DELIVERREP: /* deliverϢ */
        {
            pStrWalk +=sprintf((char *)pStrWalk, "%s+CMTI: ", g_zAt_CRLF);
        }
        break;
    case Z_APMMIA_SMSAVEFLAG_STATUSREP: /* status report */
        {
            pStrWalk +=sprintf((char *)pStrWalk, "%s+CDSI: ", g_zAt_CRLF);
        }
        break;
    case Z_APMMIA_SMSAVEFLAG_CBMSREP:
        {
            pStrWalk +=sprintf((char *)pStrWalk, "%s+CBMI: ", g_zAt_CRLF);
        }
        break;
    default:
        {
            return 0;
        }
    }
    
    if(pStoRecInd->bMem > Z_APMMIA_CPMSMEM_SR)
    {
        return 0;
    }
    pStrWalk +=zAt_EncSmsMemType(pStrWalk, pStoRecInd->bMem);
    
    sprintf((char *)pStrWalk, ",%d%s", pStoRecInd->wIndex, g_zAt_CRLF);

    return  (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncSmsCbmPduInd
*  ZPS_ApMmia_Cbs_PcbmInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CBMϱı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCbmPduInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_Cbs_Pcbm_Ind *pPcbmInd = (T_zApMmia_Cbs_Pcbm_Ind*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +CBM: <length><CR><LF><pdu> */

    pStrWalk += sprintf((char *)pStrWalk, "%s+CBM: %d%s", g_zAt_CRLF, pPcbmInd->bMsgLen, g_zAt_CRLF);

    /* <pdu> */

    /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
    if (pPcbmInd->bMsgLen > Z_APMMIA_CBS_MAX_PDU_PAGE_LEN)
    {
        return 0;//ѭȳ鳤
    }

    for (i = 0; i < pPcbmInd->bMsgLen; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%02X", pPcbmInd->abBuf[i]);
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCbmTextInd
*  ZPS_ApMmia_Cbs_TcbmInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CBMϱı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCbmTextInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_Cbs_Tcbm_Ind *pTcbmInd = (T_zApMmia_Cbs_Tcbm_Ind*) pEncCmdInfo->pMsgBody;

    /* +CBM: <sn>,<mid>,<dcs>,<page>,<pages><CR><LF><data>*/
    if (pTcbmInd->bTotalPage == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {      
        /* <sn>,<mid>,<dcs>,<page>,<pages> */ /* <CR><LF> */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CBM: %d,%d,%d,%d,%d%s", g_zAt_CRLF,pTcbmInd->wSn, 
            pTcbmInd->wMid, pTcbmInd->bDcs,pTcbmInd->bCurPage,pTcbmInd->bTotalPage, g_zAt_CRLF); 

        /* <data> */
        if (!zAt_EncCbsTextData(pStrWalk, pTcbmInd->abBuf, pTcbmInd->bMsgLen,pTcbmInd->bDcs, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp, Z_APMMIA_CBS_MAX_TEXT_PAGE_LEN))
        {
            return 0;
        }
        pStrWalk += strlen((const char *)pStrWalk);

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pTcbmInd->bCurPage == pTcbmInd->bTotalPage)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCdsPduInd
*  ZPS_ApMmia_SmsPcdsInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CDSϱı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCdsPduInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSms_StatusRec_Ind *pPcdsInd = (T_zMmiaSms_StatusRec_Ind*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +CDS: <length><CR><LF><pdu> */

    if (!pPcdsInd->bPduLength || pPcdsInd->abPduBuffer[0] > 11 || pPcdsInd->bPduLength < (pPcdsInd->abPduBuffer[0] + 1))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                      
        return ZAT_ENC_NONEED_CNF;
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+CDS: %d%s", g_zAt_CRLF,(pPcdsInd->bPduLength - (pPcdsInd->abPduBuffer[0] +1)), g_zAt_CRLF);

    /* <pdu> */
    /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
    for (i = 0; i < pPcdsInd->bPduLength; i++, pStrWalk += 2)
    {
        sprintf((char *)pStrWalk, "%02X", pPcdsInd->abPduBuffer[i]);
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCdsTextInd
*  ZPS_ApMmia_SmsTcdsInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CDSϱı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCdsTextInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSms_StatusRec_Ind *pTcdsInd = (T_zMmiaSms_StatusRec_Ind*) pEncCmdInfo->pMsgBody;
    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtStatMsg tTxtStatMsg = {0};
    T_zApMmia_TZAndTime tTpSCTS = {0};
    T_zApMmia_TZAndTime tTpDischageTime = {0};
    UINT8 iFoTmp = 0;

    /* +CDS: <fo>,<mr>,[<ra>],[<tora>],<scts>,<dt>,<st> */

    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = pTcdsInd->bPduLength;
    tPduMsg.pbPduBuf = pTcdsInd->abPduBuffer;
    
    zAti_ReadoutStatPdu(&tPduMsg, &tTxtStatMsg);/*ͷϢ*/
    zAti_ArrayToScts(&tTpSCTS, tTxtStatMsg.abScts);
    zAti_ArrayToScts(&tTpDischageTime, tTxtStatMsg.abDisTime);
    iFoTmp = zAt_GetTpFoToByte(&tTxtStatMsg.tTpFo);

    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/

    /* <fo>,<mr>, */
    pStrWalk += sprintf((char *)pStrWalk, "%s+CDS: %d,%d", g_zAt_CRLF, iFoTmp, tTxtStatMsg.bTpmr);

    pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, &tTxtStatMsg.tTpra);
   
    /* ,<scts>,<dt> (<scts>,<dt>: "yy/MM/dd,hh:mm:ss+zz") */
    pStrWalk += zAt_EncTime2Str(pStrWalk, tTpSCTS);

    pStrWalk += zAt_EncTime2Str(pStrWalk, tTpDischageTime);

    /* ,<st> */
    sprintf((char *)pStrWalk, ",%d%s", tTxtStatMsg.bStatVal, g_zAt_CRLF);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgcPduCnf
*  ZPS_ApMmia_SmsPcmgcCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGCӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgcPduCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    //T_zMmiaSms_MsgSend_Cnf *pPcmgcCnf = (T_zMmiaSms_MsgSend_Cnf*) pEncCmdInfo->pMsgBody;
    T_zMmiaSms_MsgSend_Cnf *pPcmgcCnf = &ptUiccInfo->tMsgSendCnf;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (pPcmgcCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMGC: <mr>[,<ackpdu>] */

        pStrWalk += sprintf((char *)pStrWalk, "%s+CMGC: %d", g_zAt_CRLF, pPcmgcCnf->bTpMsgRef);

        if (pPcmgcCnf->bTpduLength > 0)
        {
            if (pPcmgcCnf->bTpduLength > Z_APMMIA_MAX_SMSTPDU_LEN)
            {
                return 0;//ѭȳ鳤
            }

            /* [,<ackpdu>] */
            if (tAtData.bCsmsSvc == 1)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",");

                for (i = 0; i < pPcmgcCnf->bTpduLength; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pPcmgcCnf->abTPduBuffer[i]);
                }
            }
        }

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pPcmgcCnf->dwCause);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgcTextCnf
*  ZPS_ApMmia_SmsTcmgcCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGCӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgcTextCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    //T_zMmiaSms_MsgSend_Cnf *pTcmgcCnf = (T_zMmiaSms_MsgSend_Cnf*) pEncCmdInfo->pMsgBody;
    T_zMmiaSms_MsgSend_Cnf *pTcmgcCnf = &ptUiccInfo->tMsgSendCnf;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zApMmia_TZAndTime tTpScts = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (pTcmgcCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMGC: <mr>[,<scts>] */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CMGC: %d", g_zAt_CRLF, pTcmgcCnf->bTpMsgRef);

        if (tAtData.bCsmsSvc == Z_APMMIA_CSMSSVC_SPECIAL)
        {
            /* [,<scts>] "yy/MM/dd,hh:mm:ss+zz"*/
            zAti_ArrayToScts(&(tTpScts),&pTcmgcCnf->abTPduBuffer[2]);           
            
            pStrWalk += zAt_EncTime2Str(pStrWalk, tTpScts);
        }

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pTcmgcCnf->dwCause);
    }
    
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgdTestCnf
*  ZPS_ApMmia_SmsQueryMaxIndexCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGDӦı뺯
617001762340 lxh 12.10.08
**************************************************************************/
UINT16 zAt_PsEncSmsCmgdTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT16 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_ZAti_ValidIndexCnf *pCmgdTestCnf = (T_ZAti_ValidIndexCnf*) pEncCmdInfo->pMsgBody;

    /* +CMGD: (list of supported <index>s)[,(list of supported <delflag>s)] */
    {   
        if (pCmgdTestCnf->bIndexNum > ZATI2_CPMSMEM_USIM_MAX_NUM)
        {
            return 0;
        }
        pStrWalk += sprintf((char *)pStrWalk, "%s+CMGD: (", g_zAt_CRLF);

        for (i =0; i < pCmgdTestCnf->bIndexNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d,", pCmgdTestCnf->arrIndex[i]);
        }
        
        if (pCmgdTestCnf->bIndexNum > 0)
        {
            pStrWalk--;
        }
        sprintf((char *)pStrWalk, "),(0-4)%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncSmsCmglPduCnf
*  ZPS_ApMmia_SmsPcmglCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmglPduCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsPcmgl_Cnf *pPcmglCnf = (T_zApMmia_SmsPcmgl_Cnf*) pEncCmdInfo->pMsgBody;
    UINT16 i =0;

    /* +CMGL: <Index>,<stat>,[<alpha>],<length><CR><LF><pdu>
       [<CR><LF>+CMGL:< Index>,<stat>,[<alpha>],<length><CR><LF><pdu>[...]]
    */

    if (pPcmglCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* Ϣֶȡ */
        pStrWalk += zAt_EncCmglHead(pStrWalk, pPcmglCnf->bStatChgFlg);
        pStrWalk += sprintf((char *)pStrWalk, "%d,", pPcmglCnf->wIndex);

        if(pPcmglCnf->bMsgStatVal < ZAT_SMS_STATE_MAX)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d", pPcmglCnf->bMsgStatVal);
        }

        pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, pPcmglCnf->bNameFg , pPcmglCnf->tName.abTextVal);

        /*[<alpha>]*/  

        pStrWalk += sprintf((char *)pStrWalk, ",%d%s", pPcmglCnf->bTpduLength, g_zAt_CRLF); 
        /* <pdu> */

        /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
        if (pPcmglCnf->bTpduLength + pPcmglCnf->abPduBuf[0] + 1 > Z_APMMIA_MAX_SMSPDU_LEN)
        {
            return 0;//ѭȳ鳤
        }

        if (pPcmglCnf->bMem == Z_APMMIA_CPMSMEM_SR)
        {
            for (i = 0; i < pPcmglCnf->bTpduLength; i++, pStrWalk += 2)
            {
                sprintf((char *)pStrWalk, "%02X", pPcmglCnf->abPduBuf[i]);
            }
        }
        else
        {
            for (i = 0; i < (pPcmglCnf->bTpduLength + pPcmglCnf->abPduBuf[0] + 1); i++, pStrWalk += 2)
            {
                sprintf((char *)pStrWalk, "%02X", pPcmglCnf->abPduBuf[i]);
            }
        }

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pPcmglCnf->WCurNum == pPcmglCnf->wTotalNum)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncCbsCmglPcbmListCnf
*  ZPS_ApMmia_Cbs_PcbmListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCmglPcbmListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_Cbs_PcbmList_Cnf *pPcbmcmglCnf = (T_zApMmia_Cbs_PcbmList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT16 i =0;
    
    /* +CMGL: <Index>,<stat>,[<alpha>],<length><CR><LF><pdu>
       [<CR><LF>+CMGL:< Index>,<stat>,[<alpha>],<length><CR><LF><pdu>[...]]
    */
    
    if ((pPcbmcmglCnf->bListEndFg == 1) && (pPcbmcmglCnf->bMsgLen == 0))/*zpr20100428*/
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {    
        /* Ϣֶȡ */
         pStrWalk += zAt_EncCmglHead(pStrWalk, pPcbmcmglCnf->bStatChgFlg);

        if(pPcbmcmglCnf->bMsgStatVal < ZAT_SMS_STATE_MAX)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d,%d,\"\",%d%s", pPcbmcmglCnf->wIndex, pPcbmcmglCnf->bMsgStatVal, pPcbmcmglCnf->bMsgLen, g_zAt_CRLF);
        }
        else
        {
             pStrWalk += sprintf((char *)pStrWalk, "%d,,\"\",%d%s", pPcbmcmglCnf->wIndex, pPcbmcmglCnf->bMsgLen, g_zAt_CRLF);
        }
        /* <pdu> */
    
        /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
        if (pPcbmcmglCnf->bMsgLen + pPcbmcmglCnf->abBuf[0] + 1 > Z_APMMIA_MAX_SMSPDU_LEN)
        {
            return 0;//ѭȳ鳤
        }

        for (i = 0; i < (pPcbmcmglCnf->bMsgLen + pPcbmcmglCnf->abBuf[0] + 1); i++, pStrWalk += 2)
        {
            sprintf((char *)pStrWalk, "%02X", pPcbmcmglCnf->abBuf[i]);
        }

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pPcbmcmglCnf->bListEndFg == 1)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }
    
    return  (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
    
/**************************************************************************
* ƣ zAt_PsEncCbsCmglTcbmListCnf
*  ZPS_ApMmia_Cbs_TcbmListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCmglTcbmListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;       
    T_zApMmia_Cbs_TcbmList_Cnf *pTcmglCbmCnf = (T_zApMmia_Cbs_TcbmList_Cnf*) pEncCmdInfo->pMsgBody;

    /*
    +CMGL: <index>,<stat>,<sn>,<mid>,<page>,<pages><CR><LF><data>
    [<CR><LF>+CMGL: <index>,<stat>,<sn>,<mid>,<page>,<pages><CR><LF><data>[...]]
    */
    
    if (pTcmglCbmCnf->bTotalPage == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* +CMGL: <index>,<stat>,<sn>,<mid>,<page>,<pages> */

        pStrWalk += zAt_EncCmglHead(pStrWalk, pTcmglCbmCnf->bStatChgFlg);
        pStrWalk += sprintf((char *)pStrWalk, "%d,", pTcmglCbmCnf->wIndex);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmglCbmCnf->bMsgStatVal );
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d", 
             pTcmglCbmCnf->wSn, pTcmglCbmCnf->wMid,pTcmglCbmCnf->bCurPage, pTcmglCbmCnf->bTotalPage);

        /* <CR><LF> */
        pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
        
        /* <data> */
    
        if (!zAt_EncCbsTextData(pStrWalk, pTcmglCbmCnf->abBuf, pTcmglCbmCnf->bMsgLen,pTcmglCbmCnf->bDcs, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp, Z_APMMIA_CBS_MAX_TEXT_PAGE_LEN))
        {
            return 0;
        }    
    
        pStrWalk += strlen((const char *)pStrWalk);
      
        /* жǷǰΪӦһΣս,ΪӦ */
        if (pTcmglCbmCnf->bCurPage == pTcmglCbmCnf->bTotalPage)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    } 
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncSmsCmglTdeliListCnf
*  ZPS_ApMmia_SmsTdeliListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmglTdeliListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsTdeliList_Cnf *pTcmglDeliCnf = (T_zApMmia_SmsTdeliList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iTpAddrType = 0;

    /* +CMGL: <Index>,<stat>,<oa/da>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data>
       [<CR><LF>+CMGL: <Index>,<stat>,<da/oa>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data>[...]]
    */

    if (pTcmglDeliCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* Ϣֶȡ */

        /* +CMGL: <Index>,<stat>,<oa/da>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data> */

        /*---------------- Construction of iaddrType ---------------*/
        /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
        /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
        /*----------------------------------------------------------*/
       iTpAddrType = zAt_GetAddrTypeToByte(&pTcmglDeliCnf->tTpOriginalAddr.tAddressType);

        /* +CMGL: <Index>,<stat>, */
        pStrWalk += zAt_EncCmglHead(pStrWalk, pTcmglDeliCnf->bStatChgFlg);
        pStrWalk += sprintf((char *)pStrWalk, "%d,", pTcmglDeliCnf->wIndex);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmglDeliCnf->bMsgStatVal );
        
        /* <oa/da>, */
        pStrWalk += zAt_EncTpAddrVal(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, iTpAddrType, &pTcmglDeliCnf->tTpOriginalAddr); 

        /* [<alpha>] */
        pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, pTcmglDeliCnf->bNameFg, pTcmglDeliCnf->tName.abTextVal);
         
        /* <scts> */
        pStrWalk += zAt_EncTime2Str(pStrWalk, pTcmglDeliCnf->tTpSCTS);

        if (pTcmglDeliCnf->bMsgHeadInd == Z_APMMIA_CSDH_SHOW)
        {
            /* [,<tooa/toda>,<length>] */
            pStrWalk +=  sprintf((char *)pStrWalk, ",%d,%lu", iTpAddrType, pTcmglDeliCnf->dwTextLength);
        }

        /* <CR><LF> */
        pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

        /* <data> */
        if (pTcmglDeliCnf->pTextBuffer != NULL)
        {
            /* ͷıָ */

            if (!zAt_EncSmsTextData(pStrWalk, pTcmglDeliCnf->pTextBuffer, 
                pTcmglDeliCnf->dwTextLength, pTcmglDeliCnf->bCharNum,
                pTcmglDeliCnf->bDcs,
                pTcmglDeliCnf->tTpFirstOctet.bTpudHeadInd, 
                g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp))
            {
                zAti_RetUB((VOID**)&pTcmglDeliCnf->pTextBuffer);
                return 0;
            }
            zAti_RetUB((VOID**)&pTcmglDeliCnf->pTextBuffer);
        }
        pStrWalk += strlen((const char *)pStrWalk);

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pTcmglDeliCnf->wCurNum == pTcmglDeliCnf->wTotalNum)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmglTsubListCnf
*  ZPS_ApMmia_SmsTsubListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmglTsubListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsTsubList_Cnf *pTcmglSubCnf = (T_zApMmia_SmsTsubList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iTpAddrType = 0;

    /* +CMGL: <Index>,<stat>,<oa/da>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data>
       [<CR><LF>+CMGL: <Index>,<stat>,<da/oa>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data>[...]]
    */

    if (pTcmglSubCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* Ϣֶȡ */

        /* +CMGL: <Index>,<stat>,<oa/da>,[<alpha>],[<scts>][,<tooa/toda>,<length>]<CR><LF><data> */

        /*---------------- Construction of iaddrType ---------------*/
        /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
        /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
        /*----------------------------------------------------------*/
        iTpAddrType = zAt_GetAddrTypeToByte(&pTcmglSubCnf->tTpDestAddr.tAddressType); 
        
        /* +CMGL: <Index>,<stat>, */
        pStrWalk += zAt_EncCmglHead(pStrWalk, pTcmglSubCnf->bStatChgFlg);
        pStrWalk += sprintf((char *)pStrWalk, "%d,", pTcmglSubCnf->wIndex);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmglSubCnf->bMsgStatVal );

        /* <oa/da>, */
        pStrWalk += zAt_EncTpAddrVal(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, iTpAddrType, &pTcmglSubCnf->tTpDestAddr); 

        pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, pTcmglSubCnf->bNameFg, pTcmglSubCnf->tName.abTextVal);

        /* [<alpha>], ʵ*/      
        
        pStrWalk += sprintf((char *)pStrWalk, ",\"\"");

        /* [<scts>] ΪSMS-SUBMITʱ޴˲ */

        if (pTcmglSubCnf->bMsgHeadInd == Z_APMMIA_CSDH_SHOW)
        {
            /* [,<tooa/toda>,<length>] */
            pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu", iTpAddrType, pTcmglSubCnf->dwTextLength);
        }

        /* <CR><LF> */
        pStrWalk += sprintf((char *)pStrWalk, "%s",  g_zAt_CRLF);

        /* <data> */
        if (pTcmglSubCnf->pTextBuffer != NULL)
        {
            /* ͷıָ */
            if (!zAt_EncSmsTextData(pStrWalk, pTcmglSubCnf->pTextBuffer, pTcmglSubCnf->dwTextLength,
                pTcmglSubCnf->bCharNum, pTcmglSubCnf->bDcs, pTcmglSubCnf->tTpFirstOctet.bTpudHeadInd, 
                g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp))
            {
                zAti_RetUB((VOID**)&pTcmglSubCnf->pTextBuffer);
                return 0;
            }
            zAti_RetUB((VOID**)&pTcmglSubCnf->pTextBuffer);
        }
        pStrWalk += strlen((const char *)pStrWalk);

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pTcmglSubCnf->wCurNum == pTcmglSubCnf->wTotalNum)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmglTstatListCnf
*  ZPS_ApMmia_SmsTstatListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmglTstatListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsTstatList_Cnf *pTcmglStatCnf = (T_zApMmia_SmsTstatList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iFoTmp = 0;

    /* +CMGL: <Index>,<stat>,<fo>,<mr>,[<ra>],[<tora>],<scts>,<dt>,<st>
       [<CR><LF>+CMGL: <Index>,<stat>,<fo>,<mr>,[<ra>],[<tora>],<scts>,<dt>,<st>[...]]
    */

    if (pTcmglStatCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* ҪZAT2_MID_CMD_LENȿռ */

        /* Ϣֶȡ */

        /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
        /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
        /*       7             6                  5                 4   3             2        1   0   */
        /*---------------------------------------------------------------------------------------------*/
        iFoTmp = zAt_GetTpFoToByte(&pTcmglStatCnf->tTpFirstOctet);

        /*---------------- Construction of iaddrType ---------------*/
        /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
        /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
        /*----------------------------------------------------------*/
  
        /* +CMGL: <Index>,<stat>,<fo>,<mr>,[<ra>],[<tora>],<scts>,<dt>,<st> */

        /* +CMGL: <Index>,<stat>,<fo>,<mr>, */
        pStrWalk += zAt_EncCmglHead(pStrWalk, pTcmglStatCnf->bStatChgFlg);
        pStrWalk += sprintf((char *)pStrWalk, "%d,", pTcmglStatCnf->wIndex);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmglStatCnf->bMsgStatVal );
        
       
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d", iFoTmp, pTcmglStatCnf->bTpMsgRefer);        
        // [<ra>],
        pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, &pTcmglStatCnf->tTpReceiveAddr);        

        /* ,<scts>,<dt>, */

        pStrWalk += zAt_EncTime2Str(pStrWalk, pTcmglStatCnf->tTpSCTS);

        pStrWalk += zAt_EncTime2Str(pStrWalk, pTcmglStatCnf->tTpDischageTime);
        /* ,<st> */
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pTcmglStatCnf->bStatusValue);

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pTcmglStatCnf->wCurNum == pTcmglStatCnf->wTotalNum)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmglTcomListCnf
*  ZPS_ApMmia_SmsTcomListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGLӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmglTcomListCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsTcomList_Cnf *pTcmglComCnf = (T_zApMmia_SmsTcomList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iFoTmp = 0;

    /* +CMGL: <Index>,<stat>,<fo>,<ct>
       [<CR><LF>+CMGL: <Index>,<stat>,<fo>,<ct>[...]]
    */

    if (pTcmglComCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }
    else
    {
        /* Ϣֶȡ */

        /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
        /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
        /*       7             6                  5                 4   3             2        1   0   */
        /*---------------------------------------------------------------------------------------------*/
        iFoTmp = zAt_GetTpFoToByte(&pTcmglComCnf->tTpFirstOctet);

        /* +CMGL: <Index>,<stat>,<fo>,<ct> */
        pStrWalk += zAt_EncCmglHead(pStrWalk, pTcmglComCnf->bStatChgFlg);

        pStrWalk += sprintf((char *)pStrWalk, "%d,", pTcmglComCnf->wIndex);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmglComCnf->bMsgStatVal );
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d", iFoTmp, pTcmglComCnf->bTpCommandType);
        
        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pTcmglComCnf->wCurNum == pTcmglComCnf->wTotalNum)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgrPduCnf
*  ZPS_ApMmia_SmsPcmgrCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgrPduCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ReadSm_Cnf *pPcmgrCnf = (T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    T_z_CallNum tCallNum = {0};
    UINT8 i = 0;
    BYTE bTpduLength = 0;

    if (pPcmgrCnf->bMem != Z_APMMIA_CPMSMEM_SR && pPcmgrCnf->dwLen <= (DWORD)(*(pPcmgrCnf->pbMsg) + 1))
    {
        /* 洢SR, ҪSCAȺϢȵһ*/
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_CMSUNKNOWN_ERR);
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                      
        zAti_RetUB((VOID **)&pPcmgrCnf->pbMsg);
        return 0;
    }

    bTpduLength = (BYTE)((pPcmgrCnf->bMem == Z_APMMIA_CPMSMEM_SR) ? pPcmgrCnf->dwLen :((pPcmgrCnf->dwLen - *(pPcmgrCnf->pbMsg)) - 1));
    
    /*========================= кѯ(PDU) ================================*/
    /* +CMGR: <stat>,[<alpha>],<length><CR><LF><pdu> */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pPcmgrCnf->bStatChgFlg);

    if(pPcmgrCnf->bStatus < ZAT_SMS_STATE_MAX)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d,\"", pPcmgrCnf->bStatus);
    }
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, ",\"");
    }
              
    if (TRUE == zAti_IsSmcodeNeedAlpha(pPcmgrCnf->pbMsg, pPcmgrCnf->bMem))
    {
        zAti_GetTpadrFromPDU(&tCallNum, pPcmgrCnf->pbMsg);
        pStrWalk += zAt_EncNameStrByNum (pStrWalk, &tCallNum, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\",%d%s", bTpduLength, g_zAt_CRLF);

    /* <pdu> */
    /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
    for (i = 0; i < pPcmgrCnf->dwLen; i++, pStrWalk += 2)
    {
        sprintf((char *)pStrWalk, "%02X", pPcmgrCnf->pbMsg[i]);
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    zAti_RetUB((VOID **)&pPcmgrCnf->pbMsg);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgrPcbmReadCnf
*  ZPS_ApMmia_Cbs_PcbmReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCmgrPcbmReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ReadSm_Cnf *pPcmgrCnf = (T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +CMGR: <stat>,[<alpha>],<length><CR><LF><pdu> */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pPcmgrCnf->bStatChgFlg);

    if(pPcmgrCnf->bStatus < ZAT_SMS_STATE_MAX)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d,\"\",%lu%s", pPcmgrCnf->bStatus,pPcmgrCnf->dwLen, g_zAt_CRLF);
    }
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, ",\"\",%lu%s", pPcmgrCnf->dwLen, g_zAt_CRLF);
    }
    /* <pdu> */

    /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
    if (pPcmgrCnf->dwLen + pPcmgrCnf->pbMsg[0] + 1 > Z_APMMIA_MAX_SMSPDU_LEN)
    {
        zAti_RetUB((VOID **)&pPcmgrCnf->pbMsg);
        return 0;//ѭȳ鳤
    }

    for (i = 0; i < (pPcmgrCnf->dwLen + pPcmgrCnf->pbMsg[0] + 1); i++, pStrWalk += 2)
    {
        sprintf((char *)pStrWalk, "%02X", pPcmgrCnf->pbMsg[i]);
    }
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    zAti_RetUB((VOID **)&pPcmgrCnf->pbMsg);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt_PsEncCbsCmgrTcbmReadCnf
*  ZPS_ApMmia_Cbs_TcbmReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncCbsCmgrTcbmReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;       
    T_zApMmia_ReadSm_Cnf *pTcmgrCbmCnf = ( T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    WORD wSn = 0;
    WORD wMid = 0;
    BYTE bDcs = *(pTcmgrCbmCnf->pbMsg + 4);
    BYTE bTotalPage = (*(pTcmgrCbmCnf->pbMsg + 5) & 0x0f);
    BYTE bCurPage   = ((*(pTcmgrCbmCnf->pbMsg + 5) & 0xf0) >> 4);

    if (pTcmgrCbmCnf->dwLen <= 6)
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_CMSUNKNOWN_ERR);
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");                      
        zAti_RetUB((VOID **)&pTcmgrCbmCnf->pbMsg);
        return 0;
    }
    
    zAti_BytesDToWord(&wSn, pTcmgrCbmCnf->pbMsg);
    zAti_BytesDToWord(&wMid, pTcmgrCbmCnf->pbMsg + 2);
    
    /*+CMGR: <stat>,<sn>,<mid>,<dcs>,<page>,<pages><CR><LF><data>*/
    
    if (bTotalPage == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
        zAti_RetUB((VOID **)&pTcmgrCbmCnf->pbMsg);
        return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }
    else
    {
        /* +CMGR: <stat>,<sn>,<mid>,<dcs>,<page>,<pages> */ 
        pStrWalk += zAt_EncCmgrHead(pStrWalk, pTcmgrCbmCnf->bStatChgFlg);
        pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmgrCbmCnf->bStatus);
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d", wSn,wMid, bDcs, bCurPage, bTotalPage);

        /* <CR><LF> */
        pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

        /* <data> */
        if (!zAt_EncCbsTextData(pStrWalk, pTcmgrCbmCnf->pbMsg + 6, (BYTE)(pTcmgrCbmCnf->dwLen - 6),bDcs, 
                g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp, Z_APMMIA_CBS_MAX_TEXT_PAGE_LEN))
        {
            zAti_RetUB((VOID **)&pTcmgrCbmCnf->pbMsg);
            return 0;
        }

        pStrWalk += strlen((const char *)pStrWalk);
      
        /* жǷǰΪӦһΣս,ΪӦ */
        if (bCurPage == bTotalPage)
        {
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    } 

    zAti_RetUB((VOID **)&pTcmgrCbmCnf->pbMsg);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt_PsEncSmsCmgrTdeliReadCnf
*  ZPS_ApMmia_SmsTdeliReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgrTdeliReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_SmsTdeliRead_Cnf *pTcmgrDeliCnf = (T_zApMmia_SmsTdeliRead_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iFoTmp = 0;
    UINT8 iTpAddrType = 0;
    BOOL bBcd2StrRet = FALSE;
    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
    iFoTmp = zAt_GetTpFoToByte(&pTcmgrDeliCnf->tTpFirstOctet);

    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/
    iTpAddrType = zAt_GetAddrTypeToByte(&pTcmgrDeliCnf->tTpSrcAddr.tAddressType);

    /* +CMGR: <stat>,<oa>,[<alpha>],<scts>[,<tooa>,<fo>,<pid>,<dcs>,<sca>,<tosca>,<length>]<CR><LF><data> */

    /* +CMGR: <stat>, */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pTcmgrDeliCnf->bStatChgFlg);
        
    pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmgrDeliCnf->bMsgStatVal);

    /* <oa>, */
    pStrWalk += zAt_EncTpAddrVal(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, iTpAddrType, &pTcmgrDeliCnf->tTpSrcAddr); 

    /* [<alpha>] */
    pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, pTcmgrDeliCnf->bNameFg, pTcmgrDeliCnf->tName.abTextVal);

    /* <scts> */
    pStrWalk += zAt_EncTime2Str(pStrWalk, pTcmgrDeliCnf->tTpSCTS);

    if (pTcmgrDeliCnf->bMsgHeadInd == Z_APMMIA_CSDH_SHOW)
    {
        /* ,<tooa>,<fo>,<pid>,<dcs>, */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d", iTpAddrType, iFoTmp, pTcmgrDeliCnf->bTpProtocolId, pTcmgrDeliCnf->bTpDataCodeScheme);
        
        // <sca>, <tosca>
        pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_SCA, &pTcmgrDeliCnf->tTpSCAddr);   
 
        pStrWalk += sprintf((char *)pStrWalk, ",%lu", pTcmgrDeliCnf->dwTextLength);
    }

    /* <CR><LF> */
    pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    /* <data> */
    if (pTcmgrDeliCnf->pTextBuffer != NULL)
    {
        bBcd2StrRet = zAt_EncSmsTextData(pStrWalk, pTcmgrDeliCnf->pTextBuffer, pTcmgrDeliCnf->dwTextLength,
            pTcmgrDeliCnf->bCharNum, pTcmgrDeliCnf->bTpDataCodeScheme, 
            pTcmgrDeliCnf->tTpFirstOctet.bTpudHeadInd, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);

        /* ͷıָ */
        zAti_RetUB((VOID **)&pTcmgrDeliCnf->pTextBuffer);
        if (!bBcd2StrRet)
        {
            return 0;
        }
    }
    pStrWalk += strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgrTsubReadCnf
*  ZPS_ApMmia_SmsTsubReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgrTsubReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ReadSm_Cnf *pTcmgrSubCnf = (T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iFoTmp = 0;
    UINT8 iTpAddrType = 0;
    PBYTE  pbPduPtr = pTcmgrSubCnf->pbMsg + (*pTcmgrSubCnf->pbMsg + 1);     // (*pTcmgrSubCnf->pbMsg + 1)һֽΪͷ
    T_zApMmia_TpFo *ptTpfo = (T_zApMmia_TpFo *)pbPduPtr;

    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_SubmitMsg tTxtMsg = {0};
    T_z_CallNum tCallNum = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    T_zApMmia_SmsVP tTpValidPeriod = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = (WORD)pTcmgrSubCnf->dwLen;
    tPduMsg.pbPduBuf = pTcmgrSubCnf->pbMsg;
    zAti_ReadoutSubPdu (&tPduMsg, &tTxtMsg, ptTpfo);
    
    if (tTxtMsg.bVpLen == 7)
    {
        zOss_Memcpy(tTpValidPeriod.abAbsTime, tTxtMsg.abVp, 7);
    }
    
    if (tTxtMsg.bVpLen == 1)
    {
        tTpValidPeriod.bRelTime = tTxtMsg.abVp[0];
    }
    
    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
    iFoTmp = zAt_GetTpFoToByte(&tTxtMsg.tTpFo);    
 
    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/

    iTpAddrType = zAt_GetAddrTypeToByte(&tTxtMsg.tTpda.tAddressType);

    /* +CMGR: <stat>,<da>,[<alpha>][,<toda>,<fo>,<pid>,<dcs>,[<vp>],<sca>,<tosca>,<length>]<CR><LF><data> */

    /* +CMGR: <stat>, */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pTcmgrSubCnf->bStatChgFlg);
    pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmgrSubCnf->bStatus );
    

    /* <da>, */
    pStrWalk += zAt_EncTpAddrVal(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, iTpAddrType, &tTxtMsg.tTpda); 
  
    /* [<alpha>] */
    pStrWalk += sprintf((char *)pStrWalk, ",\"");
    
    /*========================= кѯ(TXT) =================================*/
    zAti_ConvrtTpadr(&tCallNum, &(tTxtMsg.tTpda));   
    pStrWalk += zAt_EncNameStrByNum (pStrWalk, &tCallNum, g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    if (tAtData.bCsdhShow == Z_APMMIA_CSDH_SHOW)
    {
        /* ,<tooa>,<fo>,<pid>,<dcs>, */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,", iTpAddrType, iFoTmp, tTxtMsg.bPid, tTxtMsg.bDcs);

        /* [<vp>] */
        zAt_EncDate2StrByVpFormat(pStrWalk, tTpValidPeriod, tTxtMsg.tTpFo.bTpvpFormat);//ֵ3˴ӦòöԺķֵж
        
        pStrWalk += strlen((const char *)pStrWalk);
        // <sca>, <tosca>
        pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_SCA, &tTxtMsg.tSca);   
 
        // ,<length>  
        pStrWalk += sprintf((char *)pStrWalk, ",%u",  tTxtMsg.wTxtLen);
    }

    /* <CR><LF> */
    pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    /* <data> */
    if (tTxtMsg.pbTxtBuf != NULL)
    {
        if (!zAt_EncSmsTextData(pStrWalk, tTxtMsg.pbTxtBuf, tTxtMsg.wTxtLen,
            tTxtMsg.bCharNum, tTxtMsg.bDcs,  tTxtMsg.tTpFo.bTpudHeadInd, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp))
        {
            zAti_RetUB((VOID **)&tTxtMsg.pbTxtBuf);
            zAti_RetUB((VOID **)&pTcmgrSubCnf->pbMsg);
            return 0;
        }
        
        /* ͷıָ */
        zAti_RetUB((VOID **)&tTxtMsg.pbTxtBuf);
    }
    pStrWalk += strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    zAti_RetUB((VOID **)&pTcmgrSubCnf->pbMsg);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgrTstatReadCnf
*  ZPS_ApMmia_SmsTstatReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgrTstatReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ReadSm_Cnf *pTcmgrStatCnf = (T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    T_zApMmia_TZAndTime tTpSCTS = {0};
    T_zApMmia_TZAndTime tTpDischageTime = {0};
    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtStatMsg tTxtMsg = {0};
    UINT8 iFoTmp = 0;
    PBYTE pbPduPtr        = pTcmgrStatCnf->pbMsg;

    tPduMsg.bTpmr = 0xff; /* ȱʡ */
    tPduMsg.wPduLen = (WORD)(pTcmgrStatCnf->dwLen);
    /* 
      * ״̬洢SMУPBص״̬ЯSCA
      * zAti_ReadoutStatTpduTPDUҪƫ
      * SCAĳ
      */
    if (pTcmgrStatCnf->bMem == Z_APMMIA_CPMSMEM_SR)
    {
        tPduMsg.pbPduBuf = pTcmgrStatCnf->pbMsg;
    }
    
    pbPduPtr += (*pTcmgrStatCnf->pbMsg + 1);
    
    /* ΪCQNJ00194504޸ */
    if (Z_ATI_SMSTYPE_SR == zAti_SmsGetMsgType (((T_zApMmia_TpFo*)pbPduPtr)->bMsgTypeId, pTcmgrStatCnf->bStatus))
    {
        tPduMsg.pbPduBuf = pTcmgrStatCnf->pbMsg + (*pTcmgrStatCnf->pbMsg + 1);
    }
    
    zAti_ReadoutStatTpdu(&tPduMsg, &tTxtMsg);/*ͷϢ*/
    zAti_ArrayToScts(&tTpSCTS,tTxtMsg.abScts);
    zAti_ArrayToScts(&tTpDischageTime,tTxtMsg.abDisTime);

    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
     iFoTmp = zAt_GetTpFoToByte(&tTxtMsg.tTpFo);  

    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/

    /* +CMGR: <stat>,<fo>,<mr>,[<ra>],[<tora>],<scts>,<dt>,<st> */
    /* +CMGR: <stat>,<fo>,<mr>, */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pTcmgrStatCnf->bStatChgFlg);
    pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmgrStatCnf->bStatus );
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d", iFoTmp, tTxtMsg.bTpmr);

    pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, &tTxtMsg.tTpra); 

    /* ,<scts>,<dt>, */

    pStrWalk += zAt_EncTime2Str(pStrWalk, tTpSCTS);

    pStrWalk += zAt_EncTime2Str(pStrWalk, tTpDischageTime);

    /* <st> */
   sprintf((char *)pStrWalk, ",%d%s%s", tTxtMsg.bStatVal, g_zAt_CRLF, g_zAt_OK);

    zAti_RetUB((VOID **)&pTcmgrStatCnf->pbMsg);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgrTcomReadCnf
*  ZPS_ApMmia_SmsTcomReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGRӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgrTcomReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ReadSm_Cnf *pTcmgrComCnf = (T_zApMmia_ReadSm_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 iFoTmp = 0;
    UINT8 i = 0;

    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtCmdMsg tTxtMsg = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = (WORD)pTcmgrComCnf->dwLen;
    tPduMsg.pbPduBuf = pTcmgrComCnf->pbMsg;
    zAti_ReadoutCmdPdu (&tPduMsg, &tTxtMsg);
    
    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
     iFoTmp = zAt_GetTpFoToByte(&tTxtMsg.tTpfo);  

    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/

    /* +CMGR: <stat>,<fo>,<ct>[,<pid>,[<mn>],[<da>],[<toda>],<length><CR><LF><cdata>] */
    /* +CMGR: <stat>,<fo>,<ct> */
    pStrWalk += zAt_EncCmgrHead(pStrWalk, pTcmgrComCnf->bStatChgFlg);
    pStrWalk += zAt_EncSmsStatus(pStrWalk, pTcmgrComCnf->bStatus );
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,", iFoTmp, tTxtMsg.bCmdType);
    

    if (tAtData.bCsdhShow == Z_APMMIA_CSDH_SHOW)
    {
        /* ,<pid>,<mn>, */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d", tTxtMsg.bPid, tTxtMsg.bMn);

        // ,[<da>], [<tora>] 
        pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_NORM, &tTxtMsg.tTpda); 

        /* ,<length> */
        /* <CR><LF> */
       pStrWalk += sprintf((char *)pStrWalk, ",%u%s",  tTxtMsg.wTextLen, g_zAt_CRLF);

        /* <data> */
        if (tTxtMsg.pbTextBuf != NULL)
        {                
            for (i = 0; i < tTxtMsg.wTextLen; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", tTxtMsg.pbTextBuf[i]);
            }

            /* ͷıָ */
            zAti_RetUB((VOID **)&tTxtMsg.pbTextBuf);
        }
    }
    else
    {
        /* ͷıָ */
        zAti_RetUB((VOID **)&tTxtMsg.pbTextBuf);
    }
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    zAti_RetUB((VOID **)&pTcmgrComCnf->pbMsg);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgsPduCnf
*  ZPS_ApMmia_SmsPcmgsCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGSӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgsPduCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    T_zMmiaSms_MsgSend_Cnf *pPcmgsCnf = &ptUiccInfo->tMsgSendCnf;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    if (pPcmgsCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMGS: <mr>[,<ackpdu>] */
        if(pEncCmdInfo->cmdId == ZAT2_SMS_ZMGS)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZMGS: %d", g_zAt_CRLF, pPcmgsCnf->bTpMsgRef);
        }
        else
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+CMGS: %d", g_zAt_CRLF, pPcmgsCnf->bTpMsgRef);
        }

        if (pPcmgsCnf->bTpduLength > 0)
        {
            if (pPcmgsCnf->bTpduLength > Z_APMMIA_MAX_SMSTPDU_LEN)
            {
                return 0;//ѭȳ鳤
            }

            if (tAtData.bCsmsSvc == 1)
            {
                /* [,<ackpdu>] */
                pStrWalk += sprintf((char *)pStrWalk, ",");

                for (i = 0; i < pPcmgsCnf->bTpduLength; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pPcmgsCnf->abTPduBuffer[i]);
                }
            }
        }

        sprintf((char *)pStrWalk, "%s%s",  g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pPcmgsCnf->dwCause);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgsTextCnf
*  ZPS_ApMmia_SmsTcmgsCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGSӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgsTextCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    //T_zMmiaSms_MsgSend_Cnf *pTcmgsCnf = (T_zMmiaSms_MsgSend_Cnf*) pEncCmdInfo->pMsgBody;
    T_zMmiaSms_MsgSend_Cnf *pTcmgsCnf = &ptUiccInfo->tMsgSendCnf;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zApMmia_TZAndTime tTpScts = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (pTcmgsCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMGS: <mr>[,<scts>] */
        if(pEncCmdInfo->cmdId == ZAT2_SMS_ZMGS)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZMGS: %d", g_zAt_CRLF, pTcmgsCnf->bTpMsgRef);
            if (tAtData.bCsmsSvc == 1)
            {
                UINT8 i = 0;
                /* [,<ackpdu>] */
                pStrWalk += sprintf((char *)pStrWalk, ",");

                for (i = 0; i < pTcmgsCnf->bTpduLength; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pTcmgsCnf->abTPduBuffer[i]);
                }
            }
        }
        else
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+CMGS: %d", g_zAt_CRLF, pTcmgsCnf->bTpMsgRef);

            if (tAtData.bCsmsSvc == Z_APMMIA_CSMSSVC_SPECIAL)
            {
                /* [,<scts>] "yy/MM/dd,hh:mm:ss+zz"*/
                zAti_ArrayToScts(&(tTpScts),&pTcmgsCnf->abTPduBuffer[2]);
              
                pStrWalk += zAt_EncTime2Str(pStrWalk, tTpScts);
            }
        }

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pTcmgsCnf->dwCause);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmgwCnf
*  ZPS_ApMmia_SmsCmgwCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMGWӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmgwCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_SaveSm_Cnf *pCmgwCnf = (T_zApMmia_SaveSm_Cnf*) pEncCmdInfo->pMsgBody;

    if (pCmgwCnf->bResult == Z_APMMIA_OPERATION_SUCCESS)
    {
        /* +CMGW: <Index> */
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CMGW: %d%s%s", g_zAt_CRLF, pCmgwCnf->wIndex, g_zAt_CRLF, g_zAt_OK);
    }

    return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pCmgwCnf->dwReason);
}

/*************************************************************************
* ƣ zAt_PsEncSmsCmssPduCnf
*  ZPS_ApMmia_SmsPcmgsCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMSSӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmssPduCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    //T_zMmiaSms_MsgSend_Cnf *pPcmssCnf = (T_zMmiaSms_MsgSend_Cnf*) pEncCmdInfo->pMsgBody;
    T_zMmiaSms_MsgSend_Cnf *pPcmssCnf = &ptUiccInfo->tMsgSendCnf;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (pPcmssCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMSS: <mr>[,<ackpdu>] */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CMSS: %d", g_zAt_CRLF, pPcmssCnf->bTpMsgRef);

        if (pPcmssCnf->bTpduLength > 0)
        {
            if (pPcmssCnf->bTpduLength > Z_APMMIA_MAX_SMSTPDU_LEN)
            {
                return 0;//ѭȳ鳤
            }

            if (tAtData.bCsmsSvc == Z_APMMIA_CSMSSVC_SPECIAL)
            {
                /* [,<ackpdu>] */
                pStrWalk += sprintf((char *)pStrWalk, ",");

                for (i = 0; i < pPcmssCnf->bTpduLength; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pPcmssCnf->abTPduBuffer[i]);
                }
            }
        }

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pPcmssCnf->dwCause);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmssTextCnf
*  ZPS_ApMmia_SmsTcmssCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ 
**************************************************************************/
UINT16 zAt_PsEncSmsCmssTextCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_UiccInfo *ptUiccInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tUiccInfo;
    //T_zMmiaSms_MsgSend_Cnf *pTcmssCnf = (T_zMmiaSms_MsgSend_Cnf*) pEncCmdInfo->pMsgBody;
    T_zMmiaSms_MsgSend_Cnf *pTcmssCnf = &ptUiccInfo->tMsgSendCnf;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zApMmia_TZAndTime tTpScts = {0};
    
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (pTcmssCnf->bResult == Z_MMIASMS_RESULT_OK)
    {
        /* +CMSS: <mr>[,<scts>] */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CMSS: %d", g_zAt_CRLF, pTcmssCnf->bTpMsgRef);

        if (tAtData.bCsmsSvc == Z_APMMIA_CSMSSVC_SPECIAL)
        {
            /* [,<scts>] "yy/MM/dd,hh:mm:ss+zz"*/
            zAti_ArrayToScts(&(tTpScts),&pTcmssCnf->abTPduBuffer[2]);
            pStrWalk += zAt_EncTime2Str(pStrWalk, tTpScts);
        }

        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pTcmssCnf->dwCause);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmtPduInd
*  ZPS_ApMmia_SmsPcmtInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMTϱı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmtPduInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSms_DeliverRec_Ind *pCmtPduInd = (T_zMmiaSms_DeliverRec_Ind*) pEncCmdInfo->pMsgBody;
    T_z_CallNum tCallNum = {0};
    UINT8 i = 0;

    /* +CMT: [<alpha>],<length><CR><LF><pdu> */

    pStrWalk += sprintf((char *)pStrWalk, "%s+CMT: \"", g_zAt_CRLF);

    /*========================= кѯ(PDU) ================================*/
    zAti_GetTpadrFromPDU(&tCallNum, pCmtPduInd->abPduBuffer);

    pStrWalk += zAt_EncNameStrByNum (pStrWalk, &tCallNum, g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);
    pStrWalk += sprintf((char *)pStrWalk, "\",%d%s", ((pCmtPduInd->bPduLength-pCmtPduInd->abPduBuffer[0])-1), g_zAt_CRLF);

    /* <pdu> */
    /* ѭ = PDU+Ϣĵĺ볤(λ)+1(ַλλ) */
    for (i = 0; i < pCmtPduInd->bPduLength; i++, pStrWalk += 2)
    {
        sprintf((char *)pStrWalk, "%02X", pCmtPduInd->abPduBuffer[i]);
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsCmtTextInd
*  ZPS_ApMmia_SmsTcmtInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CMTϱı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCmtTextInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSms_DeliverRec_Ind *pTcmtInd = (T_zMmiaSms_DeliverRec_Ind*) pEncCmdInfo->pMsgBody;
    T_zApMmia_TZAndTime tTpSCTS = {0};
    T_zDev_AtMem_Mmia_PrivateMem tAtData        = {0};
    T_z_CallNum tCallNum = {0};
    T_zAti_PduMsg tPduMsg = {0};
    T_zAti_TxtDlvMsg tTxtDlvMsg = {0};

    UINT8 iFoTmp = 0;
    UINT8 iTpAddrType = 0;
    /* +CMT: <oa>,[<alpha>],<scts>[,<tooa>,<fo>,<pid>,<dcs>,<sca>,<tosca>,<length>]<CR><LF><data> */

    /*------------------------------ Format of 8-bit TpFirstOctet ---------------------------------*/
    /* ReplyPathInd UserDataHeadInd  StatusReportFeature  ValidPeriodFormat  MsgFeature  MsgTypeId */
    /*       7             6                  5                 4   3             2        1   0   */
    /*---------------------------------------------------------------------------------------------*/
    /*NV*/
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
 
    tPduMsg.bTpmr = 0xff;
    tPduMsg.wPduLen = pTcmtInd->bPduLength;
    tPduMsg.pbPduBuf = pTcmtInd->abPduBuffer;
    zAti_ReadoutDlvPdu(&tPduMsg, &tTxtDlvMsg);/*ͷϢ*/
    zAti_ArrayToScts(&(tTpSCTS),tTxtDlvMsg.abScts); /*ʱϢ*/
    iFoTmp = zAt_GetTpFoToByte(&tTxtDlvMsg.tTpFo);
    /*---------------- Construction of iaddrType ---------------*/
    /* iaddrType (8 bits):     7         6 5 4       3 2 1 0    */
    /* T_zApMmia_AddrType: iTopBit  iNumberType  iNumPlanId  */
    /*----------------------------------------------------------*/
    iTpAddrType = zAt_GetAddrTypeToByte(&tTxtDlvMsg.tTpoa.tAddressType); 
  
    /* <oa>, */
    pStrWalk += sprintf((char *)pStrWalk, "%s+CMT: ", g_zAt_CRLF);

    pStrWalk += zAt_EncTpAddrVal(0, pStrWalk, Z_ATI_ADDRTYPE_NORM,iTpAddrType, &tTxtDlvMsg.tTpoa);   

    pStrWalk += sprintf((char *)pStrWalk, ",\"");
    
    /*========================= кѯ(TXT) =================================*/
    zAti_ConvrtTpadr(&tCallNum, &(tTxtDlvMsg.tTpoa));
    /* [<alpha>] */
    pStrWalk += zAt_EncNameStrByNum (pStrWalk, &tCallNum, g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);
    pStrWalk += sprintf((char *)pStrWalk, "\"");
    /* <scts> */
    pStrWalk += zAt_EncTime2Str(pStrWalk, tTpSCTS);

    if (tAtData.bCsdhShow == Z_APMMIA_CSDH_SHOW)
    {
        /* ,<tooa>,<fo>,<pid>,<dcs> */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d", iTpAddrType, iFoTmp, tTxtDlvMsg.bPid, tTxtDlvMsg.bDcs);
        // , <sca>, <tosca>,
        pStrWalk += zAt_EncTpAddr(1, pStrWalk, Z_ATI_ADDRTYPE_SCA, &tTxtDlvMsg.tSca); 

        // <length> 
        pStrWalk += sprintf((char *)pStrWalk, ",%u", tTxtDlvMsg.wTxtLen);
    }

    /* <CR><LF> */
    pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    /* <data> */
    if (tTxtDlvMsg.pbTxtBuf != NULL)
    {
        /* ͷıָ */
        if (!zAt_EncSmsTextData(pStrWalk, tTxtDlvMsg.pbTxtBuf, tTxtDlvMsg.wTxtLen,
            tTxtDlvMsg.bCharNum, tTxtDlvMsg.bDcs, tTxtDlvMsg.tTpFo.bTpudHeadInd, 
            g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp))
        {
            zAti_RetUB((VOID**)&tTxtDlvMsg.pbTxtBuf);
            return 0;
        }
        zAti_RetUB((VOID**)&tTxtDlvMsg.pbTxtBuf);
    }    
    pStrWalk += strlen((const char *)pStrWalk);
    
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncSmsCpmsCnf
*  ZPS_ApMmia_SmsCpmsCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CPMSӦı뺯
**************************************************************************/
UINT16 zAt_PsEncSmsCpmsCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbPrefMsgSto_Cnf *pCpmsCnf = (T_zApMmia_PbPrefMsgSto_Cnf*) pEncCmdInfo->pMsgBody;
    if (pCpmsCnf->bResult == Z_APMMIA_OPERATION_FAILURE)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pCpmsCnf->dwReason);
    }

    if (pCpmsCnf->bCommandInd == Z_APMMIA_SMSCMDTYPE_SET)
    {
        /* +CPMS: <used1>,<total1>,<used2>,<total2>,<used3>,<total3> */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CPMS: %d,%d,%d,%d,%d,%d%s%s", g_zAt_CRLF,
                pCpmsCnf->wMem1Used, pCpmsCnf->wMem1Total,
                pCpmsCnf->wMem2Used, pCpmsCnf->wMem2Total,
                pCpmsCnf->wMem3Used, pCpmsCnf->wMem3Total, g_zAt_CRLF, g_zAt_OK);
    }
    else if (pCpmsCnf->bCommandInd == Z_APMMIA_SMSCMDTYPE_QUERY)
    {
        if(pCpmsCnf->bMem1 > Z_APMMIA_CPMSMEM_SR 
            || pCpmsCnf->bMem2 > Z_APMMIA_CPMSMEM_SR
            || pCpmsCnf->bMem3 > Z_APMMIA_CPMSMEM_SR)
        {
            return 0;
        }
        
        /* +CPMS: <mem1>,<used1>,<total1>,<mem2>,<used2>,<total2>,<mem3>,<used3>,<total3> */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CPMS: ", g_zAt_CRLF);

        /* <mem1> */
        pStrWalk += zAt_EncSmsMemType(pStrWalk, pCpmsCnf->bMem1);
        /* ,<used1>,<total1> */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,", pCpmsCnf->wMem1Used, pCpmsCnf->wMem1Total);

        /* <mem2> */
        pStrWalk += zAt_EncSmsMemType(pStrWalk, pCpmsCnf->bMem2);

        /* ,<used2>,<total2> */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,", pCpmsCnf->wMem2Used, pCpmsCnf->wMem2Total);

        /* <mem3> */
        pStrWalk += zAt_EncSmsMemType(pStrWalk, pCpmsCnf->bMem3);

        /* ,<used3>,<total3> */
        pStrWalk += sprintf((char *)pStrWalk, ",%d,%d%s%s", pCpmsCnf->wMem3Used, pCpmsCnf->wMem3Total,g_zAt_CRLF, g_zAt_OK);
    }

   return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmsZmgsfInd
*  ZPS_ApMmia_SmsSaveFailureInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ZMGSFϱ뺯
**************************************************************************/
UINT16 zAt_PsEncSmsZmgsfInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_SaveSm_Cnf *pZmgsInd = (T_zApMmia_SaveSm_Cnf*) pEncCmdInfo->pMsgBody;
    T_zDev_AtMem_SMS_CnmiCmd tAtData = {0};
    BYTE bMemType = 0;
    zDev_AtMemReadItem(Z_AtMem_ID_Cnmi, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    bMemType = (pZmgsInd->bMem == ZAT2_MEM_IS_ME)? 1:0;

    if (pZmgsInd->dwReason == Z_APMMIA_TPMEMCAPAEXCEED_ERR
           ||pZmgsInd->dwReason == Z_APMMIA_CMSMEMFULL_ERR)
    {
         return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZMGSF: %lu,%d%s", g_zAt_CRLF, pZmgsInd->dwReason, bMemType, g_zAt_CRLF);
    }
    else
    {
        return ZAT_ENC_NONEED_CNF;
    }
}

/**************************************************************************
* ƣ zAt_PsEncUiccCardModeCnf
*  ZPS_ApMmia_CardModeCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ^CARDMODEӦı뺯
**************************************************************************/
UINT16 __ps_2g_func zAt_PsEncUiccCardModeCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApUicc_CardMode_Cnf *pCardModeCnf = (T_zApUicc_CardMode_Cnf*) pEncCmdInfo->pMsgBody;

    /* ^CARDMODE: <sim_type> */
    if ((pCardModeCnf->bCardMode != Z_APUICC_CARDMODE_UICC) &&
        (pCardModeCnf->bCardMode != Z_APUICC_CARDMODE_SIM) &&
        (pCardModeCnf->bCardMode != Z_APUICC_CARDMOE_UNKNOWN))
    {
        return 0;
    }
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s^CARDMODE: %d%s%s", g_zAt_CRLF, pCardModeCnf->bCardMode, g_zAt_CRLF, g_zAt_OK);
}

/**************************************************************************
* ƣ zAt_PsEncUiccCpinZipinReadCnf
*  ZPS_ApMmia_CpinReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CPINӦı뺯
**************************************************************************/
UINT16 __ps_comm_func zAt_PsEncUiccCpinZipinReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_PinStatQurey_Cnf *pCpinCnf = (T_zApUicc_PinStatQurey_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CPIN: <code> */
    if(pCpinCnf->bChId == 0) //USIM/SIM
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+CPIN: ", g_zAt_CRLF);
    }
#ifdef NAS_ISIM_SUPPORT
    else //ISIM
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZIPIN: ", g_zAt_CRLF);
    }
#endif

    switch (pCpinCnf->bPinStatus)
    {
        case Z_APUICC_PIN_READY:
            {
                sprintf((char *)pStrWalk, "READY%s%s", g_zAt_CRLF, g_zAt_OK);
                break;
            }
        case Z_APUICC_PIN_SIMPIN:
            {
                sprintf((char *)pStrWalk, "SIM PIN%s%s", g_zAt_CRLF, g_zAt_OK);
                break;
            }
        case Z_APUICC_PIN_SIMPUK:
            {
                sprintf((char *)pStrWalk, "SIM PUK%s%s", g_zAt_CRLF, g_zAt_OK);
                break;
            }
        case Z_APUICC_PIN_SIMPIN2:
            {
                sprintf((char *)pStrWalk, "SIM PIN2%s%s", g_zAt_CRLF, g_zAt_OK);
                break;
            }
        case Z_APUICC_PIN_SIMPUK2:
            {
                sprintf((char *)pStrWalk, "SIM PUK2%s%s", g_zAt_CRLF, g_zAt_OK);
                break;
            }
        default:
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,TRACE_ERR_LEVEL_SEVERE,"");
                return 0;
            }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncUiccMbauCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{ 
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_MbAuth_Cnf *pMbauCnf = (T_zApMmia_MbAuth_Cnf*) pEncCmdInfo->pMsgBody;
    
    pStrWalk += sprintf((char *)pStrWalk, "%s^MBAU: %d", g_zAt_CRLF,pMbauCnf->bStatus);

    if(pMbauCnf->bUnionId == 0)
    {
        zAt_PsEncUiccMbauCnfUnion0(&pStrWalk, pMbauCnf);
    }
    else if(pMbauCnf->bUnionId == 1)
    {
        zAt_PsEncUiccMbauCnfUnion1(&pStrWalk, pMbauCnf);
    }
    else if(pMbauCnf->bUnionId == 2)
    {
        zAt_PsEncUiccMbauCnfUnion2(&pStrWalk, pMbauCnf);
    }
    zAt_PsEncUiccMbauCnfEnd(&pStrWalk, pMbauCnf);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt2_PsEncUiccZcardAtrInd
*  AP_MMIA_ATR_IND_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZCARDATRϱı뺯
**************************************************************************/
UINT16 __ps_2g_func zAt_PsEncUiccZcardAtrInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR atrData[ZAT2_MAX_CARDATR_STR_LEN] = {0};
    T_zApUicc_Atr_Ind *pZcardAtrInd = (T_zApUicc_Atr_Ind *)pEncCmdInfo->pMsgBody;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};

    if(pZcardAtrInd->bLength > Z_APUICC_ATR_MAXLEN)
    {
        pZcardAtrInd->bLength = Z_APUICC_ATR_MAXLEN;
    }

    g_zAti_atDataEx[g_zAti_CurInstance].tAtrInfo.bLength = pZcardAtrInd->bLength;
    zOss_Memcpy(g_zAti_atDataEx[g_zAti_CurInstance].tAtrInfo.abAtr, pZcardAtrInd->abAtr, Z_APUICC_ATR_MAXLEN);

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    if (Z_ATI_SetType_Enable == tAtData.bAtrIndSet)
    {
        zAt_DataIntoStr((UINT8 *)pZcardAtrInd->abAtr,pZcardAtrInd->bLength,atrData, ZAT2_MAX_CARDATR_STR_LEN);
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZCARDATR: \"%s\"%s",g_zAt_CRLF, atrData, g_zAt_CRLF);
    }
    return 0;
}

/**************************************************************************
* ƣ zAt2_PsEncUiccCsimCnf
*  AP_MMIA_CSIM_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CSIMӦı뺯
**************************************************************************/ 
UINT16  zAt_PsEncUiccCsimCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR *pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_Csim_Cnf *pCsimCnf=(T_zApUicc_Csim_Cnf *) pEncCmdInfo->pMsgBody;

    if(pEncCmdInfo->cmdId == ZAT2_UICC_ZSIM)
    {
        pStrWalk += sprintf((char *)pStrWalk,"%s+ZSIM: %lu,",g_zAt_CRLF, (pCsimCnf->dwLength * 2));
    }
    else
    {
        pStrWalk += sprintf((char *)pStrWalk,"%s+CSIM: %lu,",g_zAt_CRLF, (pCsimCnf->dwLength * 2));
    }

    if (pCsimCnf->dwLength &&
        zAt_EncArr2StrByCscsType(pStrWalk, pCsimCnf->abApdu, pCsimCnf->dwLength, ZAT2_CSCS_HEX))
    {
        pStrWalk += strlen((const char *)pStrWalk);
    }

    if (pCsimCnf->bSeqFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pCsimCnf->bSeq);
    }
    sprintf((char *)pStrWalk,"%s%s",g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt2_PsEncUiccCrsmCnf
*  ZPS_ApMmia_Crsm_Cnf_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CRSMӦı뺯
**************************************************************************/
UINT16  __ps_static_func zAt_PsEncUiccCrsmCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR *pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_Crsm_Cnf *pCrsmCnf=(T_zApUicc_Crsm_Cnf *) pEncCmdInfo->pMsgBody;

    pStrWalk += sprintf((char *)pStrWalk, "%s+CRSM: %d,%d", g_zAt_CRLF, pCrsmCnf->bSw1, pCrsmCnf->bSw2);

    if (pCrsmCnf->wRspLen)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
        if (zAt_EncArr2StrByCscsType(pStrWalk, pCrsmCnf->abRsp, (UINT32)pCrsmCnf->wRspLen, ZAT2_CSCS_HEX))
        {
            pStrWalk += strlen((const char *)pStrWalk);
        }
    }
    sprintf((char *)pStrWalk,"%s%s",g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt2_PsEncUsatZufchInd
*  ZPS_ApMmia_USAT_Fetch_Ind_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZUFCHѯӦ
**************************************************************************/
UINT16 zAt_PsEncUsatZufchInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_USAT_Fetch_Ind *pZufchInd = (T_zApUicc_USAT_Fetch_Ind *) pEncCmdInfo->pMsgBody;

    /* +ZUFCH<length>,<data> */           
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZUFCH: %lu", g_zAt_CRLF, (pZufchInd->dwLength * 2));

    if (pZufchInd->dwLength)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
        if (zAt_EncArr2StrByCscsType(pStrWalk, pZufchInd->abApdu, pZufchInd->dwLength, ZAT2_CSCS_HEX))
        {
            pStrWalk += strlen((const char *)pStrWalk);
        }
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);    
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
UINT16 zAt_PsEncUsatRefreshInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;

    sprintf((char *)pStrWalk, "%s+ZREFRESHIND%s", g_zAt_CRLF, g_zAt_CRLF);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt2_PsEncUiccCchoCnf
*  AP_MMIA_CCHO_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CCHOӦı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccCchoCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApUicc_Ccho_Cnf *pCchoCnf = (T_zApUicc_Ccho_Cnf *) pEncCmdInfo->pMsgBody;

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd,"%s%d%s%s",g_zAt_CRLF, pCchoCnf->bSessionID, g_zAt_CRLF,  g_zAt_OK);
}

UINT16 zAt_PsEncUiccCchcCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd,"%s+CCHC%s%s",g_zAt_CRLF, g_zAt_CRLF,  g_zAt_OK);
}

/**************************************************************************
* ƣ zAt2_PsEncUiccCglaCnf
*  AP_MMIA_CGLA_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CGLAӦı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccCglaCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR *pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_CGla_Cnf *pCglaCnf = (T_zApUicc_CGla_Cnf *) pEncCmdInfo->pMsgBody;

    pStrWalk += sprintf((char *)pStrWalk,"%s+CGLA: %lu,",g_zAt_CRLF, pCglaCnf->dwLength * 2);

    if (pCglaCnf->dwLength && zAt_EncArr2StrByCscsType(pStrWalk, pCglaCnf->abApdu, pCglaCnf->dwLength, ZAT2_CSCS_HEX))
    {
        pStrWalk += strlen((const char *)pStrWalk);
    }
    sprintf((char *)pStrWalk,"%s%s",g_zAt_CRLF,  g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncUiccZuinitCnf
*  ZPS_ApMmia_UiccInitCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZUINITӦı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccZuinitCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_Init_Cnf *pZuinitCnf = (T_zApUicc_Init_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;
    UINT8 bValidNum = 0;
    UINT8 abIccid[sizeof(pZuinitCnf->abIccId)*2] = {0};

    bValidNum = zAti_UpDateIccid(pZuinitCnf->abIccId, sizeof(pZuinitCnf->abIccId), abIccid);

    /* +ZUINIT: <uiccstate>,<appmode>,<iccid>[,[<phase>][,[<Li>][,<Pl>]]] */
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZUINIT: %lu,%d", g_zAt_CRLF, pZuinitCnf->dwUiccState, pZuinitCnf->bAppMode);

    /* <iccid> */
    pStrWalk +=sprintf((char *)pStrWalk, ",\"");
    /*ICCIDʾЭ涨λF,ʾ:
      βλFԶʾ,λFʾ,
      ICCIDΪȫFȫʾ*/
    if(bValidNum > 0)
    {
        for(i = 0; i < bValidNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%X", abIccid[i]);
        }
    }
    else //ȫF
    {
        for(i = 0; i < sizeof(abIccid); i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%X", abIccid[i]);
        }
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    /*ѡĿǰûʹ,ô˷ʽϱ
       <Li><Pl>FgЧΪ0xffnumΪ0Ŀ,ֱϱ*/
    /* <phase>*/
    if(pZuinitCnf->bPhase != 0xff)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%02X", pZuinitCnf->bPhase);
    }
    else if(pZuinitCnf->bLiFg == Z_APMMIA_VALID || pZuinitCnf->bPlFg == Z_APMMIA_VALID)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
    }

    if(pZuinitCnf->bLiFg == Z_APMMIA_VALID)
    {
        pStrWalk+=sprintf((char *)pStrWalk, ",\"");
        for(i = 0; i < pZuinitCnf->tLi.bNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%04X", pZuinitCnf->tLi.awLangCode[i]);
        }
        pStrWalk += sprintf((char *)pStrWalk, "\"");
    }
    else if(pZuinitCnf->bPlFg == Z_APMMIA_VALID)
    {
        pStrWalk+=sprintf((char *)pStrWalk, ",");
    }

    if(pZuinitCnf->bPlFg == Z_APMMIA_VALID)
    {
        pStrWalk+= sprintf((char *)pStrWalk, ",\"");
        for(i = 0; i < pZuinitCnf->tPl.bNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%04X", pZuinitCnf->tPl.awLangCode[i]);
        }
        pStrWalk += sprintf((char *)pStrWalk, "\"");
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#ifdef NAS_ISIM_SUPPORT
UINT16 zAt_PsEncUiccZisiminitInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_Zisiminit_Ind *pZisiminitInd = (T_zAti_Zisiminit_Ind*) pEncCmdInfo->pMsgBody;

    /*+ZISIMINIT: <Chid>,<result>*/
    return (UINT16)sprintf((char *)pStrWalk, "%s+ZISIMINIT: %d,%lu%s", g_zAt_CRLF, pZisiminitInd->bChID, pZisiminitInd->dwUiccState, g_zAt_CRLF);
}
#endif
/**************************************************************************
* ƣ zAt_PsEncUiccZrapZirapCnf
*  ZPS_ApMmia_PinRemainNumCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZRAPӦı뺯617001824117+ZRAP޸
**************************************************************************/
UINT16 zAt_PsEncUiccZrapZirapCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_PinRemainNum_Cnf *pZrapCnf = (T_zApUicc_PinRemainNum_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZRAP: <pin1remain>,<pin2remain>,<unblpin1remain>,<unblpin2remain> */

    if(pZrapCnf->bChId == 0)
    {
        pStrWalk += sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZRAP: ",g_zAt_CRLF);
    }
#ifdef NAS_ISIM_SUPPORT
    else
    {
        pStrWalk += sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZIRAP: ",g_zAt_CRLF);
    }
#endif
    sprintf((char *)pStrWalk, "%d,%d,%d,%d%s%s",pZrapCnf->bPin1Remain, 
        pZrapCnf->bPin2Remain, pZrapCnf->bUnblPin1Remain, pZrapCnf->bUnblPin2Remain,g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncUiccZustatInd
*  ZPS_ApMmia_UiccIntiInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZUSTATϱı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccZustatInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApUicc_Init_Ind *pZustatInd = (T_zApUicc_Init_Ind*) pEncCmdInfo->pMsgBody;

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZUSTAT: %d%s", g_zAt_CRLF, pZustatInd->bAppMode,g_zAt_CRLF);
}

/**************************************************************************
* ƣ zAt_PsEncUiccZurdyInd
*  ZPS_ApMmia_UiccOkInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZURDYϱı뺯
**************************************************************************/
UINT16 __ps_2g_func zAt_PsEncUiccZurdyInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApUicc_UiccOk_Ind *pZurdyCnf = (T_zApUicc_UiccOk_Ind*) pEncCmdInfo->pMsgBody;

    /* +ZURDY: <appmode>,<initresult> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZURDY: %d,%lu%s", g_zAt_CRLF, pZurdyCnf->bApplMode, pZurdyCnf->dwInitResult, g_zAt_CRLF);
}

/**************************************************************************
* ƣ zAt_PsEncUiccZuslotInd
*  ZPS_ApMmia_UiccSlotInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZUSLOTϱı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccZuslotInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApUicc_Card_Ind *pZuslotCnf = (T_zApUicc_Card_Ind*) pEncCmdInfo->pMsgBody;
    T_zDev_AtMem_Mmia_PrivateMem tAtDate = {0};
#ifdef Z_DUALCARD_ADAPT
    if(Z_VALID == zAti_IsDualPsDualUicc() && Z_APUICC_EVULSION_CARD == pZuslotCnf->bSlotState)
    {
        g_zAti_ptData->bNeedChgFg = zAti_GetChangeCfgFlg();
    }
#endif
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtDate, g_zAti_CurInstance);

    if(tAtDate.bZuslotSet == Z_ATI_SetType_Disable)
    {
        return ZAT_ENC_NONEED_CNF;
    }

    /* +ZUSLOT: <slot>,<slotstate> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZUSLOT: %d,%d%s", g_zAt_CRLF, pZuslotCnf->bSlot, pZuslotCnf->bSlotState, g_zAt_CRLF);
}

/**************************************************************************
* ƣ zAt_PsEncUiccZpbicInd
*  ZPS_ApMmia_ZpbicInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZPBICϱı뺯
**************************************************************************/
UINT16 __ps_2g_func zAt_PsEncUiccZpbicInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbInitCmplt_Ind *pZpbicInd = (T_zApMmia_PbInitCmplt_Ind*) pEncCmdInfo->pMsgBody;

    /* +ZPBIC<result>,<oper> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZPBIC: %d,%d%s", g_zAt_CRLF, pZpbicInd->bResult, pZpbicInd->bOprType ,g_zAt_CRLF);        
}

/**************************************************************************
* ƣ zAt_PsEncUiccZpbciInd
*  ZPS_ApMmia_ChgIndexInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZPBICϱı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccZpbciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbChgIndex_Ind *pZpbciInd = (T_zApMmia_PbChgIndex_Ind*) pEncCmdInfo->pMsgBody;
    /* +ZPBCI<mem>,<index> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZPBCI: \"%s\",%d%s", g_zAt_CRLF, ZAT_PB_STRAGE_TYPE[pZpbciInd->bStorage], pZpbciInd->wChgIndex ,g_zAt_CRLF);        
}

/**************************************************************************
* ƣ zAt_PsEncUiccCeidCnf
*  AP_UICC_READ_EID_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CEIDӦı뺯
**************************************************************************/
UINT16 zAt_PsEncUiccCeidCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR *pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_Read_Eid_Cnf *pCeidCnf = (T_zApUicc_Read_Eid_Cnf *) pEncCmdInfo->pMsgBody;

    pStrWalk += sprintf((char *)pStrWalk,"%s+CEID: ",g_zAt_CRLF);

    if (zAt_EncArr2StrByCscsType(pStrWalk, pCeidCnf->abEid, (UINT32)Z_APUICC_EID_LEN, ZAT2_CSCS_HEX))
    {
        pStrWalk += strlen((const char *)pStrWalk);
    }
    sprintf((char *)pStrWalk,"%s%s",g_zAt_CRLF,  g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ MMIA_SM_PDP_ACTIVATE_CNF_EV
*  ZPS_ApMmia_SmActDeactCnf_EvϢӦĽṹ
* ˵ (I):
*            pStrWalk:       ַָ
*            setCnfCmdBody:  Ҫݽṹ
*            (O):
*             
*   ֵ BOOL  ɹʧ
* ˵ Ϊ+CGACTĲӦ
*
(5)LXH ˫ջ޸ģ˫ջյ5051ԭӦϱ60056006
*   (2)LXH ųɹATIϱCME ERROR:101,ʵӦϱOK
**************************************************************************/
UINT16 __ps_4g_func zAt_PsEncSmCgactSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    DWORD dwReason = 100;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zDev_AtMem_SmCidData *ptSmData = ZOSS_NULL;
#ifdef Z_SELL_STAT_SUPPORT
    T_zAti_CIDInfo tCidinfo = {0};
#endif
    T_zMmiaSm_PdpAct_Cnf *pSmCgactCnf = (T_zMmiaSm_PdpAct_Cnf*) pEncCmdInfo->pMsgBody;

     /* +CGACT:  */
    if (pSmCgactCnf->bResult == Z_SUCC)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK);       
    }
    else
    {     
        ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
        for(i = 0; i < pSmCgactCnf->bCidNum; i ++)//#28ԭ6008
        {
            zOss_Memset(ptSmData, 0, sizeof(T_zDev_AtMem_SmCidData));
            zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, pSmCgactCnf->atResult[i].bCid ,(PBYTE)ptSmData, g_zAti_CurInstance);
            if (ptSmData->tPdpContext.bPdpType == Z_MMIASM_IPV4V6
                && pSmCgactCnf->atResult[i].dwReason == Z_MMIASM_PDP_ADDRESS_TYPE_UNKNOW)
            {
                dwReason= ZAT2_CMEE_UNKNOW_PDP_TYPE;
                break;
            }
            if(pSmCgactCnf->atResult[i].dwReason == Z_MMIASM_PDP_AUTH_FAIL)//Ȩʧ6007
            {
                dwReason= ZAT2_CMEE_APN_AUTH_FAIL;
                break;
            }
        }
        zAti_RetUB((VOID**)&ptSmData);
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, dwReason);
    }
#ifdef Z_SELL_STAT_SUPPORT
    for (i = 0; i < pSmCgactCnf->bCidNum; i ++)
    {
        if (Z_SUCC == zAti_GetCidinfoFromSm(&tCidinfo, pSmCgactCnf->atResult + i))
        {
            if(Z_VALID == zAti_IsDualPsDualUicc())
            {
                zAti_SellStat_PdpActCnfSendtoPdi(pSmCgactCnf->atResult[i].bCid, &tCidinfo, g_zAti_CurInstance);
            }
            else
            {
                zAti_SellStat_PdpActCnfSendtoPdi(pSmCgactCnf->atResult[i].bCid, &tCidinfo, Z_ATI_INSNO_1);
            }
        }
        else
        {
            if(Z_VALID == zAti_IsDualPsDualUicc())
            {
                zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tCIDInfo[pSmCgactCnf->atResult[i].bCid -1], 0, sizeof(T_zAti_CIDInfo));
            }
            else
            {
                zOss_Memset(&g_zAti_atDataEx[Z_ATI_INSNO_1].tCIDInfo[pSmCgactCnf->atResult[i].bCid -1], 0, sizeof(T_zAti_CIDInfo));
            }
        }
    }
#endif
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);

}


/**************************************************************************
* ƣ zAt_PsEncSmCgactDeactSetCnf
*  ZPS_ApMmia_SmActDeactCnf_EvϢӦĽṹ
* ˵ (I):
*            pStrWalk:       ַָ
*            setCnfCmdBody:  Ҫݽṹ
*            (O):
*             
*   ֵ BOOL  ɹʧ
* ˵ Ϊ+CGACTĲӦ
*
(5)LXH ˫ջ޸ģ˫ջյ5051ԭӦϱ60056006
*   (2)LXH ųɹATIϱCME ERROR:101,ʵӦϱOK
**************************************************************************/
UINT16 __ps_4g_func zAt_PsEncSmCgactDeactSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    T_zMmiaSm_PdpDeact_Cnf *pSmCgactCnf = (T_zMmiaSm_PdpDeact_Cnf*) pEncCmdInfo->pMsgBody;
    /* +CGACT:  */
    if (pSmCgactCnf->bResult == Z_SUCC)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);       
    }
    else
    {
        for(i = 0; i<pSmCgactCnf->bCidNum; i++)
        {
            if(Z_FAIL == pSmCgactCnf->atResult[i].bHandleResult)
            {
                return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pSmCgactCnf->atResult[i].dwReason);
            }

        }
        return 0;
    }
}

/**************************************************************************
* ƣ zAt_PsEncSmCgactQueryCnf
*  ZPS_ApMmia_SmQueryPdpStatusReq_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CGACTĲѯӦ
**************************************************************************/
UINT16 zAt_PsEncSmCgactQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_QueryPdpStatus_Cnf *pSmCgactQueryCnf = (T_zMmiaSm_QueryPdpStatus_Cnf*) pEncCmdInfo->pMsgBody;
   
    /* +CGACT: <cid>,<state>[<CR><LF>+CGACT:<cid>, <state>[...]] */

    /* Ч */
    if ((pSmCgactQueryCnf->bActCidNum > Z_APMMIA_SM_MAX_CID_NUM) || (pSmCgactQueryCnf->bInactCidNum > Z_APMMIA_SM_MAX_CID_NUM))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }

    if (pSmCgactQueryCnf->bActCidNum > 0)
    {
        for (i = 0; i < pSmCgactQueryCnf->bActCidNum; i++)
        { 
            pStrWalk += sprintf((char *)pStrWalk, "%s+CGACT: %d,1", g_zAt_CRLF, pSmCgactQueryCnf->abActCid[i]); 
        }
    }
    
    if (pSmCgactQueryCnf->bInactCidNum > 0)
    {
        for (i = 0; i < pSmCgactQueryCnf->bInactCidNum; i++)
        {
            /* ѭ<CR><LF>+CGACT: <cid>,<state> */
            pStrWalk += sprintf((char *)pStrWalk, "%s+CGACT: %d,0", g_zAt_CRLF, pSmCgactQueryCnf->abInactCid[i]);
        }
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmCgcmodCnf
*  ZPS_ApMmia_SmActDeactCnf_EvϢӦĽṹ
* ˵ (I):
*            pStrWalk:       ַָ
*            setCnfCmdBody:  Ҫݽṹ
*            (O):
*             
*   ֵ BOOL  ɹʧ
* ˵ Ϊ+CGCMODĲӦ
**************************************************************************/
UINT16 zAt_PsEncSmCgcmodCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    BYTE i = 0;
    T_zMmiaSm_PdpMod_Cnf *pSmCgcmodCnf = (T_zMmiaSm_PdpMod_Cnf*) pEncCmdInfo->pMsgBody;
    
    if ((pSmCgcmodCnf->bCidNum > Z_MMIASM_MAX_CID_NUM) ||
        ((pSmCgcmodCnf->bResult != Z_SUCC) && (pSmCgcmodCnf->bResult != Z_FAIL)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }

    /* +CGCMOD:  */
    /* 617002489746 ȷҪѭжϣԴֻҪжһ  --hyc-- */
    if (pSmCgcmodCnf->bResult == Z_SUCC)
    {       
        sprintf((char *)pStrWalk, "%s", g_zAt_OK);       
    }
    else
    {
        for (i = 0; i < pSmCgcmodCnf->bCidNum; i++)
        {
            if(pSmCgcmodCnf->atResult[i].bHandleResult == Z_FAIL)
            {
                return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pSmCgcmodCnf->atResult[i].dwReason);
            }            
        }        
    }    

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncSmQueryCnf
*  ZPS_ApMmia_SmQueryActCidCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CGCMOD,+CGPADDR,+CGEQNEG,+ZQNEGĲӦ
**************************************************************************/
UINT16 zAt_PsEncSmQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_QueryActCid_Cnf *pSmQueryCnf = (T_zMmiaSm_QueryActCid_Cnf*) pEncCmdInfo->pMsgBody;

    /* ѭȳ鳤 */
    if (pSmQueryCnf->bCidNum > Z_APMMIA_SM_MAX_CID_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }
    switch (pSmQueryCnf->bCmdType)
    {
        /******************** +CGCMOD ***********************/
    case Z_APMMIA_SM_CMD_CGCMOD:
        {
            /* +CGCMOD: (list of <cid>s associated with active contexts) */
            
            sprintf((char *)pStrWalk, "%s+CGCMOD: (", g_zAt_CRLF);          
        }
        break;
        
        /******************** +ZQNEG **********************/
    case Z_APMMIA_SM_CMD_ZQNEG:
        {
            /* +ZQNEG: (list of <cid>s associated with active contexts) */

            sprintf((char *)pStrWalk, "%s+ZQNEG: (", g_zAt_CRLF); 
        }
        break;
        
        /******************** +CGEQNEG **********************/
    case Z_APMMIA_SM_CMD_CGEQNEG:
        {
            /* +CGEQNEG: (list of <cid>s associated with active contexts) */
            
            sprintf((char *)pStrWalk, "%s+CGEQNEG: (", g_zAt_CRLF); 
        }
        break;

        /******************** +CGDSCONT **********************/
    case Z_APMMIA_SM_CMD_CGDSCONT:
        {
            /* +CGDSCONT: (list of <cid>s associated with active contexts) */
            sprintf((char *)pStrWalk, "%s+CGDSCONT: (1-%c),(", g_zAt_CRLF,0x30+ZATI2_SM_MAX_SMCID_NUM); 
        }
        break;        
        /******************** +CGTFTRDP **********************/
    case Z_APMMIA_SM_CMD_CGTFTRDP:
        {
            /* +CGTFTRDP: (list of <cid>s associated with active contexts) */            

            sprintf((char *)pStrWalk, "%s+CGTFTRDP: (", g_zAt_CRLF); 
        }
        break; 
        
    /******************** +CGCONTRDP **********************/
    case Z_APMMIA_SM_CMD_CGCONTRDP:
        {
            /* +CGCONTRDP: (list of <cid>s associated with active contexts) */            
    
            sprintf((char *)pStrWalk, "%s+CGCONTRDP: (", g_zAt_CRLF); 
        }
        break; 

    /******************** +CGSCONTRDP **********************/
    case Z_APMMIA_SM_CMD_CGSCONTRDP:
        {
            /* +CGSCONTRDP: (list of <cid>s associated with active contexts) */            
    
            sprintf((char *)pStrWalk, "%s+CGSCONTRDP: (", g_zAt_CRLF); 
        }
        break; 
    
    /******************** +CGEQOSRDP **********************/
    case Z_APMMIA_SM_CMD_CGEQOSRDP:
        {
            /* +CGEQOSRDP: (list of <cid>s associated with active contexts) */            
    
            sprintf((char *)pStrWalk, "%s+CGEQOSRDP: (", g_zAt_CRLF); 
        }
        break;     
    default:
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");    
            return 0;
        }
    }
    
    pStrWalk += strlen((const char *)pStrWalk);

    if (pSmQueryCnf->bCmdType == Z_APMMIA_SM_CMD_CGDSCONT)
    {
        T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
        for (i = 0; i < pSmQueryCnf->bCidNum; i++)
        {
            zOss_Memset(ptSmData, 0, sizeof(T_zDev_AtMem_SmCidData));
            zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, pSmQueryCnf->abCid[i],(PBYTE)ptSmData, g_zAti_CurInstance);
            
            if (ptSmData->bContFlag == Z_ATI_CONTXT_First)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d,", pSmQueryCnf->abCid[i]);
            }
        }
        zAti_RetUB((VOID**)&ptSmData);
    }
    else
    {
        for (i = 0; i < pSmQueryCnf->bCidNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d,", pSmQueryCnf->abCid[i]);            
        }
    }
    
    if(pSmQueryCnf->bCidNum > 0)
    {
        pStrWalk--; /* ѭҪһλ','ȥ  */
    }

    pStrWalk += sprintf((char *)pStrWalk, ")");    

    if (pSmQueryCnf->bCmdType == Z_APMMIA_SM_CMD_CGDSCONT)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",(0-3),(0-4)");
        #ifdef R9_SUPPORT
        pStrWalk += sprintf((char *)pStrWalk, ",(0,1)");
        #endif
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmPdpAddrCnf
*  ZPS_ApMmia_SmQueryPdpAddrCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CGPADDRӦ617001861425ATIR8꿪ô
**************************************************************************/
UINT16 zAt_PsEncSmPdpAddrCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    BYTE bExCid = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_QueryPdpAddr_Cnf *pSmPdpAddrCnf = (T_zMmiaSm_QueryPdpAddr_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CGPADDR: <cid>,<PDP_addr>[<CR><LF>+CGPADDR: <cid>,<PDP_addr>[...]] */

    /* Ч */
    if (pSmPdpAddrCnf->bCidNum > Z_APMMIA_SM_MAX_CID_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                       
        return 0;
    }

    /* +CGPADDR: <cid>,<PDP_addr1>,<PDP_addr2>[<CR><LF>+CGPADDR: <cid>,<PDP_addr1>,<PDP_addr2>[...]] */
    for (i = 0; i < pSmPdpAddrCnf->bCidNum; i++)
    {
        if (Z_FAIL == zAti_CheckPdpType(pSmPdpAddrCnf->atPdpAddr[i].tPdpAddr.bPdpType))
        {
            /*617001624283AT+CGPADDR=ѯӦصǰĵĵַǷصError*/
            pStrWalk += sprintf((char *)pStrWalk, "%s+CGPADDR: %d", g_zAt_CRLF, pSmPdpAddrCnf->atPdpAddr[i].bCid);
            continue;
        }
        /*Ҫƴ*/
        if(zAti_IsMastCid(pSmPdpAddrCnf->atPdpAddr[i].bCid,&bExCid) && bExCid != 0)/*Ҫƴ*/
        {
            if(!zAt_PsEncCgpaddrCnf2(pSmPdpAddrCnf->atPdpAddr[i].bCid, bExCid, &pStrWalk))
            {
                pStrWalk += sprintf((char *)pStrWalk, "%s+CGPADDR: %d", g_zAt_CRLF, pSmPdpAddrCnf->atPdpAddr[i].bCid);
            }
        }
        else /*Ҫƴ*/
        {
            zAt_PsEncCgpaddrCnf1(&pSmPdpAddrCnf->atPdpAddr[i], &pStrWalk);
        }
        
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/*********************************************************************
* ƣ zAt_PsEncSmAnsReqCnf
*  öӦATCGANSӦ
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
********************************************************************/
UINT16 zAt_PsEncSmAnsReqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    T_zMmiaSm_MtActAns_Cnf* pAnsCnf = (T_zMmiaSm_MtActAns_Cnf*)pEncCmdInfo->pMsgBody;

    if(pAnsCnf->bResult == Z_SUCC)
    {
       return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);   
    }
    else
    {
        for(i = 0; i<pAnsCnf->bCidNum; i++)
        {
            if(pAnsCnf->atResult[i].bHandleResult == Z_FAIL)
            {
                return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pAnsCnf->atResult[i].dwReason);
            }
        }
        return 0;

    }
}
/**************************************************************************
* ƣ zAt_PsEncSmCgeqnegCnf
*  ZPS_ApMmia_SmQueryNegEQosCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CGEQNEGӦ
**************************************************************************/
UINT16 zAt_PsEncSmCgeqnegCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_QueryNegEQos_Cnf *pSmCgeqnegCnf = (T_zMmiaSm_QueryNegEQos_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CGEQNEG: <cid>,<Traffic class>,<Maximum bitrate UL>,<Maximum bitrate DL>,
       <Guaranteed bitrate UL>,<Guaranteed bitrate DL>,<Delivery order>,<Maximum SDU size>,
       <SDU error ratio>,<Residual bit error ratio>,<Delivery of erroneous SDUs>,
       <Transfer delay>,<Traffic handling priority>
       [...] */

    /* Ч */
    if (pSmCgeqnegCnf->bCidNum > Z_APMMIA_SM_MAX_CID_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }

    if (pSmCgeqnegCnf->bCidNum > 0)
    {
        for (i = 0; i < pSmCgeqnegCnf->bCidNum; i++)
        {
            /* ѭ<CR><LF>+CGEQNEG: <cid>,<Traffic class>,<Maximum bitrate UL>,<Maximum bitrate DL>,
               <Guaranteed bitrate UL>,<Guaranteed bitrate DL>,<Delivery order>,<Maximum SDU size>,
               <SDU error ratio>,<Residual bit error ratio>,<Delivery of erroneous SDUs>,
               <Transfer delay>,<Traffic handling priority> */
            pStrWalk += sprintf((char *)pStrWalk, "%s+CGEQNEG: %d,%d,%lu,%lu,%lu,%lu,%d,%d,\"%dE%d\",\"%dE%d\",%d,%d,%d", 
                g_zAt_CRLF,
                pSmCgeqnegCnf->atNegEQos[i].bCid,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.bTraffClass,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.dwMaxRateUl,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.dwMaxRateDl,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.dwGuarRateUl,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.dwGuarRateDl, 
                pSmCgeqnegCnf->atNegEQos[i].tEQos.bDlvOrder,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.wMaxSduSize,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.abSduErrRatio[0],
                pSmCgeqnegCnf->atNegEQos[i].tEQos.abSduErrRatio[1],
                pSmCgeqnegCnf->atNegEQos[i].tEQos.abResBer[0],
                pSmCgeqnegCnf->atNegEQos[i].tEQos.abResBer[1],
                pSmCgeqnegCnf->atNegEQos[i].tEQos.bDlvErrSdu,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.wTransDelay,
                pSmCgeqnegCnf->atNegEQos[i].tEQos.bTraffPri);
        }

        pStrWalk += sprintf((char *)pStrWalk, "%s",g_zAt_CRLF);
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmZqnegQosCnf
*  ZPS_ApMmia_SmQueryNegQosCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZQNEGӦ
**************************************************************************/
UINT16 zAt_PsEncSmZqnegQosCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_QueryNegQos_Cnf *pSmZqnegQosCnf = (T_zMmiaSm_QueryNegQos_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZQNEG: <cid>,<precedence>,<delay>,<reliability>,<peak>,<mean>[...] */

    /* Ч */
    if (pSmZqnegQosCnf->bCidNum > Z_APMMIA_SM_MAX_CID_NUM)
    {
        return 0;
    }

    if (pSmZqnegQosCnf->bCidNum > 0)
    {
        for (i = 0; i < pSmZqnegQosCnf->bCidNum; i++)
        {
       /*//--ȷϣ˵ɾ
            if(pSmZqnegQosCnf->atNegQos[i].bCid > ZATI2_SM_MAX_SMCID_NUM)
            {
                continue;//θCID Ϣ
            }*/
            /* ѭ<CR><LF>+ZQNEG: <cid>,<precedence>,<delay>,<reliability>,<peak>,<mean> */
          pStrWalk += sprintf((char *)pStrWalk, "%s+ZQNEG: %d,%d,%d,%d,%d,%d", 
                g_zAt_CRLF,
                pSmZqnegQosCnf->atNegQos[i].bCid,
                pSmZqnegQosCnf->atNegQos[i].tQoS.bPrecedence,
                pSmZqnegQosCnf->atNegQos[i].tQoS.bDelay,
                pSmZqnegQosCnf->atNegQos[i].tQoS.bReliability,
                pSmZqnegQosCnf->atNegQos[i].tQoS.bPeak,
                pSmZqnegQosCnf->atNegQos[i].tQoS.bMean);
        }

        pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSmNoCarrierCnf
*  ZPS_ApMmia_SmModemMoCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ӦNO CARRIERӦ
**************************************************************************/
UINT16 zAt_PsEncSmNoCarrierCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sNO CARRIER%s",g_zAt_CRLF, g_zAt_CRLF);
}

/**************************************************************************
* ƣ ZPS_ApMmia_SmConnectInd_Ev
*  ZPS_ApMmia_SmModemAnsCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ӦCONNECTӦ
**************************************************************************/
UINT16 zAt_PsEncSmConnInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    if(g_zAti_atDataEx[g_zAti_CurInstance].bMmMode == Z_APMMIA_GSMGPRS)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sCONNECT 236800%s", g_zAt_CRLF, g_zAt_CRLF);//236800
    }
    else if(g_zAti_atDataEx[g_zAti_CurInstance].bMmMode == Z_APMMIA_TDSCDMA)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sCONNECT 2936012%s", g_zAt_CRLF, g_zAt_CRLF);//2936012
    }
    /*
    else if(g_zAt_MmMode[g_zAti_CurInstance] == Z_APMMIA_LTE)
    {
        //ĿǰLTE ʽµϲ㲢ûȷǶ٣ݲʾ
    }*/
    else
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sCONNECT%s", g_zAt_CRLF, g_zAt_CRLF);
    }
}

/**************************************************************************
* ƣ zAt_PsEncSmZgdatatestCnf
*  ZPS_ApMmia_SmCauseCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ӦZGDATATESTӦ
**************************************************************************/
UINT16 zAt_PsEncSmZgdatatestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_ZAti_ZgdataTestSetCnf *pSmZgdatatestCnf = (T_ZAti_ZgdataTestSetCnf*) pEncCmdInfo->pMsgBody;

    /* +ZGDATATEST: <bResult> (including two reasons) */
    if (pSmZgdatatestCnf->bResult == TRUE)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);
    }
    else
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
    }
}

/**************************************************************************
* ƣ zAt_PsEncSmMtActivateInd
*  ZPS_ApMmia_SmMtActivateInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CRING֪ͨ
**************************************************************************/
UINT16 zAt_PsEncSmMtActivateInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    /*T_zMmiaSm_PdpAct_Ind*/
    T_zMmiaSm_PdpAct_Ind *pSmMtActInd = (T_zMmiaSm_PdpAct_Ind*) pEncCmdInfo->pMsgBody;
    UINT8 iPdpAddrSect = 0;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem  tAtData = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    
    /***617001561272 mt pdpָʾӦøcrcringcringϱ***/
    if (Z_APMMIA_CRC_ENABLE == tAtData.bCrcSet)
    {    
        /* +CRING: GPRS <PDP_type>,<PDP_addr>[,[<L2P>][,<APN>]] */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CRING: GPRS ", g_zAt_CRLF);
    
        if (Z_FAIL == zAti_CheckPdpType(pSmMtActInd->tPdpAddr.bPdpType))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,TRACE_ERR_LEVEL_SEVERE,"");
            return 0;
        }
        /* ,<PDP_type> */
        /* PDP_type¼IPַ: PPP--0, IPV4--4, IPV6--16 */
        if (pSmMtActInd->tPdpAddr.bPdpType == Z_APMMIA_SM_PPP)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"PPP\",\"");
            iPdpAddrSect = 0;
        }
        else if (pSmMtActInd->tPdpAddr.bPdpType == Z_APMMIA_SM_IPV4)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IP\",\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV4_ADDR_MAX_LEN;
        }
        else if (pSmMtActInd->tPdpAddr.bPdpType == Z_APMMIA_SM_IPV6)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IPV6\",\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;
        }
#ifdef R8_SUPPORT
        else if (pSmMtActInd->tPdpAddr.bPdpType == Z_APMMIA_SM_IPV4V6)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IPV4V6\",\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV4V6_ADDR_MAX_LEN;
    
            for (i = 0; i < Z_APMMIA_SM_IPV4_ADDR_MAX_LEN; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d.", pSmMtActInd->tPdpAddr.abIPv4Addr[i]);
            }
            /*617001605981 zAt_EncUsatPdpActParampdp©ipv4v6*/
            for (i = 0; i < Z_APMMIA_SM_IPV6_ADDR_MAX_LEN; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d.", pSmMtActInd->tPdpAddr.abIPv6Addr[i]);
            }
        }
#endif  
        else
        {
            return 0;
        }
    
        /* ,<PDP_addr> */
        if(iPdpAddrSect == Z_APMMIA_SM_IPV4_ADDR_MAX_LEN)
        {
            for (i = 0; i < iPdpAddrSect; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d.", pSmMtActInd->tPdpAddr.abIPv4Addr[i]);
            }
        }
        else if(iPdpAddrSect == Z_APMMIA_SM_IPV6_ADDR_MAX_LEN)
        {
            for (i = 0; i < iPdpAddrSect; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d.", pSmMtActInd->tPdpAddr.abIPv6Addr[i]);
            }
        }
        if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
        {
            pStrWalk--;
        }
    
        pStrWalk += sprintf((char *)pStrWalk, "\"");
    
        /* [,[<L2P>][,<APN>]] */
        switch ( g_zAti_atDataEx[g_zAti_CurInstance].bSmbL2P)
        {
        case ZAT2_L2P_MANUSPEC:
            {
                /* undifined */
                sprintf((char *)pStrWalk, ",\"\"");
            }
            break;
        case ZAT2_L2P_PPP:
            {
                sprintf((char *)pStrWalk, ",\"PPP\"");
            }
            break;
        default:
            {
                return 0;
            }
        }
        pStrWalk += strlen((const char *)pStrWalk);
    
        if (strlen((const char *)pSmMtActInd->abApn) > 0)
        {
            /* [,<APN>] */
            pStrWalk += sprintf((char *)pStrWalk, ",\"%s\"", pSmMtActInd->abApn);
        }
        
        sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
    }
    else if (Z_APMMIA_CRC_DISABLE == tAtData.bCrcSet)
    {
        sprintf((char *)pStrWalk, "%sRING%s",  g_zAt_CRLF, g_zAt_CRLF);
    }
    else
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}



/**************************************************************************
* ƣ zAt_PsEncSmZgipdnsInd
*  EV_ZATI2_SM_ZGIPDNS_INDϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZGIPDNS֪ͨ
**************************************************************************/
UINT16 __ps_4g_func zAt_PsEncSmZgipdnsInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_ZAti_SmZgipdnsInd *pZgipdnsInd = (T_ZAti_SmZgipdnsInd*) pEncCmdInfo->pMsgBody;
    UINT8 iPdpAddrSect = 0;
    UINT8 i = 0;
    UINT8 j = 0;

    /*
      +ZGIPDNS: <cid_num>,<cid1>,<PDP_type>,<PDP_address>,<gateway>,<primary_dns>,<secondary_dns>
      [,<cid2>,<PDP_type>,<PDP_address>,<gateway>,<primary_dns>,<secondary_dns>
      [...]]
    */

    if (pZgipdnsInd->iCidNum > ZATI2_SM_MAX_SMCID_NUM)
    {
        return 0;
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZGIPDNS: %d", g_zAt_CRLF, pZgipdnsInd->iCidNum);

    for (; i < pZgipdnsInd->iCidNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d,", pZgipdnsInd->smIpDnsInfo[i].iCid);

        /* ,<PDP_type> */
        /* PDP_type¼IPַ: PPP--0, IPV4--4, IPV6--16 */
        if (pZgipdnsInd->smIpDnsInfo[i].iPdpType == Z_APMMIA_SM_IPV4)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IP\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV4_ADDR_MAX_LEN;
        }
        else if (pZgipdnsInd->smIpDnsInfo[i].iPdpType == Z_APMMIA_SM_IPV6)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IPV6\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;
        }
#ifdef R8_SUPPORT
        else if (pZgipdnsInd->smIpDnsInfo[i].iPdpType == Z_APMMIA_SM_IPV4V6)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"IPV4V6\"");
            iPdpAddrSect = Z_APMMIA_SM_IPV4V6_ADDR_MAX_LEN;
        }
#endif  

        else
        {
            return 0;
        }

        /* ,<PDP_address>, */
        pStrWalk += sprintf((char *)pStrWalk, ",\"");

        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", pZgipdnsInd->smIpDnsInfo[i].iPdpAddr[j]);
        }
        if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
        {
            pStrWalk--;
        }

        pStrWalk += sprintf((char *)pStrWalk, "\",\"");

        /* ,<gateway>, */
        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", pZgipdnsInd->smIpDnsInfo[i].iGateWay[j]);
        }
        if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
        {
            pStrWalk--;
        }

        pStrWalk += sprintf((char *)pStrWalk, "\",\"");

        /* ,<primary_dns>, */
        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", pZgipdnsInd->smIpDnsInfo[i].iPrimaryDns[j]);
        }
        if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
        {
            pStrWalk--;
        }

        pStrWalk += sprintf((char *)pStrWalk, "\",\"");

        /* ,<secondary_dns>, */
        for (j = 0; j < iPdpAddrSect; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d.", pZgipdnsInd->smIpDnsInfo[i].iSecondaryDns[j]);
        }
        if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
        {
            pStrWalk--;
        }

        pStrWalk += sprintf((char *)pStrWalk, "\"");
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#ifdef USE_VOICE_SUPPORT
/**************************************************************************
* ƣ zAt_PsEncSsCcfcStatusCnf
*  ZPS_ApMmia_CcfcStatusCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CCFC=2ѯӦ617001855004ATIרԡз
**************************************************************************/
UINT16 zAt_PsEncSsCcfcStatusCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSs_CcfcQer_Cnf *pCcfcQueryCnf = (T_zMmiaSs_CcfcQer_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +CCFC: <status>,<class1>[,<number>,<type>[,<subaddr>,<satype>[,<time>]]]
       [<CR><LF>+CCFC: <status>,<class2>[,<number>,<type>[,<subaddr>,<satype>[,<time>]]]
       [...]]
    */

    /* ҪZAT2_LONG_CMD_LEN * 2ȿռ */
    //zOss_RetUB(pEncCmdInfo->pStrCmd);
    //pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 2);
    //pStrWalk = pEncCmdInfo->pStrCmd;

    if (pCcfcQueryCnf->bFwdFeatNum > 8)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }
    if (pCcfcQueryCnf->bFwdFeatNum > 0)
    {
        for (i = 0; i < pCcfcQueryCnf->bFwdFeatNum; i++)
        {
            /* ѭ<CR><LF>+CCFC: <status>,<classi>[,<number>,<type>[,<subaddr>,<satype>[,<time>]]] */
    
            /* <CR><LF>+CCFC: <status>,<class1> */
            
            pStrWalk += sprintf((char *)pStrWalk, "%s+CCFC: %d", g_zAt_CRLF, pCcfcQueryCnf->atFwdFeat[i].bStatus);
            
            if (pCcfcQueryCnf->atFwdFeat[i].bClassFg == Z_APMMIA_VALID)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d", pCcfcQueryCnf->atFwdFeat[i].bClass);              
            }
            else
            {
                pStrWalk += sprintf((char *)pStrWalk, ",7");
            }            
            
            /* [,<number>,<type>[,<subaddr>,<satype>[,<time>]]] */
            if (pCcfcQueryCnf->atFwdFeat[i].tFwdNum.bNumLen > 0)
            {
                /* <number>,<type>, */
                pStrWalk += sprintf((char *)pStrWalk, ",");
                pStrWalk += zAt_EncSmsAddrType(pStrWalk, pCcfcQueryCnf->atFwdFeat[i].tFwdNum.bNumType);  
    
                if (pCcfcQueryCnf->atFwdFeat[i].tFwdNum.bNumLen > Z_APMMIA_MAX_CALL_NUM_LEN)
                {
                    return 0;
                }
    
                /* print the BCD number */
                zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)pCcfcQueryCnf->atFwdFeat[i].tFwdNum.abNum, 
                        (UINT8)pCcfcQueryCnf->atFwdFeat[i].tFwdNum.bNumLen, ZAT2_CSCS_GSM);
                pStrWalk += strlen((const char *)pStrWalk);
    
                pStrWalk += sprintf((char *)pStrWalk, "\",%d", pCcfcQueryCnf->atFwdFeat[i].tFwdNum.bNumType);
            }
            else
            {
                if (pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bSubAddrLen > 0 || pCcfcQueryCnf->atFwdFeat[i].bTimeFg == Z_APMMIA_VALID)
                {
                    pStrWalk += sprintf((char *)pStrWalk, ",\"\",");
                }
            }
    
            /* [,<subaddr>,<satype>[,<time>]] */
            if (pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bSubAddrLen > 0)
            {
                /* ,<subaddr>,<satype> */
              
                pStrWalk += sprintf((char *)pStrWalk, ",");
                pStrWalk += zAt_EncSmsAddrType(pStrWalk, pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bTypeSubAddr );  
    
                if (pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bSubAddrLen > Z_APMMIA_MAX_SSSUBADDR_LEN)
                {
                    return 0;
                }
    
                // print the BCD number  
                zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)pCcfcQueryCnf->atFwdFeat[i].tSubAddr.abSubAddr, 
                            (UINT8)pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bSubAddrLen, ZAT2_CSCS_GSM);
                pStrWalk += strlen((const char *)pStrWalk);
    
                pStrWalk += sprintf((char *)pStrWalk, "\",%d", pCcfcQueryCnf->atFwdFeat[i].tSubAddr.bTypeSubAddr);
            }
            else
            {
                if (pCcfcQueryCnf->atFwdFeat[i].bTimeFg == Z_APMMIA_VALID)
                {
                    pStrWalk += sprintf((char *)pStrWalk, ",\"\",");
                }
            }
    
            /* [,<time>] */
            if (pCcfcQueryCnf->atFwdFeat[i].bTimeFg == Z_APMMIA_VALID)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d", pCcfcQueryCnf->atFwdFeat[i].bTime);
            }
        }  
    }
    else if (pCcfcQueryCnf->bFwdFeatNum== 0)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+CCFC: 0,7", g_zAt_CRLF);
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSsCcwaStatusCnf
*  ZPS_ApMmia_CcwaStatusCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CCWA=2ѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsCcwaStatusCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSs_CcwaQer_Cnf *pCcwaStatusCnf = (T_zMmiaSs_CcwaQer_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +CCWA: <status>,<class1>[<CR><LF>+CCWA: <status>,<class2>[...]] */
    if (pCcwaStatusCnf->bClassNum > 8)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return 0;
    }
    if (pCcwaStatusCnf->bClassNum > 0)
    {
        for (i = 0; i < pCcwaStatusCnf->bClassNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+CCWA: %d", g_zAt_CRLF, pCcwaStatusCnf->atClass[i].bStatus);
            
            if (pCcwaStatusCnf->atClass[i].bClassFg == Z_APMMIA_VALID)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d", pCcwaStatusCnf->atClass[i].bClass);              
            }
            else
            {
                pStrWalk += sprintf((char *)pStrWalk, ",7");
            }            
        }
        
        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else if (pCcwaStatusCnf->bClassNum == 0)
    {
        sprintf((char *)pStrWalk, "%s+CCWA: 0,7%s%s", g_zAt_CRLF, g_zAt_CRLF, g_zAt_OK);
    }
    
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
/**************************************************************************
* ƣ zAt_PsEncSsClckStatusCnf
*  ZPS_ApMmia_ClckStatusCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CLCK=2ѯӦ
**************************************************************************/
UINT16 zAt_PsEncPinClckStatusCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApUicc_PinEnableQuery_Cnf *pClckStatusCnf = (T_zApUicc_PinEnableQuery_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CLCK: <status>[,<class1>[<CR><LF>+CLCK: <status>,<class2>[...]] */
    if ((pClckStatusCnf->bPin1Status != Z_APUICC_PIN_NOTACTIVE)&&
         (pClckStatusCnf->bPin1Status != Z_APUICC_PIN_ACTIVE))
    {
        return 0;
    }
    
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CLCK: %d%s%s", g_zAt_CRLF, pClckStatusCnf->bPin1Status,g_zAt_CRLF, g_zAt_OK);
}
UINT16 zAt_PsEncPbClckStatusCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbClckStatus_Cnf *pClckStatusCnf = (T_zApMmia_PbClckStatus_Cnf*) pEncCmdInfo->pMsgBody;

    if (pClckStatusCnf->bClassNum > 0)
    {
        if (pClckStatusCnf->bClassNum > Z_ATISS_CLCKSTATUS_MAXNUM)
        {
            return 0;
        }
        for (i = 0; i < pClckStatusCnf->bClassNum; i++)
        {
            /* +CLCK: <status> */
            pStrWalk += sprintf((char *)pStrWalk, "%s+CLCK: %d",  g_zAt_CRLF, pClckStatusCnf->atClass[i].bStatus);
            
            /* ,<class1> */
            if (pClckStatusCnf->atClass[i].bClassFg == Z_APMMIA_VALID)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d", pClckStatusCnf->atClass[i].bClass);
            }
        }
        
        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else if (pClckStatusCnf->bClassNum == 0)
    {
        sprintf((char *)pStrWalk, "%s+CLCK: 0%s%s", g_zAt_CRLF, g_zAt_CRLF, g_zAt_OK);
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#ifdef USE_VOICE_SUPPORT
UINT16 zAt_PsEncSsClckStatusCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    UINT8 i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSs_CissQer_Cnf *ptSsClckQueryCnf = (T_zMmiaSs_CissQer_Cnf*) pEncCmdInfo->pMsgBody;

    if (ptSsClckQueryCnf->bClassNum > 0)
    {
        if (ptSsClckQueryCnf->bClassNum > Z_ATISS_CLCKSTATUS_MAXNUM)
        {
            return 0;
        }
        for (i = 0; i < ptSsClckQueryCnf->bClassNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+CLCK: %d",  g_zAt_CRLF, ptSsClckQueryCnf->atClass[i].bStatus);
            
            if (ptSsClckQueryCnf->atClass[i].bClassFg == Z_APMMIA_VALID)  
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d", ptSsClckQueryCnf->atClass[i].bClass);
            }
        }
        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else if (ptSsClckQueryCnf->bClassNum == 0)
    {
        sprintf((char *)pStrWalk, "%s+CLCK: 0%s%s", g_zAt_CRLF, g_zAt_CRLF, g_zAt_OK);
    }
    
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncSsClipQueryCnf
*  ZPS_ApMmia_ClipQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CLIPѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsClipQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zDev_AtMem_Mmia_PrivateMem  ptAtData  = {0};
    T_zMmiaSs_ClipQer_Cnf *pClipQueryCnf = (T_zMmiaSs_ClipQer_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CLIP: <n>,<m> */
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&ptAtData, g_zAti_CurInstance);

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CLIP: %d,%d%s%s", g_zAt_CRLF,ptAtData.bClipSet, pClipQueryCnf->bMPara, g_zAt_CRLF,g_zAt_OK);   
}

/**************************************************************************
* ƣ zAt_PsEncSsClirQueryCnf
*  ZPS_ApMmia_ClirQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CLIRѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsClirQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zDev_AtMem_Mmia_PrivateMem ptAtData = {0};
    T_zMmiaSs_ClirQer_Cnf *pClirQueryCnf = (T_zMmiaSs_ClirQer_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CLIR: <n>,<m> */
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&ptAtData, g_zAti_CurInstance);

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CLIR: %d,%d%s%s", g_zAt_CRLF, ptAtData.bClirSet, pClirQueryCnf->bMPara, g_zAt_CRLF, g_zAt_OK);    
}

/**************************************************************************
* ƣ zAt_PsEncSsColpQueryCnf
*  ZPS_ApMmia_ColpQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+COLPѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsColpQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zDev_AtMem_Mmia_PrivateMem  ptAtData = {0};
    T_zMmiaSs_ColpQer_Cnf *pColpQueryCnf = (T_zMmiaSs_ColpQer_Cnf*) pEncCmdInfo->pMsgBody;

    /* +COLP: <n>,<m> */
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&ptAtData, g_zAti_CurInstance);

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+COLP: %d,%d%s%s", g_zAt_CRLF,ptAtData.bColpSet, pColpQueryCnf->bMPara, g_zAt_CRLF,g_zAt_OK);        
}

/**************************************************************************
* ƣ zAt_PsEncSsColrQueryCnf
*  ZPS_ApMmia_ColrQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+COLRѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsColrQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaSs_ColrQer_Cnf *pColrQueryCnf = (T_zMmiaSs_ColrQer_Cnf*) pEncCmdInfo->pMsgBody;

    /* +COLR: <m> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+COLR: %d%s%s", g_zAt_CRLF, pColrQueryCnf->bMPara, g_zAt_CRLF, g_zAt_OK);
}
#endif

/**************************************************************************
* ƣ zAt_PsEncSsCusdInd
*  ZPS_ApMmia_CusdInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CUSD֪ͨ
**************************************************************************/
UINT16 zAt_PsEncSsCusdInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSs_CusdMt_Ind *pCusdInd = (T_zMmiaSs_CusdMt_Ind*) pEncCmdInfo->pMsgBody;

    /* +CUSD: <m>[,<str>,<dcs>] */

    /* +CUSD: <m> */
    pStrWalk += sprintf((char *)pStrWalk, "%s+CUSD: %d", g_zAt_CRLF, pCusdInd ->bMPara);

    if (pCusdInd->bStrLen > 0)
    {
        if (pCusdInd->bStrLen > Z_APMMIA_MAX_SSUSSD_LEN)
        {
            return 0;
        }

        /* ,<str> */
        pStrWalk += sprintf((char *)pStrWalk, ",\"");

        if (!zAt_EncUssdData(pStrWalk, pCusdInd->abUssdStr, pCusdInd->bStrLen, pCusdInd->bDcs))
        {
            return 0;
        }
        pStrWalk += strlen((const char *)pStrWalk);

        /* ,<dcs> */
        pStrWalk += sprintf((char *)pStrWalk, "\",%d", pCusdInd->bDcs);
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#ifdef _USE_LPP_ECID
/************************************************************
*:zNas_ConvertCoordinate
*:
************************************************************/
VOID zNas_ConvertCoordinate(DWORD dwValue, BYTE bLatitudeFg, CHAR* pStrWalk)
{
    BYTE     bDegress_DDD;
    BYTE     bDegress_MM;
    WORD    bDegress_mmmm;
    double dDegress;

    if(bLatitudeFg)
    {
        dDegress = dwValue * 90.0 / (1 << 23); //Э23.032
    }
    else
    {
        dDegress = dwValue * 360.0 / (1 << 24); //Э23.032
    }

    bDegress_DDD = (BYTE)dDegress;
    bDegress_MM = (BYTE)((dDegress - bDegress_DDD) * 60 + 0.5/10000); //4//5룬4λЧ
    bDegress_mmmm = (WORD)(((dDegress - bDegress_DDD) * 60 + 0.5/10000 - bDegress_MM) * 10000);

    if(bLatitudeFg)
    {
        sprintf(pStrWalk, "%02d%02d.%04d", bDegress_DDD, bDegress_MM, bDegress_mmmm);
    }
    else
    {
        sprintf(pStrWalk, "%03d%02d.%04d", bDegress_DDD, bDegress_MM, bDegress_mmmm);
    }
}

BYTE zAti_GetNmeaCheckCode(CHAR* pNmeaStr, BYTE len)
{
    BYTE    bResult = 0;
    BYTE    i = 0;

    for(i = 0; i<len; i++)
    {
        bResult ^= pNmeaStr[i];
    }
    return bResult;
}

UINT16 zAt_PsEncSsMolrResInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE               bCheckMode = 0;
    CHAR*              pNmeaStr = ZOSS_NULL;
    CHAR*              pTempStr = ZOSS_NULL;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSs_LrRes_ShapeData *ptShapeData;
    T_z_Coordinate * ptCoordinate;
    double             dHorSpeed;
    T_zMmiaSs_MoLr_Res_Ind *pMolrResInd = (T_zMmiaSs_MoLr_Res_Ind*) pEncCmdInfo->pMsgBody;

    if(pMolrResInd->bResult == Z_FAIL)
    {
        sprintf((char *)pStrWalk, "%s+ZMOLRE: %lu%s", g_zAt_CRLF, pMolrResInd->dwCause,g_zAt_CRLF);
    }
    else
    {
        pNmeaStr = (char*)zOss_GetUB(Z_ATI_MAX_MNEA_STR_LEN);
        zOss_Memset(pNmeaStr, 0, Z_ATI_MAX_MNEA_STR_LEN);
        pTempStr = pNmeaStr;

        if(pMolrResInd->ptShapeData != ZOSS_NULL)
        {
            ptShapeData = pMolrResInd->ptShapeData;
        }
        else
        {
            ptShapeData = pMolrResInd->ptAddShapeData;
        }

        if(ptShapeData != ZOSS_NULL && ptShapeData->bType != Z_POLYGON)
        {
            ptCoordinate = &ptShapeData->Val.tEllip.tCoordinate;

            pNmeaStr += sprintf((char *)pNmeaStr, "$GPRMC,,A,");
            zNas_ConvertCoordinate(ptCoordinate->dwLatitude, Z_VALID, pNmeaStr);//γ
            pNmeaStr += strlen((const char *)pNmeaStr);
            
            if(ptCoordinate->bLatDire == 0)
            {
                pNmeaStr += sprintf((char *)pNmeaStr, ",N,");
            }
            else
            {
                pNmeaStr += sprintf((char *)pNmeaStr, ",S,");
            }

            zNas_ConvertCoordinate(ptCoordinate->dwLongitude > 0 ? ptCoordinate->dwLongitude : -1 * ptCoordinate->dwLongitude, Z_INVALID, pNmeaStr);//
            pNmeaStr += strlen((const char *)pNmeaStr);

            if(ptCoordinate->dwLongitude > 0)
            {
                pNmeaStr += sprintf((char *)pNmeaStr, ",E,");
            }
            else
            {
                pNmeaStr += sprintf((char *)pNmeaStr, ",W,");
            }

            if(pMolrResInd->ptVelData == ZOSS_NULL)
            {
                pNmeaStr += sprintf((char *)pNmeaStr, ",,,,*");
            }
            else
            {
                dHorSpeed = (pMolrResInd->ptVelData->wHorSpeed == 0 ? 0 : pMolrResInd->ptVelData->wHorSpeed - 0.5) / 1.852; // 1= 1.852km/h
                dHorSpeed = ((WORD)((dHorSpeed + 0.05) * 10)) / 10.0;/*5,һλЧ*/
                pNmeaStr += sprintf((char *)pNmeaStr, "%03d.%d,", (WORD)(dHorSpeed), (BYTE)((dHorSpeed - (WORD)dHorSpeed) * 10));

                if(pMolrResInd->ptVelData->wBearing > 360)
                {
                    pNmeaStr += sprintf((char *)pNmeaStr, ",");
                }
                else
                {
                    pNmeaStr += sprintf((char *)pNmeaStr, "%03d.0,", pMolrResInd->ptVelData->wBearing);
                }
                pNmeaStr += sprintf((char *)pNmeaStr, ",,*");
            }

        }
        else
        {
            pNmeaStr += sprintf((char *)pNmeaStr, "$GPRMC,,V,0000.0000,N,00000.0000,E,,,,,*");
        }
        bCheckMode = zAti_GetNmeaCheckCode(pTempStr, strlen((const char*)pTempStr));
        sprintf((char *)pNmeaStr, "%02x", bCheckMode);//У
        sprintf((char *)pStrWalk, "%s+ZMOLRN: %s%s", g_zAt_CRLF, pTempStr, g_zAt_CRLF);
        zAti_RetUB((VOID**)&pTempStr);
    }
    /*ͷڲָ*/
    if(pMolrResInd->ptShapeData != ZOSS_NULL && pMolrResInd->ptShapeData->bType == Z_POLYGON)
    {
        zAti_RetUB((VOID**)&pMolrResInd->ptShapeData->Val.tPolygon.ptCoordinates);
    }
    if(pMolrResInd->ptAddShapeData != ZOSS_NULL && pMolrResInd->ptAddShapeData->bType == Z_POLYGON)
    {
        zAti_RetUB((VOID**)&pMolrResInd->ptAddShapeData->Val.tPolygon.ptCoordinates);
    }
    zAti_RetUB((VOID**)&pMolrResInd->ptShapeData);
    zAti_RetUB((VOID**)&pMolrResInd->ptAddShapeData);
    zAti_RetUB((VOID**)&pMolrResInd->ptVelData);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncSsMtlrInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    T_zMmiaSs_MtLocalReqNotify_Ind *pMtlrInd = (T_zMmiaSs_MtLocalReqNotify_Ind*) pEncCmdInfo->pMsgBody;

    /*+ZMTLR:<handle-id>,<notification-type>,<location-type>,[<client-external-id>],[<client-name>][,<plane>]*/
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    if(tAtData.bMtLrIndSet == Z_VALID)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZMTLR: %d,%d,%d,\"", g_zAt_CRLF, pMtlrInd->bHandleId, pMtlrInd->bNotifiationType,
        pMtlrInd->tLocationType.bLocationEstmateType);

        if(pMtlrInd->bClientExtIdFg == Z_VALID && pMtlrInd->tClientExtId.bExternalAddressFg == Z_VALID)
        {
            for(i = 0; i < pMtlrInd->tClientExtId.tExternalAddress.bNum; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", pMtlrInd->tClientExtId.tExternalAddress.abAddr[i]);
            }
        }
        pStrWalk += sprintf((char *)pStrWalk, "\",");
        if(pMtlrInd->bClientNameFg == Z_VALID)
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"");
            for(i = 0; i < pMtlrInd->tClientName.tNameString.bNum; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", pMtlrInd->tClientName.tNameString.abUSSDString[i]);
            }
            pStrWalk += sprintf((char *)pStrWalk, "\",%d", pMtlrInd->tClientName.bDataCodScheme);
        }
        else
        {
            pStrWalk += sprintf((char *)pStrWalk, "\"\",");
        }
        sprintf((char *)pStrWalk, ",0%s", g_zAt_CRLF);
    }
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
#ifdef USE_VOICE_SUPPORT
/**************************************************************************
* ƣ zAt_PsEncSsDsQueryCnf
*  ZPS_ApMmia_DsQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CRLPѯӦ
**************************************************************************/
UINT16 zAt_PsEncSsDsQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_DsQuery_Cnf *pDsQueryCnf = (T_zApMmia_DsQuery_Cnf*) pEncCmdInfo->pMsgBody;

    /* +DS: <direction>,<compression_negotiation>,<max_dict>,<max_string> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+DS: %d,%d,%d,%d%s%s", g_zAt_CRLF, pDsQueryCnf->bDirection, 
        pDsQueryCnf->bNegotiation, pDsQueryCnf->wMaxDict, pDsQueryCnf->bMaxString,g_zAt_CRLF, g_zAt_OK);
}
#endif

// cpbr cpbfеĹ
BOOL zAt_EncPbCpbrCpbfInfo(CHAR * pStrWalk, T_z_CallNum *ptNum, T_zApMmia_PhoneText  *ptText,
                                                        BYTE bHiddenFg, BYTE bHidden, T_zApMmia_Grp  *ptGrp, 
                                                        T_z_CallNum    *ptAnr, T_zApMmia_Sne  *ptSne, T_zApMmia_Email  *ptEmail)
{
//,<number>,<type>,<text>[,<hidden>][,<group>][,<adnumber>][,<adtype>][,<secondtext>][,<email>][,<sip_uri>][,<tel_uri>]]

/* <number>,<type>, */
    if(!zAt_EncPbNumType(pStrWalk, 1, ptNum))
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);
    
    /* <text> */
    pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, 1, ptText->abTextVal);

    /* [,<hidden>] */
    if (bHiddenFg == Z_APMMIA_VALID)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", bHidden); 
    }
#ifdef R6_SUPPORT
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, ","); 
    }

    /* <group>  */
    pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, 1, ptGrp->abAlphaId);
 
    // [,<adnumber>][,<adtype>]
    if(!zAt_EncPbNumType(pStrWalk, 1, ptAnr))
    {
        return FALSE;
    }
    pStrWalk += strlen((const char *)pStrWalk);    
   

    /* <secondtext> */
    pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, 1, ptSne->abSne);

    /* <email> */
    pStrWalk += zAt_EncPbTextByCscs(1, pStrWalk, 1, ptEmail->abEmail);

#endif 
    return TRUE;
}



/**************************************************************************
* ƣ zAt_PsEncPbCpbfSetCnf
*  ZPS_ApMmia_CpbfExeCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBFӦ
**************************************************************************/
UINT16 zAt_PsEncPbCpbfSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbFindText_Cnf  *pCpbfSetCnf = (T_zApMmia_PbFindText_Cnf*) pEncCmdInfo->pMsgBody;
//#ifdef R6_SUPPORT
//    UINT16 wGrpLen = 0;
//    UINT16 wSneLen = 0;
//    UINT16 wEmailLen = 0;
//#endif
    if (Z_APMMIA_OPERATION_FAILURE == pCpbfSetCnf->bResult)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);
    }

    if (pCpbfSetCnf->wTotalNum == 0)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK);
    }
    else
    {
        /* UCS2ıʱȿܻᳬҪ4ZAT2_LONG_CMD_LENȿռ */
        zOss_RetUB(pEncCmdInfo->pStrCmd);
        pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 4); 
        pStrWalk = pEncCmdInfo->pStrCmd;
        
        /* +CPBF: <index1>,<number>,<type>,<text>[,<hidden>][[...]
           <CR><LF>+CBPF: <index2>,<number>,<type>,<text>[,<hidden>]] */

        /* Ϣֶȡ */

        /* +CPBR: <index> */
        pStrWalk += sprintf((char *)pStrWalk, "%s+CPBF: %d", g_zAt_CRLF, pCpbfSetCnf->wIndex); 

        if (!zAt_EncPbCpbrCpbfInfo(pStrWalk, &pCpbfSetCnf->tNum, &pCpbfSetCnf->tText,
                   pCpbfSetCnf->bHiddenFg, pCpbfSetCnf->bHidden, &pCpbfSetCnf->tGrp, 
                    &pCpbfSetCnf->tAnr, &pCpbfSetCnf->tSne, &pCpbfSetCnf->tEmail))
        {
            return 0;
        }
        pStrWalk += strlen((const char *)pStrWalk);

        /* жǷǰΪӦһΣս,Ϊ Ӧ */
        if (pCpbfSetCnf->wCurNum == pCpbfSetCnf->wTotalNum)
        {
             sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK); 
        }
        else
        {
            pEncCmdInfo->bIsEndOfCnf = FALSE;
        }
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncPbCpbfTestCnf
*  ZPS_ApMmia_CpbfTestCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBFӦ
**************************************************************************/
UINT16 zAt_PsEncPbCpbfTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
     T_zApMmia_PbStorageStatus_Cnf   *ptPbsStatCnf = (T_zApMmia_PbStorageStatus_Cnf*)pEncCmdInfo->pMsgBody;

    /* +CPBF: [<nlength>],[<tlength>] */
#ifdef R6_SUPPORT
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBF: %d,%d,%d,%d,%d%s%sOK%s",  g_zAt_CRLF,
    zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength,ptPbsStatCnf->wGlength,ptPbsStatCnf->wSlength,ptPbsStatCnf->wElength, 
    g_zAt_CRLF, g_zAt_CRLF,g_zAt_CRLF);
#else
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBF: %d,%d%s%sOK%s",  g_zAt_CRLF,
    zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength, g_zAt_CRLF, g_zAt_CRLF,g_zAt_CRLF);
#endif
}


/**************************************************************************
* ƣ zAt_PsEncPbCpbrSetCnf
*  ZPS_ApMmia_CpbrSetCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBRӦм
**************************************************************************/
UINT16 zAt_PsEncPbCpbrSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_CpbrSet_Cnf *pCpbrSetCnf = (T_zApMmia_CpbrSet_Cnf*) pEncCmdInfo->pMsgBody;

    /* UCS2ıʱȿܻᳬҪ4ZAT2_LONG_CMD_LENȿռ */
    zOss_RetUB(pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 4); 
    pStrWalk = pEncCmdInfo->pStrCmd;
        
    /* +CPBR: <index1>,<number>,<type>,<text>[,<hidden>][[...]
       <CR><LF>+CPBR: <index2>,<number>,<type>,<text>[,<hidden>]] */

    /* Ϣֶȡ */

    /* +CPBR: <index> */
    pStrWalk += sprintf((char *)pStrWalk, "%s+CPBR: %d", g_zAt_CRLF, pCpbrSetCnf->wIndex); 

    if (!zAt_EncPbCpbrCpbfInfo(pStrWalk, &pCpbrSetCnf->tNum, &pCpbrSetCnf->tText,
                       pCpbrSetCnf->bHiddenFg, pCpbrSetCnf->bHidden, &pCpbrSetCnf->tGrp, 
                        &pCpbrSetCnf->tAnr, &pCpbrSetCnf->tSne, &pCpbrSetCnf->tEmail))
    {
        return 0;
    }
    pStrWalk += strlen((const char *)pStrWalk);
    
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);           

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt_PsEncPbCpbrSetEndCnf
*  ZPS_ApMmia_CpbrSetEndCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBRӦս
**************************************************************************/


UINT16 zAt_PsEncPbCpbrSetEndCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_CpbrSetEnd_Cnf *pCpbrSetEndCnf = (T_zApMmia_CpbrSetEnd_Cnf*) pEncCmdInfo->pMsgBody;

    if (pCpbrSetEndCnf->bResult == Z_APMMIA_OPERATION_SUCCESS)
    {     
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);                 
    }

    return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pCpbrSetEndCnf->dwReason);
}

/**************************************************************************
* ƣ zAt_PsEncPbCpbrTestCnf
*  ZPS_ApMmia_CpbrTestCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBRӦ
**************************************************************************/
UINT16 zAt_PsEncPbCpbrTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApMmia_PbStorageStatus_Cnf   *ptPbsStatCnf = (T_zApMmia_PbStorageStatus_Cnf*)pEncCmdInfo->pMsgBody;

    /* +CPBR: (list of supported <index>s),[<nlength>],[<tlength>] */
#ifdef R6_SUPPORT 
    if (Z_APMMIA_OPERATION_SUCCESS == ptPbsStatCnf->bResult && ptPbsStatCnf->wTotal != 0)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBR: (1-%d),%d,%d,%d,%d,%d%s%s", g_zAt_CRLF, 
            ptPbsStatCnf->wTotal, zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength, ptPbsStatCnf->wGlength, ptPbsStatCnf->wSlength,ptPbsStatCnf->wElength,  
            g_zAt_CRLF, g_zAt_OK);
    }
#else
    if (Z_APMMIA_OPERATION_SUCCESS == ptPbsStatCnf->bResult && ptPbsStatCnf->wTotal != 0)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBR: (1-%d),%d,%d%s%s", g_zAt_CRLF,
            ptPbsStatCnf->wTotal, zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength, 
            g_zAt_CRLF, g_zAt_OK);
    }
#endif
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBR: (0-0)%s%s", g_zAt_CRLF, g_zAt_CRLF, g_zAt_OK);
}

/**************************************************************************
* ƣ zAt_PsEncPbCpbsQueryCnf
*  ZPS_ApMmia_CpbsQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBSѯӦ
**************************************************************************/
UINT16 zAt_PsEncPbCpbsQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbStorageStatus_Cnf   *ptPbsStatCnf = (T_zApMmia_PbStorageStatus_Cnf*)pEncCmdInfo->pMsgBody;

    /* +CPBS: <storage>[,<used>,<total>] */
    if (ptPbsStatCnf->tStorage.bStorage > ZAT_PB_STORAGE_TYPE_MAX_NUM - 1)
    {
        return 0;
    }
    
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBS: \"%s\",%d,%d%s%s", g_zAt_CRLF, ZAT_PB_STRAGE_TYPE[ptPbsStatCnf->tStorage.bStorage], 
        ptPbsStatCnf->wUsed, ptPbsStatCnf->wTotal, g_zAt_CRLF, g_zAt_OK);
}

/**************************************************************************
* ƣ zAt_PsEncPbCpbwTestCnf
*  ZPS_ApMmia_CpbwTestCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBWӦ
**************************************************************************/
UINT16 zAt_PsEncPbCpbwTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{   
     T_zApMmia_PbStorageStatus_Cnf   *ptPbsStatCnf = (T_zApMmia_PbStorageStatus_Cnf*)pEncCmdInfo->pMsgBody;

    /* +CPBW: (list of supported <index>s),[<nlength>],(list of supported <type>s),[<tlength>] */
#ifdef R6_SUPPORT
    if (Z_APMMIA_OPERATION_SUCCESS == ptPbsStatCnf->bResult && ptPbsStatCnf->wTotal != 0)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBW: (1-%d),%d,(128,129,131,132,136,137,144,145,147,148,152,153,160,161,163,164,168,169,176,177,179,180,184,185,192,193,195,196,200,201),%d,%d,%d,%d%s%s", 
            g_zAt_CRLF, ptPbsStatCnf->wTotal, zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength, ptPbsStatCnf->wGlength, ptPbsStatCnf->wSlength, ptPbsStatCnf->wElength, g_zAt_CRLF, g_zAt_OK);
    }
#else
    if (Z_APMMIA_OPERATION_SUCCESS == ptPbsStatCnf->bResult && ptPbsStatCnf->wTotal != 0)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBW: (1-%d),%d,(128,129,131,132,136,137,144,145,147,148,152,153,160,161,163,164,168,169,176,177,179,180,184,185,192,193,195,196,200,201),%d%s%s", 
            g_zAt_CRLF, ptPbsStatCnf->wTotal, zAti_PbAdaptNLength(ptPbsStatCnf->wNlength), ptPbsStatCnf->wTlength,g_zAt_CRLF, g_zAt_OK);
    }
#endif

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBW: (0-0)%s%s", g_zAt_CRLF,g_zAt_CRLF, g_zAt_OK);
}



/**************************************************************************
* ƣ zAt_PsEncPbSCpbrSetCnf
*  ZPS_ApMmia_SCpbrSetCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ^SCPBRӦм
**************************************************************************/
UINT16 zAt_PsEncPbSCpbrSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbSFindIndex_Cnf *pSCpbrSetCnf = (T_zApMmia_PbSFindIndex_Cnf*) pEncCmdInfo->pMsgBody;
    UINT16 wTextLen = 0;
    BYTE iCode = 0;

    /* UCS2ıʱȿܻᳬҪ4ZAT2_LONG_CMD_LENȿռ */
    zOss_RetUB(pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 4); 
    pStrWalk = pEncCmdInfo->pStrCmd;
    
    /* ^SCPBR:<index1>,<num1>,<type>,<num2>,<type>,<num3>,<type>,<num4>,<type>,<text>,<coding>[,<email>] */

    /* Ϣֶȡ */

    /* +CPBR: <index> */
    if(pSCpbrSetCnf->bCmdFlg == Z_APMMIA_CHINA_MOBILE_CMD)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s^SCPBR: %d", g_zAt_CRLF, pSCpbrSetCnf->wIndex); 
    }
    else if(pSCpbrSetCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZCPBR: %d", g_zAt_CRLF, pSCpbrSetCnf->wIndex); 
    }
    else
    {
        return 0;
    }

    if(!zAt_EncPbNumType(pStrWalk, pSCpbrSetCnf->bNum1Fg, &pSCpbrSetCnf->tNum1))
    {
        return 0;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(!zAt_EncPbNumType(pStrWalk, pSCpbrSetCnf->bNum2Fg, &pSCpbrSetCnf->tNum2))
    {
        return 0;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(!zAt_EncPbNumType(pStrWalk, pSCpbrSetCnf->bNum3Fg, &pSCpbrSetCnf->tNum3))
    {
        return 0;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(!zAt_EncPbNumType(pStrWalk, pSCpbrSetCnf->bNum4Fg, &pSCpbrSetCnf->tNum4))
    {
        return 0;
    }
    pStrWalk += strlen((const char *)pStrWalk);

    if(pSCpbrSetCnf->bTextFg == 1)
    {
        /* <text> */

        wTextLen = zAt_EncAlphaStrLenByCscsType((UINT8 *)pSCpbrSetCnf->tText.abTextVal);

        pStrWalk += sprintf((char *)pStrWalk, ",\"");

        if(wTextLen > 0)
        {
            zAt_EncScpbrTxtStr(pStrWalk, pSCpbrSetCnf->tText.abTextVal, wTextLen, &iCode);
            pStrWalk += strlen((const char *)pStrWalk);
            pStrWalk += sprintf((char *)pStrWalk, "\",%d,\"",iCode);
        }
        else//Ϊ0ʱʾ뷽ʽ
        {
            pStrWalk += sprintf((char *)pStrWalk, "\",,\"");
        }
    }    
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, ",\"\",,\"");
    }
    if(pSCpbrSetCnf->bEmailFg == 1)
    {
        /* [,<email>] */
        wTextLen = zAt_EncAlphaStrLenByCscsType((UINT8 *)pSCpbrSetCnf->tEmail.abEmail); // myp
        if(wTextLen > 0)
        {
            zAt_EncScpbrTxtStr(pStrWalk, pSCpbrSetCnf->tEmail.abEmail, wTextLen, &iCode);
            pStrWalk += strlen((const char *)pStrWalk);
        }
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");
    
    if(pSCpbrSetCnf->bSneFg == 1)
    {
        if(pSCpbrSetCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)
        {
            wTextLen = zAt_EncAlphaStrLenByCscsType((UINT8 *)pSCpbrSetCnf->tSne.abSne);
        
            if(wTextLen > 0)
            {   /*ȴ0ʾ*/
                pStrWalk += sprintf((char *)pStrWalk, ",\"");
                zAt_EncScpbrTxtStr(pStrWalk, pSCpbrSetCnf->tSne.abSne, wTextLen, &iCode);
                pStrWalk += strlen((const char *)pStrWalk);
                pStrWalk += sprintf((char *)pStrWalk, "\",%d",iCode);
            }
        }
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);           
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt_PsEncPbSCpbrSetEndCnf
*  ZPS_ApMmia_SCpbrSetEndCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ^SCPBRӦս
**************************************************************************/
UINT16 zAt_PsEncPbSCpbrSetEndCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbSFindIndexEnd_Cnf *pSCpbrSetEndCnf = (T_zApMmia_PbSFindIndexEnd_Cnf*) pEncCmdInfo->pMsgBody;

    return zAt_PsEncCommonResult(pEncCmdInfo, pSCpbrSetEndCnf->bResult, Z_APMMIA_OPERATION_SUCCESS, 
                                                        Z_APMMIA_OPERATION_FAILURE, pSCpbrSetEndCnf->dwReason);
}

/**************************************************************************
* ƣ zAt_PsEncPbSCpbrTestCnf
*  ZPS_ApMmia_SCpbrTestCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CPBRӦ
**************************************************************************/
UINT16 zAt_PsEncPbSCpbrTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbSCpbrTest_Cnf *pSCpbrTestCnf = (T_zApMmia_PbSCpbrTest_Cnf*) pEncCmdInfo->pMsgBody;

    /* ^SCPBR: (list of supported <index>s),[<nlength>],[<tlength>],[<mlenth>]  */
    if(pSCpbrTestCnf->bCmdFlg == Z_APMMIA_CHINA_MOBILE_CMD)
    {
        if (pSCpbrTestCnf->wMaxIndex == 0)
        {
            return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s^SCPBR: (0-0)%s%s", g_zAt_CRLF,g_zAt_CRLF, g_zAt_OK);
        }
        pStrWalk += sprintf((char *)pStrWalk, "%s^SCPBR: (1-%d),%d,%d", g_zAt_CRLF,
            pSCpbrTestCnf->wMaxIndex, pSCpbrTestCnf->wNumLenth, pSCpbrTestCnf->wTxtLenth);
    }
    else if(pSCpbrTestCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)
    {
        if (pSCpbrTestCnf->wMaxIndex == 0)
        {
            return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZCPBR: (0-0)%s%s", g_zAt_CRLF,g_zAt_CRLF, g_zAt_OK);
        }
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZCPBR: (1-%d),%d,%d", g_zAt_CRLF,
            pSCpbrTestCnf->wMaxIndex, pSCpbrTestCnf->wNumLenth, pSCpbrTestCnf->wTxtLenth);
    }
    else
    {
        return 0;
    }


    if (pSCpbrTestCnf->bEmailLenthFg == Z_APMMIA_VALID)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pSCpbrTestCnf->wEmailLenth);       
    }
    if((pSCpbrTestCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)&& (pSCpbrTestCnf->bSneLengthFg == Z_APMMIA_VALID))
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pSCpbrTestCnf->wSneLength);        
    }
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncPbSCpbwTestCnf
*  ZPS_ApMmia_SCpbwTestCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ^SCPBWӦ
**************************************************************************/
UINT16 zAt_PsEncPbSCpbwTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbSCpbwTest_Cnf *pSCpbwTestCnf = (T_zApMmia_PbSCpbwTest_Cnf*) pEncCmdInfo->pMsgBody;

    /* ^SCPBW: (list of supported <index>s),[<nlength>],(list of supported <type>s),[<tlength>],[<mlength>] */
    if(pSCpbwTestCnf->bCmdFlg == Z_APMMIA_CHINA_MOBILE_CMD)
    {
        if (pSCpbwTestCnf->wMaxIndex == 0)
        {
            return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s^SCPBW: (0-0)%s%s", g_zAt_CRLF,g_zAt_CRLF, g_zAt_OK);
        }
        pStrWalk += sprintf((char *)pStrWalk, "%s^SCPBW: (1-%d),%d,(128,129,131,132,136,137,144,145,147,148,152,153,160,161,163,164,168,169,176,177,179,180,184,185,192,193,195,196,200,201),%d", 
            g_zAt_CRLF, pSCpbwTestCnf->wMaxIndex, pSCpbwTestCnf->wNumLenth, pSCpbwTestCnf->wTxtLenth);
    }
    else if(pSCpbwTestCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)
    {
        if (pSCpbwTestCnf->wMaxIndex == 0)
        {
            return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZCPBW: (0-0)%s%s", g_zAt_CRLF,g_zAt_CRLF, g_zAt_OK);
        }
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZCPBW: (1-%d),%d,(128,129,131,132,136,137,144,145,147,148,152,153,160,161,163,164,168,169,176,177,179,180,184,185,192,193,195,196,200,201),%d", 
            g_zAt_CRLF, pSCpbwTestCnf->wMaxIndex, pSCpbwTestCnf->wNumLenth, pSCpbwTestCnf->wTxtLenth);
    }
    else
    {
        return 0;
    }

    if (pSCpbwTestCnf->bEmailLenthFg == Z_APMMIA_VALID)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pSCpbwTestCnf->wEmailLenth);       
    }
    
    if((pSCpbwTestCnf->bCmdFlg == Z_APMMIA_ZTE_OWN_CMD)&& (pSCpbwTestCnf->bSneLengthFg == Z_APMMIA_VALID))
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pSCpbwTestCnf->wSneLength);        
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncPbZwenCnf
*  ZPS_ApMmia_SmCauseCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ ӦZWENӦ
**************************************************************************/
UINT16 zAt_PsEncPbZwenCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_ZAti_EmerNum_Cnf *pSmZwenCnf = (T_ZAti_EmerNum_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZWEN: <bResult> (including two reasons) */
    if (pSmZwenCnf->bResult == TRUE)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);
    }
    else
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%sERROR%s", g_zAt_CRLF, g_zAt_CRLF);
    }
}

/**************************************************************************
* ƣ zAt_PsEncPbZCpbqSetCnf
*  ZPS_ApMmia_ZcpbqSetCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ^SCPBWӦ
**************************************************************************/
UINT16 zAt_PsEncPbZCpbqSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_PbReadCapacity_Cnf *pZCpbqSetCnf = (T_zApMmia_PbReadCapacity_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;
    UINT8 j = 0;

    if (pZCpbqSetCnf->bResult == Z_APMMIA_OPERATION_FAILURE)
    {
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pZCpbqSetCnf->dwReason);
    }
    /* +ZCPBQ: <set_index>,<entry_num>,<anr_count>[,<anr1_num>][,<anr2_num>][,<anr3_num>][...],<grp_count>[,<grp1_num>][...],<email_count>[,<email1_num>][...],<sne_count>[,<sne1_num>][...] */
    if(pZCpbqSetCnf->bNum > Z_APMMIA_PB_CAPA_MAX_NUM)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_INVALIDPARA_ERR);
    }
    for(i = 0; i < pZCpbqSetCnf->bNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZCPBQ: %d,%d,%d", g_zAt_CRLF, pZCpbqSetCnf->tPbSetCapa[i].bSetIndex, 
            pZCpbqSetCnf->tPbSetCapa[i].bEntryNum, pZCpbqSetCnf->tPbSetCapa[i].tAnrInfo.bItemCount);
        for(j = 0; j < pZCpbqSetCnf->tPbSetCapa[i].tAnrInfo.bItemCount; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tAnrInfo.bItemCap[j]);       
        }
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tGrpNameInfo.bItemCount);       
        for(j = 0; j < pZCpbqSetCnf->tPbSetCapa[i].tGrpNameInfo.bItemCount; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tGrpNameInfo.bItemCap[j]);       
        }
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tEmailInfo.bItemCount);       
        for(j = 0; j < pZCpbqSetCnf->tPbSetCapa[i].tEmailInfo.bItemCount; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tEmailInfo.bItemCap[j]);       
        }
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tSneInfo.bItemCount);       
        for(j = 0; j < pZCpbqSetCnf->tPbSetCapa[i].tSneInfo.bItemCount; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d", pZCpbqSetCnf->tPbSetCapa[i].tSneInfo.bItemCap[j]);       
        }
    }
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncPbZCpbqQueryCnf
*  ZPS_ApMmia_ZcpbqQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZCPBQѯӦı뺯
**************************************************************************/
UINT16 zAt_PsEncPbZCpbqQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbReadSetNum_Cnf *pZCpbqQueryCnf = (T_zApMmia_PbReadSetNum_Cnf*) pEncCmdInfo->pMsgBody;    

    if (pZCpbqQueryCnf->bResult == Z_APMMIA_OPERATION_FAILURE)
    {
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pZCpbqQueryCnf->dwReason);
    }
    /* +ZCPBQ: <set_num> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZCPBQ: %d%s%s", g_zAt_CRLF, pZCpbqQueryCnf->bSetNum, g_zAt_CRLF,  g_zAt_OK);
}

/**************************************************************************
* ƣ zAt_PsEncPbZeerReadCnf
*  ZPS_ApMmia_ZeerReadCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZEERѯӦı뺯
**************************************************************************/
UINT16 zAt_PsEncPbZeerReadCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApMmia_PbReadLastExtErr_Cnf *pZeerQueryCnf = (T_zApMmia_PbReadLastExtErr_Cnf*) pEncCmdInfo->pMsgBody;    

    /* +ZEER: <ext_err> */
    if (pZeerQueryCnf->bExtErr > Z_APMMIA_PB_EXTERR_GRP_FULL)
    {
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, Z_APMMIA_INVALIDPARA_ERR);
    }
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZEER: %d%s%s",  g_zAt_CRLF, pZeerQueryCnf->bExtErr, g_zAt_CRLF,  g_zAt_OK);
}

BOOL zAt_EncZemciSCell(CHAR * pStrWalk, T_z_CellInfo  *ptSCell)
{
    switch (ptSCell->bAct)
    {
        case 0:
            {
                pStrWalk += sprintf((char *)pStrWalk, "%08X,", 0xffffffff);
            }
            break;
        case 1:
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X%04X,", ptSCell->uCell.tTd.bCellParaId,
                    ptSCell->uCell.tTd.wUarfcn);
            }
            break;
        case 2:
            {
                pStrWalk += sprintf((char *)pStrWalk, "%04X%04X,", ptSCell->uCell.tW.wPrimSc,
                    ptSCell->uCell.tW.wUarfcn);
            }
            break;
        case 4:
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X%02X%04X,", ptSCell->uCell.tGsm.bBand,
                    ptSCell->uCell.tGsm.bBsic, ptSCell->uCell.tGsm.wArfcn);
    
            }
            break;
        case 16:
            {
                pStrWalk += sprintf((char *)pStrWalk, "%04X%08lX,", ptSCell->uCell.tLte.wPhyCellId,
                    ptSCell->uCell.tLte.dwEarfcn);
            }
            break;
        default:
            {
                return FALSE;
            }
    }
    return TRUE;
}

// TDб <NTCellNum>,[<NTCellList>,<NTCellRscpList>,]
UINT16 zAt_EncZemciNTCellInfo(CHAR * pTarget, BYTE bNTCellNum,T_z_TdCell * ptNTCellList, BYTE *pbNTCellRscpList)
{
    int i = 0;
    CHAR * pStrWalk = pTarget;
    pStrWalk += sprintf((char *)pStrWalk, "%d,", bNTCellNum);

    if (bNTCellNum > 0)
    {
        for (i = 0; i < bNTCellNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%02X%04X,%d,", ptNTCellList[i].bCellParaId,
                ptNTCellList[i].wUarfcn,
                pbNTCellRscpList[i]);
        }
    }
    return (UINT16)strlen((const char *)pTarget);
}

// GSM б  <NGCellNum>[,<NGcellInfo>,<NGCellRssi>,<NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>]
UINT16 zAt_EncZemciNGCellInfo(CHAR * pTarget, BYTE bNGCellNum,T_z_GsmCell * ptNGCellList, BYTE *pbNGCellRssiList, 
                                                            BYTE *pbNGCellMinRxlevList, SHORT iC1, SHORT iC2, SHORT iC31, SHORT iC32)
{
    int i = 0;
    CHAR * pStrWalk = pTarget;
    pStrWalk += sprintf((char *)pStrWalk, "%d,", bNGCellNum);
    if (bNGCellNum > 0)
    {
        for (i = 0; i < bNGCellNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%02X%02X%04X,%d,%d,%d,%d,%d,%d,%d,", ptNGCellList[i].bBand,
               ptNGCellList[i].bBsic, ptNGCellList[i].wArfcn,
                pbNGCellRssiList[i], pbNGCellMinRxlevList[i],
                0xFF, iC1, iC2, iC31, iC32);
        }
    }
    return (UINT16)strlen((const char *)pTarget);
}


// LTE б<NLCellNum>[,<NLCellList>,<NLCellRscpList>,<NLCellRsrqList>] 
UINT16 zAt_EncZemciNLCellInfo(CHAR * pTarget, BYTE bNLCellNum,T_z_LteCell * ptNLCellList, BYTE *pbNLCellRsrpList, 
                                                        BYTE *pbNLCellRsrqList)
{
    int i = 0;
    CHAR * pStrWalk = pTarget;
    pStrWalk += sprintf((char *)pStrWalk, "%d", bNLCellNum);

    if (bNLCellNum > 0)
    {
        for (i = 0; i < bNLCellNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%04X%08lX,%d,%d", ptNLCellList[i].wPhyCellId,
                ptNLCellList[i].dwEarfcn,
                pbNLCellRsrpList[i],
                pbNLCellRsrqList[i]);
        }
    }
    return (UINT16)strlen((const char *)pTarget);
}
#ifdef PS_RAT_GSM
BOOL zAt_PsEncGcellInfo(CHAR * pStrWalk, T_zMmiaAs_EM_GCellInfo_Ind* ptGcellInfo)
{
    UINT8 i = 0;

    /* +ZEMCI: <CellId>,<Rac>,<Lac>,<PlmnId>, */
    pStrWalk += sprintf((char *)pStrWalk, "%lu,%d,%d,\"%d%d%d%d%d", ptGcellInfo->dwCellId, ptGcellInfo->bRac, ptGcellInfo->wLac,
        ptGcellInfo->tPlmnId.bMCC1, ptGcellInfo->tPlmnId.bMCC2, ptGcellInfo->tPlmnId.bMCC3, ptGcellInfo->tPlmnId.bMNC1, ptGcellInfo->tPlmnId.bMNC2);

    if (ptGcellInfo->tPlmnId.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", ptGcellInfo->tPlmnId.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    /* <Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>
          <Act>,<Submode>,<SCell>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,", ptGcellInfo->bAtt, ptGcellInfo->wT3212,ptGcellInfo->tSCell.uCell.tGsm.bBand, 
        ptGcellInfo->wDchArfcn, ptGcellInfo->bLinkTimeOut, ptGcellInfo->bNmo, ptGcellInfo->bRssi,0xff, ptGcellInfo->tSCell.bAct,ptGcellInfo->bSubMode);

    if(!zAt_EncZemciSCell(pStrWalk,&ptGcellInfo->tSCell))
    {
        return FALSE;
    }
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    /* <C1>,<C2>,<C31>,<C32>,<SupGprs>,<SupDtxFg>,<SupHop>,<Tav>, */
    pStrWalk += sprintf((char *)pStrWalk, "%d,%d,%d,%d,%d,%d,%d,%d,", ptGcellInfo->sC1, ptGcellInfo->sC2, ptGcellInfo->sC31, ptGcellInfo->sC32,
        ptGcellInfo->bSupGprs, ptGcellInfo->bSupDtxFg, ptGcellInfo->bSupHop, ptGcellInfo->bTav);

    /* <NTCellNum>,[<NTCellList>,<NTCellRscpList>,]
<NGCellNum>[,<NGcellInfo>,<NGCellRssi>,<NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>]
<NLCellNum>[,<NLCellList>,<NLCellRscpList>,<NLCellRsrqList>] */

    pStrWalk +=zAt_EncZemciNTCellInfo(pStrWalk, ptGcellInfo->bNTCellNum, ptGcellInfo->atNTCellList, ptGcellInfo->abNTCellRscpList);

    pStrWalk += sprintf((char *)pStrWalk, "%d,", ptGcellInfo->bNGCellNum);

    if (ptGcellInfo->bNGCellNum > 0)
    {
        for (i = 0; i < ptGcellInfo->bNGCellNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%02X%02X%04X,%d,%d,%d,%d,%d,%d,%d,", ptGcellInfo->aNGcellInfo[i].tNGCell.bBand,
                ptGcellInfo->aNGcellInfo[i].tNGCell.bBsic, ptGcellInfo->aNGcellInfo[i].tNGCell.wArfcn,
                ptGcellInfo->aNGcellInfo[i].bNGCellRssi, ptGcellInfo->aNGcellInfo[i].bNGCellMinRxlev,
                ptGcellInfo->aNGcellInfo[i].bSupGprs, ptGcellInfo->aNGcellInfo[i].C1,
                ptGcellInfo->aNGcellInfo[i].C2, ptGcellInfo->aNGcellInfo[i].C31, ptGcellInfo->aNGcellInfo[i].C32);
        }
    }

    pStrWalk += zAt_EncZemciNLCellInfo(pStrWalk, ptGcellInfo->bNLCellNum, ptGcellInfo->atNLCellList,
                                      ptGcellInfo->abNLCellRsrpList, ptGcellInfo->abNLCellRsrqList);

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return TRUE;
}

/**************************************************************************
* ƣ zAt_PsEncEmZemciInd
*  ZPS_ApMmia_CusdInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZEMCI֪ͨ
**************************************************************************/
UINT16 zAt_PsEncEmGrrZemciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_GCellInfo_Ind *pZemciInd = (T_zMmiaAs_EM_GCellInfo_Ind*) pEncCmdInfo->pMsgBody;
    #ifdef _USE_COMSIG_TRACE
    T_z_CellInfo_Ind  tCellInfoInd = {0};/**LXH   617001858138 TMTЧQXDMܺ**/
    #endif

    /*+ZEMCI: 
    <CellId>,<Rac>,<Lac>,<PlmnId>,<Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>
     <Act>,<Submode><SCell>,<C1>,<C2>,<C31>,<C32>,<SupGprs>,
    <SupDtxFg>,<SupHop>,<Tav>,<NTCellNum>,[<NTCellList>,<NTCellRscpList>,]
    <NGCellNum>[,<NGcellInfo>,<NGCellRssi>,<NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>]
    <NLCellNum>[,<NLCellList>,<NLCellRscpList>,<NLCellRsrqList>]
    */

    if (pZemciInd->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciInd->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciInd->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return ZAT_ENC_NONEED_CNF;
    }
    if (g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet != Z_APMMIA_EM_IND_DISABLE)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCI: ", g_zAt_CRLF);
        
        if(!zAt_PsEncGcellInfo(pStrWalk, pZemciInd))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  PS_EXCEPTION_LEVEL_NORMAL,"");
            return ZAT_ENC_NONEED_CNF;
        }
    }
#ifdef _USE_COMSIG_TRACE 
    if (g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet != Z_APMMIA_EM_IND_DISABLE && zCatAgt_IsPsSigTraced())
    {
        zAti_EM_CpyGrrCellInfo(&tCellInfoInd, pZemciInd);
        zAti_EM_SendCellInfoToTrace((PBYTE)&tCellInfoInd);
    }
#endif
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncEmGrrZemciqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_GCellInfo_Ind *pZemciqCnf = (T_zMmiaAs_EM_GCellInfo_Ind*) pEncCmdInfo->pMsgBody;

    if(Z_NO_ACT == pZemciqCnf->tSCell.bAct)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    /*+ZEMCIQ:
    <CellId>,<Rac>,<Lac>,<PlmnId>,<Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>
     <Act>,<Submode><SCell>,<C1>,<C2>,<C31>,<C32>,<SupGprs>,
    <SupDtxFg>,<SupHop>,<Tav>,<NTCellNum>,[<NTCellList>,<NTCellRscpList>,]
    <NGCellNum>[,<NGcellInfo>,<NGCellRssi>,<NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>]
    <NLCellNum>[,<NLCellList>,<NLCellRscpList>,<NLCellRsrqList>]
    */
    
    if (pZemciqCnf->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciqCnf->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciqCnf->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCIQ: ", g_zAt_CRLF);

    if(!zAt_PsEncGcellInfo(pStrWalk, pZemciqCnf))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
#if defined(PS_RAT_FDD) ||defined(PS_RAT_TDD)
BOOL zAt_PsEncUcellInfo(CHAR * pStrWalk, T_zMmiaAs_EM_UCellInfo_Ind* ptUcellInfo)
{
    SHORT   sInvalidIn3G = -1;
    /* +ZEMCI: <CellId>,<Rac>,<Lac>,<PlmnId>, */
    pStrWalk += sprintf((char *)pStrWalk, "%lu,%d,%d,\"%d%d%d%d%d", ptUcellInfo->dwCellId, ptUcellInfo->bRac, ptUcellInfo->wLac,
        ptUcellInfo->tPlmnId.bMCC1, ptUcellInfo->tPlmnId.bMCC2, ptUcellInfo->tPlmnId.bMCC3, ptUcellInfo->tPlmnId.bMNC1, ptUcellInfo->tPlmnId.bMNC2);

    if (ptUcellInfo->tPlmnId.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", ptUcellInfo->tPlmnId.bMNC3);
    }
    pStrWalk += sprintf((char *)pStrWalk, "\"");

        /* <Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>
     <Act>,<Submode><SCell>, */
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,", ptUcellInfo->bAtt, ptUcellInfo->wT3212,ptUcellInfo->bBand, 
        ptUcellInfo->wWFreq, 0xff, ptUcellInfo->bNmo, ptUcellInfo->bRscp,0xff, ptUcellInfo->tSCell.bAct,ptUcellInfo->bSubMode);

    if(!zAt_EncZemciSCell(pStrWalk,&ptUcellInfo->tSCell))
    {
        return FALSE;
    }
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    /* <C1>,<C2>,<C31>,<C32>,<SupGprs>,<SupDtxFg>,<SupHop>,<Tav>, */
    pStrWalk += sprintf((char *)pStrWalk, "%d,%d,%d,%d,%d,%d,%d,%d,", sInvalidIn3G, sInvalidIn3G, sInvalidIn3G, sInvalidIn3G,
            0xff, 0xff, 0xff, 0xff);

    /* <NTCellNum>,[<NTCellList>,<NTCellRscpList>,]<NGCellNum>[,<NGcell>,<NGCellRssi>,
    <NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>] */

    pStrWalk += zAt_EncZemciNTCellInfo(pStrWalk, ptUcellInfo->bNTCellNum, ptUcellInfo->atNTCellList, ptUcellInfo->abNTCellRscpList);
    pStrWalk += zAt_EncZemciNGCellInfo(pStrWalk, ptUcellInfo->bNGCellNum, ptUcellInfo->atNGCellList, ptUcellInfo->abNGCellRssiList, 
                                      ptUcellInfo->abNGCellMinRxlevList, sInvalidIn3G, sInvalidIn3G, sInvalidIn3G, sInvalidIn3G);
    pStrWalk += zAt_EncZemciNLCellInfo(pStrWalk, ptUcellInfo->bNLCellNum, ptUcellInfo->atNLCellList,
                                      ptUcellInfo->abNLCellRsrpList, ptUcellInfo->abNLCellRsrqList);

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return TRUE;
}

UINT16 zAt_PsEncEmUmcrZemciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_UCellInfo_Ind *pZemciInd = (T_zMmiaAs_EM_UCellInfo_Ind*) pEncCmdInfo->pMsgBody;
#ifdef _USE_COMSIG_TRACE
    T_z_CellInfo_Ind  tCellInfoInd = {0};/**LXH   617001858138 TMTЧQXDMܺ**/
#endif

    /* +ZEMCI: <CellId>,<Rac>,<Lac>,<PlmnId>,
       <Att>,<T3212>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Act>,<SCell>,
       <C1>,<C2>,<C31>,<C32>,<SupGprs>,<SupDtxFg>,<SupHop>,<Tav>,
       <NTCellNum>,[<NTCellList>,<NTCellRscpList>,]<NGCellNum>[,<NGcell>,<NGCellRssi>,
       <NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>] */

    if (pZemciInd->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciInd->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciInd->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return ZAT_ENC_NONEED_CNF;
    }
    if (g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet != Z_APMMIA_EM_IND_DISABLE)
    {
        /* +ZEMCI: <CellId>,<Rac>,<Lac>,<PlmnId>, */
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCI: ", g_zAt_CRLF);
        
        if(!zAt_PsEncUcellInfo(pStrWalk, pZemciInd))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  PS_EXCEPTION_LEVEL_NORMAL,"");
            return ZAT_ENC_NONEED_CNF;
        }
    }
#ifdef _USE_COMSIG_TRACE 
    if (g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet != Z_APMMIA_EM_IND_DISABLE && zCatAgt_IsPsSigTraced())
    {
        zAti_EM_CpyUmcrCellInfo(&tCellInfoInd, pZemciInd);
        zAti_EM_SendCellInfoToTrace((PBYTE)&tCellInfoInd);
    }
#endif
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncEmUmcrZemciqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_UCellInfo_Ind *pZemciqCnf = (T_zMmiaAs_EM_UCellInfo_Ind*) pEncCmdInfo->pMsgBody;

    if(Z_NO_ACT == pZemciqCnf->tSCell.bAct)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    if (pZemciqCnf->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciqCnf->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciqCnf->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCIQ: ", g_zAt_CRLF);

    if(!zAt_PsEncUcellInfo(pStrWalk, pZemciqCnf))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
#ifdef PS_RAT_LTE
BOOL zAt_PsEncEcellInfo(CHAR * pStrWalk, T_zMmiaAs_EM_EUCellInfo_Ind* ptEcellInfo)
{
    SHORT sInvalidIn4G = -1;

     pStrWalk += sprintf((char *)pStrWalk, "%lu,%d,%d,\"%d%d%d%d%d", ptEcellInfo->dwCellId, 0xff, ptEcellInfo->wTac, 
            ptEcellInfo->tPlmnId.bMCC1, ptEcellInfo->tPlmnId.bMCC2, ptEcellInfo->tPlmnId.bMCC3, ptEcellInfo->tPlmnId.bMNC1, ptEcellInfo->tPlmnId.bMNC2);
    if (ptEcellInfo->tPlmnId.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", ptEcellInfo->tPlmnId.bMNC3);
    }
    pStrWalk += sprintf((char *)pStrWalk, "\"");
   /* <Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>
    <Act>,<Submode>,<SCell>, */
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,", 0xff, 0xffff,ptEcellInfo->bBand, 
        0xffff, 0xff, 0xff, ptEcellInfo->bRsrp,ptEcellInfo->bRsrq, ptEcellInfo->tSCell.bAct,0xff);

    if(!zAt_EncZemciSCell(pStrWalk,&ptEcellInfo->tSCell))
    {
        return FALSE;
    }
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    /* <C1>,<C2>,<C31>,<C32>,<SupGprs>,<SupDtxFg>,<SupHop>,<Tav>, */
    pStrWalk += sprintf((char *)pStrWalk, "%d,%d,%d,%d,%d,%d,%d,%d,", sInvalidIn4G, sInvalidIn4G, sInvalidIn4G, sInvalidIn4G,
        0xff, 0xff, 0xff, 0xff);
    /* <NTCellNum>,[<NTCellList>,<NTCellRscpList>,]<NGCellNum>[,<NGcell>,<NGCellRssi>,
    <NGCellMinRxlev>,<bSupGprs>,<C1>,<C2>,<C31>,<C32>] */

    pStrWalk += zAt_EncZemciNTCellInfo(pStrWalk, ptEcellInfo->bNTCellNum, ptEcellInfo->atNTCellList, ptEcellInfo->abNTCellRscpList);

    pStrWalk += zAt_EncZemciNGCellInfo(pStrWalk, ptEcellInfo->bNGCellNum, ptEcellInfo->atNGCellList, ptEcellInfo->abNGCellRssiList, 
    ptEcellInfo->abNGCellMinRxlevList, sInvalidIn4G, sInvalidIn4G, sInvalidIn4G, sInvalidIn4G);
    pStrWalk += zAt_EncZemciNLCellInfo(pStrWalk, ptEcellInfo->bNLCellNum, ptEcellInfo->atNLCellList,
                                  ptEcellInfo->abNLCellRsrpList, ptEcellInfo->abNLCellRsrqList);

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return TRUE;
}

UINT16 zAt_PsEncEmEumcrZemciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_EUCellInfo_Ind *pZemciInd = (T_zMmiaAs_EM_EUCellInfo_Ind*) pEncCmdInfo->pMsgBody;
#ifdef _USE_COMSIG_TRACE
    T_z_CellInfo_Ind  tCellInfoInd = {0};/**LXH   617001858138 TMTЧQXDMܺ**/
#endif

    if (pZemciInd->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciInd->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciInd->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return ZAT_ENC_NONEED_CNF;
    }
    if (g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet != Z_APMMIA_EM_IND_DISABLE)
    {
        /* +ZEMCI: <CellId>,<Rac>,<Lac>,<PlmnId>, */
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCI: ", g_zAt_CRLF);

        if(!zAt_PsEncEcellInfo(pStrWalk, pZemciInd))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  PS_EXCEPTION_LEVEL_NORMAL,"");                        
            return ZAT_ENC_NONEED_CNF;
        }
    }
#ifdef _USE_COMSIG_TRACE 
    if (g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet != Z_APMMIA_EM_IND_DISABLE && zCatAgt_IsPsSigTraced())
    {
        zAti_EM_CpyEumcrCellInfo(&tCellInfoInd, pZemciInd);
        zAti_EM_SendCellInfoToTrace((PBYTE)&tCellInfoInd);
    }
#endif
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncEmEumcrZemciqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_EM_EUCellInfo_Ind *pZemciqCnf = (T_zMmiaAs_EM_EUCellInfo_Ind*) pEncCmdInfo->pMsgBody;

    if(Z_NO_ACT == pZemciqCnf->tSCell.bAct)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    if (pZemciqCnf->bNTCellNum > Z_EM_MAX_NTCELL_NUM ||
        pZemciqCnf->bNGCellNum > Z_EM_MAX_NGCELL_NUM ||
        pZemciqCnf->bNLCellNum > Z_EM_MAX_NLCELL_NUM)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCIQ: ", g_zAt_CRLF);

    if(!zAt_PsEncEcellInfo(pStrWalk, pZemciqCnf))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
#ifdef BTRUNK_SUPPORT
VOID zAt_PsEncBtrunkZemciInd(CHAR * pStrWalk, T_zEm_Lte_EmInfo_Ind* ptLtecellInfo)
{
    /*<CellId>,<Rac>,<Lac>,<PlmnId>*/
    pStrWalk += sprintf((char *)pStrWalk, "%lu,%d,%d,\"%X%X%X%X%X", ptLtecellInfo->tScellPara.tScellInfo.dwCellId, 0xff, ptLtecellInfo->tScellPara.tNasInfo.wTac,
    ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC1, ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC2,ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC3, 
    ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC1, ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC2);
    if(ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk,"%X", ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC3);
    }
    pStrWalk += sprintf((char *)pStrWalk,"\"");
    /* <Att>,<T3212>,<Band>,<DchArfcn>,<LinkTimeOut>,<Nmo>,<Rssi>,<Rsrq>,<Act>,<Submode>,<SCell>, */
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%04X%08lX", 0xff, 0xffff, ptLtecellInfo->tScellPara.tScellInfo.bBand, 0xffff, 0xff, 0xff, 
    ptLtecellInfo->tMeasInfo.bScellRsrp, ptLtecellInfo->tMeasInfo.bScellRsrq, 16, 0xff,  ptLtecellInfo->tScellPara.tScellInfo.wPci, ptLtecellInfo->tScellPara.tScellInfo.dwEarfcn);
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
}
VOID zAt_PsEncBtrunkZemciqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zEM_EmInfo_Ind  *ptAscellInfoCnf = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;

    if(ptAscellInfoCnf->bRatType != Z_LTE_ACT)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
        return;
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCIQ: ", g_zAt_CRLF);
    zAt_PsEncBtrunkZemciInd(pStrWalk, &ptAscellInfoCnf->uEmInfo.tLteEmInfo);
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s", g_zAt_OK);
}
#endif
/**************************************************************************
*:zAt_PsEncEmZemsciInd
*:ϱСϢ
**************************************************************************/
UINT16 __ps_static_func zAt_PsEncEmZemsciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    WORD wInfoLen = sizeof(T_zEM_EmInfo_Ind);
    WORD wLen = 0;
    T_zEM_EmInfo_Ind  *ptEmInfoInd = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;

    /* ҪZAT2_LONG_CMD_LEN * 2ȿռ */
    if (g_zAti_atDataEx[g_zAti_CurInstance].bCellInfSet != Z_APMMIA_EM_IND_DISABLE)
    {
        #ifndef BTRUNK_SUPPORT
        zAti_RetUB((VOID**)&pEncCmdInfo->pStrCmd);
        pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(sizeof(T_zEM_EmInfo_Ind) * 2 + 100);//100Ϊͷβ
        pStrWalk = pEncCmdInfo->pStrCmd;

        pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMSCI: ", g_zAt_CRLF);

        for(wLen = 0; wLen < wInfoLen; wLen++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%02X", *((PBYTE)(ptEmInfoInd)+wLen));
        }

        sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
        #else
        if(ptEmInfoInd->bRatType == Z_LTE_ACT)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMCI: ", g_zAt_CRLF);
            zAt_PsEncBtrunkZemciInd(pStrWalk, &ptEmInfoInd->uEmInfo.tLteEmInfo);
        }
        else
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//Not Lte Act
        }
        #endif
    }
#ifdef _USE_COMSIG_TRACE 
    if(g_zAti_atDataEx[g_zAti_CurInstance].bTraceCellInfSet != Z_APMMIA_EM_IND_DISABLE && zCatAgt_IsPsSigTraced())
    {
        zSendLogToTrace((BYTE)(g_zAti_CurInstance+1), EM_SCELL_INFO_LOG, sizeof(T_zEM_EmInfo_Ind), (PBYTE)ptEmInfoInd);
    }
#endif

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncEmZemltehoQryCnf
*  MMIA_AS_EM_LTE_HO_SET_QUERY_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ 
**************************************************************************/
UINT16 zAt_PsEncEmZemltehoQryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaAs_EM_LteHoSet_Qry_Cnf *pZemlteho = (T_zMmiaAs_EM_LteHoSet_Qry_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZEMLTEHO<action>*/

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZEMLTEHO: %d%s%s",g_zAt_CRLF,pZemlteho->bAction,g_zAt_CRLF,g_zAt_OK);
}

/**************************************************************************
* ƣ zAt_PsEncZemltehoInd
*  MMIA_AS_EM_LTE_HO_INFO_IND_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZEMLTEHO֪ͨ
**************************************************************************/
UINT16 zAt_PsEncZemltehoInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaAs_EM_LteHo_Info_Ind *pZemlteho = (T_zMmiaAs_EM_LteHo_Info_Ind*) pEncCmdInfo->pMsgBody;

    /* +ZEMLTEHO: <TotalHoCount>,<SuccHoCount>*/

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZEMLTEHO: %lu,%lu%s",g_zAt_CRLF,pZemlteho->dwTotalHoCount, pZemlteho->dwSuccHoCount,g_zAt_CRLF);
}
UINT16 zAt_PsEncZemsciQCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    WORD wInfoLen = sizeof(T_zEM_EmInfo_Ind);
    WORD wLen = 0;
    T_zEM_EmInfo_Ind  *ptAscellInfoCnf = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;

    if(Z_NO_ACT == ptAscellInfoCnf->bRatType)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
    zAti_RetUB((VOID**)&pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(sizeof(T_zEM_EmInfo_Ind) * 2 + 100);//100Ϊͷβ
    pStrWalk = pEncCmdInfo->pStrCmd;

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMSCIQ: ", g_zAt_CRLF);
    for(wLen = 0; wLen < wInfoLen; wLen++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%02X", *((PBYTE)ptAscellInfoCnf+wLen));
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
BOOL zAt_EncZemsciqGcellInfoIndex1(CHAR * pStrWalk, T_zEm_Gsm_EmInfo_Ind* ptGcellInfo)
{
    /*<CellId>,<Rac>,<Lac>,<PlmnId>,<Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%lu,%d,%d,\"%X%X%X%X%X", ptGcellInfo->tScellPara.tScellInfo.dwCellId, ptGcellInfo->tScellPara.tNasInfo.bRac, 
                        ptGcellInfo->tScellPara.tNasInfo.wLac,ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMCC1, ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMCC2,
                        ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMCC3, ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMNC1, ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMNC2);

    if (ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%X", ptGcellInfo->tScellPara.tNasInfo.tPlmn.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    /* <Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d", ptGcellInfo->tScellPara.tScellInfo.bBsic, ptGcellInfo->tScellPara.tScellInfo.wArfcn,
                        ptGcellInfo->tScellPara.tScellInfo.bBand, ptGcellInfo->tMeasInfo.bRssi, 0xff, 0xff);

    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    return TRUE;
}

BOOL zAt_EncZemsciqTdcellInfoIndex1(CHAR * pStrWalk, T_zEm_Td_EmInfo_Ind* ptTdcellInfo)
{
    /*<CellId>,<Rac>,<Lac>,<PlmnId>,<Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%lu,%d,%d,\"%X%X%X%X%X", ptTdcellInfo->tScellPara.tScellInfo.dwCellId, ptTdcellInfo->tScellPara.tNasInfo.bRac, 
                        ptTdcellInfo->tScellPara.tNasInfo.wLac,ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMCC1, ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMCC2,
                        ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMCC3, ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMNC1, ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMNC2);

    if (ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%X", ptTdcellInfo->tScellPara.tNasInfo.tPlmn.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    /* <Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d", ptTdcellInfo->tScellPara.tScellInfo.bCellParaId, ptTdcellInfo->tScellPara.tScellInfo.wUarfcn,
                        ptTdcellInfo->tScellPara.tScellInfo.bBand, ptTdcellInfo->tMeasInfo.bRscp, 0xff, 0xff);

    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    return TRUE;
}

BOOL zAt_EncZemsciqWcellInfoIndex1(CHAR * pStrWalk, T_zEm_W_EmInfo_Ind* ptWcellInfo)
{
    WORD wUarfcn = 0;
    WORD wPci = 0;
    BYTE bBand = 0;
    BYTE bRscp = 0;
    BYTE bEcNo = 0;

    /*<CellId>,<Rac>,<Lac>,<PlmnId>,<Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%lu,%d,%d,\"%X%X%X%X%X", ptWcellInfo->tCampPara.dwCellId, ptWcellInfo->tCampPara.tNasInfo.bRac, 
                        ptWcellInfo->tCampPara.tNasInfo.wLac,ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMCC1, ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMCC2,
                        ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMCC3, ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMNC1, ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMNC2);

    if (ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%X", ptWcellInfo->tCampPara.tNasInfo.tPlmn.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    if (ptWcellInfo->bStateInd == 0)
    {
        wUarfcn = ptWcellInfo->uWcellMeasInfo.tDchInfo.tFreqAsVasInfo.tUsedFreqAsInfo.wUarfcn;
        bBand = ptWcellInfo->uWcellMeasInfo.tDchInfo.tFreqAsVasInfo.tUsedFreqAsInfo.bBand;
        bRscp = ptWcellInfo->uWcellMeasInfo.tDchInfo.tFreqAsVasInfo.tUsedFreqAsInfo.atAsVasCell[0].bRscp;
        bEcNo = ptWcellInfo->uWcellMeasInfo.tDchInfo.tFreqAsVasInfo.tUsedFreqAsInfo.atAsVasCell[0].bEcNo;
        wPci = ptWcellInfo->uWcellMeasInfo.tDchInfo.tFreqAsVasInfo.tUsedFreqAsInfo.atAsVasCell[0].wPsc;
    }
    else
    {
        wUarfcn = ptWcellInfo->uWcellMeasInfo.tNotDchInfo.tFddSCellReselInfo.tScellInfo.wUarfcn;
        bBand = ptWcellInfo->uWcellMeasInfo.tNotDchInfo.tFddSCellReselInfo.tScellInfo.bBand;
        bRscp = ptWcellInfo->uWcellMeasInfo.tNotDchInfo.tFddSCellReselInfo.tScellInfo.bRscp;
        bEcNo = ptWcellInfo->uWcellMeasInfo.tNotDchInfo.tFddSCellReselInfo.tScellInfo.bEcNo;
        wPci = ptWcellInfo->uWcellMeasInfo.tNotDchInfo.tFddSCellReselInfo.tScellInfo.wPsc;
    }

    /* <Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%d,%d,%d,%d", wPci, wUarfcn, bBand, bRscp, 0xff, bEcNo);

    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    return TRUE;
}

BOOL zAt_EncZemsciqLtecellInfoIndex1(CHAR * pStrWalk, T_zEm_Lte_EmInfo_Ind* ptLtecellInfo)
{
    /*<CellId>,<Rac>,<Lac>,<PlmnId>,<Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%lu,%d,%d,\"%X%X%X%X%X", ptLtecellInfo->tScellPara.tScellInfo.dwCellId, 0xff, 
                        ptLtecellInfo->tScellPara.tNasInfo.wTac,ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC1, ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC2,
                        ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMCC3, ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC1, ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC2);

    if (ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC3 != 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%X", ptLtecellInfo->tScellPara.tNasInfo.tPlmnId.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    /* <Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>,<DlBandWidth>,<RankInd>,<C_Rnti>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d,%d,%d,%d,%d,%d,%d", ptLtecellInfo->tScellPara.tScellInfo.wPci, ptLtecellInfo->tScellPara.tScellInfo.dwEarfcn,
                        ptLtecellInfo->tScellPara.tScellInfo.bBand, ptLtecellInfo->tMeasInfo.bScellRsrp, ptLtecellInfo->tMeasInfo.bScellRsrq, 0xff, ptLtecellInfo->tScellPara.tScellInfo.bDlBandWidth,
                        ptLtecellInfo->tMeasInfo.tMeasThreshInfo.tConnMeasInfo.bRankInd, ptLtecellInfo->tMeasInfo.tMeasThreshInfo.wCrnti);

    return TRUE;
}
UINT16 zAt_EncZemsciqByIndex1(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zEM_EmInfo_Ind  *ptScellCnf = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;

    /*+ZEMSCIQ: 1,<Act>,<CellId>,<Rac>,<Lac>,<PlmnId>,<Pci><Arfcn>,<Band>,<Rssi>,<Rsrq>,<Ecno>*/

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMSCIQ: %d,%d", g_zAt_CRLF, g_zAti_atDataEx[g_zAti_CurInstance].bZemsciqIndex, ptScellCnf->bRatType);

    switch (ptScellCnf->bRatType)
    {
        case Z_GSM_ACT:
        {
            zAt_EncZemsciqGcellInfoIndex1(pStrWalk, &ptScellCnf->uEmInfo.tGsmEmInfo);
            break;
        }
        case Z_TD_ACT:
        {
            zAt_EncZemsciqTdcellInfoIndex1(pStrWalk, &ptScellCnf->uEmInfo.tTdEmInfo);
            break;
        }
        case Z_W_ACT:
        {
            zAt_EncZemsciqWcellInfoIndex1(pStrWalk, &ptScellCnf->uEmInfo.tWEmInfo);
            break;
        }
        case Z_LTE_ACT:
        {
            zAt_EncZemsciqLtecellInfoIndex1(pStrWalk, &ptScellCnf->uEmInfo.tLteEmInfo);
            break;
        }
        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
            return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    pStrWalk += (UINT16)strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_EncZemsciqByIndex0(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    BYTE b4GNum = 0;
    BYTE b3GNum = 0;
    BYTE bRelNum = 0;
    WORD wUarfcn = 0;
    WORD wPci = 0;
    BYTE bRscp = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zEM_EmInfo_Ind  *ptScellCnf = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;

    /*+ZEMSCIQ: 0,<4GCellNum>[,<Pci>,<Earfcn>,<RSRP>]s,<3GCellNum>[,<Psc>,<arfcn>,<Rscp>]s*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEMSCIQ: 0", g_zAt_CRLF);

    if(Z_LTE_ACT == ptScellCnf->bRatType)
    {
        T_zEm_Lte_EmInfo_Ind *ptLteInfo = &ptScellCnf->uEmInfo.tLteEmInfo;
        T_zEm_Lte_NCellInfo *ptNcellInfo = &ptScellCnf->uEmInfo.tLteEmInfo.tMeasInfo.tNCellInfo;

        b4GNum = ptNcellInfo->bIntraCellNum + ptNcellInfo->bInterCellNum + 1;
        b4GNum = (b4GNum > 7)? 7 : b4GNum;

        pStrWalk += sprintf((char *)pStrWalk, ",%d", b4GNum);

        pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptLteInfo->tScellPara.tScellInfo.wPci, ptLteInfo->tScellPara.tScellInfo.dwEarfcn, 
                                ptLteInfo->tMeasInfo.bScellRsrp);
        bRelNum++;

        for(i = 0; i < ptNcellInfo->bIntraCellNum && bRelNum < b4GNum; i++, bRelNum++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNcellInfo->tIntraCell[i].wPci, ptNcellInfo->tIntraCell[i].dwEarfcn, ptNcellInfo->tIntraCell[i].bRsrp);
        }

        for(i = 0; i < ptNcellInfo->bInterCellNum && bRelNum < b4GNum; i++, bRelNum++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNcellInfo->tInterCell[i].wPci, ptNcellInfo->tInterCell[i].dwEarfcn, ptNcellInfo->tInterCell[i].bRsrp);
        }

        b3GNum = (ptNcellInfo->bWCellNum > 7)? 7 : ptNcellInfo->bWCellNum;

        pStrWalk += sprintf((char *)pStrWalk, ",%d", b3GNum);

        for(i = 0; i < b3GNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNcellInfo->tNWCell[i].wPci, ptNcellInfo->tNWCell[i].wArfcn, ptNcellInfo->tNWCell[i].bRscp);
        }
    }
    else if(Z_W_ACT == ptScellCnf->bRatType)
    {
        if(ptScellCnf->uEmInfo.tWEmInfo.bStateInd == 0)
        {
            T_zEm_W_DchMeasInfo *ptDch = &ptScellCnf->uEmInfo.tWEmInfo.uWcellMeasInfo.tDchInfo;
            b4GNum = (ptDch->tNCellInfo.bLteCellNum > 7)? 7 : ptDch->tNCellInfo.bLteCellNum;

            pStrWalk += sprintf((char *)pStrWalk, ",%d", b4GNum);

            for(i = 0; i < b4GNum; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptDch->tNCellInfo.atLteCell[i].wPci, ptDch->tNCellInfo.atLteCell[i].dwEarfcn, ptDch->tNCellInfo.atLteCell[i].bRsrp);
            }

            b3GNum = ptDch->tNCellInfo.bIntraCellNum + ptDch->tNCellInfo.bInterCellNum + ptDch->tNCellInfo.bDetectCellNum + 1;
            b3GNum = (b3GNum > 7)? 7 : b3GNum;

            pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%lu,%d", b3GNum, ptDch->tFreqAsVasInfo.tUsedFreqAsInfo.atAsVasCell[0].wPsc, ptDch->tFreqAsVasInfo.tUsedFreqAsInfo.wUarfcn, 
                             ptDch->tFreqAsVasInfo.tUsedFreqAsInfo.atAsVasCell[0].bRscp);
            bRelNum++;

            for(i = 0; i < ptDch->tNCellInfo.bIntraCellNum && bRelNum < b3GNum; i++, bRelNum++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptDch->tNCellInfo.atIntraCell[i].wPsc, ptDch->tNCellInfo.atIntraCell[i].wUarfcn, ptDch->tNCellInfo.atIntraCell[i].bRscp);
            }

            for(i = 0; i < ptDch->tNCellInfo.bInterCellNum && bRelNum < b3GNum; i++, bRelNum++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptDch->tNCellInfo.atInterCell[i].wPsc, ptDch->tNCellInfo.atInterCell[i].wUarfcn, ptDch->tNCellInfo.atInterCell[i].bRscp);
            }

            for(i = 0; i < ptDch->tNCellInfo.bDetectCellNum && bRelNum < b3GNum; i++, bRelNum++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptDch->tNCellInfo.atDetectCell[i].wPsc, ptDch->tNCellInfo.atDetectCell[i].wUarfcn, ptDch->tNCellInfo.atDetectCell[i].bRscp);
            }
        }
        else
        {
            T_zEm_W_NotDchMeasInfo *ptNotDch = &ptScellCnf->uEmInfo.tWEmInfo.uWcellMeasInfo.tNotDchInfo;
            b4GNum = (ptNotDch->bLteNCellNum > 7)? 7 : ptNotDch->bLteNCellNum;

            pStrWalk += sprintf((char *)pStrWalk, ",%d", b4GNum);

            for(i = 0; i < b4GNum; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNotDch->atLteCellReselInfo[i].tLteCellInfo.wPci, ptNotDch->atLteCellReselInfo[i].tLteCellInfo.dwEarfcn, 
                                 ptNotDch->atLteCellReselInfo[i].tLteCellInfo.bRsrp);
            }

            b3GNum = ptNotDch->bFddIntraCellNum + ptNotDch->bFddInterCellNum + 1;
            b3GNum = (b3GNum > 7)? 7 : b3GNum;

            pStrWalk += sprintf((char *)pStrWalk, ",%d,%d,%lu,%d", b3GNum, ptNotDch->tFddSCellReselInfo.tScellInfo.wPsc, ptNotDch->tFddSCellReselInfo.tScellInfo.wUarfcn, 
                                 ptNotDch->tFddSCellReselInfo.tScellInfo.bRscp);
            bRelNum++;

            for(i = 0; i < ptNotDch->bFddIntraCellNum && bRelNum < b3GNum; i++, bRelNum++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNotDch->atFddIntraCellInfo[i].tFddCellInfo.wPsc, ptNotDch->atFddIntraCellInfo[i].tFddCellInfo.wUarfcn, 
                                 ptNotDch->atFddIntraCellInfo[i].tFddCellInfo.bRscp);
            }

            for(i = 0; i < ptNotDch->bFddInterCellNum && bRelNum < b3GNum; i++, bRelNum++)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",%d,%lu,%d", ptNotDch->atFddInterCellInfo[i].tFddCellInfo.wPsc, ptNotDch->atFddInterCellInfo[i].tFddCellInfo.wUarfcn, 
                                 ptNotDch->atFddInterCellInfo[i].tFddCellInfo.bRscp);
            }
        }
    }
    else
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncZemsciqByIndexCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zEM_EmInfo_Ind  *ptScellCnf = (T_zEM_EmInfo_Ind*)pEncCmdInfo->pMsgBody;
    BYTE bZemsciqIndex = g_zAti_atDataEx[g_zAti_CurInstance].bZemsciqIndex;

    if(Z_NO_ACT == ptScellCnf->bRatType)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
        return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    switch (bZemsciqIndex)
    {
        case 0:
        {
            return zAt_EncZemsciqByIndex0(pEncCmdInfo);
        }
        case 1:
        {
            return zAt_EncZemsciqByIndex1(pEncCmdInfo);
        }
        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");  
            return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
}
UINT16 zAt_PsEncEmZemsciQCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    if (g_zAti_atDataEx[g_zAti_CurInstance].bZemsciqIndex != 0xff)
    {
        zAt_PsEncZemsciqByIndexCnf(pEncCmdInfo);
        g_zAti_atDataEx[g_zAti_CurInstance].bZemsciqIndex = 0xff;
    }
    else
    {
        #ifdef BTRUNK_SUPPORT
        zAt_PsEncBtrunkZemciqCnf(pEncCmdInfo);
        #else
        zAt_PsEncZemsciQCnf(pEncCmdInfo);
        #endif
    }

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/**************************************************************************
* ƣ zAt_PsEncEmZemhiInd
*  ZPS_ApMmia_CusdInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZEMHI֪ͨ
**************************************************************************/
UINT16 zAt_PsEncEmZemhiInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_EM_HoInfo_Ind *pZemhiInd = (T_zApMmia_EM_HoInfo_Ind*) pEncCmdInfo->pMsgBody;

    /* +ZEMHI<SyncHoSuccCnt>,<AsyncHoSuccCnt>,<PreHoSuccCnt>,<PseudoHoSuccCnt>,
       <SyncHoFailCnt>,<AsyncHoFailCnt>,<PreHoFailCnt>,<PseudoHoFailCnt>,
       <HardHoSuccCnt>,<BatonHoSuccCnt>,<HardHoFailCnt>,<BatonHoFailCnt>,
       <TdHoGsmSuccCnt>,<TdHoGsmFailCnt>,<GsmHoTdHoSuccCnt>,<GsmHoTdHoFailCnt> 
    */

    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZEMHI: %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d%s",g_zAt_CRLF, 
        pZemhiInd->bSyncHoSuccCnt, pZemhiInd->bAsyncHoSuccCnt, pZemhiInd->bPreHoSuccCnt, pZemhiInd->bPseudoHoSuccCnt, 
        pZemhiInd->bSyncHoFailCnt, pZemhiInd->bAsyncHoFailCnt, pZemhiInd->bPreHoFailCnt, pZemhiInd->bPseudoHoFailCnt, 
        pZemhiInd->bHardHoSuccCnt, pZemhiInd->bBatonHoSuccCnt, pZemhiInd->bHardHoFailCnt, pZemhiInd->bBatonHoFailCnt, 
        pZemhiInd->bTdHoGsmSuccCnt, pZemhiInd->bTdHoGsmFailCnt, pZemhiInd->bGsmHoTdHoSuccCnt, pZemhiInd->bGsmHoTdHoFailCnt,g_zAt_CRLF);
}
#ifdef USE_VOICE_SUPPORT
UINT16 zAt_PsEncAcmCaocSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE abCcm[Z_APMMIA_AOC_CALL_METER_LEN] = {0};
    T_zMmiaCc_CcmQuery_Cnf *pCaocCnf = (T_zMmiaCc_CcmQuery_Cnf *)pEncCmdInfo->pMsgBody;

    zAti_LongToArray(abCcm, pCaocCnf->dwCcm, Z_APMMIA_AOC_CALL_METER_LEN);
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CAOC: \"%02X%02X%02X\"%s%s", g_zAt_CRLF, abCcm[0],abCcm[1],abCcm[2], g_zAt_CRLF, g_zAt_OK);
}

UINT16 zAt_PsEncAcmCcwvInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zDev_AtMem_Mmia_PrivateMem  ptAtMmia = {0};
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&ptAtMmia, g_zAti_CurInstance);

    if(ptAtMmia.bCcweSet != Z_APMMIA_N_ENABLE)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");                        
        return ZAT_ENC_NONEED_CNF;
    }
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CCWV%s", g_zAt_CRLF, g_zAt_CRLF);
}

UINT16 zAt_PsEncAcmCccmInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE abCcm[Z_APMMIA_AOC_CALL_METER_LEN] = {0};
    T_zMmiaCc_CcmQuery_Cnf *pCccmInd = (T_zMmiaCc_CcmQuery_Cnf *)pEncCmdInfo->pMsgBody;

    zAti_LongToArray(abCcm, pCccmInd->dwCcm, Z_APMMIA_AOC_CALL_METER_LEN);
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CCCM: \"%02X%02X%02X\"%s", g_zAt_CRLF,
        abCcm[0],abCcm[1],abCcm[2], g_zAt_CRLF); 
}
#endif
BOOL zAt_EncUsatAddr(CHAR * pStrTarget, T_zApUicc_USAT_Addr tAddr)
{
    /* <Ton>,<NPI>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tAddr.bTon, tAddr.bNPI);

    if (tAddr.bCallNumLen > Z_APUICC_USAT_MAX_BCDNUM_LEN)  //ܻһ˫
    {
        pStrTarget += sprintf((char *)pStrTarget, ",\"\"");
        return FALSE;
    }
    pStrTarget += sprintf((char *)pStrTarget, ",\"");
    /* <CallNum> */
    if (tAddr.bCallNumLen > 0)
    {
        /* print the BCD number */
        zAt_EncBcd2NumStrByCscsType(pStrTarget, tAddr.abCallNum, (UINT8)tAddr.bCallNumLen, ZAT2_CSCS_GSM);
        
        pStrTarget += strlen((const char *)pStrTarget);
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");
    return TRUE;
}
#ifdef NAS_FULL_USAT_SUPPORT
BOOL zAt_EncUsatSsStr(CHAR * pStrTarget, T_zApUicc_USAT_SsStr tSsStr)
{
    /* <Ton>,<NPI>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tSsStr.bTon, tSsStr.bNPI);

    if (tSsStr.bLen > Z_APUICC_USAT_MAX_SSSTR_LEN)
    {
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, ",\"");
   /* <CallNum> */
    if (tSsStr.bLen> 0)
    {
        /* print the BCD number */
        zAt_EncBcd2NumStrByCscsType(pStrTarget, tSsStr.abSsStr, (UINT8)tSsStr.bLen, ZAT2_CSCS_GSM);
        pStrTarget += strlen((const char *)pStrTarget);
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");
    return TRUE;
}

BOOL zAt_EncUsatUssdStr(CHAR * pStrTarget, T_zApUicc_USAT_UssdStr tUssdStr)
{
    UINT8 i = 0;

    /*<Dcs>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tUssdStr.bDcs);

    /* <UssdStr> */
    if (tUssdStr.bLen > Z_APUICC_USAT_MAX_USSDSTR_LEN)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",\"\"");
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, ",\"");

    for (i = 0; i < tUssdStr.bLen; i++)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%02X", tUssdStr.abUssdStr[i]);
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");
    return TRUE;
}

BOOL zAt_EncUsatPdpActParam(CHAR * pStrTarget, T_zApUicc_USAT_PdpActParam tPdpActParam)
{
    UINT8 i = 0;
    UINT8 j = 0;
    UINT8 iPdpAddrSect = 0;

    /* [<Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>,<DlyClss>,<ReliabClss>,<PeakPut>,<PrecClss>,
       <MeanPut>,[<TraffClss>,<DelivOrd>,<DelivErrSDU>,<MaxSDUsiz>,<MaxBitUp>,<MaxBitDown>,
       <ResiBER>,<SDUerrRat>,<TranLay>,<TrafHand>,<GuarBitUp>,<GuarBitDown>
       ,[<SignInd>,<SourDescr>,[<MaxBitExt>,<GuarBitExt>]]],<PdpType>,<PdpTypeNum>,<AddrInfo>,
       [<Apn>],[<CfgProto>,<ProtoIDLen>,[<ProtoId>,<ProtoIdCont>[...]]],] 
     */

    /* <Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d,%d,%d,%d,", tPdpActParam.bPd, tPdpActParam.bTi, tPdpActParam.bMsgType,
        tPdpActParam.bNsapi, tPdpActParam.bLlcSapi);

    /*
       <DlyClss>,<ReliabClss>,<PeakPut>,<PrecClss>,<MeanPut>
       ,[<TraffClss>,<DelivOrd>,<DelivErrSDU>,<MaxSDUsiz>,<MaxBitUp>,<MaxBitDown>,<ResiBER>,<SDUerrRat>,<TranLay>,<TrafHand>,<GuarBitUp>,<GuarBitDown>
       ,[<SignInd>,<SourDescr>,[<MaxBitExt>,<GuarBitExt>]]]
    */

    /* <DlyClss>,<ReliabClss>,<PeakPut>,<PrecClss>,<MeanPut>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d,%d,%d,%d,", 
        tPdpActParam.tReqQoS.bDlyClss, tPdpActParam.tReqQoS.bReliabClss, tPdpActParam.tReqQoS.bPeakPut, 
        tPdpActParam.tReqQoS.bPrecClss, tPdpActParam.tReqQoS.bMeanPut);

    if (tPdpActParam.tReqQoS.bpresentfg1 == 1)
    {
        /* <TraffClss>,<DelivOrd>,<DelivErrSDU>,<MaxSDUsiz>,<MaxBitUp>,<MaxBitDown>,
           <ResiBER>,<SDUerrRat>,<TranLay>,<TrafHand>,<GuarBitUp>,<GuarBitDown>,
        */
        pStrTarget += sprintf((char *)pStrTarget, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,", 
            tPdpActParam.tReqQoS.bTraffClss, tPdpActParam.tReqQoS.bDelivOrd, tPdpActParam.tReqQoS.bDelivErrSDU,
            tPdpActParam.tReqQoS.bMaxSDUsiz, tPdpActParam.tReqQoS.bMaxBitUp, tPdpActParam.tReqQoS.bMaxBitDown,
            tPdpActParam.tReqQoS.bResiBER, tPdpActParam.tReqQoS.bSDUerrRat, tPdpActParam.tReqQoS.bTranLay,
            tPdpActParam.tReqQoS.bTrafHand, tPdpActParam.tReqQoS.bGuarBitUp, tPdpActParam.tReqQoS.bGuarBitDown);

        if (tPdpActParam.tReqQoS.bpresentfg9 == 1)
        {
            /* <SignInd>,<SourDescr>, */
            pStrTarget += sprintf((char *)pStrTarget, "%d,%d,", tPdpActParam.tReqQoS.bSignInd, tPdpActParam.tReqQoS.bSourDescr);

            if (tPdpActParam.tReqQoS.bpresentfg10 == 1)
            {
                /* ,<MaxBitExt>,<GuarBitExt> */
                pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tPdpActParam.tReqQoS.bMaxBitExt, tPdpActParam.tReqQoS.bGuarBitExt);
            }
            else
            {
                pStrTarget += sprintf((char *)pStrTarget, ",");
            }
        }
        else
        {
            pStrTarget += sprintf((char *)pStrTarget, ",,,");
        }
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,,");
        if (tPdpActParam.tReqQoS.bpresentfg2 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bMaxSDUsiz);
        }

        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg3 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bMaxBitUp);
        }
        
        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg4 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bMaxBitDown);
        }

        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg5 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tPdpActParam.tReqQoS.bResiBER, tPdpActParam.tReqQoS.bSDUerrRat);
        }
        else
        {
            pStrTarget += sprintf((char *)pStrTarget, ",");
        }
        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg6 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tPdpActParam.tReqQoS.bTranLay, tPdpActParam.tReqQoS.bTrafHand);
        }
        else
        {
            pStrTarget += sprintf((char *)pStrTarget, ",");
        }
        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg7 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bGuarBitUp);
        }

        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg8 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bGuarBitDown);
        }

        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg9 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tPdpActParam.tReqQoS.bSignInd, tPdpActParam.tReqQoS.bSourDescr);
        }
        else
        {
            pStrTarget += sprintf((char *)pStrTarget, ",");
        }
        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg10 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bMaxBitExt);
        }

        pStrTarget += sprintf((char *)pStrTarget, ",");

        if (tPdpActParam.tReqQoS.bpresentfg11 == 1)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d", tPdpActParam.tReqQoS.bGuarBitExt);
        }
    }

    /* ,<PdpType>,<PdpTypeNum>,<AddrInfo>, */
    pStrTarget += sprintf((char *)pStrTarget, ",%d,%d,", tPdpActParam.tReqPdpAddr.bPdpType, tPdpActParam.tReqPdpAddr.bPdpTypeNum);

    if (tPdpActParam.tReqPdpAddr.bPdpType == Z_APMMIA_SM_PPP)
    {
        iPdpAddrSect = 0;
    }
    else if (tPdpActParam.tReqPdpAddr.bPdpType == Z_APMMIA_SM_IPV4)
    {
        iPdpAddrSect = 4;
    }
    else if (tPdpActParam.tReqPdpAddr.bPdpType == Z_APMMIA_SM_IPV6)
    {
        iPdpAddrSect = 16;
    }
    /*617001605981 zAt_EncUsatPdpActParampdp©ipv4v6*/
    else if (tPdpActParam.tReqPdpAddr.bPdpType == Z_APMMIA_SM_IPV4V6)
    {
        iPdpAddrSect = 20;
    }
    else
    {
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");

    for (i = 0; i < iPdpAddrSect; i++)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d.", tPdpActParam.tReqPdpAddr.abAddrInfo[i]);
    }
    if (iPdpAddrSect > 0)
    {
        pStrTarget--;
    }

    pStrTarget += sprintf((char *)pStrTarget, "\",");

    /* [<Apn>], */
    if (tPdpActParam.bApnFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "\"");

        for (i = 0; i < tPdpActParam.tApn.bApnValLen; i++, pStrTarget++)
        {
            sprintf((char *)pStrTarget, "%c", tPdpActParam.tApn.abApnVal[i]);
        }

        pStrTarget += sprintf((char *)pStrTarget, "\"");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<CfgProto>,<ProtoIDLen>[,<ProtoId>,<ProtoIdCont>[...]]],] */
    if (tPdpActParam.bProtCfgFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d,%d", tPdpActParam.tProtCfg.bCfgProto, tPdpActParam.tProtCfg.bProtoIDLen);

        for (i = 0; i < tPdpActParam.tProtCfg.bProtoIDLen; i++)
        {
            pStrTarget += sprintf((char *)pStrTarget, ",%04X,", tPdpActParam.tProtCfg.atProtoID[i].wProtoId);

            for (j = 0; j < tPdpActParam.tProtCfg.atProtoID[i].bProtoIdContLen; j++)
            {
                pStrTarget += sprintf((char *)pStrTarget, "%02X", tPdpActParam.tProtCfg.atProtoID[i].abProtoIdCont[j]);
            }
        }
    }

    return TRUE;
}
#endif
/**************************************************************************
* ƣ zAt_PsEncUsatZuecSetCnf
*  ZPS_ApMmia_USAT_EnvelopCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZUECѯӦ
**************************************************************************/
UINT16 zAt_PsEncUsatZuecSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_USAT_EnvelopCmd_Cnf *pZuecSetCnf = (T_zApUicc_USAT_EnvelopCmd_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +ZUEC: <confirm type>,<confirm data>*[,<error reason>] */
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZUEC: %d,", g_zAt_CRLF, pZuecSetCnf->wMsgType);

    switch (pZuecSetCnf->wMsgType)
    {
#ifdef NAS_FULL_USAT_SUPPORT
    case 1: /* SMS CTR */
        {
            /* <SmsCtrRlt>,[<RpTon>,<RpNPI>,<RpCallNum>],[<TpTon>,<TpNPI>,<TpCallNum>],[<Alpha>] */
            T_zApUicc_USAT_SmsCtrlCnf * pScCnf = (T_zApUicc_USAT_SmsCtrlCnf *)pZuecSetCnf->pBuffer;

            pStrWalk += sprintf((char *)pStrWalk, "%d", pScCnf->bCtrRlt);

            if (pScCnf->bRpdaFg == 1)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",");
                /* <RpTon>,<RpNPI>,<RpCallNum> */
                if (!zAt_EncUsatAddr(pStrWalk, pScCnf->tRpDa))
                {
                    zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                    return 0;
                }
                pStrWalk += strlen((const char *)pStrWalk);
            }
            else if ((pScCnf->bTpdaFg == 1) || (pScCnf->tAlpha.bAlphaLen > 0))
            {
                pStrWalk += sprintf((char *)pStrWalk, ",,,");
            }

            if (pScCnf->bTpdaFg == 1)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",");
                /* <TpTon>,<TpNPI>,<TpCallNum> */
                if (!zAt_EncUsatAddr(pStrWalk, pScCnf->tTpDa))
                {
                    zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                    return 0;
                }
                pStrWalk += strlen((const char *)pStrWalk);
            }
            else if (pScCnf->tAlpha.bAlphaLen > 0)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",,,");
            }

            /* <Alpha> */
            if (pScCnf->tAlpha.bAlphaLen > Z_APUICC_USAT_MAX_ALPHA_LEN)
            {
                zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                return 0;
            }
            if (pScCnf->tAlpha.bAlphaLen > 0)
            {
                pStrWalk += sprintf((char *)pStrWalk, ",");
                pStrWalk += sprintf((char *)pStrWalk, "\"");

                for (i = 0; i < pScCnf->tAlpha.bAlphaLen; i++)
                {
                    pStrWalk += sprintf((char *)pStrWalk, "%02X", pScCnf->tAlpha.abAlpha[i]);
                }
                pStrWalk += sprintf((char *)pStrWalk, "\"");
            }
        }
        break;
    case 2: /* CALL CTR */
        {
            /* <CallCtrRlt>,[<Ton>,<NPI>,<CallNum>,][<Ton>,<NPI>,<SsStr>,][<Dcs>,<UssdStr>,]
              [<Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>,<DlyClss>,<ReliabClss>,<PeakPut>,<PrecClss>,
              <MeanPut>[,<TraffClss>,<DelivOrd>,<DelivErrSDU>,<MaxSDUsiz>,<MaxBitUp>,<MaxBitDown>,
              <ResiBER>,<SDUerrRat>,<TranLay>,<TrafHand>,<GuarBitUp>,<GuarBitDown>
              [,<SignInd>,<SourDescr>[,<MaxBitExt>,<GuarBitExt>]]],<PdpType>,<PdpTypeNum>,<AddrInfo>,
              [<Apn>],[<CfgProto>,<ProtoIDLen>[,<ProtoId>,<ProtoIdCont>[...]]],]
              <Capa1>,<subaddr>,<Alpha>,[<BcReptr>],<Capa2>
             */
            T_zApUicc_USAT_CallCtrlCnf * pCcCnf = (T_zApUicc_USAT_CallCtrlCnf *)pZuecSetCnf->pBuffer;

            pStrWalk += sprintf((char *)pStrWalk, "%d,%d,", pCcCnf->bCtrlRlt, pCcCnf->bUnionFg);

            switch (pCcCnf->bUnionFg)
            {
            case 0:
                {
                    /* <TpTon>,<TpNPI>,<TpCallNum> */
                    if (!zAt_EncUsatAddr(pStrWalk, pCcCnf->uCtrStr.tAddr))
                    {
                        zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                        return 0;
                    }
                    pStrWalk += strlen((const char *)pStrWalk);
                }
                break;
            case 1:
                {
                    /* <Ton>,<NPI>,<SsStr> */
                    if (!zAt_EncUsatSsStr(pStrWalk, pCcCnf->uCtrStr.tSsStr))
                    {
                        zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                        return 0;
                    }
                    pStrWalk += strlen((const char *)pStrWalk);
                }
                break;
            case 2:
                {
                    /* <Dcs>,<UssdStr> */
                    if (!zAt_EncUsatUssdStr(pStrWalk, pCcCnf->uCtrStr.tUssdStr))
                    {
                        zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                        return 0;
                    }
                    pStrWalk += strlen((const char *)pStrWalk);
                }
                break;
            case 3:
                {
                    /* [<Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>,<DlyClss>,<ReliabClss>,<PeakPut>,<PrecClss>,
                       <MeanPut>[,<TraffClss>,<DelivOrd>,<DelivErrSDU>,<MaxSDUsiz>,<MaxBitUp>,<MaxBitDown>,
                       <ResiBER>,<SDUerrRat>,<TranLay>,<TrafHand>,<GuarBitUp>,<GuarBitDown>
                       [,<SignInd>,<SourDescr>[,<MaxBitExt>,<GuarBitExt>]]],<PdpType>,<PdpTypeNum>,<AddrInfo>,
                       [<Apn>],[<CfgProto>,<ProtoIDLen>[,<ProtoId>,<ProtoIdCont>[...]]],] 
                     */
                    if (!zAt_EncUsatPdpActParam(pStrWalk, pCcCnf->uCtrStr.tPdp))
                    {
                        zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                        return 0;
                    }
                    pStrWalk += strlen((const char *)pStrWalk);
                }
                break;
            default:
                {
                    zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                    return 0;
                }
            }

            /* <Capa1>,<subaddr>,<Alpha>,[<BcReptr>],<Capa2> */
            pStrWalk += sprintf((char *)pStrWalk, ",");
            
            /* <Capa1>, */
            for (i = 0; i < pCcCnf->tCapa1.bCpaLen; i++,pStrWalk += 2)
            {
                sprintf((char *)pStrWalk, "%02X", pCcCnf->tCapa1.abCapa[i]);
            }

            pStrWalk += sprintf((char *)pStrWalk, ",\"");

            /* <subaddr>, */
            for (i = 0; i < pCcCnf->tSubAdr.bLen; i++)
            {
                sprintf((char *)pStrWalk, "%c", pCcCnf->tSubAdr.abSubAddr[i]);
                pStrWalk += strlen((const char *)pStrWalk);
            }
            pStrWalk += sprintf((char *)pStrWalk, "\",");

            /* <Alpha>, */
            if (pCcCnf->tAlpha.bAlphaLen > Z_APUICC_USAT_MAX_ALPHA_LEN)
            {
                zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                return 0;
            }
            
            for (i = 0; i < pCcCnf->tAlpha.bAlphaLen; i++,pStrWalk += 2)
            {
                sprintf((char *)pStrWalk, "%02X", pCcCnf->tAlpha.abAlpha[i]);
            }

            pStrWalk += sprintf((char *)pStrWalk, ",");

            /* [<BcReptr>] */
            if (pCcCnf->bBcRepFg == 1)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%d", pCcCnf->bBcReptr);
            }

            sprintf((char *)pStrWalk, ",");
            pStrWalk++;

            /* <Capa2> */
            for (i = 0; i < pCcCnf->tCapa2.bCpaLen; i++,pStrWalk += 2)
            {
                sprintf((char *)pStrWalk, "%02X", pCcCnf->tCapa2.abCapa[i]);
            }
        }
        break;
#endif
    case 3: /* SMS DOWN */
        {
            /* <SmsDownRlt>[,<Tpdu>] */
            T_zApUicc_USAT_SmsDownCnf * pSdCnf = (T_zApUicc_USAT_SmsDownCnf *)pZuecSetCnf->pBuffer;

            pStrWalk += sprintf((char *)pStrWalk, "%lu", pZuecSetCnf->dwErrCode);
            pStrWalk += sprintf((char *)pStrWalk, ",\"");

            if (pSdCnf->bTpduLen > Z_APUICC_USAT_MAX_TPUD_LEN)
            {
                zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
                return 0;
            }

            for (i = 0; i < pSdCnf->bTpduLen; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", pSdCnf->abTpud[i]);
            }

            pStrWalk += sprintf((char *)pStrWalk, "\"");
        }
        break;
    case 0xffff:
        {
            /* Эջ⣬ش */
            /*if (!zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, pZuecSetCnf->dwErrCode))
            {
                return iStrLen;
            }*/
            /*[,<error reason>] */
            pStrWalk += sprintf((char *)pStrWalk, ",%lu", pZuecSetCnf->dwErrCode);
        }
        break;
    default:
        {            
            zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));
            return 0;
        }
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);

    /* ͷbufferָ */
    zAti_RetUB((VOID **)&(pZuecSetCnf->pBuffer));

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}



/*8.2        Alpha identifier */
BOOL zAt_EncUsatAlpha(CHAR * pStrTarget, T_zApUicc_USAT_Alpha tAlpha)
{
    UINT8 i = 0;

    if (tAlpha.bAlphaLen > Z_APUICC_USAT_MAX_ALPHA_LEN)
    {
        return FALSE;
    }

    /* <Alpha> */
    for (i = 0; i < tAlpha.bAlphaLen; i++)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%02X", tAlpha.abAlpha[i]);
    }

    return TRUE;
}


/*8.3        Subaddress */
BOOL zAt_EncUsatSubAddr(CHAR * pStrTarget, T_zApUicc_USAT_SubAddr tSubAddr)
{
    if ( tSubAddr.bLen > Z_APUICC_USAT_MAX_SUBADR_LEN)
    {
        pStrTarget += sprintf((char *)pStrTarget, "\"\"");
        return FALSE;
    }

    /* <subaddr> */
    pStrTarget += sprintf((char *)pStrTarget, "\"");

    /* print the BCD number */
    zAt_EncBcd2NumStrByCscsType(pStrTarget, tSubAddr.abSubAddr, (UINT8)tSubAddr.bLen, ZAT2_CSCS_GSM);

    pStrTarget += strlen((const char *)pStrTarget);
    sprintf((char *)pStrTarget, "\"");

    return TRUE;
}

#ifdef NAS_FULL_USAT_SUPPORT
/*8.4        Capability configuration parameters */
BOOL zAt_EncUsatCapa(CHAR * pStrTarget, T_zApUicc_USAT_Capa tCapa)
{
    UINT8 i = 0;

    if ( tCapa.bCpaLen > Z_APUICC_USAT_MAX_BC_LEN)
    {
        return FALSE;
    }

    /* <Capa> */
    for (i = 0; i < tCapa.bCpaLen; i++)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%02X", tCapa.abCapa[i]);
    }

    return TRUE;
}
#endif

UINT16 zAt_EncUsatCmdDtls(CHAR * pStrTarget, T_zApUicc_USAT_CmdDtls tCmdDtls)
{
    /* <CmdNum>,<CmdQual> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tCmdDtls.bCmdNum, tCmdDtls.bCmdQual);
}


/*8.7        Device identities */
UINT16 zAt_EncUsatDvcId(CHAR * pStrTarget, T_zApUicc_USAT_DvcId tDvcId)
{
    /* <SDvcId>,<DDvcId> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tDvcId.bSDvcId, tDvcId.bDDvcId);
}
    
/*8.8        Duration */
UINT16 zAt_EncUsatDura(CHAR * pStrTarget, T_zApUicc_USAT_Dura tDura)
{
    /* <TimeUnit>,<TimeFreq> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tDura.bTimeUnit, tDura.bTimeFreq);
}
#ifdef USAT_USER_REF
/*8.11     Response length */
UINT16 zAt_EncUsatRspLen(CHAR * pStrTarget, T_zApUicc_USAT_RspLen tRspLen)
{
    /* <MinRspLen>,<MaxRspLen> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tRspLen.bMinLen, tRspLen.bMaxLen);
}
#endif
/*31111  8.15 Text string */
BOOL zAt_EncUsatTxtStr(CHAR * pStrTarget, T_zApUicc_USAT_TxtStr tTxtStr)
{
    /* <CodeMode>,<Txt> */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tTxtStr.bCodeMode);

    if(tTxtStr.bTxtLen > Z_APUICC_USAT_MAX_TXTSTR_LEN)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",\"\"");
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, ",\"");
    
    zAt_EncUsatTxtData(pStrTarget, (UINT8 *)tTxtStr.abTxt, tTxtStr.bTxtLen);

    pStrTarget += strlen((const char *)pStrTarget);

    sprintf((char *)pStrTarget, "\"");

    return TRUE;
}
#ifdef USAT_USER_REF
/* 102221 8.23 Default Text */
BOOL zAt_EncUsatDefTxt(CHAR * pStrTarget, T_zApUicc_USAT_DefTxt tDefTxt)
{
    /* <CodeMode>,<Txt> */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tDefTxt.bCodeMode);

    if(tDefTxt.bTxtLen > Z_APUICC_USAT_MAX_TXTSTR_LEN)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",\"\"");
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, ",\"");

    zAt_EncUsatTxtData(pStrTarget, (UINT8 *)tDefTxt.abTxt, tDefTxt.bTxtLen);

    pStrTarget += strlen((const char *)pStrTarget);

    sprintf((char *)pStrTarget, "\"");

    return TRUE;
}
#endif
/*8.18     File list */
BOOL zAt_EncUsatFileList(CHAR * pStrTarget, T_zApUicc_USAT_FileList tFileList)
{
    UINT8 i = 0;

    /* <FileNum>[,<Fid>] */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tFileList.bFileNum);

    if ( tFileList.bFidNum > Z_APUICC_USAT_MAX_FILELST_LEN)
    {
        return FALSE;
    }

    if (tFileList.bFidNum > 0)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < tFileList.bFidNum; i++)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%04X", tFileList.awFid[i]);
        }
    }

    return TRUE;
}

/*8.19     Location information */

/*8.25     Event list */
BOOL zAt_EncUsatEvtLst(CHAR * pStrTarget, T_zApUicc_USAT_EvtLst tEvtLst)
{
    UINT8 i = 0;

    if ( tEvtLst.bLen > Z_APUICC_USAT_MAX_EVNTLST_LEN)
    {
        return FALSE;
    }

    /* <EvtNum>,<EvtLst> */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tEvtLst.bLen);

    if (tEvtLst.bLen > 0)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < tEvtLst.bLen; i++)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%02X", tEvtLst.abEvtLst[i]);
        }
    }

    return TRUE;
}

/*8.31     Icon identifier */
UINT16 zAt_EncUsatIcon(CHAR * pStrTarget, T_zApUicc_USAT_Icon tIcon)
{
    /* <IconWithDesc>,<IconId> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tIcon.bIconWithDesc, tIcon.bIconId);
}
#ifdef NAS_FULL_USAT_SUPPORT
/*102223
  8.37     Timer identifier 
  8.38     Timer value */
VOID zAt_EncUsatTimerInfo(CHAR * pStrTarget, T_zApUicc_USAT_TimerInfo tTimerInfo)
{
    /* <TimerId>[,<TimerVal>] */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tTimerInfo.bTimerId);

    if (tTimerInfo.bValFg == 1)
    {
        BYTE bHour = (BYTE)(tTimerInfo.abTimerVal[0] << 4 | tTimerInfo.abTimerVal[0] >> 4);
        BYTE bMinute = (BYTE)(tTimerInfo.abTimerVal[1] << 4 | tTimerInfo.abTimerVal[1] >> 4);
        BYTE bSecond = (BYTE)(tTimerInfo.abTimerVal[2] << 4 | tTimerInfo.abTimerVal[2] >> 4);

        sprintf((char *)pStrTarget, ",%02X%02X%02X",bHour, bMinute, bSecond);
    }

}

/*8.50     Provisioning file reference */
BOOL zAt_EncUsatProFileRef(CHAR * pStrTarget, T_zApUicc_USAT_ProFileRef tProFileRef)
{
    UINT8 i = 0;

    /* <Fid> */
    if ( tProFileRef.bFidNum > Z_APUICC_USAT_MAX_FILELST_LEN)
    {
        return FALSE;
    }
    
    for (i = 0; i < tProFileRef.bFidNum; i++)
    {
       pStrTarget += sprintf((char *)pStrTarget, "%04X", tProFileRef.awFid[i]);
    }

    return TRUE;
}
#endif
/*8.53     Channel data */
VOID zAt_EncUsatChnlData(CHAR * pStrTarget, T_zApUicc_USAT_ChnlData tChnlData)
{
    UINT8 i = 0;
    /* <ChnlData> */
    for (i = 0; i < tChnlData.bDataLen; i++)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%02X", tChnlData.abData[i]);
    }

}

/*8.58     Other address  */
BOOL zAt_EncUsatOthrAddr(CHAR * pStrTarget, T_zApUicc_USAT_OthrAddr tOthrAddr)
{
    UINT8 i = 0;
    UINT8 iPdpAddrSect = 0;
    /* <AdrType>,<Adr> */

    /* <AdrType> */
    pStrTarget += sprintf((char *)pStrTarget, "%d", tOthrAddr.bAddrType);
    
    if (tOthrAddr.bAddrType == Z_APMMIA_SM_IPV4)
    {
        iPdpAddrSect = 4;
    }
    else if (tOthrAddr.bAddrType == Z_APMMIA_SM_IPV6)
    {
        iPdpAddrSect = 16;
    }
    else
    {
        //return FALSE;
    }

    /* <Adr> */
    pStrTarget += sprintf((char *)pStrTarget, ",\"");

    if(iPdpAddrSect != 0)
    {
        for (i = 0; i < iPdpAddrSect; i++)
        {
            pStrTarget += sprintf((char *)pStrTarget, "%d.", tOthrAddr.abAddr[i]);
        }
    }
    if (iPdpAddrSect > 0)
    {
        pStrTarget--;
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");

    return TRUE;
}

/*8.59     UICC/terminal interface transport level */
UINT16 zAt_EncUsatIntfcTnsptLv(CHAR * pStrTarget, T_zApUicc_USAT_IntfcTnsptLv tIntfcTnsptLv)
{
    /* <PortNum>,<TranProType> */
    return (UINT16)sprintf((char *)pStrTarget, "%d,%d", tIntfcTnsptLv.wPortNum, tIntfcTnsptLv.bTranProType);
}

/*8.60     AID */
VOID zAt_EncUsatAid(CHAR * pStrTarget, T_zApUicc_USAT_Aid tAid)
{
    UINT8 i = 0;
    /* [<Aid>] */
    if(tAid.bLen > ZPS_APUICC_USAT_MAX_AID_LEN)
    {
        return;
    }
    for (i = 0; i < tAid.bLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tAid.abAid[i]);
    }
}
#ifdef NAS_FULL_USAT_SUPPORT
/*8.63     Service record */
VOID zAt_EncUsatSrvRec(CHAR * pStrTarget, T_zApUicc_USAT_SrvRec tSrvRec)
{
    UINT8 i = 0;
    /* <BearType>,<SrvID>,<SrvRecord> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d,", tSrvRec.bBearType, tSrvRec.bSrvID);

    for (i = 0; i < tSrvRec.bRecLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tSrvRec.abRecord[i]);
    }

}

/*8.64     Device filter */
VOID zAt_EncUsatDvcFilter(CHAR * pStrTarget, T_zApUicc_USAT_DvcFilter tDvcFilter)
{
    UINT8 i = 0;
    /* <LBType>,<Filer> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tDvcFilter.bLBType);

    for (i = 0; i < tDvcFilter.bFilterLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tDvcFilter.abFiler[i]);
    }

}

/*8.65     Service search */
VOID zAt_EncUsatSrvSrch(CHAR * pStrTarget, T_zApUicc_USAT_SrvSrch tSrvSrch)
{
    UINT8 i = 0;
    /* <BearType>,<SrvSrch> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tSrvSrch.bBearId);

    for (i = 0; i < tSrvSrch.bLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tSrvSrch.abSrvSrch[i]);
    }
}

/*8.66     Attribute information */
VOID zAt_EncUsatAtrInfo(CHAR * pStrTarget, T_zApUicc_USAT_AtrInfo tAtrInfo)
{
    UINT8 i = 0;
    /* <BearType>,<AtrInfo> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tAtrInfo.bBearType);

    for (i = 0; i < tAtrInfo.bAtrLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tAtrInfo.abAtrInfo[i]);
    }
}
#endif
/*8.68     Remote entity address */
BOOL zAt_EncUsatRmtAddr(CHAR * pStrTarget, T_zApUicc_USAT_RmtAddr tRmtAddr)
{
    UINT8 i = 0;

    if (tRmtAddr.bLen > Z_APUICC_USAT_MAX_REMADDR_LEN)
    {
        return FALSE;
    }

    /* <CodeType>,<RemAdr> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tRmtAddr.bCodeType);

    for (i = 0; i < tRmtAddr.bLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tRmtAddr.abRmtAddr[i]);
    }

    return TRUE;
}


/*8.70     Network access name */
BOOL zAt_EncUsatNetName(CHAR * pStrTarget, T_zApUicc_USAT_NetName tNetName)
{
    UINT8 i = 0;

    if (tNetName.bLen > Z_APUICC_USAT_MAX_NETNAME_LEN)
    {
        return FALSE;
    }

    /* <NetName> */
    for (i = 0; i < tNetName.bLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", tNetName.abNetName[i]);
    }

    return TRUE;
}

/*8.52     Bearer description */
BOOL zAt_EncUsatBDescp(CHAR * pStrTarget, T_zApUicc_USAT_BDescp tBDescp)
{
    UINT8 i = 0;

    /* <BearType>,<Param> */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tBDescp.bBearType);

    if(tBDescp.bParamLen <= ZPS_APUICC_USAT_MAX_BEARPRAM_LEN)
    {
        for (i = 0; i < tBDescp.bParamLen; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", tBDescp.abParam[i]);
        }
    }

    return TRUE;
}

/*102.223
  8.9      Item 
  8.24     Items next action indicator 
  8.32     Item icon identifier list 
  8.73     Item text attribute list*/
BOOL zAt_EncUsatItemInfo(CHAR * pStrTarget, T_zApUicc_USAT_ItemInfo tItemInfo, 
    UINT8 iInfoNAIFg, UINT8 iInfoIconFg, UINT8 iInfoTxtAtrFg)
{
    UINT8 i = 0;
    /* <ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>] */

    /* <ItemID>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", tItemInfo.bItemID);

    /* [<ItemNAI>], */
    if (iInfoNAIFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", tItemInfo.bItemNAI);
    }
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<ItemIconID>], */
    if (iInfoIconFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", tItemInfo.bItemIconID);
    }
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<ItemTxtStr>], */
    if (tItemInfo.tTxtStr.bAlphaLen > 0)
    {
        zAt_EncUsatAlpha(pStrTarget, tItemInfo.tTxtStr);
        pStrTarget += strlen((const char *)pStrTarget);
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <TxtAtr> */
    if (iInfoTxtAtrFg == 1)
    {
        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", tItemInfo.abTxtAtr[i]);
        }
    }

    return TRUE;
}

VOID zAt_EncUsatMTimeCmd(CHAR * pStrTarget, T_zApUicc_USAT_MTimeCmd * pMTimeCmd)
{
    /* <CmdNum>,<CmdQual>, */
    zAt_EncUsatCmdDtls(pStrTarget, pMTimeCmd->tCmd);
}

VOID zAt_EncUsatPolloffCmd(CHAR * pStrTarget, T_zApUicc_USAT_PollOffCmd * pPolloffimeCmd)
{
    /* <CmdNum>,<CmdQual>, */
    zAt_EncUsatCmdDtls(pStrTarget, pPolloffimeCmd->tCmd);
}

VOID zAt_EncUsatRefreshCmd(CHAR * pStrTarget, T_zApUicc_USAT_RefreshCmd * pRefreshCmd)
{
    /* <CmdNum>,<CmdQual>,[<Aid>],<FileNum>[,<Fid>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pRefreshCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Aid>] */
    zAt_EncUsatAid(pStrTarget, pRefreshCmd->tAid);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* ,<FileNum>[,<Fid>] */
    zAt_EncUsatFileList(pStrTarget, pRefreshCmd->tFileList);    
}

VOID zAt_EncUsatPollCmd(CHAR * pStrTarget, T_zApUicc_USAT_PollCmd * pPollCmd)
{
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pPollCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <TimeUnit>,<TimeFreq> */
    zAt_EncUsatDura(pStrTarget, pPollCmd->tDura);
}

VOID zAt_EncUsatSetUpEvtListCmd(CHAR * pStrTarget, T_zApUicc_USAT_SetUpEvtListCmd * pSetUpEvtListCmd)
{
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSetUpEvtListCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <EvtNum>,<EvtLst> */
    zAt_EncUsatEvtLst(pStrTarget, pSetUpEvtListCmd->tEvtList);
}
#ifdef NAS_FULL_USAT_SUPPORT
BOOL zAt_EncUsatSetupCallCmd(CHAR * pStrTarget, T_zApUicc_USAT_SetupCallCmd * pSetupCallCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,[<AlphaCnf>],<Ton>,<NPI>,<CallNum>,[<subaddr>],
       [<Capa>],[<TimeUnit>,<TimeFreq>],[<IconWithDescCnf>,<IconIdCnf>],
       [<AlphaStup>],[<IconWithDescStup>,<IconIdStup>],[<TxtAtrCnf>][,<TxtAtrStup>] */

    /* <CmdNum>,<CmdQual>, */

    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSetupCallCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<AlphaCnf>], */
    zAt_EncUsatAlpha(pStrTarget, pSetupCallCmd->tAlphaCnf);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Ton>,<NPI>,<CallNum>*/
    zAt_EncUsatAddr(pStrTarget, pSetupCallCmd->tAdr);
    pStrTarget += strlen((const char *)pStrTarget);

    if((pSetupCallCmd->tSubAdr.bLen > 0&&pSetupCallCmd->tSubAdr.bLen <= Z_APUICC_USAT_MAX_SUBADR_LEN)
        ||pSetupCallCmd->tCapa.bCpaLen >0 ||
        Z_VALID == pSetupCallCmd->bDuraFg ||Z_VALID == pSetupCallCmd->bIconCnfFg||
        (pSetupCallCmd->tAlphaStup.bAlphaLen>0&&pSetupCallCmd->tAlphaStup.bAlphaLen <=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||
        Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /* [<subaddr>]*/
    zAt_EncUsatSubAddr(pStrTarget, pSetupCallCmd->tSubAdr);
    pStrTarget += strlen((const char *)pStrTarget);

    if((pSetupCallCmd->tCapa.bCpaLen >0&&pSetupCallCmd->tCapa.bCpaLen<=Z_APUICC_USAT_MAX_BC_LEN)
        ||Z_VALID == pSetupCallCmd->bDuraFg ||Z_VALID == pSetupCallCmd->bIconCnfFg
        ||(pSetupCallCmd->tAlphaStup.bAlphaLen>0 && pSetupCallCmd->tAlphaStup.bAlphaLen <=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||Z_VALID == pSetupCallCmd->bTxtAtrCnfFg
        ||Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /* [<Capa>], */
    zAt_EncUsatCapa(pStrTarget, pSetupCallCmd->tCapa);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pSetupCallCmd->bDuraFg ||Z_VALID == pSetupCallCmd->bIconCnfFg||
        (pSetupCallCmd->tAlphaStup.bAlphaLen>0 && pSetupCallCmd->tAlphaStup.bAlphaLen <= ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||
        Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<TimeUnit>,<TimeFreq>], */
    if (Z_VALID== pSetupCallCmd->bDuraFg)
    {
        pStrTarget += zAt_EncUsatDura(pStrTarget, pSetupCallCmd->tDura);
    }
    else if(Z_VALID == pSetupCallCmd->bIconCnfFg||
        (pSetupCallCmd->tAlphaStup.bAlphaLen > 0 && pSetupCallCmd->tAlphaStup.bAlphaLen <= ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||
        Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDescCnf>,<IconIdCnf>], */
    if (pSetupCallCmd->bIconCnfFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSetupCallCmd->tIconCnf);
    }
    else if((pSetupCallCmd->tAlphaStup.bAlphaLen>0 && pSetupCallCmd->tAlphaStup.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||
        Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<AlphaStup>]*/
    if((pSetupCallCmd->tAlphaStup.bAlphaLen>0 && pSetupCallCmd->tAlphaStup.bAlphaLen <= ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pSetupCallCmd->bIconStupFg||
        Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    zAt_EncUsatAlpha(pStrTarget, pSetupCallCmd->tAlphaStup);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pSetupCallCmd->bIconStupFg||Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||
        Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDescStup>,<IconIdStup>] */
    if (pSetupCallCmd->bIconStupFg == 1)
    {
       pStrTarget += zAt_EncUsatIcon(pStrTarget, pSetupCallCmd->tIconStup);
    }
    else if(Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||
                Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    if(Z_VALID == pSetupCallCmd->bTxtAtrCnfFg||
        Z_VALID == pSetupCallCmd->bTxtAtrStupFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<TxtAtrCnf>] */
    if (pSetupCallCmd->bTxtAtrCnfFg == 1)
    {
        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSetupCallCmd->abTxtAtrCnf[i]);
        }
    }

    /* [,<TxtAtrStup>] */
    if (pSetupCallCmd->bTxtAtrStupFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSetupCallCmd->abTxtAtrStup[i]);
        }
    }

    return TRUE;
}
#endif
#ifdef NAS_FULL_USAT_SUPPORT
BOOL zAt_EncUsatSndSsCmd(CHAR * pStrTarget, T_zApUicc_USAT_SndSsCmd * pSndSsCmd)
{
    UINT8 i = 0;
    BYTE bNewTxtAtrFg = Z_INVALID;

    if(pSndSsCmd->tAlpha.bAlphaLen > 0&&Z_VALID == pSndSsCmd->bTxtAtrFg)
    {
        bNewTxtAtrFg = Z_VALID;
    }
    /* [<Alpha>],<Ton>,<NPI>,<SsStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */

    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSndSsCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSndSsCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Ton>,<NPI>,<SsStr>, */
    if (!zAt_EncUsatSsStr(pStrTarget, pSndSsCmd->tSs))
    {
        return FALSE;
    }
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pSndSsCmd->bIconFg ||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>] */
    if (Z_VALID == pSndSsCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSndSsCmd->tIcon);
    }
    else if(Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSndSsCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

BOOL zAt_EncUsatSndUssdCmd(CHAR * pStrTarget, T_zApUicc_USAT_SndUssdCmd * pSndUssdCmd)
{
    UINT8 i = 0;
    /* [<Alpha>],<Dcs>,<UssdStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSndUssdCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSndUssdCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Dcs>,<UssdStr>, */
    zAt_EncUsatUssdStr(pStrTarget, pSndUssdCmd->tUssd);
    pStrTarget += strlen((const char *)pStrTarget);

    if(pSndUssdCmd->bIconFg == 1||pSndUssdCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>] */
    if (pSndUssdCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSndUssdCmd->tIcon);
    }
    else if(pSndUssdCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (pSndUssdCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSndUssdCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}
#endif
BOOL zAt_EncUsatSndSmsCmd(CHAR * pStrTarget, T_zApUicc_USAT_SndSmsCmd * pSndSmsCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,[<Alpha>],[<Ton>,<NPI>,<CallNum>],<TPdu>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSndSmsCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>]*/
    zAt_EncUsatAlpha(pStrTarget, pSndSmsCmd->tAlphaId);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Ton>,<NPI>,<CallNum>]*/
    if (Z_VALID == pSndSmsCmd->bAdrFg)
    {
        zAt_EncUsatAddr(pStrTarget, pSndSmsCmd->tAdr);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Tpdu>] */
    pStrTarget += sprintf((char *)pStrTarget, "\"");
    if (pSndSmsCmd->bTPduLength > 0 && 
        pSndSmsCmd->bTPduLength <= Z_APUICC_USAT_MAX_TPDU_LEN)
    {
        for (i = 0; i < pSndSmsCmd->bTPduLength; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSndSmsCmd->abTPduBuffer[i]);
        }
    }
    pStrTarget += sprintf((char *)pStrTarget, "\"");

    /* [<IconWithDesc>,<IconId>] */
    if (Z_VALID == pSndSmsCmd->bIconFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSndSmsCmd->tIcon);
    }
    else if(Z_VALID == pSndSmsCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == pSndSmsCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSndSmsCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}
#ifdef NAS_FULL_USAT_SUPPORT
/*102223 6.6.26    LAUNCH BROWSER */
BOOL zAt_EncUsatLaunchBrowserCmd(CHAR * pStrTarget, T_zApUicc_USAT_LaunchBrowserCmd * pLaunchBrowserCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<BrowerId>],<Url>,[<BearList>],
      [<FileNum>,<Fid>[,<Fid>]],[<CodeMode>,<Txt>],[<Alpha>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */

     /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pLaunchBrowserCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pLaunchBrowserCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<BrowerId>], */
    if (pLaunchBrowserCmd->bBrowIdFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", pLaunchBrowserCmd->bBrowerId);
    }

    if(pLaunchBrowserCmd->bUrlLen > ZPS_APUICC_USAT_MAX_URL_LEN)
    {
        return FALSE;
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Url>, */
    if(pLaunchBrowserCmd->bUrlLen <= ZPS_APUICC_USAT_MAX_URL_LEN)
    {
        for (i = 0; i < pLaunchBrowserCmd->bUrlLen; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pLaunchBrowserCmd->abUrl[i]);
        }
    }

    if(pLaunchBrowserCmd->bFileNum > ZPS_APUICC_USAT_MAX_PROFILE_LEN)
    {
        return FALSE;/*޷ֱӷ*/
    }

    if(pLaunchBrowserCmd->bBearLen > 0||
        (pLaunchBrowserCmd->bFileNum > 0&&pLaunchBrowserCmd->bFileNum<=ZPS_APUICC_USAT_MAX_PROFILE_LEN)
        ||Z_VALID == pLaunchBrowserCmd->bTxtStrFg
        ||(pLaunchBrowserCmd->tAlpha.bAlphaLen > 0&&pLaunchBrowserCmd->tAlpha.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pLaunchBrowserCmd->bIconFg ||Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /* [<BearList>], */
    for (i = 0; i < pLaunchBrowserCmd->bBearLen; i++, pStrTarget += 2)
    {
        sprintf((char *)pStrTarget, "%02X", pLaunchBrowserCmd->abBearLst[i]);
    }

    /*[<FileNum>[,<Fid>[,<Fid>]]],*/
    /*<FileNum>*/
    if((pLaunchBrowserCmd->bFileNum > 0)
        ||Z_VALID == pLaunchBrowserCmd->bTxtStrFg
        ||(pLaunchBrowserCmd->tAlpha.bAlphaLen > 0&&pLaunchBrowserCmd->tAlpha.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pLaunchBrowserCmd->bIconFg ||Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",%d,", pLaunchBrowserCmd->bFileNum);
    }
    else
    {
        return TRUE;
    }

    /* [<FileNum>[,<Fid>[,<Fid>]]], */
    for (i = 0; i < pLaunchBrowserCmd->bFileNum; i++)
    {
        zAt_EncUsatProFileRef(pStrTarget, pLaunchBrowserCmd->atProvFile[i]);
        pStrTarget += strlen((const char *)pStrTarget);

        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    if (Z_INVALID == pLaunchBrowserCmd->bTxtStrFg && 
        (pLaunchBrowserCmd->tAlpha.bAlphaLen == 0||pLaunchBrowserCmd->tAlpha.bAlphaLen>ZPS_APUICC_USAT_MAX_ALPHA_LEN)&&
        Z_INVALID == pLaunchBrowserCmd->bIconFg && Z_INVALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget--;
        *pStrTarget = 0;
        return TRUE;
    }

    /* [<CodeMode>,<Txt>], */
    if (Z_VALID == pLaunchBrowserCmd->bTxtStrFg)
    {
        zAt_EncUsatTxtStr(pStrTarget, pLaunchBrowserCmd->tTxtStr);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if((pLaunchBrowserCmd->tAlpha.bAlphaLen > 0 &&pLaunchBrowserCmd->tAlpha.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pLaunchBrowserCmd->bIconFg ||Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    if((pLaunchBrowserCmd->tAlpha.bAlphaLen > 0 &&pLaunchBrowserCmd->tAlpha.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pLaunchBrowserCmd->bIconFg ||Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pLaunchBrowserCmd->tAlpha);

    if(Z_VALID == pLaunchBrowserCmd->bIconFg ||
        Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += strlen((const char *)pStrTarget);
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pLaunchBrowserCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pLaunchBrowserCmd->tIcon);
    }
    else if(Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == pLaunchBrowserCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pLaunchBrowserCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

BOOL zAt_EncUsatPlayToneCmd(CHAR * pStrTarget, T_zApUicc_USAT_PlayToneCmd * pPlayToneCmd)
{
    UINT8 i = 0;
    /* <SDvcId>,<DDvcId>,[<Alpha>],[<Tone>],[<TimeUnit>,<TimeFreq>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pPlayToneCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>*/
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pPlayToneCmd->tDevId);

    if((pPlayToneCmd->tAlpha.bAlphaLen > 0&&pPlayToneCmd->tAlpha.bAlphaLen<=ZPS_APUICC_USAT_MAX_ALPHA_LEN)
        ||Z_VALID == pPlayToneCmd->bToneFg ||Z_VALID == pPlayToneCmd->bDuraFg 
        ||Z_VALID == pPlayToneCmd->bIconFg ||Z_VALID == pPlayToneCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pPlayToneCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pPlayToneCmd->bToneFg ||Z_VALID == pPlayToneCmd->bDuraFg ||
        Z_VALID == pPlayToneCmd->bIconFg ||Z_VALID == pPlayToneCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<Tone>], */
    if (Z_VALID == pPlayToneCmd->bToneFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", pPlayToneCmd->bTone);
    }

    if(Z_VALID == pPlayToneCmd->bDuraFg||Z_VALID == pPlayToneCmd->bIconFg||
        Z_VALID == pPlayToneCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<TimeUnit>,<TimeFreq>]*/
    if (pPlayToneCmd->bDuraFg == 1)
    {
        pStrTarget += zAt_EncUsatDura(pStrTarget, pPlayToneCmd->tDura);
    }
    else if(Z_VALID == pPlayToneCmd->bIconFg||
                Z_VALID == pPlayToneCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>]*/
    if (pPlayToneCmd->bIconFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pPlayToneCmd->tIcon);
    }
    else if(Z_VALID == pPlayToneCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (pPlayToneCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pPlayToneCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}
#endif
#ifdef USAT_USER_REF
BOOL zAt_EncUsatDisPlayTxtCmd(CHAR * pStrTarget, T_zApUicc_USAT_DisPlayTxtCmd * pDisPlayTxtCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>],[<ImtRspExt>],[<TimeUnit>,<TimeFreq>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pDisPlayTxtCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <CodeMode>,<Txt> */
    zAt_EncUsatTxtStr(pStrTarget, pDisPlayTxtCmd->tTxtStr);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pDisPlayTxtCmd->bIconFg || Z_VALID == pDisPlayTxtCmd->bImtRspFg||
        Z_VALID == pDisPlayTxtCmd->bDuraFg ||Z_VALID == pDisPlayTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>], */
    if (pDisPlayTxtCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pDisPlayTxtCmd->tIcon);
    }
    else if(Z_VALID == pDisPlayTxtCmd->bImtRspFg||
                Z_VALID == pDisPlayTxtCmd->bDuraFg ||
                Z_VALID == pDisPlayTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<ImtRspExt>], */
    if (pDisPlayTxtCmd->bImtRspFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",%d", pDisPlayTxtCmd->bImtRspFg);
    }
    else if(Z_VALID == pDisPlayTxtCmd->bDuraFg ||
                Z_VALID == pDisPlayTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<TimeUnit>,<TimeFreq>], */
    if (Z_VALID == pDisPlayTxtCmd->bDuraFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatDura(pStrTarget, pDisPlayTxtCmd->tDura);
    }
    else if(pDisPlayTxtCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (pDisPlayTxtCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pDisPlayTxtCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


BOOL zAt_EncUsatGetInkeyCmd(CHAR * pStrTarget, T_zApUicc_USAT_GetInkeyCmd * pGetInkeyCmd)
{
    UINT8 i = 0;

    /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>],[<TimeUnit>,<TimeFreq>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pGetInkeyCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <CodeMode>,<Txt>, */
    zAt_EncUsatTxtStr(pStrTarget, pGetInkeyCmd->tTxtStr);
    pStrTarget += strlen((const char *)pStrTarget);
    if(pGetInkeyCmd->bIconFg == 1||pGetInkeyCmd->bDuraFg == 1||pGetInkeyCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>], */
    if (pGetInkeyCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pGetInkeyCmd->tIcon);
    }
    else if(pGetInkeyCmd->bDuraFg == 1 || pGetInkeyCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<TimeUnit>,<TimeFreq>], */
    if (pGetInkeyCmd->bDuraFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatDura(pStrTarget, pGetInkeyCmd->tDura);
    }
    else if(pGetInkeyCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (pGetInkeyCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pGetInkeyCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


BOOL zAt_EncUsatGetInputCmd(CHAR * pStrTarget, T_zApUicc_USAT_GetInputCmd * pGetInputCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,<MinRspLen>,<MaxRspLen>,[<DefCodeMode>,<DefTxt>],
       [<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pGetInputCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <CodeMode>,<Txt>, */
    zAt_EncUsatTxtStr(pStrTarget, pGetInputCmd->tTxtStr);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <MinRspLen>,<MaxRspLen>, */
    pStrTarget += zAt_EncUsatRspLen(pStrTarget, pGetInputCmd->tRspLen);

    if(Z_VALID == pGetInputCmd->bDefTxtFg ||Z_VALID == pGetInputCmd->bIconFg||Z_VALID == pGetInputCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<DefCodeMode>,<DefTxt>] */
    if (Z_VALID == pGetInputCmd->bDefTxtFg)
    {
        zAt_EncUsatDefTxt(pStrTarget, pGetInputCmd->tDefTxt);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == pGetInputCmd->bIconFg||pGetInputCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pGetInputCmd->bIconFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pGetInputCmd->tIcon);
    }
    else if(Z_VALID == pGetInputCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == pGetInputCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pGetInputCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*102223 6.6.8     SELECT ITEM */
BOOL zAt_EncUsatSelectItemCmd(CHAR * pStrTarget, T_zApUicc_USAT_SelectItemCmd * pSelectItemCmd)
{
    UINT8 i = 0;
    /* <CmdNum>,<CmdQual>,[<Alpha>],<ItemNum>[,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],
      [<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]],
      [<ItemId>],<ItemLstQuf>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    if (pSelectItemCmd->bItemNum > Z_APUICC_USAT_MAX_ITEM_NUM)
    {
        pSelectItemCmd->bItemNum = Z_APUICC_USAT_MAX_ITEM_NUM;
    }
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSelectItemCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSelectItemCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);

    /* ,<ItemNum>, */
    pStrTarget += sprintf((char *)pStrTarget, ",%d,", pSelectItemCmd->bItemNum);

    /* <ItemNum>[,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]], */
    for (; i < pSelectItemCmd->bItemNum; i++)
    {
        zAt_EncUsatItemInfo(pStrTarget, pSelectItemCmd->atItmInfo[i], pSelectItemCmd->bInfoNAIFg, pSelectItemCmd->bInfoIconFg, pSelectItemCmd->bInfoTxtAtrFg);
        pStrTarget += strlen((const char *)pStrTarget);
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<ItemId>], */
    if (pSelectItemCmd->bItemIdFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", pSelectItemCmd->bItemId);
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <ItemLstQuf>, */
    if(pSelectItemCmd->bItemNum > 0)
    {
        pStrTarget += sprintf((char *)pStrTarget, "%d", pSelectItemCmd->bItemLstQuf);
    }

    if(pSelectItemCmd->bIconFg == 1||pSelectItemCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>] */
    if (pSelectItemCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSelectItemCmd->tIcon);
    }
    else if(pSelectItemCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (pSelectItemCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSelectItemCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}
#endif
/*102223 6.6.8     SETUP MENU */
BOOL zAt_EncUsatSetUpMenuCmd(CHAR * pStrTarget, T_zApUicc_USAT_SetUpMenuCmd * pSetUpMenuCmd)
{
    UINT8 i = 0;

    /* <CmdNum>,<CmdQual>,[<Alpha>],<ItemNum>[,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],
      [<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]],
      <ItemLstQuf>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    if (pSetUpMenuCmd->bItemNum > Z_APUICC_USAT_MAX_ITEM_NUM)
    {
        pSetUpMenuCmd->bItemNum = Z_APUICC_USAT_MAX_ITEM_NUM;
    }
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSetUpMenuCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSetUpMenuCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);

    /* ,<ItemNum>, */
    pStrTarget += sprintf((char *)pStrTarget, ",%d,", pSetUpMenuCmd->bItemNum);

    /* [<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]], */
    for (; i < pSetUpMenuCmd->bItemNum; i++)
    {
        zAt_EncUsatItemInfo(pStrTarget, pSetUpMenuCmd->atItmInfo[i], pSetUpMenuCmd->bInfoNAIFg, pSetUpMenuCmd->bInfoIconFg, pSetUpMenuCmd->bInfoTxtAtrFg);
        pStrTarget += strlen((const char *)pStrTarget);
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    if(pSetUpMenuCmd->bItemNum > 0)
    {
        /* <ItemLstQuf>, */
        pStrTarget += sprintf((char *)pStrTarget, "%d", pSetUpMenuCmd->bItemLstQuf);
    }

    /* [<IconWithDesc>,<IconId>], */
    if (pSetUpMenuCmd->bIconFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSetUpMenuCmd->tIcon);
    }
    else if(pSetUpMenuCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (pSetUpMenuCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSetUpMenuCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*6.6.15    PROVIDE LOCAL INFORMATION */
VOID zAt_EncUsatLocInfoCmd(CHAR * pStrTarget, T_zApUicc_USAT_LocInfoCmd * pLocInfoCmd)
{
    /* <CmdNum>,<CmdQual> */
    zAt_EncUsatCmdDtls(pStrTarget, pLocInfoCmd->tCmd);
}
#ifdef NAS_FULL_USAT_SUPPORT
/*102223 6.6.21    TIMER MANAGEMENT */
VOID zAt_EncUsatTimrMngCmd(CHAR * pStrTarget, T_zApUicc_USAT_TimrMngCmd * pTimrMngCmd)
{
    /* <CmdNum>,<CmdQual>,<TimerId>[,<TimerVal>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pTimrMngCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <TimerId>[,<TimerVal>] */
    zAt_EncUsatTimerInfo(pStrTarget, pTimrMngCmd->tTimeInfo);
}

/*102223 6.6.22    SET UP IDLE MODE TEXT */
BOOL zAt_EncUsatSetIdleModTxtCmd(CHAR * pStrTarget, T_zApUicc_USAT_SetIdleModTxtCmd * pSetIdleModTxtCmd)
{
    UINT8 i = 0;

    /* <SDvcId>,<DDvcId>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSetIdleModTxtCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pSetIdleModTxtCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <CodeMode>,<Txt>, */
    zAt_EncUsatTxtStr(pStrTarget, pSetIdleModTxtCmd->tTxtStr);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pSetIdleModTxtCmd->bIconFg ||
        Z_VALID == pSetIdleModTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>]*/
    if (Z_VALID == pSetIdleModTxtCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSetIdleModTxtCmd->tIcon);
    }
    else if(Z_VALID == pSetIdleModTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == pSetIdleModTxtCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSetIdleModTxtCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*6.6.17    PERFORM CARD APDU */
BOOL zAt_EncUsatPerformCardApduCmd(CHAR * pStrTarget, T_zApUicc_USAT_PerformCardApduCmd * pPerformCardApduCmd)
{
    UINT8 i = 0;

    /* <SDvcId>,<DDvcId>,<Cla>,<Ins>,<P1>,<P2>,[<Lc>],[<PduData>],[<Le>] */
    /* <CmdNum>,<CmdQual>, */
    if (pPerformCardApduCmd->tCApdu.bLc > 236)
    {
        return FALSE;
    }
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pPerformCardApduCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pPerformCardApduCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Cla>,<Ins>,<P1>,<P2>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,%d,%d,%d", pPerformCardApduCmd->tCApdu.bCla, pPerformCardApduCmd->tCApdu.bIns,
        pPerformCardApduCmd->tCApdu.bP1, pPerformCardApduCmd->tCApdu.bP2);

    if(Z_VALID == pPerformCardApduCmd->tCApdu.bLcFg ||
        Z_VALID == pPerformCardApduCmd->tCApdu.bLeFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<Lc>], */
    if (Z_VALID == pPerformCardApduCmd->tCApdu.bLcFg)
    {
        sprintf((char *)pStrTarget, "%d", pPerformCardApduCmd->tCApdu.bLc);
        pStrTarget += strlen((const char *)pStrTarget);
    }

    if((Z_VALID == pPerformCardApduCmd->tCApdu.bLcFg&&
        pPerformCardApduCmd->tCApdu.bLc > 0&&pPerformCardApduCmd->tCApdu.bLc<=236)
        ||Z_VALID == pPerformCardApduCmd->tCApdu.bLeFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<PduData>]*/
    if (Z_VALID == pPerformCardApduCmd->tCApdu.bLcFg&&
        pPerformCardApduCmd->tCApdu.bLc > 0&&pPerformCardApduCmd->tCApdu.bLc<=236)
    {
        pStrTarget += sprintf((char *)pStrTarget, "\"");

        for (i = 0; i < pPerformCardApduCmd->tCApdu.bLc; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pPerformCardApduCmd->tCApdu.abData[i]);
        }

        pStrTarget += sprintf((char *)pStrTarget, "\"");
    }

    /* [,<Le>] */
    if (Z_VALID == pPerformCardApduCmd->tCApdu.bLeFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        sprintf((char *)pStrTarget, "%d", pPerformCardApduCmd->tCApdu.bLe);
    }

    return TRUE;
}


/*102223 6.6.19    POWER ON CARD */
VOID zAt_EncUsatPwrOnCardCmd(CHAR * pStrTarget, T_zApUicc_USAT_PwrOnCardCmd * pPwrOnCardCmd)
{
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pPwrOnCardCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
    zAt_EncUsatDvcId(pStrTarget, pPwrOnCardCmd->tDvcId);
}

/*102223 6.6.18    POWER OFF CARD */
VOID zAt_EncUsatPwrOffCardCmd(CHAR * pStrTarget, T_zApUicc_USAT_PwrOffCardCmd * pPwrOffCardCmd)
{
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pPwrOffCardCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
   zAt_EncUsatDvcId(pStrTarget, pPwrOffCardCmd->tDvcId);
}

/*102223 6.6.18    POWER OFF CARD */
VOID zAt_EncUsatGetReaderStatusCmd(CHAR * pStrTarget, T_zApUicc_USAT_GetReaderStatusCmd * pGetReaderStatusCmd)
{
    /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId> */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pGetReaderStatusCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
    zAt_EncUsatDvcId(pStrTarget, pGetReaderStatusCmd->tDvcId);
}

/*102223 6.6.23    RUN AT COMMAND */
BOOL zAt_EncUsatRunATCmd(CHAR * pStrTarget, T_zApUicc_USAT_RunATCmd * pRunATCmd)
{
    UINT8 i = 0;

    /* <SDvcId>,<DDvcId>,[<Alpha>],<AtCmdStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pRunATCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pRunATCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pRunATCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",\"");

    /* <AtCmdStr>, */
    for (i = 0; i < pRunATCmd->bAtStrLen; i++, pStrTarget++)
    {
        sprintf((char *)pStrTarget, "%c", pRunATCmd->abAtStr[i]);
    }

    pStrTarget += sprintf((char *)pStrTarget, "\"");

    if(pRunATCmd->bIconFg == 1 || pRunATCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>], */
    if (pRunATCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pRunATCmd->tIcon);
    }
    else if(pRunATCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (pRunATCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pRunATCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


/*102223 6.6.25    LANGUAGE NOTIFICATION */
VOID zAt_EncUsatLgNoticeCmd(CHAR * pStrTarget, T_zApUicc_USAT_LgNoticeCmd * pLgNoticeCmd)
{
    UINT8 i = 0;

    /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>[,<Lang>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pLgNoticeCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pLgNoticeCmd->tDvcId);
    
    /* [,<Lang>] */
    if (pLgNoticeCmd->bLgFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < 2; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pLgNoticeCmd->abLg[i]);
        }
    }
}
#endif
BOOL zAt_EncUsatOpenChnlCmd(CHAR * pStrTarget, T_zApUicc_USAT_OpenChnlCmd * pOpenChnlCmd)
{
    UINT8 i = 0;
    BYTE bNewTxtAtrFg = Z_INVALID;
    /*102223 6.6.27.1 <Alpha><TxtAtr>ſܴ*/
    if(pOpenChnlCmd->tAlpha.bAlphaLen > 0 && Z_VALID == pOpenChnlCmd->bTxtAtrFg)
    {
        bNewTxtAtrFg = Z_VALID;
    }

    /* <CmdNum>,<CmdQual>,[<Alpha>],[<IconWithDesc>,<IconId>],<Ton>,<NPI>,<CallNum>,[<subaddr>],
      [<TimeUnit1>,<TimeFreq1>],[<TimeUnit2>,<TimeFreq2>],<BearType>,<Param>,<BufSize>,[<networkname>],
      [<OadrType>,<Oadr>],[<LoginCodeMode>,<LoginTxt>],[<PswdCodeMode>,<PswdTxt>],
      [<PortNum>,<TranProType>],[<DataAdrType>,<DataAdr>],[<CodeType>,<RemAdr>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pOpenChnlCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pOpenChnlCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pOpenChnlCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pOpenChnlCmd->tIcon);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <Ton>,<NPI>,<CallNum>, */
    zAt_EncUsatAddr(pStrTarget, pOpenChnlCmd->tAdr);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<subaddr>], */
    zAt_EncUsatSubAddr(pStrTarget, pOpenChnlCmd->tSubAdr);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<TimeUnit1>,<TimeFreq1>], */
    if (Z_VALID == pOpenChnlCmd->bDura1Fg)
    {
        pStrTarget += zAt_EncUsatDura(pStrTarget, pOpenChnlCmd->tDura1);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<TimeUnit2>,<TimeFreq2>], */
    if (Z_VALID == pOpenChnlCmd->bDura2Fg)
    {
        pStrTarget += zAt_EncUsatDura(pStrTarget, pOpenChnlCmd->tDura2);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <BearType>,<Param>, */
    if (!zAt_EncUsatBDescp(pStrTarget, pOpenChnlCmd->tBdesc))
    {
        return FALSE;/*ʧϱĩβܻж*/
    }
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <BufSize>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d", pOpenChnlCmd->wBufSize);

    if(Z_VALID == pOpenChnlCmd->bOAdrFg||
        (pOpenChnlCmd->tNetName.bLen > 0&&pOpenChnlCmd->tNetName.bLen <= ZPS_APUICC_USAT_MAX_NETNAME_LEN)||
        Z_VALID == pOpenChnlCmd->bLogFg ||Z_VALID == pOpenChnlCmd->bPswdFg||
        Z_VALID == pOpenChnlCmd->bTrLvFg ||Z_VALID == pOpenChnlCmd->bDataAdrFg || 
        Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /*[<networkname>]*/
    zAt_EncUsatNetName(pStrTarget, pOpenChnlCmd->tNetName);
	pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pOpenChnlCmd->bOAdrFg||
        Z_VALID == pOpenChnlCmd->bLogFg ||Z_VALID == pOpenChnlCmd->bPswdFg||
        Z_VALID == pOpenChnlCmd->bTrLvFg ||Z_VALID == pOpenChnlCmd->bDataAdrFg || 
        Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /* [<OadrType>,<Oadr>], */
    if (Z_VALID == pOpenChnlCmd->bOAdrFg)
    {
        if (!zAt_EncUsatOthrAddr(pStrTarget, pOpenChnlCmd->tOadr))
        {
            return FALSE;/*ʧϱĩβܻж*/
        }
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == pOpenChnlCmd->bLogFg ||Z_VALID == pOpenChnlCmd->bPswdFg||
        Z_VALID == pOpenChnlCmd->bTrLvFg ||Z_VALID == pOpenChnlCmd->bDataAdrFg || 
        Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }
    else
    {
        return TRUE;
    }

    /* [<LoginCodeMode>,<LoginTxt>], */
    if (Z_VALID == pOpenChnlCmd->bLogFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        zAt_EncUsatTxtStr(pStrTarget, pOpenChnlCmd->tLogin);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == pOpenChnlCmd->bPswdFg||Z_VALID == pOpenChnlCmd->bTrLvFg ||
        Z_VALID == pOpenChnlCmd->bDataAdrFg || Z_VALID == pOpenChnlCmd->bRemAdrFg||
        Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }
    else
    {
        return TRUE;
    }

    /* [<PswdCodeMode>,<PswdTxt>], */
    if (Z_VALID == pOpenChnlCmd->bPswdFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        zAt_EncUsatTxtStr(pStrTarget, pOpenChnlCmd->tPswd);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == pOpenChnlCmd->bTrLvFg ||Z_VALID == pOpenChnlCmd->bDataAdrFg || 
        Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }
    else
    {
        return TRUE;
    }

    /* [<PortNum>,<TranProType>], */
    if (Z_VALID == pOpenChnlCmd->bTrLvFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIntfcTnsptLv(pStrTarget, pOpenChnlCmd->tTrLv);
    }
    else if(Z_VALID == pOpenChnlCmd->bDataAdrFg || 
        Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }
    else
    {
     return TRUE;
    }

    /* [<DataAdrType>,<DataAdr>] */
    if (Z_VALID == pOpenChnlCmd->bDataAdrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        zAt_EncUsatOthrAddr(pStrTarget, pOpenChnlCmd->tDataAdr);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == pOpenChnlCmd->bRemAdrFg||Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }
    else
    {
        return TRUE;
    }

    /* [<CodeType>,<RemAdr>] */
    if (Z_VALID == pOpenChnlCmd->bRemAdrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        if (!zAt_EncUsatRmtAddr(pStrTarget, pOpenChnlCmd->tRemAdr))
        {
            return FALSE;
        }
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pOpenChnlCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


/*102223 6.6.28    CLOSE CHANNEL */
BOOL zAt_EncUsatCloseChnlCmd(CHAR * pStrTarget, T_zApUicc_USAT_CloseChnlCmd * pCloseChnlCmd)
{
    UINT8 i = 0;

    /* <SDvcId>,<DDvcId>,[<Alpha>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pCloseChnlCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pCloseChnlCmd->tDvcId);

    if((pCloseChnlCmd->tAlpha.bAlphaLen > 0 && pCloseChnlCmd->tAlpha.bAlphaLen <= ZPS_APUICC_USAT_MAX_ALPHA_LEN)
    ||Z_VALID == pCloseChnlCmd->bIconFg ||Z_VALID == pCloseChnlCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pCloseChnlCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);

    if(Z_VALID == pCloseChnlCmd->bIconFg ||
        Z_VALID == pCloseChnlCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [<IconWithDesc>,<IconId>] */
    if (Z_VALID == pCloseChnlCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pCloseChnlCmd->tIcon);
    }
    else if(Z_VALID == pCloseChnlCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == pCloseChnlCmd->bTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pCloseChnlCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


/*102223 6.6.29    RECEIVE DATA */
BOOL zAt_EncUsatRsvDataCmd(CHAR * pStrTarget, T_zApUicc_USAT_RsvDataCmd * pRsvDataCmd)
{
    UINT8 i = 0;

    /* <DesDevID>,[<Alpha>],[<IconWithDesc>,<IconId>],<DataLen>[,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pRsvDataCmd->tCmd);

    /* <DesDevID>, */
    pStrTarget += sprintf((char *)pStrTarget, ",%d,", pRsvDataCmd->bDesDevID);

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pRsvDataCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<IconWithDesc>,<IconId>], */
    if (pRsvDataCmd->bIconFg == 1)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pRsvDataCmd->tIcon);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    /* ,<DataLen> */
    pStrTarget += sprintf((char *)pStrTarget, ",%d", pRsvDataCmd->bDataLen);

    /* [,<TxtAtr>] */
    if (pRsvDataCmd->bTxtAtrFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pRsvDataCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*6.6.30    SEND DATA */
BOOL zAt_EncUsatSndDataCmd(CHAR * pStrTarget, T_zApUicc_USAT_SndDataCmd * pSndDataCmd)
{
    UINT8 i = 0;
    BYTE bNewTxtAtrFg = Z_INVALID;

    if(pSndDataCmd->tAlpha.bAlphaLen > 0 && Z_VALID == pSndDataCmd->bTxtAtrFg)
    {
        bNewTxtAtrFg = Z_VALID;
    }
    /* <CmdNum>,<CmdQual>,<DesDevID>,[<Alpha>],[<IconWithDesc>,<IconId>],<ChnlData>[,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSndDataCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <DesDevID>, */
    pStrTarget += sprintf((char *)pStrTarget, "%d,", pSndDataCmd->bDesDevID);

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSndDataCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pSndDataCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSndDataCmd->tIcon);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* ,<ChnlData> */
    zAt_EncUsatChnlData(pStrTarget, pSndDataCmd->tChnlData);
    pStrTarget += strlen((const char *)pStrTarget);

    /* [,<TxtAtr>] */
    if (Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSndDataCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*102223 6.6.31    GET CHANNEL STATUS */
VOID zAt_EncUsatGetChnlStatusCmd(CHAR * pStrTarget, T_zApUicc_USAT_GetChnlStatusCmd * pGetChnlStatusCmd)
{
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pGetChnlStatusCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId> */
    zAt_EncUsatDvcId(pStrTarget, pGetChnlStatusCmd->tDvcId);
}

#ifdef NAS_FULL_USAT_SUPPORT
/*102223 6.6.32    SERVICE SEARCH */
BOOL zAt_EncUsatSrvSearchCmd(CHAR * pStrTarget, T_zApUicc_USAT_SrvSearchCmd * pSrvSearchCmd)
{
    UINT8 i = 0;
    BYTE bNewTxtAtrFg = Z_INVALID;

    if(pSrvSearchCmd->tAlpha.bAlphaLen > 0&&Z_VALID == pSrvSearchCmd->bTxtAtr)
    {
        bNewTxtAtrFg = Z_VALID;
    }

    /* <SDvcId>,<DDvcId>,[<Alpha>],[<IconWithDesc>,<IconId>],<BearId>,<SrvSrch>,
      [<LBType>,<Filer>][,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pSrvSearchCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pSrvSearchCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pSrvSearchCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pSrvSearchCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pSrvSearchCmd->tIcon);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <BearId>,<SrvSrch>, */
    zAt_EncUsatSrvSrch(pStrTarget, pSrvSearchCmd->tSrvSrch);
    pStrTarget += strlen((const char *)pStrTarget);

    /* [<LBType>,<Filer>] */
    if (Z_VALID == pSrvSearchCmd->bDvcFiltFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        zAt_EncUsatDvcFilter(pStrTarget, pSrvSearchCmd->tDvcFilter);
        pStrTarget += strlen((const char *)pStrTarget);
    }
    else if(Z_VALID == bNewTxtAtrFg)
    {
         pStrTarget += sprintf((char *)pStrTarget, ",,");
    }

    /* [,<TxtAtr>] */
    if (Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pSrvSearchCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}


/*102223 6.6.33    GET SERVICE INFORMATION */
BOOL zAt_EncUsatGetSrvInfoCmd(CHAR * pStrTarget, T_zApUicc_USAT_GetSrvInfoCmd * pGetSrvInfoCmd)
{
    UINT8 i = 0;
    BYTE bNewTxtAtrFg = Z_INVALID;

    if(pGetSrvInfoCmd->tAlpha.bAlphaLen > 0&&Z_VALID == pGetSrvInfoCmd->bTxtAtr)
    {
        bNewTxtAtrFg = Z_VALID;
    }
    /* [<Alpha>],[<IconWithDesc>,<IconId>],<BearType>,<AtrInfo>[,<TxtAtr>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pGetSrvInfoCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<Alpha>], */
    zAt_EncUsatAlpha(pStrTarget, pGetSrvInfoCmd->tAlpha);
    pStrTarget += strlen((const char *)pStrTarget);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* [<IconWithDesc>,<IconId>], */
    if (Z_VALID == pGetSrvInfoCmd->bIconFg)
    {
        pStrTarget += zAt_EncUsatIcon(pStrTarget, pGetSrvInfoCmd->tIcon);
    }
    else
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
    }

    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <BearType>,<AtrInfo> */
    zAt_EncUsatAtrInfo(pStrTarget, pGetSrvInfoCmd->tAtrInfo);
    pStrTarget += strlen((const char *)pStrTarget);

    /* [,<TxtAtr>] */
    if (Z_VALID == bNewTxtAtrFg)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");

        for (i = 0; i < Z_APUICC_USAT_MAX_TXTATTR_LEN; i++, pStrTarget += 2)
        {
            sprintf((char *)pStrTarget, "%02X", pGetSrvInfoCmd->abTxtAtr[i]);
        }
    }

    return TRUE;
}

/*102223 6.6.34    DECLARE SERVICE */
VOID zAt_EncUsatDeclearSrvCmd(CHAR * pStrTarget, T_zApUicc_USAT_DeclearSrvCmd * pDeclearSrvCmd)
{
    /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,<BearType>,<SrvID>,<SrvRecord>[,<PortNum>,<TranProType>] */
    /* <CmdNum>,<CmdQual>, */
    pStrTarget += zAt_EncUsatCmdDtls(pStrTarget, pDeclearSrvCmd->tCmd);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <SDvcId>,<DDvcId>, */
    pStrTarget += zAt_EncUsatDvcId(pStrTarget, pDeclearSrvCmd->tDvcId);
    pStrTarget += sprintf((char *)pStrTarget, ",");

    /* <BearType>,<SrvID>,<SrvRecord> */
    zAt_EncUsatSrvRec(pStrTarget, pDeclearSrvCmd->tSrvRec);
    pStrTarget += strlen((const char *)pStrTarget);

    /* [,<PortNum>,<TranProType>] */
    if (pDeclearSrvCmd->bItfTrLvFg == 1)
    {
        pStrTarget += sprintf((char *)pStrTarget, ",");
        pStrTarget += zAt_EncUsatIntfcTnsptLv(pStrTarget, pDeclearSrvCmd->tItfTrLv);
    }
}
/*102223 6.6.24    SEND DTMF COMMAND */
VOID zAt_EncUsatSendDtmfCmd(CHAR * pStrTarget, T_zApUicc_USAT_CmdDtls * pSendDtmfCmd)
{
    /* <CmdNum>,<CmdQual>, */
    zAt_EncUsatCmdDtls(pStrTarget, *pSendDtmfCmd);
}
#endif
/**************************************************************************
* ƣ zAt_PsEncUsatZupciInd
*  ZPS_ApMmia_USAT_ProvCmdInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZUPCI֪ͨ
**************************************************************************/
UINT16 zAt_PsEncUsatZupciInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApUicc_USAT_Procmd_Ind *pZupciInd = (T_zApUicc_USAT_Procmd_Ind*) pEncCmdInfo->pMsgBody;

    /* ҪıZAT2_LONG_CMD_LENȿռ */
    zOss_RetUB(pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 4);
    pStrWalk = pEncCmdInfo->pStrCmd;

    /* +ZUPCI: <proactive command type>,<proactive command data>*[,<error reason>] */
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZUPCI: %d,", g_zAt_CRLF, pZupciInd->wMsgType);

    if(pZupciInd->pBuffer == NULL)
    {
        if(pZupciInd->wMsgType == ZAT2_INVALID_VALUE) /*102223 6.6.34    DECLARE SERVICE */
        {
            /*[,<error reason>] */
            pStrWalk += sprintf((char *)pStrWalk, ",%lu", pZupciInd->dwErrCode);
        }
        else
        {
            pStrWalk--;
        }

        sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
        return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }

    switch (pZupciInd->wMsgType)
    {
    case Z_APUICC_USAT_PRO_MSGTYPE_MORETIME: /*102223 6.6.4     MORE TIME  */
        {
            zAt_EncUsatMTimeCmd(pStrWalk, (T_zApUicc_USAT_MTimeCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_POLLOFF:  /*102223 6.6.14    POLLING OFF  */
        {
            zAt_EncUsatPolloffCmd(pStrWalk, (T_zApUicc_USAT_PollOffCmd *)pZupciInd->pBuffer);
            break;
        }
#ifdef NAS_FULL_USAT_SUPPORT
    case Z_APUICC_USAT_PRO_MSGTYPE_SENDDTMF: /*102223 6.6.24    SEND DTMF COMMAND */
        {
            zAt_EncUsatSendDtmfCmd(pStrWalk, (T_zApUicc_USAT_CmdDtls *) pZupciInd->pBuffer);
        }
        break;
#endif
    case Z_APUICC_USAT_PRO_MSGTYPE_REFRESH:  /*102223 6.6.13    REFRESH  */
        {
            /* <CmdNum>,<CmdQual>,[<Aid>][,<FileNum>,<Fid>] */
            zAt_EncUsatRefreshCmd(pStrWalk, (T_zApUicc_USAT_RefreshCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_POLINTVL: /*102223 6.6.6     POLL INTERVAL */
        {
            /* <CmdNum>,<CmdQual>,<TimeUnit>,<TimeFreq> */
            zAt_EncUsatPollCmd(pStrWalk, (T_zApUicc_USAT_PollCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_STUPEVNT: /*102223 6.6.16    SET UP EVENT LIST */
        {
            /* <CmdNum>,<CmdQual>,<EvtNum>,<EvtLst> */
            zAt_EncUsatSetUpEvtListCmd(pStrWalk, (T_zApUicc_USAT_SetUpEvtListCmd *)pZupciInd->pBuffer);
            break;
        }
#ifdef NAS_FULL_USAT_SUPPORT
    case Z_APUICC_USAT_PRO_MSGTYPE_STUPCALL: /*102223 6.6.12    SET UP CALL */
        {
            /* <CmdNum>,<CmdQual>,[<AlphaCnf>],<Ton>,<NPI>,<CallNum>,[<subaddr>],
               [<Capa>],[<TimeUnit>,<TimeFreq>],[<IconWithDescCnf>,<IconIdCnf>],
               [<AlphaStup>],[<IconWithDescStup>,<IconIdStup>][[,<TxtAtrCnf>][,<TxtAtrStup>]] */
            zAt_EncUsatSetupCallCmd(pStrWalk, (T_zApUicc_USAT_SetupCallCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_SENDSS:   /*31111  6.4.11    SEND SS*/
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],<Ton>,<NPI>,<SsStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatSndSsCmd(pStrWalk, (T_zApUicc_USAT_SndSsCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_SENDUSSD: /*31111  6.4.12    SEND USSD*/
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],<Dcs>,<UssdStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatSndUssdCmd(pStrWalk, (T_zApUicc_USAT_SndUssdCmd*)pZupciInd->pBuffer);
            break;
        }
#endif
    case Z_APUICC_USAT_PRO_MSGTYPE_SENDSMS:  /*102223 6.6.9     SEND SHORT MESSAGE */
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],[<Ton>,<NPI>,<CallNum>],<TPdu>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatSndSmsCmd(pStrWalk, (T_zApUicc_USAT_SndSmsCmd*)pZupciInd->pBuffer);
            break;
        }
#ifdef NAS_FULL_USAT_SUPPORT
    case Z_APUICC_USAT_PRO_MSGTYPE_LCHBRWSR: /*102223 6.6.26    LAUNCH BROWSER */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<BrowerId>],<Url>,[<BearType>],
              [<FileNum>,<Fid>[,<Fid>]],[<CodeMode>,<Txt>],[<Alpha>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatLaunchBrowserCmd(pStrWalk, (T_zApUicc_USAT_LaunchBrowserCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_PLAYTONE: /*102223 6.6.5     PLAY TONE */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<Alpha>],[<Tone>],[<TimeUnit>,<TimeFreq>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatPlayToneCmd(pStrWalk, (T_zApUicc_USAT_PlayToneCmd *)pZupciInd->pBuffer);
            break;
        }
#endif
#ifdef USAT_USER_REF
    case Z_APUICC_USAT_PRO_MSGTYPE_DISPTEXT: /*102223 6.6.1     DISPLAY TEXT */
        {
            /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>],[<ImtRspExt>],
              [<TimeUnit>,<TimeFreq>][,<TxtAtr>] */
            zAt_EncUsatDisPlayTxtCmd(pStrWalk, (T_zApUicc_USAT_DisPlayTxtCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_GETINKEY: /*102223 6.6.2     GET INKEY */
        {
            /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>],[<TimeUnit>,<TimeFreq>][,<TxtAtr>] */
            zAt_EncUsatGetInkeyCmd(pStrWalk, (T_zApUicc_USAT_GetInkeyCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_GETINPUT: /*102223 6.6.3     GET INPUT */
        {
            /* <CmdNum>,<CmdQual>,<CodeMode>,<Txt>,<MinRspLen>,<MaxRspLen>,[<DefCodeMode>,<DefTxt>],
               [<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatGetInputCmd(pStrWalk, (T_zApUicc_USAT_GetInputCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_SELEITEM: /*102223 6.6.8     SELECT ITEM */
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],<ItemNum>,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],
              [<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]],
              [<ItemId>],<ItemLstQuf>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatSelectItemCmd(pStrWalk, (T_zApUicc_USAT_SelectItemCmd *)pZupciInd->pBuffer);
            break;
        }
#endif
    case Z_APUICC_USAT_PRO_MSGTYPE_STUPMENU: /*102223 6.6.7     SET-UP MENU */
        {
            /* <CmdNum>,<CmdQual>,<Alpha>,<ItemNum>,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],
              [<TxtAtr>][,<ItemID>,[<ItemNAI>],[<ItemIconID>],[<ItemTxtStr>],[<TxtAtr>]],
              <ItemLstQuf>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            g_zAti_atDataEx[g_zAti_CurInstance].tStUpMenu.bFg = Z_VALID;
            zOss_Memcpy(&g_zAti_atDataEx[g_zAti_CurInstance].tStUpMenu.tSetUpMenuCmd, pZupciInd->pBuffer, sizeof(T_zApUicc_USAT_SetUpMenuCmd));
            zAt_EncUsatSetUpMenuCmd(pStrWalk, (T_zApUicc_USAT_SetUpMenuCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_PLOCINFO: /*102223 6.6.15    PROVIDE LOCAL INFORMATION */
        {
            /* <CmdNum>,<CmdQual> */
            zAt_EncUsatLocInfoCmd(pStrWalk, (T_zApUicc_USAT_LocInfoCmd *)pZupciInd->pBuffer);
            break;
        }
#ifdef NAS_FULL_USAT_SUPPORT
    case Z_APUICC_USAT_PRO_MSGTYPE_TIMERMNG: /*102223 6.6.21    TIMER MANAGEMENT */
        {
            /* <CmdNum>,<CmdQual>,<TimerId>[,<TimerVal>] */
            zAt_EncUsatTimrMngCmd(pStrWalk, (T_zApUicc_USAT_TimrMngCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_STIDLTXT: /*102223 6.6.22    SET UP IDLE MODE TEXT */
        {
            /* <SDvcId>,<DDvcId>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatSetIdleModTxtCmd(pStrWalk, (T_zApUicc_USAT_SetIdleModTxtCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_PRCDAPDU: /*102223 6.6.17    PERFORM CARD APDU */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,<Cla>,<Ins>,<P1>,<P2>,[<PduData>],[<Le>] */
            zAt_EncUsatPerformCardApduCmd(pStrWalk, (T_zApUicc_USAT_PerformCardApduCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_PONCARD:  /*102223 6.6.19    POWER ON CARD */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId> */
            zAt_EncUsatPwrOnCardCmd(pStrWalk, (T_zApUicc_USAT_PwrOnCardCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_POFFCARD: /*102223 6.6.18    POWER OFF CARD */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId> */
            zAt_EncUsatPwrOffCardCmd(pStrWalk, (T_zApUicc_USAT_PwrOffCardCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_GTRDRSTA: /*102223 6.6.20    GET READER STATUS */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId> */
            zAt_EncUsatGetReaderStatusCmd(pStrWalk, (T_zApUicc_USAT_GetReaderStatusCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_RUNATCMD: /*102223 6.6.23    RUN AT COMMAND */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<Alpha>],<AtCmdStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatRunATCmd(pStrWalk, (T_zApUicc_USAT_RunATCmd*)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_LNGNOTFY: /*102223 6.6.25    LANGUAGE NOTIFICATION */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>[,<Lang>] */
            zAt_EncUsatLgNoticeCmd(pStrWalk, (T_zApUicc_USAT_LgNoticeCmd*)pZupciInd->pBuffer);
            break;
        }
#endif
    case Z_APUICC_USAT_PRO_MSGTYPE_OPENCHNL: /*102223 6.6.27    OPEN CHANNEL */
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],[<IconWithDesc>,<IconId>],<Ton>,<NPI>,<CallNum>,[<subaddr>],
              [<TimeUnit1>,<TimeFreq1>],[<TimeUnit2>,<TimeFreq2>],<BearType>,<Param>,<BufSize>,
              [<OadrType>,<Oadr>],[<LoginCodeMode>,<LoginTxt>],[<PswdCodeMode>,<PswdTxt>],
              [<PortNum>,<TranProType>],[<DataAdrType>,<DataAdr>],[<CodeType>,<RemAdr>][,<TxtAtr>] */
            zAt_EncUsatOpenChnlCmd(pStrWalk, (T_zApUicc_USAT_OpenChnlCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_CLOSCHNL: /*102223 6.6.28    CLOSE CHANNEL */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<Alpha>],[<IconWithDesc>,<IconId>][,<TxtAtr>] */
            zAt_EncUsatCloseChnlCmd(pStrWalk, (T_zApUicc_USAT_CloseChnlCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_RECVDATA: /*102223 6.6.29    RECEIVE DATA */
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],[<IconWithDesc>,<IconId>],<DataLen>[,<TxtAtr>] */
            zAt_EncUsatRsvDataCmd(pStrWalk, (T_zApUicc_USAT_RsvDataCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_SENDDATA: /*102223 6.6.30    SEND DATA */
        {
            /* <CmdNum>,<CmdQual>,<DesDevID>,[<Alpha>],[<IconWithDesc>,<IconId>],<ChnlData>[,<TxtAtr>] */
            zAt_EncUsatSndDataCmd(pStrWalk, (T_zApUicc_USAT_SndDataCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_GTCHSTAT: /*102223 6.6.31    GET CHANNEL STATUS */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId> */
            zAt_EncUsatGetChnlStatusCmd(pStrWalk, (T_zApUicc_USAT_GetChnlStatusCmd *)pZupciInd->pBuffer);
            break;
        }
#ifdef NAS_FULL_USAT_SUPPORT
    case Z_APUICC_USAT_PRO_MSGTYPE_SERVSRCH: /*102223 6.6.32    SERVICE SEARCH */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<Alpha>],[<IconWithDesc>,<IconId>],<BearId>,<SrvSrch>,
              [<LBType>,<Filer>][,<TxtAtr>] */
            zAt_EncUsatSrvSearchCmd(pStrWalk, (T_zApUicc_USAT_SrvSearchCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_GTSERINF: /*102223 6.6.33    GET SERVICE INFORMATION */
        {
            /* <CmdNum>,<CmdQual>,[<Alpha>],[<IconWithDesc>,<IconId>],<BearType>,<AtrInfo>[,<TxtAtr>] */
            zAt_EncUsatGetSrvInfoCmd(pStrWalk, (T_zApUicc_USAT_GetSrvInfoCmd *)pZupciInd->pBuffer);
            break;
        }
    case Z_APUICC_USAT_PRO_MSGTYPE_DECLSERV: /*102223 6.6.34    DECLARE SERVICE */
        {
            /* <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,<BearType>,<SrvID>,<SrvRecord>[,<PortNum>,<TranProType>] */
            zAt_EncUsatDeclearSrvCmd(pStrWalk, (T_zApUicc_USAT_DeclearSrvCmd *)pZupciInd->pBuffer);
            break;
        }
#endif
    case ZAT2_INVALID_VALUE: /*102223 6.6.34    DECLARE SERVICE */
        {
            /*[,<error reason>] */
            sprintf((char *)pStrWalk, ",%lu", pZupciInd->dwErrCode);
        }
        break;
    default:
        {
            sprintf((char *)pStrWalk, "%d,%d", ((T_zApUicc_USAT_CmdDtls *)pZupciInd->pBuffer)->bCmdNum, 
                ((T_zApUicc_USAT_CmdDtls *)pZupciInd->pBuffer)->bCmdQual);
            break;
        }
    }

    pStrWalk += strlen((const char *)pStrWalk);

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    /* ͷbufferָ */
    zAti_RetUB((VOID **)&(pZupciInd->pBuffer));
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncUsatZgiidfSetCnf
*  ZPS_ApMmia_ZGiidfCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZGIIDFѯӦ
**************************************************************************/
UINT16 zAt_PsEncUsatZgiidfSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ZGiidf_Cnf *pZgiidfSetCnf = (T_zApMmia_ZGiidf_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +ZGIIDF:<Local information Type>,<Local Info> 
     */
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZGIIDF: ", g_zAt_CRLF);

    for (i = 0; i < pZgiidfSetCnf->bDataValLen; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%02X", pZgiidfSetCnf->abImgInstncVal[i]);
    }

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncUsatZimgSetCnf
*  ZPS_ApMmia_ZImgCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZIMGѯӦ
**************************************************************************/
UINT16 zAt_PsEncUsatZimgSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_ZImg_Cnf *pZimgSetCnf = (T_zApMmia_ZImg_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    /* +ZIMG:<Image Instance Width>,<Image Instance Heigh>,<Image Coding Scheme>,
    <Image Instance Keyid>,<Offset into Image Instance File>,<Length of Image Instance Data>*/
    if (pZimgSetCnf->bImgNum > Z_APMMIA_MAX_IMG_DSCRP_NUM)
    {
        return 0;
    }
    
    if ( pZimgSetCnf->bImgNum > 0)
    {
        for (i = 0; i < pZimgSetCnf->bImgNum; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZIMG: %d,%d,%d,%d,%d,%d", g_zAt_CRLF,
                pZimgSetCnf->tImgDscrp[i].bWidth, pZimgSetCnf->tImgDscrp[i].bHeigh,
                pZimgSetCnf->tImgDscrp[i].bCodeScheme, pZimgSetCnf->tImgDscrp[i].wInstncFid,
                pZimgSetCnf->tImgDscrp[i].wOffsetIntoInstnc, pZimgSetCnf->tImgDscrp[i].wInstncDataLen);
        }
        
        pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);
    }
        
    sprintf((char *)pStrWalk, "%s", g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncUsatZuendInd
*  ZPS_ApMmia_ZImgCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZIMGѯӦ
**************************************************************************/
UINT16 zAt_PsEncUsatZuendInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zApUicc_USAT_NoprocNotify_Ind  *ptNotifyInd = (T_zApUicc_USAT_NoprocNotify_Ind*)pEncCmdInfo->pMsgBody;
    /* +ZUEND: <bIsBackToTopMenu>*/
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZUEND: %d%s", g_zAt_CRLF, ptNotifyInd->bIsBackToTopMenu, g_zAt_CRLF);
}

UINT16 zAt_PsEncPbCpbwExeCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zApMmia_PbEdit_Cnf *pCpbwExECnf = (T_zApMmia_PbEdit_Cnf*) pEncCmdInfo->pMsgBody;
#ifdef R9_SUPPORT
    if (Z_APMMIA_OPERATION_SUCCESS == pCpbwExECnf->bResult)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CPBW: %d%s%s", g_zAt_CRLF, pCpbwExECnf->wWrittenIndex,g_zAt_CRLF, g_zAt_OK);   
    }
#else 
    if (Z_APMMIA_OPERATION_SUCCESS == pCpbwExECnf->bResult)
    {
        return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s", g_zAt_OK);
    }
#endif
    return zAt_EncErrorCode(pEncCmdInfo->pStrCmd, pEncCmdInfo->cmdId, pCpbwExECnf->dwReason);
    //return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/*ѰCIDϢ*/
BOOL __ps_4g_func zAt_GetCidInfoInCgcontrdpCnf(T_zMmiaSm_Cgcontrdp_Cnf *pCgcontrdpCnf,BYTE bCid,PBYTE pIndex)
{
    BYTE i = 0;
    for(i = 0;i < pCgcontrdpCnf->bCidNum;i++)
    {
        if(pCgcontrdpCnf->atNwEstInfo[i].bCid == bCid)
        {
            *pIndex = i;
             return TRUE;
        }
    }
    return FALSE;
}
/**************************************************************************
* ƣ zAt_PsEncCgcontrdpInDualStack
*  ˫ջʱѰCIDϢͽб
* ˵ (IO)
*   ֵ TRUE ɹ  FALSE ʧ
**************************************************************************/
BOOL __ps_4g_func zAt_PsEncCgcontrdpInDualStack(T_zMmiaSm_Cgcontrdp_Cnf *pCgcontrdpCnf,BYTE bCid,CHAR ** ppStrWalk)
{
    BYTE bExCid = 0;
    //Ҫƴӵ
    if(zAti_IsMastCid(bCid,&bExCid) && bExCid != 0)
    {
        return zAt_PsEncCgcontrdpCnf2(pCgcontrdpCnf, bCid, bExCid, ppStrWalk);
    }
    else //Ҫƴӵ
    {
        return zAt_PsEncCgcontrdpCnf1(pCgcontrdpCnf, bCid,  ppStrWalk);
    }
}

/*PCscfַʱϱĵַĲ*/
BOOL __ps_4g_func zAt_EncCgcontrdpCnfByPCscfAddPara(T_ZAt2_AtCmd_CnfId AtId, CHAR ** ppStrWalk, T_zMmiaSm_Cgcontrdp_Para *pCgcontrdpPara)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo  tNwIPInfo = {0};
    
    if (ZAT2_CGCONTRDP_CNF_FORV4 == AtId)
    {
        if (Z_APMMIA_VALID == pCgcontrdpPara->atNwEstIPv4Info.bPCscfSecAddr2Flg || Z_APMMIA_VALID == pCgcontrdpPara->atNwEstIPv4Info.bPCscfSecAddr3Flg)
        {
            zOss_Memcpy(&tNwIPInfo, &pCgcontrdpPara->atNwEstIPv4Info, sizeof(T_zMmiaSm_Cgcontrdp_AddrInfo));
        }
        else
        {
            return FALSE;
        }
    }
    else if (ZAT2_CGCONTRDP_CNF_FORV6 == AtId)
    {
        if (Z_APMMIA_VALID == pCgcontrdpPara->atNwEstIPv6Info.bPCscfSecAddr2Flg || Z_APMMIA_VALID == pCgcontrdpPara->atNwEstIPv6Info.bPCscfSecAddr3Flg)
        {
            zOss_Memcpy(&tNwIPInfo, &pCgcontrdpPara->atNwEstIPv6Info, sizeof(T_zMmiaSm_Cgcontrdp_AddrInfo));
        }
        else
        {
            return FALSE;
        }
    }
    else
    {
        return FALSE;
    }

    /*뺯ʹõPCscfPriAddrPCscfSecAddrҪPCscfSecAddr2PCscfSecAddr3ֱ𸳸PCscfPriAddrPCscfSecAddr*/
    tNwIPInfo.bPCscfPriAddrFlg = tNwIPInfo.bPCscfSecAddr2Flg;
    tNwIPInfo.bPCscfSecAddrFlg = tNwIPInfo.bPCscfSecAddr3Flg;
    zOss_Memcpy(tNwIPInfo.abPCscfPriAddr, tNwIPInfo.abPCscfSecAddr2, Z_MMIASM_ADDR_MAX_LEN);
    zOss_Memcpy(tNwIPInfo.abPCscfSecAddr, tNwIPInfo.abPCscfSecAddr3, Z_MMIASM_ADDR_MAX_LEN);
    /*PCscfSecAddr2ЧPCscfSecAddr3ЧPCscfSecAddr3abPCscfPriAddr*/
    if (Z_APMMIA_INVALID == tNwIPInfo.bPCscfSecAddr2Flg && (Z_APMMIA_VALID == tNwIPInfo.bPCscfSecAddr3Flg))
    {
        zOss_Memcpy(tNwIPInfo.abPCscfPriAddr, tNwIPInfo.abPCscfSecAddr3, Z_MMIASM_ADDR_MAX_LEN);
        tNwIPInfo.bPCscfPriAddrFlg = Z_APMMIA_VALID;
        tNwIPInfo.bPCscfSecAddrFlg = Z_APMMIA_INVALID;
    }
    tNwIPInfo.bPCscfSecAddr2Flg = Z_APMMIA_INVALID;
    tNwIPInfo.bPCscfSecAddr3Flg = Z_APMMIA_INVALID;

    zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, pCgcontrdpPara);
    
    return zAt_PsEncReadCnfParse(AtId, ppStrWalk, &tNwIPInfo);
}
/**********************************************************************
:zAt_PsEncCgcontrdpCnf1
:ԲҪƴӵCIdϢб
***********************************************************************/
BOOL __ps_4g_func zAt_PsEncCgcontrdpCnf1(T_zMmiaSm_Cgcontrdp_Cnf *pCgcontrdpCnf,BYTE bCid,CHAR ** ppStrWalk)
{
    BYTE bIndex = 0;

    if(zAt_GetCidInfoInCgcontrdpCnf(pCgcontrdpCnf,bCid, &bIndex))
    {
        if(((pCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV4V6)
          ||(pCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV4))
          &&zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex])))
        {
            zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex].atNwEstIPv4Info));
            zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex]));
        }
        if(((pCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV4V6)
          ||(pCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV6))
          &&zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex])))
        {
             zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex].atNwEstIPv6Info));
             zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(pCgcontrdpCnf->atNwEstInfo[bIndex]));
        }
        return TRUE;      
    }
    return FALSE;    
}
/*************************************************************************************
:zAt_PsEncCgcontrdpCnf2
:ҪƴӵCIdϢб
*************************************************************************************/
BOOL zAt_PsEncCgcontrdpCnf2(T_zMmiaSm_Cgcontrdp_Cnf *pCgcontrdpCnf,BYTE bCid, BYTE bExCid, CHAR ** ppStrWalk)
{
    BYTE bIndex = 0;
    BYTE bIndexEx = 0;
    
    if(zAt_GetCidInfoInCgcontrdpCnf(pCgcontrdpCnf,bCid, &bIndex))
    {
        if(zAt_GetCidInfoInCgcontrdpCnf(pCgcontrdpCnf,bExCid, &bIndexEx))
        {
            T_zMmiaSm_Cgcontrdp_Cnf *ptTempCgcontrdpCnf= (T_zMmiaSm_Cgcontrdp_Cnf*)zAti_GetUB(sizeof(T_zMmiaSm_Cgcontrdp_Cnf));
            zOss_Memcpy(ptTempCgcontrdpCnf, pCgcontrdpCnf, sizeof(T_zMmiaSm_Cgcontrdp_Cnf));
            ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx].bCid = bCid;
            if(ptTempCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV4&&ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx].bPdpType == Z_APMMIA_SM_IPV6)
            {
                zAt_PsEncLteCgcontrdpCnfParam1( ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex]));
                zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex].atNwEstIPv4Info));
                zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex]));
                zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx]));
                zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx].atNwEstIPv6Info));
                zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx]));
                zAti_RetUB((VOID**)&ptTempCgcontrdpCnf);
                return TRUE;
            }
            else if(ptTempCgcontrdpCnf->atNwEstInfo[bIndex].bPdpType == Z_APMMIA_SM_IPV6&&pCgcontrdpCnf->atNwEstInfo[bIndexEx].bPdpType == Z_APMMIA_SM_IPV4)
            {
                zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx]));
                zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx].atNwEstIPv4Info));
                zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV4, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndexEx]));
                zAt_PsEncLteCgcontrdpCnfParam1(ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex]));
                zAt_PsEncReadCnfParse(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex].atNwEstIPv6Info));
                zAt_EncCgcontrdpCnfByPCscfAddPara(ZAT2_CGCONTRDP_CNF_FORV6, ppStrWalk, &(ptTempCgcontrdpCnf->atNwEstInfo[bIndex]));
                zAti_RetUB((VOID**)&ptTempCgcontrdpCnf);
                return TRUE;
            }
            zAti_RetUB((VOID**)&ptTempCgcontrdpCnf);
            return FALSE;
        }
        else
        {
            return zAt_PsEncCgcontrdpCnf1(pCgcontrdpCnf, bCid, ppStrWalk);
        }
    }
    return FALSE;
}

/* +CGCONTRDP: <cid>,<bearer_id>,<apn>[,<source address and subnet mask>[,
<gw_addr>[,<DNS_prim_addr>[,<DNS_sec_addr>[,<P-CSCF_prim_addr>[,<P-CSCF_sec_addr>]]]]]]*/
/**************************************************************************
* ƣ zAt_PsEncLteCgcontrdpCnf
*  ZPS_ApMmia_SmCgcontrdpCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CGCONTRDPѯӦ
**************************************************************************/
UINT16 __ps_4g_func zAt_PsEncLteCgcontrdpCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = NULL;
    UINT8 i = 0;
    T_zMmiaSm_Cgcontrdp_Cnf *pCgcontrdpCnf = (T_zMmiaSm_Cgcontrdp_Cnf*) pEncCmdInfo->pMsgBody;

    zAt_UpdateSpaceForLongAt(pEncCmdInfo, 4);
    pEncCmdInfo->pStrCmd[ZAT_LONG_CMD_LEN*4 - 1] = '\0';
    pStrWalk = pEncCmdInfo->pStrCmd;
    if (pCgcontrdpCnf->bCidNum > Z_MMIASM_MAX_CID_NUM)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_INVALIDPARA_ERR);
       // return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }

    if (pCgcontrdpCnf->bResult == Z_FAIL)
    {
        return  zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
        //return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    } 
    /*˫ջ*/
    if(g_zAti_atDataEx[g_zAti_CurInstance].bActCnfCid!=0xff)//ѯCIDϢ
    {
        if(!zAt_PsEncCgcontrdpInDualStack(pCgcontrdpCnf,g_zAti_atDataEx[g_zAti_CurInstance].bActCnfCid,&pStrWalk))
        {
            zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
            return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
        }
    }
    else if(g_zAti_atDataEx[g_zAti_CurInstance].bActCnfCid==0xff)//
    {
        T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
        
        for(i = 0; i<pCgcontrdpCnf->bCidNum; i++)
        {
            zOss_Memset(ptSmData, 0, sizeof(T_zDev_AtMem_SmCidData));
            zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, pCgcontrdpCnf->atNwEstInfo[i].bCid ,(PBYTE)ptSmData, g_zAti_CurInstance);
            
            if (ptSmData->bPdpInfoFg != Z_ATI_PDP_Define || ptSmData->bContFlag != Z_ATI_CONTXT_First)
            {
                continue;
            }
            if(!zAt_PsEncCgcontrdpInDualStack(pCgcontrdpCnf,pCgcontrdpCnf->atNwEstInfo[i].bCid,&pStrWalk))
            {
                zAti_RetUB((VOID**)&ptSmData);
                zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
                return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
            }
        }
        zAti_RetUB((VOID**)&ptSmData);
    }
    g_zAti_atDataEx[g_zAti_CurInstance].bActCnfCid = 0xff;//ȫ

    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);  

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/* +CGSCONTRDP: <cid>,<p_cid>,<bearer_id>*/
/**************************************************************************
* ƣ zAt_PsEncLteCgscontrdpCnf
*  ZPS_ApMmia_SmCgscontrdpCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CGSCONTRDPѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteCgscontrdpCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaSm_Cgscontrdp_Cnf *pCgscontrdpCnf = (T_zMmiaSm_Cgscontrdp_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    if (pCgscontrdpCnf->bCidNum > Z_MMIASM_MAX_CID_NUM)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_INVALIDPARA_ERR);
    }

    if (pCgscontrdpCnf->bResult == Z_FAIL)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
    } 

    if (pCgscontrdpCnf->bCidNum > 0)
    {
        for (i = 0;i < pCgscontrdpCnf->bCidNum;i++)
        {
            zAt_PsEncLteCgscontrdpCnfParam(&pStrWalk, &(pCgscontrdpCnf->tSecPdpPara[i]));
        }
    }  
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);  

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncLteEusirZetwspInd
*  ZPS_ApMmia_ZETWSPrimaryQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+zetwspѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteEusirZetwspInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaEusir_ETWSPrimary_Ind *pZetwspInd = (T_zMmiaEusir_ETWSPrimary_Ind*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem         ptAtData   = {0};
        
    /* +ZETWSP:<mode> */
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0,  (PBYTE)&ptAtData, g_zAti_CurInstance);
    if(ptAtData.bZETWSPrimarySet != Z_APMMIA_ETWS_ENABLE)
    {
        return ZAT_ENC_NONEED_CNF;
    }   

    if (Z_APMMIA_ETWS_ENABLE == ptAtData.bZETWSPrimarySet)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZETWSP: %d,%d,%d", g_zAt_CRLF,pZetwspInd->wWarningMsgId, pZetwspInd->wSerialNum, pZetwspInd->wWarningType);   
    
        if (pZetwspInd->bSecInfoPresent)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",\"");         
            
            for (i = 0; i < 50; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", pZetwspInd->abSecinfo[i]);            
            }
            
            pStrWalk += sprintf((char *)pStrWalk, "\"");         
        }
        sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);   
    }   
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncLteCbsZetwspInd
*  ZPS_ApMmia_ZETWSPrimaryQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+zetwspѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteCbsZetwspInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaCbs_Data_Ind *pZetwspInd = (T_zMmiaCbs_Data_Ind*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    WORD wWarningType   = (pZetwspInd->atBuf[0].abBuf[0] << 8) | pZetwspInd->atBuf[0].abBuf[1];
    BYTE abSecinfo[Z_MMIACBS_ETWS_SECURITYINFO_LEN] = {0};

    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if (tAtData.bZETWSPrimarySet != Z_APMMIA_ETWS_ENABLE)
    { 
        return ZAT_ENC_NONEED_CNF;
    }

    /* +ZETWSP:<mode>  617001612042 ZETWSPüϱдliangxh*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZETWSP: %d,%d,%d", g_zAt_CRLF, pZetwspInd->wMid, pZetwspInd->wSn, wWarningType);   

    if (pZetwspInd->bPriEtwsSecFlg)
    {
        zOss_Memcpy(abSecinfo, pZetwspInd->atBuf[0].abBuf + sizeof(WORD), Z_MMIACBS_ETWS_SECURITYINFO_LEN);
        pStrWalk += sprintf((char *)pStrWalk, ",\"");         
        
        for (i = 0; i < Z_MMIACBS_ETWS_SECURITYINFO_LEN; i++, pStrWalk += 2)
        {
            sprintf((char *)pStrWalk, "%02X", abSecinfo[i]); 
        }
        
        pStrWalk += sprintf((char *)pStrWalk, "\"");         
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);   
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**************************************************************************
* ƣ zAt_PsEncLteZetwssInd
*  ZPS_ApMmia_ZETWSPrimaryQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZIMGѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteZetwssInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaEusir_ETWSSecondary_Ind *pZetwssInd = (T_zMmiaEusir_ETWSSecondary_Ind*) pEncCmdInfo->pMsgBody;
    UINT16 i = 0;
    T_zDev_AtMem_Mmia_PrivateMem  ptAtData = {0};

    /* +ZETWSS:<mode> */
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&ptAtData, g_zAti_CurInstance);
    if(ptAtData.bZETWSSecondaryQuerySet != Z_APMMIA_ETWS_ENABLE)
    {
        zAti_RetUB((VOID **)&(pZetwssInd->pbWarningMsg));
        return ZAT_ENC_NONEED_CNF;
    }  

    if (Z_APMMIA_ETWS_ENABLE == ptAtData.bZETWSSecondaryQuerySet)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZETWSS: %d,%d", g_zAt_CRLF, pZetwssInd->wWarningMsgId, pZetwssInd->wSerialNum);   
    
        if (pZetwssInd->wWarningMsgLen > 0)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",\"");         
            
            for (i = 0; i < pZetwssInd->wWarningMsgLen; i++)
            {
                pStrWalk += sprintf((char *)pStrWalk, "%02X", pZetwssInd->pbWarningMsg[i]);               
            }
            
            pStrWalk += sprintf((char *)pStrWalk, "\",%d", pZetwssInd->bDataCodingScheme);         
        }
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);   
    zAti_RetUB((VOID **)&(pZetwssInd->pbWarningMsg));
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#ifdef PS_RAT_LTE
#ifdef EURRC_CSG_SUPPORT
UINT16 zAt_EncLtecsgInfo(CHAR *pStrTarget, BYTE bState, T_z_CsgInfo *ptCsgInfo)
{
    CHAR *pStrWalk = pStrTarget;
    UINT8 i = 0;

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZCSG: %d,", g_zAt_CRLF, bState);   

    // csg
    if(1 == ptCsgInfo->tAct.bGsm)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", Z_APMMIA_COPSACT_GSM);   
    }
    else if (1 == ptCsgInfo->tAct.bGsmCompact)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", Z_APMMIA_COPSACT_GSMCOMPACT);   
    }
    else if (1 == ptCsgInfo->tAct.bTD || 1 == ptCsgInfo->tAct.bW)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", Z_APMMIA_COPSACT_UTRAN);   
    }
    else if (1 == ptCsgInfo->tAct.bLte)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", Z_APMMIA_COPSACT_E_UTRAN);   
    }
    /*else
    {
       zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE, "registered, but no ACT");
    }*/
    pStrWalk += sprintf((char *)pStrWalk, ",");   
    
    pStrWalk += sprintf((char *)pStrWalk, "%lu,\"", ptCsgInfo->tCsg.tCsgInfo.tCsgId); 

    if(ptCsgInfo->tCsg.tCsgInfo.tCsgInd.bTextCsgFg == Z_APMMIA_VALID)
    {
        for (i = 0;i < ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tTextCsg.bLength; i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%c", ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tTextCsg.abCSG_ind[i]);   
        }
    }
    pStrWalk += sprintf((char *)pStrWalk, "\",\"");   
    if(ptCsgInfo->tCsg.tCsgInfo.tCsgInd.bGphcCsgFg == Z_APMMIA_VALID)
    {
        for (i = 0;i < ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tGphcCsg.bIconLinkLen;i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%c", ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tGphcCsg.abIconLink[i]);   
        }
    }
    pStrWalk += sprintf((char *)pStrWalk, "\",%d,%d,\"", ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tGphcCsg.bGraphicTag,
        ptCsgInfo->tCsg.tCsgInfo.tCsgInd.tGphcCsg.bIconQual);   

    if(ptCsgInfo->tCsg.tCsgInfo.tHnbName.bValLen > 0)
    {
        for (i = 0;i < ptCsgInfo->tCsg.tCsgInfo.tHnbName.bValLen;i++)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%c", ptCsgInfo->tCsg.tCsgInfo.tHnbName.abHNBN[i]);   
        }
    }
    pStrWalk += sprintf((char *)pStrWalk, "\"");   

    // 617001855004ATIרԡз
    pStrWalk += sprintf((char *)pStrWalk, ",\"%X%X%X%X%X", ptCsgInfo->tCsg.tPlmn.bMCC1, ptCsgInfo->tCsg.tPlmn.bMCC2,
       ptCsgInfo->tCsg.tPlmn.bMCC3, ptCsgInfo->tCsg.tPlmn.bMNC1, ptCsgInfo->tCsg.tPlmn.bMNC2);

    if (ptCsgInfo->tCsg.tPlmn.bMNC3!= 0xf)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%X", ptCsgInfo->tCsg.tPlmn.bMNC3);
    }

    pStrWalk += sprintf((char *)pStrWalk, "\"");

    return (UINT16)strlen((const char *)pStrTarget);
    
}

/* +ZCSG:<mode>[<act>,<CSG_ID>,[Disp_Ind],[HNB]] */
/**************************************************************************
* ƣ zAt_PsEncLteZcsgQueryCnf
*  ZPS_ApMmia_ZCsgQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZCSGѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteZcsgQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaUmm_CurCsgQry_Cnf *pZcsgQueryCnf = (T_zMmiaUmm_CurCsgQry_Cnf*) pEncCmdInfo->pMsgBody;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    pStrWalk += zAt_EncLtecsgInfo(pStrWalk, pZcsgQueryCnf->bCsgSelMode, &pZcsgQueryCnf->tCsgInfo);
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);  
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/* +ZCSG: (list of current <ALLOWED>,<act>,<CSG_ID>,[Disp_Ind],[HNB]) */
/**************************************************************************
* ƣ zAt_PsEncLteZcsgTestCnf
*  ZPS_ApMmia_ZCsgListCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZCSGѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteZcsgTestCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaUmm_CsgList_Cnf *pZcsgTestCnf = (T_zMmiaUmm_CsgList_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;

    if (pZcsgTestCnf->bNum > Z_MmiaUmm_MaxCsgNum)
    {
        return 0;
    }
    if (pZcsgTestCnf->bNum > 0)
    {
        for (i = 0;i < pZcsgTestCnf->bNum;i++)
        {
             pStrWalk += zAt_EncLtecsgInfo(pStrWalk, pZcsgTestCnf->abState[i], &pZcsgTestCnf->atCsgInfoList[i]);
        }
    }  
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);  

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif
/**************************************************************************
* ƣ zAt_PsEncLteCemodeQueryCnf
*  ZPS_ApMmia_ZETWSPrimaryQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZIMGѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteCemodeQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaUmm_EpsModeQry_Cnf *pCemodeQueryCnf = (T_zMmiaUmm_EpsModeQry_Cnf*) pEncCmdInfo->pMsgBody;

    /* +CEMODE:<mode> */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+CEMODE: %d%s%s", g_zAt_CRLF, pCemodeQueryCnf->bMode, g_zAt_CRLF, g_zAt_OK);   
}

/**************************************************************************
* ƣ zAt_PsEncLteCeregInd
*  ZPS_ApMmia_ZETWSPrimaryQueryCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZIMGѯӦ617001861425ATIR8꿪ô
**************************************************************************/
UINT16 __ps_comm_func zAt_PsEncLteCeregInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zApMmia_Cereg_Ind *pCeregInd = (T_zApMmia_Cereg_Ind*) pEncCmdInfo->pMsgBody;

    /* +CEREG: <stat>[,<tac>,<ci>[,<AcT>[,< SubAct >]]] */
     pStrWalk += sprintf((char *)pStrWalk, "%s+CEREG: %d", g_zAt_CRLF, pCeregInd->bStat);   

    if ((pCeregInd->bLacFg == Z_APMMIA_VALID) && (pCeregInd->bRacFg == Z_APMMIA_VALID) 
        && (pCeregInd->bCiFg == Z_APMMIA_VALID))
    {
        {
             pStrWalk += sprintf((char *)pStrWalk, ",\"%02X%02X\",\"%02X%02X%02X%02X\"",
                pCeregInd->abLac[1],pCeregInd->abLac[0],
                pCeregInd->abCi[3],pCeregInd->abCi[2],pCeregInd->abCi[1],pCeregInd->abCi[0]);         
        }

        if (pCeregInd->bActFg == Z_APMMIA_VALID)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d",pCeregInd->bAct);         
        } 
        /**LTE-TDD,LTE-FDD**/
        if (pCeregInd->bSubActFg == Z_APMMIA_VALID)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",%d",pCeregInd->bSubAct);         
        }
    }
    
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);   
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/**************************************************************************
* ƣ zAt_PsEncZlteInfoInd
*  ZPS_ApMmia_CusdInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+Zlteinfo֪ͨ
**************************************************************************/
UINT16 zAt_PsEncZlteInfoInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    T_zMmiaEucsr_LteInfo_Ind *pZlteInfoInd = (T_zMmiaEucsr_LteInfo_Ind*) pEncCmdInfo->pMsgBody;

    if (!(pZlteInfoInd->bSubFrmAssignType == 0xff || (pZlteInfoInd->bSubFrmAssignType <= 6)) || 
         !(pZlteInfoInd->bSpclSubFrmPatt == 0xff || (pZlteInfoInd->bSpclSubFrmPatt <= 8)))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");
        return ZAT_ENC_NONEED_CNF;
    }
    /******* +ZLTEINFO 617001599469**atϱ֡Ϣ**/
    /* +ZLTEINFO:<SubFrmAssign >,< SpclSubFrmPatt >[,...] */
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZLTEINFO: %d,%d%s",g_zAt_CRLF, pZlteInfoInd->bSubFrmAssignType, pZlteInfoInd->bSpclSubFrmPatt, g_zAt_CRLF);
}
/****************************************************************
*:    zAt_PsEncLteZrssiQueryCnf
*:    +ZRSSIȡLTEźǿȵӦ
*˵:    
*****************************************************************/
UINT16 zAt_PsEncLteZrssiQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zMmiaAs_Rssi_Qry_Cnf *pRssiQryCnf = (T_zMmiaAs_Rssi_Qry_Cnf*) pEncCmdInfo->pMsgBody;

    /*+ZRSSI: <RssiInteger1>,<RssiDecimals1>,<RssiInteger2>,<RssiDecimals2>*/
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZRSSI: %d,%d,%d,%d%s%s",
        g_zAt_CRLF, pRssiQryCnf->tRssi[0].sRssiInt, pRssiQryCnf->tRssi[0].bRssiDec, 
        pRssiQryCnf->tRssi[1].sRssiInt, pRssiQryCnf->tRssi[1].bRssiDec,g_zAt_CRLF, g_zAt_OK);
}
/****************************************************************
*:    zAt_PsEncLteZsinrQueryCnf
*:    +ZSINRȡLTEȵӦ
*˵:    
*****************************************************************/
UINT16 zAt_PsEncLteZsinrQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zMmiaAs_Sinr_Qry_Cnf *pSinrQryCnf = (T_zMmiaAs_Sinr_Qry_Cnf*) pEncCmdInfo->pMsgBody;

    /*+ZSINR: <SinrInteger1><SinrDecimals1><SinrInteger2><SinrDecimals2>
                        <SinrInteger3><SinrDecimals3><SinrInteger4><SinrDecimals4>*/
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZSINR: %d,%d,%d,%d,%d,%d,%d,%d%s%s",
        g_zAt_CRLF, pSinrQryCnf->tSinr[0].cSinrInt, pSinrQryCnf->tSinr[0].bSinrDec, 
                               pSinrQryCnf->tSinr[1].cSinrInt, pSinrQryCnf->tSinr[1].bSinrDec, 
                               pSinrQryCnf->tSinr[2].cSinrInt, pSinrQryCnf->tSinr[2].bSinrDec,
                               pSinrQryCnf->tSinr[3].cSinrInt, pSinrQryCnf->tSinr[3].bSinrDec,
                               g_zAt_CRLF, g_zAt_OK);
}
/**************************************************************************
* ƣ zAt_PsEncMmZsrvIndCnf
*  ZPS_ApMmia_ZmmiInd_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZSRVINGϱı뺯
**************************************************************************/
UINT16 zAt_PsEncMmZsrvInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaUmm_MtCsSrv_Ind *pZsrvInd= (T_zMmiaUmm_MtCsSrv_Ind*) pEncCmdInfo->pMsgBody;

    if (pZsrvInd->tCLI.bNumLen > Z_MAX_CALLNUM_LEN)
    {
        return 0;
    }

    /*ZSRVING:<NUM>[,[<NUMTPYE>][,<SSCODE>]]**617001605851 liangxh***/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZSRVING: ",  g_zAt_CRLF);
    pStrWalk += zAt_EncSmsAddrType(pStrWalk, pZsrvInd->tCLI.bNumType);  

    /* print the BCD number */
    zAt_EncBcd2NumStrByCscsType(pStrWalk, (UINT8 *)pZsrvInd->tCLI.abNum, pZsrvInd->tCLI.bNumLen, ZAT2_CSCS_GSM);
    pStrWalk += strlen((const char *)pStrWalk);
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    if((pZsrvInd->tCLI.bNumType != 0) && (pZsrvInd->tCLI.bNumType != 0xff))
    {       
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pZsrvInd->tCLI.bNumType);
    }
    else
    {
        if (pZsrvInd->bSsCodeFg)
        {
            pStrWalk += sprintf((char *)pStrWalk, ",,%d", pZsrvInd->bSsCode);        
        }
        sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);           
        return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }

    if (pZsrvInd->bSsCodeFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%d", pZsrvInd->bSsCode);        
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);        
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
BOOL zAti_IsHasValidFg(BYTE *pbFg, BYTE bLen)
{
    BYTE i = 0;

    if(pbFg == NULL)
    {
        return FALSE;
    }

    for(i = 0; i < bLen; i++)
    {
        if(Z_VALID == pbFg[i])
        {
            return TRUE;
        }
    }

    return FALSE;
}
/**************************************************************************
* ƣ zAt2_PsEncZepcgSetCnf
*  AP_MMIA_L1E_ZEPCG_CNFϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+ZEPCG֪ͨ
**************************************************************************/
UINT16 zAt_PsEncZepcgSetCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaL1E_Zepcg_Cnf *pZepcgCnf = (T_zMmiaL1E_Zepcg_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZEPCG:<cmd >,< mode>[,<result>[,<val1>[,<val2>[...]]]] */
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZEPCG: %d,%d",g_zAt_CRLF, pZepcgCnf->bCmd, pZepcgCnf->bMode);

    
    pStrWalk += sprintf((char *)pStrWalk, ",%d", pZepcgCnf->bRslt);

    for(i = 0; i < Z_ZEPCG_PARAM_NUMBER; i++)
    {
        if(zAti_IsHasValidFg(&pZepcgCnf->bVal1Fg[i], (Z_ZEPCG_PARAM_NUMBER - i)))
        {
            pStrWalk += sprintf((char *)pStrWalk, ",");
        }
        else
        {
            break;
        }

        if(Z_VALID == pZepcgCnf->bVal1Fg[i])
        {
            pStrWalk += sprintf((char *)pStrWalk, "%ld", pZepcgCnf->dwVal[i]);
        }
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s",g_zAt_CRLF);
    /*AT+ZEPCG=25,1,0 ѾȻظOKֻҪϱOK*/
    if(Z_ZEPCG_IND_CMD == pZepcgCnf->bCmd && pZepcgCnf->bMode == AP_MMIA_ZEPCG_QRY)
    {
        return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }
    
    sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}


/* +CGEQOSRDP: <cid> [,<QCI>, [<DL_GBR and UL_GBR>], [<DL_MBR and UL_MBR>]]*/
/**************************************************************************
* ƣ zAt_PsEncLteCgeqosrdpCnf
*  ZPS_ApMmia_CgeqosrdpCnf_EvϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ Ӧ+CGEQOSRDPѯӦ
**************************************************************************/
UINT16 zAt_PsEncLteCgeqosrdpCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{    
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaEsm_EpsQosQuery_Cnf *pCgeqosrdpCnf = (T_zMmiaEsm_EpsQosQuery_Cnf*) pEncCmdInfo->pMsgBody;
    UINT8 i = 0;
    if (pCgeqosrdpCnf->bCidNum > Z_MMIAESM_MAX_CID_NUM)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, Z_APMMIA_INVALIDPARA_ERR);
    }

    if (pCgeqosrdpCnf->bResult == Z_FAIL)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
    }  

    if (pCgeqosrdpCnf->bCidNum > 0)
    {
        for (i = 0;i < pCgeqosrdpCnf->bCidNum;i++)
        {
            zAt_PsEncReadCnfParse(ZAT2_CGEQOSRDP_CNF, &pStrWalk, &(pCgeqosrdpCnf->atEpsQosInfo[i]));
        }
    }
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);  

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}  
/************************************************************
*:zAt_PsEncLteAsCommCnf
*:ASظATIӦϢı,Ϣ
*ûʧܵ
************************************************************/
UINT16 zAt_PsEncLteAsCommCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    return (UINT16)sprintf((char *)pStrWalk, "%s", g_zAt_OK);
}
#ifdef EMBMS_SUPPORT
/**********************************************************
*:zAt_PsEncLteSaiQueryCnf
*:SAIбѯı
*˵:MBMS
**********************************************************/
UINT16 zAt_PsEncLteSaiQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    BYTE j = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_SaiListQueryResp *ptSaiQryResp = (T_zAtiAs_SaiListQueryResp*)pEncCmdInfo->pMsgBody;

    zOss_RetUB(pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * 4); 
    pStrWalk = pEncCmdInfo->pStrCmd;

    if(ptSaiQryResp->bFreqNum > Z_MAX_LTE_FREQ_NUM)
    {
        return 0;
    }

    /*+ ZSAILIST:<frequency_number>[,<frequency-1>,<Serving_frequency_flag>,<Sai_number>[,<Sai1>[,<Sai2>[]]]*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZSAILIST: %d",g_zAt_CRLF, ptSaiQryResp->bFreqNum);

    for(i = 0; i < ptSaiQryResp->bFreqNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk,",%lu,%d,%d",ptSaiQryResp->atSpecFreqSaiListInfo[i].dwFreq, ptSaiQryResp->atSpecFreqSaiListInfo[i].bIsServFreq, ptSaiQryResp->atSpecFreqSaiListInfo[i].bSaiNum);
        for(j = 0; j < ptSaiQryResp->atSpecFreqSaiListInfo[i].bSaiNum; j++)
        {
            pStrWalk += sprintf((char *)pStrWalk,",%d", ptSaiQryResp->atSpecFreqSaiListInfo[i].awSai[j]);
        }
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 

    if(pEncCmdInfo->bIsEndOfCnf)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK);
    } 

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/**********************************************************
*:zAt_PsEncLteTmgiQueryCnf
*:TMGIбѯı
*˵:MBMS
**********************************************************/
UINT16 zAt_PsEncLteTmgiQueryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_TmgiListQueryResp *ptTmgiQryResp = (T_zAtiAs_TmgiListQueryResp*)pEncCmdInfo->pMsgBody;

    if(ptTmgiQryResp->wTmgiNum > Z_MAX_MBMS_TMGI_LIST_NUM)
    {
        return 0;
    }
   /*+ ZTMGILIST: <TMGI_type>,[<Oos_Reason>],<TMGI_number>[,[<SessionId1>],<TMGI-1>[,[<SessionId2>],<TMGI-2>]...[]]*/

    /*<TMGI_type>*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZTMGILIST: %d,", g_zAt_CRLF, ptTmgiQryResp->bTmgiListType);

    /*<Oos_Reason>*/
    if(Z_VALID == ptTmgiQryResp->bWarnReasonFg)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d", ptTmgiQryResp->bWarnReason);
    }
    /*<TMGI_number>*/
    pStrWalk += sprintf((char *)pStrWalk, ",%d", ptTmgiQryResp->wTmgiNum);

    for(i = 0; i < ptTmgiQryResp->wTmgiNum; i++)
    {
        /*<SessionId>*/
        pStrWalk += sprintf((char *)pStrWalk, ",");
        if(Z_VALID == ptTmgiQryResp->atTmgiList[i].bSessionIdFg)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d", ptTmgiQryResp->atTmgiList[i].bSessionId);
        }
        /*<TMGI>*/
        pStrWalk += sprintf((char *)pStrWalk, ",\"%02X%02X%02X%X%X%X%X%X", ptTmgiQryResp->atTmgiList[i].tTmgi.abServiceId[0],
            ptTmgiQryResp->atTmgiList[i].tTmgi.abServiceId[1], ptTmgiQryResp->atTmgiList[i].tTmgi.abServiceId[2],ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMCC1,
            ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMCC2, ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMCC3,
            ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMNC1, ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMNC2);

        if(ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMNC3 != 0xF)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%X", ptTmgiQryResp->atTmgiList[i].tTmgi.tPlmnId.bMNC3);
        }

        pStrWalk += sprintf((char *)pStrWalk, "\"");
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 

    if(pEncCmdInfo->bIsEndOfCnf)
    {
        sprintf((char *)pStrWalk, "%s", g_zAt_OK); 
    }  

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/*********************************************************************
*:zAt_PsEncLteTmgiActiveCnf
*:TMGIӦ
*˵:EMBMS
**********************************************************************/
UINT16 zAt_PsEncLteTmgiActiveCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_Tmgi_Activate_Cnf *ptTmgiActCnf = (T_zAtiAs_Tmgi_Activate_Cnf*)pEncCmdInfo->pMsgBody;

    if(ptTmgiActCnf->bActStatus <= 2)
    {
        return (UINT16)sprintf((char *)pStrWalk, "%s+ZTMGIACT: %d%s%s", g_zAt_CRLF, ptTmgiActCnf->bActStatus, 
            g_zAt_CRLF, g_zAt_OK);
    }
    else   //error
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, zAti_GetTmgiActErrorCode(ptTmgiActCnf->bActStatus));
    }
}

/*******************************************
*:zAt_PsEncLteTmgiDeActiveCnf
*:TMGIȥӦ
*˵:EMBMS
********************************************/
UINT16 zAt_PsEncLteTmgiDeActiveCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE  bStatus = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_Tmgi_Deactivate_Cnf *ptTmgiDeActCnf = (T_zAtiAs_Tmgi_Deactivate_Cnf*)pEncCmdInfo->pMsgBody;

    if(ptTmgiDeActCnf->bDeactStatus == TMGI_DEACT_STATUS_DUPLC_ACT)
    {
        bStatus= Z_ATI_TMGI_DEACT_DUPLC;//ظȥ
    }
    else
    {
        bStatus = Z_ATI_TMGI_DEACT_SUCC;
    }

    return (UINT16)sprintf((char *)pStrWalk, "%s+ZTMGIACT: %d%s%s", g_zAt_CRLF, bStatus, 
            g_zAt_CRLF, g_zAt_OK);
}
/*******************************************
*:zAt_PsEncLteMbmsSuspendInd
*:EMBMS֪ͨ
*˵:EMBMS
********************************************/
UINT16 zAt_PsEncLteMbmsSuspendInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_MbmsServiceSuspendInd *ptSuspendInd = (T_zAtiAs_MbmsServiceSuspendInd*)pEncCmdInfo->pMsgBody;

    if(ptSuspendInd->wTmgiNum > Z_MAX_TMGI_NUM_IN_MBSFN_AREA)
    {
        return 0;
    }

    /*ZMBMSSUSPEND: <TMGI_Number> [,[<SessionId1>],<TMGI-1>[,[<SessionId2>],<TMGI-2>...]]*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZMBMSSUSPEND: %d", g_zAt_CRLF, ptSuspendInd->wTmgiNum);

    for(i= 0; i < ptSuspendInd->wTmgiNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
        if(Z_VALID == ptSuspendInd->atTmgiList[i].bSessionIdFg)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d", ptSuspendInd->atTmgiList[i].bSessionId);
        }
    
        pStrWalk += sprintf((char *)pStrWalk,",\"%02X%02X%02X%X%X%X%X%X", ptSuspendInd->atTmgiList[i].tTmgi.abServiceId[0], ptSuspendInd->atTmgiList[i].tTmgi.abServiceId[1],
            ptSuspendInd->atTmgiList[i].tTmgi.abServiceId[2], ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMCC1, 
            ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMCC2, ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMCC3,
            ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMNC1, ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMNC2);

        if(ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMNC3 != 0xF)
        {
            pStrWalk += sprintf((char *)pStrWalk,"%X", ptSuspendInd->atTmgiList[i].tTmgi.tPlmnId.bMNC3);
        }

        pStrWalk += sprintf((char *)pStrWalk, "\"");
    }

    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF); 

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
/*************************************************************
*:zAt_PsEncLteMbmsResumeInd
*:EMBMSظ֪ͨı
*˵:EMBMS
*************************************************************/
UINT16 zAt_PsEncLteMbmsResumeInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_MbmsServiceResumeInd *ptResumeInd = (T_zAtiAs_MbmsServiceResumeInd*)pEncCmdInfo->pMsgBody;
    /*+ZMBMSRESUME: <TMGI_Number> [,[<SessionId1>],<TMGI-1>[,[<SessionId2>],<TMGI-2>]...]*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZMBMSRESUME: %d", g_zAt_CRLF, ptResumeInd->wTmgiNum);

    if(ptResumeInd->wTmgiNum > Z_MAX_TMGI_NUM_IN_MBSFN_AREA)
    {
        return 0;
    }

    for(i= 0; i < ptResumeInd->wTmgiNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",");
        if(Z_VALID == ptResumeInd->atTmgiList[i].bSessionIdFg)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%d", ptResumeInd->atTmgiList[i].bSessionId);
        }
        pStrWalk += sprintf((char *)pStrWalk,",\"%02X%02X%02X%X%X%X%X%X", ptResumeInd->atTmgiList[i].tTmgi.abServiceId[0], ptResumeInd->atTmgiList[i].tTmgi.abServiceId[1],
            ptResumeInd->atTmgiList[i].tTmgi.abServiceId[2], ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMCC1, 
            ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMCC2, ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMCC3,
            ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMNC1, ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMNC2);

        if(ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMNC3 != 0xF)
        {
            pStrWalk += sprintf((char *)pStrWalk,"%X", ptResumeInd->atTmgiList[i].tTmgi.tPlmnId.bMNC3);
        }

        pStrWalk += sprintf((char *)pStrWalk,"\"");
    }
    sprintf((char *)pStrWalk, "%s", g_zAt_CRLF);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

/*************************************************************
*:zAt_PsEncLteNetWorkTimeQryCnf
*:ѯʱӦı
*˵:EMBMS
*************************************************************/
UINT16 zAt_PsEncLteNWTimeQryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAtiAs_NwTimeQueryResp *ptNWTQryCnf = (T_zAtiAs_NwTimeQueryResp*)pEncCmdInfo->pMsgBody;
    /*+ZMBMSNWTM: <TimeInfo>*/

    if (ptNWTQryCnf->bResult == Z_FAIL)
    {
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, 100);
    }  
    else
    {
        pStrWalk += sprintf((char *)pStrWalk, "%s+ZMBMSNWTM: ", g_zAt_CRLF);
        pStrWalk += sprintf((char *)pStrWalk, "%08lX", (UINT32)((ptNWTQryCnf->uUtcTimeInfo>>32)&0xffffffff));
        pStrWalk += sprintf((char *)pStrWalk, "%08lX", (UINT32)(ptNWTQryCnf->uUtcTimeInfo&0xffffffff));
        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
        return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
    }
}
#endif
#endif

BOOL __ps_static_func zAt_PsDecParamInit(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, UINT16 iTypeLength)
{
    pPrsCmd2Msg->pMsgBody = zAti_GetUB(iTypeLength);
    return TRUE;
}

BOOL __ps_static_func zAt_PsDecCmdFirstParamOmitted(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR* pDecCmdStr, VOID * pDecCmd)
{/*617001635997 ͵atӦȱʡֵӦֱӷok*/
    if (strlen((const char *)pDecCmdStr) == 0)
    {
        zOss_Memcpy(g_zAt_EncBuf, g_zAt_OK, strlen((const char *)g_zAt_OK));
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_REPLY_DIRECT;
        return TRUE;
    }
    return FALSE;
}

BOOL zAt_PsDecCmdFirstParamNeeded(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR* pDecCmdStr)
{
    if (strlen((const char *)pDecCmdStr) == 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_SYNTAX_ERR;
        return FALSE;
    }
    return TRUE;
}

BOOL __ps_static_func zAt_PsDecNextParamDecimalNumByteNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) <= 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseDecimalByte(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL __ps_static_func zAt_PsDecNextParamDecimalNumByte(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    SINT16 iSubLen = -1;
    
    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) ==-1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    else if(iSubLen == 0)
    {
        zAt_PutValue(pMmiaFalg, Z_MMIAESM_CMD_WITHOUTCID);
        return TRUE;
    }
    return zAt_PsDecParseDecimalByte(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL __ps_static_func zAt_PsDecParseDecimalByte(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_DECIMAL_PARAM, &iTmpVal32);
    if (bStr2ValRet && iTmpVal32 <= 0xff)
    {
        (*pMmiaParam) = (BYTE)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_MMIAESM_CMD_WITHCID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

VOID __ps_static_func zAt_PutValue(BYTE* pValue , BYTE value)
{
    if(pValue != NULL)
    {
        (*pValue) = value;
    }
}

BOOL zAt_PsDecNextParamHexNumByteNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam) <= 0))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseHexByte(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}
BOOL zAt_PsDecNextParamHexNumWordNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, WORD * pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam))<= 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseHexWord(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL zAt_PsDecParseHexWord(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, WORD * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32);
    if (bStr2ValRet && iTmpVal32 <= 0xffff)
    {
        (*pMmiaParam) = (WORD)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}
BOOL zAt_PsDecParseHexByte(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32);
    if (bStr2ValRet && iTmpVal32 <= 0xff)
    {
        (*pMmiaParam) = (BYTE)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

BOOL zAt_PsDecNextParamHexNumDword(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, DWORD * pMmiaParam, BYTE* pMmiaFalg)
{
    SINT16 iSubLen = -1;
    
    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) ==-1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    else if(iSubLen == 0)
    {
        zAt_PutValue(pMmiaFalg, Z_APMMIA_INVALID);
        return TRUE;
    }
    return zAt_PsDecParseHexDword(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL zAt_PsDecParseHexDword(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, DWORD * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32);
    if (bStr2ValRet)
    {
        (*pMmiaParam) = (DWORD)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

T_ZAt_ParseCmd2MsgRslt __ps_static_func zAt_PsDecFinishParse(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR* pDecCmdStr, VOID * pDecCmd, UINT16 iTypeLength, BOOL needCheck)
{
    if (needCheck &&((*(pDecCmdStr - 1) == ZAT2_COMMA_CHAR) || (strlen((const char *)pDecCmdStr) != 0))) /* with more ',' */
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_SYNTAX_ERR;
        return *pPrsCmd2Msg; 
    }

    pPrsCmd2Msg->iMsgLen = iTypeLength;
    zOss_Memcpy(pPrsCmd2Msg->pMsgBody, pDecCmd, pPrsCmd2Msg->iMsgLen);
    
    return *pPrsCmd2Msg;
}

BOOL zAt_PsDecZcsgOperNumParam(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, T_z_PlmnId * pMmiaParam)
{
    SINT16 iSubLen = -1;
    BYTE i = 0;
    UINT32 iTmpVal32 = 0;
    BYTE abPlmnId[3]={0};
    CHAR strByteBuf[ZAT2_BYTE_BUF_LEN] = {0};
    BYTE bBcdNam = 0;
    CHAR MNC3 = 0;

    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam)) == -1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    if (iSubLen > 0)
    {
        if (iSubLen == 5)
        {
            strSubBuf[5] = strSubBuf[4];
            strSubBuf[4] = strSubBuf[3];
            strSubBuf[3] = 'F';
        }
        else if(iSubLen == 6)
        {
            //MNC3һַҪĸ
            MNC3 = strSubBuf[5];
            strSubBuf[5] = strSubBuf[4];
            strSubBuf[4] = strSubBuf[3];
            strSubBuf[3] = MNC3;
        }
        else
        {
            pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
            return FALSE; 
        }

        for (i = 0; i < 3; i++)
        {
            zOss_Memcpy(strByteBuf, &strSubBuf[i * 2], 2);
            if (zAt_Str2Value(strByteBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32) && iTmpVal32 <= 0xff)
            {
                bBcdNam = (BYTE)iTmpVal32;
                abPlmnId[i] = (BYTE)((bBcdNam << 4) | (bBcdNam >> 4));
            }
            else
            {
                pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
                return FALSE;
            }
        }
        zOss_Memcpy(pMmiaParam, abPlmnId, sizeof(T_z_PlmnId));
        if(Z_INVALID == zAti_IsPlmnIdValid(pMmiaParam))
        {
            pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
            return FALSE; 
        }
        
    }
    return TRUE;
}
BOOL zAt_PsDecPlmnId(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, T_z_PlmnId * pMmiaParam)
{
    SINT16 iSubLen = -1;
    UINT32 iTmpVal32 = 0;
    BYTE abPlmnId[3]={0};

    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam)) == -1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    if (iSubLen > 0)
    {
        UINT8 i = 0;
        CHAR strByteBuf[ZAT2_BYTE_BUF_LEN] = {0};
        BYTE bBcdNam = 0;
        CHAR MNC3 = 0;

        if (iSubLen == 5)
        {
            strSubBuf[5] = strSubBuf[4];
            strSubBuf[4] = strSubBuf[3];
            strSubBuf[3] = 'F';
        }
        else if (iSubLen == 6)
        {
            //MNC3һַҪĸ
            MNC3 = strSubBuf[5];
            strSubBuf[5] = strSubBuf[4];
            strSubBuf[4] = strSubBuf[3];
            strSubBuf[3] = MNC3;
        }
        else
        {
            return FALSE; 
        }

        for (i = 0; i < 3; i++)
        {
            zOss_Memcpy(strByteBuf, &strSubBuf[i * 2], 2);
            if (zAt_Str2Value(strByteBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32) && iTmpVal32 <= 0xff)
            {
                bBcdNam = (BYTE)iTmpVal32;
                abPlmnId[i] = (BYTE)((bBcdNam << 4) | (bBcdNam >> 4));
            }
            else
            {
                return FALSE;
            }
        }

        zOss_Memcpy(pMmiaParam, abPlmnId, sizeof(T_z_PlmnId));
        if(Z_INVALID == zAti_IsPlmnIdValid(pMmiaParam))
        {
            return FALSE; 
        }
    }
    else
    {
        return FALSE; 
    }       

    return TRUE;
}

BOOL zAt_PsDecNextParamDecimalNumDword(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, DWORD * pMmiaParam, BYTE* pMmiaFalg)
{
    SINT16 iSubLen = -1;
    
    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) == -1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    else if(iSubLen == 0)
    {
        zAt_PutValue(pMmiaFalg, Z_APMMIA_INVALID);
        return TRUE;
    }
    return zAt_PsDecParseDecimalDword(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL zAt_PsDecNextParamDecimalNumDwordNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, DWORD * pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) <=0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseDecimalDword(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL zAt_PsDecParseDecimalDword(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, DWORD * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_DECIMAL_PARAM, &iTmpVal32);
    if (bStr2ValRet)
    {
        (*pMmiaParam) = (DWORD)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

BOOL zAt_PsDecParseZflagFac(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE* pFac)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam)) <=0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    
    return zAt_PsDecParseZflagFacContent(pPrsCmd2Msg,strSubBuf,pFac);
}

BOOL zAt_PsDecParseZflagFacContent(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, BYTE* pFac)
{
    UINT8 i = 0;
    
    for (i = 0; i < ZAT_FAC_TYPE_MAX_NUM; i++)
    {
        if (0 == strcmp((const char *)strSubBuf, (const char *)ZAT_FAC_TYPE[i]))
        {
            (*pFac) = i;
            return TRUE; 
        }
    }
    pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
    
    return FALSE; 
}

BOOL __ps_static_func zAt_PsDecNextParamDecimalNumBool(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    SINT16 iSubLen = -1;
    
    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) ==-1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    else if(iSubLen == 0)
    {
        return TRUE;
    }
    return zAt_PsDecParseDecimalBool(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

BOOL __ps_static_func zAt_PsDecParseDecimalBool(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_DECIMAL_PARAM, &iTmpVal32);
    if (bStr2ValRet && iTmpVal32 <=1)
    {
        (*pMmiaParam) = (BYTE)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

BOOL zAt_PsDecZflagSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_ZAti_Zflag_Req* pZflagSetReq = (T_ZAti_Zflag_Req *)pMsgbody;

    return (zAt_PsDecParseZflagFac(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, &(pZflagSetReq->bFac))); 
}

BOOL zAt_PsDecZflagSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_ZAti_Zflag_Req* pZflagSetReq = (T_ZAti_Zflag_Req *)pMsgbody;

    return (zAt_PsDecNextParamDecimalNumBool(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    (BYTE *)&(pZflagSetReq->bValue),NULL)); 
}

BOOL __ps_static_func zAt_PsDecNextParamDecimalNumBoolNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, BYTE * pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) <=0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseDecimalBool(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}
#ifdef USE_VOICE_SUPPORT
BOOL zAt_PsDecCaocSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CaocSet_Req* pCaocSetReq = (T_zApMmia_CaocSet_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByteNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pCaocSetReq->bMode),&(pCaocSetReq->bModeFlg)));
}
#endif
BOOL zAt_PsDecParamContent(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf,BYTE * pMmiaParam, BYTE* pParamLen,SINT16 strLen)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;
    CHAR strByteBuf[ZAT2_BYTE_BUF_LEN] = {0};           /* ˫ַ */
    UINT16 i = 0;

    if(strLen % 2)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    for (i = 0; i < strLen / 2; i++)
    {
        zOss_Memcpy(strByteBuf, &strSubBuf[i * 2], 2);
        bStr2ValRet = zAt_Str2Value(strByteBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32);
        if (bStr2ValRet && iTmpVal32 <= 0xff)
        {
            pMmiaParam[i] = (BYTE)iTmpVal32;
        }
        else
        {
            pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
            return FALSE;
        }
    }
    *pParamLen = (BYTE)(strLen / 2);

    return TRUE;
}
/*617001855004ATIרԡз*/
BOOL zAt_PsDecPrmHxFormtDefltLngthIsFixedNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                                         BYTE * pMmiaParam, BYTE* pParamLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam);
    if ((iSubLen <= 0) || (iSubLen > 0&&iSubLen != iMaxLen * 2))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }

    return zAt_PsDecParamContent(pPrsCmd2Msg,strSubBuf,pMmiaParam,pParamLen,iSubLen);
}

BOOL zAt_PsDecPrmHxFormtDefltLngthIsFixed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                                         BYTE * pMmiaParam, BYTE* pParamLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam);
    if ((iSubLen < 0) || (iSubLen > 0&&iSubLen != iMaxLen * 2))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }

    return zAt_PsDecParamContent(pPrsCmd2Msg,strSubBuf,pMmiaParam,pParamLen,iSubLen);
}

BOOL zAt_PsDecPrmHxFormtDefltLngthIsNotFixed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                                         BYTE * pMmiaParam, BYTE* pParamLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam);
    if ((iSubLen < 0) || (iSubLen > 0&&iSubLen > iMaxLen * 2))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }

    return zAt_PsDecParamContent(pPrsCmd2Msg,strSubBuf,pMmiaParam,pParamLen,iSubLen);
}

BOOL zAt_PsDecPrmHxAndDecmlFormtDefltIsNotFixed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                                         BYTE * pMmiaParam, BYTE* pParamLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_HEX_FORMAT, ppStrParam);
    if ((iSubLen < 0) || (iSubLen > 0&&iSubLen > iMaxLen * 2))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    
    return zAt_PsDecParamContent(pPrsCmd2Msg,strSubBuf,pMmiaParam,pParamLen,iSubLen);
}

BOOL zAt_PsDecPrmHxAndDecmlFormtDefltIsFixed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                                         BYTE * pMmiaParam, BYTE* pParamLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam);
    if ((iSubLen < 0) || (iSubLen > 0&&iSubLen != iMaxLen * 2))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    
    return zAt_PsDecParamContent(pPrsCmd2Msg,strSubBuf,pMmiaParam,pParamLen,iSubLen);
}

BOOL zAt_PsDecParamStrDefault(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, 
                               BYTE * pMmiaParam, BYTE* pStrLen, WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam);
    if ((iSubLen < 0) || (iSubLen > iMaxLen))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    //zOss_Memset(pMmiaParam, 0, iMaxLen); // ⲿѾʼΪ0,ҲΪ0xFF
    *pStrLen = 0;
    
    if(iSubLen > 0)
    {
        zOss_Memcpy(pMmiaParam, strSubBuf, (WORD)iSubLen);
        *pStrLen = (BYTE)iSubLen;
    }

    return TRUE;
}

BOOL zAt_PsDecParamStrNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, 
                            CHAR **ppStrParam,BYTE * pMmiaParam, SINT16* iStrlen,WORD iMaxLen)
{
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppStrParam);
    if ((iSubLen <= 0) || (iSubLen > iMaxLen))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    //zOss_Memset(pMmiaParam, 0, iMaxLen);
    *iStrlen = 0;
    if(iSubLen > 0)
    {
        zOss_Memcpy(pMmiaParam, strSubBuf, (WORD)iSubLen);
        *iStrlen = iSubLen;
    }

    return TRUE;
}
#ifdef USE_VOICE_SUPPORT
VOID zAt_PsDecParamSetValue(BYTE* iIntegerlen,BYTE * pIntegerParam,BYTE* iDecimallen,BYTE * pDecimalParam)
{
    UINT8 i = 0;
    BOOL iResult = FALSE;

    for(i = 0;i < *iIntegerlen;i++)
    {
        if(pIntegerParam[i] != 0)
        {
            iResult = TRUE;
            break;
        }
    }
    if(!iResult)
    {
        *iIntegerlen = 0;
    }

    for(i = 0;i < *iDecimallen;i++)
    {
        if(pDecimalParam[i] != 0)
        {
            iResult = TRUE;
            break;
        }
    }
    if(!iResult)
    {
        *iDecimallen = 0;
    }
}

BOOL zAt_PsDecParamForppuofCpuc(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf,SINT16 iStrlen,BYTE * pIntegerParam, 
                                 BYTE* iIntegerlen,BYTE * pDecimalParam, BYTE* iDecimallen,WORD iMaxLen)
{
    UINT8 i = 0;
    *iDecimallen = 0;
    *iIntegerlen = 0;
    
    for(i = 0;i < iStrlen;i++)
    {
        if(strSubBuf[i] == ZAT2_DOT_CHAR)
        {
            break;    
        }
        if((strSubBuf[i] >= '0') && (strSubBuf[i] <= '9') && (i < iMaxLen))
        {
            pIntegerParam[i] = (BYTE)strSubBuf[i] - '0';
        }
        else
        {
            return FALSE; 
        }     
    }
    *iIntegerlen = i;
    if(i < iStrlen)
    {
        *iDecimallen = (BYTE)(iStrlen - i )-1;
    }
    for(i = 0;i < *iDecimallen;i++)
    {
        if((strSubBuf[i + 1 + (*iIntegerlen)] >= '0') && (strSubBuf[i + 1 + (*iIntegerlen)] <= '9') && (i < iMaxLen))
        {
            pDecimalParam[i] = (BYTE)strSubBuf[i + 1 + (*iIntegerlen)] - '0';
        }
        else
        {
            return FALSE; 
        }  
    }
    zAt_PsDecParamSetValue(iIntegerlen,pIntegerParam,iDecimallen,pDecimalParam); 
    
    return TRUE;
}

BOOL zAt_PsDecCammSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CammSet_Req* pCammSetReq = (T_zApMmia_CammSet_Req *)pMsgbody;
    
    return ( zAt_PsDecPrmHxFormtDefltLngthIsFixed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    (pCammSetReq->abAcmMax),&(pCammSetReq->bAcmMaxLen),Z_APMMIA_AOC_CALL_METER_LEN)); 
}

BOOL zAt_PsDecCammSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CammSet_Req* pCammSetReq = (T_zApMmia_CammSet_Req *)pMsgbody;
    
    return ( zAt_PsDecParamStrDefault(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    (pCammSetReq->abPwd),&(pCammSetReq->bPwdLen),Z_APMMIA_MAX_PIN_LEN)); 
}

BOOL zAt_PsDecCpucSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    SINT16 iSubLen = -1;
    SINT16 iCnvtRet = -1;
    
    T_zApMmia_CpucSet_Req* pCpucSetReq = (T_zApMmia_CpucSet_Req *)pMsgbody;

    if((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppDecCmdStr))<=0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    /*<currency>Ľȡڵǰıʽ*/
    iCnvtRet = zAt_DecStr2Gsm7bByCscsType(pCpucSetReq->abCurrencyCode, Z_APMMIA_AOC_CURRENCY_CODE_LEN,
            strSubBuf, (WORD)iSubLen, (UINT8)g_zAti_atDataEx[g_zAti_CurInstance].bCurCscsTyp);

    if (iCnvtRet <= 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    } 
    return TRUE;
    
}

BOOL zAt_PsDecCpucSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    CHAR sPpuBuf[Z_APMMIA_AOC_PPU_NUM_LEN * 3] = {0};    /* ʱȡַ */
    SINT16 iStrlen = 0;
    T_zApMmia_CpucSet_Req* pCpucSetReq = (T_zApMmia_CpucSet_Req *)pMsgbody;
    
    if(!(zAt_PsDecParamStrNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr,(BYTE *)sPpuBuf,&iStrlen,Z_APMMIA_AOC_PPU_NUM_LEN*2+1))) 
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    if(TRUE != zAt_PsDecParamForppuofCpuc(pPrsCmd2Msg, strSubBuf,iStrlen,pCpucSetReq->abInteger,&(pCpucSetReq->bIntegerLen),
           pCpucSetReq->abDecimal,&(pCpucSetReq->bDecimalLen),Z_APMMIA_AOC_PPU_NUM_LEN))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }

    return TRUE;         
}

BOOL zAt_PsDecCpucSetReqParam3(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CpucSet_Req* pCpucSetReq = (T_zApMmia_CpucSet_Req *)pMsgbody;
    
    return ( zAt_PsDecParamStrDefault(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    (pCpucSetReq->abPwd),&(pCpucSetReq->bPwdLen),Z_APMMIA_MAX_PIN_LEN)); 
}
#endif
BOOL zAt_PsDecZpukSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Zpuk_Req* pZpukSetReq = (T_zApUicc_Zpuk_Req *)pMsgbody;
    
    return ( zAt_PsDecNextParamDecimalNumByteNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZpukSetReq->bFac),NULL));
}

BOOL zAt_PsDecZpukSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Zpuk_Req* pZpukSetReq = (T_zApUicc_Zpuk_Req *)pMsgbody;
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppDecCmdStr);//617001781132 lxh 12.10.10
    if ((iSubLen <= 0) || (iSubLen > Z_APMMIA_MAX_PIN_NUM))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    zOss_Memset(pZpukSetReq->abPuk, 0xff, (WORD)Z_APMMIA_MAX_PIN_NUM);
    zOss_Memcpy(pZpukSetReq->abPuk, strSubBuf, (WORD)iSubLen);
    return TRUE;
    /*if(iSubLen > 0)
    {
        zOss_Memcpy(pZpukSetReq->abPuk, strSubBuf, (WORD)iSubLen);
        return TRUE;
    }
    return FALSE;*/
}

BOOL zAt_PsDecZpukSetReqParam3(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Zpuk_Req* pZpukSetReq = (T_zApUicc_Zpuk_Req *)pMsgbody;
    SINT16 iSubLen = -1;

    iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppDecCmdStr);//617001781132 lxh 12.10.10
    if ((iSubLen <= 0) || (iSubLen > Z_APMMIA_MAX_PIN_NUM))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    zOss_Memset(pZpukSetReq->abPin, 0xff, (WORD)Z_APMMIA_MAX_PIN_NUM);
    zOss_Memcpy(pZpukSetReq->abPin, strSubBuf, (WORD)iSubLen);
    return TRUE;
    /*if(iSubLen > 0)
    {
        zOss_Memcpy(pZpukSetReq->abPin, strSubBuf, (WORD)iSubLen);
        return TRUE;
    }
    return FALSE;*/
}

BOOL zAt_PsDecZpukSetReqParam4(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Zpuk_Req* pZpukSetReq = (T_zApUicc_Zpuk_Req *)pMsgbody;
#ifdef NAS_ISIM_SUPPORT
    BYTE bChIdFg = Z_INVALID;
#endif
    pZpukSetReq->bChId = 0;
#ifdef NAS_ISIM_SUPPORT
    if(!zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, &(pZpukSetReq->bChId), &bChIdFg)
        ||(bChIdFg && (pZpukSetReq->bChId < 1||pZpukSetReq->bChId > 19)))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
#else
    if(zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppDecCmdStr) < 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
#endif

    return TRUE;
}

BOOL zAt_PsDecUiccMbauReqContent(T_zApMmia_MbAuth_Req *pMbausetReq, CHAR **ppDecCmdStr)
{
    UINT16 iStrLen = 0;
    BOOL iReslt = FALSE;

    iReslt = zAt_DecStr2CompArr(pMbausetReq->abRand,&iStrLen,Z_APMMIA_MAX_LEN_RAND,ppDecCmdStr,TRUE);
    if((!iReslt) || (iStrLen != Z_APMMIA_MAX_LEN_RAND))
    {
        return FALSE; 
    }
    iReslt = zAt_DecStr2CompArr(pMbausetReq->abAutn,&iStrLen,Z_APMMIA_MAX_LEN_AUTN,ppDecCmdStr,FALSE);
    if(!iReslt || ((iStrLen != Z_APMMIA_MAX_LEN_AUTN) && (iStrLen > 0)))
    {
        return FALSE; 
    }
    pMbausetReq->bAutnFg = (iStrLen > 0) ? Z_APMMIA_VALID : Z_APMMIA_INVALID; 
    return TRUE; 
}

BOOL zAt_PsDecNextParamDecimalNumWordNeed(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, WORD* pMmiaParam, BYTE* pMmiaFalg)
{
    if ((zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) <= 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    return zAt_PsDecParseDecimalWord(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}

/* 617001526821  Ƶ*/
BOOL zAt_PsDecNextParamDecimalNumWord(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppStrParam, WORD* pMmiaParam, BYTE* pMmiaFalg)
{
    SINT16 iSubLen = -1;
    
    if ((iSubLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_INTEGER, ppStrParam)) <= -1)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    else if(iSubLen == 0)
    {
        zAt_PutValue(pMmiaFalg, Z_APMMIA_INVALID);
        return TRUE;
    }
    return zAt_PsDecParseDecimalWord(pPrsCmd2Msg,strSubBuf,pMmiaParam,pMmiaFalg);
}


BOOL zAt_PsDecParseDecimalWord(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, WORD * pMmiaParam, BYTE* pMmiaFalg)
{
    BOOL bStr2ValRet = FALSE;
    UINT32 iTmpVal32 = 0;

    bStr2ValRet = zAt_Str2Value(strSubBuf, ZAT2_IS_DECIMAL_PARAM, &iTmpVal32);
    if (bStr2ValRet && iTmpVal32 <= 0xffff)
    {
        (*pMmiaParam) = (WORD)iTmpVal32;
        zAt_PutValue(pMmiaFalg, Z_APMMIA_VALID);
    }
    else
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

BOOL zAt_PsDecZrefreshSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByteNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZrefreshsetReq->tRefresh.tCmd.bCmdNum),NULL)); 
}

BOOL zAt_PsDecZrefreshSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByteNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZrefreshsetReq->tRefresh.tCmd.bCmdQual),NULL)); 
}

BOOL zAt_PsDecZrefreshSetReqParam3(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZrefreshsetReq->tRefresh.tFileList.bFileNum),NULL)); 
}

BOOL zAt_PsDecZrefreshSetReqParam4(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZrefreshsetReq->tRefresh.tFileList.bFidNum),NULL)); 
}

BOOL zAt_PsDecZrefreshSetReqParam5(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;
    CHAR strByteBuf[ZAT2_BYTE_BUF_LEN] = {0};           /* ˫ַ */
    UINT32 iTmpVal32 = 0;
    SINT16 iStrLen = 0;
    UINT16 i = 0;
    WORD wValue = 0;
    if ((iStrLen = zAt_GetNextParamStr(strSubBuf, ZAT2_PARAM_STRING, ppDecCmdStr)) < 0)
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    if(iStrLen > (Z_APMMIA_USAT_MAX_FILELST_LEN * 4))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE; 
    }
    for (i = 0; i < iStrLen / 2; i++)
    {
        zOss_Memcpy(strByteBuf, &strSubBuf[i * 2], 2);
        if (zAt_Str2Value(strByteBuf, ZAT2_IS_HEX_PARAM, &iTmpVal32) && iTmpVal32 <= 0xff)
        {
            if(i % 2 == 0)
            {
                wValue = (WORD)(iTmpVal32 << 8);
            }
            else
            {
                wValue = (WORD)iTmpVal32 | wValue;
            }
            pZrefreshsetReq->tRefresh.tFileList.awFid[i / 2] = wValue;
        }
        else
        {
            pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
            return FALSE; 
        }
    }
    return TRUE; 
}

BOOL zAt_PsDecZrefreshSetReqParam6(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;

    return ( zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, &(pZrefreshsetReq->tRefresh.tAid.bLen),NULL)); 
}

BOOL zAt_PsDecZrefreshSetReqParam7(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApUicc_Refresh_Req* pZrefreshsetReq = (T_zApUicc_Refresh_Req *)pMsgbody;
    BYTE    bAidLth = 0;
    
    if (!zAt_PsDecPrmHxFormtDefltLngthIsNotFixed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, pZrefreshsetReq->tRefresh.tAid.abAid,&bAidLth, Z_APMMIA_USAT_MAX_AID_LEN))
    {
        return FALSE;
    }
    return TRUE; 
}


BOOL zAt_PsDecSetReqParse(T_ZAt2_AtCmd_ReqId AtId, T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    UINT8 i=0;
    for(i=0; i<g_ParseReqFnc[AtId].TotalParamNum;i++)
    {
        if(!(g_ParseReqFnc[AtId].pFanc[i].parseFun(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, pMsgbody)))
        {
            return FALSE;
        }
    }
    return TRUE;
}

BOOL __ps_4g_func zAt_PsEncReadCnfParse(T_ZAt2_AtCmd_CnfId AtId, CHAR ** ppStrWalk, VOID * pMsgBody)
{
    UINT8 i = 0;
    for(i=0; i<g_ParseCnfFnc[AtId].TotalParamNum;i++)
    {
        if(!(g_ParseCnfFnc[AtId].pFanc[i].parseFun(ppStrWalk, pMsgBody)))
        {
            return FALSE;
        }
    }
    return TRUE;
}
BOOL zAt_PsDecSetReqParam(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, BYTE* pSetPara)
{
    /*617001635997 ͵atӦȱʡֵӦֱӷok*/
    if (zAt_PsDecCmdFirstParamOmitted(pPrsCmd2Msg, (*ppDecCmdStr), pSetPara))
    {
        return TRUE;
    }
    return zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, pSetPara,NULL); 
}

#ifdef PS_RAT_LTE
/* <mode> 617001855004ATIרԡз*/
BOOL zAt_PsDecLteZcsgSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    BYTE bMode = 0xff;
    T_zAti_CsgSel_Req* pZcsgSetReq = (T_zAti_CsgSel_Req *)pMsgbody;
    
    if (zAt_PsDecCmdFirstParamNeeded(pPrsCmd2Msg, (*ppDecCmdStr)) &&
        zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, &bMode,NULL) &&
        bMode <= Z_APMMIA_ZCSGMODE_MANU)
    {
        pZcsgSetReq->bCsgSelMode = bMode;
        return TRUE;
    }
    
    pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
    return FALSE;
}
 /* <act> 617001855004ATIרԡз
      616000237711ʶH+ʾ֧*/
BOOL zAt_PsDecLteZcsgSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    BYTE bAct = 0xff;
    
    T_zAti_CsgSel_Req* pZcsgSetReq = (T_zAti_CsgSel_Req *)pMsgbody;
    pZcsgSetReq->bActFg=Z_APMMIA_INVALID;
    zOss_Memset(&pZcsgSetReq->tPlmnAct.tAct, 0, sizeof(T_z_Act));
    if(!zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, (BYTE *)&bAct,&(pZcsgSetReq->bActFg))
     ||(pZcsgSetReq->bActFg&&bAct > Z_APMMIA_COPSACT_UTRAN_HSPA_PLUS))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    if(pZcsgSetReq->bActFg)
    {
        zAti_ConvertByte2ActStruct(bAct, FALSE, 0xff, &(pZcsgSetReq->tPlmnAct));
    }
    return TRUE;
}
/* <CSG_ID>  <mode> 617001855004ATIרԡз*/
BOOL zAt_PsDecLteZcsgSetReqParam3(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    BOOL bRet = FALSE;
    T_zAti_CsgSel_Req* pZcsgSetReq = (T_zAti_CsgSel_Req *)pMsgbody;
    pZcsgSetReq->bCsgIdFg=Z_APMMIA_INVALID;
    pZcsgSetReq->tCsgId=0;
    bRet = zAt_PsDecNextParamDecimalNumDword(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZcsgSetReq->tCsgId),&(pZcsgSetReq->bCsgIdFg)); 

    if(!bRet||(pZcsgSetReq->bActFg != pZcsgSetReq->bCsgIdFg))
    {
        pPrsCmd2Msg->decRslt2nd = ZAT2_CMD_PARAM_ERR;
        return FALSE;
    }
    return TRUE;
}

/* <OperNum>    617001855004ATIרԡз*/
BOOL zAt_PsDecLteZcsgSetReqParam4(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zAti_CsgSel_Req* pZcsgSetReq = (T_zAti_CsgSel_Req *)pMsgbody;
    return ( zAt_PsDecZcsgOperNumParam(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, &(pZcsgSetReq->tPlmnAct.tPlmnId))); 
}

VOID zAt_PsDecLteCgeqosParamInit(T_zApMmia_CgeqosSet_Req  *pCgeqosSetReq)
{
    pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_NO_CID;
    pCgeqosSetReq->atEpsQosInfo.bQciFlg = Z_APMMIA_INVALID;
    pCgeqosSetReq->atEpsQosInfo.bUlDlGbrFlg= Z_APMMIA_INVALID;
    pCgeqosSetReq->atEpsQosInfo.bUlDlMbrFlg= Z_APMMIA_INVALID;
}
/* <cid> */
BOOL zAt_PsDecLteCgeqosSetReqParam1(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;
    BYTE  bFlag = Z_APMMIA_INVALID;
    /**617001592959  cgeqos޷ȥ***/
    if (strlen((const char *)(*ppDecCmdStr)) == 0)
    {
        pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_NO_CID;
        return TRUE;
    }
    if (!zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.bCid),&bFlag))
    {
        return FALSE;
    }
    if(pCgeqosSetReq->atEpsQosInfo.bCid != 0xff)
    {
        pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_ONLY_CID;
    }
    
    return TRUE;    
}
/*<QCI>*/
BOOL zAt_PsDecLteCgeqosSetReqParam2(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;
    BITS bQciFlg = Z_APMMIA_INVALID;
    
    /**617001592959  cgeqos޷ȥ***/
    if (strlen((const char *)(*ppDecCmdStr)) == 0)
    {
        if (pCgeqosSetReq->bCidFlg == Z_APMMIA_SM_CMD_ONLY_CID)
        {
            pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_ONLY_CID;
        }
        else
        {
            pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_NO_CID;
        }
        pCgeqosSetReq->atEpsQosInfo.bQciFlg = Z_MMIAESM_CMD_WITHOUTCID;
        return TRUE;
    }
    if(zAt_PsDecNextParamDecimalNumByte(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.bQci),&bQciFlg))
    {
        pCgeqosSetReq->atEpsQosInfo.bQciFlg = bQciFlg;
        pCgeqosSetReq->bCidFlg = Z_APMMIA_SM_CMD_NORMAL;
        return TRUE;    
    }
    
    return FALSE;    
}
/*<DL_GBR>*/
BOOL zAt_PsDecLteCgeqosSetReqParam3(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;

    return (zAt_PsDecNextParamDecimalNumDword(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.dwDlGbr),NULL)); 
}
/*< UL_GBR>*/
BOOL zAt_PsDecLteCgeqosSetReqParam4(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;
    BITS bUlDlGbrFlg = Z_APMMIA_INVALID;

    if(zAt_PsDecNextParamDecimalNumDword(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.dwUlGbr),&bUlDlGbrFlg))
    {
        pCgeqosSetReq->atEpsQosInfo.bUlDlGbrFlg = bUlDlGbrFlg;
        return TRUE;    
    }
    
    return FALSE;    
}
/*<DL_  MBR>*/
BOOL zAt_PsDecLteCgeqosSetReqParam5(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;

    return (zAt_PsDecNextParamDecimalNumDword(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.dwDlMbr),NULL)); 
}
/*< UL_MBR>*/
BOOL zAt_PsDecLteCgeqosSetReqParam6(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_CgeqosSet_Req* pCgeqosSetReq = (T_zApMmia_CgeqosSet_Req*)pMsgbody;
    BITS bUlDlMbrFlg = Z_APMMIA_INVALID;

    if(zAt_PsDecNextParamDecimalNumDword(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
        &(pCgeqosSetReq->atEpsQosInfo.dwUlMbr),&bUlDlMbrFlg))
    {
        pCgeqosSetReq->atEpsQosInfo.bUlDlMbrFlg = bUlDlMbrFlg;
        return TRUE;    
    }
    
    return FALSE;    
}


BOOL zAt_PsEncLteCgeqosrdpCnfParam1(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaEsm_EpsQosInfo* pAtEpsQosInfo = (T_zMmiaEsm_EpsQosInfo*) pMsgBody;

    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%s+CGEQOSRDP: %d,", g_zAt_CRLF, pAtEpsQosInfo->bCid);     
    return TRUE;
}

BOOL zAt_PsEncLteCgeqosrdpCnfParam2(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaEsm_EpsQosInfo* pAtEpsQosInfo = (T_zMmiaEsm_EpsQosInfo*) pMsgBody;

    if (pAtEpsQosInfo->bQciFlg == Z_APMMIA_VALID) 
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%d", pAtEpsQosInfo->bQci); 
    }  
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",\"");  

    return TRUE;
}

BOOL zAt_PsEncLteCgeqosrdpCnfParam3(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaEsm_EpsQosInfo* pAtEpsQosInfo = (T_zMmiaEsm_EpsQosInfo*) pMsgBody;

    if (pAtEpsQosInfo->bUlDlGbrFlg == Z_APMMIA_VALID) 
    {
        /**617001587836DL_GBRUL_GBRDL_MBRUL_MBRʾʽ*/
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%lu,%lu", pAtEpsQosInfo->dwDlGbr, pAtEpsQosInfo->dwUlGbr); 
    }  
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",\"");
    return TRUE;
}

BOOL zAt_PsEncLteCgeqosrdpCnfParam4(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaEsm_EpsQosInfo* pAtEpsQosInfo = (T_zMmiaEsm_EpsQosInfo*) pMsgBody;

    if (pAtEpsQosInfo->bUlDlMbrFlg == Z_APMMIA_VALID) 
    {
        /**617001587836DL_GBRUL_GBRDL_MBRUL_MBRʾʽ*/
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%lu,%lu", pAtEpsQosInfo->dwDlMbr, pAtEpsQosInfo->dwUlMbr);
    }  
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",\""); 

    return TRUE;
}

BOOL zAt_PsEncLteCgeqosrdpCnfParam5(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaEsm_EpsQosInfo* pAtEpsQosInfo = (T_zMmiaEsm_EpsQosInfo*) pMsgBody;

    if(pAtEpsQosInfo->bUlDlAmbrFlg == Z_APMMIA_VALID)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%lu,%lu", pAtEpsQosInfo->dwDlAmbr, pAtEpsQosInfo->dwUlAmbr);
    }

    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\""); 

    return TRUE;
}

#endif
BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfParam1(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_Para* pCgcontrdpPara = (T_zMmiaSm_Cgcontrdp_Para*) pMsgBody;

    if(sprintf((char *)(*ppStrWalk), "%s+CGCONTRDP: %d,%d,\"%s\"", g_zAt_CRLF, pCgcontrdpPara->bCid, pCgcontrdpPara->bBearerId, pCgcontrdpPara->abApn)< 0)
    {
        return FALSE;
    }
    (*ppStrWalk) += strlen((const char *)(*ppStrWalk));  

    return TRUE;
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfParamParse(CHAR ** ppStrWalk, BYTE * ppMsgBody, UINT8 iPdpAddrSect, UINT8 iFlag)
{
    UINT8 i = 0;
    
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",");//617001747105 ɹϢʾѡDNSϢ
    if(iFlag == Z_APMMIA_VALID)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\"");
        for (i = 0; i < iPdpAddrSect; i++)
        {
            (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%d.", ppMsgBody[i]);
        }
        (*ppStrWalk)--;
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\"");  
    }
    
    return TRUE;
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param2(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abSrcAddrAndMask), 
        ZAT2_MAX_IPV4_PDPADDR_LEN*2, pAddrInfo->bSrcAddrAndMaskFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param3(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abGwAddr), 
        ZAT2_MAX_IPV4_PDPADDR_LEN, pAddrInfo->bGwAddrFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param4(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abDnsPriAddr), 
        ZAT2_MAX_IPV4_PDPADDR_LEN, pAddrInfo->bDnsPriAddrFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param5(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abDnsSecAddr), 
        ZAT2_MAX_IPV4_PDPADDR_LEN, pAddrInfo->bDnsSecAddrFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param6(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abPCscfPriAddr), 
        ZAT2_MAX_IPV4_PDPADDR_LEN, pAddrInfo->bPCscfPriAddrFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param7(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abPCscfSecAddr), 
        ZAT2_MAX_IPV4_PDPADDR_LEN, pAddrInfo->bPCscfSecAddrFlg);
}

BOOL __ps_4g_func zAt_PsEncLteCgcontrdpCnfV4Param8(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;

    if(pAddrInfo->bImcnSignInd == Z_APMMIA_VALID)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",%d",pAddrInfo->bImcnSignInd);
    }
    return TRUE;
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param2(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abSrcAddrAndMask), 
        Z_APMMIA_SM_MAX_PDPADDR_MASK_LEN, pAddrInfo->bSrcAddrAndMaskFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param3(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abGwAddr), 
        ZAT2_MAX_IPV6_PDPADDR_LEN, pAddrInfo->bGwAddrFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param4(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abDnsPriAddr), 
        ZAT2_MAX_IPV6_PDPADDR_LEN, pAddrInfo->bDnsPriAddrFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param5(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abDnsSecAddr), 
        ZAT2_MAX_IPV6_PDPADDR_LEN, pAddrInfo->bDnsSecAddrFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param6(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abPCscfPriAddr), 
        ZAT2_MAX_IPV6_PDPADDR_LEN, pAddrInfo->bPCscfPriAddrFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param7(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;
    
    return zAt_PsEncLteCgcontrdpCnfParamParse(ppStrWalk, (BYTE *)(pAddrInfo->abPCscfSecAddr), 
        ZAT2_MAX_IPV6_PDPADDR_LEN, pAddrInfo->bPCscfSecAddrFlg);
}

BOOL zAt_PsEncLteCgcontrdpCnfV6Param8(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgcontrdp_AddrInfo* pAddrInfo = (T_zMmiaSm_Cgcontrdp_AddrInfo*) pMsgBody;

    if(pAddrInfo->bImcnSignInd == Z_APMMIA_VALID)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",%d",pAddrInfo->bImcnSignInd);
    }
    return TRUE;
}

BOOL zAt_PsEncLteCgscontrdpCnfParam(CHAR ** ppStrWalk, VOID * pMsgBody)
{
    T_zMmiaSm_Cgscontrdp_Para* pCgscontrdpPara = (T_zMmiaSm_Cgscontrdp_Para*) pMsgBody;

    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%s+CGSCONTRDP: %d,%d,%d", g_zAt_CRLF, pCgscontrdpPara->bCid, pCgscontrdpPara->bPriCid, pCgscontrdpPara->bBearerId); 
    if(pCgscontrdpPara->bImcnSignInd == Z_APMMIA_VALID)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk),",%d",pCgscontrdpPara->bImcnSignInd);
    }

    return TRUE;
}

BOOL zAt_PsDecLteZetwspSetReqParam(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_ZETWSPrimarySet_Req* pZetwspSetReq = (T_zApMmia_ZETWSPrimarySet_Req *)pMsgbody;
    
    return ((zAt_PsDecCmdFirstParamNeeded(pPrsCmd2Msg, (*ppDecCmdStr)))
    &&(zAt_PsDecNextParamDecimalNumBoolNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZetwspSetReq->bETWSSet), NULL))); 

}

BOOL zAt_PsDecLteZetwssSetReqParam(T_ZAt_ParseCmd2MsgRslt   *pPrsCmd2Msg, CHAR * strSubBuf, CHAR **ppDecCmdStr, VOID* pMsgbody)
{
    T_zApMmia_ZETWSSecondarySet_Req* pZetwssSetReq = (T_zApMmia_ZETWSSecondarySet_Req *)pMsgbody;
    
    return ((zAt_PsDecCmdFirstParamNeeded(pPrsCmd2Msg, (*ppDecCmdStr)))
    &&(zAt_PsDecNextParamDecimalNumBoolNeed(pPrsCmd2Msg, strSubBuf, ppDecCmdStr, 
    &(pZetwssSetReq->bETWSSet), NULL))); 

}


VOID zAt_PsEncUiccMbauCnfUnion0(CHAR ** ppStrWalk, T_zApMmia_MbAuth_Cnf *pMbauCnf)
{
    UINT8 i = 0;
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",\"");
    for(i = 0;i < Z_CK_LEN;i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", *((PBYTE)pMbauCnf->uAuthRslt.t3GSuccMbAuth.tCk + i));
    }
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",\"");
    for(i = 0;i < Z_IK_LEN;i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", *((PBYTE)pMbauCnf->uAuthRslt.t3GSuccMbAuth.tIk+ i));
    }
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",\"");
    for(i = 0;i < Z_APMMIA_MAX_LEN_RES;i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", pMbauCnf->uAuthRslt.t3GSuccMbAuth.abRes[i]);
    }
}

VOID zAt_PsEncUiccMbauCnfUnion1(CHAR ** ppStrWalk, T_zApMmia_MbAuth_Cnf *pMbauCnf)
{
    UINT8 i = 0;
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",\"");
    
    for(i = 0;i < Z_APMMIA_MAX_LEN_KC;i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", pMbauCnf->uAuthRslt.t2GmbAuth.abKc[i]);
    }
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",\"");
    for(i = 0;i < Z_APMMIA_MAX_LEN_SRES; i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", pMbauCnf->uAuthRslt.t2GmbAuth.abSres[i]);
    }
}

VOID zAt_PsEncUiccMbauCnfUnion2(CHAR ** ppStrWalk, T_zApMmia_MbAuth_Cnf *pMbauCnf)
{
    UINT8 i = 0;
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",,\"");
    for(i = 0;i < Z_APMMIA_MAX_LEN_AUTS;i++,(*ppStrWalk) += 2)
    {
        sprintf((char *)(*ppStrWalk), "%02X", pMbauCnf->uAuthRslt.t3GsyncErrMbAuth.abAuts[i]);
    }
}

VOID zAt_PsEncUiccMbauCnfEnd(CHAR ** ppStrWalk, T_zApMmia_MbAuth_Cnf *pMbauCnf)
{
    if(pMbauCnf->bUnionId == 0)
    {
        /*ϱresΪʵʵЧַbResLen2*/
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\",%d",pMbauCnf->uAuthRslt.t3GSuccMbAuth.bResLen * 2);
    }
    else if((pMbauCnf->bUnionId == 1) || (pMbauCnf->bUnionId == 2))
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "\"");
    }
    (*ppStrWalk) += sprintf((char *)(*ppStrWalk), "%s%s", g_zAt_CRLF, g_zAt_OK);
}

VOID zAt_PsEncZsetQueryCnfContent(CHAR ** ppStrWalk, T_ZAti_Zset_Req* pZsetCnf)
{
    UINT8 i = 0;
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag1,pZsetCnf->iParam.param1);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag2,pZsetCnf->iParam.param2);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag3,pZsetCnf->iParam.param3);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag4,pZsetCnf->iParam.param4);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag5,pZsetCnf->iParam.param5);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag6,pZsetCnf->iParam.param6);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag7,pZsetCnf->iParam.param7);
    zAt_PsEncZsetQueryCnfParam(ppStrWalk, pZsetCnf->iParam.flag8,pZsetCnf->iParam.param8);
    i = zAt_PsEncZsetQueryCnfFlagCheck(pZsetCnf->iParam.flag1,pZsetCnf->iParam.flag2,pZsetCnf->iParam.flag3,
    pZsetCnf->iParam.flag4,pZsetCnf->iParam.flag5,pZsetCnf->iParam.flag6,pZsetCnf->iParam.flag7,pZsetCnf->iParam.flag8);
    (*ppStrWalk) = (*ppStrWalk) - i;
}

UINT8 zAt_PsEncZsetQueryCnfFlagCheck(UINT32 flg1,UINT32 flg2,UINT32 flg3,UINT32 flg4,UINT32 flg5,UINT32 flg6,UINT32 flg7,UINT32 flg8)
{
    BYTE i = 0;

    if (flg8||(i++, flg7)||(i++, flg6) || (i++, flg5) || (i++, flg4) || (i++, flg3) || (i++, flg2) || (i++, flg1))
    {
        return i;
    }
    return ++i;
}


VOID zAt_PsEncZsetQueryCnfParam(CHAR ** ppStrWalk, UINT32 paramFlag, UINT32 param)
{
    if(paramFlag)
    {
        (*ppStrWalk) += sprintf((char *)(*ppStrWalk), ",%lu", param);
    }
    else
    {
        (*ppStrWalk)+= sprintf((char *)(*ppStrWalk), ",");
    }
}


BOOL __ps_4g_func zAt_UpdateSpaceForLongAt(T_ZAt_EncCmdInfo * pEncCmdInfo, UINT8 Length)
{
    /* ҪZAT2_LONG_CMD_LEN*Lengthȿռ */
    zOss_RetUB(pEncCmdInfo->pStrCmd);
    pEncCmdInfo->pStrCmd = (CHAR *)zAti_GetUB(ZAT_LONG_CMD_LEN * Length); 
    return TRUE;
}

/**************************************************************************
* ƣ zAt_PsEncLteZconstatInd
*  EV_ZATI2_LTE_ZCONSTAT_INDϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZCONSTATϱı뺯
**************************************************************************/
UINT16 zAt_PsEncLteZconstatInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_ZAti_ZconstatInd *pZconstatInd = (T_ZAti_ZconstatInd*) pEncCmdInfo->pMsgBody;    
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZCONSTAT: %d,%d%s",  g_zAt_CRLF, pZconstatInd->iResult,pZconstatInd->iCid, g_zAt_CRLF);
}

/**************************************************************************
* ƣ zAt_PsEncZmsriInd
*  EV_ZATI2_ZMSRI_INDϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZMSRIϱı뺯617001591411 ܻ- ܻV3汾ͬʵ
**************************************************************************/
UINT16 zAt_PsEncZmsriInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZMSRI%s", g_zAt_CRLF, g_zAt_CRLF);
}
#ifdef Z_DUALCARD_ADAPT 
UINT16 zAti_PsCfgStartInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZPSCFGSTART%s", g_zAt_CRLF, g_zAt_CRLF);
}

UINT16 zAti_PsCfgEndInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZPSCFGEND%s", g_zAt_CRLF, g_zAt_CRLF);
}

UINT16 zAti_UserCardDecidInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd, "%s+ZPRIMACARDSEL%s", g_zAt_CRLF, g_zAt_CRLF);
}
#endif
VOID zAt_EncCopnCnf(CHAR * pStrTarget, T_z_PlmnId * ptPlmnId, UINT8 *pSource, UINT8 bSourceLen)
{
    BYTE j= 0;

    pStrTarget += sprintf((char *)pStrTarget, "%s+COPN: \"%X%X%X%X%X", g_zAt_CRLF, ptPlmnId->bMCC1,
    ptPlmnId->bMCC2, ptPlmnId->bMCC3, ptPlmnId->bMNC1, ptPlmnId->bMNC2); 

    if(ptPlmnId->bMNC3 != 0xF)
    {
        pStrTarget += sprintf((char *)pStrTarget,"%X", ptPlmnId->bMNC3);
    }

    pStrTarget += sprintf((char *)pStrTarget,"\",\"");

    for(j= 0; j < bSourceLen; j++)
    {
        pStrTarget += sprintf((char *)pStrTarget,"%c", pSource[j]);
    }
    pStrTarget += sprintf((char *)pStrTarget,"\"%s", g_zAt_CRLF);
}

UINT16 zAt_PsEncCopnExeCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    WORD i = 0;
    BYTE bLen= 0;
    WORD wCurrNum = 0;
    BYTE bInsNo = g_zAti_CurInstance;
    T_zAti_NV_NetPlmnInfo *ptNvNetInfo = ZOSS_NULL;
    T_zAti_NV_MePlmnInfo *ptMeInfo = NULL;
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zAti_Copn_Exe_Cnf *pExeCnf = (T_zAti_Copn_Exe_Cnf*)pEncCmdInfo->pMsgBody;

    wCurrNum = pExeCnf->wCurrNum;

    if(pExeCnf->bMem == Z_ATI_OPLPNN)
    {
        zAti_GetReadCardMutex();
        if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum == 0||
            g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum != pExeCnf->wTotalNum)
        {
            zAti_PutReadCardMutex();
            return 0;
        }

        for(i = wCurrNum; i < (pExeCnf->bIndNum + wCurrNum); i++)
        {
            bLen = (BYTE)strlen((const char*)g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName);

            if(Z_VALID == zAti_IsPlmnIdValid(&g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId) &&
                bLen > 0)
            {
                zAt_EncCopnCnf(pStrWalk, &g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->tPlmnId, 
                    g_zAti_atDataEx[bInsNo].tCrdPnnOpl.atPmnInfo[i]->abFullName, bLen);
                pStrWalk += strlen((const char *)pStrWalk);
            }
        }
        zAti_PutReadCardMutex();
    }
    else if(pExeCnf->bMem == Z_ATI_NET)
    {
        ptNvNetInfo = (T_zAti_NV_NetPlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_NetPlmnInfo));
        zDev_NV_AtiReadItem(Z_ATI_NV_NetOperPlmnID, (PBYTE)ptNvNetInfo);
        for(i = wCurrNum; i < (pExeCnf->bIndNum + wCurrNum); i++)
        {
            bLen = (BYTE)strlen((const char*)ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName);
            if(Z_VALID == zAti_IsPlmnIdValid(&ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId) 
                && bLen > 0)
            {
                zAt_EncCopnCnf(pStrWalk, &ptNvNetInfo->atNvNetPlmnIDInfo[i].tPlmnId, 
                    ptNvNetInfo->atNvNetPlmnIDInfo[i].abFullName, bLen);
                pStrWalk += strlen((const char *)pStrWalk);
            }
        }
        zAti_RetUB((VOID**)&ptNvNetInfo);
    }
    else if(pExeCnf->bMem == Z_ATI_ME)
    {
        /*8KҪп*/
        ptMeInfo = (T_zAti_NV_MePlmnInfo*)zAti_GetUB(sizeof(T_zAti_NV_MePlmnInfo));
        if (ptMeInfo == ZOSS_NULL)
        {
            zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
            return 0;
        }

        zDev_NV_AtiReadItem(Z_ATI_NV_MeOperPlmnID, (PBYTE)ptMeInfo);
        for(i = wCurrNum; i < (pExeCnf->bIndNum + wCurrNum); i++)
        {
            bLen = (BYTE)strlen((const char*)ptMeInfo->atNvMePlmnIDInfo[i].abFullName);
            if(Z_VALID == zAti_IsPlmnIdValid(&ptMeInfo->atNvMePlmnIDInfo[i].tPlmnId) 
                && bLen > 0)
            {
                zAt_EncCopnCnf(pStrWalk, &ptMeInfo->atNvMePlmnIDInfo[i].tPlmnId, 
                    ptMeInfo->atNvMePlmnIDInfo[i].abFullName, bLen);
                pStrWalk += strlen((const char *)pStrWalk);
            }
        }
        zAti_RetUB((VOID**)&ptMeInfo);
    }
    else if(pExeCnf->bMem == Z_ATI_GLOBAL)
    {
        for(i = wCurrNum; i < (pExeCnf->bIndNum + wCurrNum); i++)
        {
            bLen = (BYTE)strlen(g_zAt_Global_Plmninfo[i].Longstr);
            if(bLen > 0 && Z_VALID == zAti_IsPlmnIdValid((T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum))
            {
                zAt_EncCopnCnf(pStrWalk, (T_z_PlmnId*)g_zAt_Global_Plmninfo[i].abNum, 
                    (UINT8*)g_zAt_Global_Plmninfo[i].Longstr, bLen);
                pStrWalk += strlen((const char *)pStrWalk);
            }
        }
    }
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

UINT16 zAt_PsEncCopnEndCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    return (UINT16)sprintf((char *)pEncCmdInfo->pStrCmd,"%s", g_zAt_OK);
}

T_ZAt_ParseCmd2MsgRslt zAt_PsDecLteZconstatSetReq(T_ZAt_DecCmdInfo *pDecCmdInfo)
{
    CHAR* pDecCmdStr = pDecCmdInfo->strParam;   /* ¼ֶεָ */
    CHAR strSubBuf[ZAT2_SUB_PARAM_MAX_LEN] = {0};    /* ŽȡĲַ */
    T_ZAt_ParseCmd2MsgRslt   prsCmd2Msg = {0};
    UINT8 iResult = 0;
    UINT8 channelId = 0;

    if(!(zAt_PsDecNextParamDecimalNumByteNeed( &prsCmd2Msg, strSubBuf, 
        &pDecCmdStr, &iResult, NULL)))
    {
        return prsCmd2Msg;
    }
    if(!(zAt_PsDecNextParamDecimalNumByteNeed( &prsCmd2Msg, strSubBuf, 
        &pDecCmdStr, &channelId, NULL)))
    {
        return prsCmd2Msg;
    }
    zAti_LteZconstatInd(iResult, channelId);
    zOss_Memset(&prsCmd2Msg, 0, sizeof(T_ZAt_ParseCmd2MsgRslt));       
    sprintf((char *)g_zAt_EncBuf, "%s", g_zAt_OK);
    prsCmd2Msg.decRslt2nd = ZAT2_CMD_REPLY_DIRECT;
    return prsCmd2Msg; 
}

/**************************************************************************
* ƣ zAt_PsEncCgpaddrCnf1
*  ˫ջʱѰҲҪƴӵCIDϢͽб
* ˵ (IO)
*   ֵ TRUE ɹ  FALSE ʧ
**************************************************************************/
BOOL zAt_PsEncCgpaddrCnf1(T_zMmiaSm_CidPdpAddr *pCidPdpAddr, CHAR ** ppStrWalk)
{
    BYTE i= 0;
    *ppStrWalk += sprintf((char *)*ppStrWalk, "%s+CGPADDR: %d", g_zAt_CRLF, pCidPdpAddr->bCid);
    *ppStrWalk += sprintf((char *)*ppStrWalk, ",\"");

    if(pCidPdpAddr->tPdpAddr.bPdpType == Z_MMIASM_IPV4)
    {
        for(i=0;i<Z_APMMIA_SM_IPV4_ADDR_MAX_LEN;i++)
        {
            *ppStrWalk += sprintf((char *)*ppStrWalk, "%d.", pCidPdpAddr->tPdpAddr.abIPv4Addr[i]);
        }
        (*ppStrWalk)--;
        *ppStrWalk += sprintf((char *)*ppStrWalk, "\"");
    }
    else if(pCidPdpAddr->tPdpAddr.bPdpType == Z_MMIASM_IPV6)
    {
        for(i=0;i<Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;i++)
        {
            *ppStrWalk += sprintf((char *)*ppStrWalk, "%d.", pCidPdpAddr->tPdpAddr.abIPv6Addr[i]);
        }
        (*ppStrWalk)--;
        *ppStrWalk += sprintf((char *)*ppStrWalk, "\"");
    }
    else if(pCidPdpAddr->tPdpAddr.bPdpType == Z_MMIASM_IPV4V6)
    {
        for(i=0;i<Z_APMMIA_SM_IPV4_ADDR_MAX_LEN;i++)
        {
            *ppStrWalk += sprintf((char *)*ppStrWalk, "%d.", pCidPdpAddr->tPdpAddr.abIPv4Addr[i]);
        }
        (*ppStrWalk)--;
        *ppStrWalk += sprintf((char *)*ppStrWalk, "\",\"");
        for(i=0;i<Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;i++)
        {
            *ppStrWalk += sprintf((char *)*ppStrWalk, "%d.", pCidPdpAddr->tPdpAddr.abIPv6Addr[i]);
        }
        (*ppStrWalk)--;
        *ppStrWalk += sprintf((char *)*ppStrWalk, "\"");
    }
    //--*ppStrWalk += sprintf((char *)*ppStrWalk, "%s", g_zAt_CRLF);
    return TRUE;
}
/***************************************************************************************
:zAt_PsEncCgpaddrCnf2
:ҪƴӵCIDַϢб,CIDĵַýӿڻȡ
˵ (IO)
  ֵ TRUE ɹ  FALSE ʧ
ע:Ҫƴ˵ѾˣԲ迼Ǿַ̬
***************************************************************************************/
BOOL zAt_PsEncCgpaddrCnf2(BYTE bFstCid, BYTE bSecCid, CHAR ** ppStrWalk)
{
    T_zMmiaSm_PdpAddr  *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));
    T_zMmiaSm_PcoInfo   *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_zMmiaSm_PdpAddr  *ptPdpAddrExt = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));
    T_zMmiaSm_PcoInfo   *ptPcoInfoExt = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_zMmiaSm_CidPdpAddr               tPdpCidAddr = {0};
    
    if(zAti_GetPdpInfoByCid(bFstCid, ptPdpAddr, ptPcoInfo, g_zAti_CurInstance) && zAti_GetPdpInfoByCid((UINT8)bSecCid, ptPdpAddrExt, ptPcoInfoExt, g_zAti_CurInstance))
    {
        tPdpCidAddr.tPdpAddr.bPdpType = Z_MMIASM_IPV4V6;
        tPdpCidAddr.bCid = bFstCid;
        if(ptPdpAddr->bPdpType == Z_MMIASM_IPV4 && ptPdpAddrExt->bPdpType == Z_MMIASM_IPV6)
        {
            zOss_Memcpy(tPdpCidAddr.tPdpAddr.abIPv4Addr, ptPdpAddr->abIPv4Addr, ZATI2_SM_IPV4_PDPADDR_LEN);
            zOss_Memcpy(tPdpCidAddr.tPdpAddr.abIPv6Addr, ptPdpAddrExt->abIPv6Addr, ZATI2_SM_IPV6_PDPADDR_LEN);
            zAti_RetUB((VOID **)&ptPdpAddr);
            zAti_RetUB((VOID **)&ptPcoInfo);
            zAti_RetUB((VOID **)&ptPdpAddrExt);
            zAti_RetUB((VOID **)&ptPcoInfoExt);
            return zAt_PsEncCgpaddrCnf1(&tPdpCidAddr, ppStrWalk);
        }
        if(ptPdpAddr->bPdpType == Z_MMIASM_IPV6 && ptPdpAddrExt->bPdpType == Z_MMIASM_IPV4)
        {
            zOss_Memcpy(tPdpCidAddr.tPdpAddr.abIPv4Addr, ptPdpAddrExt->abIPv4Addr, ZATI2_SM_IPV4_PDPADDR_LEN);
            zOss_Memcpy(tPdpCidAddr.tPdpAddr.abIPv6Addr, ptPdpAddr->abIPv6Addr, ZATI2_SM_IPV6_PDPADDR_LEN);
            zAti_RetUB((VOID **)&ptPdpAddr);
            zAti_RetUB((VOID **)&ptPcoInfo);
            zAti_RetUB((VOID **)&ptPdpAddrExt);
            zAti_RetUB((VOID **)&ptPcoInfoExt);
            return zAt_PsEncCgpaddrCnf1(&tPdpCidAddr, ppStrWalk);
        }
    }
    zAti_RetUB((VOID **)&ptPdpAddr);
    zAti_RetUB((VOID **)&ptPcoInfo);
    zAti_RetUB((VOID **)&ptPdpAddrExt);
    zAti_RetUB((VOID **)&ptPcoInfoExt);
    return FALSE;
}

VOID zAt_GetSqByRegState(BYTE bSrcSq, BYTE *pbDestSq)
{
    BYTE bRegState = zAti_GetRegState(); 
    
    if (bRegState == Z_ATI_REGSTATE_NORMAL)
    {
        *pbDestSq = bSrcSq;
    }
    else if (bRegState == Z_ATI_REGSTATE_NOSERVE)
    {
        *pbDestSq = 0;
    }
}
BYTE zAt_GetGsmRssiAndBer(T_zMmiaAs_Cesq_Qry_Cnf *ptCesqQryCnf, BYTE *pRssi, BYTE *pBer)
{
    BYTE bRssi = ptCesqQryCnf->bRssi;
    BYTE bBer  = ptCesqQryCnf->bBer;
    /*bRssiֵ[99,255]ʱó99ЧֵС9963ʱΪ63
        bBERֵ[99,255]ʱó99ЧֵС997ʱΪ7*/
    if (bRssi >= 99)
    {                     
        bRssi = 99;
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bGsmRssi, &bRssi);
    }
    else
    {
        if ((bRssi > 63) && (bRssi < 99))
        {
            bRssi = 63;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bGsmRssi = bRssi;
    }

    if (bBer >= 99)
    {                     
        bBer = 99;
    }
    else if ((bBer > 7) && (bBer < 99))
    {
        bBer = 7;
    }
    
    *pRssi = bRssi;
    *pBer = bBer;

    return Z_VALID;
}
BYTE zAt_GetTdRscp(T_zMmiaAs_Cesq_Qry_Cnf *ptCesqQryCnf, BYTE *pRscp)
{
    BYTE bRscp = ptCesqQryCnf->bRscp;
    
    /*ģʽϢеbRscpֵ(91,255)ʱó91255ʱϱ255ЧֵֵΪ˵
    ӦϱʱҪ5*/

    if (bRscp == 255)
    {
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bTdRscp, &bRscp);
    }
    else
    {
        if ((bRscp > 91) && (bRscp < 255))
        {                     
            bRscp = 91;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bTdRscp = bRscp;
    }

    *pRscp = (bRscp == 255)? 255:(bRscp+5);
    
    return Z_VALID;
}

BYTE zAt_GetWRscpAndEcno(T_zMmiaAs_Cesq_Qry_Cnf *ptCesqQryCnf, BYTE *pRscp, BYTE *pEcno)
{
    BYTE bRscp = ptCesqQryCnf->bRscp;
    BYTE bEcno = ptCesqQryCnf->bEcno;
    
  /*ģʽϢеbRscpֵ(91,255)ʱó91255ʱϱ255ЧֵֵΪ˵
    ӦϱʱҪ5*/
    if (bRscp == 255)
    {
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bWRscp, &bRscp);
    }
    else
    {
        if ((bRscp > 91) && (bRscp < 255))
        {                     
            bRscp = 91;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bWRscp = bRscp;
    }

    if (bEcno == 255)
    {
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bWEcno, &bEcno);
    }
    else
    {
        if ((bEcno > 49) && (bEcno < 255))
        {                     
            bEcno = 49;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bWEcno = bEcno;
    }
    
    *pRscp = (bRscp == 255)? 255:(bRscp+5);
    *pEcno = bEcno;
    
    return Z_VALID;
}

BYTE zAt_GetLteRsrqAndRsrp(T_zMmiaAs_Cesq_Qry_Cnf *ptCesqQryCnf, BYTE *pRsrq, BYTE *pRsrp)
{
    if (ptCesqQryCnf->bRsrq == 255)
    {
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bLteRsrq, &ptCesqQryCnf->bRsrq);
    }
    else
    {
        if ((ptCesqQryCnf->bRsrq > 34) && (ptCesqQryCnf->bRsrq < 255))
        {                     
            ptCesqQryCnf->bRsrq = 34;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bLteRsrq = ptCesqQryCnf->bRsrq;
    }
    
    if (ptCesqQryCnf->bRsrp == 255)
    {
        zAt_GetSqByRegState(g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bLteRsrp, &ptCesqQryCnf->bRsrp);
    }
    else
    {
        if ((ptCesqQryCnf->bRsrp > 97) && (ptCesqQryCnf->bRsrp < 255))
        {                     
            ptCesqQryCnf->bRsrp = 97;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].tCesqSqinfo.bLteRsrp = ptCesqQryCnf->bRsrp;
    }
    
    *pRsrq = ptCesqQryCnf->bRsrq;
    *pRsrp = ptCesqQryCnf->bRsrp;

    return Z_VALID;
}

/**************************************************************************
* ƣ zAt_PsEncCesqQryCnf
*  MMIA_AS_QUERY_CESQ_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +CESQϱı뺯
**************************************************************************/
UINT16 zAt_PsEncCesqQryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    BYTE bRssi = 0;
    BYTE bBer  = 0;
    BYTE bRscp = 0;
    BYTE bRsrq = 0;
    BYTE bRsrp = 0;
    BYTE bEcno = 0;
    T_zMmiaAs_Cesq_Qry_Cnf *ptCesqQryCnf = (T_zMmiaAs_Cesq_Qry_Cnf*)pEncCmdInfo->pMsgBody;
    
    if(Z_NO_ACT == ptCesqQryCnf->bAct)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    switch (ptCesqQryCnf->bAct)
    {
        case Z_GSM_ACT:
            if (Z_INVALID == zAt_GetGsmRssiAndBer(ptCesqQryCnf, &bRssi, &bBer))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
            }
            
            pStrWalk += sprintf((char *)pStrWalk, "%s+CESQ: %d,%d,%d,%d,%d,%d", g_zAt_CRLF,bRssi,bBer,0xff,0xff,0xff,0xff);
            break;
        case Z_TD_ACT:
            if (Z_INVALID == zAt_GetTdRscp(ptCesqQryCnf, &bRscp))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
            }
            pStrWalk += sprintf((char *)pStrWalk, "%s+CESQ: %d,%d,%d,%d,%d,%d", g_zAt_CRLF,99,99,bRscp,0xff,0xff,0xff);
            break;
        case Z_W_ACT:
            if (Z_INVALID == zAt_GetWRscpAndEcno(ptCesqQryCnf, &bRscp, &bEcno))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
            }
            pStrWalk += sprintf((char *)pStrWalk, "%s+CESQ: %d,%d,%d,%d,%d,%d", g_zAt_CRLF,99,99,bRscp,bEcno,0xff,0xff);
            break;
        case Z_LTE_ACT:
            if (Z_INVALID == zAt_GetLteRsrqAndRsrp(ptCesqQryCnf, &bRsrq, &bRsrp))
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
                return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
            }
            pStrWalk += sprintf((char *)pStrWalk, "%s+CESQ: %d,%d,%d,%d,%d,%d", g_zAt_CRLF,99,99,0xff,0xff,bRsrq,bRsrp);
            break;
        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
            return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
BYTE zAti_SetRssiAndAct(BYTE bOldRssi, BYTE bOldAct, BYTE *pbRssi, BYTE *pbAct)
{
    BYTE bRegState = zAti_GetRegState();

    switch (bRegState)
    {
        case Z_ATI_REGSTATE_SEARCH:    /**/
            return Z_INVALID;

        case Z_ATI_REGSTATE_NORMAL:     /*פ*/
            *pbRssi = bOldRssi;
            *pbAct = bOldAct;
            return Z_VALID;
            
        case Z_ATI_REGSTATE_NOSERVE:         /*no cell*/  
        default:
            *pbRssi = 0;
            *pbAct = Z_APMMIA_NOSERVE;
            return Z_VALID;
    }
}

VOID zAti_GrrQryRssiCnf(BYTE bSrcRssi, BYTE bSrcBer, BYTE *pbRssi, BYTE *pbBer, BYTE *pbAct)
{
    if (bSrcRssi >= 99)
    {
        bSrcRssi = 99;
        *pbAct = Z_APMMIA_NOSERVE;
        /*ֻеǰϢʽǰμ¼ʽͬӦñʷֵ
        ܻϱʽ¼ֵ*/
        if (g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct == Z_APMMIA_GSMGPRS)
        {
            zAti_SetRssiAndAct(g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi,g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct,&bSrcRssi, pbAct);
        }
    }
    else
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi = bSrcRssi;
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct = Z_APMMIA_GSMGPRS;
        *pbAct = Z_APMMIA_GSMGPRS;
    }

    *pbRssi = zAti_GetGsmRssi(bSrcRssi);

    *pbBer = bSrcBer;

    if (bSrcBer >= 99)
    {                     
        *pbBer = 99;
    }
    else if ((bSrcBer > 7) && (bSrcBer < 99))
    {
        *pbBer = 7;
    }
    
    return;
}
VOID zAti_TdQryRssiCnf(BYTE bSrcRssi, BYTE *pbRssi, BYTE *pbAct)
{
    if (bSrcRssi >= 99)
    {
        bSrcRssi = 99;
        *pbAct = Z_APMMIA_NOSERVE;
        /*ֻеǰϢʽǰμ¼ʽͬӦñʷֵ
        ܻϱʽ¼ֵ*/
        if (g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct == Z_APMMIA_TDSCDMA)
        {
            zAti_SetRssiAndAct(g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi,g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct,&bSrcRssi,pbAct);
        }
    }
    else
    {
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi = bSrcRssi;
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct = Z_APMMIA_TDSCDMA;
        *pbAct = Z_APMMIA_TDSCDMA;
    }

    *pbRssi = bSrcRssi + 100;
    return;
}

VOID zAti_WQryRssiCnf(BYTE bSrcRssi, BYTE *pbRssi, BYTE *pbAct)
{
    if (bSrcRssi >= 99)
    {
        bSrcRssi = 99;
        *pbAct = Z_APMMIA_NOSERVE;
        /*ֻеǰϢʽǰμ¼ʽͬӦñʷֵ
        ܻϱʽ¼ֵ*/
        if (g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct == Z_APMMIA_WCDMA)
        {
            zAti_SetRssiAndAct(g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi,g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct,&bSrcRssi, pbAct);
        }
    }
    else
    {
        if (bSrcRssi > 76)
        {
            bSrcRssi = 76;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi = bSrcRssi;
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct = Z_APMMIA_WCDMA;
        *pbAct = Z_APMMIA_WCDMA;
    }

    *pbRssi = bSrcRssi;
    return;
}

VOID zAti_LteQryRssiCnf(BYTE bSrcRssi, BYTE *pbRssi, BYTE *pbAct)
{
    *pbRssi = bSrcRssi;
    *pbAct = Z_APMMIA_LTE;
    if (bSrcRssi == 255)
    {
        *pbRssi  = 199;
        *pbAct = Z_APMMIA_NOSERVE;
        /*ֻеǰϢʽǰμ¼ʽͬӦñʷֵ
        ܻϱʽ¼ֵ*/
        if (g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct == Z_APMMIA_LTE)
        {
            zAti_SetRssiAndAct(g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi,g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct,pbRssi,pbAct);
        }
    }
    else
    {
        if (bSrcRssi > 125)
        {
            *pbRssi = 125;
        }
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqRssi = *pbRssi;
        g_zAti_atDataEx[g_zAti_CurInstance].bZcsqAct = Z_APMMIA_LTE;
    }

    return;
}
/**************************************************************************
* ƣ zAt_PsEncZcsqQryCnf
*  MMIA_AS_QUERY_ZCSQ_CNF_EVϢӦĽṹ,öӦAT
* ˵ (IO):
*            pEncCmdInfo:     ϢͳϢ
*   ֵ UINT16  ַȣ0Ϊʧ
* ˵ +ZCSQϱı뺯
**************************************************************************/
UINT16 zAt_PsEncZcsqQryCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    BYTE bRssi = 0;
    BYTE bBer  = 0;
    BYTE bRscp = 0;
    BYTE bAct = Z_APMMIA_NOSERVE;
    T_zMmiaAs_Zcsq_Qry_Cnf *ptQryCnf = (T_zMmiaAs_Zcsq_Qry_Cnf*)pEncCmdInfo->pMsgBody;
    
    if(Z_NO_ACT == ptQryCnf->bAct)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }

    switch (ptQryCnf->bAct)
    {
        case Z_GSM_ACT:
            zAti_GrrQryRssiCnf(ptQryCnf->bRssi, ptQryCnf->bBer, &bRssi, &bBer, &bAct);
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZCSQ: %d,%d,%d", g_zAt_CRLF,bRssi,bBer,bAct);
            break;
        case Z_TD_ACT:
            zAti_TdQryRssiCnf(ptQryCnf->bRssi, &bRscp, &bAct);
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZCSQ: %d,%d,%d", g_zAt_CRLF,bRscp,99,bAct);
            break;
        case Z_W_ACT:
            zAti_WQryRssiCnf(ptQryCnf->bRssi, &bRssi, &bAct);
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZCSQ: %d,%d,%d", g_zAt_CRLF,bRssi,99,bAct);
            break;
        case Z_LTE_ACT:
            zAti_LteQryRssiCnf(ptQryCnf->bRssi, &bRssi, &bAct);
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZCSQ: %d,%d,%d", g_zAt_CRLF,bRssi,99,bAct);
            break;
        default:
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
            return zAt_EncErrorCode(pStrWalk, pEncCmdInfo->cmdId, ZAT2_CMEE_GETNOINFO_ERR);
    }
    
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
VOID zAti_GetPdpAddrByCid(CHAR *pStrWalk, UINT8 bCid)
{
    T_zMmiaSm_PdpAddr *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));  
    T_zMmiaSm_PcoInfo *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_ZAti_SmIpDnsInfo tAddr = {0};
    UINT8 iPdpAddrSect = 0;
    UINT8 i = 0;

    if(zAti_GetPdpInfoByCid(bCid, ptPdpAddr, ptPcoInfo, g_zAti_CurInstance)) /* Ѿ*/
    {
        tAddr.iPdpType = ptPdpAddr->bPdpType;
        tAddr.iCid = bCid;
        zAti_SmSaveIpAddr(&tAddr, ptPdpAddr, ptPcoInfo);
    }
    else
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");//CID not act
    }
    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);

    if (tAddr.iPdpType == Z_APMMIA_SM_IPV4)
    {
        iPdpAddrSect = Z_APMMIA_SM_IPV4_ADDR_MAX_LEN;
    }
    else if (tAddr.iPdpType == Z_APMMIA_SM_IPV6)
    {
        iPdpAddrSect = Z_APMMIA_SM_IPV6_ADDR_MAX_LEN;
    }
#ifdef R8_SUPPORT
    else if (tAddr.iPdpType == Z_APMMIA_SM_IPV4V6)
    {
        iPdpAddrSect = Z_APMMIA_SM_IPV4V6_ADDR_MAX_LEN;
    }
#endif
    else
    {
        return ;
    }

    /* ,<PDP_address>, */
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    for (i = 0; i < iPdpAddrSect; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "%d.", tAddr.iPdpAddr[i]);
    }
    if (iPdpAddrSect > 0)/* ѭҪһλ'.'ȥ  */
    {
        pStrWalk--;
    }
    pStrWalk += sprintf((char *)pStrWalk, "\"");
    return;
}
UINT16 zAt_PsEncZlbsCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    BYTE i = 0;
    BYTE bImeiTmp  = 0;
    T_z_UiccId_ImeiInfo tImeiInfo = {0};
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaAs_LBS_Cnf *pZlbsCnf = (T_zMmiaAs_LBS_Cnf*) pEncCmdInfo->pMsgBody;

    /* +ZLBS: <accesstype>,<Imei>,<cdma>,[<serverIp>],<cellnum>[,<mcc>,<mnc>,<lac>,<cellid>,<signal>]s*/
    pStrWalk += sprintf((char *)pStrWalk, "%s+ZLBS: 0,", g_zAt_CRLF);/*<accesstype>̶0*/
    if (Z_APUICC_CMD_OK != zAti_ReadItem(Z_UiccId_IMEI, 1, 1, (VOID *)&tImeiInfo))
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
    }

    /* <IMEI> */
    pStrWalk += sprintf((char *)pStrWalk, "\"");

    for (i = 0; i < Z_APMMIA_USAT_MAX_IMEI_LEN; i++)
    {
        bImeiTmp = (BYTE)((tImeiInfo.tImei[i] << 4) | (tImeiInfo.tImei[i] >> 4));
        pStrWalk += sprintf((char *)pStrWalk, "%02X", bImeiTmp);
    }
    /*imei15BCDЧ*/
    *(pStrWalk - 1) = 0;
    pStrWalk--;
    pStrWalk += sprintf((char *)pStrWalk, "\",0,");/* <cdma> ̶0*/
    /*[<serverIp>]* *ĬϻȡCID1ip*/
    /*zAti_GetPdpAddrByCid(pStrWalk, 1);
    pStrWalk += (UINT16)strlen((const char *)pStrWalk);
    */
    pStrWalk += sprintf((char *)pStrWalk, ",%d", pZlbsCnf->bCellNum);
    /*[,<mcc>,<mnc>,<lac>,<cellid>,<signal>]s*/
    for (i = 0; i < pZlbsCnf->bCellNum; i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, ",%X%X%X,%X%X", pZlbsCnf->atLbsCell[i].tPlmnId.bMCC1,pZlbsCnf->atLbsCell[i].tPlmnId.bMCC2,\
            pZlbsCnf->atLbsCell[i].tPlmnId.bMCC3, pZlbsCnf->atLbsCell[i].tPlmnId.bMNC1,pZlbsCnf->atLbsCell[i].tPlmnId.bMNC2);
        if (pZlbsCnf->atLbsCell[i].tPlmnId.bMNC3 != 0xF)
        {
            pStrWalk += sprintf((char *)pStrWalk,"%X", pZlbsCnf->atLbsCell[i].tPlmnId.bMNC3);
        }
        pStrWalk += sprintf((char *)pStrWalk,",%d,%lu,%d", pZlbsCnf->atLbsCell[i].wTac,pZlbsCnf->atLbsCell[i].dwCellId,pZlbsCnf->atLbsCell[i].sSignal);
    }

    pStrWalk += sprintf((char *)pStrWalk, "%s",g_zAt_CRLF);
    //sprintf((char *)pStrWalk, "%s", g_zAt_OK);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}

#ifdef DSDS_VSIM
UINT16 zAt_PsEncCardSwitchReqCnf(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    T_zMmiaAs_CardSwitch_Cnf *pCardSwitchCnf = (T_zMmiaAs_CardSwitch_Cnf*) pEncCmdInfo->pMsgBody;

    return zAt_PsEncCommonResult(pEncCmdInfo, pCardSwitchCnf->bResult, Z_SUCC, Z_FAIL, 100);
}

UINT16 zAt_PsEncCardSwitchReqInd(T_ZAt_EncCmdInfo * pEncCmdInfo)
{
    CHAR * pStrWalk = pEncCmdInfo->pStrCmd;
    T_zMmiaUmm_CardSwitchReq_Ind *ptCardSwitchInd = (T_zMmiaUmm_CardSwitchReq_Ind*) pEncCmdInfo->pMsgBody;

    if(ptCardSwitchInd->bSim1Act == ptCardSwitchInd->bSim2Act)
    {
        zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
        return 0;
    }

    sprintf((char *)pStrWalk, "%s+ZCARDSWITCHIND: %d,%d,%d%s", g_zAt_CRLF, ptCardSwitchInd->bSim1Act, 
    ptCardSwitchInd->bSim2Act, ptCardSwitchInd->bSwitchStat, g_zAt_CRLF);

    return (UINT16)strlen((const char *)pEncCmdInfo->pStrCmd);
}
#endif

