//#include <message.h>
#include <limits.h>
#include <errno.h>
#include <wifi.h>
#include "wlan_interface.h"
#include "softap_api.h"

#define WIFI_SSID_LEN        33
#define WLAN_SECURITY_LEN    20
#define WLAN_ENCRYTYPE_LEN   10
#define WLAN_DEFAULTID_LEN    2
#define WLAN_WEPKEY_LEN      32
#define WLAN_PSK_LEN         65
#define WLAN_ENCODE_PSK_LEN 100

#define WF_AU_OPEN          "OPEN"            //wifi auth mode?
#define WF_AU_SHARE         "SHARED"
#define WF_AU_WEPAUTO       "WEPAUTO"
#define WF_AU_WPA           "WPAPSK"
#define WF_AU_WPA2          "WPA2PSK"
#define WF_AU_WPA_WPA2  	"WPAPSKWPA2PSK" 
#define WF_AU_WAPIPSK	    "WAPIPSK"
#define WF_ENCRY_NONE       "NONE"   //encrypt
#define WF_ENCRY_WEP        "WEP"
#define WF_ENCRY_TKIP       "TKIP"
#define WF_ENCRY_CCMP       "CCMP"
#define WF_ENCRY_AES        "AES"
#define WF_ENCRY_TKIP_CCMP  "TKIPCCMP"
#define WF_ENCRY_TKIP_AES   "TKIPAES"

#define MAX_WIFI_NUM 32

static int zte_station_connect_time_calc(char *timeStr);
static void zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList);
//int get_vap_sta_num(char *vapIface);

static int zte_wlan_ssid1_basic_set(char *ssid_in)
{
    char  *ssid = NULL; 
	char nv_tmp[WIFI_SSID_LEN] = {0};
	
	if (NULL == ssid_in)
	{
		printf("input ssid is null\n");
		return -1;
	}

	if ((!strcmp(ssid_in, "")) || (strlen(ssid_in) <= 0) || (strlen(ssid_in) > WIFI_SSID_LEN))
	{
		printf("input ssid is error\n");
		return -1;
	}
    
    //ssid
    memset(nv_tmp, 0, sizeof(nv_tmp));
	//kw 3
    sc_cfg_get("SSID1", nv_tmp, sizeof(nv_tmp));
    if (0 != strcmp(ssid_in, nv_tmp))
    {
        sc_cfg_set("SSID1", ssid_in);
		//sc_cfg_save();
    }
	else
	{
		printf("input ssid is same \n");
		return 1;
	}

    return 0;
}

static int zte_wlan_ssid1_security_set(char *password)
{	
    char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};
    int changeSecurityMode = 1;
    
	sc_cfg_get("AuthMode", authMode, sizeof(authMode));
	sc_cfg_get("EncrypType", encrypType, sizeof(encrypType));

	//kw 3  
    printf("wlan_ssid1_security_set authMode = [%s]\n", authMode);
	printf("wlan_ssid1_security_set encrypType = [%s]\n", encrypType);   
	if(NULL == password)//&& (!(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))))
	{
		printf("wlan_ssid1_security_set password is null\n");
		return -1;
	}
#if 0 //kw 3
	if((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_NONE)))
	{
		if(strlen(password) == 0 || (!strcmp(password, "")))
		{
			printf("%s, WF_AU_OPEN password len is 0\n", __FUNCTION__);
			return 1;
		}
		else 
		{
			if((strlen(password) < 8) || (strlen(password) > 64))
			{
				printf("%s,  password len is error\n", __FUNCTION__);
				return -1;
			}
		}
	}
	else
	{
		if((strlen(password) < 8) || (strlen(password) > 64) || (!strcmp(password, "")))
		{
			printf("%s, not open password len is error\n", __FUNCTION__);
			return -1;
		}
	}
#endif	
	if(((!strcmp(authMode, WF_AU_WPA_WPA2)) && (!strcmp(encrypType, WF_ENCRY_TKIP_AES))))
	{
		changeSecurityMode = 0;
	}
	else
	{
		sc_cfg_set("AuthMode", WF_AU_WPA_WPA2);
		sc_cfg_set("EncrypType", WF_ENCRY_TKIP_AES);
	}
    if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
    {   
        if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
        	 (!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
        {
		    int len = 0;
			len = strlen(password);
			if(len != 5 && len != 10 && len != 13 && len != 26) //kw 3 ;wep 5,13(no 16)
			{
				printf("wlan_ssid1_security_set wep psk len = [%d]\n", len);  
				return -1;
			}
			sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
 			//kw 3
			char old_wep_key[WLAN_WEPKEY_LEN] = {0};
			
			if(!strcmp(DefaultKeyID, "1"))
			{
				sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key2Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else if(!strcmp(DefaultKeyID, "2"))
			{
                sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
				
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key3Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else if(!strcmp(DefaultKeyID, "3"))
			{
				sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key4Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
			else 
			{
				sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
				if(strcmp(old_wep_key, password))
				{
					sc_cfg_set("Key1Str1", password);
					//sc_cfg_save();
				}
				else
				{
					printf("wlan_ssid1_security_set wep psk is same\n");  
					return 1;
				}
			}
		
        }
        else if(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))
        {
            printf("authMode is open and not wep \n");
			return 1;

        }
    }
    else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
    {
		char psk[WLAN_PSK_LEN] = {0};
        int len = 0;
		char encode[WLAN_ENCODE_PSK_LEN] = {0};
		len = strlen(password);
		
		if(len < 8 || len > 64)
		{
			printf("%s password len is %d \n",authMode, len);
			return -1;
		}
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		//kw 3
		if(strcmp(psk, password))
		{
			sc_cfg_set("WPAPSK1", password);
			base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
			sc_cfg_set("WPAPSK1_encode", encode);
			//sc_cfg_save();
		}
		else
		{
			if(!changeSecurityMode)
			{
				printf("%s, wpapskwpa2psk psk is same\n", __FUNCTION__);
				return 1;
			}
		}

    }
	else if(!strcmp(authMode, WF_AU_WAPIPSK))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		int len = 0;
		char encode[WLAN_ENCODE_PSK_LEN] = {0};
		len = strlen(password);
		
		if(len < 8 || len > 64)
		{
			printf("WF_AU_WAPIPSK password len is %d \n", len);
			return -1;
		}
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		//kw 3
		if(strcmp(psk, password))
		{
			sc_cfg_set("WPAPSK1", password);
			base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
			sc_cfg_set("WPAPSK1_encode", encode);
			//sc_cfg_save();
		}
		else
		{
			if(!changeSecurityMode)
			{
				printf("%s, wapi psk is same\n", __FUNCTION__);
				return 1;
			}
		}
	
	}
    else
    {
        // other security mode is invalid
        printf("ERROR:security mode  is invalid\n");
        return -1;
    }

    return 0;
}

int zte_wlan_get_ssid1_settings(char* ssid, char* password, int ssid_len, int password_len)
{
	char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};

	if(NULL == ssid || NULL == password)
	{
		printf("ERROR:input ssid && password is null\n");
		return -1;
	}
	
	//kw 3
	char old_ssid[WIFI_SSID_LEN] = {0};
	sc_cfg_get("SSID1",old_ssid,sizeof(old_ssid));
	strncpy(ssid, old_ssid, ssid_len - 1);

	sc_cfg_get("AuthMode",authMode,sizeof(authMode));
	sc_cfg_get("EncrypType",encrypType,sizeof(encrypType));

	printf("wlan_ssid1_security_get authMode = [%s]\n", authMode);   
	printf("wlan_ssid1_security_get encrypType = [%s]\n", encrypType);   

	if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
	{   
		if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
			(!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
		{
			sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));

			char old_wep_key[WLAN_WEPKEY_LEN] = {0};
			if(!strcmp(DefaultKeyID, "1"))
			{
				sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else if(!strcmp(DefaultKeyID, "2"))
			{
				sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else if(!strcmp(DefaultKeyID, "3"))
			{
				sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
			else 
			{
				sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
				strncpy(password, old_wep_key, password_len-1);
			}
		
		}
    }
	else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		strncpy(password, psk, password_len-1);
	}
	else if(!strcmp(authMode, WF_AU_WAPIPSK))
	{
		char psk[WLAN_PSK_LEN]                = {0};
		sc_cfg_get("WPAPSK1",psk,sizeof(psk));
		strncpy(password, psk, password_len-1);
	}
	else
	{
		return -1;
	}

	return 0;
}

int zte_wlan_ssid1_set(char* ssid, char* password)
{
	int ret_for_basic = 0;
	int ret_for_security = 0;
	
	ret_for_basic = zte_wlan_ssid1_basic_set(ssid);
    if(-1 == ret_for_basic)
    {
        printf("wlan_ssid1_basic_set is false\n");
        return -1;
    }
	ret_for_security = zte_wlan_ssid1_security_set(password);
    if(-1 == ret_for_security)
    {
        printf("call lan_ssid1_security_set failure .\n");   
		return -1;//kw 3
	}
	
    if(ret_for_basic == 0 || ret_for_security == 0)
	{
		if(0 == ipc_send_message(MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, 2, "1", 0))
		{
			//sc_cfg_set("RadioOff", "0");
			printf("wifi set cmd done!\n");
		}
		else
		{
			printf("wifi set cmd wlan_ssid1_set error!\n");
			return -1;
		}
    }
    return 0; 
}

//wifi_hal.c of realtek, in order to capture sta num of va0 and va1(if multi ssid is enabled)
int zte_wlan_capture_sta_num()
{
	int staTotalNum = 0;
	char wifi_cur_state[8] = {0};
	char sta_count[8] = {0};

	sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
	
	if( !strncmp(wifi_cur_state,"0",1) )
	{
	    printf("[%s]wifi is off, can't obtain sta info!!\n",__FUNCTION__);
	    return 0;
	}
	sc_cfg_get("sta_count",sta_count,sizeof(sta_count));

	staTotalNum = atoi(sta_count);
	
	printf("[%s] staTotalNum = %d\n",__FUNCTION__,staTotalNum);
	return staTotalNum;
 }


static int zte_station_connect_time_calc(char* timeStr)
{
    //timeStr : [1 hr 2 min 3 sec]
	//char timeStr[32] = {0};
    char *splited_val = NULL;
    char *splited_str = NULL;
    char *delimiter = " ";
    char *save = NULL;
    int time = 0;
	int splited_int = 0;

	//strncpy(timeStr, str, 31);
	//timeStr[31] = '\0';
	printf("timeStr %s\n", timeStr);
    splited_val = strtok_r(timeStr, delimiter, &save);
    if(NULL != splited_val)
    {
		printf("splited_val is %s\n", splited_val);
        splited_str = strtok_r(NULL, delimiter, &save);
    }
	else
	{
		printf("splited_val is NULL\n");
	}
    
    while(NULL != splited_val && NULL != splited_str)
    {
		printf("val %s, str %s\n", splited_val, splited_str);
		splited_int = atoi(splited_val);

		if(splited_int < 0 || splited_int > INT_MAX-1) {//kw 3
			printf("[%s]splited_int error: %d!!\n",__FUNCTION__,splited_int);
	    	return 0;
		}
        if(0 == strncmp(splited_str, "hr", 2))
        {
            time += splited_int * 60 * 60;
        }else if(0 == strncmp(splited_str, "min", 3))
        {
            time += splited_int * 60;
        }else if(0 == strncmp(splited_str, "sec", 3))
        {
            time += splited_int;
        }
        splited_val = strtok_r(NULL, delimiter, &save);
        if(NULL != splited_val)
        {
            splited_str = strtok_r(NULL, delimiter, &save);
        }        
    }
    char temp[32] = {0};
    sprintf(temp, "%d", time);
    sc_cfg_set("link_time", temp);
    return time;
}

int  copyfile(const char *source, const char * target)
{
    FILE  *fp_s = NULL;
    FILE  *fp_t = NULL;
    char  buf[1024]={0};
    int  lenR = 0;
    int  lenW=0;

    if( NULL== source  || NULL == target) return -1;
    if((fp_s = fopen(source,"r"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", source);
        return -1;
    }

    if((fp_t = fopen(target,"w"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", target);
        fclose(fp_s); //kw 3
        return -1;
    }

    while((lenR = fread(buf, 1, 1024, fp_s)) > 0)
    {
        if((lenW = fwrite(buf, 1, lenR, fp_t)) != lenR)
        {
            printf("[copyfile]sunwenming write to %s failed\n", target);
        	fclose(fp_s); //kw 3
        	fclose(fp_t);
            return  -1;
        }
        memset(buf, 0, 1024);
    }
	//kw 3
    fclose(fp_s);
    fclose(fp_t);
    return 0;
}


static void  zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList)
{
	char station_mac_tmp[MAX_NUMBER_OF_MAC*20] = {0};
	char sta_count[8] = {0};
	char * p = NULL;
	int i =0;
	char mac_tmp[18] = {0};
	sc_cfg_get("station_mac", station_mac_tmp, sizeof(station_mac_tmp));
	sc_cfg_get("sta_count", sta_count, sizeof(sta_count));

	staList->Num = atoi(sta_count);
	if (staList->Num > MAX_NUMBER_OF_MAC) {//kw
		printf("sta_count=%s, Num=%d\n", sta_count, staList->Num);
		return;
	}
		
	p = station_mac_tmp;
	printf("station_mac=%s\n", station_mac_tmp);
	for(i=0;i < staList->Num; i++ )
	{            

		unsigned char addr[6] = {0};
		memset(mac_tmp, 0, 18);  
		strncpy(mac_tmp, p, 17); p+= 18;
		printf("mac_tmp=%s\n", mac_tmp);
		sscanf(mac_tmp, "%2x:%2x:%2x:%2x:%2x:%2x", (unsigned int *)&addr[0], (unsigned int *)&addr[1],
		(unsigned int *)&addr[2],(unsigned int *)&addr[3],(unsigned int *)&addr[4],(unsigned int *)&addr[5]);//kw
		printf("[addr=]%2x:%2x:%2x:%2x:%2x:%2x\n", addr[0], addr[1],
		addr[2],addr[3],addr[4],addr[5]);
		
		memcpy((void*)(staList->Entry[i].Addr), (void*)addr, 6);
	}    


}
 
void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList)
{
	int i = 0;
	char wifi_cur_state[8]={0};

	sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
	if(atoi(wifi_cur_state) == 0)
	{
	    	printf("wifi is Off, can not read sta_info\n");
	   	 return;
	}        

	zte_get_vap_sta_list(staList);

}
#if 0 //kw 3
int get_channel()
{
	char channel[8] = {0};
	pipecmd("iwpriv wlan0 get_mib channel |cut -d':' -f2", channel);
	return atoi(channel);
}
#endif
