/**************************************************************************
*
*                  Copyright (c) 2014 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : RWNvConfig.h
* ļ : 
* ʵֹ : 
*      : 
*      : 
*  : 
* ˵ :         
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _RWNVCONFIG_H
#define _RWNVCONFIG_H

#include "RONvConfig.h"

/****************************************************************************
	                                      rwo area
****************************************************************************/

#define OS_FLASH_RWO_OFFSET_FROM_NV                 (OS_FLASH_ROW_OFFSET_FROM_NV + OS_FLASH_ROW_NVRAM_SIZE) /* ƶдƫ */
#define OS_FLASH_RWO_NVRAM_SIZE                     (512 * 1024)

/***************************
 AMT user config  42KB : LTE 10KB
***************************/
#define OS_FLASH_AMT_RW_USER_LTE_OFFSET_FROM_NV     OS_FLASH_RWO_OFFSET_FROM_NV
#define OS_FLASH_AMT_RW_USER_LTE_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_AMT_RW_USER_LTE_OFFSET_FROM_NV)
#define OS_FLASH_AMT_RW_USER_LTE_SIZE               (10 * 1024)
	
/***************************
 AMT user config  42KB: TDS 3KB
***************************/
#define OS_FLASH_AMT_RW_USER_TDS_OFFSET_FROM_NV     (OS_FLASH_AMT_RW_USER_LTE_OFFSET_FROM_NV + OS_FLASH_AMT_RW_USER_LTE_SIZE)
#define OS_FLASH_AMT_RW_USER_TDS_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_AMT_RW_USER_TDS_OFFSET_FROM_NV)
#define OS_FLASH_AMT_RW_USER_TDS_SIZE               (3 * 1024)
	
/***************************
 AMT user config  42KB:GGE 7KB
***************************/
#define OS_FLASH_AMT_RW_USER_GGE_OFFSET_FROM_NV     (OS_FLASH_AMT_RW_USER_TDS_OFFSET_FROM_NV + OS_FLASH_AMT_RW_USER_TDS_SIZE)
#define OS_FLASH_AMT_RW_USER_GGE_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_AMT_RW_USER_GGE_OFFSET_FROM_NV)
#define OS_FLASH_AMT_RW_USER_GGE_SIZE               (7 * 1024)
	
/***************************
 AMT user config  42KB: WCDMA 10KB
***************************/
#define OS_FLASH_AMT_RW_USER_WCDMA_OFFSET_FROM_NV   (OS_FLASH_AMT_RW_USER_GGE_OFFSET_FROM_NV + OS_FLASH_AMT_RW_USER_GGE_SIZE)
#define OS_FLASH_AMT_RW_USER_WCDMA_BASE_ADDR        (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_AMT_RW_USER_WCDMA_OFFSET_FROM_NV)
#define OS_FLASH_AMT_RW_USER_WCDMA_SIZE             (10 * 1024)
	
/***************************
 AMT user config  42KB: LTEA 27KB
***************************/
#define OS_FLASH_AMT_RW_USER_LTEA_OFFSET_FROM_NV    (OS_FLASH_AMT_RW_USER_WCDMA_OFFSET_FROM_NV + OS_FLASH_AMT_RW_USER_WCDMA_SIZE)
#define OS_FLASH_AMT_RW_USER_LTEA_BASE_ADDR         (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_AMT_RW_USER_LTEA_OFFSET_FROM_NV)
#define OS_FLASH_AMT_RW_USER_LTEA_SIZE              (27 * 1024)
	
/***************************
 LTE  physical area config 0KB
***************************/
#define OS_FLASH_LTEPHY_RW_NONFAC_OFFSET_FROM_NV    (OS_FLASH_AMT_RW_USER_LTEA_OFFSET_FROM_NV  + OS_FLASH_AMT_RW_USER_LTEA_SIZE)
#define OS_FLASH_LTEPHY_RW_NONFAC_BASE_ADDR         (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_LTEPHY_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_LTEPHY_RW_NONFAC_SIZE              (0 * 1024)
	
/***************************
 TDS physical area config  2KB
***************************/
#define OS_FLASH_TDPHY_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_LTEPHY_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_LTEPHY_RW_NONFAC_SIZE)
#define OS_FLASH_TDPHY_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_TDPHY_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_TDPHY_RW_NONFAC_SIZE               (2 * 1024)
	
/***************************
 GSM l1g area config 14KB
***************************/
#define OS_FLASH_GSML1G_RW_NONFAC_OFFSET_FROM_NV    (OS_FLASH_TDPHY_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_TDPHY_RW_NONFAC_SIZE)
#define OS_FLASH_GSML1G_RW_NONFAC_BASE_ADDR         (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_GSML1G_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_GSML1G_RW_NONFAC_SIZE              (14 * 1024)
	
/***************************
 WCDMA physical area config  2KB
***************************/
#define OS_FLASH_WCDMAPHY_RW_NONFAC_OFFSET_FROM_NV  (OS_FLASH_GSML1G_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_GSML1G_RW_NONFAC_SIZE)
#define OS_FLASH_WCDMAPHY_RW_NONFAC_BASE_ADDR       (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_WCDMAPHY_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_WCDMAPHY_RW_NONFAC_SIZE            (2 * 1024)
	
/***************************
 LTEA physical area config	16KB
***************************/
#define OS_FLASH_LTEAPHY_RW_NONFAC_OFFSET_FROM_NV   (OS_FLASH_WCDMAPHY_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_WCDMAPHY_RW_NONFAC_SIZE)
#define OS_FLASH_LTEAPHY_RW_NONFAC_BASE_ADDR        (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_LTEAPHY_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_LTEAPHY_RW_NONFAC_SIZE             (16 * 1024)
	
/***************************
 zx_rf m0 config	20KB
***************************/
#define OS_FLASH_ZXRFM0_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_LTEAPHY_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_LTEAPHY_RW_NONFAC_SIZE)
#define OS_FLASH_ZXRFM0_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_ZXRFM0_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_ZXRFM0_RW_NONFAC_SIZE               (20 * 1024)
	
/***************************
 tx event table 64KB
***************************/
#define OS_FLASH_TXETAB_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_ZXRFM0_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_ZXRFM0_RW_NONFAC_SIZE)
#define OS_FLASH_TXETAB_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_TXETAB_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_TXETAB_RW_NONFAC_SIZE               (64 * 1024)

/***************************
 phycom area 2KB
***************************/
#define OS_FLASH_RFCOM_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_TXETAB_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_TXETAB_RW_NONFAC_SIZE)
#define OS_FLASH_RFCOM_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_RFCOM_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_RFCOM_RW_NONFAC_SIZE               (2 * 1024)

/***************************
 rwo area reserved 335KB
***************************/
#define OS_FLASH_RWO_RESERVED_OFFSET_FROM_NV         (OS_FLASH_RFCOM_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_RFCOM_RW_NONFAC_SIZE)
#define OS_FLASH_RWO_RESERVED_BASE_ADDR              (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_RWO_RESERVED_OFFSET_FROM_NV)
#define OS_FLASH_RWO_RESERVED_SIZE                   (335 * 1024)

/****************************************************************************
	                                      rw area
****************************************************************************/
#define OS_FLASH_RW_OFFSET_FROM_NV                  (OS_FLASH_RWO_OFFSET_FROM_NV + OS_FLASH_RWO_NVRAM_SIZE) /* дƫ */
#define OS_FLASH_RW_NVRAM_SIZE                      (768 * 1024)

/***************************
 TSP area config    2KB
***************************/
#define OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV       OS_FLASH_RW_OFFSET_FROM_NV
#define OS_FLASH_TSP_RW_NONFAC_BASE_ADDR            (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_TSP_RW_NONFAC_SIZE                 (2 * 1024)
#define OS_FLASH_TSP_RW_NONFAC_AT_MODE_ADDR         (OS_FLASH_TSP_RW_NONFAC_BASE_ADDR + 1024)


/***************************
 ATI area config  2KB
***************************/
#define OS_FLASH_ATI_RW_NONFAC_OFFSET_FROM_NV       (OS_FLASH_TSP_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_TSP_RW_NONFAC_SIZE)
#define OS_FLASH_ATI_RW_NONFAC_BASE_ADDR            (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_ATI_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_ATI_RW_NONFAC_SIZE                 (2 * 1024)

/***************************
 at config setting   1KB
***************************/
#define OS_FLASH_ATCFG_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_ATI_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_ATI_RW_NONFAC_SIZE)
#define OS_FLASH_ATCFG_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_ATCFG_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_ATCFG_RW_NONFAC_SIZE               (1 * 1024)

/***************************
 phy config    2KB
***************************/
#define OS_FLASH_PHYCFG_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_ATCFG_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_ATCFG_RW_NONFAC_SIZE)
#define OS_FLASH_PHYCFG_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_PHYCFG_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_PHYCFG_RW_NONFAC_SIZE               (2 * 1024)

/***************************
volte area config    1KB
***************************/
#define OS_FLASH_VOLTE_RW_NONFAC_OFFSET_FROM_NV    (OS_FLASH_PHYCFG_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_PHYCFG_RW_NONFAC_SIZE)
#define OS_FLASH_VOLTE_RW_NONFAC_BASE_ADDR         (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_VOLTE_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_VOLTE_RW_NONFAC_SIZE              (1 * 1024)

/***************************
 ps area config   64KB
***************************/
#define OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV        (OS_FLASH_VOLTE_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_VOLTE_RW_NONFAC_SIZE)
#define OS_FLASH_PS_RW_NONFAC_BASE_ADDR             (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_PS_RW_NONFAC_SIZE                  (64 * 1024)

/***************************
 driver area config  16KB
***************************/
#define OS_FLASH_DRV_RW_NONFAC_OFFSET_FROM_NV       (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_PS_RW_NONFAC_SIZE)
#define OS_FLASH_DRV_RW_NONFAC_BASE_ADDR            (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_DRV_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_DRV_RW_NONFAC_SIZE                 (16 * 1024)

/***************************
plat area config  0KB
***************************/
#define OS_FLASH_PLAT_RW_NONFAC_OFFSET_FROM_NV      (OS_FLASH_DRV_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_DRV_RW_NONFAC_SIZE)
#define OS_FLASH_PLAT_RW_NONFAC_BASE_ADDR           (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_PLAT_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_PLAT_RW_NONFAC_SIZE                (0 * 1024)

/***************************
user area config    0KB
***************************/
#define OS_FLASH_USER_RW_NONFAC_OFFSET_FROM_NV      (OS_FLASH_PLAT_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_PLAT_RW_NONFAC_SIZE)
#define OS_FLASH_USER_RW_NONFAC_BASE_ADDR           (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_USER_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_USER_RW_NONFAC_SIZE                0

/***************************
 voice area config 64KB
***************************/
#define OS_FLASH_VOICE_RW_NONFAC_OFFSET_FROM_NV     (OS_FLASH_USER_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_USER_RW_NONFAC_SIZE)
#define OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR          (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_VOICE_RW_NONFAC_OFFSET_FROM_NV)
#define OS_FLASH_VOICE_RW_NONFAC_SIZE               (64 * 1024)

/******************************
 ref RWdate area 16KB
******************************/
#define OS_FLASH_REF_DESIGN_RW_OFFSET_FROM_NV       (OS_FLASH_VOICE_RW_NONFAC_OFFSET_FROM_NV + OS_FLASH_VOICE_RW_NONFAC_SIZE)
#define OS_FLASH_REF_DESIGN_RW_BASE_ADDR            (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_REF_DESIGN_RW_OFFSET_FROM_NV)
#define OS_FLASH_REF_DESIGN_RW_SIZE                 (16 * 1024)

/******************************
 reserved RWdate area config  600KB
******************************/
#define OS_FLASH_RW_RESERVED_OFFSET_FROM_NV         (OS_FLASH_REF_DESIGN_RW_OFFSET_FROM_NV + OS_FLASH_REF_DESIGN_RW_SIZE)
#define OS_FLASH_RW_RESERVED_BASE_ADDR              (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_RW_RESERVED_OFFSET_FROM_NV)
#define OS_FLASH_RW_RESERVED_SIZE                   (600 * 1024)

/******************************
 nv flag area
******************************/
#define OS_FLASH_FLAG_NVRAM_BASE_ADD                (OS_FLASH_RW_OFFSET_FROM_NV + OS_FLASH_RW_NVRAM_SIZE)
#define OS_FLASH_FLAG_NVRAM_SIZE                    (1024 * 1024)

/******************************
 work area symbol 1 BYTE
*******************************/
#define OS_FLASH_WORK_AREA_SYMBOL_BASE_ADDR         (OS_FLASH_FLAG_NVRAM_BASE_ADD)
#define OS_FLASH_WORK_AREA_SYMBOL_SIZE              (256 * 1024)

/******************************
 backup area symbol 1 BYTE 
******************************/
#define OS_FLASH_BACKUP_AREA_SYMBOL_BASE_ADDR       (OS_FLASH_WORK_AREA_SYMBOL_BASE_ADDR+OS_FLASH_WORK_AREA_SYMBOL_SIZE)
#define OS_FLASH_BACKUP_AREA_SYMBOL_SIZE            (256 * 1024)

/******************************
 factory area symbol 1 BYTE 
******************************/
#define OS_FLASH_FACTORY_AREA_SYMBOL_BASE_ADDR      (OS_FLASH_BACKUP_AREA_SYMBOL_BASE_ADDR+OS_FLASH_BACKUP_AREA_SYMBOL_SIZE)
#define OS_FLASH_FACTORY_AREA_SYMBOL_SIZE           (256 * 1024)

/******************************
 reset factory symbol 1 BYTE 
******************************/
#define OS_FLASH_RESET_FACTORY_SYMBOL_BASE_ADDR     (OS_FLASH_FACTORY_AREA_SYMBOL_BASE_ADDR+OS_FLASH_FACTORY_AREA_SYMBOL_SIZE)
#define OS_FLASH_RESET_FACTORY_SYMBOL_SIZE          (256 * 1024)

/******************************
 RWdate BACKUP area  0.75M
******************************/
#define OS_FLASH_RW_BACKUP_NVRAM_BASE_ADDR          (OS_FLASH_FLAG_NVRAM_BASE_ADD + OS_FLASH_FLAG_NVRAM_SIZE)
#define OS_FLASH_RW_BACKUP_NVRAM_SIZE               OS_FLASH_RW_NVRAM_SIZE  /*NV RWܴС768K*/

#if 1 /**/
/***************************
 SM MEMORY bakeup RWvate area config
***************************/
#define OS_FLASH_RW_SM_BAKEUP_OFFSET_FROM_NV        (OS_FLASH_RW_BACKUP_NVRAM_BASE_ADDR + OS_FLASH_RW_BACKUP_NVRAM_SIZE)
#define OS_FLASH_RW_SM_BAKEUP_BASE_ADDR             (OS_FLASH_NV_PARTITION_BASE_ADDR + OS_FLASH_RW_SM_BAKEUP_OFFSET_FROM_NV)
#define OS_FLASH_RW_SM_BAKEUP_SIZE                  0 
#endif

/******************************
 factory setting nvram  area  1.5M
******************************/
#define OS_FLASH_FACTORY_NVRAM_BASE_ADDR            0                 /* ǵһnvfacڴļ */
#define OS_FLASH_FACTORY_NVRAM_SIZE                 (512 * 1024)      /* 0.5MȷnvrwĹʹûֲ0.5M    */

/******************************
 Reserved NV Head addr
******************************/
#define PS_SELLSTAT_NVHEAD_OFFSET_FROM_NV      (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 4)
#define PS_PLMNCFG_NVHEAD_OFFSET_FROM_NV       (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 304)
#define PS_UEINFO_NVHEAD_OFFSET_FROM_NV        (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 20320)
#define PS_SIGNALBOX_NVHEAD_OFFSET_FROM_NV     (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 27448)
#define PS_UECAPA_NVHEAD_OFFSET_FROM_NV        (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 27492)
#define PS_USERSET_NVHEAD_OFFSET_FROM_NV       (OS_FLASH_PS_RW_NONFAC_OFFSET_FROM_NV + 38136)

#define REF_DESIGN_USER_OFFSET_FROM_NV         (OS_FLASH_REF_DESIGN_RW_OFFSET_FROM_NV + 1262)

/******************************
 vsim area
******************************/
#define OS_FLASH_VSIM_WORK_AREA_BASE_ADDR           0
#define OS_FLASH_VSIM_WORK_AREA_SIZE                (256 * 1024)

#define OS_FLASH_VSIM_RESERVED0_BASE_ADDR           (OS_FLASH_VSIM_WORK_AREA_BASE_ADDR + OS_FLASH_VSIM_WORK_AREA_SIZE)
#define OS_FLASH_VSIM_RESERVED0_SIZE                (256 * 1024)

#define OS_FLASH_VSIM_BACKUP_AREA_BASE_ADDR         (OS_FLASH_VSIM_RESERVED0_BASE_ADDR + OS_FLASH_VSIM_RESERVED0_SIZE)
#define OS_FLASH_VSIM_BACKUP_AREA_SIZE              OS_FLASH_VSIM_WORK_AREA_SIZE

#define OS_FLASH_VSIM_RESERVED1_BASE_ADDR           (OS_FLASH_VSIM_BACKUP_AREA_BASE_ADDR + OS_FLASH_VSIM_BACKUP_AREA_SIZE)
#define OS_FLASH_VSIM_RESERVED1_SIZE                (256 * 1024)

#define OS_FLASH_VSIM_WORK_AREA_SYMBOL_BASE_ADDR    (OS_FLASH_VSIM_RESERVED1_BASE_ADDR + OS_FLASH_VSIM_RESERVED1_SIZE)
#define OS_FLASH_VSIM_WORK_AREA_SYMBOL_SIZE         (256 * 1024)

#define OS_FLASH_VSIM_BACKUP_AREA_SYMBOL_BASE_ADDR  (OS_FLASH_VSIM_WORK_AREA_SYMBOL_BASE_ADDR + OS_FLASH_VSIM_WORK_AREA_SYMBOL_SIZE)
#define OS_FLASH_VSIM_BACKUP_AREA_SYMBOL_SIZE       (256 * 1024)

#define OS_FLASH_VSIM_FAC_AREA_SYMBOL_BASE_ADDR     (OS_FLASH_VSIM_BACKUP_AREA_SYMBOL_BASE_ADDR + OS_FLASH_VSIM_BACKUP_AREA_SYMBOL_SIZE)
#define OS_FLASH_VSIM_FAC_AREA_SYMBOL_SIZE          (256 * 1024)

#define OS_FLASH_VSIM_FAC_AREA_BASE_ADDR            0
#define OS_FLASH_VSIM_FAC_AREA_SIZE                 OS_FLASH_VSIM_WORK_AREA_SIZE

/****************************************************************************
	                                      End
****************************************************************************/

#endif

