/***************************************************************************************************/
/*NAT֮ǰIPܻᱻתȥݣ˴HOOK౨ĵĹ*/
/***************************************************************************************************/

#include <linux/types.h>
#include <linux/ip.h>
#include <linux/netfilter.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <net/route.h>
#include <net/ip.h>
#include <linux/netfilter_ipv4.h>

unsigned int lan_ipaddr  = 0; //0x0100A8C0;    //صַ192.168.0.1
unsigned int lan_netmask = 0; //0x00FFFFFF;    // 255.255.255.0

extern char default_route_name[IFNAMSIZ];

unsigned int hook_func_check_privateip(unsigned int hooknum,
					  struct sk_buff *skb,
					  const struct net_device *in,
					  const struct net_device *out,
					  int (*okfn)(struct sk_buff *))
{
	struct iphdr *iph = ip_hdr(skb);
    //unsigned char *pbuf = NULL;

    if ((lan_ipaddr == 0) || (lan_netmask == 0) || default_route_name[0] == 0)
    {
	    //printk("[check privateip not set]: lan_ipaddr=%d, lan_netmask=%d\n", lan_ipaddr, lan_netmask);
	    return NF_ACCEPT;
    }

	if ((htons(ETH_P_IP) != skb->protocol)
        || (0 != memcmp(default_route_name, skb->dev->name, strlen(skb->dev->name))))
	{
	    //printk("[check privateip]: protocol=%d, default_route_name=%s, skb->dev->name=%s, pass\n", skb->protocol, default_route_name, skb->dev->name);
	    return NF_ACCEPT;
    }

#if 0
    printk("[check privateip]: iph_saddr = 0x%x\n", iph->saddr);
    pbuf = skb->network_header + 12;
    printk("[check privateip]: iph_saddr = %02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x\n", pbuf[0], pbuf[1], pbuf[2], pbuf[3], pbuf[4], pbuf[5], pbuf[6], pbuf[7]);
#endif

	if ((iph->saddr & lan_netmask) == (lan_ipaddr & lan_netmask))
    {
		//printk("[check privateip] drop: coming ip iph->saddr = 0x%x, lan_netmask = 0x%x, lan_ipaddr = 0x%x \n", iph->saddr, lan_netmask, lan_ipaddr);
	    return NF_DROP;
	}
    //printk("[check privateip]: got src ip:[0x%x], pass\n", iph->saddr);
	return NF_ACCEPT;
}

static struct nf_hook_ops nfho_check_privateip[] = {
	{
        .hook		= hook_func_check_privateip,
		.owner		= THIS_MODULE,
		.pf		= PF_INET,
		.hooknum	= NF_INET_POST_ROUTING,
		.priority	= NF_IP_PRI_LAST,
	}
};

static int __init check_privateip_module_init(void)
{
    printk("[check privateip]zte_check_privateip_module_init register start...\n");
    return nf_register_hook(nfho_check_privateip);
}

static void __exit check_privateip_module_cleanup(void)
{
    printk("[check privateip]zte_check_privateip_module_cleanup unregister\n");
    nf_unregister_hook(nfho_check_privateip);
}

module_param(lan_ipaddr, uint, 0644);
module_param(lan_netmask, uint, 0644);


module_init(check_privateip_module_init);
module_exit(check_privateip_module_cleanup);

