#include <linux/types.h>
#include <linux/netfilter.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/proc_fs.h>    /* Necessary because we use proc fs */
#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/percpu.h>
#include <linux/netdevice.h>
#include <linux/security.h>
#include <net/net_namespace.h>
#ifdef CONFIG_SYSCTL
#include <linux/sysctl.h>
#endif

#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_l3proto.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_zones.h>
#include <net/netfilter/nf_conntrack_timestamp.h>

#include <linux/rculist_nulls.h>

#ifdef NETLINK_UC 
#include "../../../../drivers/net/fast6/fast6.h"
#include "../../../../drivers/net/fastnat/fastnat.h"
#else
#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>
#endif
#include <linux/init.h>
#define MSGLEN 256
static char assert[MSGLEN];

extern char br_name[];
extern char ps_name[];
extern char usb_name[];
extern char ppp_name[];
extern char need_jilian[];

static void *br_name_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1) 
        return NULL;
    return 1;
}

static void *br_name_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void br_name_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int br_name_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "br_name: %s\n", br_name);
    return 0;
}

static const struct seq_operations br_seq_ops = {
    .start = br_name_seq_start,
    .next  = br_name_seq_next,
    .stop  = br_name_seq_stop,
    .show = br_name_seq_show
};

static int br_name_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &br_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t br_name_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;

    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    memset(br_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(br_name, buffer, size))
        return -EFAULT;
    return count;
}

static void *ps_name_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *ps_name_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void ps_name_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int ps_name_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "ps_name: %s\n", ps_name);
    return 0;
}

static const struct seq_operations ps_name_seq_ops = {
    .start = ps_name_seq_start,
    .next  = ps_name_seq_next,
    .stop  = ps_name_seq_stop,
    .show  = ps_name_seq_show
};

static int ps_name_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &ps_name_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t ps_name_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    
    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    memset(ps_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(ps_name, buffer, size))
        return -EFAULT;
    return count;
}

static void *usb_name_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *usb_name_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void usb_name_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int usb_name_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "usb_name: %s\n", usb_name);
    return 0;
}

static const struct seq_operations usb_name_seq_ops = {
    .start = usb_name_seq_start,
    .next  = usb_name_seq_next,
    .stop  = usb_name_seq_stop,
    .show  = usb_name_seq_show
};

static int usb_name_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &usb_name_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t usb_name_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;

    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    memset(usb_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(usb_name, buffer, size))
        return -EFAULT;
    return count;
}

static void *ppp_name_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *ppp_name_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void ppp_name_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int ppp_name_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "ppp_name: %s\n", ppp_name);
    return 0;
}

static const struct seq_operations ppp_seq_ops = {
    .start = ppp_name_seq_start,
    .next  = ppp_name_seq_next,
    .stop  = ppp_name_seq_stop,
    .show  = ppp_name_seq_show
};

static int ppp_name_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &ppp_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t ppp_name_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;

    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    memset(ppp_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(ppp_name, buffer, size))
        return -EFAULT;
    return count;
}

static void *core_type_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *core_type_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void core_type_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int core_type_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "need_jilian: %s\n", need_jilian);
    return 0;
}

static const struct seq_operations core_type_seq_ops = {
    .start = core_type_seq_start,
    .next  = core_type_seq_next,
    .stop  = core_type_seq_stop,
    .show  = core_type_seq_show
};

static int core_type_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &core_type_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t core_type_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;

    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    memset(need_jilian, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(need_jilian, buffer, size))
        return -EFAULT;
    return count;
}

static const struct file_operations br_name_file_ops = {
    .owner   = THIS_MODULE,
    .open    = br_name_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release, //seq_release_privateƺҲԣsingle_releaseseq_release_netпָ쳣
    .write = br_name_set,
};

static const struct file_operations ps_name_file_ops = {
    .owner   = THIS_MODULE,
    .open    = ps_name_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = ps_name_set,
};

static const struct file_operations usb_name_file_ops = {
    .owner   = THIS_MODULE,
    .open    = usb_name_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = usb_name_set,
};

static const struct file_operations ppp_name_file_ops = {
    .owner   = THIS_MODULE,
    .open    = ppp_name_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = ppp_name_set,
};

static const struct file_operations core_type_file_ops = {
    .owner   = THIS_MODULE,
    .open    = core_type_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = core_type_set,
};

int net_adapter_init_proc(void)
{
    //ƽ̨
    proc_create("br_name", 0440, init_net.proc_net, &br_name_file_ops);

    //modemƽ̨
    proc_create("ps_name", 0440, init_net.proc_net, &ps_name_file_ops);

    //usbƽ̨
    proc_create("usb_name", 0440, init_net.proc_net, &usb_name_file_ops);
    
    //pppƽ̨
    proc_create("ppp_name", 0440, init_net.proc_net, &ppp_name_file_ops);

    //core_typeƽ̨
    proc_create("need_jilian", 0440, init_net.proc_net, &core_type_file_ops);

    return 1;
}

EXPORT_SYMBOL(net_adapter_init_proc);


static int save_assert_open(struct inode *inode, struct file *file)
{
    return 0;
}

static ssize_t save_assert_msg(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
	int n = 0;
    memset(assert, 0, MSGLEN);
    if (copy_from_user(assert, buffer, strlen(buffer)))
        return -EFAULT;
    return count;
}

static ssize_t read_assert_msg(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    if (copy_to_user(buffer, assert, strlen(assert)))
        return -EFAULT;
    return count;
}

static const struct file_operations save_assert_ops = {
    .owner  = THIS_MODULE,
    .open   = save_assert_open,
    .write  = save_assert_msg,
    .read   = read_assert_msg,
};


static __init int app_assert_msg_init(void)
{
    proc_create("softap_assert", 0655, NULL, &save_assert_ops);
    return 0;
}

late_initcall(app_assert_msg_init);



