#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/if_bridge.h>
#include <asm/uaccess.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <linux/device.h>
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/sched.h>
#include <linux/jhash.h>
#include "../../../bridge/br_private.h"
#include <net/arp.h>
#include <net/SI/netioc_proc.h>
#include <net/SI/netioctl.h>
#include <net/SI/errno_track.h>
#include <net/SI/pkt_lost_track.h>
#include <net/SI/sock_track.h>


#ifdef NETLINK_UC 
#include "../../../../drivers/net/fast6/fast6.h"
#include "../../../../drivers/net/fastnat/fastnat.h"
#else
#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>
#endif


int set_print = 0;       //ԶĴӡ
EXPORT_SYMBOL(set_print);

int set_tcpdump = 0;  //ץ

//ŵǰskbصͳϢһЩ쳣Ϣ
unsigned long skbinfo_dbg[SKB_INFO_MAX]= {0}; 

//ԴͳֵǸؼṹ룬ԹڲѧϰͶλ
unsigned long netruninfo_dbg[NET_INFO_MAX]= {0}; 

//skb޵ȫ֣Ŀǰδʹ
unsigned long skb_max_panic = 800; //ΪPSޣskbޣᵼpanic
int skb_num_limit = 1800;  //skbޣNULL

//ضskbͷŵʱջ
char skb_dump_str[NIOCTL_MAX_MSGLEN] = {0};
unsigned int skb_dump_len = 0;

/*ԱTCPͳ*/
unsigned long tcp_stats_dbg[TCP_STATS_MAX] = {0};



//ΪݰĽģϢͳƳݰģ
int  skb_num4 = 0;                  //յV4ݰ
int  skb_num6 = 0;                  //յV6ݰ
int  skb_big_num;                   //lenȳ1000ݰV4V6
int  skb_small_num;                 //lenС100ݰV4V6
int  skb_bytes4 = 0;                //յV4ݰֽ
int  skb_bytes6 = 0;                //յV6ݰֽ
int  skb_unknown = 0;               //յδ֪ЭݰARPȷV4V6ı
int  skb_tcpnum = 0;                //յtcpݰV4V6fastbrı
int  skb_udpnum = 0;                //յudpݰV4V6fastbrı
int  broadcast_num4 = 0;            //յV4㲥
int  broadcast_num6 = 0;            //յV6㲥
int  multicast_num4 = 0;            //յV4鲥
int  multicast_num6 = 0;            //յV6鲥
int  fastnat_num = 0;               //fastnatɹı
int  fast6_num = 0;                 //fast6ɹı
int  fastbr_num = 0;                //fastbrɹı
int  fast_local4_rcv_num = 0;       //fast_local4ɹձ
int  fast_local6_rcv_num = 0;       //fast_local6ɹձ
int  fast_local4_output_num = 0;    //fast_local4ɹͱ
int  fast_local6_output_num = 0;    //fast_local6ɹͱ
int  fast_tcpdump_num = 0;          //fastץ


int double_mac = 0; //mac鿪
//slabڴʹͳƣδͨslabַأkmalloc
struct slab_info slab_count = {0};

extern unsigned int nf_conntrack_max;
extern int netdev_max_backlog;

extern net_dbg_dev_info_t net_dbg_dev_info;
extern atomic_t  skb_used;

extern int ackdrop_maxnum;
extern int fastnat_ack_param;
/*********************************************************************/
/*                  ȡںϢ
/*********************************************************************/

/*ȡskbϢ*/
int get_skb_using(unsigned long arg)
{
    struct skb_using_msg* myskb_msg;
    int i=0;
    myskb_msg = (struct skb_num_msg*)kzalloc(sizeof(struct skb_using_msg),GFP_KERNEL);
    if(!myskb_msg)
            return -EFAULT;
   
    myskb_msg->skb_all       = atomic_read(&skb_used);
    myskb_msg->skb_tocp      = skbinfo_dbg[SKB_TYPE_TOCP];
    myskb_msg->skb_fromcp    = skbinfo_dbg[SKB_TYPE_FROMCP];
    myskb_msg->skb_data_num  = skbinfo_dbg[SKB_TYPE_DATA];
    myskb_msg->skb_data_size = skbinfo_dbg[SKB_DATA_BYTES];
    myskb_msg->skb_stop      = skbinfo_dbg[SKB_QUEUE_STOP];
    myskb_msg->skb_lock      = skbinfo_dbg[SKB_QUEUE_LOCK];
    myskb_msg->skb_panic = skb_max_panic;
    myskb_msg->skb_fail = skb_num_limit;
    if (copy_to_user((char *)arg, myskb_msg, sizeof(struct skb_using_msg)))
    {
        kfree(myskb_msg);
        return -EFAULT;
    }
    
    //print_sun(SUN_DBG,"\n copytouser \n\n");
    kfree(myskb_msg);
    return 0;
}
/*ȡslabϢ*/
void netslab_init(void){
    slab_count.num[BRFDB_SLAB][1]               = sizeof(struct net_bridge_fdb_entry );
    slab_count.num[DST_SLAB][1]                 = sizeof(struct dst_entry );
    slab_count.num[SKB_SLAB][1]                 = sizeof(struct sk_buff );
#ifdef NETLINK_UC
    slab_count.num[FAST_SLAB][1]                = sizeof(nat_entry_t);
#else
    slab_count.num[FAST_SLAB][1]                = sizeof(fast_entry_t);
#endif
    slab_count.num[INETPEER_SLAB][1]            = sizeof(struct inet_peer );
    slab_count.num[INET_HASHTABLES_SLAB][1]     = 24;//sizeof(struct inet_bind_bucket );
    slab_count.num[INET_TIMEWAIT_SOCK_SLAB][1]  = sizeof(struct inet_timewait_sock );
    //slab_count.num[SOCKET_SLAB][1]            = sizeof(struct socket_alloc );
    slab_count.num[NF_CONNTRACK_CORE_SLAB][1]   = sizeof(struct nf_conn );
    slab_count.num[NF_CONNTRACK_EXCEPT_SLAB][1] = 172;//sizeof(struct nf_conntrack_expect );
    slab_count.num[REQUEST_SOCK_SLAB][1]        = sizeof(struct request_sock );
    slab_count.num[SOCK_SLAB][1]                = sizeof(struct sock );
    slab_count.num[SOCKET_SLAB][1]              = sizeof(struct socket_alloc );
    //slab_count.num[XFRM6_TUNNEL_SLAB][1]      = sizeof(struct xfrm6_tunnel_spi );  
    //slab_count.num[XT_HASHLIMIT_SLAB][1]      = sizeof(struct dsthash_ent );
    slab_count.num[FIB_TRIE_SLAB][1]            = 24;//sizeof(struct fib_alias );
    slab_count.num[FLOW_SLAB][1]                = 84;//sizeof(struct flow_cache_entry );

    slab_count.num[SOCK_ALLOC_PAGES][1]         = 4*1024;;
    slab_count.num[IP6_OUTPUT_ALLOC_PAGES][1]   = 4*1024;
    slab_count.num[IP_OUTPUT_ALLOC_PAGES][1]    = 4*1024;
    slab_count.num[SKB_ALLOC_PAGES][1]          = 4*1024;
}

void netslab_inc(int i){
    slab_count.num[i][0]++;
}

void netslab_dec(int i){
    slab_count.num[i][0]--;
}
int get_slab_info(unsigned long arg)
{   
    netslab_init();
    if (copy_to_user((char *)arg, &slab_count, sizeof(struct slab_info)))
    {
        return -EFAULT;
    }
    return 0;
}

int get_hash_info(unsigned long arg)
{
    struct hash_info *fast_hash_info;
    int i = 0, j = 0;
    int list_count = 0, current_count = 0;
    struct nf_conntrack_tuple_hash *h;
    struct hlist_nulls_node *n;
    fast_hash_info = (struct hash_info*)kzalloc(sizeof(struct hash_info),GFP_KERNEL);
    if(!fast_hash_info)
            return -EFAULT;
   
    fast_hash_info->max_hash_size = nf_conntrack_htable_size;
    fast_hash_info->current_hash_num = working_list.count * 2;
    for(i = 0; i < fast_hash_info->max_hash_size; i++){
        hlist_nulls_for_each_entry_rcu(h, n, &working_hash[i], hnnode)
        {
           list_count ++;
        }
        for(j = 0; j < current_count; j++){
            if(fast_hash_info->hash[j][0] == list_count){
                fast_hash_info->hash[j][1]++;
                break;
            }            
        }
        if(current_count == j && current_count <  HASH_ARRAY_COUNT){
            fast_hash_info->hash[current_count][0] = list_count;
            fast_hash_info->hash[current_count++][1] = 1;
            if(current_count >=  HASH_ARRAY_COUNT){
                break;
            }
        }
        list_count = 0;
    }   
    fast_hash_info->current_array_size = current_count;
    if (copy_to_user((char *)arg, fast_hash_info, sizeof(struct hash_info)))
    {
        kfree(fast_hash_info);
        return -EFAULT;
    }
    
    kfree(fast_hash_info);
    return 0;
}

/*ȡdevϢ*/
int get_dev_info(unsigned long arg)
{
    struct net_device *dev;
    struct ioctl_dev_netstats *dev_status;
    
    dev_status = (struct ioctl_dev_netstats*)kzalloc(sizeof(struct ioctl_dev_netstats), GFP_KERNEL);
    if(!dev_status)
        return -EFAULT;
    
    if(copy_from_user(dev_status, (char *)arg, sizeof(struct ioctl_dev_netstats)))
    {
        kfree(dev_status);
        return -EFAULT;
    }
    rcu_read_lock();
    dev = dev_get_by_name_rcu(&init_net,dev_status->dev_name);    
    if(!dev)
    {
        rcu_read_unlock();
        kfree(dev_status);
        return -EFAULT;
    }
    
    memcpy(&(dev_status->stats),&(dev->stats),sizeof(struct net_device_stats));
    memcpy(&(dev_status->stats_dbg),&(dev->stats_dbg),sizeof(struct net_dev_skbinfo));
    dev_status->flags         = dev->flags;
    dev_status->operstate     = dev->operstate;
    dev_status->state         = dev->state;
    dev_status->net_flag      = dev->net_flag;
    dev_status->num_tx_queues = dev->num_tx_queues;
    dev_status->que_state     = dev->_tx[0].state;
    
    //print_sun(SUN_DBG,"  num_tx_queues: %u       que_state: %u  \n",dev->num_tx_queues,dev->_tx[0].state);
    rcu_read_unlock();
    if (copy_to_user((char *)arg, dev_status, sizeof(struct ioctl_dev_netstats)))
    {
        kfree(dev_status);
        return -EFAULT;
    }
    kfree(dev_status);
    return 0;
}

/*ȡеmac¼Ӷȡ豸mac*/
int network_get_pcmac(unsigned long arg)
{
    struct pc_node *mypc_node;
    int i = 0;
    int j = 0;
    struct net_device *dev;
    struct net_bridge *br;
    struct hlist_head *head;
    struct hlist_node *h;
    struct net_bridge_fdb_entry *fdb;

    mypc_node=(struct pc_node*)kzalloc(sizeof(struct pc_node),GFP_KERNEL);
    if(!mypc_node)
        return -EFAULT;
    dev = dev_get_by_name_rcu(&init_net,"br0");
    if(!dev)
    {
        kfree(mypc_node);
        return -EFAULT;
    }
    
    br = netdev_priv(dev);
    for (i = 0; i < BR_HASH_SIZE; i++)
    {
        head = &br->hash[i];
#ifdef NETLINK_UC
        hlist_for_each_entry_rcu(fdb, head, hlist )
#else
        hlist_for_each_entry_rcu(fdb, h, head, hlist)
#endif
        {
            if(!fdb->is_local)//cov_2 && fdb->dst->dev->name)
            {
                for(j=0; j<6; j++)
                    mypc_node->info[mypc_node->num].mac_addr[j]=fdb->addr.addr[j];
                strcpy(mypc_node->info[mypc_node->num].dev_name,fdb->dst->dev->name);
                mypc_node->num ++;
            }
        }
    }

    if (copy_to_user((char *)arg, mypc_node, sizeof(struct pc_node)))
    {
        kfree(mypc_node);
        return -EFAULT;
    }
    kfree(mypc_node);

    return 0;
}

/*ȡǰں˲Ӧò*/
int get_kernelparam(unsigned long arg)
{
    ioctl_data *pval;
    int ret = -1;

    pval = (struct ioctl_data *)kzalloc(sizeof(ioctl_data), GFP_KERNEL);
    if(!pval)
        return -EFAULT;

    if (copy_from_user(pval, (char *)arg, sizeof(ioctl_data)))
    {
        kfree(pval);
        return -EFAULT;
    }
    pval->name[NIOCTL_MAX_NAMELEN-1]='\0';
    if (strcmp(pval->name, "fastnat") == 0)
    {
        ret = fastnat_level;
    }
    else if (strcmp(pval->name, "fastbr") == 0)
    {
        ret = fastbr_level;
    }
    else if (strcmp(pval->name, "set_print") == 0)
    {
        ret = set_print;
    }
    else if (strcmp(pval->name, "set_tcpdump") == 0)
    {
        ret = set_tcpdump;
    }
    else if (strcmp(pval->name,"leak") == 0)
    {
        ret = leak_set;
    }
    else if (strcmp(pval->name,"brip") == 0)
    {
        ret = br_ipchange_flag; 
    }
    else if (strcmp(pval->name,"ackdrop") == 0)
    {
        ret = ackdrop_maxnum; 
    }
    else if (strcmp(pval->name,"listmax") == 0)
    {
        ret = leak_list_max; 
    }
    else if (strcmp(pval->name,"set_psbufleak") == 0)
    {
        ret = set_psbufleak; 
    }
    else if (strcmp(pval->name,"set_extskbleak") == 0)
    {
        ret = set_extskbleak; 
    }
    else if (strcmp(pval->name,"leak_full_panic") == 0)
    {
        ret = leak_full_panic; 
    }   
    else if (strcmp(pval->name,"skb_max_panic") == 0)
    {
        ret = skb_max_panic; 
    }
    else if (strcmp(pval->name,"skb_num_limit") == 0)
    {
        ret = skb_num_limit; 
    }
    else if(0 == strcmp(pval->name, "pkt_lost_track"))
    {
        ret = pkt_lost_track;
    }
    else if(0 == strcmp(pval->name, "net_debug_ping"))
    {
        ret = net_debug_ping;
    }
    else if(0 == strcmp(pval->name, "net_debug_perf"))
    {
        ret = net_debug_perf;
    }
    else
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "the key:%s is not supported!\n", buf);
    }
    
    if (ret != -1)
    {
		char name[NIOCTL_MAX_NAMELEN];
		memcpy(name,pval->name,NIOCTL_MAX_NAMELEN);
		name[NIOCTL_MAX_NAMELEN-1]='\0';
        snprintf(pval->buf,sizeof(pval->buf), "value: %s == %d \n", name, ret);
    }
    if (copy_to_user((char *)arg, pval, sizeof(ioctl_data)))
    {
        kfree(pval);
        return -EFAULT;
    }
    kfree(pval);

    return 0;
}

/*********************************************************************/
/*                  ں˲
*********************************************************************/

/*Ӧò㴫ݹִֵԱȽ.ʱdump stk*/

int set_skb_dump(unsigned long arg)
{
    ioctl_data *val;
    val = (struct ioctl_data *)kzalloc(sizeof(ioctl_data), GFP_KERNEL);
    if(!val)
        return -EFAULT;

    if(copy_from_user(val, (char *)arg, sizeof(ioctl_data))) {
        kfree(val);
        return -EFAULT;
    }

    skb_dump_len = val->size;
    memset(skb_dump_str, 0,NIOCTL_MAX_MSGLEN);
	if(skb_dump_len <=NIOCTL_MAX_MSGLEN)
    memcpy(skb_dump_str, &(val->buf[0]), skb_dump_len);
    kfree(val);
	return 0;
}


/*ôӡأbufзصǰӡ״̬*/
int set_print_opt(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    //set_printֻ֧0~1
    if (pval->value > SUN_ERR)
    {
        snprintf(pval->buf,sizeof(pval->buf), "Error: set_print-%d not supported, only support 0~1! \n", pval->value);
        return -EFAULT;
    }

    set_print = pval->value;
    snprintf(pval->buf,sizeof(pval->buf), "set_print is set to %d\n", pval->value);

    return 0;
}

/*ԶtcpdumpأbufзصǰԶtcpdump״̬*/
int set_sq_tcpdump(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    //set_sq_tcpdumpֻ֧0~1
    if (pval->value < 0 || pval->value > 1)
    {
        snprintf(pval->buf,sizeof(pval->buf), "Error: set_sq_tcpdump-%d not supported, only support 0~1! \n", pval->value);
        return -EFAULT;
    }

    set_tcpdump = pval->value;
    snprintf(pval->buf,sizeof(pval->buf), "set_sq_tcpdump is set to %d\n", pval->value);

    return 0;
}

/*ڴٿ*/
int  set_leak(void * arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    struct track_info *t;
    unsigned long spin_flag = 0;
    int i = 0, j = 0, m = 0, n = 0,k = 0;

    if (val->size == 0)
    {
        int n = val->value;
		if (n <= TRACK_START || n >= TRACK_END) {
			printk("Usage:%d < n < %d", TRACK_START, TRACK_END);
			return 0;
		}

		if (leak_set == n) {
			printk("leak_set = %d already set\n ", leak_set);
			return 0;
		}

		/*ͷleak*/
		if (leak_set > TRACK_START && leak_set < TRACK_END) {
			spin_lock_irqsave(&leak_lock, spin_flag);
			for (k = 0; k < leak_list_max; k++)
			{
				t = (struct track_info *)(data_head[n] + k*tnode_len);
				kfree(t->func_track);
			}

			kfree(data_head[n]);
			data_head[n] = NULL;
			memset(data_free+n, 0, sizeof(struct leak_list));
			memset(data_leak+n, 0, sizeof(struct leak_list));

			/*
			 *ض켣˽
			 *    PACKET_INFO: ͬһdataдŶIPݰļ
			 */
			switch(leak_set) {
				case SKB_INFO:
					set_psbufleak = 0;
					set_extskbleak = 0;
					leak_set = TRACK_START;
					for(i = 0; i < MAX_EXT_MEM_HASH; i++)
					{
						struct extpbuf_info *temp = NULL;
						struct extpbuf_info *temp2 = NULL;

						toCp_listlog[i].count = 0;
						fromCp_list[i].count = 0;
   						list_for_each_entry_safe(temp, temp2, &toCp_listlog[i].first, node) {
							__list_del_entry(&temp->node);
       						kfree(temp);
   						}

						list_for_each_entry_safe(temp, temp2, &fromCp_list[i].first, node) {
							__list_del_entry(&temp->node);
       						kfree(temp);
   						}
					}
					break;

				case DATA_INFO: break;
				case USER_INFO: break;
				case CONN_INFO: break;
				case NETDEV_INFO: break;
				default: break;
			}
			spin_unlock_irqrestore(&leak_lock, spin_flag);
		}
		/*
		 *ͬʱ׷ٶ켣
		 */
		switch(n) {
			case SKB_INFO:
				set_psbufleak = 1;
				set_extskbleak = 1;
				leak_set = n;
				break;
			case DATA_INFO: break;
			case USER_INFO: break;
			case CONN_INFO: break;
			case NETDEV_INFO: break;
			case LIST_SKB_INFO:
			case QUEUE_STATE_INFO:
					 leak_set = n;
					  break;
			default: leak_set = n; break;
		}
		if(leak_set < TRACK_END && leak_set >= 0)
		track_init(leak_set);
			/*
			 * PACKET_INFOtypeȻΪSKB_INFO
			 */
			//((leak_set >> PACKET_INFO) & 0x1) ? (leak_set = (1<<SKB_INFO)) : 20121231;
    }
    return 0;
}

int set_skb_num_limit(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
        
    skb_num_limit = val->value;
    snprintf(val->buf,sizeof(val->buf),"skb_num_limit is set as %d \n",skb_num_limit);
    return 0;
}
    
int set_double_mac(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
        
    double_mac = val->value;
    snprintf(val->buf,sizeof(val->buf),"double_mac is set as %d \n", double_mac);
    return 0;
}

int set_pkt_lost_track(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;

    pkt_lost_track = val->value;
    snprintf(val->buf,sizeof(val->buf), "packet_lost_track is set as %d\n", pkt_lost_track);
    return 0;
}

int set_skbmax_panic(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    if(val->value)
        leak_set = 1;
    skb_max_panic = val->value;
    snprintf(val->buf,sizeof(val->buf),"skb_max_panic is set as %d \n",skb_max_panic);
    return 0;
}

int set_leakfull_panic(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    if(val->value)
        leak_set = 1;
    leak_full_panic = val->value;
    snprintf(val->buf,sizeof(val->buf),"leak_full_panic is set as %d \n",leak_full_panic);
    return 0;
}


/*ڴ¼ڵ*/
int set_max(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    
    leak_list_max = val->value;
    snprintf(val->buf,sizeof(val->buf),"list max num is set as %d \n",leak_list_max);
    return 0;
}

/*ù켣ޣuser++--ʱҪ󣬷2*/
int set_trackmax(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;

    track_max = val->value;
    snprintf(val->buf,sizeof(val->buf),"list max num is set as %d \n", track_max);
    return 0;
}

/*ջ켣ַ*/
int set_stacklenmax(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;

    stack_lenmax = val->value;
    snprintf(val->buf,sizeof(val->buf),"list max num is set as %d \n", stack_lenmax);
    return 0;
}

/*ԶtcpdumpأbufзصǰԶtcpdump״̬*/
int set_tcpdump_opt(unsigned long arg)
{
    ioctl_data val;
    char dev_name[20] = {0};
    
    if(copy_from_user(&val, (char *)arg, sizeof(val)))  
        return -EFAULT;
    val.buf[NIOCTL_MAX_MSGLEN-1]='\0';
    if (strcmp(val.buf, "off") == 0)
    {
        set_tcpdump = 0;
        snprintf(val.buf,sizeof(val.buf),"tcpdump is off\n");
    }
    else 
    {
        set_tcpdump = 3;
        strncpy(dev_name,val.buf,sizeof(dev_name)-1);
        snprintf(val.buf,sizeof(val.buf),"tcpdump at %s is on\n",dev_name);
    }
    if (copy_to_user((char *)arg, &val, sizeof(val)))
        return -EFAULT;
    return 0;

}

/*ƽ̨br_name*/
int set_br_name(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;
    if(pval->size == 0)//cov_2 ((pval->size == 0) || (pval->buf == NULL))
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "Error: input param error. br_name:%s, size:%d! \n", buf, pval->size);
        return -EFAULT;
    }

    memset(br_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
	if(pval->size <= MAX_NET_DEVICE_NAME_LEN)
    memcpy(br_name, pval->buf, pval->size);
    snprintf(pval->buf,sizeof(pval->buf), "br_name is set to %s\n", br_name);

    return 0;
}

/*ƽ̨ps_name*/
int set_ps_name(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    if (pval->size == 0)//cov_2((pval->size == 0) || (pval->buf == NULL))
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "Error: input param error. ps_name:%s, size:%d! \n", buf, pval->size);
        return -EFAULT;
    }

    memset(ps_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
	if(pval->size <= MAX_NET_DEVICE_NAME_LEN)
    memcpy(ps_name, pval->buf, pval->size);
    snprintf(pval->buf,sizeof(pval->buf), "ps_name is set to %s\n", ps_name);

    return 0;
}

/*ƽ̨usb_name*/
int set_usb_name(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    if (pval->size == 0)//cov_2((pval->size == 0) || (pval->buf == NULL))
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "Error: input param error. usb_name:%s, size:%d! \n", buf, pval->size);
        return -EFAULT;
    }

    memset(usb_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
	if(pval->size <= MAX_NET_DEVICE_NAME_LEN)
    memcpy(usb_name, pval->buf, pval->size);
    snprintf(pval->buf,sizeof(pval->buf), "usb_name is set to %s\n", usb_name);

    return 0;
}

/*ƽ̨ppp_name*/
int set_ppp_name(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    if (pval->size == 0)//cov_2((pval->size == 0) || (pval->buf == NULL))
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "Error: input param error. ppp_name:%s, size:%d! \n", buf, pval->size);
        return -EFAULT;
    }

    memset(ppp_name, 0, MAX_NET_DEVICE_NAME_LEN + 1);
	if(pval->size <= MAX_NET_DEVICE_NAME_LEN)
    memcpy(ppp_name, pval->buf, pval->size);
    snprintf(pval->buf,sizeof(pval->buf), "ppp_name is set to %s\n", ppp_name);

    return 0;
}

/*br0 ip۸ĵĶԿ*/
int set_brip(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;

    br_ipchange_flag = val->value;
    snprintf(val->buf,sizeof(val->buf),"br_ipchange_flag is set to %d\n", br_ipchange_flag);
    //print_sun(SUN_DBG,"br_ipchange_flag is set to %d\n", br_ipchange_flag);
    return 0;
}

/*fastnatfast_level_changefastnatص޸*/
int set_fastnat_level(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    //fastnat levelֻ֧FAST_CLOSE~FAST_NET_DEVICEFAST_CLOSE_KEEP_LINK
#ifdef NETLINK_UC
    if ((pval->value < FAST_CLOSE || pval->value > FAST_PS_USB) && pval->value != FAST_CLOSE_KEEP_LINK)
#else
    if ((pval->value < FAST_CLOSE || pval->value > FAST_NET_DEVICE) && pval->value != FAST_CLOSE_KEEP_LINK)
#endif
    {
        snprintf(pval->buf,sizeof(pval->buf), "Error: fastnat_level-%d not supported, only support 0~2 and 5! \n", pval->value);
        return -EFAULT;
    }

    fast_level_change(pval->value);
    snprintf(pval->buf,sizeof(pval->buf), "fastnat level is set to %d\n", pval->value);

    return 0;
}

/*fastbrأbufзصǰfastbr*/
int set_fastbr_level(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    //fastnat levelֻ֧0~1
    if (pval->value < 0 || pval->value > 1)
    {
        snprintf(pval->buf,sizeof(pval->buf), "Error: fastbr_level-%d not supported, only support 0~1! \n", pval->value);
        return -EFAULT;
    }
    
    fastbr_level = pval->value;
    snprintf(pval->buf,sizeof(pval->buf), "fastbr level is set to %d\n", pval->value);

    return 0;
}

int set_fast_switch(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    int level = val->value;

    if (level < 0 || level > 127)
    {
        snprintf(val->buf,sizeof(val->buf), "value should betwen 0~127 \n");
    }

    //ÿתӺ
    fast_switch_change(level);
    snprintf(val->buf,sizeof(val->buf), "fast_switch is set to 0x%x\n", level);
    return 0;
}

int set_net_debug_ping(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    int value = val->value;
    net_dbg_dev_info_t *devinfo = val->data;

    //net_debug_pingֻ֧0~1
    if (value < 0 || value > 1)
    {
        snprintf(val->buf,sizeof(val->buf), "net_debug_ping value should betwen 0~1 \n");
    }

    if (devinfo && value)
    {
        memcpy(&net_dbg_dev_info, devinfo, sizeof(net_dbg_dev_info_t));
    }
    
    net_debug_ping = val->value;
    snprintf(val->buf,sizeof(val->buf), "net_debug_ping is set to %d\n", value);
    
    return 0;
}

int set_net_debug_perf(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    int value = val->value;
    net_dbg_dev_info_t *devinfo = val->data;

    //net_debug_perfֻ֧0~1
    if (value < 0 || value > 1)
    {
        snprintf(val->buf,sizeof(val->buf), "net_debug_perf value should betwen 0~1 \n");
    }

    if (devinfo && value)
    {
        memcpy(&net_dbg_dev_info, devinfo, sizeof(net_dbg_dev_info_t));
    }
    
    net_debug_perf = val->value;
    snprintf(val->buf,sizeof(val->buf), "net_debug_perf is set to %d\n", value);
    
    return 0;
}

extern int addr_check;
int set_addr_check(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    int value = val->value;

    if (value < 0 || value > 1)
    {
        snprintf(val->buf,sizeof(val->buf), "addr_check value should betwen 0~1 \n");
    }
    
    addr_check = val->value;
    snprintf(val->buf,sizeof(val->buf), "addr_check is set to %d\n", value);
    
    return 0;
}

extern int errno_stack_track;
int set_errno_stack_track(unsigned long arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    int value = val->value;

    if (value < 0 || value > 1)
    {
        snprintf(val->buf,sizeof(val->buf), "errno_stack_track value should betwen 0~1 \n");
    }
    
    errno_stack_track = val->value;
    snprintf(val->buf,sizeof(val->buf), "errno_stack_track is set to %d\n", value);
    
    return 0;
}

/*ackؼƵ*/
int set_ackdrop(void *arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    if (val->value == 0)
    {
        ackdrop_maxnum =0;
        fastnat_ack_param = 0;
        snprintf(val->buf,sizeof(val->buf),"ackdrop is off \n");
    }
    else 
    {
        ackdrop_maxnum = val->value;
        fastnat_ack_param = 1;
        snprintf(val->buf,sizeof(val->buf),"ackdrop every %d packet \n",ackdrop_maxnum);
    }
    
    return 0;
}

/*üİ*/
int set_skb_queue_type(void *arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    if(val->value < 0)
    {
        return -EFAULT;
    }

    check_pkt = val->value;
    snprintf(val->buf,sizeof(val->buf), "skb queue type is set to %d\n", check_pkt);
    return 0;
}

/*ӡݿ*/
int set_print_packet(void *arg)
{
    ioctl_data *val = (ioctl_data *)arg;
    if(val->value < 0 || val->value > 1)
    {
        return -EFAULT;
    }

    set_print_pkt = val->value;
    snprintf(val->buf,sizeof(val->buf), "print packet is set to %d\n", set_print_pkt);
    return 0;    
}

static int set_net_debug_packet_sec(unsigned long arg);

/*netdogĲӦýӿڣʱڸúif֧*/
int set_kernelparam(unsigned long arg)
{
    ioctl_data *pval;
    int ret = 0;

    pval = (struct ioctl_data *)kzalloc(sizeof(ioctl_data), GFP_KERNEL);
    if(!pval)
        return -EFAULT;

    if (copy_from_user(pval, (char *)arg, sizeof(ioctl_data)))
    {
        kfree(pval);
        return -EFAULT;
    }
    pval->name[NIOCTL_MAX_NAMELEN-1]='\0';
    if (strcmp(pval->name, "fastnat") == 0)
    {
        ret = set_fastnat_level((void *)pval);
    }
    else if (strcmp(pval->name, "fastbr") == 0)
    {
        ret = set_fastbr_level((void *)pval);
    }
    else if (strcmp(pval->name, "set_print") == 0)
    {
        ret = set_print_opt((void *)pval);
    }
    else if (strcmp(pval->name, "set_tcpdump") == 0)
    {
        ret = set_sq_tcpdump((void *)pval);
    }
    else if (strcmp(pval->name,"leak") == 0)
    {
        ret = set_leak((void *)pval);
    }
    //ƽ̨
    else if (strcmp(pval->name, "br_name") == 0)
    {
        ret = set_br_name((void *)pval); 
    }
    else if (strcmp(pval->name, "ps_name") == 0)
    {
        ret = set_ps_name((void *)pval); 
    }
    else if (strcmp(pval->name, "usb_name") == 0)
    {
        ret = set_usb_name((void *)pval); 
    }
    else if (strcmp(pval->name, "ppp_name") == 0)
    {
        ret = set_ppp_name((void *)pval); 
    }
    else if (strcmp(pval->name,"brip") == 0)
    {
        ret = set_brip((void *)pval); 
    }
    else if (strcmp(pval->name,"ackdrop") == 0)
    {
        ret = set_ackdrop((void *)pval); 
    }
    else if (strcmp(pval->name,"leak_list_max") == 0)
    {
        ret = set_max((void *)pval); 
    }    
    else if (strcmp(pval->name,"track_max") == 0)
    {
        ret = set_trackmax((void *)pval);
    }
    else if (strcmp(pval->name,"stack_lenmax") == 0)
    {
        ret = set_stacklenmax((void *)pval);
    }
    else if (strcmp(pval->name,"errno") == 0)
    {
        ret = set_errno_procname((void *)pval);
    }
    else if (strcmp(pval->name,"leak_full_panic") == 0)
    {
        ret = set_leakfull_panic((void *)pval);
    }
    else if (strcmp(pval->name,"skb_max_panic") == 0)
    {
        ret = set_skbmax_panic((void *)pval);
    }
    else if (strcmp(pval->name,"skb_num_limit") == 0)
    {
        ret = set_skb_num_limit((void *)pval);
    }
    else if (strcmp(pval->name,"double_mac") == 0)
    {
        ret = set_double_mac((void *)pval);
    }
    else if(strcmp(pval->name, "skb_queue_type") == 0)
    {
        ret = set_skb_queue_type((void *)pval);
    }
    else if(strcmp(pval->name, "print_pkt") == 0)
    {
        ret = set_print_packet((void *)pval);
    }
    else if (strcmp(pval->name, "pkt_lost_track") == 0)
    {
        ret = set_pkt_lost_track((void *)pval);
    }
    else if (strcmp(pval->name, "fast_switch") == 0)
    {
        ret = set_fast_switch((void *)pval);
    }
    else if (strcmp(pval->name, "net_debug_ping") == 0)
    {
        ret = set_net_debug_ping((void *)pval);
    }
    else if (strcmp(pval->name, "net_debug_perf") == 0)
    {
        ret = set_net_debug_perf((void *)pval);
    }
    else if (strcmp(pval->name, "addr_check") == 0)
    {
        ret = set_addr_check((void *)pval);
    }
    else if (strcmp(pval->name, "errno_stack_track") == 0)
    {
        ret = set_errno_stack_track((void *)pval);
    }
    else if (strcmp(pval->name, "app_active_net") == 0)
    {
        ret = set_net_debug_packet_sec((void *)pval);
    }
    else
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "the key:%s is not supported!\n", buf);
    }

    if (copy_to_user((char *)arg, pval, sizeof(ioctl_data)))
    {
        kfree(pval);
        return -EFAULT;
    }
    kfree(pval);

    return ret;
}

int set_errno_procname(void *arg)
{
    ioctl_data *pval = (ioctl_data *)arg;

    if (pval->size == 0)//cov_2((pval->size == 0) || (pval->buf == NULL))
    {
		unsigned char buf[NIOCTL_MAX_MSGLEN];
		memcpy(buf,pval->buf,NIOCTL_MAX_MSGLEN);
        snprintf(pval->buf,sizeof(pval->buf), "Error: input param error. ppp_name:%s, size:%d! \n", buf, pval->size);
        return -EFAULT;
    }

    if (!strcmp(pval->buf,"off"))
    {
        errno_proc_name[0] = '\0';
    }
    else
    {
        memset(errno_proc_name, 0, sizeof(errno_proc_name));
        strncpy(errno_proc_name, pval->buf, sizeof(errno_proc_name)-1);
    }
    snprintf(pval->buf,sizeof(pval->buf), "errno_proc_name is set to %s\n", errno_proc_name);

    return 0;

}

/*ȡskb fastǰͳϢ*/
int get_skb_fast(unsigned long arg)
{
    struct skb_and_fast_msg *skbfast_info;

    skbfast_info = (struct skb_and_fast_msg*)kzalloc(sizeof(struct skb_and_fast_msg), GFP_KERNEL);
    if(!skbfast_info)
        return -EFAULT;

    skbfast_info->skb_num4       = skb_num4;
    skbfast_info->skb_num6       = skb_num6;
    skbfast_info->skb_big_num    = skb_big_num;
    skbfast_info->skb_small_num  = skb_small_num;
    skbfast_info->skb_bytes4     = skb_bytes4;
    skbfast_info->skb_bytes6     = skb_bytes6;
    skbfast_info->skb_unknown    = skb_unknown;
    skbfast_info->skb_tcpnum     = skb_tcpnum;
    skbfast_info->skb_udpnum     = skb_udpnum;
    skbfast_info->broadcast_num4 = broadcast_num4;
    skbfast_info->broadcast_num6 = broadcast_num6;
    skbfast_info->multicast_num4 = multicast_num4;
    skbfast_info->multicast_num6 = multicast_num6;
    skbfast_info->fastnat_num    = fastnat_num;
    skbfast_info->fast6_num      = fast6_num;
    skbfast_info->fastbr_num     = fastbr_num;
    skbfast_info->fastnat_level  = fastnat_level;
    skbfast_info->fastbr_level   = fastbr_level;
    skbfast_info->irqfree_num    = skbinfo_dbg[SKB_IRQ_FREE];
    skbfast_info->skbcopy_num    = skbinfo_dbg[SKB_COPY];
    skbfast_info->cache_copy       = skbinfo_dbg[SKB_COPY_CACHE];
    skbfast_info->skbflood_num   = skbinfo_dbg[SKB_FLOOD];
    skbfast_info->errfree_num    = skbinfo_dbg[SKB_ERRFREE];
    skbfast_info->frag_num       = skbinfo_dbg[SKB_FRAG];
    skbfast_info->mtu_num        = skbinfo_dbg[SKB_OVER_MTU];
    skbfast_info->fast_loop      = skbinfo_dbg[SKB_LOOP];
    skbfast_info->xmit_lock_num  =  skbinfo_dbg[SKB_QUEUE_LOCK];
    skbfast_info->xmit_stop_num  =  skbinfo_dbg[SKB_QUEUE_STOP];
    skbfast_info->br_mac_change_num = netruninfo_dbg[BR_MAC_CHANGE];
    skbfast_info->fast_tcpdump_num = fast_tcpdump_num;

    skbfast_info->fast_switch  = fast_switch;
    skbfast_info->fast_local4_rcv_num = fast_local4_rcv_num;       
    skbfast_info->fast_local6_rcv_num = fast_local6_rcv_num;       
    skbfast_info->fast_local4_output_num = fast_local4_output_num;    
    skbfast_info->fast_local6_output_num = fast_local6_output_num;    

    if (copy_to_user((char *)arg, skbfast_info, sizeof(struct skb_and_fast_msg)))
    {
        kfree(skbfast_info);
        return -EFAULT;
    }
    kfree(skbfast_info);

    return 0;
}


int get_ptype(unsigned long arg)
{
   
    struct ptype_info my_ptype={0};
    struct packet_type *ptype, *pt_prev;
    int i=0;
    int j=0;
    int k=0;
    memset(&my_ptype,0,sizeof(struct ptype_info));
    list_for_each_entry_rcu(ptype, &ptype_all, list) 
    {        
        if(j>= 5)
            break;
        my_ptype.ptype_all[j++] = ntohs(ptype->type);            
    }
    for(i=0;i<=15;i++)
    {
        list_for_each_entry_rcu(ptype, &ptype_base[i], list) 
        {
            if(k>=15)
                break;
            my_ptype.ptype_base[k++] = ntohs(ptype->type);            
            
        }
    }

    if (copy_to_user((char *)arg, &my_ptype, sizeof(struct ptype_info)))
    {       
        return -EFAULT;
    }
    
    return 0;
}

/*ȡԴʹ*/
int get_max_msg(unsigned long arg)
{
    struct net_max_check_msg *max_msg;
    struct softnet_data *sd;

    max_msg = (struct net_max_check_msg*)kzalloc(sizeof(struct net_max_check_msg), GFP_KERNEL);
    if (!max_msg)
        return -EFAULT;

    max_msg->nf_conntrack_max   = nf_conntrack_max;
    max_msg->nf_conntrack_now   = atomic_read(&init_net.ct.count);

    //cpuΪ0
    sd = &per_cpu(softnet_data, 0);
    max_msg->netdev_max_backlog = netdev_max_backlog;
    max_msg->input_queue_len    = skb_queue_len(&sd->input_pkt_queue);
    max_msg->rx_dropped = sd->dropped;
    
    max_msg->fastnat_link_max   = nf_conntrack_max;
    max_msg->fastnat_link_now   = working_list.count;
    max_msg->fast6_link_max     = nf_conntrack_max;
    max_msg->fast6_link_now     = working_list6.count;

    max_msg->br_mac_change      = netruninfo_dbg[BR_MAC_CHANGE];
    max_msg->neigh_alloc        = netruninfo_dbg[NEIGH_ALLOC];
    max_msg->neigh_free         = netruninfo_dbg[NEIGH_FREE];
    max_msg->br_neigh_vary      = netruninfo_dbg[BR_NEIGH_VARY];
    max_msg->conn_alloc         = netruninfo_dbg[CONN_ALLOC];
    max_msg->conn_free          = netruninfo_dbg[CONN_FREE];
    max_msg->brfdb_alloc        = netruninfo_dbg[BRFDB_ALLOC];
    max_msg->dst_alloc          = netruninfo_dbg[DST_ALLOC];
    max_msg->dst_free           = netruninfo_dbg[DST_FREE];
    max_msg->hh_update          = netruninfo_dbg[HH_UPDATE];
    max_msg->rt_cache_invalid   = netruninfo_dbg[RT_CACHE_INVALID];
    max_msg->rt_hash_add        = netruninfo_dbg[RT_CACHE_INVALID];
    max_msg->rt_hash_del        = netruninfo_dbg[RT_HASH_ADD];
    max_msg->ssmac_change_indev = netruninfo_dbg[SSMAC_CHANGE_INDEV];
         
    if (copy_to_user((char *)arg, max_msg, sizeof(struct net_max_check_msg)))
    {
        kfree(max_msg);
        return -EFAULT;
    }
    kfree(max_msg);

    return 0;
}

int get_process_info(void *arg)
{
    struct task_struct *tsk;
    char *pname, *q, *p;
    unsigned int flag = 0;
    int ret = 0;
    
    ioctl_data *pval = NULL;

    pval = (struct ioctl_data *)kzalloc(sizeof(ioctl_data), GFP_KERNEL);
    if(!pval)
        return -EFAULT;

    if (copy_from_user(pval, (char *)arg, sizeof(ioctl_data)))
    {
        kfree(pval);
        return -EFAULT;
    }

    p = kzalloc(128, GFP_KERNEL);
    if(!p)
	{
		kfree(pval);
		return -EFAULT;
	}
	if(pval->size <= 128)
    memcpy(p, pval->buf, pval->size);
	p[127]=0;
    pname = kzalloc(128, GFP_KERNEL);
    if (!pname) {
        //printk("fail to alloc tskname buf\n");
        kfree(pval);
        kfree(p);
        return -1;
    }
    
    printk("\n\n========start==========\n");
    write_lock_irq(&tasklist_lock);
    for_each_process(tsk) {
        get_task_comm(pname, tsk);
		pname[127]=0;
        if (strstr(pname, p)) {
            flag = 1;
            show_stack(tsk, NULL);
            break;
        }
        memset(pname, 0, 128);
    }

    if (!flag) 
    { 
        snprintf(pval->buf,sizeof(pval->buf),"process %s is not exist\n", pname);
    }
    else if (task_is_stopped(tsk))
    {
        
        snprintf(pval->buf,sizeof(pval->buf),"process %s(%ld) is stopped, please cat /proc/kmsg for more info\n", 
                pname, task_pid_nr(tsk));
    }
    else if (task_is_dead(tsk)) 
    {
        snprintf(pval->buf,sizeof(pval->buf),"process %s(%ld) is dead, please cat /proc/kmsg for more info\n", 
                pname, task_pid_nr(tsk));
    }
    else {
        switch(tsk->state) {
            case TASK_RUNNING:
                snprintf(pval->buf,sizeof(pval->buf),"process %s(%ld) is running, please cat /proc/kmsg for more info\n", 
                        pname, task_pid_nr(tsk));

                break;
            case TASK_INTERRUPTIBLE:
                snprintf(pval->buf,sizeof(pval->buf),"process %s(%ld) is sleep and INTERRUPTIBLE, please cat /proc/kmsg for more info\n", 
                        pname, task_pid_nr(tsk));

                break;
            case TASK_UNINTERRUPTIBLE:
                snprintf(pval->buf,sizeof(pval->buf),"process %s(%ld) is sleep and UNINTERRUPTIBLE, please cat /proc/kmsg for more info\n", 
                        pname, task_pid_nr(tsk));

                break;
            default: break;
        }
    }
    
    printk("========end==========\n\n");

    write_unlock_irq(&tasklist_lock);

    if (copy_to_user((char *)arg, pval, sizeof(ioctl_data)))
    {
        //kfree(pval);
        ret = -EFAULT;
    }
    
    kfree(pval);
    kfree(p);
    kfree(pname);
    return ret;
}


int get_pkt_lost_info(unsigned long arg)
{
    fast_entry_t *fast_entry = NULL;
    struct pkt_lost_info *lost_info = NULL;
    struct nf_conn *ct;
    int i = 0;

    lost_info = (struct pkt_lost_info *)kzalloc(sizeof(struct pkt_lost_info), GFP_KERNEL);
    if(!lost_info)
        return -EFAULT;

    memset(lost_info, 0, sizeof(struct pkt_lost_info));
    
    spin_lock_bh(&fastnat_spinlock);
    fast_entry = working_list.next;
    while(NULL != fast_entry)
    {
        ct= fast_entry->ct;
        if(ct)
        {
            if(IPPROTO_TCP == ct->tuplehash[0].tuple.dst.protonum)
            {
                for(i = 0; i < 2; i++)
                {
                    if(ct->packet_info[i].bytes >= 10000 && ct->packet_info[i].packets >= 100)
                    {
                        lost_info->stats[i].send_drops      += ct->conn_pktloss[i].send_drops;
                        lost_info->stats[i].recv_drops      += ct->conn_pktloss[i].recv_drops;
                        lost_info->stats[i].send_drop_bytes += ct->conn_pktloss[i].send_drop_bytes;
                        lost_info->stats[i].recv_drop_bytes += ct->conn_pktloss[i].recv_drop_bytes;
                        lost_info->stats[i].total_packets   += ct->packet_info[i].packets;
                        lost_info->stats[i].total_bytes     += ct->packet_info[i].bytes;
                    }
                }
            }
        }

        fast_entry = fast_entry->next;
    }
    spin_unlock_bh(&fastnat_spinlock);

    if (copy_to_user((char *)arg, lost_info, sizeof(struct pkt_lost_info)))
    {
        kfree(lost_info);
        return -EFAULT;
    }
    
    kfree(lost_info);

    return 0;
}


int get_tcp_stat_info(unsigned long arg)
{
    struct tcp_sock_stat *tcp_info = NULL;

    tcp_info = (struct tcp_sock_stat *)kzalloc(sizeof(struct tcp_sock_stat), GFP_KERNEL);
    if(NULL == tcp_info)
        return -EFAULT;

    tcp_info->tcp_recv_num    = tcp_stats_dbg[TCP_RECV_PKTS];
    tcp_info->tcp_send_num    = tcp_stats_dbg[TCP_SEND_PKTS];
    tcp_info->tcp_retrans_num = tcp_stats_dbg[TCP_RETRANS_PKTS];
    tcp_info->tcp_recv_drops  = tcp_stats_dbg[TCP_RECV_DROPS];
    tcp_info->tcp_send_drops  = tcp_stats_dbg[TCP_SEND_DROPS];
    tcp_info->tcp_rst_send    = tcp_stats_dbg[TCP_RST_SEND_NUM];
    tcp_info->tcp_rst_recv    = tcp_stats_dbg[TCP_RST_RECV_NUM];

    if (copy_to_user((char *)arg, tcp_info, sizeof(struct tcp_sock_stat)))
    {
        kfree(tcp_info);
        return -EFAULT;
    }
    
    kfree(tcp_info);
    return 0;
}

int net_debug_packet = 0;
struct timeval net_debug_packet_tv = {0, 0};
struct list_head net_debug_packet_list_head; 
int net_debug_packet_sec = 0;

static int set_net_debug_packet_sec(unsigned long arg)
{
#if 0
    ioctl_data *val = (ioctl_data *)arg;
    int value = val->value;
    if (value > 5)
        value = 5;
	if(net_debug_packet)
	{
		printk("app_active_net is runing.\n");
		return 0;	
    }		

    net_debug_packet_sec = value * 60;
    net_debug_packet = 1;
    INIT_LIST_HEAD(&net_debug_packet_list_head);
    do_gettimeofday(&net_debug_packet_tv);
    printk("app_active_net  sec=%d ,debug=%d:\n", net_debug_packet_sec, net_debug_packet);
#endif
    return 0;
}

static void app_atcive_net_show()
{
#if 0
    struct net_debug_packet_list *tmp1, *tmp2;
    struct time_list *time_tmp1, *time_tmp2;
    if (net_debug_packet == 1){
        printk("app_active_net record start time sec %lu, usec %lu\n", net_debug_packet_tv.tv_sec, net_debug_packet_tv.tv_usec); 
        list_for_each_entry_safe (tmp1, tmp2, &net_debug_packet_list_head, list) {
			printk("app_active_net pid = %d, tgid = %d, count = %d, name =%s\n", tmp1->pid, tmp1->tgid, tmp1->count, tmp1->pname);
            list_for_each_entry_safe (time_tmp1, time_tmp2, &tmp1->time, packet_list) {
                printk("app_active_net \t\ttime: sec %lu, usec %lu\n", time_tmp1->tv.tv_sec, time_tmp1->tv.tv_usec);
                list_del(&time_tmp1->packet_list);
                kfree(time_tmp1);
            }
            list_del(&tmp1->list);
            kfree(tmp1);
        }
    }
    net_debug_packet = 0;
    net_debug_packet_sec = 0;
	printk("app_active_net finish.\n");
    memset(&net_debug_packet_tv, 0, sizeof(net_debug_packet_tv));
#endif	
}

//¼Ӧ÷
void record_app_atcive_net()
{
#if 0
    if (net_debug_packet == 1)
    {
        int now_pid = current->pid;
		int g_pid = current->tgid;
		char name[DEV_NAME_LEN] = {0};		
	
        struct net_debug_packet_list *tmp;
        struct time_list *time_tmp = kzalloc(sizeof(struct time_list), GFP_ATOMIC);
		
		if(DEV_NAME_LEN >strlen(current->comm))
			memcpy(name,current->comm,strlen(current->comm));
		else
			memcpy(name,current->comm,DEV_NAME_LEN-1);
        list_for_each_entry(tmp, &net_debug_packet_list_head, list){
            if (tmp->pid == now_pid){
                do_gettimeofday(&time_tmp->tv);
                tmp->count++;
                list_add_tail(&time_tmp->packet_list, &tmp->time);
                if (time_tmp->tv.tv_sec > (net_debug_packet_tv.tv_sec+ net_debug_packet_sec))
                    app_atcive_net_show();
                return;
            } 
        }
        struct net_debug_packet_list *packet_tmp = kzalloc(sizeof(struct net_debug_packet_list), GFP_ATOMIC);
        INIT_LIST_HEAD(&packet_tmp->time);
        packet_tmp->count = 1;
        packet_tmp->pid = now_pid;
		packet_tmp->tgid = g_pid;
		memcpy(packet_tmp->pname,name,DEV_NAME_LEN);
        do_gettimeofday(&time_tmp->tv);
        list_add_tail(&time_tmp->packet_list, &packet_tmp->time);
        list_add_tail(&packet_tmp->list, &net_debug_packet_list_head);
        if (time_tmp->tv.tv_sec > (net_debug_packet_tv.tv_sec + net_debug_packet_sec))
            app_atcive_net_show();
    }
#endif	
}

