/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <net/SI/fast_common.h>
#include <net/inet_hashtables.h>
#include <linux/igmp.h>

#include <net/netfilter/nf_conntrack_l4proto.h>

#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_l3proto.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_extend.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_ecache.h>
#include <net/netfilter/nf_conntrack_zones.h>
#include <net/netfilter/nf_conntrack_timestamp.h>
#include <net/netfilter/nf_conntrack_timeout.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>

MODULE_LICENSE("GPL");

/* ***************** ipv4 תر ********************************/
#ifndef CONFIG_PREEMPT_RT_FULL
extern int *vir_addr_ddrnet;
#endif
/* ********************************  ********************************/


/* ******************************** ʵ ********************************/
int dst_expire_count = 0;
extern int no_neighbour;

static inline int rt_is_expired(struct rtable *rth)
{
    return rth->rt_genid != atomic_read(&(dev_net(rth->dst.dev))->ipv4.rt_genid);
}

int fast4_fw_recv(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum)
{
    struct iphdr *iph = ip_hdr(skb);
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    __sum16 *cksum = NULL;
    __be32 *oldip = NULL;
    __be16 *oldport = 0;
    struct net_device *dev = NULL;
    u_int32_t skip_nat = 0;
      
    enum ip_conntrack_info ctinfo;
    unsigned int *timeouts;
    struct nf_conn_timeout *timeout_ext = NULL;
    int ret;
    int rdir;
    int type;
    u_int32_t      nat_addr;
    u_int16_t      nat_port;
    struct ethhdr * eth;
    struct dst_entry *dst_dir = NULL, *dst_rdir = NULL;
#ifndef CONFIG_PREEMPT_RT_FULL
    if(skb->isExtern && ((unsigned long )skb->head < (unsigned long)vir_addr_ddrnet || (unsigned long )skb->head > ((unsigned long)vir_addr_ddrnet+PSBUFFER_MEM_SIZE)))
        panic("fast4_fw_recv addr is not PSBUF mem!!!");
#endif
    /* ģʽδNAT */
    /*if (!test_bit(IPS_DST_NAT_BIT, &ct->status) && !test_bit(IPS_SRC_NAT_BIT, &ct->status)){
        printk("ct nat error\n");
        goto err_out;
    }*/
    
    rdir = (IP_CT_DIR_ORIGINAL == dir) ? IP_CT_DIR_REPLY: IP_CT_DIR_ORIGINAL;
    dst_dir = dst_get_by_ct(ct, dir);

    //TCP˫UDP򼴿
    if (!dst_dir)
        goto err_out;

    //жdst_entryǷ
    if (rt_is_expired((struct rtable*)dst_dir))
    {
        dst_expire_count++;
        spin_lock_bh(&fast_fw_spinlock);
        fast_fw_conn_release(ct);
        spin_unlock_bh(&fast_fw_spinlock);
        goto err_out;
    }
        
    // ¼ŵ㣬ֱָŵ
    if (ct->fast_ct.fast_brport[dir]) 
	{
		rcu_read_lock();
    		dev = rcu_dereference_protected(ct->fast_ct.fast_brport[dir], 1);
       	rcu_read_unlock();
    }
    else{
        dev = dst_dir->dev;
    }

     /*Ƿ񳬹豸MTU*/
    if (!dev || (skb->len > dev->mtu))
    {
        skbinfo_add(NULL, SKB_OVER_MTU);
        goto err_out;
    }
    
    //شİֱͷŲ
    if (strcmp(skb->dev->name, dev->name) == 0)
    {
        skbinfo_add(NULL, SKB_LOOP);
        //nf_conntrack_put(&ct->ct_general);
        kfree_skb(skb);
        printk("fast4_fw loopback skb, free skb\n");
        goto drop_packet;
    }
        
    //οresolve_normal_ct
    if (dir == 1) {
        ctinfo = IP_CT_ESTABLISHED_REPLY;
    } else {
        if (test_bit(IPS_SEEN_REPLY_BIT, &ct->status)) {
            ctinfo = IP_CT_ESTABLISHED;
        } else if (test_bit(IPS_EXPECTED_BIT, &ct->status)) {
            ctinfo = IP_CT_RELATED;
        } else {
            ctinfo = IP_CT_NEW;
        }
    }

    //չtimeoutĬ϶ûУԭֹͻԼ
    timeout_ext = nf_ct_timeout_find(ct);
    if (timeout_ext)
        timeouts = NF_CT_TIMEOUT_EXT_DATA(timeout_ext);
    else
        timeouts = l4proto->get_timeouts(&init_net);

    //¶ʱ״̬
    ret = l4proto->packet(ct, skb, dataoff, ctinfo, PF_INET, NF_INET_PRE_ROUTING, timeouts);
    if (ret <= 0) {
        skb->nfct = NULL;
        goto err_out; // fastʧǰܸskbݣʧܾҪָ
    }

    //жϳdevͷռǷ㹻Ҫexpand
    if (!(skb = fast_expand_headroom(skb, dev))){
       // nf_conntrack_put(&ct->ct_general);
        printk("fast4_fw fast_expand_headroom skb failed, free skb\n");
        goto drop_packet;
    }

    fast_tcpdump(skb);
    
    //ץУݻclonefastɹҪıdataݣҪcopyһ
    if (skb_cloned(skb))
    {
        if (pskb_expand_head(skb, 0, 0, GFP_ATOMIC))
        {    
            //print_sun(SUN_DBG, "fast4_fw_recv clone copy failed !!!\n");
            kfree_skb(skb);
            //nf_conntrack_put(&ct->ct_general);
            printk("fast4_fw pskb_expand_head skb failed, free skb\n");
            goto drop_packet;
        }
		clean_cache(skb->data,skb->len);
    }

    //fastnatɹIPͷ׵ַ,Թcacheˢʱʹ
    skb_reset_network_header(skb);
    skb->isFastnat = 1;
    skb->nfct = &ct->ct_general;
    skb->nfctinfo = ctinfo;
    
    if (test_bit(IPS_SRC_NAT_BIT, &ct->status))
    {
        if(IP_CT_DIR_ORIGINAL == dir)
        {
            nat_addr = ct->tuplehash[rdir].tuple.dst.u3.ip;
            nat_port = ct->tuplehash[rdir].tuple.dst.u.all;
            type = FN_TYPE_SRC;
        }
        else
        {
            nat_addr = ct->tuplehash[rdir].tuple.src.u3.ip;
            nat_port = ct->tuplehash[rdir].tuple.src.u.all;
            type = FN_TYPE_DST;
        }
    }
    else if (test_bit(IPS_DST_NAT_BIT, &ct->status))
    {
        if (IP_CT_DIR_ORIGINAL == dir)
        {
            nat_addr = ct->tuplehash[rdir].tuple.src.u3.ip;
            nat_port = ct->tuplehash[rdir].tuple.src.u.all;
            type = FN_TYPE_DST;
        }
        else
        {
            nat_addr = ct->tuplehash[rdir].tuple.dst.u3.ip;
            nat_port = ct->tuplehash[rdir].tuple.dst.u.all;
            type = FN_TYPE_SRC;
        }
    } else {
        skip_nat = 1;
    }

    if (!skip_nat)
    {
        /*natת*/
        if (IPPROTO_TCP == iph->protocol)
        {
            tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
            cksum = &tcph->check;
            oldport = (FN_TYPE_SRC == type)? (&tcph->source): (&tcph->dest);
        }
        else if (IPPROTO_UDP == iph->protocol)
        {
            udph = (struct udphdr *)(skb->data + iph->ihl * 4);
            cksum = &udph->check;
            oldport = (FN_TYPE_SRC == type)? (&udph->source): (&udph->dest);
        }

        oldip = (FN_TYPE_SRC == type)? (&iph->saddr) : (&iph->daddr);

        if (cksum != NULL && (0!=*cksum || IPPROTO_TCP == iph->protocol))
        {
            inet_proto_csum_replace4(cksum, skb, *oldip, nat_addr, 0);
            inet_proto_csum_replace2(cksum, skb, *oldport, nat_port, 0);
        }
        csum_replace4(&iph->check, *oldip, nat_addr);
        if(oldport)
        *oldport = nat_port;
        *oldip = nat_addr;
    }
    else
    {
        if (IPPROTO_TCP == iph->protocol)
        {
            tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
        }
    }

    //ctӵͳ
    ct->packet_info[dir].packets++;
    ct->packet_info[dir].bytes += skb->len;
    
    //ڵͳ  --- οlinuxԭͳƵĶIP
    if (fastnat_level == FAST_NET_DEVICE)
    {
        skb->dev->stats.rx_packets++;
        skb->dev->stats.rx_bytes += skb->len;
    }  

    if (dev->flags & IFF_UP)
    {
        if (!(dev->flags & IFF_POINTOPOINT)){
            skb_push(skb, ETH_HLEN);
            eth = (struct ethhdr *)skb->data;
            //dev macַΪݰԴmacַ
            memcpy(eth->h_source, dev->dev_addr, ETH_ALEN);
            if (dst_dir->_neighbour)
                memcpy(eth->h_dest, dst_dir->_neighbour->ha, ETH_ALEN);
            else {
                printk("dst_dir->_neighbour is NULL\n");
				kfree_skb(skb);
                no_neighbour++;
                goto drop_packet;
            }
            eth->h_proto = htons(ETH_P_IP);
        }
        skb->dev = dev;
        skb->now_location |= FASTNAT_SUCC;
        dev_queue_xmit(skb);
    }
    else
    {
        printk("fast4_fw dev:%s not up\n", skb->dev->name);
        //print_sun(SUN_DBG, "ERR &&&&&& %s DOWN, kfree_skb!!!!!!!! \n", skb->dev->name);
        kfree_skb(skb);
    }
    //print_sun(SUN_DBG, "skb : 0x%x, fastnat succ--------", skb);

succ_out:
drop_packet:
    if (tmpl)
        nf_conntrack_put(&tmpl->ct_general);
    dst_release(dst_dir);
    return 1;
        
err_out :
    dst_release(dst_dir);
    nf_conntrack_put(&ct->ct_general);
    //print_sun(SUN_DBG, "skb : 0x%x, fastnat FAIL!!!!!!!!!!", skb);
    if (tmpl) {
        skb->nfct = &tmpl->ct_general;
    }
    else {
        skb->nfct = NULL;
    }
    return 0; /* not fast nat */    
}

//POST_ROUTINGڵ㣬fastݵĸֵ
unsigned int napt_handle4_fw(unsigned int hooknum,
            struct sk_buff *skb,
            const struct net_device *in,
            const struct net_device *out, int (*okfn) (struct sk_buff *))
{
    struct nf_conn *ct;
    enum ip_conntrack_info ctinfo;
    u_int8_t protocol;
    enum ip_conntrack_dir dir, rdir;
    struct dst_entry *dst = skb_dst(skb);
#ifdef CONFIG_ATHRS_HW_NAT
    u_int32_t mask =0;
#endif

    //תܿ
    if (fastnat_level == FAST_CLOSE || fastnat_level == FAST_CLOSE_KEEP_LINK)
    {
        return NF_ACCEPT;
    }

    //ֻTCPUDP֧fastICMPҵctTCPUDPģ: ˿ڲɴԱʾж
    if (ip_hdr(skb)->protocol != IPPROTO_TCP && ip_hdr(skb)->protocol != IPPROTO_UDP)
        return NF_ACCEPT;

    //תӹλͼ
    if (!test_bit(FAST_TYPE_VERSION_BIT, &fast_switch)
        || !test_bit(FAST_TYPE_FW4_BIT, &fast_switch) )
    {
        return NF_ACCEPT;
    }
    
    if (!out)
    {
        return NF_ACCEPT;
    }

    //㲥鲥
    if (ipv4_is_multicast(ip_hdr(skb)->daddr) || ipv4_is_lbcast(ip_hdr(skb)->daddr))
    {
        return NF_ACCEPT;
    }
    
    if (!dst || !dst->_neighbour || unlikely(dst->flags & DST_NOCACHE))
    {
        return NF_ACCEPT;
    }
    
    if (memcmp(dst->_neighbour->ha, zeromac, ETH_ALEN) == 0)
    {
        if (!(skb->dev->flags & IFF_POINTOPOINT))
             return NF_ACCEPT;
    }
	
     /*Ƿ񳬹豸MTU*/
    if (dst->dev && (skb->len > dst->dev->mtu))
    {
        return NF_ACCEPT;
    }
	
    if (!(ct = nf_ct_get(skb, &ctinfo)))
    {
        return NF_ACCEPT;
    }

    protocol = nf_ct_protonum(ct);
    
    if (ct->master == NULL)
    {
        //const struct nf_conntrack_helper *helper;
        struct nf_conn_help *temp_help = nfct_help(ct);
        //ĳϴhelpȹӣ뽻linuxעں˴ں˲ܻȡصݰϢ
        if(temp_help!=NULL)
        {
            //helper = rcu_dereference(temp_help->helper);
            //if(!(helper->tuple.src.u.all == htons(21)&&helper->tuple.dst.protonum == IPPROTO_TCP)) {
            return NF_ACCEPT;
             //   }
        }
    }

    /* only forward */
    if (!skb->skb_iif)
    {
        return NF_ACCEPT;
    }

    //˲ҪfastnatЭ,ݶ˿ںŽй
    if (check_skip_ports(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all))
    {
        return NF_ACCEPT;
    }

    dir = CTINFO2DIR(ctinfo);
    
    rdir = (IP_CT_DIR_ORIGINAL == dir) ? IP_CT_DIR_REPLY: IP_CT_DIR_ORIGINAL;
    
    /*ֻTCP/UDPfastnat*/
    if (IPPROTO_TCP == protocol)
    {
        /*TCPֳɹ*/
        if(!test_bit(IPS_ASSURED_BIT, &ct->status))
        {
            return NF_ACCEPT;
        }
    }
    else if (IPPROTO_UDP != protocol)
    {
        return NF_ACCEPT;
    }
    
    spin_lock_bh(&fast_fw_spinlock);
    if (ct->fast_ct.fast_dst[dir] && (ct->fast_ct.fast_dst[dir] != dst))
    {
        fast_fw_conn_release(ct);
    }
    
    if (!ct->fast_ct.fast_dst[dir])
    {
        rcu_assign_pointer(ct->fast_ct.fast_dst[dir], dst);
        ct->fast_ct.fast_brport[dir] = getBridgePort(dst->_neighbour, out);
        fast_dst_add_ct(dst, ct);
    }
    spin_unlock_bh(&fast_fw_spinlock);
    
    ct->fast_ct.isFast = FAST_CT_FW4;
    
    return NF_ACCEPT;
}

static struct nf_hook_ops fast4_fw_hook = {
    .hook = napt_handle4_fw,
    .owner = THIS_MODULE,
    .pf = PF_INET,
    .hooknum = NF_INET_POST_ROUTING,
    .priority = NF_IP_PRI_LAST,
};

int fast4_fw_init(void)
{
    int ret = 0;
        
    ret = nf_register_hook(&fast4_fw_hook);
    if (ret != 0)
    {
        //print_sun(SUN_ERR,"init fast4_fw_init failed\n");
        return -EINVAL;
    }
    //print_sun(SUN_DBG,"init fast4_fw_init done\n");

    return 0;
}

int fast4_fw_cleanup(void)
{
    fast_release_all(RELEASE_ALL_DST);
    nf_unregister_hook(&fast4_fw_hook);
    return 0;
}

