/*
 * linux/arch/arm/mach-zx297520v2/mach/clock.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef CLOCK_H
#define CLOCK_H

#include <linux/clkdev.h>
#include <mach/iomap.h>
#include <mach/board.h>

#define name_main_clk_32k   				"main_clk_32k"
#define name_main_clk_26m   				"main_clk_26m"
#define name_mpll_clk_12m   				"mpll_clk_12m"
#define name_mpll_clk_24m   				"mpll_clk_24m"
#define name_mpll_clk_39m   				"mpll_clk_39m"
#define name_mpll_clk_52m   				"mpll_clk_52m"
#define name_mpll_clk_78m   				"mpll_clk_78m"
#define name_mpll_clk_104m   				"mpll_clk_104m"
#define name_mpll_clk_124m8   				"mpll_clk_124m8"
#define name_mpll_clk_156m   				"mpll_clk_156m"
#define name_mpll_clk_208m   				"mpll_clk_208m"
#define name_mpll_clk_312m   				"mpll_clk_312m"
#define name_mpll_clk_624m   				"mpll_clk_624m"
#define name_dpll_clk_491m52   				"dpll_clk_491m52"
#define name_dpll_clk_122m88   				"dpll_clk_122m88"
#define name_dpll_clk_81m92   				"dpll_clk_81m92"
#define name_upll_clk_480m   				"upll_clk_480m"
#define name_upll_clk_96m   				"upll_clk_96m"
#define name_gpll_clk_25m   				"gpll_clk_25m"
#define name_gpll_clk_50m   				"gpll_clk_50m"
#define name_gpll_clk_100m   				"gpll_clk_100m"
#define name_gpll_clk_178m   				"gpll_clk_178m"
#define name_gpll_clk_200m   				"gpll_clk_200m"

/*
 * flags used across common struct clk.  these flags should only affect the
 * top-level framework.  custom flags for dealing with hardware specifics
 * belong in struct clk_foo
 */
#define CLK_IGNORE_UNUSED					BIT(3) /* do not gate even if unused */
#define CLK_IS_ROOT							BIT(4) /* root clk, has no parent */
#define CLK_AUTO_ROUND_PARENT				BIT(5) /* auto round parent to select rate */
#define CLK_NO_ODD_DIV						BIT(6) /* no div or even div */

struct clk;

/**
 * struct clk_hw - handle for traversing from a struct clk to its corresponding
 * hardware-specific structure.  struct clk_hw should be declared within struct
 * clk_foo and then referenced by the struct clk instance that uses struct
 * clk_foo's clk_ops
 *
 * clk: pointer to the struct clk instance that points back to this struct
 * clk_hw instance
 */
struct clk_hw
{
	struct clk *clk;
};

struct clk_ops {
	int				(*prepare)(struct clk_hw *hw);
	void			(*unprepare)(struct clk_hw *hw);

	int				(*enable)(struct clk_hw *hw);
	void			(*disable)(struct clk_hw *hw);
	int				(*is_enabled)(struct clk_hw *hw);

	unsigned long	(*recalc_rate)(struct clk_hw *hw,
					unsigned long parent_rate);
	long			(*round_rate)(struct clk_hw *hw, unsigned long,
					unsigned long *);
	int				(*set_rate)(struct clk_hw *hw, unsigned long);

	int				(*set_parent)(struct clk_hw *hw, u8 index);
	u8				(*get_parent)(struct clk_hw *hw);
	void			(*init)(struct clk_hw *hw);			/*called when register to clk_dev*/
	int    			(*set_auto_gate)(struct clk_hw *hw, bool enable);
};
struct clk
{
	const char				*name;
	const struct clk_ops	*ops;
	struct clk_hw			*hw;
	struct clk				*parent;
	char					**parent_names;
	struct clk				**parents;
	u8						num_parents;
	unsigned long			rate;
	unsigned long			new_rate;
	unsigned long			flags;
	unsigned int			enable_count;
	struct list_head 		list;
};

#define CLK_ZX29_CONFIG(dev, con, ck) 	\
	{				\
			.dev_id = dev,	\
			.con_id = con,	\
			.clk = ck,	\
	}

#define NAME_CLK(clk) 		name_##clk

#define DEFINE_ZX29_ROOT_CLK(root_clk,clk_rate) \
static struct clk root_clk = { \
	.name 	= NAME_CLK(root_clk), \
    .rate 	= clk_rate, \
    .ops  	= &root_clk_ops, \
    .flags = CLK_IS_ROOT, \
}

struct zx29_hwclk
{
    struct clk_hw   hw;
    struct zx29_reg_conf     clk_en_reg;
    struct zx29_reg_conf     clk_sel_reg;
    struct zx29_reg_conf     clk_div_reg;
    struct zx29_reg_conf     clk_gate_reg;
};

#define to_zx29_hwclk(_hw) container_of(_hw, struct zx29_hwclk, hw)

extern struct clk_lookup periph_clocks_lookups[];
extern unsigned int periph_clocks_lookups_num;
#endif
