#include <linux/module.h>  
#include <linux/types.h>  
#include <linux/fs.h>  
#include <linux/errno.h>  
#include <linux/mm.h>  
#include <linux/sched.h>  
#include <linux/init.h>  
#include <linux/cdev.h>  
#include <asm/io.h>  
#include <asm/uaccess.h>  
#include <linux/timer.h>  
#include <asm/atomic.h>  
#include <linux/slab.h>  
#include <linux/device.h>  
  
#define AT_CDEV_MAJOR 255  /*Ԥat dev豸*/  
  
static int at_cdev_major = AT_CDEV_MAJOR;  
  
/*豸ṹ,˽ṹԷװ豸صһЩϢ 
  źҲԷװڴ˽ṹУstruct cdev cdev*/  
struct at_cdev   
{  
    struct cdev cdev;  
};  
  
struct at_cdev *at_devp; /*豸ṹָ*/  
  
/*ļ򿪺ϲԴ豸openʱִ*/  
int at_cdev_open(struct inode *inode, struct file *filp)     
{  
    printk(KERN_NOTICE "======== at_cdev_open ");  
    return 0;  
}  
  
/*ļͷţϲԴ豸closeʱִ*/  
int at_cdev_release(struct inode *inode, struct file *filp)      
{  
    printk(KERN_NOTICE "======== at_cdev_release ");     
    return 0;  
}  
  
/*ļĶϲԴ豸readʱִ*/  
static ssize_t at_cdev_read(struct file *filp, char __user *buf, size_t count, loff_t *ppos)  
{  
    printk(KERN_NOTICE "======== at_cdev_read ");    
	return 0;
}

static ssize_t at_cdev_write(struct file *filp, const char __user *buf, size_t count, loff_t *ppos)
{
    printk(KERN_NOTICE "======== at_cdev_write ");      
	return 0;
}

static long at_cdev_ioctl(struct file *filp, unsigned int cmd, unsigned long arg)
{
    printk(KERN_NOTICE "======== at_cdev_ioctl ");
	return 0;
}

  
/* ļṹ壬Ѿṹ*/  
static const struct file_operations at_cdev_fops =  
{  
    .owner = THIS_MODULE,  
    .open = at_cdev_open,  
    .release = at_cdev_release,  
    .read = at_cdev_read, 
    .write = at_cdev_write,
    .unlocked_ioctl = at_cdev_ioctl	
};  
  
/*ʼעcdev*/  
static void at_cdev_setup_cdev(struct at_cdev *dev, int index)  
{  
    printk(KERN_NOTICE "======== at_cdev_setup_cdev");     
    int err, devno = MKDEV(at_cdev_major, index);   
  
    /*ʼһַ豸豸ֵ֧Ĳat_cdev_fops*/     
    cdev_init(&dev->cdev, &at_cdev_fops);       
    dev->cdev.owner = THIS_MODULE;  
    dev->cdev.ops = &at_cdev_fops;  
       
    err = cdev_add(&dev->cdev, devno, 1);    
    if(err)  
    {  
        printk(KERN_NOTICE "Error %d add at_cdev %d", err, index);   
    }  
}  
  
int at_cdev_init(void)  
{  
    printk(KERN_NOTICE "======== at_cdev_init ");    
    int ret;  
    dev_t devno = MKDEV(at_cdev_major, 0);  
  
    struct class *at_cdev_class;  
    /*豸ţʧܲö̬뷽ʽ*/  
    if(at_cdev_major)  
    {  
        printk(KERN_NOTICE "======== at_cdev_init 1");  
        ret = register_chrdev_region(devno, 1, "at_ps");  
    }else  
    {  
        printk(KERN_NOTICE "======== at_cdev_init 2");  
        ret = alloc_chrdev_region(&devno,0,1,"at_ps");  
        at_cdev_major = MAJOR(devno);  
    }  
    if(ret < 0)  
    {  
        printk(KERN_NOTICE "======== at_cdev_init 3");  
        return ret;  
    }  
    /*̬豸ṹڴ*/  
    at_devp = kmalloc(sizeof(struct at_cdev), GFP_KERNEL);  
    if(!at_devp)  /*ʧ*/  
    {  
        ret = -ENOMEM;  
        printk(KERN_NOTICE "Error add at_cdev");     
        goto fail_malloc;  
    }  
  
    memset(at_devp,0,sizeof(struct at_cdev));  
    
    at_cdev_setup_cdev(at_devp, 0);  
  
    at_cdev_class = class_create(THIS_MODULE, "at_ps");  
    device_create(at_cdev_class, NULL, MKDEV(at_cdev_major, 0), NULL, "at_ps");  
   
    return 0;  
  
    fail_malloc:  
        unregister_chrdev_region(devno,1);  
	return ret;
}  
  
void at_cdev_exit(void)    /*ģж*/  
{  
    printk(KERN_NOTICE "End at_cdev");   
    cdev_del(&at_devp->cdev);  /*עcdev*/  
    kfree(at_devp);       /*ͷ豸ṹڴ*/  
    unregister_chrdev_region(MKDEV(at_cdev_major,0),1);    //ͷ豸  
}  
  
MODULE_LICENSE("Dual BSD/GPL");  
module_param(at_cdev_major, int, S_IRUGO);  
module_init(at_cdev_init);  
module_exit(at_cdev_exit);  
