#ifndef _DDRNET_QUEUE_H_
#define _DDRNET_QUEUE_H_
#ifdef USE_DDRNET_PACKET
#include <linux/spinlock.h>
#include <linux/semaphore.h>

//typedef struct list_head _list;
//typedef struct spinlock _lock;
typedef __kernel_size_t		SIZE_T;


#define DDRNET_SKB_PACKET_SIZE  sizeof(struct ddrnet_skb_packet)
#define DDRNET_PSB_PACKET_SIZE  sizeof(struct ddrnet_psbuf_packet)


struct ddrnet_queue {
    struct list_head queue;
    int qlen;
    struct spinlock lock;
};

struct ddrnet_skb_packet {
	struct list_head list;
      struct  T_ToExt_info packet;
};

struct ddrnet_psbuf_packet {
	struct list_head list;
      void* packet;
};

__inline static void ddrnet_init_listhead(struct list_head *list)
{
        INIT_LIST_HEAD(list);
}

__inline static void ddrnet_init_queue(struct ddrnet_queue *pqueue)
{
	INIT_LIST_HEAD(&(pqueue->queue));
	spin_lock_init(&(pqueue->lock));
	pqueue->qlen = 0;
}

__inline static void ddrnet_list_insert_head(struct list_head *plist, struct list_head *phead)
{
	list_add(plist, phead);
}

__inline static void ddrnet_list_insert_tail(struct list_head *plist, struct list_head *phead)
{
	list_add_tail(plist, phead);
}
 __inline static void ddrnet_list_del(struct list_head * prev, struct list_head * next)
{
	next->prev = prev;
	prev->next = next;
}
 __inline static void ddrnet_list_del_entry(struct list_head *entry)
 {
     ddrnet_list_del(entry->prev, entry->next);
 }

__inline static void ddrnet_list_delete(struct list_head *plist)
{
	//list_del_init(plist);
	list_del(plist);
}



__inline static struct list_head *get_next(struct list_head *list)
{
	return list->next;
}

__inline static u32	ddrnet_is_list_empty(struct list_head *phead)
{
	return (list_empty(phead) ? TRUE: FALSE);
}

__inline static void ddrnet_spinlock(struct spinlock *plock, u32 flag)
{
	spin_lock_irqsave(plock, flag);
	//spin_lock(plock);
}

__inline static void ddrnet_spinunlock(struct spinlock *plock, u32 flag)
{
	spin_unlock_irqrestore(plock, flag);
	//spin_unlock(plock);
}
#endif
#endif  /*  _DDRNET_QUEUE_H_  */
