/*
 * Ethernet driver for zte zx2975xx gmac on chip network device
 * (c)2008 http://www.zte.com.cn
 * Authors:	zhang dongdong <zhang.dongdong16@zte.com.cn>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/phy.h>
#include <linux/platform_device.h>
#include <mach/iomap.h>
#include <mach/pcu.h>
#include <linux/kthread.h>
#include <linux/semaphore.h>
#include <linux/kobject.h>
#include <linux/gmac/gmac.h>

#define GMAC_NO_INT

#ifdef GMAC_NO_INT
#define GTIMER_INTERVAL  2000
#endif

#define MAC_ADDR_SET                         1
#define MAC_ADDR_LENTH		                 6	

#define GMAC_BD_LEN                32

#define GMAC_RX_BD_NUM    (1 << 9)
#define GMAC_TX_BD_NUM    (1 << 10)

#define GMAC_RX_BUF_LEN    (GMAC_BD_LEN * GMAC_RX_BD_NUM)
#define GMAC_TX_BUF_LEN    (GMAC_BD_LEN * GMAC_TX_BD_NUM)

#define GMAC_BUF_LEN        (GMAC_RX_BUF_LEN + GMAC_TX_BUF_LEN)

#define MAC_RESET_NUM               3 											//
#define MAC_WAIT_TIME               10000 										//0.1ms //ʱΪms
#define PHY_CLOCK			  		5											// ʱΪ 2ubootʹʱ3 0x03
#define PHY_RESET					(1 << 15)									// PHY λ
#define DMA_OWNER 					(1 << 31)									// ȨDMA

#define ERR_TX_ES 					(1 << 15)									// ʹ
#define ERR_TX_JT 					(1 << 14)  									// Jabber Timeout
#define ERR_TX_FF 					(1 << 13)  									// Frame Flushed
#define ERR_TX_LC 					(1 << 11)  									// Loss of Carrier
#define ERR_TX_NC 					(1 << 10)  									// No Carrier
#define ERR_TX_LATECOL 				(1 << 9)  									// Late Collision
#define ERR_TX_EC 					(1 << 8)  									// Excessive Collision
#define ERR_TX_ED 					(1 << 2)  									// Excessive Deferral
#define ERR_TX_UF 					(1 << 1)  									// Underflow Error
#define ERR_RX_ES 					(1 << 15)  									// մ
#define ERR_RX_LE 					(1 << 12)   								// Length Error
#define ERR_RX_OE 					(1 << 11)   								// Overflow Error
#define ERR_RX_IPC 					(1 << 7)   									// Timestamp Available/IP Checksum Error (Type1) /Giant Frame
#define ERR_RX_LC 					(1 << 6)   									// Late Collision
#define ERR_RX_CE 					(1 << 1)   									// Rx MAC Address/Payload Checksum Error
#define INT_ST_TX  					0x01       									// ͺж
#define INT_ST_RX  					0x40										// պж

#define GMAC_FRAME_LEN               1528

#define	MAC(x)						gmac[(x) >> 2]
#define mac_mii_is_busy()			(MAC(0x0010) & 0x01)
#define mac_provide_clock()			(MAC(0x0010) = (PHY_CLOCK <<2))
#define mac_reset()					(MAC(0x1000)	|= 1)
#define mac_wait_reset_finished()	while(MAC(0x1000) & 1)
#define mac_int_enable()			(MAC(0x101C)	 = 0x180f5)
#define mac_int_disable()			(MAC(0x101C)	 = 0x00)
#define mac_int_clear(x)			(MAC(0x1014)	 = (x))
#define mac_enable()				(MAC(0x0000)	|= (0x3 << 2))                    
#define mac_disable()				(MAC(0x0000)	&= ~(0x3 << 2))             //  gmac stop rx&tx
#define mac_set_full_duplex_mode()	(MAC(0x0000)	|= 1 << 11)					// Ϊȫ˫ģʽ
#define mac_set_half_duplex_mode()	(MAC(0x0000)	&= ~(1 << 11))				// Ϊ˫ģʽ
#define mac_set_speed_100m_mode()	(MAC(0x0000)	|= 1 << 14)					// Ϊ100M
#define mac_set_speed_10m_mode()	(MAC(0x0000)	&= ~(1 << 14))				// Ϊ10M
#define mac_set_gmii_mode()			(MAC(0x0000)	&=  ~(1 << 15))				// PHYĽӿΪGMII
#define mac_set_mii_mode()			(MAC(0x0000)	|= 1 << 15)					// PHYĽӿΪMII
#define mac_rece_all_data()			(MAC(0x0004)	|= (1 << 31) | 1)			// 
#define dma_enable()				(MAC(0x1018)	|= ((1 << 1) | (1 << 13)))
#define dma_disable()				(MAC(0x1018)	&= ~((1 << 1) | (1 << 13))) // ֹͣշdma stop
#define dma_continue_tx()			(MAC(0x1004)	 = 1)						// ֹͣ
#define dma_continue_rx()			(MAC(0x1008)	 = 1)						// ֹͣ
#define dma_set_tx_buffer(x)		(MAC(0x1010)	 = (x))						// ÷ͻ(ַ)
#define dma_set_rx_buffer(x)		(MAC(0x100C)	 = (x))						// ýջ(ַ)
#define dma_clear_tx_fifo()			(MAC(0x1018)	|= 1 << 20)					// FIFO
#define dma_wait_tx_fifo_cleared()	while(MAC(0x1018) & (1 << 20));				// ȴFIFO

#define gmac_phy_reset()            ((*(volatile unsigned int  *)(ZX_SOC_SYS_BASE+0x150)) &= ~0x10)
#define gmac_phy_release()          ((*(volatile unsigned int  *)(ZX_SOC_SYS_BASE+0x150)) |= 0x10)
#define gmac_set_clk()				((*(volatile unsigned int  *)(ZX_TOP_CRM_BASE+0x11C)) = 0x00000005)   // GMAC_MOD_CFG gmac clk 50m


#define MIN(a,b)   					((a) < (b) ? (a) : (b))

typedef enum
{
	eSET_AUTO_NEGO = 0,
	eSET_10M_HALF_DUPLEX = 1,
	eSET_10M_FULL_DUPLEX = 2,
	eSET_100M_HALF_DUPLEX = 4,
	eSET_100M_FULL_DUPLEX = 8,
	eSET_SPEED_DUPLEX_END = 5
} E_SET_SPEED_DUPLEX;

struct bd_rx
{
    u32 					RDES0;							// ƼĴ
    u32 					RDES1;							// ݳ
    u32 					dma_buf;						// ݻַ
    u32 					next;							// һ
    struct sk_buff 			*skb;							// SKB ָ
    u32						data0;							// δʹãݶ
    u32						data1;							// δʹãݶ
    u32						data2;							// δʹãݶ
};

struct bd_tx
{
    u32 					TDES0;							// ƼĴ
    u32 					TDES1;							// ݳ
    u32 					dma_buf;						// ݻַ
    u32 					next;							// һ
    struct sk_buff 			*skb;							// SKB ָ
    u32						data0;							// δʹãݶ
    u32						data1;							// δʹãݶ
    u32						data2;							// δʹãݶ
};

struct zx29_gmac_dev
{
	struct net_device*		netdev;
	struct spinlock			lock;
	struct tasklet_struct	tasklet;
#ifdef GMAC_NO_INT
	struct semaphore        sem;
	struct hrtimer*			timer;
#endif
	struct wake_lock 		wake_lock;

	int                     stopped;
	unsigned long			base_addr;	/* device I/O address	*/
	unsigned				int_event;						// ״̬
	unsigned long			nports;							// PHY/SWITCH˿ڸ
	unsigned long			rmii_port;						// RMIIڶӦPHY˿ں

	unsigned				dma_rx_phy_init;				// DMA ʼַ
	char*					dma_rx_vir_init;				// DMA ʼַ
	unsigned				dma_rx_phy;						// DMA ַ
	char*					dma_rx_vir;						// DMA ַ
	unsigned				dma_tx_phy;						// DMA ַ
	char*					dma_tx_vir;						// DMA ַ
	int						rx_bd_offset;					// ƫ
	int						tx_bd_offset;					// ƫ
	int						txed_bd;						// ѷƫ

	E_SET_SPEED_DUPLEX		set_duplex_mode;				//0:Ӧ, 1:10M˫2:10Mȫ˫4:100M˫8:100Mȫ˫
	
	int                     autoneg;

	struct phy_device *phydev;
	struct {
		struct mii_bus *bus;
		int irq[PHY_MAX_ADDR];
	} mii;
	struct {
		unsigned int speed;
		u8 giga;
		u8 isup;
		u8 duplex;
	} link;
};

extern void gmac_event_notify(GMAC_NOTIFY_EVENT notify_type, void* puf);
extern int  gmac_event_init(void);

