/*
* Copyright (C) 2010 Realtek Semiconductor Corp.
* All Rights Reserved.
*
*                
*
*/

#ifndef __ZX_GMAC_H__
#define __ZX_GMAC_H__

#include <linux/module.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/spinlock.h>
#include <linux/ethtool.h>
#include <linux/delay.h>
#include <linux/platform_device.h>
#include <linux/irq.h>
#include <linux/crc32.h>
#include <linux/mii.h>
#include <linux/clk.h>
#include <linux/semaphore.h>
#include <linux/gpio.h>
#include <linux/kthread.h>

#include <mach/iomap.h>
#include <mach/pcu.h>


#include <linux/sched.h>
#include <linux/workqueue.h>
#include <linux/kobject.h>
//#include <linux/android_notify.h>

#include <linux/soc/zte/pm/drv_idle.h>
#include <linux/nvro_comm.h>

#define GMAC_BD_LEN                32

#define GMAC_RX_BD_NUM    (1 << 9)
#define GMAC_TX_BD_NUM    (1 << 10)

#define GMAC_RX_BUF_LEN    (GMAC_BD_LEN * GMAC_RX_BD_NUM)
#define GMAC_TX_BUF_LEN    (GMAC_BD_LEN * GMAC_TX_BD_NUM)

#define GMAC_BUF_LEN        (GMAC_RX_BUF_LEN + GMAC_TX_BUF_LEN)

#define MAC_ADDR_SET                            1
#define MAC_ADDR_LENTH		                 6	

#define PHY_AUTONEG_TIMEOUT              100000                                       //Э̵ȴʱ

#define MAC_RESET_NUM                       3 //
#define MAC_WAIT_TIME                       10000 //0.1ms //ʱΪms
#define PHY_CLOCK			  		5											// ʱΪ 2ubootʹʱ3 0x03
#define PHY_RESET					(1 << 15)									// PHY λ
#define DMA_OWNER 					(1 << 31)									// ȨDMA

//#define GMAC_CLKEN            		0xFCA0013C
/* Basic mode control register. */
#define BMCR_RESV			0x003f	/* Unused...		       */
#define BMCR_SPEED1000		0x0040	/* MSB of Speed (1000)	       */
#define BMCR_CTST			0x0080	/* Collision test	       */
#define BMCR_FULLDPLX		0x0100	/* Full duplex		       */
#define BMCR_ANRESTART		0x0200	/* Auto negotiation restart    */
#define BMCR_ISOLATE		0x0400	/* Disconnect DP83840 from MII */
#define BMCR_PDOWN			0x0800	/* Powerdown the DP83840       */
#define BMCR_ANENABLE		0x1000	/* Enable auto negotiation     */
#define BMCR_SPEED100		0x2000	/* Select 100Mbps	       */
#define BMCR_LOOPBACK		0x4000	/* TXD loopback bits	       */
#define BMCR_RESET			0x8000	/* Reset the DP83840	       */
#define MAC_HWETHER      	OS_FLASH_AMT_COMM_RO_GMAC_OFFSET
/*------------------------------------------------------------------------------
* :
* ʹ
* մ
* Ĵж״̬
------------------------------------------------------------------------------*/
#define ERR_TX_ES 					(1 << 15)									// ʹ
#define ERR_TX_JT 					(1 << 14)  									// Jabber Timeout
#define ERR_TX_FF 					(1 << 13)  									// Frame Flushed
#define ERR_TX_LC 					(1 << 11)  									// Loss of Carrier
#define ERR_TX_NC 					(1 << 10)  									// No Carrier
#define ERR_TX_LATECOL 				(1 << 9)  									// Late Collision
#define ERR_TX_EC 					(1 << 8)  									// Excessive Collision
#define ERR_TX_ED 					(1 << 2)  									// Excessive Deferral
#define ERR_TX_UF 					(1 << 1)  									// Underflow Error
#define ERR_RX_ES 					(1 << 15)  									// մ
#define ERR_RX_LE 					(1 << 12)   								// Length Error
#define ERR_RX_OE 					(1 << 11)   								// Overflow Error
#define ERR_RX_IPC 					(1 << 7)   									// Timestamp Available/IP Checksum Error (Type1) /Giant Frame
#define ERR_RX_LC 					(1 << 6)   									// Late Collision
#define ERR_RX_CE 					(1 << 1)   									// Rx MAC Address/Payload Checksum Error
#define INT_ST_TX  					0x01       									// ͺж
#define INT_ST_RX  					0x40										// պж

#define GMAC_FRAME_LEN                0x5F8
/*------------------------------------------------------------------------------
* : ԼĴһЩ
------------------------------------------------------------------------------*/
#define	MAC(x)						gmac[(x) >> 2]
#define mac_mii_is_busy()			(MAC(0x0010) & 0x01)
#define mac_provide_clock()			(MAC(0x0010) = (PHY_CLOCK <<2))
#define mac_reset()					(MAC(0x1000)	|= 1)
#define mac_wait_reset_finished()	while(MAC(0x1000) & 1)
#define mac_int_enable()			(MAC(0x101C)	 = 0x180f5)
#define mac_int_disable()			(MAC(0x101C)	 = 0x00)
#define mac_int_clear(x)			(MAC(0x1014)	 = (x))
#define mac_enable()				(MAC(0x0000)	|= (0x3 << 2))                    
#define mac_disable()				(MAC(0x0000)	&= ~(0x3 << 2))                               //  gmac stop rx&tx
#define mac_set_duplex_mode()		(MAC(0x0000)	|= 1 << 11)					// Ϊȫ˫ģʽ
#define mac_set_gmii_mode()			(MAC(0x0000)	&=  ~(1 << 15))					// PHYĽӿΪGMII
#define mac_set_mii_mode()			(MAC(0x0000)	|= 1 << 15)					// PHYĽӿΪMII
#define mac_rece_all_data()			(MAC(0x0004)	|= (1 << 31) | 1)			// 
#define dma_enable()				(MAC(0x1018)	|= ((1 << 1) | (1 << 13)))
#define dma_disable()				(MAC(0x1018)	&= ~((1 << 1) | (1 << 13)))    // ֹͣշdma stop
#define dma_continue_tx()			(MAC(0x1004)	 = 1)						// ֹͣ
#define dma_continue_rx()			(MAC(0x1008)	 = 1)						// ֹͣ
#define dma_set_tx_buffer(x)		(MAC(0x1010)	 = (x))						// ÷ͻ(ַ)
#define dma_set_rx_buffer(x)		(MAC(0x100C)	 = (x))						// ýջ(ַ)
#define dma_clear_tx_fifo()			(MAC(0x1018)	|= 1 << 20)					// FIFO
#define dma_wait_tx_fifo_cleared()	while(MAC(0x1018) & (1 << 20));				// ȴFIFO


#define MIN(a,b)   					((a) < (b) ? (a) : (b))

typedef enum
{
	eSPEED_10M = 0,
	eSPEED_100M,
	eSPEED_END
} E_SPEED;

typedef enum
{
	eDUPLEX_HALF = 0,
	eDUPLEX_FULL,
	eDUPLEX_END
} E_DUPLEX;

typedef enum
{
	eSET_AUTO_NEGO = 0,
	eSET_10M_FULL_DUPLEX = 2,
	eSET_100M_HALF_DUPLEX = 4,
	eSET_100M_FULL_DUPLEX = 8,
	eSET_10M_HALF_DUPLEX = 1,
	eSET_SPEED_DUPLEX_END = 5
} E_SET_SPEED_DUPLEX;

typedef enum
{
	eLINK_OFF = 0,
	eLINK_ON,
	eLINK_END
} E_LINK_STATE;

typedef enum
{
	ePERIPHERAL_PHY = 0,
	ePERIPHERAL_SWITCH,
	ePERIPHERAL_END
} E_DEV_TYPE;

typedef enum{
     GMAC_ETH_PLUGIN,
     GMAC_ETH_PLUGOUT,
     GMAC_EVNET_NUM,
}gmac_notify_event;
/*------------------------------------------------------------------------------
* ¼Ϊṹ嶨:
* 
* 
------------------------------------------------------------------------------*/
struct bd_rx
{
    u32 					RDES0;							// ƼĴ
    u32 					RDES1;							// ݳ
    u32 					dma_buf;						// ݻַ
    u32 					next;							// һ
    struct sk_buff 			*skb;							// SKB ָ
    u32						data0;							// δʹãݶ
    u32						data1;							// δʹãݶ
    u32						data2;							// δʹãݶ
};

struct bd_tx
{
    u32 					TDES0;							// ƼĴ
    u32 					TDES1;							// ݳ
    u32 					dma_buf;						// ݻַ
    u32 					next;							// һ
    struct sk_buff 			*skb;							// SKB ָ
    u32						data0;							// δʹãݶ
    u32						data1;							// δʹãݶ
    u32						data2;							// δʹãݶ
};

struct zx_net_dev
{
	struct net_device*		netdev;
	struct clk				*clk;							// ע⣬ʱԴֻݲʹ
	int						phy;							// PHY ڽӿеĴ
	unsigned				phy_id;							// PHY ID
	unsigned				dma_rx_phy;						// DMA ַ
	char*					dma_rx_vir;						// DMA ַ
	unsigned				dma_tx_phy;						// DMA ַ
	char*					dma_tx_vir;						// DMA ַ
	int						rx_bd_offset;					// ƫ
	int						tx_bd_offset;					// ƫ
	int						txed_bd;						// ѷƫ
	struct timer_list		timer;							// ҪʱѯPHY״̬
	E_LINK_STATE			link;							// PHY״̬
	E_SPEED					speed;							//0,10M; 1,100M
	E_DUPLEX				duplex;							//0,half; 1,full
	E_SET_SPEED_DUPLEX		set_duplex_mode;				//0:Ӧ, 1:10Mȫ˫2:100M˫3:100Mȫ˫4:10M˫
	int                     autoneg;
	struct spinlock			phy_lock;						//linkspeedduplexset_duplex_modePHYصϢһ
	struct spinlock			lock;
	struct tasklet_struct	tasklet;						// 벿
	unsigned				int_event;						// ״̬
	int 					ext_irq;
       struct task_struct *      switch_thread;
       struct semaphore       phy_sem;
       //struct tasklet_struct	ext_tasklet;						// 벿
       unsigned	int			ext_int_event;						// ״̬
       int                                stopped;       
	E_DEV_TYPE                  device_type;  
	int (*init)(struct net_device *dev);
	int (*open)(struct net_device *dev);
	int (*stop)(struct net_device *dev);
	int (*release)(struct net_device *dev);
	E_LINK_STATE (*link_state)(struct net_device *dev);
};
    

#endif  /*__RTK_API_H__*/



