/*
 * drivers/net/phy/realtek.c
 *
 * Driver for Realtek PHYs
 *
 * Author: Johnson Leung <r58129@freescale.com>
 *
 * Copyright (c) 2004 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 */
#include <linux/phy.h>
#include <linux/module.h>
#include <linux/gmac/gmac.h>
#include "./rtl8306e/rtl8306e_types.h"
#include "./rtl8306e/rtl8306e_asicdrv.h"
#include "./rtl8306e/rtk_api.h"

#define RTL821x_PHYSR		0x11
#define RTL821x_PHYSR_DUPLEX	0x2000
#define RTL821x_PHYSR_SPEED	0xc000
#define RTL821x_INER		0x12
#define RTL821x_INER_INIT	0x6400
#define RTL821x_INSR		0x13

MODULE_DESCRIPTION("Realtek PHY driver");
MODULE_AUTHOR("Johnson Leung");
MODULE_LICENSE("GPL");

#ifdef CONFIG_RTK8306E_PHY
struct phy_device *realtek_phydev;

extern int rtl8306e_config_init(void);

int smiRead(int phyad, int regad,int * data)
{
	*data = mdiobus_read(realtek_phydev->bus, phyad, regad);	
	return 1;
}

int smiWrite(int phyad, int regad, int data)
{
	mdiobus_write(realtek_phydev->bus, phyad, regad, data);
	return 1;
}
#endif

static int rtl821x_ack_interrupt(struct phy_device *phydev)
{
	int err;

	err = phy_read(phydev, RTL821x_INSR);

	return (err < 0) ? err : 0;
}

static int rtl821x_config_intr(struct phy_device *phydev)
{
	int err;

	if (phydev->interrupts == PHY_INTERRUPT_ENABLED)
		err = phy_write(phydev, RTL821x_INER,
				RTL821x_INER_INIT);
	else
		err = phy_write(phydev, RTL821x_INER, 0);

	return err;
}

static int rtl8306x_config_init(struct phy_device *phydev)
{
	int err = 0;

	printk("@@@@@@@@@@@@rtl8306x_config_init begin@@@@@@@@@@@@@\n");

#ifdef CONFIG_RTK8306E_PHY
	realtek_phydev = phydev;
	err = rtl8306e_config_init();
#endif

	printk("@@@@@@@@@@@@rtl8306x_config_init end@@@@@@@@@@@@@\n");

	return err;
}

typedef enum
{
	eLINK_OFF = 0,
	eLINK_ON,
	eLINK_END
} E_LINK_STATE;
static E_LINK_STATE rtk8306x_port_state[5]= {0};
extern void gmac_event_notify(GMAC_NOTIFY_EVENT notify_type, void* puf);
extern int32 rtl8306e_port_phyLinkStatus_get(uint32 phy, uint32 *plinkUp); 
static int rtl8306x_private_proc(struct phy_device *phydev)
{
	int err = 0;
	int i = 0;
	int islink = 0;
	int org_lan_status = 0;
	int org_wan_status = 0;
	int new_lan_status = 0;
	int new_wan_status = 0;

	for(i=0; i<4; i++) {
		if(rtk8306x_port_state[i] == 1)
			org_lan_status = 1; 

		rtl8306e_port_phyLinkStatus_get(i,&islink);
		rtk8306x_port_state[i] = islink;
		if(islink == 1)
			new_lan_status = 1;
	}

	org_wan_status = rtk8306x_port_state[4];
	rtl8306e_port_phyLinkStatus_get(i,&islink);
	rtk8306x_port_state[4] = islink;
	if(islink == 1)
		new_wan_status = 1;

	if((org_lan_status == 0)&&(new_lan_status == 1))
		gmac_event_notify(GMAC_ETH_SW_LAN_PLUGIN, NULL);

	if((org_lan_status == 1)&&(new_lan_status == 0))
		gmac_event_notify(GMAC_ETH_SW_LAN_PLUGOUT, NULL);

	if((org_wan_status == 0)&&(new_wan_status == 1))
		gmac_event_notify(GMAC_ETH_SW_WAN_PLUGIN, NULL);

	if((org_wan_status == 1)&&(new_wan_status == 0))
		gmac_event_notify(GMAC_ETH_SW_WAN_PLUGOUT, NULL);

#if 0
	for(i=0; i<5; i++) {
		rtl8306e_port_phyLinkStatus_get(i,&islink);
		if(rtk8306x_port_state[i] != islink) {
			rtk8306x_port_state[i] = islink;
			if(i == 4) {
				if(islink == 1)
					gmac_event_notify(GMAC_ETH_SW_WAN_PLUGIN, NULL);
				else
					gmac_event_notify(GMAC_ETH_SW_WAN_PLUGOUT, NULL);
			} else {
				if(islink == 1)
					gmac_event_notify(GMAC_ETH_SW_LAN_PLUGIN, NULL);
				else
					gmac_event_notify(GMAC_ETH_SW_LAN_PLUGOUT, NULL);
			}
		}
	}
#endif
	return err;
}


/* RTL8211B */
static struct phy_driver rtl821x_driver = {
	.phy_id		= 0x001cc912,
	.name		= "RTL821x Gigabit Ethernet",
	.phy_id_mask	= 0x001fffff,
	.features	= PHY_GBIT_FEATURES,
	.flags		= PHY_HAS_INTERRUPT,
	.config_aneg	= &genphy_config_aneg,
	.read_status	= &genphy_read_status,
	.ack_interrupt	= &rtl821x_ack_interrupt,
	.config_intr	= &rtl821x_config_intr,
	.driver		= { .owner = THIS_MODULE,},
};

/* RTL8306E */
static struct phy_driver rtl8306x_driver = {
	.phy_id		= 0x001cc852,
	.name		= "RTL8306x Ethernet",
	.phy_id_mask	= 0x0fffffe0,
	.features	= PHY_BASIC_FEATURES,
	.config_aneg	= &genphy_config_aneg,
	.read_status	= &genphy_read_status,
	.config_init	= &rtl8306x_config_init,
	.private_proc	= &rtl8306x_private_proc,
	.suspend	= genphy_suspend,
	.resume		= genphy_resume,
	.driver		= { .owner = THIS_MODULE,},
};


static int __init realtek_init(void)
{
	int ret;

	ret = phy_driver_register(&rtl821x_driver);
	if (ret < 0)
		return -ENODEV;

	ret = phy_driver_register(&rtl8306x_driver);

	return ret;
}

static void __exit realtek_exit(void)
{
	phy_driver_unregister(&rtl821x_driver);
	phy_driver_unregister(&rtl8306x_driver);
}

module_init(realtek_init);
module_exit(realtek_exit);

static struct mdio_device_id __maybe_unused realtek_tbl[] = {
	{ 0x001cc912, 0x001fffff },
	{ 0x001cc852, 0x0fffffe0 },
	{ }
};

MODULE_DEVICE_TABLE(mdio, realtek_tbl);
