#include <linux/version.h>
#include <linux/module.h>
#include <linux/vmalloc.h>
#include <linux/platform_device.h>
#include <linux/pm_runtime.h>
#include <linux/regulator/consumer.h>

#include <asm/io.h>

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 0, 0))
#include <linux/printk.h>
#include <linux/err.h>
#else
#include <config/printk.h>
#endif


extern int ssvdevice_init(void);
extern void ssvdevice_exit(void);

extern int  wifi_dev_init(void);
extern void  wifi_dev_exit(void);

//extern int ssv_prealloc_init(void);
//extern void  ssv_prealloc_exit(void);

//extern void ssv6x5x_wifi_enable(int bval);
extern void aic8800_wifi_enable(int bval);
extern void aic8800_wifi_disable(int bval);
extern int aicwf_prealloc_init(void);
extern void aicwf_prealloc_exit(void);
int initWlan(void)
{
    int ret=0;
    printk(KERN_ERR "qqq wlan.c initWlan@@@\n");
	aic8800_wifi_enable(1);
	aic8800_wifi_disable(1);
    ret = aicwf_prealloc_init();
    if (ret)
        return ret;
    //ssv6x5x_wifi_enable(1);
    //ret = ssv_prealloc_init();
    // if (ret) 
	//return ret;
	 
    ret = wifi_dev_init();
    return ret;
	
}

void exitWlan(void)
{
    //ssvdevice_exit();
    wifi_dev_exit();
	aicwf_prealloc_exit();
    //ssv_prealloc_exit();
    return;
}

static int generic_wifi_init_module(void)
{
	return initWlan();
}

static void generic_wifi_exit_module(void)
{
	exitWlan();
}

EXPORT_SYMBOL(generic_wifi_init_module);
EXPORT_SYMBOL(generic_wifi_exit_module);

//#ifdef CONFIG_SSV6X5X //CONFIG_SSV6XXX=y
module_init(generic_wifi_init_module);
//late_initcall(generic_wifi_init_module);
//#else //CONFIG_SSV6XXX=m or =n
//module_init(generic_wifi_init_module);
//#endif
module_exit(generic_wifi_exit_module);

MODULE_LICENSE("Dual BSD/GPL");
